/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeRegionNetworkEndpointGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource. Provide this property when
    * you create the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group#description GoogleComputeRegionNetworkEndpointGroup#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group#id GoogleComputeRegionNetworkEndpointGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource; provided by the client when the resource is
    * created. The name must be 1-63 characters long, and comply with
    * RFC1035. Specifically, the name must be 1-63 characters long and match
    * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
    * first character must be a lowercase letter, and all following
    * characters must be a dash, lowercase letter, or digit, except the last
    * character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group#name GoogleComputeRegionNetworkEndpointGroup#name}
    */
    readonly name: string;
    /**
    * This field is only used for PSC and INTERNET NEGs.
    *
    * The URL of the network to which all network endpoints in the NEG belong. Uses
    * "default" project network if unspecified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group#network GoogleComputeRegionNetworkEndpointGroup#network}
    */
    readonly network?: string;
    /**
    * Type of network endpoints in this network endpoint group. Defaults to SERVERLESS. Default value: "SERVERLESS" Possible values: ["SERVERLESS", "PRIVATE_SERVICE_CONNECT", "INTERNET_IP_PORT", "INTERNET_FQDN_PORT"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group#network_endpoint_type GoogleComputeRegionNetworkEndpointGroup#network_endpoint_type}
    */
    readonly networkEndpointType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group#project GoogleComputeRegionNetworkEndpointGroup#project}
    */
    readonly project?: string;
    /**
    * This field is only used for PSC and INTERNET NEGs.
    *
    * The target service url used to set up private service connection to
    * a Google API or a PSC Producer Service Attachment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group#psc_target_service GoogleComputeRegionNetworkEndpointGroup#psc_target_service}
    */
    readonly pscTargetService?: string;
    /**
    * A reference to the region where the regional NEGs reside.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group#region GoogleComputeRegionNetworkEndpointGroup#region}
    */
    readonly region: string;
    /**
    * This field is only used for PSC NEGs.
    *
    * Optional URL of the subnetwork to which all network endpoints in the NEG belong.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group#subnetwork GoogleComputeRegionNetworkEndpointGroup#subnetwork}
    */
    readonly subnetwork?: string;
    /**
    * app_engine block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group#app_engine GoogleComputeRegionNetworkEndpointGroup#app_engine}
    */
    readonly appEngine?: GoogleComputeRegionNetworkEndpointGroupAppEngine;
    /**
    * cloud_function block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group#cloud_function GoogleComputeRegionNetworkEndpointGroup#cloud_function}
    */
    readonly cloudFunction?: GoogleComputeRegionNetworkEndpointGroupCloudFunction;
    /**
    * cloud_run block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group#cloud_run GoogleComputeRegionNetworkEndpointGroup#cloud_run}
    */
    readonly cloudRun?: GoogleComputeRegionNetworkEndpointGroupCloudRun;
    /**
    * serverless_deployment block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group#serverless_deployment GoogleComputeRegionNetworkEndpointGroup#serverless_deployment}
    */
    readonly serverlessDeployment?: GoogleComputeRegionNetworkEndpointGroupServerlessDeployment;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group#timeouts GoogleComputeRegionNetworkEndpointGroup#timeouts}
    */
    readonly timeouts?: GoogleComputeRegionNetworkEndpointGroupTimeouts;
}
export interface GoogleComputeRegionNetworkEndpointGroupAppEngine {
    /**
    * Optional serving service.
    * The service name must be 1-63 characters long, and comply with RFC1035.
    * Example value: "default", "my-service".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group#service GoogleComputeRegionNetworkEndpointGroup#service}
    */
    readonly service?: string;
    /**
    * A template to parse service and version fields from a request URL.
    * URL mask allows for routing to multiple App Engine services without
    * having to create multiple Network Endpoint Groups and backend services.
    *
    * For example, the request URLs "foo1-dot-appname.appspot.com/v1" and
    * "foo1-dot-appname.appspot.com/v2" can be backed by the same Serverless NEG with
    * URL mask "-dot-appname.appspot.com/". The URL mask will parse
    * them to { service = "foo1", version = "v1" } and { service = "foo1", version = "v2" } respectively.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group#url_mask GoogleComputeRegionNetworkEndpointGroup#url_mask}
    */
    readonly urlMask?: string;
    /**
    * Optional serving version.
    * The version must be 1-63 characters long, and comply with RFC1035.
    * Example value: "v1", "v2".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group#version GoogleComputeRegionNetworkEndpointGroup#version}
    */
    readonly version?: string;
}
export declare function googleComputeRegionNetworkEndpointGroupAppEngineToTerraform(struct?: GoogleComputeRegionNetworkEndpointGroupAppEngineOutputReference | GoogleComputeRegionNetworkEndpointGroupAppEngine): any;
export declare function googleComputeRegionNetworkEndpointGroupAppEngineToHclTerraform(struct?: GoogleComputeRegionNetworkEndpointGroupAppEngineOutputReference | GoogleComputeRegionNetworkEndpointGroupAppEngine): any;
export declare class GoogleComputeRegionNetworkEndpointGroupAppEngineOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionNetworkEndpointGroupAppEngine | undefined;
    set internalValue(value: GoogleComputeRegionNetworkEndpointGroupAppEngine | undefined);
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
    private _urlMask?;
    get urlMask(): string;
    set urlMask(value: string);
    resetUrlMask(): void;
    get urlMaskInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export interface GoogleComputeRegionNetworkEndpointGroupCloudFunction {
    /**
    * A user-defined name of the Cloud Function.
    * The function name is case-sensitive and must be 1-63 characters long.
    * Example value: "func1".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group#function GoogleComputeRegionNetworkEndpointGroup#function}
    */
    readonly function?: string;
    /**
    * A template to parse function field from a request URL. URL mask allows
    * for routing to multiple Cloud Functions without having to create
    * multiple Network Endpoint Groups and backend services.
    *
    * For example, request URLs "mydomain.com/function1" and "mydomain.com/function2"
    * can be backed by the same Serverless NEG with URL mask "/". The URL mask
    * will parse them to { function = "function1" } and { function = "function2" } respectively.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group#url_mask GoogleComputeRegionNetworkEndpointGroup#url_mask}
    */
    readonly urlMask?: string;
}
export declare function googleComputeRegionNetworkEndpointGroupCloudFunctionToTerraform(struct?: GoogleComputeRegionNetworkEndpointGroupCloudFunctionOutputReference | GoogleComputeRegionNetworkEndpointGroupCloudFunction): any;
export declare function googleComputeRegionNetworkEndpointGroupCloudFunctionToHclTerraform(struct?: GoogleComputeRegionNetworkEndpointGroupCloudFunctionOutputReference | GoogleComputeRegionNetworkEndpointGroupCloudFunction): any;
export declare class GoogleComputeRegionNetworkEndpointGroupCloudFunctionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionNetworkEndpointGroupCloudFunction | undefined;
    set internalValue(value: GoogleComputeRegionNetworkEndpointGroupCloudFunction | undefined);
    private _function?;
    get function(): string;
    set function(value: string);
    resetFunction(): void;
    get functionInput(): string | undefined;
    private _urlMask?;
    get urlMask(): string;
    set urlMask(value: string);
    resetUrlMask(): void;
    get urlMaskInput(): string | undefined;
}
export interface GoogleComputeRegionNetworkEndpointGroupCloudRun {
    /**
    * Cloud Run service is the main resource of Cloud Run.
    * The service must be 1-63 characters long, and comply with RFC1035.
    * Example value: "run-service".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group#service GoogleComputeRegionNetworkEndpointGroup#service}
    */
    readonly service?: string;
    /**
    * Cloud Run tag represents the "named-revision" to provide
    * additional fine-grained traffic routing information.
    * The tag must be 1-63 characters long, and comply with RFC1035.
    * Example value: "revision-0010".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group#tag GoogleComputeRegionNetworkEndpointGroup#tag}
    */
    readonly tag?: string;
    /**
    * A template to parse service and tag fields from a request URL.
    * URL mask allows for routing to multiple Run services without having
    * to create multiple network endpoint groups and backend services.
    *
    * For example, request URLs "foo1.domain.com/bar1" and "foo1.domain.com/bar2"
    * an be backed by the same Serverless Network Endpoint Group (NEG) with
    * URL mask ".domain.com/". The URL mask will parse them to { service="bar1", tag="foo1" }
    * and { service="bar2", tag="foo2" } respectively.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group#url_mask GoogleComputeRegionNetworkEndpointGroup#url_mask}
    */
    readonly urlMask?: string;
}
export declare function googleComputeRegionNetworkEndpointGroupCloudRunToTerraform(struct?: GoogleComputeRegionNetworkEndpointGroupCloudRunOutputReference | GoogleComputeRegionNetworkEndpointGroupCloudRun): any;
export declare function googleComputeRegionNetworkEndpointGroupCloudRunToHclTerraform(struct?: GoogleComputeRegionNetworkEndpointGroupCloudRunOutputReference | GoogleComputeRegionNetworkEndpointGroupCloudRun): any;
export declare class GoogleComputeRegionNetworkEndpointGroupCloudRunOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionNetworkEndpointGroupCloudRun | undefined;
    set internalValue(value: GoogleComputeRegionNetworkEndpointGroupCloudRun | undefined);
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _urlMask?;
    get urlMask(): string;
    set urlMask(value: string);
    resetUrlMask(): void;
    get urlMaskInput(): string | undefined;
}
export interface GoogleComputeRegionNetworkEndpointGroupServerlessDeployment {
    /**
    * The platform of the NEG backend target(s). Possible values:
    * API Gateway: apigateway.googleapis.com
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group#platform GoogleComputeRegionNetworkEndpointGroup#platform}
    */
    readonly platform: string;
    /**
    * The user-defined name of the workload/instance. This value must be provided explicitly or in the urlMask.
    * The resource identified by this value is platform-specific and is as follows: API Gateway: The gateway ID, App Engine: The service name,
    * Cloud Functions: The function name, Cloud Run: The service name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group#resource GoogleComputeRegionNetworkEndpointGroup#resource}
    */
    readonly resource?: string;
    /**
    * A template to parse platform-specific fields from a request URL. URL mask allows for routing to multiple resources
    * on the same serverless platform without having to create multiple Network Endpoint Groups and backend resources.
    * The fields parsed by this template are platform-specific and are as follows: API Gateway: The gateway ID,
    * App Engine: The service and version, Cloud Functions: The function name, Cloud Run: The service and tag
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group#url_mask GoogleComputeRegionNetworkEndpointGroup#url_mask}
    */
    readonly urlMask?: string;
    /**
    * The optional resource version. The version identified by this value is platform-specific and is follows:
    * API Gateway: Unused, App Engine: The service version, Cloud Functions: Unused, Cloud Run: The service tag
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group#version GoogleComputeRegionNetworkEndpointGroup#version}
    */
    readonly version?: string;
}
export declare function googleComputeRegionNetworkEndpointGroupServerlessDeploymentToTerraform(struct?: GoogleComputeRegionNetworkEndpointGroupServerlessDeploymentOutputReference | GoogleComputeRegionNetworkEndpointGroupServerlessDeployment): any;
export declare function googleComputeRegionNetworkEndpointGroupServerlessDeploymentToHclTerraform(struct?: GoogleComputeRegionNetworkEndpointGroupServerlessDeploymentOutputReference | GoogleComputeRegionNetworkEndpointGroupServerlessDeployment): any;
export declare class GoogleComputeRegionNetworkEndpointGroupServerlessDeploymentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionNetworkEndpointGroupServerlessDeployment | undefined;
    set internalValue(value: GoogleComputeRegionNetworkEndpointGroupServerlessDeployment | undefined);
    private _platform?;
    get platform(): string;
    set platform(value: string);
    get platformInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    resetResource(): void;
    get resourceInput(): string | undefined;
    private _urlMask?;
    get urlMask(): string;
    set urlMask(value: string);
    resetUrlMask(): void;
    get urlMaskInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export interface GoogleComputeRegionNetworkEndpointGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group#create GoogleComputeRegionNetworkEndpointGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group#delete GoogleComputeRegionNetworkEndpointGroup#delete}
    */
    readonly delete?: string;
}
export declare function googleComputeRegionNetworkEndpointGroupTimeoutsToTerraform(struct?: GoogleComputeRegionNetworkEndpointGroupTimeouts | cdktf.IResolvable): any;
export declare function googleComputeRegionNetworkEndpointGroupTimeoutsToHclTerraform(struct?: GoogleComputeRegionNetworkEndpointGroupTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeRegionNetworkEndpointGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionNetworkEndpointGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionNetworkEndpointGroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group google_compute_region_network_endpoint_group}
*/
export declare class GoogleComputeRegionNetworkEndpointGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_region_network_endpoint_group";
    /**
    * Generates CDKTF code for importing a GoogleComputeRegionNetworkEndpointGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleComputeRegionNetworkEndpointGroup to import
    * @param importFromId The id of the existing GoogleComputeRegionNetworkEndpointGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleComputeRegionNetworkEndpointGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_endpoint_group google_compute_region_network_endpoint_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeRegionNetworkEndpointGroupConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeRegionNetworkEndpointGroupConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _networkEndpointType?;
    get networkEndpointType(): string;
    set networkEndpointType(value: string);
    resetNetworkEndpointType(): void;
    get networkEndpointTypeInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _pscTargetService?;
    get pscTargetService(): string;
    set pscTargetService(value: string);
    resetPscTargetService(): void;
    get pscTargetServiceInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    private _appEngine;
    get appEngine(): GoogleComputeRegionNetworkEndpointGroupAppEngineOutputReference;
    putAppEngine(value: GoogleComputeRegionNetworkEndpointGroupAppEngine): void;
    resetAppEngine(): void;
    get appEngineInput(): GoogleComputeRegionNetworkEndpointGroupAppEngine | undefined;
    private _cloudFunction;
    get cloudFunction(): GoogleComputeRegionNetworkEndpointGroupCloudFunctionOutputReference;
    putCloudFunction(value: GoogleComputeRegionNetworkEndpointGroupCloudFunction): void;
    resetCloudFunction(): void;
    get cloudFunctionInput(): GoogleComputeRegionNetworkEndpointGroupCloudFunction | undefined;
    private _cloudRun;
    get cloudRun(): GoogleComputeRegionNetworkEndpointGroupCloudRunOutputReference;
    putCloudRun(value: GoogleComputeRegionNetworkEndpointGroupCloudRun): void;
    resetCloudRun(): void;
    get cloudRunInput(): GoogleComputeRegionNetworkEndpointGroupCloudRun | undefined;
    private _serverlessDeployment;
    get serverlessDeployment(): GoogleComputeRegionNetworkEndpointGroupServerlessDeploymentOutputReference;
    putServerlessDeployment(value: GoogleComputeRegionNetworkEndpointGroupServerlessDeployment): void;
    resetServerlessDeployment(): void;
    get serverlessDeploymentInput(): GoogleComputeRegionNetworkEndpointGroupServerlessDeployment | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeRegionNetworkEndpointGroupTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeRegionNetworkEndpointGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeRegionNetworkEndpointGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
