/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeRegionNetworkFirewallPolicyRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Action to perform when the client connection triggers the rule. Valid actions are "allow", "deny" and "goto_next".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#action GoogleComputeRegionNetworkFirewallPolicyRule#action}
    */
    readonly action: string;
    /**
    * An optional description for this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#description GoogleComputeRegionNetworkFirewallPolicyRule#description}
    */
    readonly description?: string;
    /**
    * The direction in which this rule applies. Possible values: INGRESS, EGRESS
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#direction GoogleComputeRegionNetworkFirewallPolicyRule#direction}
    */
    readonly direction: string;
    /**
    * Denotes whether the firewall policy rule is disabled. When set to true, the firewall policy rule is not enforced and traffic behaves as if it did not exist. If this is unspecified, the firewall policy rule will be enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#disabled GoogleComputeRegionNetworkFirewallPolicyRule#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * Denotes whether to enable logging for a particular rule. If logging is enabled, logs will be exported to the configured export destination in Stackdriver. Logs may be exported to BigQuery or Pub/Sub. Note: you cannot enable logging on "goto_next" rules.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#enable_logging GoogleComputeRegionNetworkFirewallPolicyRule#enable_logging}
    */
    readonly enableLogging?: boolean | cdktf.IResolvable;
    /**
    * The firewall policy of the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#firewall_policy GoogleComputeRegionNetworkFirewallPolicyRule#firewall_policy}
    */
    readonly firewallPolicy: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#id GoogleComputeRegionNetworkFirewallPolicyRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest prority.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#priority GoogleComputeRegionNetworkFirewallPolicyRule#priority}
    */
    readonly priority: number;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#project GoogleComputeRegionNetworkFirewallPolicyRule#project}
    */
    readonly project?: string;
    /**
    * The location of this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#region GoogleComputeRegionNetworkFirewallPolicyRule#region}
    */
    readonly region?: string;
    /**
    * An optional name for the rule. This field is not a unique identifier and can be updated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#rule_name GoogleComputeRegionNetworkFirewallPolicyRule#rule_name}
    */
    readonly ruleName?: string;
    /**
    * A list of service accounts indicating the sets of instances that are applied with this rule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#target_service_accounts GoogleComputeRegionNetworkFirewallPolicyRule#target_service_accounts}
    */
    readonly targetServiceAccounts?: string[];
    /**
    * match block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#match GoogleComputeRegionNetworkFirewallPolicyRule#match}
    */
    readonly match: GoogleComputeRegionNetworkFirewallPolicyRuleMatch;
    /**
    * target_secure_tags block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#target_secure_tags GoogleComputeRegionNetworkFirewallPolicyRule#target_secure_tags}
    */
    readonly targetSecureTags?: GoogleComputeRegionNetworkFirewallPolicyRuleTargetSecureTags[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#timeouts GoogleComputeRegionNetworkFirewallPolicyRule#timeouts}
    */
    readonly timeouts?: GoogleComputeRegionNetworkFirewallPolicyRuleTimeouts;
}
export interface GoogleComputeRegionNetworkFirewallPolicyRuleMatchLayer4Configs {
    /**
    * The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (`tcp`, `udp`, `icmp`, `esp`, `ah`, `ipip`, `sctp`), or the IP protocol number.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#ip_protocol GoogleComputeRegionNetworkFirewallPolicyRule#ip_protocol}
    */
    readonly ipProtocol: string;
    /**
    * An optional list of ports to which this rule applies. This field is only applicable for UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: ``.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#ports GoogleComputeRegionNetworkFirewallPolicyRule#ports}
    */
    readonly ports?: string[];
}
export declare function googleComputeRegionNetworkFirewallPolicyRuleMatchLayer4ConfigsToTerraform(struct?: GoogleComputeRegionNetworkFirewallPolicyRuleMatchLayer4Configs | cdktf.IResolvable): any;
export declare function googleComputeRegionNetworkFirewallPolicyRuleMatchLayer4ConfigsToHclTerraform(struct?: GoogleComputeRegionNetworkFirewallPolicyRuleMatchLayer4Configs | cdktf.IResolvable): any;
export declare class GoogleComputeRegionNetworkFirewallPolicyRuleMatchLayer4ConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionNetworkFirewallPolicyRuleMatchLayer4Configs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionNetworkFirewallPolicyRuleMatchLayer4Configs | cdktf.IResolvable | undefined);
    private _ipProtocol?;
    get ipProtocol(): string;
    set ipProtocol(value: string);
    get ipProtocolInput(): string | undefined;
    private _ports?;
    get ports(): string[];
    set ports(value: string[]);
    resetPorts(): void;
    get portsInput(): string[] | undefined;
}
export declare class GoogleComputeRegionNetworkFirewallPolicyRuleMatchLayer4ConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionNetworkFirewallPolicyRuleMatchLayer4Configs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionNetworkFirewallPolicyRuleMatchLayer4ConfigsOutputReference;
}
export interface GoogleComputeRegionNetworkFirewallPolicyRuleMatchSrcSecureTags {
    /**
    * Name of the secure tag, created with TagManager's TagValue API. @pattern tagValues/[0-9]+
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#name GoogleComputeRegionNetworkFirewallPolicyRule#name}
    */
    readonly name: string;
}
export declare function googleComputeRegionNetworkFirewallPolicyRuleMatchSrcSecureTagsToTerraform(struct?: GoogleComputeRegionNetworkFirewallPolicyRuleMatchSrcSecureTags | cdktf.IResolvable): any;
export declare function googleComputeRegionNetworkFirewallPolicyRuleMatchSrcSecureTagsToHclTerraform(struct?: GoogleComputeRegionNetworkFirewallPolicyRuleMatchSrcSecureTags | cdktf.IResolvable): any;
export declare class GoogleComputeRegionNetworkFirewallPolicyRuleMatchSrcSecureTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionNetworkFirewallPolicyRuleMatchSrcSecureTags | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionNetworkFirewallPolicyRuleMatchSrcSecureTags | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get state(): string;
}
export declare class GoogleComputeRegionNetworkFirewallPolicyRuleMatchSrcSecureTagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionNetworkFirewallPolicyRuleMatchSrcSecureTags[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionNetworkFirewallPolicyRuleMatchSrcSecureTagsOutputReference;
}
export interface GoogleComputeRegionNetworkFirewallPolicyRuleMatch {
    /**
    * Address groups which should be matched against the traffic destination. Maximum number of destination address groups is 10. Destination address groups is only supported in Egress rules.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#dest_address_groups GoogleComputeRegionNetworkFirewallPolicyRule#dest_address_groups}
    */
    readonly destAddressGroups?: string[];
    /**
    * Domain names that will be used to match against the resolved domain name of destination of traffic. Can only be specified if DIRECTION is egress.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#dest_fqdns GoogleComputeRegionNetworkFirewallPolicyRule#dest_fqdns}
    */
    readonly destFqdns?: string[];
    /**
    * CIDR IP address range. Maximum number of destination CIDR IP ranges allowed is 5000.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#dest_ip_ranges GoogleComputeRegionNetworkFirewallPolicyRule#dest_ip_ranges}
    */
    readonly destIpRanges?: string[];
    /**
    * The Unicode country codes whose IP addresses will be used to match against the source of traffic. Can only be specified if DIRECTION is egress.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#dest_region_codes GoogleComputeRegionNetworkFirewallPolicyRule#dest_region_codes}
    */
    readonly destRegionCodes?: string[];
    /**
    * Name of the Google Cloud Threat Intelligence list.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#dest_threat_intelligences GoogleComputeRegionNetworkFirewallPolicyRule#dest_threat_intelligences}
    */
    readonly destThreatIntelligences?: string[];
    /**
    * Address groups which should be matched against the traffic source. Maximum number of source address groups is 10. Source address groups is only supported in Ingress rules.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#src_address_groups GoogleComputeRegionNetworkFirewallPolicyRule#src_address_groups}
    */
    readonly srcAddressGroups?: string[];
    /**
    * Domain names that will be used to match against the resolved domain name of source of traffic. Can only be specified if DIRECTION is ingress.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#src_fqdns GoogleComputeRegionNetworkFirewallPolicyRule#src_fqdns}
    */
    readonly srcFqdns?: string[];
    /**
    * CIDR IP address range. Maximum number of source CIDR IP ranges allowed is 5000.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#src_ip_ranges GoogleComputeRegionNetworkFirewallPolicyRule#src_ip_ranges}
    */
    readonly srcIpRanges?: string[];
    /**
    * The Unicode country codes whose IP addresses will be used to match against the source of traffic. Can only be specified if DIRECTION is ingress.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#src_region_codes GoogleComputeRegionNetworkFirewallPolicyRule#src_region_codes}
    */
    readonly srcRegionCodes?: string[];
    /**
    * Name of the Google Cloud Threat Intelligence list.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#src_threat_intelligences GoogleComputeRegionNetworkFirewallPolicyRule#src_threat_intelligences}
    */
    readonly srcThreatIntelligences?: string[];
    /**
    * layer4_configs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#layer4_configs GoogleComputeRegionNetworkFirewallPolicyRule#layer4_configs}
    */
    readonly layer4Configs: GoogleComputeRegionNetworkFirewallPolicyRuleMatchLayer4Configs[] | cdktf.IResolvable;
    /**
    * src_secure_tags block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#src_secure_tags GoogleComputeRegionNetworkFirewallPolicyRule#src_secure_tags}
    */
    readonly srcSecureTags?: GoogleComputeRegionNetworkFirewallPolicyRuleMatchSrcSecureTags[] | cdktf.IResolvable;
}
export declare function googleComputeRegionNetworkFirewallPolicyRuleMatchToTerraform(struct?: GoogleComputeRegionNetworkFirewallPolicyRuleMatchOutputReference | GoogleComputeRegionNetworkFirewallPolicyRuleMatch): any;
export declare function googleComputeRegionNetworkFirewallPolicyRuleMatchToHclTerraform(struct?: GoogleComputeRegionNetworkFirewallPolicyRuleMatchOutputReference | GoogleComputeRegionNetworkFirewallPolicyRuleMatch): any;
export declare class GoogleComputeRegionNetworkFirewallPolicyRuleMatchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionNetworkFirewallPolicyRuleMatch | undefined;
    set internalValue(value: GoogleComputeRegionNetworkFirewallPolicyRuleMatch | undefined);
    private _destAddressGroups?;
    get destAddressGroups(): string[];
    set destAddressGroups(value: string[]);
    resetDestAddressGroups(): void;
    get destAddressGroupsInput(): string[] | undefined;
    private _destFqdns?;
    get destFqdns(): string[];
    set destFqdns(value: string[]);
    resetDestFqdns(): void;
    get destFqdnsInput(): string[] | undefined;
    private _destIpRanges?;
    get destIpRanges(): string[];
    set destIpRanges(value: string[]);
    resetDestIpRanges(): void;
    get destIpRangesInput(): string[] | undefined;
    private _destRegionCodes?;
    get destRegionCodes(): string[];
    set destRegionCodes(value: string[]);
    resetDestRegionCodes(): void;
    get destRegionCodesInput(): string[] | undefined;
    private _destThreatIntelligences?;
    get destThreatIntelligences(): string[];
    set destThreatIntelligences(value: string[]);
    resetDestThreatIntelligences(): void;
    get destThreatIntelligencesInput(): string[] | undefined;
    private _srcAddressGroups?;
    get srcAddressGroups(): string[];
    set srcAddressGroups(value: string[]);
    resetSrcAddressGroups(): void;
    get srcAddressGroupsInput(): string[] | undefined;
    private _srcFqdns?;
    get srcFqdns(): string[];
    set srcFqdns(value: string[]);
    resetSrcFqdns(): void;
    get srcFqdnsInput(): string[] | undefined;
    private _srcIpRanges?;
    get srcIpRanges(): string[];
    set srcIpRanges(value: string[]);
    resetSrcIpRanges(): void;
    get srcIpRangesInput(): string[] | undefined;
    private _srcRegionCodes?;
    get srcRegionCodes(): string[];
    set srcRegionCodes(value: string[]);
    resetSrcRegionCodes(): void;
    get srcRegionCodesInput(): string[] | undefined;
    private _srcThreatIntelligences?;
    get srcThreatIntelligences(): string[];
    set srcThreatIntelligences(value: string[]);
    resetSrcThreatIntelligences(): void;
    get srcThreatIntelligencesInput(): string[] | undefined;
    private _layer4Configs;
    get layer4Configs(): GoogleComputeRegionNetworkFirewallPolicyRuleMatchLayer4ConfigsList;
    putLayer4Configs(value: GoogleComputeRegionNetworkFirewallPolicyRuleMatchLayer4Configs[] | cdktf.IResolvable): void;
    get layer4ConfigsInput(): cdktf.IResolvable | GoogleComputeRegionNetworkFirewallPolicyRuleMatchLayer4Configs[] | undefined;
    private _srcSecureTags;
    get srcSecureTags(): GoogleComputeRegionNetworkFirewallPolicyRuleMatchSrcSecureTagsList;
    putSrcSecureTags(value: GoogleComputeRegionNetworkFirewallPolicyRuleMatchSrcSecureTags[] | cdktf.IResolvable): void;
    resetSrcSecureTags(): void;
    get srcSecureTagsInput(): cdktf.IResolvable | GoogleComputeRegionNetworkFirewallPolicyRuleMatchSrcSecureTags[] | undefined;
}
export interface GoogleComputeRegionNetworkFirewallPolicyRuleTargetSecureTags {
    /**
    * Name of the secure tag, created with TagManager's TagValue API. @pattern tagValues/[0-9]+
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#name GoogleComputeRegionNetworkFirewallPolicyRule#name}
    */
    readonly name: string;
}
export declare function googleComputeRegionNetworkFirewallPolicyRuleTargetSecureTagsToTerraform(struct?: GoogleComputeRegionNetworkFirewallPolicyRuleTargetSecureTags | cdktf.IResolvable): any;
export declare function googleComputeRegionNetworkFirewallPolicyRuleTargetSecureTagsToHclTerraform(struct?: GoogleComputeRegionNetworkFirewallPolicyRuleTargetSecureTags | cdktf.IResolvable): any;
export declare class GoogleComputeRegionNetworkFirewallPolicyRuleTargetSecureTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionNetworkFirewallPolicyRuleTargetSecureTags | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionNetworkFirewallPolicyRuleTargetSecureTags | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get state(): string;
}
export declare class GoogleComputeRegionNetworkFirewallPolicyRuleTargetSecureTagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionNetworkFirewallPolicyRuleTargetSecureTags[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionNetworkFirewallPolicyRuleTargetSecureTagsOutputReference;
}
export interface GoogleComputeRegionNetworkFirewallPolicyRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#create GoogleComputeRegionNetworkFirewallPolicyRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#delete GoogleComputeRegionNetworkFirewallPolicyRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#update GoogleComputeRegionNetworkFirewallPolicyRule#update}
    */
    readonly update?: string;
}
export declare function googleComputeRegionNetworkFirewallPolicyRuleTimeoutsToTerraform(struct?: GoogleComputeRegionNetworkFirewallPolicyRuleTimeouts | cdktf.IResolvable): any;
export declare function googleComputeRegionNetworkFirewallPolicyRuleTimeoutsToHclTerraform(struct?: GoogleComputeRegionNetworkFirewallPolicyRuleTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeRegionNetworkFirewallPolicyRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionNetworkFirewallPolicyRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionNetworkFirewallPolicyRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule google_compute_region_network_firewall_policy_rule}
*/
export declare class GoogleComputeRegionNetworkFirewallPolicyRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_region_network_firewall_policy_rule";
    /**
    * Generates CDKTF code for importing a GoogleComputeRegionNetworkFirewallPolicyRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleComputeRegionNetworkFirewallPolicyRule to import
    * @param importFromId The id of the existing GoogleComputeRegionNetworkFirewallPolicyRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleComputeRegionNetworkFirewallPolicyRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_network_firewall_policy_rule google_compute_region_network_firewall_policy_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeRegionNetworkFirewallPolicyRuleConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeRegionNetworkFirewallPolicyRuleConfig);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _direction?;
    get direction(): string;
    set direction(value: string);
    get directionInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _enableLogging?;
    get enableLogging(): boolean | cdktf.IResolvable;
    set enableLogging(value: boolean | cdktf.IResolvable);
    resetEnableLogging(): void;
    get enableLoggingInput(): boolean | cdktf.IResolvable | undefined;
    private _firewallPolicy?;
    get firewallPolicy(): string;
    set firewallPolicy(value: string);
    get firewallPolicyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get kind(): string;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _ruleName?;
    get ruleName(): string;
    set ruleName(value: string);
    resetRuleName(): void;
    get ruleNameInput(): string | undefined;
    get ruleTupleCount(): number;
    private _targetServiceAccounts?;
    get targetServiceAccounts(): string[];
    set targetServiceAccounts(value: string[]);
    resetTargetServiceAccounts(): void;
    get targetServiceAccountsInput(): string[] | undefined;
    private _match;
    get match(): GoogleComputeRegionNetworkFirewallPolicyRuleMatchOutputReference;
    putMatch(value: GoogleComputeRegionNetworkFirewallPolicyRuleMatch): void;
    get matchInput(): GoogleComputeRegionNetworkFirewallPolicyRuleMatch | undefined;
    private _targetSecureTags;
    get targetSecureTags(): GoogleComputeRegionNetworkFirewallPolicyRuleTargetSecureTagsList;
    putTargetSecureTags(value: GoogleComputeRegionNetworkFirewallPolicyRuleTargetSecureTags[] | cdktf.IResolvable): void;
    resetTargetSecureTags(): void;
    get targetSecureTagsInput(): cdktf.IResolvable | GoogleComputeRegionNetworkFirewallPolicyRuleTargetSecureTags[] | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeRegionNetworkFirewallPolicyRuleTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeRegionNetworkFirewallPolicyRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeRegionNetworkFirewallPolicyRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
