/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeRegionSecurityPolicyRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Action to perform when the rule is matched. The following are the valid actions:
    *
    * * allow: allow access to target.
    *
    * * deny(STATUS): deny access to target, returns the HTTP response code specified. Valid values for STATUS are 403, 404, and 502.
    *
    * * rate_based_ban: limit client traffic to the configured threshold and ban the client if the traffic exceeds the threshold. Configure parameters for this action in RateLimitOptions. Requires rateLimitOptions to be set.
    *
    * * redirect: redirect to a different target. This can either be an internal reCAPTCHA redirect, or an external URL-based redirect via a 302 response. Parameters for this action can be configured via redirectOptions. This action is only supported in Global Security Policies of type CLOUD_ARMOR.
    *
    * * throttle: limit client traffic to the configured threshold. Configure parameters for this action in rateLimitOptions. Requires rateLimitOptions to be set for this.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy_rule#action GoogleComputeRegionSecurityPolicyRule#action}
    */
    readonly action: string;
    /**
    * An optional description of this resource. Provide this property when you create the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy_rule#description GoogleComputeRegionSecurityPolicyRule#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy_rule#id GoogleComputeRegionSecurityPolicyRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * If set to true, the specified action is not enforced.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy_rule#preview GoogleComputeRegionSecurityPolicyRule#preview}
    */
    readonly preview?: boolean | cdktf.IResolvable;
    /**
    * An integer indicating the priority of a rule in the list.
    * The priority must be a positive value between 0 and 2147483647.
    * Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy_rule#priority GoogleComputeRegionSecurityPolicyRule#priority}
    */
    readonly priority: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy_rule#project GoogleComputeRegionSecurityPolicyRule#project}
    */
    readonly project?: string;
    /**
    * The Region in which the created Region Security Policy rule should reside.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy_rule#region GoogleComputeRegionSecurityPolicyRule#region}
    */
    readonly region: string;
    /**
    * The name of the security policy this rule belongs to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy_rule#security_policy GoogleComputeRegionSecurityPolicyRule#security_policy}
    */
    readonly securityPolicy: string;
    /**
    * match block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy_rule#match GoogleComputeRegionSecurityPolicyRule#match}
    */
    readonly match?: GoogleComputeRegionSecurityPolicyRuleMatch;
    /**
    * network_match block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy_rule#network_match GoogleComputeRegionSecurityPolicyRule#network_match}
    */
    readonly networkMatch?: GoogleComputeRegionSecurityPolicyRuleNetworkMatch;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy_rule#timeouts GoogleComputeRegionSecurityPolicyRule#timeouts}
    */
    readonly timeouts?: GoogleComputeRegionSecurityPolicyRuleTimeouts;
}
export interface GoogleComputeRegionSecurityPolicyRuleMatchConfig {
    /**
    * CIDR IP address range. Maximum number of srcIpRanges allowed is 10.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy_rule#src_ip_ranges GoogleComputeRegionSecurityPolicyRule#src_ip_ranges}
    */
    readonly srcIpRanges?: string[];
}
export declare function googleComputeRegionSecurityPolicyRuleMatchConfigToTerraform(struct?: GoogleComputeRegionSecurityPolicyRuleMatchConfigOutputReference | GoogleComputeRegionSecurityPolicyRuleMatchConfig): any;
export declare function googleComputeRegionSecurityPolicyRuleMatchConfigToHclTerraform(struct?: GoogleComputeRegionSecurityPolicyRuleMatchConfigOutputReference | GoogleComputeRegionSecurityPolicyRuleMatchConfig): any;
export declare class GoogleComputeRegionSecurityPolicyRuleMatchConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionSecurityPolicyRuleMatchConfig | undefined;
    set internalValue(value: GoogleComputeRegionSecurityPolicyRuleMatchConfig | undefined);
    private _srcIpRanges?;
    get srcIpRanges(): string[];
    set srcIpRanges(value: string[]);
    resetSrcIpRanges(): void;
    get srcIpRangesInput(): string[] | undefined;
}
export interface GoogleComputeRegionSecurityPolicyRuleMatch {
    /**
    * Preconfigured versioned expression. If this field is specified, config must also be specified.
    * Available preconfigured expressions along with their requirements are: SRC_IPS_V1 - must specify the corresponding srcIpRange field in config. Possible values: ["SRC_IPS_V1"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy_rule#versioned_expr GoogleComputeRegionSecurityPolicyRule#versioned_expr}
    */
    readonly versionedExpr?: string;
    /**
    * config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy_rule#config GoogleComputeRegionSecurityPolicyRule#config}
    */
    readonly config?: GoogleComputeRegionSecurityPolicyRuleMatchConfig;
}
export declare function googleComputeRegionSecurityPolicyRuleMatchToTerraform(struct?: GoogleComputeRegionSecurityPolicyRuleMatchOutputReference | GoogleComputeRegionSecurityPolicyRuleMatch): any;
export declare function googleComputeRegionSecurityPolicyRuleMatchToHclTerraform(struct?: GoogleComputeRegionSecurityPolicyRuleMatchOutputReference | GoogleComputeRegionSecurityPolicyRuleMatch): any;
export declare class GoogleComputeRegionSecurityPolicyRuleMatchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionSecurityPolicyRuleMatch | undefined;
    set internalValue(value: GoogleComputeRegionSecurityPolicyRuleMatch | undefined);
    private _versionedExpr?;
    get versionedExpr(): string;
    set versionedExpr(value: string);
    resetVersionedExpr(): void;
    get versionedExprInput(): string | undefined;
    private _config;
    get config(): GoogleComputeRegionSecurityPolicyRuleMatchConfigOutputReference;
    putConfig(value: GoogleComputeRegionSecurityPolicyRuleMatchConfig): void;
    resetConfig(): void;
    get configInput(): GoogleComputeRegionSecurityPolicyRuleMatchConfig | undefined;
}
export interface GoogleComputeRegionSecurityPolicyRuleNetworkMatchUserDefinedFields {
    /**
    * Name of the user-defined field, as given in the definition.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy_rule#name GoogleComputeRegionSecurityPolicyRule#name}
    */
    readonly name?: string;
    /**
    * Matching values of the field. Each element can be a 32-bit unsigned decimal or hexadecimal (starting with "0x") number (e.g. "64") or range (e.g. "0x400-0x7ff").
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy_rule#values GoogleComputeRegionSecurityPolicyRule#values}
    */
    readonly values?: string[];
}
export declare function googleComputeRegionSecurityPolicyRuleNetworkMatchUserDefinedFieldsToTerraform(struct?: GoogleComputeRegionSecurityPolicyRuleNetworkMatchUserDefinedFields | cdktf.IResolvable): any;
export declare function googleComputeRegionSecurityPolicyRuleNetworkMatchUserDefinedFieldsToHclTerraform(struct?: GoogleComputeRegionSecurityPolicyRuleNetworkMatchUserDefinedFields | cdktf.IResolvable): any;
export declare class GoogleComputeRegionSecurityPolicyRuleNetworkMatchUserDefinedFieldsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionSecurityPolicyRuleNetworkMatchUserDefinedFields | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionSecurityPolicyRuleNetworkMatchUserDefinedFields | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class GoogleComputeRegionSecurityPolicyRuleNetworkMatchUserDefinedFieldsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionSecurityPolicyRuleNetworkMatchUserDefinedFields[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionSecurityPolicyRuleNetworkMatchUserDefinedFieldsOutputReference;
}
export interface GoogleComputeRegionSecurityPolicyRuleNetworkMatch {
    /**
    * Destination IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy_rule#dest_ip_ranges GoogleComputeRegionSecurityPolicyRule#dest_ip_ranges}
    */
    readonly destIpRanges?: string[];
    /**
    * Destination port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number (e.g. "80") or range (e.g. "0-1023").
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy_rule#dest_ports GoogleComputeRegionSecurityPolicyRule#dest_ports}
    */
    readonly destPorts?: string[];
    /**
    * IPv4 protocol / IPv6 next header (after extension headers). Each element can be an 8-bit unsigned decimal number (e.g. "6"), range (e.g. "253-254"), or one of the following protocol names: "tcp", "udp", "icmp", "esp", "ah", "ipip", or "sctp".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy_rule#ip_protocols GoogleComputeRegionSecurityPolicyRule#ip_protocols}
    */
    readonly ipProtocols?: string[];
    /**
    * BGP Autonomous System Number associated with the source IP address.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy_rule#src_asns GoogleComputeRegionSecurityPolicyRule#src_asns}
    */
    readonly srcAsns?: number[];
    /**
    * Source IPv4/IPv6 addresses or CIDR prefixes, in standard text format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy_rule#src_ip_ranges GoogleComputeRegionSecurityPolicyRule#src_ip_ranges}
    */
    readonly srcIpRanges?: string[];
    /**
    * Source port numbers for TCP/UDP/SCTP. Each element can be a 16-bit unsigned decimal number (e.g. "80") or range (e.g. "0-1023").
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy_rule#src_ports GoogleComputeRegionSecurityPolicyRule#src_ports}
    */
    readonly srcPorts?: string[];
    /**
    * Two-letter ISO 3166-1 alpha-2 country code associated with the source IP address.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy_rule#src_region_codes GoogleComputeRegionSecurityPolicyRule#src_region_codes}
    */
    readonly srcRegionCodes?: string[];
    /**
    * user_defined_fields block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy_rule#user_defined_fields GoogleComputeRegionSecurityPolicyRule#user_defined_fields}
    */
    readonly userDefinedFields?: GoogleComputeRegionSecurityPolicyRuleNetworkMatchUserDefinedFields[] | cdktf.IResolvable;
}
export declare function googleComputeRegionSecurityPolicyRuleNetworkMatchToTerraform(struct?: GoogleComputeRegionSecurityPolicyRuleNetworkMatchOutputReference | GoogleComputeRegionSecurityPolicyRuleNetworkMatch): any;
export declare function googleComputeRegionSecurityPolicyRuleNetworkMatchToHclTerraform(struct?: GoogleComputeRegionSecurityPolicyRuleNetworkMatchOutputReference | GoogleComputeRegionSecurityPolicyRuleNetworkMatch): any;
export declare class GoogleComputeRegionSecurityPolicyRuleNetworkMatchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionSecurityPolicyRuleNetworkMatch | undefined;
    set internalValue(value: GoogleComputeRegionSecurityPolicyRuleNetworkMatch | undefined);
    private _destIpRanges?;
    get destIpRanges(): string[];
    set destIpRanges(value: string[]);
    resetDestIpRanges(): void;
    get destIpRangesInput(): string[] | undefined;
    private _destPorts?;
    get destPorts(): string[];
    set destPorts(value: string[]);
    resetDestPorts(): void;
    get destPortsInput(): string[] | undefined;
    private _ipProtocols?;
    get ipProtocols(): string[];
    set ipProtocols(value: string[]);
    resetIpProtocols(): void;
    get ipProtocolsInput(): string[] | undefined;
    private _srcAsns?;
    get srcAsns(): number[];
    set srcAsns(value: number[]);
    resetSrcAsns(): void;
    get srcAsnsInput(): number[] | undefined;
    private _srcIpRanges?;
    get srcIpRanges(): string[];
    set srcIpRanges(value: string[]);
    resetSrcIpRanges(): void;
    get srcIpRangesInput(): string[] | undefined;
    private _srcPorts?;
    get srcPorts(): string[];
    set srcPorts(value: string[]);
    resetSrcPorts(): void;
    get srcPortsInput(): string[] | undefined;
    private _srcRegionCodes?;
    get srcRegionCodes(): string[];
    set srcRegionCodes(value: string[]);
    resetSrcRegionCodes(): void;
    get srcRegionCodesInput(): string[] | undefined;
    private _userDefinedFields;
    get userDefinedFields(): GoogleComputeRegionSecurityPolicyRuleNetworkMatchUserDefinedFieldsList;
    putUserDefinedFields(value: GoogleComputeRegionSecurityPolicyRuleNetworkMatchUserDefinedFields[] | cdktf.IResolvable): void;
    resetUserDefinedFields(): void;
    get userDefinedFieldsInput(): cdktf.IResolvable | GoogleComputeRegionSecurityPolicyRuleNetworkMatchUserDefinedFields[] | undefined;
}
export interface GoogleComputeRegionSecurityPolicyRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy_rule#create GoogleComputeRegionSecurityPolicyRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy_rule#delete GoogleComputeRegionSecurityPolicyRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy_rule#update GoogleComputeRegionSecurityPolicyRule#update}
    */
    readonly update?: string;
}
export declare function googleComputeRegionSecurityPolicyRuleTimeoutsToTerraform(struct?: GoogleComputeRegionSecurityPolicyRuleTimeouts | cdktf.IResolvable): any;
export declare function googleComputeRegionSecurityPolicyRuleTimeoutsToHclTerraform(struct?: GoogleComputeRegionSecurityPolicyRuleTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeRegionSecurityPolicyRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionSecurityPolicyRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionSecurityPolicyRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy_rule google_compute_region_security_policy_rule}
*/
export declare class GoogleComputeRegionSecurityPolicyRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_region_security_policy_rule";
    /**
    * Generates CDKTF code for importing a GoogleComputeRegionSecurityPolicyRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleComputeRegionSecurityPolicyRule to import
    * @param importFromId The id of the existing GoogleComputeRegionSecurityPolicyRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleComputeRegionSecurityPolicyRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy_rule google_compute_region_security_policy_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeRegionSecurityPolicyRuleConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeRegionSecurityPolicyRuleConfig);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _preview?;
    get preview(): boolean | cdktf.IResolvable;
    set preview(value: boolean | cdktf.IResolvable);
    resetPreview(): void;
    get previewInput(): boolean | cdktf.IResolvable | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    get regionInput(): string | undefined;
    private _securityPolicy?;
    get securityPolicy(): string;
    set securityPolicy(value: string);
    get securityPolicyInput(): string | undefined;
    private _match;
    get match(): GoogleComputeRegionSecurityPolicyRuleMatchOutputReference;
    putMatch(value: GoogleComputeRegionSecurityPolicyRuleMatch): void;
    resetMatch(): void;
    get matchInput(): GoogleComputeRegionSecurityPolicyRuleMatch | undefined;
    private _networkMatch;
    get networkMatch(): GoogleComputeRegionSecurityPolicyRuleNetworkMatchOutputReference;
    putNetworkMatch(value: GoogleComputeRegionSecurityPolicyRuleNetworkMatch): void;
    resetNetworkMatch(): void;
    get networkMatchInput(): GoogleComputeRegionSecurityPolicyRuleNetworkMatch | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeRegionSecurityPolicyRuleTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeRegionSecurityPolicyRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeRegionSecurityPolicyRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
