/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeRegionSecurityPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource. Provide this property when you create the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy#description GoogleComputeRegionSecurityPolicy#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy#id GoogleComputeRegionSecurityPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035.
    * Specifically, the name must be 1-63 characters long and match the regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy#name GoogleComputeRegionSecurityPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy#project GoogleComputeRegionSecurityPolicy#project}
    */
    readonly project?: string;
    /**
    * The Region in which the created Region Security Policy should reside.
    * If it is not provided, the provider region is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy#region GoogleComputeRegionSecurityPolicy#region}
    */
    readonly region?: string;
    /**
    * The type indicates the intended use of the security policy.
    * - CLOUD_ARMOR: Cloud Armor backend security policies can be configured to filter incoming HTTP requests targeting backend services. They filter requests before they hit the origin servers.
    * - CLOUD_ARMOR_EDGE: Cloud Armor edge security policies can be configured to filter incoming HTTP requests targeting backend services (including Cloud CDN-enabled) as well as backend buckets (Cloud Storage). They filter requests before the request is served from Google's cache.
    * - CLOUD_ARMOR_NETWORK: Cloud Armor network policies can be configured to filter packets targeting network load balancing resources such as backend services, target pools, target instances, and instances with external IPs. They filter requests before the request is served from the application.
    * This field can be set only at resource creation time. Possible values: ["CLOUD_ARMOR", "CLOUD_ARMOR_EDGE", "CLOUD_ARMOR_NETWORK"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy#type GoogleComputeRegionSecurityPolicy#type}
    */
    readonly type?: string;
    /**
    * ddos_protection_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy#ddos_protection_config GoogleComputeRegionSecurityPolicy#ddos_protection_config}
    */
    readonly ddosProtectionConfig?: GoogleComputeRegionSecurityPolicyDdosProtectionConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy#timeouts GoogleComputeRegionSecurityPolicy#timeouts}
    */
    readonly timeouts?: GoogleComputeRegionSecurityPolicyTimeouts;
    /**
    * user_defined_fields block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy#user_defined_fields GoogleComputeRegionSecurityPolicy#user_defined_fields}
    */
    readonly userDefinedFields?: GoogleComputeRegionSecurityPolicyUserDefinedFields[] | cdktf.IResolvable;
}
export interface GoogleComputeRegionSecurityPolicyDdosProtectionConfig {
    /**
    * Google Cloud Armor offers the following options to help protect systems against DDoS attacks:
    * - STANDARD: basic always-on protection for network load balancers, protocol forwarding, or VMs with public IP addresses.
    * - ADVANCED: additional protections for Managed Protection Plus subscribers who use network load balancers, protocol forwarding, or VMs with public IP addresses.
    * - ADVANCED_PREVIEW: flag to enable the security policy in preview mode. Possible values: ["ADVANCED", "ADVANCED_PREVIEW", "STANDARD"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy#ddos_protection GoogleComputeRegionSecurityPolicy#ddos_protection}
    */
    readonly ddosProtection: string;
}
export declare function googleComputeRegionSecurityPolicyDdosProtectionConfigToTerraform(struct?: GoogleComputeRegionSecurityPolicyDdosProtectionConfigOutputReference | GoogleComputeRegionSecurityPolicyDdosProtectionConfig): any;
export declare function googleComputeRegionSecurityPolicyDdosProtectionConfigToHclTerraform(struct?: GoogleComputeRegionSecurityPolicyDdosProtectionConfigOutputReference | GoogleComputeRegionSecurityPolicyDdosProtectionConfig): any;
export declare class GoogleComputeRegionSecurityPolicyDdosProtectionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionSecurityPolicyDdosProtectionConfig | undefined;
    set internalValue(value: GoogleComputeRegionSecurityPolicyDdosProtectionConfig | undefined);
    private _ddosProtection?;
    get ddosProtection(): string;
    set ddosProtection(value: string);
    get ddosProtectionInput(): string | undefined;
}
export interface GoogleComputeRegionSecurityPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy#create GoogleComputeRegionSecurityPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy#delete GoogleComputeRegionSecurityPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy#update GoogleComputeRegionSecurityPolicy#update}
    */
    readonly update?: string;
}
export declare function googleComputeRegionSecurityPolicyTimeoutsToTerraform(struct?: GoogleComputeRegionSecurityPolicyTimeouts | cdktf.IResolvable): any;
export declare function googleComputeRegionSecurityPolicyTimeoutsToHclTerraform(struct?: GoogleComputeRegionSecurityPolicyTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeRegionSecurityPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionSecurityPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionSecurityPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleComputeRegionSecurityPolicyUserDefinedFields {
    /**
    * The base relative to which 'offset' is measured. Possible values are:
    * - IPV4: Points to the beginning of the IPv4 header.
    * - IPV6: Points to the beginning of the IPv6 header.
    * - TCP: Points to the beginning of the TCP header, skipping over any IPv4 options or IPv6 extension headers. Not present for non-first fragments.
    * - UDP: Points to the beginning of the UDP header, skipping over any IPv4 options or IPv6 extension headers. Not present for non-first fragments. Possible values: ["IPV4", "IPV6", "TCP", "UDP"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy#base GoogleComputeRegionSecurityPolicy#base}
    */
    readonly base: string;
    /**
    * If specified, apply this mask (bitwise AND) to the field to ignore bits before matching.
    * Encoded as a hexadecimal number (starting with "0x").
    * The last byte of the field (in network byte order) corresponds to the least significant byte of the mask.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy#mask GoogleComputeRegionSecurityPolicy#mask}
    */
    readonly mask?: string;
    /**
    * The name of this field. Must be unique within the policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy#name GoogleComputeRegionSecurityPolicy#name}
    */
    readonly name?: string;
    /**
    * Offset of the first byte of the field (in network byte order) relative to 'base'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy#offset GoogleComputeRegionSecurityPolicy#offset}
    */
    readonly offset?: number;
    /**
    * Size of the field in bytes. Valid values: 1-4.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy#size GoogleComputeRegionSecurityPolicy#size}
    */
    readonly size?: number;
}
export declare function googleComputeRegionSecurityPolicyUserDefinedFieldsToTerraform(struct?: GoogleComputeRegionSecurityPolicyUserDefinedFields | cdktf.IResolvable): any;
export declare function googleComputeRegionSecurityPolicyUserDefinedFieldsToHclTerraform(struct?: GoogleComputeRegionSecurityPolicyUserDefinedFields | cdktf.IResolvable): any;
export declare class GoogleComputeRegionSecurityPolicyUserDefinedFieldsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionSecurityPolicyUserDefinedFields | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionSecurityPolicyUserDefinedFields | cdktf.IResolvable | undefined);
    private _base?;
    get base(): string;
    set base(value: string);
    get baseInput(): string | undefined;
    private _mask?;
    get mask(): string;
    set mask(value: string);
    resetMask(): void;
    get maskInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _offset?;
    get offset(): number;
    set offset(value: number);
    resetOffset(): void;
    get offsetInput(): number | undefined;
    private _size?;
    get size(): number;
    set size(value: number);
    resetSize(): void;
    get sizeInput(): number | undefined;
}
export declare class GoogleComputeRegionSecurityPolicyUserDefinedFieldsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionSecurityPolicyUserDefinedFields[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionSecurityPolicyUserDefinedFieldsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy google_compute_region_security_policy}
*/
export declare class GoogleComputeRegionSecurityPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_region_security_policy";
    /**
    * Generates CDKTF code for importing a GoogleComputeRegionSecurityPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleComputeRegionSecurityPolicy to import
    * @param importFromId The id of the existing GoogleComputeRegionSecurityPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleComputeRegionSecurityPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_region_security_policy google_compute_region_security_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeRegionSecurityPolicyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeRegionSecurityPolicyConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get fingerprint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get policyId(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    get selfLinkWithPolicyId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _ddosProtectionConfig;
    get ddosProtectionConfig(): GoogleComputeRegionSecurityPolicyDdosProtectionConfigOutputReference;
    putDdosProtectionConfig(value: GoogleComputeRegionSecurityPolicyDdosProtectionConfig): void;
    resetDdosProtectionConfig(): void;
    get ddosProtectionConfigInput(): GoogleComputeRegionSecurityPolicyDdosProtectionConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeRegionSecurityPolicyTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeRegionSecurityPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeRegionSecurityPolicyTimeouts | undefined;
    private _userDefinedFields;
    get userDefinedFields(): GoogleComputeRegionSecurityPolicyUserDefinedFieldsList;
    putUserDefinedFields(value: GoogleComputeRegionSecurityPolicyUserDefinedFields[] | cdktf.IResolvable): void;
    resetUserDefinedFields(): void;
    get userDefinedFieldsInput(): cdktf.IResolvable | GoogleComputeRegionSecurityPolicyUserDefinedFields[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
