/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeReservationConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_reservation#description GoogleComputeReservation#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_reservation#id GoogleComputeReservation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
    * created. The name must be 1-63 characters long, and comply with
    * RFC1035. Specifically, the name must be 1-63 characters long and match
    * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
    * first character must be a lowercase letter, and all following
    * characters must be a dash, lowercase letter, or digit, except the last
    * character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_reservation#name GoogleComputeReservation#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_reservation#project GoogleComputeReservation#project}
    */
    readonly project?: string;
    /**
    * When set to true, only VMs that target this reservation by name can
    * consume this reservation. Otherwise, it can be consumed by VMs with
    * affinity for any reservation. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_reservation#specific_reservation_required GoogleComputeReservation#specific_reservation_required}
    */
    readonly specificReservationRequired?: boolean | cdktf.IResolvable;
    /**
    * The zone where the reservation is made.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_reservation#zone GoogleComputeReservation#zone}
    */
    readonly zone: string;
    /**
    * share_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_reservation#share_settings GoogleComputeReservation#share_settings}
    */
    readonly shareSettings?: GoogleComputeReservationShareSettings;
    /**
    * specific_reservation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_reservation#specific_reservation GoogleComputeReservation#specific_reservation}
    */
    readonly specificReservation: GoogleComputeReservationSpecificReservation;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_reservation#timeouts GoogleComputeReservation#timeouts}
    */
    readonly timeouts?: GoogleComputeReservationTimeouts;
}
export interface GoogleComputeReservationShareSettingsProjectMap {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_reservation#id GoogleComputeReservation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * The project id/number, should be same as the key of this project config in the project map.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_reservation#project_id GoogleComputeReservation#project_id}
    */
    readonly projectId?: string;
}
export declare function googleComputeReservationShareSettingsProjectMapToTerraform(struct?: GoogleComputeReservationShareSettingsProjectMap | cdktf.IResolvable): any;
export declare function googleComputeReservationShareSettingsProjectMapToHclTerraform(struct?: GoogleComputeReservationShareSettingsProjectMap | cdktf.IResolvable): any;
export declare class GoogleComputeReservationShareSettingsProjectMapOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeReservationShareSettingsProjectMap | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeReservationShareSettingsProjectMap | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    resetProjectId(): void;
    get projectIdInput(): string | undefined;
}
export declare class GoogleComputeReservationShareSettingsProjectMapList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeReservationShareSettingsProjectMap[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeReservationShareSettingsProjectMapOutputReference;
}
export interface GoogleComputeReservationShareSettings {
    /**
    * Type of sharing for this shared-reservation Possible values: ["LOCAL", "SPECIFIC_PROJECTS"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_reservation#share_type GoogleComputeReservation#share_type}
    */
    readonly shareType?: string;
    /**
    * project_map block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_reservation#project_map GoogleComputeReservation#project_map}
    */
    readonly projectMap?: GoogleComputeReservationShareSettingsProjectMap[] | cdktf.IResolvable;
}
export declare function googleComputeReservationShareSettingsToTerraform(struct?: GoogleComputeReservationShareSettingsOutputReference | GoogleComputeReservationShareSettings): any;
export declare function googleComputeReservationShareSettingsToHclTerraform(struct?: GoogleComputeReservationShareSettingsOutputReference | GoogleComputeReservationShareSettings): any;
export declare class GoogleComputeReservationShareSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeReservationShareSettings | undefined;
    set internalValue(value: GoogleComputeReservationShareSettings | undefined);
    private _shareType?;
    get shareType(): string;
    set shareType(value: string);
    resetShareType(): void;
    get shareTypeInput(): string | undefined;
    private _projectMap;
    get projectMap(): GoogleComputeReservationShareSettingsProjectMapList;
    putProjectMap(value: GoogleComputeReservationShareSettingsProjectMap[] | cdktf.IResolvable): void;
    resetProjectMap(): void;
    get projectMapInput(): cdktf.IResolvable | GoogleComputeReservationShareSettingsProjectMap[] | undefined;
}
export interface GoogleComputeReservationSpecificReservationInstancePropertiesGuestAccelerators {
    /**
    * The number of the guest accelerator cards exposed to
    * this instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_reservation#accelerator_count GoogleComputeReservation#accelerator_count}
    */
    readonly acceleratorCount: number;
    /**
    * The full or partial URL of the accelerator type to
    * attach to this instance. For example:
    * 'projects/my-project/zones/us-central1-c/acceleratorTypes/nvidia-tesla-p100'
    *
    * If you are creating an instance template, specify only the accelerator name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_reservation#accelerator_type GoogleComputeReservation#accelerator_type}
    */
    readonly acceleratorType: string;
}
export declare function googleComputeReservationSpecificReservationInstancePropertiesGuestAcceleratorsToTerraform(struct?: GoogleComputeReservationSpecificReservationInstancePropertiesGuestAccelerators | cdktf.IResolvable): any;
export declare function googleComputeReservationSpecificReservationInstancePropertiesGuestAcceleratorsToHclTerraform(struct?: GoogleComputeReservationSpecificReservationInstancePropertiesGuestAccelerators | cdktf.IResolvable): any;
export declare class GoogleComputeReservationSpecificReservationInstancePropertiesGuestAcceleratorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeReservationSpecificReservationInstancePropertiesGuestAccelerators | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeReservationSpecificReservationInstancePropertiesGuestAccelerators | cdktf.IResolvable | undefined);
    private _acceleratorCount?;
    get acceleratorCount(): number;
    set acceleratorCount(value: number);
    get acceleratorCountInput(): number | undefined;
    private _acceleratorType?;
    get acceleratorType(): string;
    set acceleratorType(value: string);
    get acceleratorTypeInput(): string | undefined;
}
export declare class GoogleComputeReservationSpecificReservationInstancePropertiesGuestAcceleratorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeReservationSpecificReservationInstancePropertiesGuestAccelerators[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeReservationSpecificReservationInstancePropertiesGuestAcceleratorsOutputReference;
}
export interface GoogleComputeReservationSpecificReservationInstancePropertiesLocalSsds {
    /**
    * The size of the disk in base-2 GB.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_reservation#disk_size_gb GoogleComputeReservation#disk_size_gb}
    */
    readonly diskSizeGb: number;
    /**
    * The disk interface to use for attaching this disk. Default value: "SCSI" Possible values: ["SCSI", "NVME"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_reservation#interface GoogleComputeReservation#interface}
    */
    readonly interface?: string;
}
export declare function googleComputeReservationSpecificReservationInstancePropertiesLocalSsdsToTerraform(struct?: GoogleComputeReservationSpecificReservationInstancePropertiesLocalSsds | cdktf.IResolvable): any;
export declare function googleComputeReservationSpecificReservationInstancePropertiesLocalSsdsToHclTerraform(struct?: GoogleComputeReservationSpecificReservationInstancePropertiesLocalSsds | cdktf.IResolvable): any;
export declare class GoogleComputeReservationSpecificReservationInstancePropertiesLocalSsdsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeReservationSpecificReservationInstancePropertiesLocalSsds | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeReservationSpecificReservationInstancePropertiesLocalSsds | cdktf.IResolvable | undefined);
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    get diskSizeGbInput(): number | undefined;
    private _interface?;
    get interface(): string;
    set interface(value: string);
    resetInterface(): void;
    get interfaceInput(): string | undefined;
}
export declare class GoogleComputeReservationSpecificReservationInstancePropertiesLocalSsdsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeReservationSpecificReservationInstancePropertiesLocalSsds[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeReservationSpecificReservationInstancePropertiesLocalSsdsOutputReference;
}
export interface GoogleComputeReservationSpecificReservationInstanceProperties {
    /**
    * The name of the machine type to reserve.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_reservation#machine_type GoogleComputeReservation#machine_type}
    */
    readonly machineType: string;
    /**
    * The minimum CPU platform for the reservation. For example,
    * '"Intel Skylake"'. See
    * the CPU platform availability reference](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform#availablezones)
    * for information on available CPU platforms.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_reservation#min_cpu_platform GoogleComputeReservation#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * guest_accelerators block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_reservation#guest_accelerators GoogleComputeReservation#guest_accelerators}
    */
    readonly guestAccelerators?: GoogleComputeReservationSpecificReservationInstancePropertiesGuestAccelerators[] | cdktf.IResolvable;
    /**
    * local_ssds block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_reservation#local_ssds GoogleComputeReservation#local_ssds}
    */
    readonly localSsds?: GoogleComputeReservationSpecificReservationInstancePropertiesLocalSsds[] | cdktf.IResolvable;
}
export declare function googleComputeReservationSpecificReservationInstancePropertiesToTerraform(struct?: GoogleComputeReservationSpecificReservationInstancePropertiesOutputReference | GoogleComputeReservationSpecificReservationInstanceProperties): any;
export declare function googleComputeReservationSpecificReservationInstancePropertiesToHclTerraform(struct?: GoogleComputeReservationSpecificReservationInstancePropertiesOutputReference | GoogleComputeReservationSpecificReservationInstanceProperties): any;
export declare class GoogleComputeReservationSpecificReservationInstancePropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeReservationSpecificReservationInstanceProperties | undefined;
    set internalValue(value: GoogleComputeReservationSpecificReservationInstanceProperties | undefined);
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    get machineTypeInput(): string | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _guestAccelerators;
    get guestAccelerators(): GoogleComputeReservationSpecificReservationInstancePropertiesGuestAcceleratorsList;
    putGuestAccelerators(value: GoogleComputeReservationSpecificReservationInstancePropertiesGuestAccelerators[] | cdktf.IResolvable): void;
    resetGuestAccelerators(): void;
    get guestAcceleratorsInput(): cdktf.IResolvable | GoogleComputeReservationSpecificReservationInstancePropertiesGuestAccelerators[] | undefined;
    private _localSsds;
    get localSsds(): GoogleComputeReservationSpecificReservationInstancePropertiesLocalSsdsList;
    putLocalSsds(value: GoogleComputeReservationSpecificReservationInstancePropertiesLocalSsds[] | cdktf.IResolvable): void;
    resetLocalSsds(): void;
    get localSsdsInput(): cdktf.IResolvable | GoogleComputeReservationSpecificReservationInstancePropertiesLocalSsds[] | undefined;
}
export interface GoogleComputeReservationSpecificReservation {
    /**
    * The number of resources that are allocated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_reservation#count GoogleComputeReservation#count}
    */
    readonly count: number;
    /**
    * instance_properties block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_reservation#instance_properties GoogleComputeReservation#instance_properties}
    */
    readonly instanceProperties: GoogleComputeReservationSpecificReservationInstanceProperties;
}
export declare function googleComputeReservationSpecificReservationToTerraform(struct?: GoogleComputeReservationSpecificReservationOutputReference | GoogleComputeReservationSpecificReservation): any;
export declare function googleComputeReservationSpecificReservationToHclTerraform(struct?: GoogleComputeReservationSpecificReservationOutputReference | GoogleComputeReservationSpecificReservation): any;
export declare class GoogleComputeReservationSpecificReservationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeReservationSpecificReservation | undefined;
    set internalValue(value: GoogleComputeReservationSpecificReservation | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    get inUseCount(): number;
    private _instanceProperties;
    get instanceProperties(): GoogleComputeReservationSpecificReservationInstancePropertiesOutputReference;
    putInstanceProperties(value: GoogleComputeReservationSpecificReservationInstanceProperties): void;
    get instancePropertiesInput(): GoogleComputeReservationSpecificReservationInstanceProperties | undefined;
}
export interface GoogleComputeReservationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_reservation#create GoogleComputeReservation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_reservation#delete GoogleComputeReservation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_reservation#update GoogleComputeReservation#update}
    */
    readonly update?: string;
}
export declare function googleComputeReservationTimeoutsToTerraform(struct?: GoogleComputeReservationTimeouts | cdktf.IResolvable): any;
export declare function googleComputeReservationTimeoutsToHclTerraform(struct?: GoogleComputeReservationTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeReservationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeReservationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeReservationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_reservation google_compute_reservation}
*/
export declare class GoogleComputeReservation extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_reservation";
    /**
    * Generates CDKTF code for importing a GoogleComputeReservation resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleComputeReservation to import
    * @param importFromId The id of the existing GoogleComputeReservation that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_reservation#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleComputeReservation to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_reservation google_compute_reservation} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeReservationConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeReservationConfig);
    get commitment(): string;
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _specificReservationRequired?;
    get specificReservationRequired(): boolean | cdktf.IResolvable;
    set specificReservationRequired(value: boolean | cdktf.IResolvable);
    resetSpecificReservationRequired(): void;
    get specificReservationRequiredInput(): boolean | cdktf.IResolvable | undefined;
    get status(): string;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    get zoneInput(): string | undefined;
    private _shareSettings;
    get shareSettings(): GoogleComputeReservationShareSettingsOutputReference;
    putShareSettings(value: GoogleComputeReservationShareSettings): void;
    resetShareSettings(): void;
    get shareSettingsInput(): GoogleComputeReservationShareSettings | undefined;
    private _specificReservation;
    get specificReservation(): GoogleComputeReservationSpecificReservationOutputReference;
    putSpecificReservation(value: GoogleComputeReservationSpecificReservation): void;
    get specificReservationInput(): GoogleComputeReservationSpecificReservation | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeReservationTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeReservationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeReservationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
