/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeResourcePolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource. Provide this property when you create the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#description GoogleComputeResourcePolicy#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#id GoogleComputeResourcePolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the resource, provided by the client when initially creating
    * the resource. The resource name must be 1-63 characters long, and comply
    * with RFC1035. Specifically, the name must be 1-63 characters long and
    * match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])'? which means the
    * first character must be a lowercase letter, and all following characters
    * must be a dash, lowercase letter, or digit, except the last character,
    * which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#name GoogleComputeResourcePolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#project GoogleComputeResourcePolicy#project}
    */
    readonly project?: string;
    /**
    * Region where resource policy resides.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#region GoogleComputeResourcePolicy#region}
    */
    readonly region?: string;
    /**
    * disk_consistency_group_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#disk_consistency_group_policy GoogleComputeResourcePolicy#disk_consistency_group_policy}
    */
    readonly diskConsistencyGroupPolicy?: GoogleComputeResourcePolicyDiskConsistencyGroupPolicy;
    /**
    * group_placement_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#group_placement_policy GoogleComputeResourcePolicy#group_placement_policy}
    */
    readonly groupPlacementPolicy?: GoogleComputeResourcePolicyGroupPlacementPolicy;
    /**
    * instance_schedule_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#instance_schedule_policy GoogleComputeResourcePolicy#instance_schedule_policy}
    */
    readonly instanceSchedulePolicy?: GoogleComputeResourcePolicyInstanceSchedulePolicy;
    /**
    * snapshot_schedule_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#snapshot_schedule_policy GoogleComputeResourcePolicy#snapshot_schedule_policy}
    */
    readonly snapshotSchedulePolicy?: GoogleComputeResourcePolicySnapshotSchedulePolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#timeouts GoogleComputeResourcePolicy#timeouts}
    */
    readonly timeouts?: GoogleComputeResourcePolicyTimeouts;
}
export interface GoogleComputeResourcePolicyDiskConsistencyGroupPolicy {
    /**
    * Enable disk consistency on the resource policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#enabled GoogleComputeResourcePolicy#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleComputeResourcePolicyDiskConsistencyGroupPolicyToTerraform(struct?: GoogleComputeResourcePolicyDiskConsistencyGroupPolicyOutputReference | GoogleComputeResourcePolicyDiskConsistencyGroupPolicy): any;
export declare function googleComputeResourcePolicyDiskConsistencyGroupPolicyToHclTerraform(struct?: GoogleComputeResourcePolicyDiskConsistencyGroupPolicyOutputReference | GoogleComputeResourcePolicyDiskConsistencyGroupPolicy): any;
export declare class GoogleComputeResourcePolicyDiskConsistencyGroupPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeResourcePolicyDiskConsistencyGroupPolicy | undefined;
    set internalValue(value: GoogleComputeResourcePolicyDiskConsistencyGroupPolicy | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleComputeResourcePolicyGroupPlacementPolicy {
    /**
    * The number of availability domains instances will be spread across. If two instances are in different
    * availability domain, they will not be put in the same low latency network
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#availability_domain_count GoogleComputeResourcePolicy#availability_domain_count}
    */
    readonly availabilityDomainCount?: number;
    /**
    * Collocation specifies whether to place VMs inside the same availability domain on the same low-latency network.
    * Specify 'COLLOCATED' to enable collocation. Can only be specified with 'vm_count'. If compute instances are created
    * with a COLLOCATED policy, then exactly 'vm_count' instances must be created at the same time with the resource policy
    * attached. Possible values: ["COLLOCATED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#collocation GoogleComputeResourcePolicy#collocation}
    */
    readonly collocation?: string;
    /**
    * Specifies the number of max logical switches.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#max_distance GoogleComputeResourcePolicy#max_distance}
    */
    readonly maxDistance?: number;
    /**
    * Number of VMs in this placement group. Google does not recommend that you use this field
    * unless you use a compact policy and you want your policy to work only if it contains this
    * exact number of VMs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#vm_count GoogleComputeResourcePolicy#vm_count}
    */
    readonly vmCount?: number;
}
export declare function googleComputeResourcePolicyGroupPlacementPolicyToTerraform(struct?: GoogleComputeResourcePolicyGroupPlacementPolicyOutputReference | GoogleComputeResourcePolicyGroupPlacementPolicy): any;
export declare function googleComputeResourcePolicyGroupPlacementPolicyToHclTerraform(struct?: GoogleComputeResourcePolicyGroupPlacementPolicyOutputReference | GoogleComputeResourcePolicyGroupPlacementPolicy): any;
export declare class GoogleComputeResourcePolicyGroupPlacementPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeResourcePolicyGroupPlacementPolicy | undefined;
    set internalValue(value: GoogleComputeResourcePolicyGroupPlacementPolicy | undefined);
    private _availabilityDomainCount?;
    get availabilityDomainCount(): number;
    set availabilityDomainCount(value: number);
    resetAvailabilityDomainCount(): void;
    get availabilityDomainCountInput(): number | undefined;
    private _collocation?;
    get collocation(): string;
    set collocation(value: string);
    resetCollocation(): void;
    get collocationInput(): string | undefined;
    private _maxDistance?;
    get maxDistance(): number;
    set maxDistance(value: number);
    resetMaxDistance(): void;
    get maxDistanceInput(): number | undefined;
    private _vmCount?;
    get vmCount(): number;
    set vmCount(value: number);
    resetVmCount(): void;
    get vmCountInput(): number | undefined;
}
export interface GoogleComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule {
    /**
    * Specifies the frequency for the operation, using the unix-cron format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#schedule GoogleComputeResourcePolicy#schedule}
    */
    readonly schedule: string;
}
export declare function googleComputeResourcePolicyInstanceSchedulePolicyVmStartScheduleToTerraform(struct?: GoogleComputeResourcePolicyInstanceSchedulePolicyVmStartScheduleOutputReference | GoogleComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule): any;
export declare function googleComputeResourcePolicyInstanceSchedulePolicyVmStartScheduleToHclTerraform(struct?: GoogleComputeResourcePolicyInstanceSchedulePolicyVmStartScheduleOutputReference | GoogleComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule): any;
export declare class GoogleComputeResourcePolicyInstanceSchedulePolicyVmStartScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule | undefined;
    set internalValue(value: GoogleComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule | undefined);
    private _schedule?;
    get schedule(): string;
    set schedule(value: string);
    get scheduleInput(): string | undefined;
}
export interface GoogleComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule {
    /**
    * Specifies the frequency for the operation, using the unix-cron format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#schedule GoogleComputeResourcePolicy#schedule}
    */
    readonly schedule: string;
}
export declare function googleComputeResourcePolicyInstanceSchedulePolicyVmStopScheduleToTerraform(struct?: GoogleComputeResourcePolicyInstanceSchedulePolicyVmStopScheduleOutputReference | GoogleComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule): any;
export declare function googleComputeResourcePolicyInstanceSchedulePolicyVmStopScheduleToHclTerraform(struct?: GoogleComputeResourcePolicyInstanceSchedulePolicyVmStopScheduleOutputReference | GoogleComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule): any;
export declare class GoogleComputeResourcePolicyInstanceSchedulePolicyVmStopScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule | undefined;
    set internalValue(value: GoogleComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule | undefined);
    private _schedule?;
    get schedule(): string;
    set schedule(value: string);
    get scheduleInput(): string | undefined;
}
export interface GoogleComputeResourcePolicyInstanceSchedulePolicy {
    /**
    * The expiration time of the schedule. The timestamp is an RFC3339 string.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#expiration_time GoogleComputeResourcePolicy#expiration_time}
    */
    readonly expirationTime?: string;
    /**
    * The start time of the schedule. The timestamp is an RFC3339 string.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#start_time GoogleComputeResourcePolicy#start_time}
    */
    readonly startTime?: string;
    /**
    * Specifies the time zone to be used in interpreting the schedule. The value of this field must be a time zone name
    * from the tz database: http://en.wikipedia.org/wiki/Tz_database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#time_zone GoogleComputeResourcePolicy#time_zone}
    */
    readonly timeZone: string;
    /**
    * vm_start_schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#vm_start_schedule GoogleComputeResourcePolicy#vm_start_schedule}
    */
    readonly vmStartSchedule?: GoogleComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule;
    /**
    * vm_stop_schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#vm_stop_schedule GoogleComputeResourcePolicy#vm_stop_schedule}
    */
    readonly vmStopSchedule?: GoogleComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule;
}
export declare function googleComputeResourcePolicyInstanceSchedulePolicyToTerraform(struct?: GoogleComputeResourcePolicyInstanceSchedulePolicyOutputReference | GoogleComputeResourcePolicyInstanceSchedulePolicy): any;
export declare function googleComputeResourcePolicyInstanceSchedulePolicyToHclTerraform(struct?: GoogleComputeResourcePolicyInstanceSchedulePolicyOutputReference | GoogleComputeResourcePolicyInstanceSchedulePolicy): any;
export declare class GoogleComputeResourcePolicyInstanceSchedulePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeResourcePolicyInstanceSchedulePolicy | undefined;
    set internalValue(value: GoogleComputeResourcePolicyInstanceSchedulePolicy | undefined);
    private _expirationTime?;
    get expirationTime(): string;
    set expirationTime(value: string);
    resetExpirationTime(): void;
    get expirationTimeInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    get timeZoneInput(): string | undefined;
    private _vmStartSchedule;
    get vmStartSchedule(): GoogleComputeResourcePolicyInstanceSchedulePolicyVmStartScheduleOutputReference;
    putVmStartSchedule(value: GoogleComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule): void;
    resetVmStartSchedule(): void;
    get vmStartScheduleInput(): GoogleComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule | undefined;
    private _vmStopSchedule;
    get vmStopSchedule(): GoogleComputeResourcePolicyInstanceSchedulePolicyVmStopScheduleOutputReference;
    putVmStopSchedule(value: GoogleComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule): void;
    resetVmStopSchedule(): void;
    get vmStopScheduleInput(): GoogleComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule | undefined;
}
export interface GoogleComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy {
    /**
    * Maximum age of the snapshot that is allowed to be kept.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#max_retention_days GoogleComputeResourcePolicy#max_retention_days}
    */
    readonly maxRetentionDays: number;
    /**
    * Specifies the behavior to apply to scheduled snapshots when
    * the source disk is deleted. Default value: "KEEP_AUTO_SNAPSHOTS" Possible values: ["KEEP_AUTO_SNAPSHOTS", "APPLY_RETENTION_POLICY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#on_source_disk_delete GoogleComputeResourcePolicy#on_source_disk_delete}
    */
    readonly onSourceDiskDelete?: string;
}
export declare function googleComputeResourcePolicySnapshotSchedulePolicyRetentionPolicyToTerraform(struct?: GoogleComputeResourcePolicySnapshotSchedulePolicyRetentionPolicyOutputReference | GoogleComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy): any;
export declare function googleComputeResourcePolicySnapshotSchedulePolicyRetentionPolicyToHclTerraform(struct?: GoogleComputeResourcePolicySnapshotSchedulePolicyRetentionPolicyOutputReference | GoogleComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy): any;
export declare class GoogleComputeResourcePolicySnapshotSchedulePolicyRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy | undefined;
    set internalValue(value: GoogleComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy | undefined);
    private _maxRetentionDays?;
    get maxRetentionDays(): number;
    set maxRetentionDays(value: number);
    get maxRetentionDaysInput(): number | undefined;
    private _onSourceDiskDelete?;
    get onSourceDiskDelete(): string;
    set onSourceDiskDelete(value: string);
    resetOnSourceDiskDelete(): void;
    get onSourceDiskDeleteInput(): string | undefined;
}
export interface GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule {
    /**
    * Defines a schedule with units measured in days. The value determines how many days pass between the start of each cycle. Days in cycle for snapshot schedule policy must be 1.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#days_in_cycle GoogleComputeResourcePolicy#days_in_cycle}
    */
    readonly daysInCycle: number;
    /**
    * This must be in UTC format that resolves to one of
    * 00:00, 04:00, 08:00, 12:00, 16:00, or 20:00. For example,
    * both 13:00-5 and 08:00 are valid.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#start_time GoogleComputeResourcePolicy#start_time}
    */
    readonly startTime: string;
}
export declare function googleComputeResourcePolicySnapshotSchedulePolicyScheduleDailyScheduleToTerraform(struct?: GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleDailyScheduleOutputReference | GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule): any;
export declare function googleComputeResourcePolicySnapshotSchedulePolicyScheduleDailyScheduleToHclTerraform(struct?: GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleDailyScheduleOutputReference | GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule): any;
export declare class GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleDailyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule | undefined;
    set internalValue(value: GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule | undefined);
    private _daysInCycle?;
    get daysInCycle(): number;
    set daysInCycle(value: number);
    get daysInCycleInput(): number | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    get startTimeInput(): string | undefined;
}
export interface GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule {
    /**
    * The number of hours between snapshots.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#hours_in_cycle GoogleComputeResourcePolicy#hours_in_cycle}
    */
    readonly hoursInCycle: number;
    /**
    * Time within the window to start the operations.
    * It must be in an hourly format "HH:MM",
    * where HH : [00-23] and MM : [00] GMT.
    * eg: 21:00
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#start_time GoogleComputeResourcePolicy#start_time}
    */
    readonly startTime: string;
}
export declare function googleComputeResourcePolicySnapshotSchedulePolicyScheduleHourlyScheduleToTerraform(struct?: GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleHourlyScheduleOutputReference | GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule): any;
export declare function googleComputeResourcePolicySnapshotSchedulePolicyScheduleHourlyScheduleToHclTerraform(struct?: GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleHourlyScheduleOutputReference | GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule): any;
export declare class GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleHourlyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule | undefined;
    set internalValue(value: GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule | undefined);
    private _hoursInCycle?;
    get hoursInCycle(): number;
    set hoursInCycle(value: number);
    get hoursInCycleInput(): number | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    get startTimeInput(): string | undefined;
}
export interface GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks {
    /**
    * The day of the week to create the snapshot. e.g. MONDAY Possible values: ["MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#day GoogleComputeResourcePolicy#day}
    */
    readonly day: string;
    /**
    * Time within the window to start the operations.
    * It must be in format "HH:MM", where HH : [00-23] and MM : [00-00] GMT.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#start_time GoogleComputeResourcePolicy#start_time}
    */
    readonly startTime: string;
}
export declare function googleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeksToTerraform(struct?: GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks | cdktf.IResolvable): any;
export declare function googleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeksToHclTerraform(struct?: GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks | cdktf.IResolvable): any;
export declare class GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks | cdktf.IResolvable | undefined);
    private _day?;
    get day(): string;
    set day(value: string);
    get dayInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    get startTimeInput(): string | undefined;
}
export declare class GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeksOutputReference;
}
export interface GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule {
    /**
    * day_of_weeks block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#day_of_weeks GoogleComputeResourcePolicy#day_of_weeks}
    */
    readonly dayOfWeeks: GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks[] | cdktf.IResolvable;
}
export declare function googleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleToTerraform(struct?: GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleOutputReference | GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule): any;
export declare function googleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleToHclTerraform(struct?: GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleOutputReference | GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule): any;
export declare class GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule | undefined;
    set internalValue(value: GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule | undefined);
    private _dayOfWeeks;
    get dayOfWeeks(): GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeksList;
    putDayOfWeeks(value: GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks[] | cdktf.IResolvable): void;
    get dayOfWeeksInput(): cdktf.IResolvable | GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks[] | undefined;
}
export interface GoogleComputeResourcePolicySnapshotSchedulePolicySchedule {
    /**
    * daily_schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#daily_schedule GoogleComputeResourcePolicy#daily_schedule}
    */
    readonly dailySchedule?: GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule;
    /**
    * hourly_schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#hourly_schedule GoogleComputeResourcePolicy#hourly_schedule}
    */
    readonly hourlySchedule?: GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule;
    /**
    * weekly_schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#weekly_schedule GoogleComputeResourcePolicy#weekly_schedule}
    */
    readonly weeklySchedule?: GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule;
}
export declare function googleComputeResourcePolicySnapshotSchedulePolicyScheduleToTerraform(struct?: GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleOutputReference | GoogleComputeResourcePolicySnapshotSchedulePolicySchedule): any;
export declare function googleComputeResourcePolicySnapshotSchedulePolicyScheduleToHclTerraform(struct?: GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleOutputReference | GoogleComputeResourcePolicySnapshotSchedulePolicySchedule): any;
export declare class GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeResourcePolicySnapshotSchedulePolicySchedule | undefined;
    set internalValue(value: GoogleComputeResourcePolicySnapshotSchedulePolicySchedule | undefined);
    private _dailySchedule;
    get dailySchedule(): GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleDailyScheduleOutputReference;
    putDailySchedule(value: GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule): void;
    resetDailySchedule(): void;
    get dailyScheduleInput(): GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule | undefined;
    private _hourlySchedule;
    get hourlySchedule(): GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleHourlyScheduleOutputReference;
    putHourlySchedule(value: GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule): void;
    resetHourlySchedule(): void;
    get hourlyScheduleInput(): GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule | undefined;
    private _weeklySchedule;
    get weeklySchedule(): GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleOutputReference;
    putWeeklySchedule(value: GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule): void;
    resetWeeklySchedule(): void;
    get weeklyScheduleInput(): GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule | undefined;
}
export interface GoogleComputeResourcePolicySnapshotSchedulePolicySnapshotProperties {
    /**
    * Creates the new snapshot in the snapshot chain labeled with the
    * specified name. The chain name must be 1-63 characters long and comply
    * with RFC1035.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#chain_name GoogleComputeResourcePolicy#chain_name}
    */
    readonly chainName?: string;
    /**
    * Whether to perform a 'guest aware' snapshot.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#guest_flush GoogleComputeResourcePolicy#guest_flush}
    */
    readonly guestFlush?: boolean | cdktf.IResolvable;
    /**
    * A set of key-value pairs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#labels GoogleComputeResourcePolicy#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Cloud Storage bucket location to store the auto snapshot
    * (regional or multi-regional)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#storage_locations GoogleComputeResourcePolicy#storage_locations}
    */
    readonly storageLocations?: string[];
}
export declare function googleComputeResourcePolicySnapshotSchedulePolicySnapshotPropertiesToTerraform(struct?: GoogleComputeResourcePolicySnapshotSchedulePolicySnapshotPropertiesOutputReference | GoogleComputeResourcePolicySnapshotSchedulePolicySnapshotProperties): any;
export declare function googleComputeResourcePolicySnapshotSchedulePolicySnapshotPropertiesToHclTerraform(struct?: GoogleComputeResourcePolicySnapshotSchedulePolicySnapshotPropertiesOutputReference | GoogleComputeResourcePolicySnapshotSchedulePolicySnapshotProperties): any;
export declare class GoogleComputeResourcePolicySnapshotSchedulePolicySnapshotPropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeResourcePolicySnapshotSchedulePolicySnapshotProperties | undefined;
    set internalValue(value: GoogleComputeResourcePolicySnapshotSchedulePolicySnapshotProperties | undefined);
    private _chainName?;
    get chainName(): string;
    set chainName(value: string);
    resetChainName(): void;
    get chainNameInput(): string | undefined;
    private _guestFlush?;
    get guestFlush(): boolean | cdktf.IResolvable;
    set guestFlush(value: boolean | cdktf.IResolvable);
    resetGuestFlush(): void;
    get guestFlushInput(): boolean | cdktf.IResolvable | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _storageLocations?;
    get storageLocations(): string[];
    set storageLocations(value: string[]);
    resetStorageLocations(): void;
    get storageLocationsInput(): string[] | undefined;
}
export interface GoogleComputeResourcePolicySnapshotSchedulePolicy {
    /**
    * retention_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#retention_policy GoogleComputeResourcePolicy#retention_policy}
    */
    readonly retentionPolicy?: GoogleComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#schedule GoogleComputeResourcePolicy#schedule}
    */
    readonly schedule: GoogleComputeResourcePolicySnapshotSchedulePolicySchedule;
    /**
    * snapshot_properties block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#snapshot_properties GoogleComputeResourcePolicy#snapshot_properties}
    */
    readonly snapshotProperties?: GoogleComputeResourcePolicySnapshotSchedulePolicySnapshotProperties;
}
export declare function googleComputeResourcePolicySnapshotSchedulePolicyToTerraform(struct?: GoogleComputeResourcePolicySnapshotSchedulePolicyOutputReference | GoogleComputeResourcePolicySnapshotSchedulePolicy): any;
export declare function googleComputeResourcePolicySnapshotSchedulePolicyToHclTerraform(struct?: GoogleComputeResourcePolicySnapshotSchedulePolicyOutputReference | GoogleComputeResourcePolicySnapshotSchedulePolicy): any;
export declare class GoogleComputeResourcePolicySnapshotSchedulePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeResourcePolicySnapshotSchedulePolicy | undefined;
    set internalValue(value: GoogleComputeResourcePolicySnapshotSchedulePolicy | undefined);
    private _retentionPolicy;
    get retentionPolicy(): GoogleComputeResourcePolicySnapshotSchedulePolicyRetentionPolicyOutputReference;
    putRetentionPolicy(value: GoogleComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy): void;
    resetRetentionPolicy(): void;
    get retentionPolicyInput(): GoogleComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy | undefined;
    private _schedule;
    get schedule(): GoogleComputeResourcePolicySnapshotSchedulePolicyScheduleOutputReference;
    putSchedule(value: GoogleComputeResourcePolicySnapshotSchedulePolicySchedule): void;
    get scheduleInput(): GoogleComputeResourcePolicySnapshotSchedulePolicySchedule | undefined;
    private _snapshotProperties;
    get snapshotProperties(): GoogleComputeResourcePolicySnapshotSchedulePolicySnapshotPropertiesOutputReference;
    putSnapshotProperties(value: GoogleComputeResourcePolicySnapshotSchedulePolicySnapshotProperties): void;
    resetSnapshotProperties(): void;
    get snapshotPropertiesInput(): GoogleComputeResourcePolicySnapshotSchedulePolicySnapshotProperties | undefined;
}
export interface GoogleComputeResourcePolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#create GoogleComputeResourcePolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#delete GoogleComputeResourcePolicy#delete}
    */
    readonly delete?: string;
}
export declare function googleComputeResourcePolicyTimeoutsToTerraform(struct?: GoogleComputeResourcePolicyTimeouts | cdktf.IResolvable): any;
export declare function googleComputeResourcePolicyTimeoutsToHclTerraform(struct?: GoogleComputeResourcePolicyTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeResourcePolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeResourcePolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeResourcePolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy google_compute_resource_policy}
*/
export declare class GoogleComputeResourcePolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_resource_policy";
    /**
    * Generates CDKTF code for importing a GoogleComputeResourcePolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleComputeResourcePolicy to import
    * @param importFromId The id of the existing GoogleComputeResourcePolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleComputeResourcePolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_resource_policy google_compute_resource_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeResourcePolicyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeResourcePolicyConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _diskConsistencyGroupPolicy;
    get diskConsistencyGroupPolicy(): GoogleComputeResourcePolicyDiskConsistencyGroupPolicyOutputReference;
    putDiskConsistencyGroupPolicy(value: GoogleComputeResourcePolicyDiskConsistencyGroupPolicy): void;
    resetDiskConsistencyGroupPolicy(): void;
    get diskConsistencyGroupPolicyInput(): GoogleComputeResourcePolicyDiskConsistencyGroupPolicy | undefined;
    private _groupPlacementPolicy;
    get groupPlacementPolicy(): GoogleComputeResourcePolicyGroupPlacementPolicyOutputReference;
    putGroupPlacementPolicy(value: GoogleComputeResourcePolicyGroupPlacementPolicy): void;
    resetGroupPlacementPolicy(): void;
    get groupPlacementPolicyInput(): GoogleComputeResourcePolicyGroupPlacementPolicy | undefined;
    private _instanceSchedulePolicy;
    get instanceSchedulePolicy(): GoogleComputeResourcePolicyInstanceSchedulePolicyOutputReference;
    putInstanceSchedulePolicy(value: GoogleComputeResourcePolicyInstanceSchedulePolicy): void;
    resetInstanceSchedulePolicy(): void;
    get instanceSchedulePolicyInput(): GoogleComputeResourcePolicyInstanceSchedulePolicy | undefined;
    private _snapshotSchedulePolicy;
    get snapshotSchedulePolicy(): GoogleComputeResourcePolicySnapshotSchedulePolicyOutputReference;
    putSnapshotSchedulePolicy(value: GoogleComputeResourcePolicySnapshotSchedulePolicy): void;
    resetSnapshotSchedulePolicy(): void;
    get snapshotSchedulePolicyInput(): GoogleComputeResourcePolicySnapshotSchedulePolicy | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeResourcePolicyTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeResourcePolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeResourcePolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
