/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeRouterConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_router#description GoogleComputeRouter#description}
    */
    readonly description?: string;
    /**
    * Indicates if a router is dedicated for use with encrypted VLAN
    * attachments (interconnectAttachments).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_router#encrypted_interconnect_router GoogleComputeRouter#encrypted_interconnect_router}
    */
    readonly encryptedInterconnectRouter?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_router#id GoogleComputeRouter#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. The name must be 1-63 characters long, and
    * comply with RFC1035. Specifically, the name must be 1-63 characters
    * long and match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?'
    * which means the first character must be a lowercase letter, and all
    * following characters must be a dash, lowercase letter, or digit,
    * except the last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_router#name GoogleComputeRouter#name}
    */
    readonly name: string;
    /**
    * A reference to the network to which this router belongs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_router#network GoogleComputeRouter#network}
    */
    readonly network: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_router#project GoogleComputeRouter#project}
    */
    readonly project?: string;
    /**
    * Region where the router resides.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_router#region GoogleComputeRouter#region}
    */
    readonly region?: string;
    /**
    * bgp block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_router#bgp GoogleComputeRouter#bgp}
    */
    readonly bgp?: GoogleComputeRouterBgp;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_router#timeouts GoogleComputeRouter#timeouts}
    */
    readonly timeouts?: GoogleComputeRouterTimeouts;
}
export interface GoogleComputeRouterBgpAdvertisedIpRanges {
    /**
    * User-specified description for the IP range.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_router#description GoogleComputeRouter#description}
    */
    readonly description?: string;
    /**
    * The IP range to advertise. The value must be a
    * CIDR-formatted string.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_router#range GoogleComputeRouter#range}
    */
    readonly range: string;
}
export declare function googleComputeRouterBgpAdvertisedIpRangesToTerraform(struct?: GoogleComputeRouterBgpAdvertisedIpRanges | cdktf.IResolvable): any;
export declare function googleComputeRouterBgpAdvertisedIpRangesToHclTerraform(struct?: GoogleComputeRouterBgpAdvertisedIpRanges | cdktf.IResolvable): any;
export declare class GoogleComputeRouterBgpAdvertisedIpRangesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRouterBgpAdvertisedIpRanges | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRouterBgpAdvertisedIpRanges | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _range?;
    get range(): string;
    set range(value: string);
    get rangeInput(): string | undefined;
}
export declare class GoogleComputeRouterBgpAdvertisedIpRangesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRouterBgpAdvertisedIpRanges[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRouterBgpAdvertisedIpRangesOutputReference;
}
export interface GoogleComputeRouterBgp {
    /**
    * User-specified flag to indicate which mode to use for advertisement. Default value: "DEFAULT" Possible values: ["DEFAULT", "CUSTOM"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_router#advertise_mode GoogleComputeRouter#advertise_mode}
    */
    readonly advertiseMode?: string;
    /**
    * User-specified list of prefix groups to advertise in custom mode.
    * This field can only be populated if advertiseMode is CUSTOM and
    * is advertised to all peers of the router. These groups will be
    * advertised in addition to any specified prefixes. Leave this field
    * blank to advertise no custom groups.
    *
    * This enum field has the one valid value: ALL_SUBNETS
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_router#advertised_groups GoogleComputeRouter#advertised_groups}
    */
    readonly advertisedGroups?: string[];
    /**
    * Local BGP Autonomous System Number (ASN). Must be an RFC6996
    * private ASN, either 16-bit or 32-bit. The value will be fixed for
    * this router resource. All VPN tunnels that link to this router
    * will have the same local ASN.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_router#asn GoogleComputeRouter#asn}
    */
    readonly asn: number;
    /**
    * The interval in seconds between BGP keepalive messages that are sent
    * to the peer. Hold time is three times the interval at which keepalive
    * messages are sent, and the hold time is the maximum number of seconds
    * allowed to elapse between successive keepalive messages that BGP
    * receives from a peer.
    *
    * BGP will use the smaller of either the local hold time value or the
    * peer's hold time value as the hold time for the BGP connection
    * between the two peers. If set, this value must be between 20 and 60.
    * The default is 20.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_router#keepalive_interval GoogleComputeRouter#keepalive_interval}
    */
    readonly keepaliveInterval?: number;
    /**
    * advertised_ip_ranges block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_router#advertised_ip_ranges GoogleComputeRouter#advertised_ip_ranges}
    */
    readonly advertisedIpRanges?: GoogleComputeRouterBgpAdvertisedIpRanges[] | cdktf.IResolvable;
}
export declare function googleComputeRouterBgpToTerraform(struct?: GoogleComputeRouterBgpOutputReference | GoogleComputeRouterBgp): any;
export declare function googleComputeRouterBgpToHclTerraform(struct?: GoogleComputeRouterBgpOutputReference | GoogleComputeRouterBgp): any;
export declare class GoogleComputeRouterBgpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRouterBgp | undefined;
    set internalValue(value: GoogleComputeRouterBgp | undefined);
    private _advertiseMode?;
    get advertiseMode(): string;
    set advertiseMode(value: string);
    resetAdvertiseMode(): void;
    get advertiseModeInput(): string | undefined;
    private _advertisedGroups?;
    get advertisedGroups(): string[];
    set advertisedGroups(value: string[]);
    resetAdvertisedGroups(): void;
    get advertisedGroupsInput(): string[] | undefined;
    private _asn?;
    get asn(): number;
    set asn(value: number);
    get asnInput(): number | undefined;
    private _keepaliveInterval?;
    get keepaliveInterval(): number;
    set keepaliveInterval(value: number);
    resetKeepaliveInterval(): void;
    get keepaliveIntervalInput(): number | undefined;
    private _advertisedIpRanges;
    get advertisedIpRanges(): GoogleComputeRouterBgpAdvertisedIpRangesList;
    putAdvertisedIpRanges(value: GoogleComputeRouterBgpAdvertisedIpRanges[] | cdktf.IResolvable): void;
    resetAdvertisedIpRanges(): void;
    get advertisedIpRangesInput(): cdktf.IResolvable | GoogleComputeRouterBgpAdvertisedIpRanges[] | undefined;
}
export interface GoogleComputeRouterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_router#create GoogleComputeRouter#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_router#delete GoogleComputeRouter#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_router#update GoogleComputeRouter#update}
    */
    readonly update?: string;
}
export declare function googleComputeRouterTimeoutsToTerraform(struct?: GoogleComputeRouterTimeouts | cdktf.IResolvable): any;
export declare function googleComputeRouterTimeoutsToHclTerraform(struct?: GoogleComputeRouterTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeRouterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRouterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRouterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_router google_compute_router}
*/
export declare class GoogleComputeRouter extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_router";
    /**
    * Generates CDKTF code for importing a GoogleComputeRouter resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleComputeRouter to import
    * @param importFromId The id of the existing GoogleComputeRouter that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_router#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleComputeRouter to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_router google_compute_router} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeRouterConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeRouterConfig);
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _encryptedInterconnectRouter?;
    get encryptedInterconnectRouter(): boolean | cdktf.IResolvable;
    set encryptedInterconnectRouter(value: boolean | cdktf.IResolvable);
    resetEncryptedInterconnectRouter(): void;
    get encryptedInterconnectRouterInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _bgp;
    get bgp(): GoogleComputeRouterBgpOutputReference;
    putBgp(value: GoogleComputeRouterBgp): void;
    resetBgp(): void;
    get bgpInput(): GoogleComputeRouterBgp | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeRouterTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeRouterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeRouterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
