/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeSecurityPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this security policy. Max size is 2048.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#description GoogleComputeSecurityPolicy#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#id GoogleComputeSecurityPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the security policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#name GoogleComputeSecurityPolicy#name}
    */
    readonly name: string;
    /**
    * The project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#project GoogleComputeSecurityPolicy#project}
    */
    readonly project?: string;
    /**
    * The type indicates the intended use of the security policy. CLOUD_ARMOR - Cloud Armor backend security policies can be configured to filter incoming HTTP requests targeting backend services. They filter requests before they hit the origin servers. CLOUD_ARMOR_EDGE - Cloud Armor edge security policies can be configured to filter incoming HTTP requests targeting backend services (including Cloud CDN-enabled) as well as backend buckets (Cloud Storage). They filter requests before the request is served from Google's cache.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#type GoogleComputeSecurityPolicy#type}
    */
    readonly type?: string;
    /**
    * adaptive_protection_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#adaptive_protection_config GoogleComputeSecurityPolicy#adaptive_protection_config}
    */
    readonly adaptiveProtectionConfig?: GoogleComputeSecurityPolicyAdaptiveProtectionConfig;
    /**
    * advanced_options_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#advanced_options_config GoogleComputeSecurityPolicy#advanced_options_config}
    */
    readonly advancedOptionsConfig?: GoogleComputeSecurityPolicyAdvancedOptionsConfig;
    /**
    * recaptcha_options_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#recaptcha_options_config GoogleComputeSecurityPolicy#recaptcha_options_config}
    */
    readonly recaptchaOptionsConfig?: GoogleComputeSecurityPolicyRecaptchaOptionsConfig;
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#rule GoogleComputeSecurityPolicy#rule}
    */
    readonly rule?: GoogleComputeSecurityPolicyRule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#timeouts GoogleComputeSecurityPolicy#timeouts}
    */
    readonly timeouts?: GoogleComputeSecurityPolicyTimeouts;
}
export interface GoogleComputeSecurityPolicyAdaptiveProtectionConfigAutoDeployConfig {
    /**
    * Rules are only automatically deployed for alerts on potential attacks with confidence scores greater than this threshold.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#confidence_threshold GoogleComputeSecurityPolicy#confidence_threshold}
    */
    readonly confidenceThreshold?: number;
    /**
    * Google Cloud Armor stops applying the action in the automatically deployed rule to an identified attacker after this duration. The rule continues to operate against new requests.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#expiration_sec GoogleComputeSecurityPolicy#expiration_sec}
    */
    readonly expirationSec?: number;
    /**
    * Rules are only automatically deployed when the estimated impact to baseline traffic from the suggested mitigation is below this threshold.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#impacted_baseline_threshold GoogleComputeSecurityPolicy#impacted_baseline_threshold}
    */
    readonly impactedBaselineThreshold?: number;
    /**
    * Identifies new attackers only when the load to the backend service that is under attack exceeds this threshold.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#load_threshold GoogleComputeSecurityPolicy#load_threshold}
    */
    readonly loadThreshold?: number;
}
export declare function googleComputeSecurityPolicyAdaptiveProtectionConfigAutoDeployConfigToTerraform(struct?: GoogleComputeSecurityPolicyAdaptiveProtectionConfigAutoDeployConfigOutputReference | GoogleComputeSecurityPolicyAdaptiveProtectionConfigAutoDeployConfig): any;
export declare function googleComputeSecurityPolicyAdaptiveProtectionConfigAutoDeployConfigToHclTerraform(struct?: GoogleComputeSecurityPolicyAdaptiveProtectionConfigAutoDeployConfigOutputReference | GoogleComputeSecurityPolicyAdaptiveProtectionConfigAutoDeployConfig): any;
export declare class GoogleComputeSecurityPolicyAdaptiveProtectionConfigAutoDeployConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSecurityPolicyAdaptiveProtectionConfigAutoDeployConfig | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyAdaptiveProtectionConfigAutoDeployConfig | undefined);
    private _confidenceThreshold?;
    get confidenceThreshold(): number;
    set confidenceThreshold(value: number);
    resetConfidenceThreshold(): void;
    get confidenceThresholdInput(): number | undefined;
    private _expirationSec?;
    get expirationSec(): number;
    set expirationSec(value: number);
    resetExpirationSec(): void;
    get expirationSecInput(): number | undefined;
    private _impactedBaselineThreshold?;
    get impactedBaselineThreshold(): number;
    set impactedBaselineThreshold(value: number);
    resetImpactedBaselineThreshold(): void;
    get impactedBaselineThresholdInput(): number | undefined;
    private _loadThreshold?;
    get loadThreshold(): number;
    set loadThreshold(value: number);
    resetLoadThreshold(): void;
    get loadThresholdInput(): number | undefined;
}
export interface GoogleComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig {
    /**
    * If set to true, enables CAAP for L7 DDoS detection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#enable GoogleComputeSecurityPolicy#enable}
    */
    readonly enable?: boolean | cdktf.IResolvable;
    /**
    * Rule visibility. Supported values include: "STANDARD", "PREMIUM".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#rule_visibility GoogleComputeSecurityPolicy#rule_visibility}
    */
    readonly ruleVisibility?: string;
}
export declare function googleComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigToTerraform(struct?: GoogleComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigOutputReference | GoogleComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig): any;
export declare function googleComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigToHclTerraform(struct?: GoogleComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigOutputReference | GoogleComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig): any;
export declare class GoogleComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig | undefined);
    private _enable?;
    get enable(): boolean | cdktf.IResolvable;
    set enable(value: boolean | cdktf.IResolvable);
    resetEnable(): void;
    get enableInput(): boolean | cdktf.IResolvable | undefined;
    private _ruleVisibility?;
    get ruleVisibility(): string;
    set ruleVisibility(value: string);
    resetRuleVisibility(): void;
    get ruleVisibilityInput(): string | undefined;
}
export interface GoogleComputeSecurityPolicyAdaptiveProtectionConfig {
    /**
    * auto_deploy_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#auto_deploy_config GoogleComputeSecurityPolicy#auto_deploy_config}
    */
    readonly autoDeployConfig?: GoogleComputeSecurityPolicyAdaptiveProtectionConfigAutoDeployConfig;
    /**
    * layer_7_ddos_defense_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#layer_7_ddos_defense_config GoogleComputeSecurityPolicy#layer_7_ddos_defense_config}
    */
    readonly layer7DdosDefenseConfig?: GoogleComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig;
}
export declare function googleComputeSecurityPolicyAdaptiveProtectionConfigToTerraform(struct?: GoogleComputeSecurityPolicyAdaptiveProtectionConfigOutputReference | GoogleComputeSecurityPolicyAdaptiveProtectionConfig): any;
export declare function googleComputeSecurityPolicyAdaptiveProtectionConfigToHclTerraform(struct?: GoogleComputeSecurityPolicyAdaptiveProtectionConfigOutputReference | GoogleComputeSecurityPolicyAdaptiveProtectionConfig): any;
export declare class GoogleComputeSecurityPolicyAdaptiveProtectionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSecurityPolicyAdaptiveProtectionConfig | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyAdaptiveProtectionConfig | undefined);
    private _autoDeployConfig;
    get autoDeployConfig(): GoogleComputeSecurityPolicyAdaptiveProtectionConfigAutoDeployConfigOutputReference;
    putAutoDeployConfig(value: GoogleComputeSecurityPolicyAdaptiveProtectionConfigAutoDeployConfig): void;
    resetAutoDeployConfig(): void;
    get autoDeployConfigInput(): GoogleComputeSecurityPolicyAdaptiveProtectionConfigAutoDeployConfig | undefined;
    private _layer7DdosDefenseConfig;
    get layer7DdosDefenseConfig(): GoogleComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigOutputReference;
    putLayer7DdosDefenseConfig(value: GoogleComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig): void;
    resetLayer7DdosDefenseConfig(): void;
    get layer7DdosDefenseConfigInput(): GoogleComputeSecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig | undefined;
}
export interface GoogleComputeSecurityPolicyAdvancedOptionsConfigJsonCustomConfig {
    /**
    * A list of custom Content-Type header values to apply the JSON parsing.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#content_types GoogleComputeSecurityPolicy#content_types}
    */
    readonly contentTypes: string[];
}
export declare function googleComputeSecurityPolicyAdvancedOptionsConfigJsonCustomConfigToTerraform(struct?: GoogleComputeSecurityPolicyAdvancedOptionsConfigJsonCustomConfigOutputReference | GoogleComputeSecurityPolicyAdvancedOptionsConfigJsonCustomConfig): any;
export declare function googleComputeSecurityPolicyAdvancedOptionsConfigJsonCustomConfigToHclTerraform(struct?: GoogleComputeSecurityPolicyAdvancedOptionsConfigJsonCustomConfigOutputReference | GoogleComputeSecurityPolicyAdvancedOptionsConfigJsonCustomConfig): any;
export declare class GoogleComputeSecurityPolicyAdvancedOptionsConfigJsonCustomConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSecurityPolicyAdvancedOptionsConfigJsonCustomConfig | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyAdvancedOptionsConfigJsonCustomConfig | undefined);
    private _contentTypes?;
    get contentTypes(): string[];
    set contentTypes(value: string[]);
    get contentTypesInput(): string[] | undefined;
}
export interface GoogleComputeSecurityPolicyAdvancedOptionsConfig {
    /**
    * JSON body parsing. Supported values include: "DISABLED", "STANDARD".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#json_parsing GoogleComputeSecurityPolicy#json_parsing}
    */
    readonly jsonParsing?: string;
    /**
    * Logging level. Supported values include: "NORMAL", "VERBOSE".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#log_level GoogleComputeSecurityPolicy#log_level}
    */
    readonly logLevel?: string;
    /**
    * An optional list of case-insensitive request header names to use for resolving the callers client IP address.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#user_ip_request_headers GoogleComputeSecurityPolicy#user_ip_request_headers}
    */
    readonly userIpRequestHeaders?: string[];
    /**
    * json_custom_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#json_custom_config GoogleComputeSecurityPolicy#json_custom_config}
    */
    readonly jsonCustomConfig?: GoogleComputeSecurityPolicyAdvancedOptionsConfigJsonCustomConfig;
}
export declare function googleComputeSecurityPolicyAdvancedOptionsConfigToTerraform(struct?: GoogleComputeSecurityPolicyAdvancedOptionsConfigOutputReference | GoogleComputeSecurityPolicyAdvancedOptionsConfig): any;
export declare function googleComputeSecurityPolicyAdvancedOptionsConfigToHclTerraform(struct?: GoogleComputeSecurityPolicyAdvancedOptionsConfigOutputReference | GoogleComputeSecurityPolicyAdvancedOptionsConfig): any;
export declare class GoogleComputeSecurityPolicyAdvancedOptionsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSecurityPolicyAdvancedOptionsConfig | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyAdvancedOptionsConfig | undefined);
    private _jsonParsing?;
    get jsonParsing(): string;
    set jsonParsing(value: string);
    resetJsonParsing(): void;
    get jsonParsingInput(): string | undefined;
    private _logLevel?;
    get logLevel(): string;
    set logLevel(value: string);
    resetLogLevel(): void;
    get logLevelInput(): string | undefined;
    private _userIpRequestHeaders?;
    get userIpRequestHeaders(): string[];
    set userIpRequestHeaders(value: string[]);
    resetUserIpRequestHeaders(): void;
    get userIpRequestHeadersInput(): string[] | undefined;
    private _jsonCustomConfig;
    get jsonCustomConfig(): GoogleComputeSecurityPolicyAdvancedOptionsConfigJsonCustomConfigOutputReference;
    putJsonCustomConfig(value: GoogleComputeSecurityPolicyAdvancedOptionsConfigJsonCustomConfig): void;
    resetJsonCustomConfig(): void;
    get jsonCustomConfigInput(): GoogleComputeSecurityPolicyAdvancedOptionsConfigJsonCustomConfig | undefined;
}
export interface GoogleComputeSecurityPolicyRecaptchaOptionsConfig {
    /**
    * A field to supply a reCAPTCHA site key to be used for all the rules using the redirect action with the type of GOOGLE_RECAPTCHA under the security policy. The specified site key needs to be created from the reCAPTCHA API. The user is responsible for the validity of the specified site key. If not specified, a Google-managed site key is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#redirect_site_key GoogleComputeSecurityPolicy#redirect_site_key}
    */
    readonly redirectSiteKey: string;
}
export declare function googleComputeSecurityPolicyRecaptchaOptionsConfigToTerraform(struct?: GoogleComputeSecurityPolicyRecaptchaOptionsConfigOutputReference | GoogleComputeSecurityPolicyRecaptchaOptionsConfig): any;
export declare function googleComputeSecurityPolicyRecaptchaOptionsConfigToHclTerraform(struct?: GoogleComputeSecurityPolicyRecaptchaOptionsConfigOutputReference | GoogleComputeSecurityPolicyRecaptchaOptionsConfig): any;
export declare class GoogleComputeSecurityPolicyRecaptchaOptionsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSecurityPolicyRecaptchaOptionsConfig | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyRecaptchaOptionsConfig | undefined);
    private _redirectSiteKey?;
    get redirectSiteKey(): string;
    set redirectSiteKey(value: string);
    get redirectSiteKeyInput(): string | undefined;
}
export interface GoogleComputeSecurityPolicyRuleHeaderActionRequestHeadersToAdds {
    /**
    * The name of the header to set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#header_name GoogleComputeSecurityPolicy#header_name}
    */
    readonly headerName: string;
    /**
    * The value to set the named header to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#header_value GoogleComputeSecurityPolicy#header_value}
    */
    readonly headerValue?: string;
}
export declare function googleComputeSecurityPolicyRuleHeaderActionRequestHeadersToAddsToTerraform(struct?: GoogleComputeSecurityPolicyRuleHeaderActionRequestHeadersToAdds | cdktf.IResolvable): any;
export declare function googleComputeSecurityPolicyRuleHeaderActionRequestHeadersToAddsToHclTerraform(struct?: GoogleComputeSecurityPolicyRuleHeaderActionRequestHeadersToAdds | cdktf.IResolvable): any;
export declare class GoogleComputeSecurityPolicyRuleHeaderActionRequestHeadersToAddsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeSecurityPolicyRuleHeaderActionRequestHeadersToAdds | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyRuleHeaderActionRequestHeadersToAdds | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    resetHeaderValue(): void;
    get headerValueInput(): string | undefined;
}
export declare class GoogleComputeSecurityPolicyRuleHeaderActionRequestHeadersToAddsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeSecurityPolicyRuleHeaderActionRequestHeadersToAdds[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeSecurityPolicyRuleHeaderActionRequestHeadersToAddsOutputReference;
}
export interface GoogleComputeSecurityPolicyRuleHeaderAction {
    /**
    * request_headers_to_adds block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#request_headers_to_adds GoogleComputeSecurityPolicy#request_headers_to_adds}
    */
    readonly requestHeadersToAdds: GoogleComputeSecurityPolicyRuleHeaderActionRequestHeadersToAdds[] | cdktf.IResolvable;
}
export declare function googleComputeSecurityPolicyRuleHeaderActionToTerraform(struct?: GoogleComputeSecurityPolicyRuleHeaderActionOutputReference | GoogleComputeSecurityPolicyRuleHeaderAction): any;
export declare function googleComputeSecurityPolicyRuleHeaderActionToHclTerraform(struct?: GoogleComputeSecurityPolicyRuleHeaderActionOutputReference | GoogleComputeSecurityPolicyRuleHeaderAction): any;
export declare class GoogleComputeSecurityPolicyRuleHeaderActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSecurityPolicyRuleHeaderAction | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyRuleHeaderAction | undefined);
    private _requestHeadersToAdds;
    get requestHeadersToAdds(): GoogleComputeSecurityPolicyRuleHeaderActionRequestHeadersToAddsList;
    putRequestHeadersToAdds(value: GoogleComputeSecurityPolicyRuleHeaderActionRequestHeadersToAdds[] | cdktf.IResolvable): void;
    get requestHeadersToAddsInput(): cdktf.IResolvable | GoogleComputeSecurityPolicyRuleHeaderActionRequestHeadersToAdds[] | undefined;
}
export interface GoogleComputeSecurityPolicyRuleMatchConfig {
    /**
    * Set of IP addresses or ranges (IPV4 or IPV6) in CIDR notation to match against inbound traffic. There is a limit of 10 IP ranges per rule. A value of '*' matches all IPs (can be used to override the default behavior).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#src_ip_ranges GoogleComputeSecurityPolicy#src_ip_ranges}
    */
    readonly srcIpRanges: string[];
}
export declare function googleComputeSecurityPolicyRuleMatchConfigToTerraform(struct?: GoogleComputeSecurityPolicyRuleMatchConfigOutputReference | GoogleComputeSecurityPolicyRuleMatchConfig): any;
export declare function googleComputeSecurityPolicyRuleMatchConfigToHclTerraform(struct?: GoogleComputeSecurityPolicyRuleMatchConfigOutputReference | GoogleComputeSecurityPolicyRuleMatchConfig): any;
export declare class GoogleComputeSecurityPolicyRuleMatchConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSecurityPolicyRuleMatchConfig | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyRuleMatchConfig | undefined);
    private _srcIpRanges?;
    get srcIpRanges(): string[];
    set srcIpRanges(value: string[]);
    get srcIpRangesInput(): string[] | undefined;
}
export interface GoogleComputeSecurityPolicyRuleMatchExpr {
    /**
    * Textual representation of an expression in Common Expression Language syntax. The application context of the containing message determines which well-known feature set of CEL is supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#expression GoogleComputeSecurityPolicy#expression}
    */
    readonly expression: string;
}
export declare function googleComputeSecurityPolicyRuleMatchExprToTerraform(struct?: GoogleComputeSecurityPolicyRuleMatchExprOutputReference | GoogleComputeSecurityPolicyRuleMatchExpr): any;
export declare function googleComputeSecurityPolicyRuleMatchExprToHclTerraform(struct?: GoogleComputeSecurityPolicyRuleMatchExprOutputReference | GoogleComputeSecurityPolicyRuleMatchExpr): any;
export declare class GoogleComputeSecurityPolicyRuleMatchExprOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSecurityPolicyRuleMatchExpr | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyRuleMatchExpr | undefined);
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
}
export interface GoogleComputeSecurityPolicyRuleMatch {
    /**
    * Predefined rule expression. If this field is specified, config must also be specified. Available options:   SRC_IPS_V1: Must specify the corresponding src_ip_ranges field in config.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#versioned_expr GoogleComputeSecurityPolicy#versioned_expr}
    */
    readonly versionedExpr?: string;
    /**
    * config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#config GoogleComputeSecurityPolicy#config}
    */
    readonly config?: GoogleComputeSecurityPolicyRuleMatchConfig;
    /**
    * expr block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#expr GoogleComputeSecurityPolicy#expr}
    */
    readonly expr?: GoogleComputeSecurityPolicyRuleMatchExpr;
}
export declare function googleComputeSecurityPolicyRuleMatchToTerraform(struct?: GoogleComputeSecurityPolicyRuleMatchOutputReference | GoogleComputeSecurityPolicyRuleMatch): any;
export declare function googleComputeSecurityPolicyRuleMatchToHclTerraform(struct?: GoogleComputeSecurityPolicyRuleMatchOutputReference | GoogleComputeSecurityPolicyRuleMatch): any;
export declare class GoogleComputeSecurityPolicyRuleMatchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSecurityPolicyRuleMatch | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyRuleMatch | undefined);
    private _versionedExpr?;
    get versionedExpr(): string;
    set versionedExpr(value: string);
    resetVersionedExpr(): void;
    get versionedExprInput(): string | undefined;
    private _config;
    get config(): GoogleComputeSecurityPolicyRuleMatchConfigOutputReference;
    putConfig(value: GoogleComputeSecurityPolicyRuleMatchConfig): void;
    resetConfig(): void;
    get configInput(): GoogleComputeSecurityPolicyRuleMatchConfig | undefined;
    private _expr;
    get expr(): GoogleComputeSecurityPolicyRuleMatchExprOutputReference;
    putExpr(value: GoogleComputeSecurityPolicyRuleMatchExpr): void;
    resetExpr(): void;
    get exprInput(): GoogleComputeSecurityPolicyRuleMatchExpr | undefined;
}
export interface GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestCookie {
    /**
    * You can specify an exact match or a partial match by using a field operator and a field value. Available options: EQUALS: The operator matches if the field value equals the specified value. STARTS_WITH: The operator matches if the field value starts with the specified value. ENDS_WITH: The operator matches if the field value ends with the specified value. CONTAINS: The operator matches if the field value contains the specified value. EQUALS_ANY: The operator matches if the field value is any value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#operator GoogleComputeSecurityPolicy#operator}
    */
    readonly operator: string;
    /**
    * A request field matching the specified value will be excluded from inspection during preconfigured WAF evaluation. The field value must be given if the field operator is not EQUALS_ANY, and cannot be given if the field operator is EQUALS_ANY.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#value GoogleComputeSecurityPolicy#value}
    */
    readonly value?: string;
}
export declare function googleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestCookieToTerraform(struct?: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestCookie | cdktf.IResolvable): any;
export declare function googleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestCookieToHclTerraform(struct?: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestCookie | cdktf.IResolvable): any;
export declare class GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestCookieOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestCookie | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestCookie | cdktf.IResolvable | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestCookieList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestCookie[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestCookieOutputReference;
}
export interface GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestHeader {
    /**
    * You can specify an exact match or a partial match by using a field operator and a field value. Available options: EQUALS: The operator matches if the field value equals the specified value. STARTS_WITH: The operator matches if the field value starts with the specified value. ENDS_WITH: The operator matches if the field value ends with the specified value. CONTAINS: The operator matches if the field value contains the specified value. EQUALS_ANY: The operator matches if the field value is any value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#operator GoogleComputeSecurityPolicy#operator}
    */
    readonly operator: string;
    /**
    * A request field matching the specified value will be excluded from inspection during preconfigured WAF evaluation. The field value must be given if the field operator is not EQUALS_ANY, and cannot be given if the field operator is EQUALS_ANY.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#value GoogleComputeSecurityPolicy#value}
    */
    readonly value?: string;
}
export declare function googleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestHeaderToTerraform(struct?: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestHeader | cdktf.IResolvable): any;
export declare function googleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestHeaderToHclTerraform(struct?: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestHeader | cdktf.IResolvable): any;
export declare class GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestHeader | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestHeader | cdktf.IResolvable | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestHeaderOutputReference;
}
export interface GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestQueryParam {
    /**
    * You can specify an exact match or a partial match by using a field operator and a field value. Available options: EQUALS: The operator matches if the field value equals the specified value. STARTS_WITH: The operator matches if the field value starts with the specified value. ENDS_WITH: The operator matches if the field value ends with the specified value. CONTAINS: The operator matches if the field value contains the specified value. EQUALS_ANY: The operator matches if the field value is any value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#operator GoogleComputeSecurityPolicy#operator}
    */
    readonly operator: string;
    /**
    * A request field matching the specified value will be excluded from inspection during preconfigured WAF evaluation. The field value must be given if the field operator is not EQUALS_ANY, and cannot be given if the field operator is EQUALS_ANY.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#value GoogleComputeSecurityPolicy#value}
    */
    readonly value?: string;
}
export declare function googleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestQueryParamToTerraform(struct?: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestQueryParam | cdktf.IResolvable): any;
export declare function googleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestQueryParamToHclTerraform(struct?: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestQueryParam | cdktf.IResolvable): any;
export declare class GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestQueryParamOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestQueryParam | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestQueryParam | cdktf.IResolvable | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestQueryParamList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestQueryParam[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestQueryParamOutputReference;
}
export interface GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestUri {
    /**
    * You can specify an exact match or a partial match by using a field operator and a field value. Available options: EQUALS: The operator matches if the field value equals the specified value. STARTS_WITH: The operator matches if the field value starts with the specified value. ENDS_WITH: The operator matches if the field value ends with the specified value. CONTAINS: The operator matches if the field value contains the specified value. EQUALS_ANY: The operator matches if the field value is any value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#operator GoogleComputeSecurityPolicy#operator}
    */
    readonly operator: string;
    /**
    * A request field matching the specified value will be excluded from inspection during preconfigured WAF evaluation. The field value must be given if the field operator is not EQUALS_ANY, and cannot be given if the field operator is EQUALS_ANY.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#value GoogleComputeSecurityPolicy#value}
    */
    readonly value?: string;
}
export declare function googleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestUriToTerraform(struct?: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestUri | cdktf.IResolvable): any;
export declare function googleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestUriToHclTerraform(struct?: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestUri | cdktf.IResolvable): any;
export declare class GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestUriOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestUri | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestUri | cdktf.IResolvable | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestUriList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestUri[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestUriOutputReference;
}
export interface GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusion {
    /**
    * A list of target rule IDs under the WAF rule set to apply the preconfigured WAF exclusion. If omitted, it refers to all the rule IDs under the WAF rule set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#target_rule_ids GoogleComputeSecurityPolicy#target_rule_ids}
    */
    readonly targetRuleIds?: string[];
    /**
    * Target WAF rule set to apply the preconfigured WAF exclusion.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#target_rule_set GoogleComputeSecurityPolicy#target_rule_set}
    */
    readonly targetRuleSet: string;
    /**
    * request_cookie block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#request_cookie GoogleComputeSecurityPolicy#request_cookie}
    */
    readonly requestCookie?: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestCookie[] | cdktf.IResolvable;
    /**
    * request_header block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#request_header GoogleComputeSecurityPolicy#request_header}
    */
    readonly requestHeader?: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestHeader[] | cdktf.IResolvable;
    /**
    * request_query_param block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#request_query_param GoogleComputeSecurityPolicy#request_query_param}
    */
    readonly requestQueryParam?: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestQueryParam[] | cdktf.IResolvable;
    /**
    * request_uri block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#request_uri GoogleComputeSecurityPolicy#request_uri}
    */
    readonly requestUri?: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestUri[] | cdktf.IResolvable;
}
export declare function googleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionToTerraform(struct?: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusion | cdktf.IResolvable): any;
export declare function googleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionToHclTerraform(struct?: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusion | cdktf.IResolvable): any;
export declare class GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusion | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusion | cdktf.IResolvable | undefined);
    private _targetRuleIds?;
    get targetRuleIds(): string[];
    set targetRuleIds(value: string[]);
    resetTargetRuleIds(): void;
    get targetRuleIdsInput(): string[] | undefined;
    private _targetRuleSet?;
    get targetRuleSet(): string;
    set targetRuleSet(value: string);
    get targetRuleSetInput(): string | undefined;
    private _requestCookie;
    get requestCookie(): GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestCookieList;
    putRequestCookie(value: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestCookie[] | cdktf.IResolvable): void;
    resetRequestCookie(): void;
    get requestCookieInput(): cdktf.IResolvable | GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestCookie[] | undefined;
    private _requestHeader;
    get requestHeader(): GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestHeaderList;
    putRequestHeader(value: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestHeader[] | cdktf.IResolvable): void;
    resetRequestHeader(): void;
    get requestHeaderInput(): cdktf.IResolvable | GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestHeader[] | undefined;
    private _requestQueryParam;
    get requestQueryParam(): GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestQueryParamList;
    putRequestQueryParam(value: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestQueryParam[] | cdktf.IResolvable): void;
    resetRequestQueryParam(): void;
    get requestQueryParamInput(): cdktf.IResolvable | GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestQueryParam[] | undefined;
    private _requestUri;
    get requestUri(): GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestUriList;
    putRequestUri(value: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestUri[] | cdktf.IResolvable): void;
    resetRequestUri(): void;
    get requestUriInput(): cdktf.IResolvable | GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionRequestUri[] | undefined;
}
export declare class GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusion[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionOutputReference;
}
export interface GoogleComputeSecurityPolicyRulePreconfiguredWafConfig {
    /**
    * exclusion block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#exclusion GoogleComputeSecurityPolicy#exclusion}
    */
    readonly exclusion?: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusion[] | cdktf.IResolvable;
}
export declare function googleComputeSecurityPolicyRulePreconfiguredWafConfigToTerraform(struct?: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigOutputReference | GoogleComputeSecurityPolicyRulePreconfiguredWafConfig): any;
export declare function googleComputeSecurityPolicyRulePreconfiguredWafConfigToHclTerraform(struct?: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigOutputReference | GoogleComputeSecurityPolicyRulePreconfiguredWafConfig): any;
export declare class GoogleComputeSecurityPolicyRulePreconfiguredWafConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSecurityPolicyRulePreconfiguredWafConfig | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyRulePreconfiguredWafConfig | undefined);
    private _exclusion;
    get exclusion(): GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusionList;
    putExclusion(value: GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusion[] | cdktf.IResolvable): void;
    resetExclusion(): void;
    get exclusionInput(): cdktf.IResolvable | GoogleComputeSecurityPolicyRulePreconfiguredWafConfigExclusion[] | undefined;
}
export interface GoogleComputeSecurityPolicyRuleRateLimitOptionsBanThreshold {
    /**
    * Number of HTTP(S) requests for calculating the threshold.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#count GoogleComputeSecurityPolicy#count}
    */
    readonly count: number;
    /**
    * Interval over which the threshold is computed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#interval_sec GoogleComputeSecurityPolicy#interval_sec}
    */
    readonly intervalSec: number;
}
export declare function googleComputeSecurityPolicyRuleRateLimitOptionsBanThresholdToTerraform(struct?: GoogleComputeSecurityPolicyRuleRateLimitOptionsBanThresholdOutputReference | GoogleComputeSecurityPolicyRuleRateLimitOptionsBanThreshold): any;
export declare function googleComputeSecurityPolicyRuleRateLimitOptionsBanThresholdToHclTerraform(struct?: GoogleComputeSecurityPolicyRuleRateLimitOptionsBanThresholdOutputReference | GoogleComputeSecurityPolicyRuleRateLimitOptionsBanThreshold): any;
export declare class GoogleComputeSecurityPolicyRuleRateLimitOptionsBanThresholdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSecurityPolicyRuleRateLimitOptionsBanThreshold | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyRuleRateLimitOptionsBanThreshold | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _intervalSec?;
    get intervalSec(): number;
    set intervalSec(value: number);
    get intervalSecInput(): number | undefined;
}
export interface GoogleComputeSecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfigs {
    /**
    * Rate limit key name applicable only for the following key types: HTTP_HEADER -- Name of the HTTP header whose value is taken as the key value. HTTP_COOKIE -- Name of the HTTP cookie whose value is taken as the key value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#enforce_on_key_name GoogleComputeSecurityPolicy#enforce_on_key_name}
    */
    readonly enforceOnKeyName?: string;
    /**
    * Determines the key to enforce the rate_limit_threshold on
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#enforce_on_key_type GoogleComputeSecurityPolicy#enforce_on_key_type}
    */
    readonly enforceOnKeyType?: string;
}
export declare function googleComputeSecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfigsToTerraform(struct?: GoogleComputeSecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfigs | cdktf.IResolvable): any;
export declare function googleComputeSecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfigsToHclTerraform(struct?: GoogleComputeSecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfigs | cdktf.IResolvable): any;
export declare class GoogleComputeSecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeSecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfigs | cdktf.IResolvable | undefined);
    private _enforceOnKeyName?;
    get enforceOnKeyName(): string;
    set enforceOnKeyName(value: string);
    resetEnforceOnKeyName(): void;
    get enforceOnKeyNameInput(): string | undefined;
    private _enforceOnKeyType?;
    get enforceOnKeyType(): string;
    set enforceOnKeyType(value: string);
    resetEnforceOnKeyType(): void;
    get enforceOnKeyTypeInput(): string | undefined;
}
export declare class GoogleComputeSecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeSecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeSecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfigsOutputReference;
}
export interface GoogleComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptions {
    /**
    * Target for the redirect action. This is required if the type is EXTERNAL_302 and cannot be specified for GOOGLE_RECAPTCHA.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#target GoogleComputeSecurityPolicy#target}
    */
    readonly target?: string;
    /**
    * Type of the redirect action.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#type GoogleComputeSecurityPolicy#type}
    */
    readonly type: string;
}
export declare function googleComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptionsToTerraform(struct?: GoogleComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptionsOutputReference | GoogleComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptions): any;
export declare function googleComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptionsToHclTerraform(struct?: GoogleComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptionsOutputReference | GoogleComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptions): any;
export declare class GoogleComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptions | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptions | undefined);
    private _target?;
    get target(): string;
    set target(value: string);
    resetTarget(): void;
    get targetInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface GoogleComputeSecurityPolicyRuleRateLimitOptionsRateLimitThreshold {
    /**
    * Number of HTTP(S) requests for calculating the threshold.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#count GoogleComputeSecurityPolicy#count}
    */
    readonly count: number;
    /**
    * Interval over which the threshold is computed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#interval_sec GoogleComputeSecurityPolicy#interval_sec}
    */
    readonly intervalSec: number;
}
export declare function googleComputeSecurityPolicyRuleRateLimitOptionsRateLimitThresholdToTerraform(struct?: GoogleComputeSecurityPolicyRuleRateLimitOptionsRateLimitThresholdOutputReference | GoogleComputeSecurityPolicyRuleRateLimitOptionsRateLimitThreshold): any;
export declare function googleComputeSecurityPolicyRuleRateLimitOptionsRateLimitThresholdToHclTerraform(struct?: GoogleComputeSecurityPolicyRuleRateLimitOptionsRateLimitThresholdOutputReference | GoogleComputeSecurityPolicyRuleRateLimitOptionsRateLimitThreshold): any;
export declare class GoogleComputeSecurityPolicyRuleRateLimitOptionsRateLimitThresholdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSecurityPolicyRuleRateLimitOptionsRateLimitThreshold | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyRuleRateLimitOptionsRateLimitThreshold | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _intervalSec?;
    get intervalSec(): number;
    set intervalSec(value: number);
    get intervalSecInput(): number | undefined;
}
export interface GoogleComputeSecurityPolicyRuleRateLimitOptions {
    /**
    * Can only be specified if the action for the rule is "rate_based_ban". If specified, determines the time (in seconds) the traffic will continue to be banned by the rate limit after the rate falls below the threshold.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#ban_duration_sec GoogleComputeSecurityPolicy#ban_duration_sec}
    */
    readonly banDurationSec?: number;
    /**
    * Action to take for requests that are under the configured rate limit threshold. Valid option is "allow" only.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#conform_action GoogleComputeSecurityPolicy#conform_action}
    */
    readonly conformAction: string;
    /**
    * Determines the key to enforce the rateLimitThreshold on
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#enforce_on_key GoogleComputeSecurityPolicy#enforce_on_key}
    */
    readonly enforceOnKey?: string;
    /**
    * Rate limit key name applicable only for the following key types: HTTP_HEADER -- Name of the HTTP header whose value is taken as the key value. HTTP_COOKIE -- Name of the HTTP cookie whose value is taken as the key value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#enforce_on_key_name GoogleComputeSecurityPolicy#enforce_on_key_name}
    */
    readonly enforceOnKeyName?: string;
    /**
    * Action to take for requests that are above the configured rate limit threshold, to either deny with a specified HTTP response code, or redirect to a different endpoint. Valid options are "deny()" where valid values for status are 403, 404, 429, and 502, and "redirect" where the redirect parameters come from exceedRedirectOptions below.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#exceed_action GoogleComputeSecurityPolicy#exceed_action}
    */
    readonly exceedAction: string;
    /**
    * ban_threshold block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#ban_threshold GoogleComputeSecurityPolicy#ban_threshold}
    */
    readonly banThreshold?: GoogleComputeSecurityPolicyRuleRateLimitOptionsBanThreshold;
    /**
    * enforce_on_key_configs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#enforce_on_key_configs GoogleComputeSecurityPolicy#enforce_on_key_configs}
    */
    readonly enforceOnKeyConfigs?: GoogleComputeSecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfigs[] | cdktf.IResolvable;
    /**
    * exceed_redirect_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#exceed_redirect_options GoogleComputeSecurityPolicy#exceed_redirect_options}
    */
    readonly exceedRedirectOptions?: GoogleComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptions;
    /**
    * rate_limit_threshold block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#rate_limit_threshold GoogleComputeSecurityPolicy#rate_limit_threshold}
    */
    readonly rateLimitThreshold: GoogleComputeSecurityPolicyRuleRateLimitOptionsRateLimitThreshold;
}
export declare function googleComputeSecurityPolicyRuleRateLimitOptionsToTerraform(struct?: GoogleComputeSecurityPolicyRuleRateLimitOptionsOutputReference | GoogleComputeSecurityPolicyRuleRateLimitOptions): any;
export declare function googleComputeSecurityPolicyRuleRateLimitOptionsToHclTerraform(struct?: GoogleComputeSecurityPolicyRuleRateLimitOptionsOutputReference | GoogleComputeSecurityPolicyRuleRateLimitOptions): any;
export declare class GoogleComputeSecurityPolicyRuleRateLimitOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSecurityPolicyRuleRateLimitOptions | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyRuleRateLimitOptions | undefined);
    private _banDurationSec?;
    get banDurationSec(): number;
    set banDurationSec(value: number);
    resetBanDurationSec(): void;
    get banDurationSecInput(): number | undefined;
    private _conformAction?;
    get conformAction(): string;
    set conformAction(value: string);
    get conformActionInput(): string | undefined;
    private _enforceOnKey?;
    get enforceOnKey(): string;
    set enforceOnKey(value: string);
    resetEnforceOnKey(): void;
    get enforceOnKeyInput(): string | undefined;
    private _enforceOnKeyName?;
    get enforceOnKeyName(): string;
    set enforceOnKeyName(value: string);
    resetEnforceOnKeyName(): void;
    get enforceOnKeyNameInput(): string | undefined;
    private _exceedAction?;
    get exceedAction(): string;
    set exceedAction(value: string);
    get exceedActionInput(): string | undefined;
    private _banThreshold;
    get banThreshold(): GoogleComputeSecurityPolicyRuleRateLimitOptionsBanThresholdOutputReference;
    putBanThreshold(value: GoogleComputeSecurityPolicyRuleRateLimitOptionsBanThreshold): void;
    resetBanThreshold(): void;
    get banThresholdInput(): GoogleComputeSecurityPolicyRuleRateLimitOptionsBanThreshold | undefined;
    private _enforceOnKeyConfigs;
    get enforceOnKeyConfigs(): GoogleComputeSecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfigsList;
    putEnforceOnKeyConfigs(value: GoogleComputeSecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfigs[] | cdktf.IResolvable): void;
    resetEnforceOnKeyConfigs(): void;
    get enforceOnKeyConfigsInput(): cdktf.IResolvable | GoogleComputeSecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfigs[] | undefined;
    private _exceedRedirectOptions;
    get exceedRedirectOptions(): GoogleComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptionsOutputReference;
    putExceedRedirectOptions(value: GoogleComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptions): void;
    resetExceedRedirectOptions(): void;
    get exceedRedirectOptionsInput(): GoogleComputeSecurityPolicyRuleRateLimitOptionsExceedRedirectOptions | undefined;
    private _rateLimitThreshold;
    get rateLimitThreshold(): GoogleComputeSecurityPolicyRuleRateLimitOptionsRateLimitThresholdOutputReference;
    putRateLimitThreshold(value: GoogleComputeSecurityPolicyRuleRateLimitOptionsRateLimitThreshold): void;
    get rateLimitThresholdInput(): GoogleComputeSecurityPolicyRuleRateLimitOptionsRateLimitThreshold | undefined;
}
export interface GoogleComputeSecurityPolicyRuleRedirectOptions {
    /**
    * Target for the redirect action. This is required if the type is EXTERNAL_302 and cannot be specified for GOOGLE_RECAPTCHA.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#target GoogleComputeSecurityPolicy#target}
    */
    readonly target?: string;
    /**
    * Type of the redirect action. Available options: EXTERNAL_302: Must specify the corresponding target field in config. GOOGLE_RECAPTCHA: Cannot specify target field in config.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#type GoogleComputeSecurityPolicy#type}
    */
    readonly type: string;
}
export declare function googleComputeSecurityPolicyRuleRedirectOptionsToTerraform(struct?: GoogleComputeSecurityPolicyRuleRedirectOptionsOutputReference | GoogleComputeSecurityPolicyRuleRedirectOptions): any;
export declare function googleComputeSecurityPolicyRuleRedirectOptionsToHclTerraform(struct?: GoogleComputeSecurityPolicyRuleRedirectOptionsOutputReference | GoogleComputeSecurityPolicyRuleRedirectOptions): any;
export declare class GoogleComputeSecurityPolicyRuleRedirectOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSecurityPolicyRuleRedirectOptions | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyRuleRedirectOptions | undefined);
    private _target?;
    get target(): string;
    set target(value: string);
    resetTarget(): void;
    get targetInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface GoogleComputeSecurityPolicyRule {
    /**
    * Action to take when match matches the request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#action GoogleComputeSecurityPolicy#action}
    */
    readonly action: string;
    /**
    * An optional description of this rule. Max size is 64.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#description GoogleComputeSecurityPolicy#description}
    */
    readonly description?: string;
    /**
    * When set to true, the action specified above is not enforced. Stackdriver logs for requests that trigger a preview action are annotated as such.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#preview GoogleComputeSecurityPolicy#preview}
    */
    readonly preview?: boolean | cdktf.IResolvable;
    /**
    * An unique positive integer indicating the priority of evaluation for a rule. Rules are evaluated from highest priority (lowest numerically) to lowest priority (highest numerically) in order.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#priority GoogleComputeSecurityPolicy#priority}
    */
    readonly priority: number;
    /**
    * header_action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#header_action GoogleComputeSecurityPolicy#header_action}
    */
    readonly headerAction?: GoogleComputeSecurityPolicyRuleHeaderAction;
    /**
    * match block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#match GoogleComputeSecurityPolicy#match}
    */
    readonly match: GoogleComputeSecurityPolicyRuleMatch;
    /**
    * preconfigured_waf_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#preconfigured_waf_config GoogleComputeSecurityPolicy#preconfigured_waf_config}
    */
    readonly preconfiguredWafConfig?: GoogleComputeSecurityPolicyRulePreconfiguredWafConfig;
    /**
    * rate_limit_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#rate_limit_options GoogleComputeSecurityPolicy#rate_limit_options}
    */
    readonly rateLimitOptions?: GoogleComputeSecurityPolicyRuleRateLimitOptions;
    /**
    * redirect_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#redirect_options GoogleComputeSecurityPolicy#redirect_options}
    */
    readonly redirectOptions?: GoogleComputeSecurityPolicyRuleRedirectOptions;
}
export declare function googleComputeSecurityPolicyRuleToTerraform(struct?: GoogleComputeSecurityPolicyRule | cdktf.IResolvable): any;
export declare function googleComputeSecurityPolicyRuleToHclTerraform(struct?: GoogleComputeSecurityPolicyRule | cdktf.IResolvable): any;
export declare class GoogleComputeSecurityPolicyRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeSecurityPolicyRule | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyRule | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _preview?;
    get preview(): boolean | cdktf.IResolvable;
    set preview(value: boolean | cdktf.IResolvable);
    resetPreview(): void;
    get previewInput(): boolean | cdktf.IResolvable | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _headerAction;
    get headerAction(): GoogleComputeSecurityPolicyRuleHeaderActionOutputReference;
    putHeaderAction(value: GoogleComputeSecurityPolicyRuleHeaderAction): void;
    resetHeaderAction(): void;
    get headerActionInput(): GoogleComputeSecurityPolicyRuleHeaderAction | undefined;
    private _match;
    get match(): GoogleComputeSecurityPolicyRuleMatchOutputReference;
    putMatch(value: GoogleComputeSecurityPolicyRuleMatch): void;
    get matchInput(): GoogleComputeSecurityPolicyRuleMatch | undefined;
    private _preconfiguredWafConfig;
    get preconfiguredWafConfig(): GoogleComputeSecurityPolicyRulePreconfiguredWafConfigOutputReference;
    putPreconfiguredWafConfig(value: GoogleComputeSecurityPolicyRulePreconfiguredWafConfig): void;
    resetPreconfiguredWafConfig(): void;
    get preconfiguredWafConfigInput(): GoogleComputeSecurityPolicyRulePreconfiguredWafConfig | undefined;
    private _rateLimitOptions;
    get rateLimitOptions(): GoogleComputeSecurityPolicyRuleRateLimitOptionsOutputReference;
    putRateLimitOptions(value: GoogleComputeSecurityPolicyRuleRateLimitOptions): void;
    resetRateLimitOptions(): void;
    get rateLimitOptionsInput(): GoogleComputeSecurityPolicyRuleRateLimitOptions | undefined;
    private _redirectOptions;
    get redirectOptions(): GoogleComputeSecurityPolicyRuleRedirectOptionsOutputReference;
    putRedirectOptions(value: GoogleComputeSecurityPolicyRuleRedirectOptions): void;
    resetRedirectOptions(): void;
    get redirectOptionsInput(): GoogleComputeSecurityPolicyRuleRedirectOptions | undefined;
}
export declare class GoogleComputeSecurityPolicyRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeSecurityPolicyRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeSecurityPolicyRuleOutputReference;
}
export interface GoogleComputeSecurityPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#create GoogleComputeSecurityPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#delete GoogleComputeSecurityPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#update GoogleComputeSecurityPolicy#update}
    */
    readonly update?: string;
}
export declare function googleComputeSecurityPolicyTimeoutsToTerraform(struct?: GoogleComputeSecurityPolicyTimeouts | cdktf.IResolvable): any;
export declare function googleComputeSecurityPolicyTimeoutsToHclTerraform(struct?: GoogleComputeSecurityPolicyTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeSecurityPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSecurityPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeSecurityPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy google_compute_security_policy}
*/
export declare class GoogleComputeSecurityPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_security_policy";
    /**
    * Generates CDKTF code for importing a GoogleComputeSecurityPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleComputeSecurityPolicy to import
    * @param importFromId The id of the existing GoogleComputeSecurityPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleComputeSecurityPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_security_policy google_compute_security_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeSecurityPolicyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeSecurityPolicyConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get fingerprint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _adaptiveProtectionConfig;
    get adaptiveProtectionConfig(): GoogleComputeSecurityPolicyAdaptiveProtectionConfigOutputReference;
    putAdaptiveProtectionConfig(value: GoogleComputeSecurityPolicyAdaptiveProtectionConfig): void;
    resetAdaptiveProtectionConfig(): void;
    get adaptiveProtectionConfigInput(): GoogleComputeSecurityPolicyAdaptiveProtectionConfig | undefined;
    private _advancedOptionsConfig;
    get advancedOptionsConfig(): GoogleComputeSecurityPolicyAdvancedOptionsConfigOutputReference;
    putAdvancedOptionsConfig(value: GoogleComputeSecurityPolicyAdvancedOptionsConfig): void;
    resetAdvancedOptionsConfig(): void;
    get advancedOptionsConfigInput(): GoogleComputeSecurityPolicyAdvancedOptionsConfig | undefined;
    private _recaptchaOptionsConfig;
    get recaptchaOptionsConfig(): GoogleComputeSecurityPolicyRecaptchaOptionsConfigOutputReference;
    putRecaptchaOptionsConfig(value: GoogleComputeSecurityPolicyRecaptchaOptionsConfig): void;
    resetRecaptchaOptionsConfig(): void;
    get recaptchaOptionsConfigInput(): GoogleComputeSecurityPolicyRecaptchaOptionsConfig | undefined;
    private _rule;
    get rule(): GoogleComputeSecurityPolicyRuleList;
    putRule(value: GoogleComputeSecurityPolicyRule[] | cdktf.IResolvable): void;
    resetRule(): void;
    get ruleInput(): cdktf.IResolvable | GoogleComputeSecurityPolicyRule[] | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeSecurityPolicyTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeSecurityPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeSecurityPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
