/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeServiceAttachmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The connection preference to use for this service attachment. Valid
    * values include "ACCEPT_AUTOMATIC", "ACCEPT_MANUAL".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_service_attachment#connection_preference GoogleComputeServiceAttachment#connection_preference}
    */
    readonly connectionPreference: string;
    /**
    * An array of projects that are not allowed to connect to this service
    * attachment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_service_attachment#consumer_reject_lists GoogleComputeServiceAttachment#consumer_reject_lists}
    */
    readonly consumerRejectLists?: string[];
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_service_attachment#description GoogleComputeServiceAttachment#description}
    */
    readonly description?: string;
    /**
    * If specified, the domain name will be used during the integration between
    * the PSC connected endpoints and the Cloud DNS. For example, this is a
    * valid domain name: "p.mycompany.com.". Current max number of domain names
    * supported is 1.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_service_attachment#domain_names GoogleComputeServiceAttachment#domain_names}
    */
    readonly domainNames?: string[];
    /**
    * If true, enable the proxy protocol which is for supplying client TCP/IP
    * address data in TCP connections that traverse proxies on their way to
    * destination servers.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_service_attachment#enable_proxy_protocol GoogleComputeServiceAttachment#enable_proxy_protocol}
    */
    readonly enableProxyProtocol: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_service_attachment#id GoogleComputeServiceAttachment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. The name must be 1-63 characters long, and
    * comply with RFC1035. Specifically, the name must be 1-63 characters
    * long and match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?'
    * which means the first character must be a lowercase letter, and all
    * following characters must be a dash, lowercase letter, or digit,
    * except the last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_service_attachment#name GoogleComputeServiceAttachment#name}
    */
    readonly name: string;
    /**
    * An array of subnets that is provided for NAT in this service attachment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_service_attachment#nat_subnets GoogleComputeServiceAttachment#nat_subnets}
    */
    readonly natSubnets: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_service_attachment#project GoogleComputeServiceAttachment#project}
    */
    readonly project?: string;
    /**
    * This flag determines whether a consumer accept/reject list change can reconcile the statuses of existing ACCEPTED or REJECTED PSC endpoints.
    *
    * If false, connection policy update will only affect existing PENDING PSC endpoints. Existing ACCEPTED/REJECTED endpoints will remain untouched regardless how the connection policy is modified .
    * If true, update will affect both PENDING and ACCEPTED/REJECTED PSC endpoints. For example, an ACCEPTED PSC endpoint will be moved to REJECTED if its project is added to the reject list.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_service_attachment#reconcile_connections GoogleComputeServiceAttachment#reconcile_connections}
    */
    readonly reconcileConnections?: boolean | cdktf.IResolvable;
    /**
    * URL of the region where the resource resides.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_service_attachment#region GoogleComputeServiceAttachment#region}
    */
    readonly region?: string;
    /**
    * The URL of a forwarding rule that represents the service identified by
    * this service attachment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_service_attachment#target_service GoogleComputeServiceAttachment#target_service}
    */
    readonly targetService: string;
    /**
    * consumer_accept_lists block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_service_attachment#consumer_accept_lists GoogleComputeServiceAttachment#consumer_accept_lists}
    */
    readonly consumerAcceptLists?: GoogleComputeServiceAttachmentConsumerAcceptLists[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_service_attachment#timeouts GoogleComputeServiceAttachment#timeouts}
    */
    readonly timeouts?: GoogleComputeServiceAttachmentTimeouts;
}
export interface GoogleComputeServiceAttachmentConnectedEndpoints {
}
export declare function googleComputeServiceAttachmentConnectedEndpointsToTerraform(struct?: GoogleComputeServiceAttachmentConnectedEndpoints): any;
export declare function googleComputeServiceAttachmentConnectedEndpointsToHclTerraform(struct?: GoogleComputeServiceAttachmentConnectedEndpoints): any;
export declare class GoogleComputeServiceAttachmentConnectedEndpointsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeServiceAttachmentConnectedEndpoints | undefined;
    set internalValue(value: GoogleComputeServiceAttachmentConnectedEndpoints | undefined);
    get endpoint(): string;
    get status(): string;
}
export declare class GoogleComputeServiceAttachmentConnectedEndpointsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeServiceAttachmentConnectedEndpointsOutputReference;
}
export interface GoogleComputeServiceAttachmentConsumerAcceptLists {
    /**
    * The number of consumer forwarding rules the consumer project can
    * create.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_service_attachment#connection_limit GoogleComputeServiceAttachment#connection_limit}
    */
    readonly connectionLimit: number;
    /**
    * The network that is allowed to connect to this service attachment.
    * Only one of project_id_or_num and network_url may be set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_service_attachment#network_url GoogleComputeServiceAttachment#network_url}
    */
    readonly networkUrl?: string;
    /**
    * A project that is allowed to connect to this service attachment.
    * Only one of project_id_or_num and network_url may be set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_service_attachment#project_id_or_num GoogleComputeServiceAttachment#project_id_or_num}
    */
    readonly projectIdOrNum?: string;
}
export declare function googleComputeServiceAttachmentConsumerAcceptListsToTerraform(struct?: GoogleComputeServiceAttachmentConsumerAcceptLists | cdktf.IResolvable): any;
export declare function googleComputeServiceAttachmentConsumerAcceptListsToHclTerraform(struct?: GoogleComputeServiceAttachmentConsumerAcceptLists | cdktf.IResolvable): any;
export declare class GoogleComputeServiceAttachmentConsumerAcceptListsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeServiceAttachmentConsumerAcceptLists | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeServiceAttachmentConsumerAcceptLists | cdktf.IResolvable | undefined);
    private _connectionLimit?;
    get connectionLimit(): number;
    set connectionLimit(value: number);
    get connectionLimitInput(): number | undefined;
    private _networkUrl?;
    get networkUrl(): string;
    set networkUrl(value: string);
    resetNetworkUrl(): void;
    get networkUrlInput(): string | undefined;
    private _projectIdOrNum?;
    get projectIdOrNum(): string;
    set projectIdOrNum(value: string);
    resetProjectIdOrNum(): void;
    get projectIdOrNumInput(): string | undefined;
}
export declare class GoogleComputeServiceAttachmentConsumerAcceptListsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeServiceAttachmentConsumerAcceptLists[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeServiceAttachmentConsumerAcceptListsOutputReference;
}
export interface GoogleComputeServiceAttachmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_service_attachment#create GoogleComputeServiceAttachment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_service_attachment#delete GoogleComputeServiceAttachment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_service_attachment#update GoogleComputeServiceAttachment#update}
    */
    readonly update?: string;
}
export declare function googleComputeServiceAttachmentTimeoutsToTerraform(struct?: GoogleComputeServiceAttachmentTimeouts | cdktf.IResolvable): any;
export declare function googleComputeServiceAttachmentTimeoutsToHclTerraform(struct?: GoogleComputeServiceAttachmentTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeServiceAttachmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeServiceAttachmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeServiceAttachmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_service_attachment google_compute_service_attachment}
*/
export declare class GoogleComputeServiceAttachment extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_service_attachment";
    /**
    * Generates CDKTF code for importing a GoogleComputeServiceAttachment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleComputeServiceAttachment to import
    * @param importFromId The id of the existing GoogleComputeServiceAttachment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_service_attachment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleComputeServiceAttachment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_service_attachment google_compute_service_attachment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeServiceAttachmentConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeServiceAttachmentConfig);
    private _connectedEndpoints;
    get connectedEndpoints(): GoogleComputeServiceAttachmentConnectedEndpointsList;
    private _connectionPreference?;
    get connectionPreference(): string;
    set connectionPreference(value: string);
    get connectionPreferenceInput(): string | undefined;
    private _consumerRejectLists?;
    get consumerRejectLists(): string[];
    set consumerRejectLists(value: string[]);
    resetConsumerRejectLists(): void;
    get consumerRejectListsInput(): string[] | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _domainNames?;
    get domainNames(): string[];
    set domainNames(value: string[]);
    resetDomainNames(): void;
    get domainNamesInput(): string[] | undefined;
    private _enableProxyProtocol?;
    get enableProxyProtocol(): boolean | cdktf.IResolvable;
    set enableProxyProtocol(value: boolean | cdktf.IResolvable);
    get enableProxyProtocolInput(): boolean | cdktf.IResolvable | undefined;
    get fingerprint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _natSubnets?;
    get natSubnets(): string[];
    set natSubnets(value: string[]);
    get natSubnetsInput(): string[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _reconcileConnections?;
    get reconcileConnections(): boolean | cdktf.IResolvable;
    set reconcileConnections(value: boolean | cdktf.IResolvable);
    resetReconcileConnections(): void;
    get reconcileConnectionsInput(): boolean | cdktf.IResolvable | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _targetService?;
    get targetService(): string;
    set targetService(value: string);
    get targetServiceInput(): string | undefined;
    private _consumerAcceptLists;
    get consumerAcceptLists(): GoogleComputeServiceAttachmentConsumerAcceptListsList;
    putConsumerAcceptLists(value: GoogleComputeServiceAttachmentConsumerAcceptLists[] | cdktf.IResolvable): void;
    resetConsumerAcceptLists(): void;
    get consumerAcceptListsInput(): cdktf.IResolvable | GoogleComputeServiceAttachmentConsumerAcceptLists[] | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeServiceAttachmentTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeServiceAttachmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeServiceAttachmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
