/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeSharedVpcServiceProjectConfig extends cdktf.TerraformMetaArguments {
    /**
    * The deletion policy for the shared VPC service. Setting ABANDON allows the resource
    * 				to be abandoned rather than deleted. Possible values are: "ABANDON".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_shared_vpc_service_project#deletion_policy GoogleComputeSharedVpcServiceProject#deletion_policy}
    */
    readonly deletionPolicy?: string;
    /**
    * The ID of a host project to associate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_shared_vpc_service_project#host_project GoogleComputeSharedVpcServiceProject#host_project}
    */
    readonly hostProject: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_shared_vpc_service_project#id GoogleComputeSharedVpcServiceProject#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ID of the project that will serve as a Shared VPC service project.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_shared_vpc_service_project#service_project GoogleComputeSharedVpcServiceProject#service_project}
    */
    readonly serviceProject: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_shared_vpc_service_project#timeouts GoogleComputeSharedVpcServiceProject#timeouts}
    */
    readonly timeouts?: GoogleComputeSharedVpcServiceProjectTimeouts;
}
export interface GoogleComputeSharedVpcServiceProjectTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_shared_vpc_service_project#create GoogleComputeSharedVpcServiceProject#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_shared_vpc_service_project#delete GoogleComputeSharedVpcServiceProject#delete}
    */
    readonly delete?: string;
}
export declare function googleComputeSharedVpcServiceProjectTimeoutsToTerraform(struct?: GoogleComputeSharedVpcServiceProjectTimeouts | cdktf.IResolvable): any;
export declare function googleComputeSharedVpcServiceProjectTimeoutsToHclTerraform(struct?: GoogleComputeSharedVpcServiceProjectTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeSharedVpcServiceProjectTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSharedVpcServiceProjectTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeSharedVpcServiceProjectTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_shared_vpc_service_project google_compute_shared_vpc_service_project}
*/
export declare class GoogleComputeSharedVpcServiceProject extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_shared_vpc_service_project";
    /**
    * Generates CDKTF code for importing a GoogleComputeSharedVpcServiceProject resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleComputeSharedVpcServiceProject to import
    * @param importFromId The id of the existing GoogleComputeSharedVpcServiceProject that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_shared_vpc_service_project#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleComputeSharedVpcServiceProject to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_shared_vpc_service_project google_compute_shared_vpc_service_project} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeSharedVpcServiceProjectConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeSharedVpcServiceProjectConfig);
    private _deletionPolicy?;
    get deletionPolicy(): string;
    set deletionPolicy(value: string);
    resetDeletionPolicy(): void;
    get deletionPolicyInput(): string | undefined;
    private _hostProject?;
    get hostProject(): string;
    set hostProject(value: string);
    get hostProjectInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _serviceProject?;
    get serviceProject(): string;
    set serviceProject(value: string);
    get serviceProjectInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeSharedVpcServiceProjectTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeSharedVpcServiceProjectTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeSharedVpcServiceProjectTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
