/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeTargetHttpsProxyConfig extends cdktf.TerraformMetaArguments {
    /**
    * URLs to certificate manager certificate resources that are used to authenticate connections between users and the load balancer.
    * Currently, you may specify up to 15 certificates. Certificate manager certificates do not apply when the load balancing scheme is set to INTERNAL_SELF_MANAGED.
    * sslCertificates and certificateManagerCertificates fields can not be defined together.
    * Accepted format is '//certificatemanager.googleapis.com/projects/{project}/locations/{location}/certificates/{resourceName}' or just the self_link 'projects/{project}/locations/{location}/certificates/{resourceName}'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_target_https_proxy#certificate_manager_certificates GoogleComputeTargetHttpsProxy#certificate_manager_certificates}
    */
    readonly certificateManagerCertificates?: string[];
    /**
    * A reference to the CertificateMap resource uri that identifies a certificate map
    * associated with the given target proxy. This field can only be set for global target proxies.
    * Accepted format is '//certificatemanager.googleapis.com/projects/{project}/locations/{location}/certificateMaps/{resourceName}'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_target_https_proxy#certificate_map GoogleComputeTargetHttpsProxy#certificate_map}
    */
    readonly certificateMap?: string;
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_target_https_proxy#description GoogleComputeTargetHttpsProxy#description}
    */
    readonly description?: string;
    /**
    * Specifies how long to keep a connection open, after completing a response,
    * while there is no matching traffic (in seconds). If an HTTP keepalive is
    * not specified, a default value (610 seconds) will be used. For Global
    * external HTTP(S) load balancer, the minimum allowed value is 5 seconds and
    * the maximum allowed value is 1200 seconds. For Global external HTTP(S)
    * load balancer (classic), this option is not available publicly.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_target_https_proxy#http_keep_alive_timeout_sec GoogleComputeTargetHttpsProxy#http_keep_alive_timeout_sec}
    */
    readonly httpKeepAliveTimeoutSec?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_target_https_proxy#id GoogleComputeTargetHttpsProxy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
    * created. The name must be 1-63 characters long, and comply with
    * RFC1035. Specifically, the name must be 1-63 characters long and match
    * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
    * first character must be a lowercase letter, and all following
    * characters must be a dash, lowercase letter, or digit, except the last
    * character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_target_https_proxy#name GoogleComputeTargetHttpsProxy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_target_https_proxy#project GoogleComputeTargetHttpsProxy#project}
    */
    readonly project?: string;
    /**
    * This field only applies when the forwarding rule that references
    * this target proxy has a loadBalancingScheme set to INTERNAL_SELF_MANAGED.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_target_https_proxy#proxy_bind GoogleComputeTargetHttpsProxy#proxy_bind}
    */
    readonly proxyBind?: boolean | cdktf.IResolvable;
    /**
    * Specifies the QUIC override policy for this resource. This determines
    * whether the load balancer will attempt to negotiate QUIC with clients
    * or not. Can specify one of NONE, ENABLE, or DISABLE. If NONE is
    * specified, Google manages whether QUIC is used. Default value: "NONE" Possible values: ["NONE", "ENABLE", "DISABLE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_target_https_proxy#quic_override GoogleComputeTargetHttpsProxy#quic_override}
    */
    readonly quicOverride?: string;
    /**
    * A URL referring to a networksecurity.ServerTlsPolicy
    * resource that describes how the proxy should authenticate inbound
    * traffic. serverTlsPolicy only applies to a global TargetHttpsProxy
    * attached to globalForwardingRules with the loadBalancingScheme
    * set to INTERNAL_SELF_MANAGED or EXTERNAL or EXTERNAL_MANAGED.
    * For details which ServerTlsPolicy resources are accepted with
    * INTERNAL_SELF_MANAGED and which with EXTERNAL, EXTERNAL_MANAGED
    * loadBalancingScheme consult ServerTlsPolicy documentation.
    * If left blank, communications are not encrypted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_target_https_proxy#server_tls_policy GoogleComputeTargetHttpsProxy#server_tls_policy}
    */
    readonly serverTlsPolicy?: string;
    /**
    * URLs to SslCertificate resources that are used to authenticate connections between users and the load balancer.
    * Currently, you may specify up to 15 SSL certificates. sslCertificates do not apply when the load balancing scheme is set to INTERNAL_SELF_MANAGED.
    * sslCertificates and certificateManagerCertificates can not be defined together.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_target_https_proxy#ssl_certificates GoogleComputeTargetHttpsProxy#ssl_certificates}
    */
    readonly sslCertificates?: string[];
    /**
    * A reference to the SslPolicy resource that will be associated with
    * the TargetHttpsProxy resource. If not set, the TargetHttpsProxy
    * resource will not have any SSL policy configured.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_target_https_proxy#ssl_policy GoogleComputeTargetHttpsProxy#ssl_policy}
    */
    readonly sslPolicy?: string;
    /**
    * A reference to the UrlMap resource that defines the mapping from URL
    * to the BackendService.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_target_https_proxy#url_map GoogleComputeTargetHttpsProxy#url_map}
    */
    readonly urlMap: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_target_https_proxy#timeouts GoogleComputeTargetHttpsProxy#timeouts}
    */
    readonly timeouts?: GoogleComputeTargetHttpsProxyTimeouts;
}
export interface GoogleComputeTargetHttpsProxyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_target_https_proxy#create GoogleComputeTargetHttpsProxy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_target_https_proxy#delete GoogleComputeTargetHttpsProxy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_target_https_proxy#update GoogleComputeTargetHttpsProxy#update}
    */
    readonly update?: string;
}
export declare function googleComputeTargetHttpsProxyTimeoutsToTerraform(struct?: GoogleComputeTargetHttpsProxyTimeouts | cdktf.IResolvable): any;
export declare function googleComputeTargetHttpsProxyTimeoutsToHclTerraform(struct?: GoogleComputeTargetHttpsProxyTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeTargetHttpsProxyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeTargetHttpsProxyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeTargetHttpsProxyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_target_https_proxy google_compute_target_https_proxy}
*/
export declare class GoogleComputeTargetHttpsProxy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_target_https_proxy";
    /**
    * Generates CDKTF code for importing a GoogleComputeTargetHttpsProxy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleComputeTargetHttpsProxy to import
    * @param importFromId The id of the existing GoogleComputeTargetHttpsProxy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_target_https_proxy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleComputeTargetHttpsProxy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_compute_target_https_proxy google_compute_target_https_proxy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeTargetHttpsProxyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeTargetHttpsProxyConfig);
    private _certificateManagerCertificates?;
    get certificateManagerCertificates(): string[];
    set certificateManagerCertificates(value: string[]);
    resetCertificateManagerCertificates(): void;
    get certificateManagerCertificatesInput(): string[] | undefined;
    private _certificateMap?;
    get certificateMap(): string;
    set certificateMap(value: string);
    resetCertificateMap(): void;
    get certificateMapInput(): string | undefined;
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _httpKeepAliveTimeoutSec?;
    get httpKeepAliveTimeoutSec(): number;
    set httpKeepAliveTimeoutSec(value: number);
    resetHttpKeepAliveTimeoutSec(): void;
    get httpKeepAliveTimeoutSecInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _proxyBind?;
    get proxyBind(): boolean | cdktf.IResolvable;
    set proxyBind(value: boolean | cdktf.IResolvable);
    resetProxyBind(): void;
    get proxyBindInput(): boolean | cdktf.IResolvable | undefined;
    get proxyId(): number;
    private _quicOverride?;
    get quicOverride(): string;
    set quicOverride(value: string);
    resetQuicOverride(): void;
    get quicOverrideInput(): string | undefined;
    get selfLink(): string;
    private _serverTlsPolicy?;
    get serverTlsPolicy(): string;
    set serverTlsPolicy(value: string);
    resetServerTlsPolicy(): void;
    get serverTlsPolicyInput(): string | undefined;
    private _sslCertificates?;
    get sslCertificates(): string[];
    set sslCertificates(value: string[]);
    resetSslCertificates(): void;
    get sslCertificatesInput(): string[] | undefined;
    private _sslPolicy?;
    get sslPolicy(): string;
    set sslPolicy(value: string);
    resetSslPolicy(): void;
    get sslPolicyInput(): string | undefined;
    private _urlMap?;
    get urlMap(): string;
    set urlMap(value: string);
    get urlMapInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeTargetHttpsProxyTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeTargetHttpsProxyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeTargetHttpsProxyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
