/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleContainerAnalysisNoteConfig extends cdktf.TerraformMetaArguments {
    /**
    * Time of expiration for this note. Leave empty if note does not expire.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_note#expiration_time GoogleContainerAnalysisNote#expiration_time}
    */
    readonly expirationTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_note#id GoogleContainerAnalysisNote#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A detailed description of the note
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_note#long_description GoogleContainerAnalysisNote#long_description}
    */
    readonly longDescription?: string;
    /**
    * The name of the note.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_note#name GoogleContainerAnalysisNote#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_note#project GoogleContainerAnalysisNote#project}
    */
    readonly project?: string;
    /**
    * Names of other notes related to this note.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_note#related_note_names GoogleContainerAnalysisNote#related_note_names}
    */
    readonly relatedNoteNames?: string[];
    /**
    * A one sentence description of the note.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_note#short_description GoogleContainerAnalysisNote#short_description}
    */
    readonly shortDescription?: string;
    /**
    * attestation_authority block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_note#attestation_authority GoogleContainerAnalysisNote#attestation_authority}
    */
    readonly attestationAuthority: GoogleContainerAnalysisNoteAttestationAuthority;
    /**
    * related_url block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_note#related_url GoogleContainerAnalysisNote#related_url}
    */
    readonly relatedUrl?: GoogleContainerAnalysisNoteRelatedUrl[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_note#timeouts GoogleContainerAnalysisNote#timeouts}
    */
    readonly timeouts?: GoogleContainerAnalysisNoteTimeouts;
}
export interface GoogleContainerAnalysisNoteAttestationAuthorityHint {
    /**
    * The human readable name of this Attestation Authority, for
    * example "qa".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_note#human_readable_name GoogleContainerAnalysisNote#human_readable_name}
    */
    readonly humanReadableName: string;
}
export declare function googleContainerAnalysisNoteAttestationAuthorityHintToTerraform(struct?: GoogleContainerAnalysisNoteAttestationAuthorityHintOutputReference | GoogleContainerAnalysisNoteAttestationAuthorityHint): any;
export declare function googleContainerAnalysisNoteAttestationAuthorityHintToHclTerraform(struct?: GoogleContainerAnalysisNoteAttestationAuthorityHintOutputReference | GoogleContainerAnalysisNoteAttestationAuthorityHint): any;
export declare class GoogleContainerAnalysisNoteAttestationAuthorityHintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAnalysisNoteAttestationAuthorityHint | undefined;
    set internalValue(value: GoogleContainerAnalysisNoteAttestationAuthorityHint | undefined);
    private _humanReadableName?;
    get humanReadableName(): string;
    set humanReadableName(value: string);
    get humanReadableNameInput(): string | undefined;
}
export interface GoogleContainerAnalysisNoteAttestationAuthority {
    /**
    * hint block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_note#hint GoogleContainerAnalysisNote#hint}
    */
    readonly hint: GoogleContainerAnalysisNoteAttestationAuthorityHint;
}
export declare function googleContainerAnalysisNoteAttestationAuthorityToTerraform(struct?: GoogleContainerAnalysisNoteAttestationAuthorityOutputReference | GoogleContainerAnalysisNoteAttestationAuthority): any;
export declare function googleContainerAnalysisNoteAttestationAuthorityToHclTerraform(struct?: GoogleContainerAnalysisNoteAttestationAuthorityOutputReference | GoogleContainerAnalysisNoteAttestationAuthority): any;
export declare class GoogleContainerAnalysisNoteAttestationAuthorityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAnalysisNoteAttestationAuthority | undefined;
    set internalValue(value: GoogleContainerAnalysisNoteAttestationAuthority | undefined);
    private _hint;
    get hint(): GoogleContainerAnalysisNoteAttestationAuthorityHintOutputReference;
    putHint(value: GoogleContainerAnalysisNoteAttestationAuthorityHint): void;
    get hintInput(): GoogleContainerAnalysisNoteAttestationAuthorityHint | undefined;
}
export interface GoogleContainerAnalysisNoteRelatedUrl {
    /**
    * Label to describe usage of the URL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_note#label GoogleContainerAnalysisNote#label}
    */
    readonly label?: string;
    /**
    * Specific URL associated with the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_note#url GoogleContainerAnalysisNote#url}
    */
    readonly url: string;
}
export declare function googleContainerAnalysisNoteRelatedUrlToTerraform(struct?: GoogleContainerAnalysisNoteRelatedUrl | cdktf.IResolvable): any;
export declare function googleContainerAnalysisNoteRelatedUrlToHclTerraform(struct?: GoogleContainerAnalysisNoteRelatedUrl | cdktf.IResolvable): any;
export declare class GoogleContainerAnalysisNoteRelatedUrlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerAnalysisNoteRelatedUrl | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerAnalysisNoteRelatedUrl | cdktf.IResolvable | undefined);
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export declare class GoogleContainerAnalysisNoteRelatedUrlList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerAnalysisNoteRelatedUrl[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerAnalysisNoteRelatedUrlOutputReference;
}
export interface GoogleContainerAnalysisNoteTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_note#create GoogleContainerAnalysisNote#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_note#delete GoogleContainerAnalysisNote#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_note#update GoogleContainerAnalysisNote#update}
    */
    readonly update?: string;
}
export declare function googleContainerAnalysisNoteTimeoutsToTerraform(struct?: GoogleContainerAnalysisNoteTimeouts | cdktf.IResolvable): any;
export declare function googleContainerAnalysisNoteTimeoutsToHclTerraform(struct?: GoogleContainerAnalysisNoteTimeouts | cdktf.IResolvable): any;
export declare class GoogleContainerAnalysisNoteTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAnalysisNoteTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerAnalysisNoteTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_note google_container_analysis_note}
*/
export declare class GoogleContainerAnalysisNote extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_container_analysis_note";
    /**
    * Generates CDKTF code for importing a GoogleContainerAnalysisNote resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleContainerAnalysisNote to import
    * @param importFromId The id of the existing GoogleContainerAnalysisNote that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_note#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleContainerAnalysisNote to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_note google_container_analysis_note} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleContainerAnalysisNoteConfig
    */
    constructor(scope: Construct, id: string, config: GoogleContainerAnalysisNoteConfig);
    get createTime(): string;
    private _expirationTime?;
    get expirationTime(): string;
    set expirationTime(value: string);
    resetExpirationTime(): void;
    get expirationTimeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get kind(): string;
    private _longDescription?;
    get longDescription(): string;
    set longDescription(value: string);
    resetLongDescription(): void;
    get longDescriptionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _relatedNoteNames?;
    get relatedNoteNames(): string[];
    set relatedNoteNames(value: string[]);
    resetRelatedNoteNames(): void;
    get relatedNoteNamesInput(): string[] | undefined;
    private _shortDescription?;
    get shortDescription(): string;
    set shortDescription(value: string);
    resetShortDescription(): void;
    get shortDescriptionInput(): string | undefined;
    get updateTime(): string;
    private _attestationAuthority;
    get attestationAuthority(): GoogleContainerAnalysisNoteAttestationAuthorityOutputReference;
    putAttestationAuthority(value: GoogleContainerAnalysisNoteAttestationAuthority): void;
    get attestationAuthorityInput(): GoogleContainerAnalysisNoteAttestationAuthority | undefined;
    private _relatedUrl;
    get relatedUrl(): GoogleContainerAnalysisNoteRelatedUrlList;
    putRelatedUrl(value: GoogleContainerAnalysisNoteRelatedUrl[] | cdktf.IResolvable): void;
    resetRelatedUrl(): void;
    get relatedUrlInput(): cdktf.IResolvable | GoogleContainerAnalysisNoteRelatedUrl[] | undefined;
    private _timeouts;
    get timeouts(): GoogleContainerAnalysisNoteTimeoutsOutputReference;
    putTimeouts(value: GoogleContainerAnalysisNoteTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleContainerAnalysisNoteTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
