/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleContainerAnalysisOccurrenceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_occurrence#id GoogleContainerAnalysisOccurrence#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The analysis note associated with this occurrence, in the form of
    * projects/[PROJECT]/notes/[NOTE_ID]. This field can be used as a
    * filter in list requests.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_occurrence#note_name GoogleContainerAnalysisOccurrence#note_name}
    */
    readonly noteName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_occurrence#project GoogleContainerAnalysisOccurrence#project}
    */
    readonly project?: string;
    /**
    * A description of actions that can be taken to remedy the note.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_occurrence#remediation GoogleContainerAnalysisOccurrence#remediation}
    */
    readonly remediation?: string;
    /**
    * Required. Immutable. A URI that represents the resource for which
    * the occurrence applies. For example,
    * https://gcr.io/project/image@sha256:123abc for a Docker image.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_occurrence#resource_uri GoogleContainerAnalysisOccurrence#resource_uri}
    */
    readonly resourceUri: string;
    /**
    * attestation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_occurrence#attestation GoogleContainerAnalysisOccurrence#attestation}
    */
    readonly attestation: GoogleContainerAnalysisOccurrenceAttestation;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_occurrence#timeouts GoogleContainerAnalysisOccurrence#timeouts}
    */
    readonly timeouts?: GoogleContainerAnalysisOccurrenceTimeouts;
}
export interface GoogleContainerAnalysisOccurrenceAttestationSignatures {
    /**
    * The identifier for the public key that verifies this
    * signature. MUST be an RFC3986 conformant
    * URI. * When possible, the key id should be an
    * immutable reference, such as a cryptographic digest.
    * Examples of valid values:
    *
    * * OpenPGP V4 public key fingerprint. See https://www.iana.org/assignments/uri-schemes/prov/openpgp4fpr
    *   for more details on this scheme.
    *     * 'openpgp4fpr:74FAF3B861BDA0870C7B6DEF607E48D2A663AEEA'
    * * RFC6920 digest-named SubjectPublicKeyInfo (digest of the DER serialization):
    *     * "ni:///sha-256;cD9o9Cq6LG3jD0iKXqEi_vdjJGecm_iXkbqVoScViaU"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_occurrence#public_key_id GoogleContainerAnalysisOccurrence#public_key_id}
    */
    readonly publicKeyId: string;
    /**
    * The content of the signature, an opaque bytestring.
    * The payload that this signature verifies MUST be
    * unambiguously provided with the Signature during
    * verification. A wrapper message might provide the
    * payload explicitly. Alternatively, a message might
    * have a canonical serialization that can always be
    * unambiguously computed to derive the payload.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_occurrence#signature GoogleContainerAnalysisOccurrence#signature}
    */
    readonly signature?: string;
}
export declare function googleContainerAnalysisOccurrenceAttestationSignaturesToTerraform(struct?: GoogleContainerAnalysisOccurrenceAttestationSignatures | cdktf.IResolvable): any;
export declare function googleContainerAnalysisOccurrenceAttestationSignaturesToHclTerraform(struct?: GoogleContainerAnalysisOccurrenceAttestationSignatures | cdktf.IResolvable): any;
export declare class GoogleContainerAnalysisOccurrenceAttestationSignaturesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerAnalysisOccurrenceAttestationSignatures | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerAnalysisOccurrenceAttestationSignatures | cdktf.IResolvable | undefined);
    private _publicKeyId?;
    get publicKeyId(): string;
    set publicKeyId(value: string);
    get publicKeyIdInput(): string | undefined;
    private _signature?;
    get signature(): string;
    set signature(value: string);
    resetSignature(): void;
    get signatureInput(): string | undefined;
}
export declare class GoogleContainerAnalysisOccurrenceAttestationSignaturesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerAnalysisOccurrenceAttestationSignatures[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerAnalysisOccurrenceAttestationSignaturesOutputReference;
}
export interface GoogleContainerAnalysisOccurrenceAttestation {
    /**
    * The serialized payload that is verified by one or
    * more signatures. A base64-encoded string.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_occurrence#serialized_payload GoogleContainerAnalysisOccurrence#serialized_payload}
    */
    readonly serializedPayload: string;
    /**
    * signatures block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_occurrence#signatures GoogleContainerAnalysisOccurrence#signatures}
    */
    readonly signatures: GoogleContainerAnalysisOccurrenceAttestationSignatures[] | cdktf.IResolvable;
}
export declare function googleContainerAnalysisOccurrenceAttestationToTerraform(struct?: GoogleContainerAnalysisOccurrenceAttestationOutputReference | GoogleContainerAnalysisOccurrenceAttestation): any;
export declare function googleContainerAnalysisOccurrenceAttestationToHclTerraform(struct?: GoogleContainerAnalysisOccurrenceAttestationOutputReference | GoogleContainerAnalysisOccurrenceAttestation): any;
export declare class GoogleContainerAnalysisOccurrenceAttestationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAnalysisOccurrenceAttestation | undefined;
    set internalValue(value: GoogleContainerAnalysisOccurrenceAttestation | undefined);
    private _serializedPayload?;
    get serializedPayload(): string;
    set serializedPayload(value: string);
    get serializedPayloadInput(): string | undefined;
    private _signatures;
    get signatures(): GoogleContainerAnalysisOccurrenceAttestationSignaturesList;
    putSignatures(value: GoogleContainerAnalysisOccurrenceAttestationSignatures[] | cdktf.IResolvable): void;
    get signaturesInput(): cdktf.IResolvable | GoogleContainerAnalysisOccurrenceAttestationSignatures[] | undefined;
}
export interface GoogleContainerAnalysisOccurrenceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_occurrence#create GoogleContainerAnalysisOccurrence#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_occurrence#delete GoogleContainerAnalysisOccurrence#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_occurrence#update GoogleContainerAnalysisOccurrence#update}
    */
    readonly update?: string;
}
export declare function googleContainerAnalysisOccurrenceTimeoutsToTerraform(struct?: GoogleContainerAnalysisOccurrenceTimeouts | cdktf.IResolvable): any;
export declare function googleContainerAnalysisOccurrenceTimeoutsToHclTerraform(struct?: GoogleContainerAnalysisOccurrenceTimeouts | cdktf.IResolvable): any;
export declare class GoogleContainerAnalysisOccurrenceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAnalysisOccurrenceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerAnalysisOccurrenceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_occurrence google_container_analysis_occurrence}
*/
export declare class GoogleContainerAnalysisOccurrence extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_container_analysis_occurrence";
    /**
    * Generates CDKTF code for importing a GoogleContainerAnalysisOccurrence resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleContainerAnalysisOccurrence to import
    * @param importFromId The id of the existing GoogleContainerAnalysisOccurrence that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_occurrence#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleContainerAnalysisOccurrence to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_analysis_occurrence google_container_analysis_occurrence} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleContainerAnalysisOccurrenceConfig
    */
    constructor(scope: Construct, id: string, config: GoogleContainerAnalysisOccurrenceConfig);
    get createTime(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get kind(): string;
    get name(): string;
    private _noteName?;
    get noteName(): string;
    set noteName(value: string);
    get noteNameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _remediation?;
    get remediation(): string;
    set remediation(value: string);
    resetRemediation(): void;
    get remediationInput(): string | undefined;
    private _resourceUri?;
    get resourceUri(): string;
    set resourceUri(value: string);
    get resourceUriInput(): string | undefined;
    get updateTime(): string;
    private _attestation;
    get attestation(): GoogleContainerAnalysisOccurrenceAttestationOutputReference;
    putAttestation(value: GoogleContainerAnalysisOccurrenceAttestation): void;
    get attestationInput(): GoogleContainerAnalysisOccurrenceAttestation | undefined;
    private _timeouts;
    get timeouts(): GoogleContainerAnalysisOccurrenceTimeoutsOutputReference;
    putTimeouts(value: GoogleContainerAnalysisOccurrenceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleContainerAnalysisOccurrenceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
