/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleContainerAzureClientConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Azure Active Directory Application ID.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_client#application_id GoogleContainerAzureClient#application_id}
    */
    readonly applicationId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_client#id GoogleContainerAzureClient#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_client#location GoogleContainerAzureClient#location}
    */
    readonly location: string;
    /**
    * The name of this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_client#name GoogleContainerAzureClient#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_client#project GoogleContainerAzureClient#project}
    */
    readonly project?: string;
    /**
    * The Azure Active Directory Tenant ID.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_client#tenant_id GoogleContainerAzureClient#tenant_id}
    */
    readonly tenantId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_client#timeouts GoogleContainerAzureClient#timeouts}
    */
    readonly timeouts?: GoogleContainerAzureClientTimeouts;
}
export interface GoogleContainerAzureClientTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_client#create GoogleContainerAzureClient#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_client#delete GoogleContainerAzureClient#delete}
    */
    readonly delete?: string;
}
export declare function googleContainerAzureClientTimeoutsToTerraform(struct?: GoogleContainerAzureClientTimeouts | cdktf.IResolvable): any;
export declare function googleContainerAzureClientTimeoutsToHclTerraform(struct?: GoogleContainerAzureClientTimeouts | cdktf.IResolvable): any;
export declare class GoogleContainerAzureClientTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAzureClientTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerAzureClientTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_client google_container_azure_client}
*/
export declare class GoogleContainerAzureClient extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_container_azure_client";
    /**
    * Generates CDKTF code for importing a GoogleContainerAzureClient resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleContainerAzureClient to import
    * @param importFromId The id of the existing GoogleContainerAzureClient that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_client#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleContainerAzureClient to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_client google_container_azure_client} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleContainerAzureClientConfig
    */
    constructor(scope: Construct, id: string, config: GoogleContainerAzureClientConfig);
    private _applicationId?;
    get applicationId(): string;
    set applicationId(value: string);
    get applicationIdInput(): string | undefined;
    get certificate(): string;
    get createTime(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    get tenantIdInput(): string | undefined;
    get uid(): string;
    private _timeouts;
    get timeouts(): GoogleContainerAzureClientTimeoutsOutputReference;
    putTimeouts(value: GoogleContainerAzureClientTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleContainerAzureClientTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
