/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleContainerAzureClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. Annotations on the cluster. This field has the same restrictions as Kubernetes annotations. The total size of all keys and values combined is limited to 256k. Keys can have 2 segments: prefix (optional) and name (required), separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between.
    *
    * **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
    * Please refer to the field `effective_annotations` for all of the annotations present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#annotations GoogleContainerAzureCluster#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * The Azure region where the cluster runs. Each Google Cloud region supports a subset of nearby Azure regions. You can call to list all supported Azure regions within a given Google Cloud region.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#azure_region GoogleContainerAzureCluster#azure_region}
    */
    readonly azureRegion: string;
    /**
    * Name of the AzureClient. The `AzureClient` resource must reside on the same GCP project and region as the `AzureCluster`. `AzureClient` names are formatted as `projects/<project-number>/locations/<region>/azureClients/<client-id>`. See Resource Names (https:cloud.google.com/apis/design/resource_names) for more details on Google Cloud resource names.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#client GoogleContainerAzureCluster#client}
    */
    readonly client?: string;
    /**
    * Optional. A human readable description of this cluster. Cannot be longer than 255 UTF-8 encoded bytes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#description GoogleContainerAzureCluster#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#id GoogleContainerAzureCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#location GoogleContainerAzureCluster#location}
    */
    readonly location: string;
    /**
    * The name of this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#name GoogleContainerAzureCluster#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#project GoogleContainerAzureCluster#project}
    */
    readonly project?: string;
    /**
    * The ARM ID of the resource group where the cluster resources are deployed. For example: `/subscriptions/* /resourceGroups/*`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#resource_group_id GoogleContainerAzureCluster#resource_group_id}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly resourceGroupId: string;
    /**
    * authorization block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#authorization GoogleContainerAzureCluster#authorization}
    */
    readonly authorization: GoogleContainerAzureClusterAuthorization;
    /**
    * azure_services_authentication block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#azure_services_authentication GoogleContainerAzureCluster#azure_services_authentication}
    */
    readonly azureServicesAuthentication?: GoogleContainerAzureClusterAzureServicesAuthentication;
    /**
    * control_plane block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#control_plane GoogleContainerAzureCluster#control_plane}
    */
    readonly controlPlane: GoogleContainerAzureClusterControlPlane;
    /**
    * fleet block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#fleet GoogleContainerAzureCluster#fleet}
    */
    readonly fleet: GoogleContainerAzureClusterFleet;
    /**
    * logging_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#logging_config GoogleContainerAzureCluster#logging_config}
    */
    readonly loggingConfig?: GoogleContainerAzureClusterLoggingConfig;
    /**
    * networking block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#networking GoogleContainerAzureCluster#networking}
    */
    readonly networking: GoogleContainerAzureClusterNetworking;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#timeouts GoogleContainerAzureCluster#timeouts}
    */
    readonly timeouts?: GoogleContainerAzureClusterTimeouts;
}
export interface GoogleContainerAzureClusterWorkloadIdentityConfig {
}
export declare function googleContainerAzureClusterWorkloadIdentityConfigToTerraform(struct?: GoogleContainerAzureClusterWorkloadIdentityConfig): any;
export declare function googleContainerAzureClusterWorkloadIdentityConfigToHclTerraform(struct?: GoogleContainerAzureClusterWorkloadIdentityConfig): any;
export declare class GoogleContainerAzureClusterWorkloadIdentityConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerAzureClusterWorkloadIdentityConfig | undefined;
    set internalValue(value: GoogleContainerAzureClusterWorkloadIdentityConfig | undefined);
    get identityProvider(): string;
    get issuerUri(): string;
    get workloadPool(): string;
}
export declare class GoogleContainerAzureClusterWorkloadIdentityConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerAzureClusterWorkloadIdentityConfigOutputReference;
}
export interface GoogleContainerAzureClusterAuthorizationAdminGroups {
    /**
    * The name of the group, e.g. `my-group@domain.com`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#group GoogleContainerAzureCluster#group}
    */
    readonly group: string;
}
export declare function googleContainerAzureClusterAuthorizationAdminGroupsToTerraform(struct?: GoogleContainerAzureClusterAuthorizationAdminGroups | cdktf.IResolvable): any;
export declare function googleContainerAzureClusterAuthorizationAdminGroupsToHclTerraform(struct?: GoogleContainerAzureClusterAuthorizationAdminGroups | cdktf.IResolvable): any;
export declare class GoogleContainerAzureClusterAuthorizationAdminGroupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerAzureClusterAuthorizationAdminGroups | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerAzureClusterAuthorizationAdminGroups | cdktf.IResolvable | undefined);
    private _group?;
    get group(): string;
    set group(value: string);
    get groupInput(): string | undefined;
}
export declare class GoogleContainerAzureClusterAuthorizationAdminGroupsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerAzureClusterAuthorizationAdminGroups[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerAzureClusterAuthorizationAdminGroupsOutputReference;
}
export interface GoogleContainerAzureClusterAuthorizationAdminUsers {
    /**
    * The name of the user, e.g. `my-gcp-id@gmail.com`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#username GoogleContainerAzureCluster#username}
    */
    readonly username: string;
}
export declare function googleContainerAzureClusterAuthorizationAdminUsersToTerraform(struct?: GoogleContainerAzureClusterAuthorizationAdminUsers | cdktf.IResolvable): any;
export declare function googleContainerAzureClusterAuthorizationAdminUsersToHclTerraform(struct?: GoogleContainerAzureClusterAuthorizationAdminUsers | cdktf.IResolvable): any;
export declare class GoogleContainerAzureClusterAuthorizationAdminUsersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerAzureClusterAuthorizationAdminUsers | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerAzureClusterAuthorizationAdminUsers | cdktf.IResolvable | undefined);
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export declare class GoogleContainerAzureClusterAuthorizationAdminUsersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerAzureClusterAuthorizationAdminUsers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerAzureClusterAuthorizationAdminUsersOutputReference;
}
export interface GoogleContainerAzureClusterAuthorization {
    /**
    * admin_groups block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#admin_groups GoogleContainerAzureCluster#admin_groups}
    */
    readonly adminGroups?: GoogleContainerAzureClusterAuthorizationAdminGroups[] | cdktf.IResolvable;
    /**
    * admin_users block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#admin_users GoogleContainerAzureCluster#admin_users}
    */
    readonly adminUsers: GoogleContainerAzureClusterAuthorizationAdminUsers[] | cdktf.IResolvable;
}
export declare function googleContainerAzureClusterAuthorizationToTerraform(struct?: GoogleContainerAzureClusterAuthorizationOutputReference | GoogleContainerAzureClusterAuthorization): any;
export declare function googleContainerAzureClusterAuthorizationToHclTerraform(struct?: GoogleContainerAzureClusterAuthorizationOutputReference | GoogleContainerAzureClusterAuthorization): any;
export declare class GoogleContainerAzureClusterAuthorizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAzureClusterAuthorization | undefined;
    set internalValue(value: GoogleContainerAzureClusterAuthorization | undefined);
    private _adminGroups;
    get adminGroups(): GoogleContainerAzureClusterAuthorizationAdminGroupsList;
    putAdminGroups(value: GoogleContainerAzureClusterAuthorizationAdminGroups[] | cdktf.IResolvable): void;
    resetAdminGroups(): void;
    get adminGroupsInput(): cdktf.IResolvable | GoogleContainerAzureClusterAuthorizationAdminGroups[] | undefined;
    private _adminUsers;
    get adminUsers(): GoogleContainerAzureClusterAuthorizationAdminUsersList;
    putAdminUsers(value: GoogleContainerAzureClusterAuthorizationAdminUsers[] | cdktf.IResolvable): void;
    get adminUsersInput(): cdktf.IResolvable | GoogleContainerAzureClusterAuthorizationAdminUsers[] | undefined;
}
export interface GoogleContainerAzureClusterAzureServicesAuthentication {
    /**
    * The Azure Active Directory Application ID for Authentication configuration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#application_id GoogleContainerAzureCluster#application_id}
    */
    readonly applicationId: string;
    /**
    * The Azure Active Directory Tenant ID for Authentication configuration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#tenant_id GoogleContainerAzureCluster#tenant_id}
    */
    readonly tenantId: string;
}
export declare function googleContainerAzureClusterAzureServicesAuthenticationToTerraform(struct?: GoogleContainerAzureClusterAzureServicesAuthenticationOutputReference | GoogleContainerAzureClusterAzureServicesAuthentication): any;
export declare function googleContainerAzureClusterAzureServicesAuthenticationToHclTerraform(struct?: GoogleContainerAzureClusterAzureServicesAuthenticationOutputReference | GoogleContainerAzureClusterAzureServicesAuthentication): any;
export declare class GoogleContainerAzureClusterAzureServicesAuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAzureClusterAzureServicesAuthentication | undefined;
    set internalValue(value: GoogleContainerAzureClusterAzureServicesAuthentication | undefined);
    private _applicationId?;
    get applicationId(): string;
    set applicationId(value: string);
    get applicationIdInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    get tenantIdInput(): string | undefined;
}
export interface GoogleContainerAzureClusterControlPlaneDatabaseEncryption {
    /**
    * The ARM ID of the Azure Key Vault key to encrypt / decrypt data. For example: `/subscriptions/<subscription-id>/resourceGroups/<resource-group-id>/providers/Microsoft.KeyVault/vaults/<key-vault-id>/keys/<key-name>` Encryption will always take the latest version of the key and hence specific version is not supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#key_id GoogleContainerAzureCluster#key_id}
    */
    readonly keyId: string;
}
export declare function googleContainerAzureClusterControlPlaneDatabaseEncryptionToTerraform(struct?: GoogleContainerAzureClusterControlPlaneDatabaseEncryptionOutputReference | GoogleContainerAzureClusterControlPlaneDatabaseEncryption): any;
export declare function googleContainerAzureClusterControlPlaneDatabaseEncryptionToHclTerraform(struct?: GoogleContainerAzureClusterControlPlaneDatabaseEncryptionOutputReference | GoogleContainerAzureClusterControlPlaneDatabaseEncryption): any;
export declare class GoogleContainerAzureClusterControlPlaneDatabaseEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAzureClusterControlPlaneDatabaseEncryption | undefined;
    set internalValue(value: GoogleContainerAzureClusterControlPlaneDatabaseEncryption | undefined);
    private _keyId?;
    get keyId(): string;
    set keyId(value: string);
    get keyIdInput(): string | undefined;
}
export interface GoogleContainerAzureClusterControlPlaneMainVolume {
    /**
    * Optional. The size of the disk, in GiBs. When unspecified, a default value is provided. See the specific reference in the parent resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#size_gib GoogleContainerAzureCluster#size_gib}
    */
    readonly sizeGib?: number;
}
export declare function googleContainerAzureClusterControlPlaneMainVolumeToTerraform(struct?: GoogleContainerAzureClusterControlPlaneMainVolumeOutputReference | GoogleContainerAzureClusterControlPlaneMainVolume): any;
export declare function googleContainerAzureClusterControlPlaneMainVolumeToHclTerraform(struct?: GoogleContainerAzureClusterControlPlaneMainVolumeOutputReference | GoogleContainerAzureClusterControlPlaneMainVolume): any;
export declare class GoogleContainerAzureClusterControlPlaneMainVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAzureClusterControlPlaneMainVolume | undefined;
    set internalValue(value: GoogleContainerAzureClusterControlPlaneMainVolume | undefined);
    private _sizeGib?;
    get sizeGib(): number;
    set sizeGib(value: number);
    resetSizeGib(): void;
    get sizeGibInput(): number | undefined;
}
export interface GoogleContainerAzureClusterControlPlaneProxyConfig {
    /**
    * The ARM ID the of the resource group containing proxy keyvault. Resource group ids are formatted as `/subscriptions/<subscription-id>/resourceGroups/<resource-group-name>`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#resource_group_id GoogleContainerAzureCluster#resource_group_id}
    */
    readonly resourceGroupId: string;
    /**
    * The URL the of the proxy setting secret with its version. Secret ids are formatted as `https:<key-vault-name>.vault.azure.net/secrets/<secret-name>/<secret-version>`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#secret_id GoogleContainerAzureCluster#secret_id}
    */
    readonly secretId: string;
}
export declare function googleContainerAzureClusterControlPlaneProxyConfigToTerraform(struct?: GoogleContainerAzureClusterControlPlaneProxyConfigOutputReference | GoogleContainerAzureClusterControlPlaneProxyConfig): any;
export declare function googleContainerAzureClusterControlPlaneProxyConfigToHclTerraform(struct?: GoogleContainerAzureClusterControlPlaneProxyConfigOutputReference | GoogleContainerAzureClusterControlPlaneProxyConfig): any;
export declare class GoogleContainerAzureClusterControlPlaneProxyConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAzureClusterControlPlaneProxyConfig | undefined;
    set internalValue(value: GoogleContainerAzureClusterControlPlaneProxyConfig | undefined);
    private _resourceGroupId?;
    get resourceGroupId(): string;
    set resourceGroupId(value: string);
    get resourceGroupIdInput(): string | undefined;
    private _secretId?;
    get secretId(): string;
    set secretId(value: string);
    get secretIdInput(): string | undefined;
}
export interface GoogleContainerAzureClusterControlPlaneReplicaPlacements {
    /**
    * For a given replica, the Azure availability zone where to provision the control plane VM and the ETCD disk.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#azure_availability_zone GoogleContainerAzureCluster#azure_availability_zone}
    */
    readonly azureAvailabilityZone: string;
    /**
    * For a given replica, the ARM ID of the subnet where the control plane VM is deployed. Make sure it's a subnet under the virtual network in the cluster configuration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#subnet_id GoogleContainerAzureCluster#subnet_id}
    */
    readonly subnetId: string;
}
export declare function googleContainerAzureClusterControlPlaneReplicaPlacementsToTerraform(struct?: GoogleContainerAzureClusterControlPlaneReplicaPlacements | cdktf.IResolvable): any;
export declare function googleContainerAzureClusterControlPlaneReplicaPlacementsToHclTerraform(struct?: GoogleContainerAzureClusterControlPlaneReplicaPlacements | cdktf.IResolvable): any;
export declare class GoogleContainerAzureClusterControlPlaneReplicaPlacementsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerAzureClusterControlPlaneReplicaPlacements | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerAzureClusterControlPlaneReplicaPlacements | cdktf.IResolvable | undefined);
    private _azureAvailabilityZone?;
    get azureAvailabilityZone(): string;
    set azureAvailabilityZone(value: string);
    get azureAvailabilityZoneInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
}
export declare class GoogleContainerAzureClusterControlPlaneReplicaPlacementsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerAzureClusterControlPlaneReplicaPlacements[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerAzureClusterControlPlaneReplicaPlacementsOutputReference;
}
export interface GoogleContainerAzureClusterControlPlaneRootVolume {
    /**
    * Optional. The size of the disk, in GiBs. When unspecified, a default value is provided. See the specific reference in the parent resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#size_gib GoogleContainerAzureCluster#size_gib}
    */
    readonly sizeGib?: number;
}
export declare function googleContainerAzureClusterControlPlaneRootVolumeToTerraform(struct?: GoogleContainerAzureClusterControlPlaneRootVolumeOutputReference | GoogleContainerAzureClusterControlPlaneRootVolume): any;
export declare function googleContainerAzureClusterControlPlaneRootVolumeToHclTerraform(struct?: GoogleContainerAzureClusterControlPlaneRootVolumeOutputReference | GoogleContainerAzureClusterControlPlaneRootVolume): any;
export declare class GoogleContainerAzureClusterControlPlaneRootVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAzureClusterControlPlaneRootVolume | undefined;
    set internalValue(value: GoogleContainerAzureClusterControlPlaneRootVolume | undefined);
    private _sizeGib?;
    get sizeGib(): number;
    set sizeGib(value: number);
    resetSizeGib(): void;
    get sizeGibInput(): number | undefined;
}
export interface GoogleContainerAzureClusterControlPlaneSshConfig {
    /**
    * The SSH public key data for VMs managed by Anthos. This accepts the authorized_keys file format used in OpenSSH according to the sshd(8) manual page.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#authorized_key GoogleContainerAzureCluster#authorized_key}
    */
    readonly authorizedKey: string;
}
export declare function googleContainerAzureClusterControlPlaneSshConfigToTerraform(struct?: GoogleContainerAzureClusterControlPlaneSshConfigOutputReference | GoogleContainerAzureClusterControlPlaneSshConfig): any;
export declare function googleContainerAzureClusterControlPlaneSshConfigToHclTerraform(struct?: GoogleContainerAzureClusterControlPlaneSshConfigOutputReference | GoogleContainerAzureClusterControlPlaneSshConfig): any;
export declare class GoogleContainerAzureClusterControlPlaneSshConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAzureClusterControlPlaneSshConfig | undefined;
    set internalValue(value: GoogleContainerAzureClusterControlPlaneSshConfig | undefined);
    private _authorizedKey?;
    get authorizedKey(): string;
    set authorizedKey(value: string);
    get authorizedKeyInput(): string | undefined;
}
export interface GoogleContainerAzureClusterControlPlane {
    /**
    * The ARM ID of the subnet where the control plane VMs are deployed. Example: `/subscriptions//resourceGroups//providers/Microsoft.Network/virtualNetworks//subnets/default`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#subnet_id GoogleContainerAzureCluster#subnet_id}
    */
    readonly subnetId: string;
    /**
    * Optional. A set of tags to apply to all underlying control plane Azure resources.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#tags GoogleContainerAzureCluster#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * The Kubernetes version to run on control plane replicas (e.g. `1.19.10-gke.1000`). You can list all supported versions on a given Google Cloud region by calling GetAzureServerConfig.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#version GoogleContainerAzureCluster#version}
    */
    readonly version: string;
    /**
    * Optional. The Azure VM size name. Example: `Standard_DS2_v2`. For available VM sizes, see https://docs.microsoft.com/en-us/azure/virtual-machines/vm-naming-conventions. When unspecified, it defaults to `Standard_DS2_v2`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#vm_size GoogleContainerAzureCluster#vm_size}
    */
    readonly vmSize?: string;
    /**
    * database_encryption block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#database_encryption GoogleContainerAzureCluster#database_encryption}
    */
    readonly databaseEncryption?: GoogleContainerAzureClusterControlPlaneDatabaseEncryption;
    /**
    * main_volume block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#main_volume GoogleContainerAzureCluster#main_volume}
    */
    readonly mainVolume?: GoogleContainerAzureClusterControlPlaneMainVolume;
    /**
    * proxy_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#proxy_config GoogleContainerAzureCluster#proxy_config}
    */
    readonly proxyConfig?: GoogleContainerAzureClusterControlPlaneProxyConfig;
    /**
    * replica_placements block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#replica_placements GoogleContainerAzureCluster#replica_placements}
    */
    readonly replicaPlacements?: GoogleContainerAzureClusterControlPlaneReplicaPlacements[] | cdktf.IResolvable;
    /**
    * root_volume block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#root_volume GoogleContainerAzureCluster#root_volume}
    */
    readonly rootVolume?: GoogleContainerAzureClusterControlPlaneRootVolume;
    /**
    * ssh_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#ssh_config GoogleContainerAzureCluster#ssh_config}
    */
    readonly sshConfig: GoogleContainerAzureClusterControlPlaneSshConfig;
}
export declare function googleContainerAzureClusterControlPlaneToTerraform(struct?: GoogleContainerAzureClusterControlPlaneOutputReference | GoogleContainerAzureClusterControlPlane): any;
export declare function googleContainerAzureClusterControlPlaneToHclTerraform(struct?: GoogleContainerAzureClusterControlPlaneOutputReference | GoogleContainerAzureClusterControlPlane): any;
export declare class GoogleContainerAzureClusterControlPlaneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAzureClusterControlPlane | undefined;
    set internalValue(value: GoogleContainerAzureClusterControlPlane | undefined);
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    resetVmSize(): void;
    get vmSizeInput(): string | undefined;
    private _databaseEncryption;
    get databaseEncryption(): GoogleContainerAzureClusterControlPlaneDatabaseEncryptionOutputReference;
    putDatabaseEncryption(value: GoogleContainerAzureClusterControlPlaneDatabaseEncryption): void;
    resetDatabaseEncryption(): void;
    get databaseEncryptionInput(): GoogleContainerAzureClusterControlPlaneDatabaseEncryption | undefined;
    private _mainVolume;
    get mainVolume(): GoogleContainerAzureClusterControlPlaneMainVolumeOutputReference;
    putMainVolume(value: GoogleContainerAzureClusterControlPlaneMainVolume): void;
    resetMainVolume(): void;
    get mainVolumeInput(): GoogleContainerAzureClusterControlPlaneMainVolume | undefined;
    private _proxyConfig;
    get proxyConfig(): GoogleContainerAzureClusterControlPlaneProxyConfigOutputReference;
    putProxyConfig(value: GoogleContainerAzureClusterControlPlaneProxyConfig): void;
    resetProxyConfig(): void;
    get proxyConfigInput(): GoogleContainerAzureClusterControlPlaneProxyConfig | undefined;
    private _replicaPlacements;
    get replicaPlacements(): GoogleContainerAzureClusterControlPlaneReplicaPlacementsList;
    putReplicaPlacements(value: GoogleContainerAzureClusterControlPlaneReplicaPlacements[] | cdktf.IResolvable): void;
    resetReplicaPlacements(): void;
    get replicaPlacementsInput(): cdktf.IResolvable | GoogleContainerAzureClusterControlPlaneReplicaPlacements[] | undefined;
    private _rootVolume;
    get rootVolume(): GoogleContainerAzureClusterControlPlaneRootVolumeOutputReference;
    putRootVolume(value: GoogleContainerAzureClusterControlPlaneRootVolume): void;
    resetRootVolume(): void;
    get rootVolumeInput(): GoogleContainerAzureClusterControlPlaneRootVolume | undefined;
    private _sshConfig;
    get sshConfig(): GoogleContainerAzureClusterControlPlaneSshConfigOutputReference;
    putSshConfig(value: GoogleContainerAzureClusterControlPlaneSshConfig): void;
    get sshConfigInput(): GoogleContainerAzureClusterControlPlaneSshConfig | undefined;
}
export interface GoogleContainerAzureClusterFleet {
    /**
    * The number of the Fleet host project where this cluster will be registered.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#project GoogleContainerAzureCluster#project}
    */
    readonly project?: string;
}
export declare function googleContainerAzureClusterFleetToTerraform(struct?: GoogleContainerAzureClusterFleetOutputReference | GoogleContainerAzureClusterFleet): any;
export declare function googleContainerAzureClusterFleetToHclTerraform(struct?: GoogleContainerAzureClusterFleetOutputReference | GoogleContainerAzureClusterFleet): any;
export declare class GoogleContainerAzureClusterFleetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAzureClusterFleet | undefined;
    set internalValue(value: GoogleContainerAzureClusterFleet | undefined);
    get membership(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
}
export interface GoogleContainerAzureClusterLoggingConfigComponentConfig {
    /**
    * Components of the logging configuration to be enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#enable_components GoogleContainerAzureCluster#enable_components}
    */
    readonly enableComponents?: string[];
}
export declare function googleContainerAzureClusterLoggingConfigComponentConfigToTerraform(struct?: GoogleContainerAzureClusterLoggingConfigComponentConfigOutputReference | GoogleContainerAzureClusterLoggingConfigComponentConfig): any;
export declare function googleContainerAzureClusterLoggingConfigComponentConfigToHclTerraform(struct?: GoogleContainerAzureClusterLoggingConfigComponentConfigOutputReference | GoogleContainerAzureClusterLoggingConfigComponentConfig): any;
export declare class GoogleContainerAzureClusterLoggingConfigComponentConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAzureClusterLoggingConfigComponentConfig | undefined;
    set internalValue(value: GoogleContainerAzureClusterLoggingConfigComponentConfig | undefined);
    private _enableComponents?;
    get enableComponents(): string[];
    set enableComponents(value: string[]);
    resetEnableComponents(): void;
    get enableComponentsInput(): string[] | undefined;
}
export interface GoogleContainerAzureClusterLoggingConfig {
    /**
    * component_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#component_config GoogleContainerAzureCluster#component_config}
    */
    readonly componentConfig?: GoogleContainerAzureClusterLoggingConfigComponentConfig;
}
export declare function googleContainerAzureClusterLoggingConfigToTerraform(struct?: GoogleContainerAzureClusterLoggingConfigOutputReference | GoogleContainerAzureClusterLoggingConfig): any;
export declare function googleContainerAzureClusterLoggingConfigToHclTerraform(struct?: GoogleContainerAzureClusterLoggingConfigOutputReference | GoogleContainerAzureClusterLoggingConfig): any;
export declare class GoogleContainerAzureClusterLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAzureClusterLoggingConfig | undefined;
    set internalValue(value: GoogleContainerAzureClusterLoggingConfig | undefined);
    private _componentConfig;
    get componentConfig(): GoogleContainerAzureClusterLoggingConfigComponentConfigOutputReference;
    putComponentConfig(value: GoogleContainerAzureClusterLoggingConfigComponentConfig): void;
    resetComponentConfig(): void;
    get componentConfigInput(): GoogleContainerAzureClusterLoggingConfigComponentConfig | undefined;
}
export interface GoogleContainerAzureClusterNetworking {
    /**
    * The IP address range of the pods in this cluster, in CIDR notation (e.g. `10.96.0.0/14`). All pods in the cluster get assigned a unique RFC1918 IPv4 address from these ranges. Only a single range is supported. This field cannot be changed after creation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#pod_address_cidr_blocks GoogleContainerAzureCluster#pod_address_cidr_blocks}
    */
    readonly podAddressCidrBlocks: string[];
    /**
    * The IP address range for services in this cluster, in CIDR notation (e.g. `10.96.0.0/14`). All services in the cluster get assigned a unique RFC1918 IPv4 address from these ranges. Only a single range is supported. This field cannot be changed after creating a cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#service_address_cidr_blocks GoogleContainerAzureCluster#service_address_cidr_blocks}
    */
    readonly serviceAddressCidrBlocks: string[];
    /**
    * The Azure Resource Manager (ARM) ID of the VNet associated with your cluster. All components in the cluster (i.e. control plane and node pools) run on a single VNet. Example: `/subscriptions/* /resourceGroups/* /providers/Microsoft.Network/virtualNetworks/*` This field cannot be changed after creation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#virtual_network_id GoogleContainerAzureCluster#virtual_network_id}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly virtualNetworkId: string;
}
export declare function googleContainerAzureClusterNetworkingToTerraform(struct?: GoogleContainerAzureClusterNetworkingOutputReference | GoogleContainerAzureClusterNetworking): any;
export declare function googleContainerAzureClusterNetworkingToHclTerraform(struct?: GoogleContainerAzureClusterNetworkingOutputReference | GoogleContainerAzureClusterNetworking): any;
export declare class GoogleContainerAzureClusterNetworkingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAzureClusterNetworking | undefined;
    set internalValue(value: GoogleContainerAzureClusterNetworking | undefined);
    private _podAddressCidrBlocks?;
    get podAddressCidrBlocks(): string[];
    set podAddressCidrBlocks(value: string[]);
    get podAddressCidrBlocksInput(): string[] | undefined;
    private _serviceAddressCidrBlocks?;
    get serviceAddressCidrBlocks(): string[];
    set serviceAddressCidrBlocks(value: string[]);
    get serviceAddressCidrBlocksInput(): string[] | undefined;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    get virtualNetworkIdInput(): string | undefined;
}
export interface GoogleContainerAzureClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#create GoogleContainerAzureCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#delete GoogleContainerAzureCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#update GoogleContainerAzureCluster#update}
    */
    readonly update?: string;
}
export declare function googleContainerAzureClusterTimeoutsToTerraform(struct?: GoogleContainerAzureClusterTimeouts | cdktf.IResolvable): any;
export declare function googleContainerAzureClusterTimeoutsToHclTerraform(struct?: GoogleContainerAzureClusterTimeouts | cdktf.IResolvable): any;
export declare class GoogleContainerAzureClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAzureClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerAzureClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster google_container_azure_cluster}
*/
export declare class GoogleContainerAzureCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_container_azure_cluster";
    /**
    * Generates CDKTF code for importing a GoogleContainerAzureCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleContainerAzureCluster to import
    * @param importFromId The id of the existing GoogleContainerAzureCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleContainerAzureCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_azure_cluster google_container_azure_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleContainerAzureClusterConfig
    */
    constructor(scope: Construct, id: string, config: GoogleContainerAzureClusterConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _azureRegion?;
    get azureRegion(): string;
    set azureRegion(value: string);
    get azureRegionInput(): string | undefined;
    private _client?;
    get client(): string;
    set client(value: string);
    resetClient(): void;
    get clientInput(): string | undefined;
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveAnnotations;
    get effectiveAnnotations(): cdktf.StringMap;
    get endpoint(): string;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    private _resourceGroupId?;
    get resourceGroupId(): string;
    set resourceGroupId(value: string);
    get resourceGroupIdInput(): string | undefined;
    get state(): string;
    get uid(): string;
    get updateTime(): string;
    private _workloadIdentityConfig;
    get workloadIdentityConfig(): GoogleContainerAzureClusterWorkloadIdentityConfigList;
    private _authorization;
    get authorization(): GoogleContainerAzureClusterAuthorizationOutputReference;
    putAuthorization(value: GoogleContainerAzureClusterAuthorization): void;
    get authorizationInput(): GoogleContainerAzureClusterAuthorization | undefined;
    private _azureServicesAuthentication;
    get azureServicesAuthentication(): GoogleContainerAzureClusterAzureServicesAuthenticationOutputReference;
    putAzureServicesAuthentication(value: GoogleContainerAzureClusterAzureServicesAuthentication): void;
    resetAzureServicesAuthentication(): void;
    get azureServicesAuthenticationInput(): GoogleContainerAzureClusterAzureServicesAuthentication | undefined;
    private _controlPlane;
    get controlPlane(): GoogleContainerAzureClusterControlPlaneOutputReference;
    putControlPlane(value: GoogleContainerAzureClusterControlPlane): void;
    get controlPlaneInput(): GoogleContainerAzureClusterControlPlane | undefined;
    private _fleet;
    get fleet(): GoogleContainerAzureClusterFleetOutputReference;
    putFleet(value: GoogleContainerAzureClusterFleet): void;
    get fleetInput(): GoogleContainerAzureClusterFleet | undefined;
    private _loggingConfig;
    get loggingConfig(): GoogleContainerAzureClusterLoggingConfigOutputReference;
    putLoggingConfig(value: GoogleContainerAzureClusterLoggingConfig): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): GoogleContainerAzureClusterLoggingConfig | undefined;
    private _networking;
    get networking(): GoogleContainerAzureClusterNetworkingOutputReference;
    putNetworking(value: GoogleContainerAzureClusterNetworking): void;
    get networkingInput(): GoogleContainerAzureClusterNetworking | undefined;
    private _timeouts;
    get timeouts(): GoogleContainerAzureClusterTimeoutsOutputReference;
    putTimeouts(value: GoogleContainerAzureClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleContainerAzureClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
