/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import * as cdktf from 'cdktf';
export interface GoogleContainerClusterAddonsConfigCloudrunConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#disabled GoogleContainerCluster#disabled}
    */
    readonly disabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#load_balancer_type GoogleContainerCluster#load_balancer_type}
    */
    readonly loadBalancerType?: string;
}
export declare function googleContainerClusterAddonsConfigCloudrunConfigToTerraform(struct?: GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference | GoogleContainerClusterAddonsConfigCloudrunConfig): any;
export declare function googleContainerClusterAddonsConfigCloudrunConfigToHclTerraform(struct?: GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference | GoogleContainerClusterAddonsConfigCloudrunConfig): any;
export declare class GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterAddonsConfigCloudrunConfig | undefined;
    set internalValue(value: GoogleContainerClusterAddonsConfigCloudrunConfig | undefined);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _loadBalancerType?;
    get loadBalancerType(): string;
    set loadBalancerType(value: string);
    resetLoadBalancerType(): void;
    get loadBalancerTypeInput(): string | undefined;
}
export interface GoogleContainerClusterAddonsConfigConfigConnectorConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterAddonsConfigConfigConnectorConfigToTerraform(struct?: GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference | GoogleContainerClusterAddonsConfigConfigConnectorConfig): any;
export declare function googleContainerClusterAddonsConfigConfigConnectorConfigToHclTerraform(struct?: GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference | GoogleContainerClusterAddonsConfigConfigConnectorConfig): any;
export declare class GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterAddonsConfigConfigConnectorConfig | undefined;
    set internalValue(value: GoogleContainerClusterAddonsConfigConfigConnectorConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterAddonsConfigDnsCacheConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterAddonsConfigDnsCacheConfigToTerraform(struct?: GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference | GoogleContainerClusterAddonsConfigDnsCacheConfig): any;
export declare function googleContainerClusterAddonsConfigDnsCacheConfigToHclTerraform(struct?: GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference | GoogleContainerClusterAddonsConfigDnsCacheConfig): any;
export declare class GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterAddonsConfigDnsCacheConfig | undefined;
    set internalValue(value: GoogleContainerClusterAddonsConfigDnsCacheConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigToTerraform(struct?: GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference | GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig): any;
export declare function googleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigToHclTerraform(struct?: GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference | GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig): any;
export declare class GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig | undefined;
    set internalValue(value: GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigToTerraform(struct?: GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference | GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig): any;
export declare function googleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigToHclTerraform(struct?: GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference | GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig): any;
export declare class GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig | undefined;
    set internalValue(value: GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterAddonsConfigGcsFuseCsiDriverConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterAddonsConfigGcsFuseCsiDriverConfigToTerraform(struct?: GoogleContainerClusterAddonsConfigGcsFuseCsiDriverConfigOutputReference | GoogleContainerClusterAddonsConfigGcsFuseCsiDriverConfig): any;
export declare function googleContainerClusterAddonsConfigGcsFuseCsiDriverConfigToHclTerraform(struct?: GoogleContainerClusterAddonsConfigGcsFuseCsiDriverConfigOutputReference | GoogleContainerClusterAddonsConfigGcsFuseCsiDriverConfig): any;
export declare class GoogleContainerClusterAddonsConfigGcsFuseCsiDriverConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterAddonsConfigGcsFuseCsiDriverConfig | undefined;
    set internalValue(value: GoogleContainerClusterAddonsConfigGcsFuseCsiDriverConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterAddonsConfigGkeBackupAgentConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterAddonsConfigGkeBackupAgentConfigToTerraform(struct?: GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference | GoogleContainerClusterAddonsConfigGkeBackupAgentConfig): any;
export declare function googleContainerClusterAddonsConfigGkeBackupAgentConfigToHclTerraform(struct?: GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference | GoogleContainerClusterAddonsConfigGkeBackupAgentConfig): any;
export declare class GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterAddonsConfigGkeBackupAgentConfig | undefined;
    set internalValue(value: GoogleContainerClusterAddonsConfigGkeBackupAgentConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#disabled GoogleContainerCluster#disabled}
    */
    readonly disabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterAddonsConfigHorizontalPodAutoscalingToTerraform(struct?: GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference | GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling): any;
export declare function googleContainerClusterAddonsConfigHorizontalPodAutoscalingToHclTerraform(struct?: GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference | GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling): any;
export declare class GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling | undefined;
    set internalValue(value: GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling | undefined);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterAddonsConfigHttpLoadBalancing {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#disabled GoogleContainerCluster#disabled}
    */
    readonly disabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterAddonsConfigHttpLoadBalancingToTerraform(struct?: GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference | GoogleContainerClusterAddonsConfigHttpLoadBalancing): any;
export declare function googleContainerClusterAddonsConfigHttpLoadBalancingToHclTerraform(struct?: GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference | GoogleContainerClusterAddonsConfigHttpLoadBalancing): any;
export declare class GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterAddonsConfigHttpLoadBalancing | undefined;
    set internalValue(value: GoogleContainerClusterAddonsConfigHttpLoadBalancing | undefined);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterAddonsConfigIstioConfig {
    /**
    * The authentication type between services in Istio. Available options include AUTH_MUTUAL_TLS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#auth GoogleContainerCluster#auth}
    */
    readonly auth?: string;
    /**
    * The status of the Istio addon, which makes it easy to set up Istio for services in a cluster. It is disabled by default. Set disabled = false to enable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#disabled GoogleContainerCluster#disabled}
    */
    readonly disabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterAddonsConfigIstioConfigToTerraform(struct?: GoogleContainerClusterAddonsConfigIstioConfigOutputReference | GoogleContainerClusterAddonsConfigIstioConfig): any;
export declare function googleContainerClusterAddonsConfigIstioConfigToHclTerraform(struct?: GoogleContainerClusterAddonsConfigIstioConfigOutputReference | GoogleContainerClusterAddonsConfigIstioConfig): any;
export declare class GoogleContainerClusterAddonsConfigIstioConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterAddonsConfigIstioConfig | undefined;
    set internalValue(value: GoogleContainerClusterAddonsConfigIstioConfig | undefined);
    private _auth?;
    get auth(): string;
    set auth(value: string);
    resetAuth(): void;
    get authInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterAddonsConfigKalmConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterAddonsConfigKalmConfigToTerraform(struct?: GoogleContainerClusterAddonsConfigKalmConfigOutputReference | GoogleContainerClusterAddonsConfigKalmConfig): any;
export declare function googleContainerClusterAddonsConfigKalmConfigToHclTerraform(struct?: GoogleContainerClusterAddonsConfigKalmConfigOutputReference | GoogleContainerClusterAddonsConfigKalmConfig): any;
export declare class GoogleContainerClusterAddonsConfigKalmConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterAddonsConfigKalmConfig | undefined;
    set internalValue(value: GoogleContainerClusterAddonsConfigKalmConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterAddonsConfigNetworkPolicyConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#disabled GoogleContainerCluster#disabled}
    */
    readonly disabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterAddonsConfigNetworkPolicyConfigToTerraform(struct?: GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference | GoogleContainerClusterAddonsConfigNetworkPolicyConfig): any;
export declare function googleContainerClusterAddonsConfigNetworkPolicyConfigToHclTerraform(struct?: GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference | GoogleContainerClusterAddonsConfigNetworkPolicyConfig): any;
export declare class GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterAddonsConfigNetworkPolicyConfig | undefined;
    set internalValue(value: GoogleContainerClusterAddonsConfigNetworkPolicyConfig | undefined);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterAddonsConfig {
    /**
    * cloudrun_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#cloudrun_config GoogleContainerCluster#cloudrun_config}
    */
    readonly cloudrunConfig?: GoogleContainerClusterAddonsConfigCloudrunConfig;
    /**
    * config_connector_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#config_connector_config GoogleContainerCluster#config_connector_config}
    */
    readonly configConnectorConfig?: GoogleContainerClusterAddonsConfigConfigConnectorConfig;
    /**
    * dns_cache_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#dns_cache_config GoogleContainerCluster#dns_cache_config}
    */
    readonly dnsCacheConfig?: GoogleContainerClusterAddonsConfigDnsCacheConfig;
    /**
    * gce_persistent_disk_csi_driver_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#gce_persistent_disk_csi_driver_config GoogleContainerCluster#gce_persistent_disk_csi_driver_config}
    */
    readonly gcePersistentDiskCsiDriverConfig?: GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig;
    /**
    * gcp_filestore_csi_driver_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#gcp_filestore_csi_driver_config GoogleContainerCluster#gcp_filestore_csi_driver_config}
    */
    readonly gcpFilestoreCsiDriverConfig?: GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig;
    /**
    * gcs_fuse_csi_driver_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#gcs_fuse_csi_driver_config GoogleContainerCluster#gcs_fuse_csi_driver_config}
    */
    readonly gcsFuseCsiDriverConfig?: GoogleContainerClusterAddonsConfigGcsFuseCsiDriverConfig;
    /**
    * gke_backup_agent_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#gke_backup_agent_config GoogleContainerCluster#gke_backup_agent_config}
    */
    readonly gkeBackupAgentConfig?: GoogleContainerClusterAddonsConfigGkeBackupAgentConfig;
    /**
    * horizontal_pod_autoscaling block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#horizontal_pod_autoscaling GoogleContainerCluster#horizontal_pod_autoscaling}
    */
    readonly horizontalPodAutoscaling?: GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling;
    /**
    * http_load_balancing block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#http_load_balancing GoogleContainerCluster#http_load_balancing}
    */
    readonly httpLoadBalancing?: GoogleContainerClusterAddonsConfigHttpLoadBalancing;
    /**
    * istio_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#istio_config GoogleContainerCluster#istio_config}
    */
    readonly istioConfig?: GoogleContainerClusterAddonsConfigIstioConfig;
    /**
    * kalm_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#kalm_config GoogleContainerCluster#kalm_config}
    */
    readonly kalmConfig?: GoogleContainerClusterAddonsConfigKalmConfig;
    /**
    * network_policy_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#network_policy_config GoogleContainerCluster#network_policy_config}
    */
    readonly networkPolicyConfig?: GoogleContainerClusterAddonsConfigNetworkPolicyConfig;
}
export declare function googleContainerClusterAddonsConfigToTerraform(struct?: GoogleContainerClusterAddonsConfigOutputReference | GoogleContainerClusterAddonsConfig): any;
export declare function googleContainerClusterAddonsConfigToHclTerraform(struct?: GoogleContainerClusterAddonsConfigOutputReference | GoogleContainerClusterAddonsConfig): any;
export declare class GoogleContainerClusterAddonsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterAddonsConfig | undefined;
    set internalValue(value: GoogleContainerClusterAddonsConfig | undefined);
    private _cloudrunConfig;
    get cloudrunConfig(): GoogleContainerClusterAddonsConfigCloudrunConfigOutputReference;
    putCloudrunConfig(value: GoogleContainerClusterAddonsConfigCloudrunConfig): void;
    resetCloudrunConfig(): void;
    get cloudrunConfigInput(): GoogleContainerClusterAddonsConfigCloudrunConfig | undefined;
    private _configConnectorConfig;
    get configConnectorConfig(): GoogleContainerClusterAddonsConfigConfigConnectorConfigOutputReference;
    putConfigConnectorConfig(value: GoogleContainerClusterAddonsConfigConfigConnectorConfig): void;
    resetConfigConnectorConfig(): void;
    get configConnectorConfigInput(): GoogleContainerClusterAddonsConfigConfigConnectorConfig | undefined;
    private _dnsCacheConfig;
    get dnsCacheConfig(): GoogleContainerClusterAddonsConfigDnsCacheConfigOutputReference;
    putDnsCacheConfig(value: GoogleContainerClusterAddonsConfigDnsCacheConfig): void;
    resetDnsCacheConfig(): void;
    get dnsCacheConfigInput(): GoogleContainerClusterAddonsConfigDnsCacheConfig | undefined;
    private _gcePersistentDiskCsiDriverConfig;
    get gcePersistentDiskCsiDriverConfig(): GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference;
    putGcePersistentDiskCsiDriverConfig(value: GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig): void;
    resetGcePersistentDiskCsiDriverConfig(): void;
    get gcePersistentDiskCsiDriverConfigInput(): GoogleContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig | undefined;
    private _gcpFilestoreCsiDriverConfig;
    get gcpFilestoreCsiDriverConfig(): GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference;
    putGcpFilestoreCsiDriverConfig(value: GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig): void;
    resetGcpFilestoreCsiDriverConfig(): void;
    get gcpFilestoreCsiDriverConfigInput(): GoogleContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig | undefined;
    private _gcsFuseCsiDriverConfig;
    get gcsFuseCsiDriverConfig(): GoogleContainerClusterAddonsConfigGcsFuseCsiDriverConfigOutputReference;
    putGcsFuseCsiDriverConfig(value: GoogleContainerClusterAddonsConfigGcsFuseCsiDriverConfig): void;
    resetGcsFuseCsiDriverConfig(): void;
    get gcsFuseCsiDriverConfigInput(): GoogleContainerClusterAddonsConfigGcsFuseCsiDriverConfig | undefined;
    private _gkeBackupAgentConfig;
    get gkeBackupAgentConfig(): GoogleContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference;
    putGkeBackupAgentConfig(value: GoogleContainerClusterAddonsConfigGkeBackupAgentConfig): void;
    resetGkeBackupAgentConfig(): void;
    get gkeBackupAgentConfigInput(): GoogleContainerClusterAddonsConfigGkeBackupAgentConfig | undefined;
    private _horizontalPodAutoscaling;
    get horizontalPodAutoscaling(): GoogleContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference;
    putHorizontalPodAutoscaling(value: GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling): void;
    resetHorizontalPodAutoscaling(): void;
    get horizontalPodAutoscalingInput(): GoogleContainerClusterAddonsConfigHorizontalPodAutoscaling | undefined;
    private _httpLoadBalancing;
    get httpLoadBalancing(): GoogleContainerClusterAddonsConfigHttpLoadBalancingOutputReference;
    putHttpLoadBalancing(value: GoogleContainerClusterAddonsConfigHttpLoadBalancing): void;
    resetHttpLoadBalancing(): void;
    get httpLoadBalancingInput(): GoogleContainerClusterAddonsConfigHttpLoadBalancing | undefined;
    private _istioConfig;
    get istioConfig(): GoogleContainerClusterAddonsConfigIstioConfigOutputReference;
    putIstioConfig(value: GoogleContainerClusterAddonsConfigIstioConfig): void;
    resetIstioConfig(): void;
    get istioConfigInput(): GoogleContainerClusterAddonsConfigIstioConfig | undefined;
    private _kalmConfig;
    get kalmConfig(): GoogleContainerClusterAddonsConfigKalmConfigOutputReference;
    putKalmConfig(value: GoogleContainerClusterAddonsConfigKalmConfig): void;
    resetKalmConfig(): void;
    get kalmConfigInput(): GoogleContainerClusterAddonsConfigKalmConfig | undefined;
    private _networkPolicyConfig;
    get networkPolicyConfig(): GoogleContainerClusterAddonsConfigNetworkPolicyConfigOutputReference;
    putNetworkPolicyConfig(value: GoogleContainerClusterAddonsConfigNetworkPolicyConfig): void;
    resetNetworkPolicyConfig(): void;
    get networkPolicyConfigInput(): GoogleContainerClusterAddonsConfigNetworkPolicyConfig | undefined;
}
export interface GoogleContainerClusterAuthenticatorGroupsConfig {
    /**
    * The name of the RBAC security group for use with Google security groups in Kubernetes RBAC. Group name must be in format gke-security-groups@yourdomain.com.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#security_group GoogleContainerCluster#security_group}
    */
    readonly securityGroup: string;
}
export declare function googleContainerClusterAuthenticatorGroupsConfigToTerraform(struct?: GoogleContainerClusterAuthenticatorGroupsConfigOutputReference | GoogleContainerClusterAuthenticatorGroupsConfig): any;
export declare function googleContainerClusterAuthenticatorGroupsConfigToHclTerraform(struct?: GoogleContainerClusterAuthenticatorGroupsConfigOutputReference | GoogleContainerClusterAuthenticatorGroupsConfig): any;
export declare class GoogleContainerClusterAuthenticatorGroupsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterAuthenticatorGroupsConfig | undefined;
    set internalValue(value: GoogleContainerClusterAuthenticatorGroupsConfig | undefined);
    private _securityGroup?;
    get securityGroup(): string;
    set securityGroup(value: string);
    get securityGroupInput(): string | undefined;
}
export interface GoogleContainerClusterBinaryAuthorization {
    /**
    * Enable Binary Authorization for this cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Mode of operation for Binary Authorization policy evaluation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#evaluation_mode GoogleContainerCluster#evaluation_mode}
    */
    readonly evaluationMode?: string;
}
export declare function googleContainerClusterBinaryAuthorizationToTerraform(struct?: GoogleContainerClusterBinaryAuthorizationOutputReference | GoogleContainerClusterBinaryAuthorization): any;
export declare function googleContainerClusterBinaryAuthorizationToHclTerraform(struct?: GoogleContainerClusterBinaryAuthorizationOutputReference | GoogleContainerClusterBinaryAuthorization): any;
export declare class GoogleContainerClusterBinaryAuthorizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterBinaryAuthorization | undefined;
    set internalValue(value: GoogleContainerClusterBinaryAuthorization | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _evaluationMode?;
    get evaluationMode(): string;
    set evaluationMode(value: string);
    resetEvaluationMode(): void;
    get evaluationModeInput(): string | undefined;
}
export interface GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptions {
}
export declare function googleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsToTerraform(struct?: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptions): any;
export declare function googleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsToHclTerraform(struct?: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptions): any;
export declare class GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptions | undefined;
    set internalValue(value: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptions | undefined);
    get autoUpgradeStartTime(): string;
    get description(): string;
}
export declare class GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference;
}
export interface GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement {
    /**
    * Specifies whether the node auto-repair is enabled for the node pool. If enabled, the nodes in this node pool will be monitored and, if they fail health checks too many times, an automatic repair action will be triggered.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#auto_repair GoogleContainerCluster#auto_repair}
    */
    readonly autoRepair?: boolean | cdktf.IResolvable;
    /**
    * Specifies whether node auto-upgrade is enabled for the node pool. If enabled, node auto-upgrade helps keep the nodes in your node pool up to date with the latest release version of Kubernetes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#auto_upgrade GoogleContainerCluster#auto_upgrade}
    */
    readonly autoUpgrade?: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementToTerraform(struct?: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference | GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement): any;
export declare function googleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementToHclTerraform(struct?: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference | GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement): any;
export declare class GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement | undefined;
    set internalValue(value: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement | undefined);
    private _autoRepair?;
    get autoRepair(): boolean | cdktf.IResolvable;
    set autoRepair(value: boolean | cdktf.IResolvable);
    resetAutoRepair(): void;
    get autoRepairInput(): boolean | cdktf.IResolvable | undefined;
    private _autoUpgrade?;
    get autoUpgrade(): boolean | cdktf.IResolvable;
    set autoUpgrade(value: boolean | cdktf.IResolvable);
    resetAutoUpgrade(): void;
    get autoUpgradeInput(): boolean | cdktf.IResolvable | undefined;
    private _upgradeOptions;
    get upgradeOptions(): GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList;
}
export interface GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig {
    /**
    * Defines whether the instance has integrity monitoring enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enable_integrity_monitoring GoogleContainerCluster#enable_integrity_monitoring}
    */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Defines whether the instance has Secure Boot enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enable_secure_boot GoogleContainerCluster#enable_secure_boot}
    */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigToTerraform(struct?: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference | GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig): any;
export declare function googleContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigToHclTerraform(struct?: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference | GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig): any;
export declare class GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig | undefined;
    set internalValue(value: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy {
    /**
    * Number of blue nodes to drain in a batch.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#batch_node_count GoogleContainerCluster#batch_node_count}
    */
    readonly batchNodeCount?: number;
    /**
    * Percentage of the bool pool nodes to drain in a batch. The range of this field should be (0.0, 1.0].
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#batch_percentage GoogleContainerCluster#batch_percentage}
    */
    readonly batchPercentage?: number;
    /**
    * Soak time after each batch gets drained.
    *
    * 																			A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#batch_soak_duration GoogleContainerCluster#batch_soak_duration}
    */
    readonly batchSoakDuration?: string;
}
export declare function googleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyToTerraform(struct?: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference | GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy): any;
export declare function googleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyToHclTerraform(struct?: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference | GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy): any;
export declare class GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy | undefined;
    set internalValue(value: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy | undefined);
    private _batchNodeCount?;
    get batchNodeCount(): number;
    set batchNodeCount(value: number);
    resetBatchNodeCount(): void;
    get batchNodeCountInput(): number | undefined;
    private _batchPercentage?;
    get batchPercentage(): number;
    set batchPercentage(value: number);
    resetBatchPercentage(): void;
    get batchPercentageInput(): number | undefined;
    private _batchSoakDuration?;
    get batchSoakDuration(): string;
    set batchSoakDuration(value: string);
    resetBatchSoakDuration(): void;
    get batchSoakDurationInput(): string | undefined;
}
export interface GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings {
    /**
    * Time needed after draining entire blue pool. After this period, blue pool will be cleaned up.
    *
    * 																A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#node_pool_soak_duration GoogleContainerCluster#node_pool_soak_duration}
    */
    readonly nodePoolSoakDuration?: string;
    /**
    * standard_rollout_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#standard_rollout_policy GoogleContainerCluster#standard_rollout_policy}
    */
    readonly standardRolloutPolicy?: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy;
}
export declare function googleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsToTerraform(struct?: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference | GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings): any;
export declare function googleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsToHclTerraform(struct?: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference | GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings): any;
export declare class GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings | undefined;
    set internalValue(value: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings | undefined);
    private _nodePoolSoakDuration?;
    get nodePoolSoakDuration(): string;
    set nodePoolSoakDuration(value: string);
    resetNodePoolSoakDuration(): void;
    get nodePoolSoakDurationInput(): string | undefined;
    private _standardRolloutPolicy;
    get standardRolloutPolicy(): GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference;
    putStandardRolloutPolicy(value: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy): void;
    resetStandardRolloutPolicy(): void;
    get standardRolloutPolicyInput(): GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy | undefined;
}
export interface GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings {
    /**
    * The maximum number of nodes that can be created beyond the current size of the node pool during the upgrade process.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#max_surge GoogleContainerCluster#max_surge}
    */
    readonly maxSurge?: number;
    /**
    * The maximum number of nodes that can be simultaneously unavailable during the upgrade process.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#max_unavailable GoogleContainerCluster#max_unavailable}
    */
    readonly maxUnavailable?: number;
    /**
    * Update strategy of the node pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#strategy GoogleContainerCluster#strategy}
    */
    readonly strategy?: string;
    /**
    * blue_green_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#blue_green_settings GoogleContainerCluster#blue_green_settings}
    */
    readonly blueGreenSettings?: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings;
}
export declare function googleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsToTerraform(struct?: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference | GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings): any;
export declare function googleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsToHclTerraform(struct?: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference | GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings): any;
export declare class GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings | undefined;
    set internalValue(value: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings | undefined);
    private _maxSurge?;
    get maxSurge(): number;
    set maxSurge(value: number);
    resetMaxSurge(): void;
    get maxSurgeInput(): number | undefined;
    private _maxUnavailable?;
    get maxUnavailable(): number;
    set maxUnavailable(value: number);
    resetMaxUnavailable(): void;
    get maxUnavailableInput(): number | undefined;
    private _strategy?;
    get strategy(): string;
    set strategy(value: string);
    resetStrategy(): void;
    get strategyInput(): string | undefined;
    private _blueGreenSettings;
    get blueGreenSettings(): GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference;
    putBlueGreenSettings(value: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings): void;
    resetBlueGreenSettings(): void;
    get blueGreenSettingsInput(): GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings | undefined;
}
export interface GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults {
    /**
    * The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#boot_disk_kms_key GoogleContainerCluster#boot_disk_kms_key}
    */
    readonly bootDiskKmsKey?: string;
    /**
    * Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#disk_size GoogleContainerCluster#disk_size}
    */
    readonly diskSize?: number;
    /**
    * Type of the disk attached to each node.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#disk_type GoogleContainerCluster#disk_type}
    */
    readonly diskType?: string;
    /**
    * The default image type used by NAP once a new node pool is being created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#image_type GoogleContainerCluster#image_type}
    */
    readonly imageType?: string;
    /**
    * Minimum CPU platform to be used by this instance. The instance may be scheduled on the specified or newer CPU platform. Applicable values are the friendly names of CPU platforms, such as Intel Haswell.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#min_cpu_platform GoogleContainerCluster#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * Scopes that are used by NAP when creating node pools.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#oauth_scopes GoogleContainerCluster#oauth_scopes}
    */
    readonly oauthScopes?: string[];
    /**
    * The Google Cloud Platform Service Account to be used by the node VMs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#service_account GoogleContainerCluster#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * management block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#management GoogleContainerCluster#management}
    */
    readonly management?: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement;
    /**
    * shielded_instance_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#shielded_instance_config GoogleContainerCluster#shielded_instance_config}
    */
    readonly shieldedInstanceConfig?: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig;
    /**
    * upgrade_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#upgrade_settings GoogleContainerCluster#upgrade_settings}
    */
    readonly upgradeSettings?: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings;
}
export declare function googleContainerClusterClusterAutoscalingAutoProvisioningDefaultsToTerraform(struct?: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference | GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults): any;
export declare function googleContainerClusterClusterAutoscalingAutoProvisioningDefaultsToHclTerraform(struct?: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference | GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults): any;
export declare class GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults | undefined;
    set internalValue(value: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults | undefined);
    private _bootDiskKmsKey?;
    get bootDiskKmsKey(): string;
    set bootDiskKmsKey(value: string);
    resetBootDiskKmsKey(): void;
    get bootDiskKmsKeyInput(): string | undefined;
    private _diskSize?;
    get diskSize(): number;
    set diskSize(value: number);
    resetDiskSize(): void;
    get diskSizeInput(): number | undefined;
    private _diskType?;
    get diskType(): string;
    set diskType(value: string);
    resetDiskType(): void;
    get diskTypeInput(): string | undefined;
    private _imageType?;
    get imageType(): string;
    set imageType(value: string);
    resetImageType(): void;
    get imageTypeInput(): string | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _management;
    get management(): GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference;
    putManagement(value: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement): void;
    resetManagement(): void;
    get managementInput(): GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement | undefined;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig | undefined;
    private _upgradeSettings;
    get upgradeSettings(): GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference;
    putUpgradeSettings(value: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings): void;
    resetUpgradeSettings(): void;
    get upgradeSettingsInput(): GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings | undefined;
}
export interface GoogleContainerClusterClusterAutoscalingResourceLimits {
    /**
    * Maximum amount of the resource in the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#maximum GoogleContainerCluster#maximum}
    */
    readonly maximum?: number;
    /**
    * Minimum amount of the resource in the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#minimum GoogleContainerCluster#minimum}
    */
    readonly minimum?: number;
    /**
    * The type of the resource. For example, cpu and memory. See the guide to using Node Auto-Provisioning for a list of types.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#resource_type GoogleContainerCluster#resource_type}
    */
    readonly resourceType: string;
}
export declare function googleContainerClusterClusterAutoscalingResourceLimitsToTerraform(struct?: GoogleContainerClusterClusterAutoscalingResourceLimits | cdktf.IResolvable): any;
export declare function googleContainerClusterClusterAutoscalingResourceLimitsToHclTerraform(struct?: GoogleContainerClusterClusterAutoscalingResourceLimits | cdktf.IResolvable): any;
export declare class GoogleContainerClusterClusterAutoscalingResourceLimitsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerClusterClusterAutoscalingResourceLimits | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerClusterClusterAutoscalingResourceLimits | cdktf.IResolvable | undefined);
    private _maximum?;
    get maximum(): number;
    set maximum(value: number);
    resetMaximum(): void;
    get maximumInput(): number | undefined;
    private _minimum?;
    get minimum(): number;
    set minimum(value: number);
    resetMinimum(): void;
    get minimumInput(): number | undefined;
    private _resourceType?;
    get resourceType(): string;
    set resourceType(value: string);
    get resourceTypeInput(): string | undefined;
}
export declare class GoogleContainerClusterClusterAutoscalingResourceLimitsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerClusterClusterAutoscalingResourceLimits[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerClusterClusterAutoscalingResourceLimitsOutputReference;
}
export interface GoogleContainerClusterClusterAutoscaling {
    /**
    * Configuration options for the Autoscaling profile feature, which lets you choose whether the cluster autoscaler should optimize for resource utilization or resource availability when deciding to remove nodes from a cluster. Can be BALANCED or OPTIMIZE_UTILIZATION. Defaults to BALANCED.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#autoscaling_profile GoogleContainerCluster#autoscaling_profile}
    */
    readonly autoscalingProfile?: string;
    /**
    * Whether node auto-provisioning is enabled. Resource limits for cpu and memory must be defined to enable node auto-provisioning.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * auto_provisioning_defaults block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#auto_provisioning_defaults GoogleContainerCluster#auto_provisioning_defaults}
    */
    readonly autoProvisioningDefaults?: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults;
    /**
    * resource_limits block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#resource_limits GoogleContainerCluster#resource_limits}
    */
    readonly resourceLimits?: GoogleContainerClusterClusterAutoscalingResourceLimits[] | cdktf.IResolvable;
}
export declare function googleContainerClusterClusterAutoscalingToTerraform(struct?: GoogleContainerClusterClusterAutoscalingOutputReference | GoogleContainerClusterClusterAutoscaling): any;
export declare function googleContainerClusterClusterAutoscalingToHclTerraform(struct?: GoogleContainerClusterClusterAutoscalingOutputReference | GoogleContainerClusterClusterAutoscaling): any;
export declare class GoogleContainerClusterClusterAutoscalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterClusterAutoscaling | undefined;
    set internalValue(value: GoogleContainerClusterClusterAutoscaling | undefined);
    private _autoscalingProfile?;
    get autoscalingProfile(): string;
    set autoscalingProfile(value: string);
    resetAutoscalingProfile(): void;
    get autoscalingProfileInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _autoProvisioningDefaults;
    get autoProvisioningDefaults(): GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference;
    putAutoProvisioningDefaults(value: GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults): void;
    resetAutoProvisioningDefaults(): void;
    get autoProvisioningDefaultsInput(): GoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults | undefined;
    private _resourceLimits;
    get resourceLimits(): GoogleContainerClusterClusterAutoscalingResourceLimitsList;
    putResourceLimits(value: GoogleContainerClusterClusterAutoscalingResourceLimits[] | cdktf.IResolvable): void;
    resetResourceLimits(): void;
    get resourceLimitsInput(): cdktf.IResolvable | GoogleContainerClusterClusterAutoscalingResourceLimits[] | undefined;
}
export interface GoogleContainerClusterClusterTelemetry {
    /**
    * Type of the integration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#type GoogleContainerCluster#type}
    */
    readonly type: string;
}
export declare function googleContainerClusterClusterTelemetryToTerraform(struct?: GoogleContainerClusterClusterTelemetryOutputReference | GoogleContainerClusterClusterTelemetry): any;
export declare function googleContainerClusterClusterTelemetryToHclTerraform(struct?: GoogleContainerClusterClusterTelemetryOutputReference | GoogleContainerClusterClusterTelemetry): any;
export declare class GoogleContainerClusterClusterTelemetryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterClusterTelemetry | undefined;
    set internalValue(value: GoogleContainerClusterClusterTelemetry | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface GoogleContainerClusterConfidentialNodes {
    /**
    * Whether Confidential Nodes feature is enabled for all nodes in this cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterConfidentialNodesToTerraform(struct?: GoogleContainerClusterConfidentialNodesOutputReference | GoogleContainerClusterConfidentialNodes): any;
export declare function googleContainerClusterConfidentialNodesToHclTerraform(struct?: GoogleContainerClusterConfidentialNodesOutputReference | GoogleContainerClusterConfidentialNodes): any;
export declare class GoogleContainerClusterConfidentialNodesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterConfidentialNodes | undefined;
    set internalValue(value: GoogleContainerClusterConfidentialNodes | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterCostManagementConfig {
    /**
    * Whether to enable GKE cost allocation. When you enable GKE cost allocation, the cluster name and namespace of your GKE workloads appear in the labels field of the billing export to BigQuery. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterCostManagementConfigToTerraform(struct?: GoogleContainerClusterCostManagementConfigOutputReference | GoogleContainerClusterCostManagementConfig): any;
export declare function googleContainerClusterCostManagementConfigToHclTerraform(struct?: GoogleContainerClusterCostManagementConfigOutputReference | GoogleContainerClusterCostManagementConfig): any;
export declare class GoogleContainerClusterCostManagementConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterCostManagementConfig | undefined;
    set internalValue(value: GoogleContainerClusterCostManagementConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterDatabaseEncryption {
    /**
    * The key to use to encrypt/decrypt secrets.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#key_name GoogleContainerCluster#key_name}
    */
    readonly keyName?: string;
    /**
    * ENCRYPTED or DECRYPTED.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#state GoogleContainerCluster#state}
    */
    readonly state: string;
}
export declare function googleContainerClusterDatabaseEncryptionToTerraform(struct?: GoogleContainerClusterDatabaseEncryptionOutputReference | GoogleContainerClusterDatabaseEncryption): any;
export declare function googleContainerClusterDatabaseEncryptionToHclTerraform(struct?: GoogleContainerClusterDatabaseEncryptionOutputReference | GoogleContainerClusterDatabaseEncryption): any;
export declare class GoogleContainerClusterDatabaseEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterDatabaseEncryption | undefined;
    set internalValue(value: GoogleContainerClusterDatabaseEncryption | undefined);
    private _keyName?;
    get keyName(): string;
    set keyName(value: string);
    resetKeyName(): void;
    get keyNameInput(): string | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    get stateInput(): string | undefined;
}
export interface GoogleContainerClusterDefaultSnatStatus {
    /**
    * When disabled is set to false, default IP masquerade rules will be applied to the nodes to prevent sNAT on cluster internal traffic.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#disabled GoogleContainerCluster#disabled}
    */
    readonly disabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterDefaultSnatStatusToTerraform(struct?: GoogleContainerClusterDefaultSnatStatusOutputReference | GoogleContainerClusterDefaultSnatStatus): any;
export declare function googleContainerClusterDefaultSnatStatusToHclTerraform(struct?: GoogleContainerClusterDefaultSnatStatusOutputReference | GoogleContainerClusterDefaultSnatStatus): any;
export declare class GoogleContainerClusterDefaultSnatStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterDefaultSnatStatus | undefined;
    set internalValue(value: GoogleContainerClusterDefaultSnatStatus | undefined);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterDnsConfig {
    /**
    * Which in-cluster DNS provider should be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#cluster_dns GoogleContainerCluster#cluster_dns}
    */
    readonly clusterDns?: string;
    /**
    * The suffix used for all cluster service records.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#cluster_dns_domain GoogleContainerCluster#cluster_dns_domain}
    */
    readonly clusterDnsDomain?: string;
    /**
    * The scope of access to cluster DNS records.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#cluster_dns_scope GoogleContainerCluster#cluster_dns_scope}
    */
    readonly clusterDnsScope?: string;
}
export declare function googleContainerClusterDnsConfigToTerraform(struct?: GoogleContainerClusterDnsConfigOutputReference | GoogleContainerClusterDnsConfig): any;
export declare function googleContainerClusterDnsConfigToHclTerraform(struct?: GoogleContainerClusterDnsConfigOutputReference | GoogleContainerClusterDnsConfig): any;
export declare class GoogleContainerClusterDnsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterDnsConfig | undefined;
    set internalValue(value: GoogleContainerClusterDnsConfig | undefined);
    private _clusterDns?;
    get clusterDns(): string;
    set clusterDns(value: string);
    resetClusterDns(): void;
    get clusterDnsInput(): string | undefined;
    private _clusterDnsDomain?;
    get clusterDnsDomain(): string;
    set clusterDnsDomain(value: string);
    resetClusterDnsDomain(): void;
    get clusterDnsDomainInput(): string | undefined;
    private _clusterDnsScope?;
    get clusterDnsScope(): string;
    set clusterDnsScope(value: string);
    resetClusterDnsScope(): void;
    get clusterDnsScopeInput(): string | undefined;
}
export interface GoogleContainerClusterEnableK8SBetaApis {
    /**
    * Enabled Kubernetes Beta APIs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled_apis GoogleContainerCluster#enabled_apis}
    */
    readonly enabledApis: string[];
}
export declare function googleContainerClusterEnableK8SBetaApisToTerraform(struct?: GoogleContainerClusterEnableK8SBetaApisOutputReference | GoogleContainerClusterEnableK8SBetaApis): any;
export declare function googleContainerClusterEnableK8SBetaApisToHclTerraform(struct?: GoogleContainerClusterEnableK8SBetaApisOutputReference | GoogleContainerClusterEnableK8SBetaApis): any;
export declare class GoogleContainerClusterEnableK8SBetaApisOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterEnableK8SBetaApis | undefined;
    set internalValue(value: GoogleContainerClusterEnableK8SBetaApis | undefined);
    private _enabledApis?;
    get enabledApis(): string[];
    set enabledApis(value: string[]);
    get enabledApisInput(): string[] | undefined;
}
export interface GoogleContainerClusterFleet {
    /**
    * The Fleet host project of the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#project GoogleContainerCluster#project}
    */
    readonly project?: string;
}
export declare function googleContainerClusterFleetToTerraform(struct?: GoogleContainerClusterFleetOutputReference | GoogleContainerClusterFleet): any;
export declare function googleContainerClusterFleetToHclTerraform(struct?: GoogleContainerClusterFleetOutputReference | GoogleContainerClusterFleet): any;
export declare class GoogleContainerClusterFleetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterFleet | undefined;
    set internalValue(value: GoogleContainerClusterFleet | undefined);
    get membership(): string;
    get membershipId(): string;
    get membershipLocation(): string;
    get preRegistered(): cdktf.IResolvable;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
}
export interface GoogleContainerClusterGatewayApiConfig {
    /**
    * The Gateway API release channel to use for Gateway API.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#channel GoogleContainerCluster#channel}
    */
    readonly channel: string;
}
export declare function googleContainerClusterGatewayApiConfigToTerraform(struct?: GoogleContainerClusterGatewayApiConfigOutputReference | GoogleContainerClusterGatewayApiConfig): any;
export declare function googleContainerClusterGatewayApiConfigToHclTerraform(struct?: GoogleContainerClusterGatewayApiConfigOutputReference | GoogleContainerClusterGatewayApiConfig): any;
export declare class GoogleContainerClusterGatewayApiConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterGatewayApiConfig | undefined;
    set internalValue(value: GoogleContainerClusterGatewayApiConfig | undefined);
    private _channel?;
    get channel(): string;
    set channel(value: string);
    get channelInput(): string | undefined;
}
export interface GoogleContainerClusterIdentityServiceConfig {
    /**
    * Whether to enable the Identity Service component.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterIdentityServiceConfigToTerraform(struct?: GoogleContainerClusterIdentityServiceConfigOutputReference | GoogleContainerClusterIdentityServiceConfig): any;
export declare function googleContainerClusterIdentityServiceConfigToHclTerraform(struct?: GoogleContainerClusterIdentityServiceConfigOutputReference | GoogleContainerClusterIdentityServiceConfig): any;
export declare class GoogleContainerClusterIdentityServiceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterIdentityServiceConfig | undefined;
    set internalValue(value: GoogleContainerClusterIdentityServiceConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterIpAllocationPolicyAdditionalPodRangesConfig {
    /**
    * Name for pod secondary ipv4 range which has the actual range defined ahead.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#pod_range_names GoogleContainerCluster#pod_range_names}
    */
    readonly podRangeNames: string[];
}
export declare function googleContainerClusterIpAllocationPolicyAdditionalPodRangesConfigToTerraform(struct?: GoogleContainerClusterIpAllocationPolicyAdditionalPodRangesConfigOutputReference | GoogleContainerClusterIpAllocationPolicyAdditionalPodRangesConfig): any;
export declare function googleContainerClusterIpAllocationPolicyAdditionalPodRangesConfigToHclTerraform(struct?: GoogleContainerClusterIpAllocationPolicyAdditionalPodRangesConfigOutputReference | GoogleContainerClusterIpAllocationPolicyAdditionalPodRangesConfig): any;
export declare class GoogleContainerClusterIpAllocationPolicyAdditionalPodRangesConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterIpAllocationPolicyAdditionalPodRangesConfig | undefined;
    set internalValue(value: GoogleContainerClusterIpAllocationPolicyAdditionalPodRangesConfig | undefined);
    private _podRangeNames?;
    get podRangeNames(): string[];
    set podRangeNames(value: string[]);
    get podRangeNamesInput(): string[] | undefined;
}
export interface GoogleContainerClusterIpAllocationPolicyPodCidrOverprovisionConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#disabled GoogleContainerCluster#disabled}
    */
    readonly disabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterIpAllocationPolicyPodCidrOverprovisionConfigToTerraform(struct?: GoogleContainerClusterIpAllocationPolicyPodCidrOverprovisionConfigOutputReference | GoogleContainerClusterIpAllocationPolicyPodCidrOverprovisionConfig): any;
export declare function googleContainerClusterIpAllocationPolicyPodCidrOverprovisionConfigToHclTerraform(struct?: GoogleContainerClusterIpAllocationPolicyPodCidrOverprovisionConfigOutputReference | GoogleContainerClusterIpAllocationPolicyPodCidrOverprovisionConfig): any;
export declare class GoogleContainerClusterIpAllocationPolicyPodCidrOverprovisionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterIpAllocationPolicyPodCidrOverprovisionConfig | undefined;
    set internalValue(value: GoogleContainerClusterIpAllocationPolicyPodCidrOverprovisionConfig | undefined);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterIpAllocationPolicy {
    /**
    * The IP address range for the cluster pod IPs. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. /14) to have a range chosen with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#cluster_ipv4_cidr_block GoogleContainerCluster#cluster_ipv4_cidr_block}
    */
    readonly clusterIpv4CidrBlock?: string;
    /**
    * The name of the existing secondary range in the cluster's subnetwork to use for pod IP addresses. Alternatively, cluster_ipv4_cidr_block can be used to automatically create a GKE-managed one.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#cluster_secondary_range_name GoogleContainerCluster#cluster_secondary_range_name}
    */
    readonly clusterSecondaryRangeName?: string;
    /**
    * The IP address range of the services IPs in this cluster. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. /14) to have a range chosen with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#services_ipv4_cidr_block GoogleContainerCluster#services_ipv4_cidr_block}
    */
    readonly servicesIpv4CidrBlock?: string;
    /**
    * The name of the existing secondary range in the cluster's subnetwork to use for service ClusterIPs. Alternatively, services_ipv4_cidr_block can be used to automatically create a GKE-managed one.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#services_secondary_range_name GoogleContainerCluster#services_secondary_range_name}
    */
    readonly servicesSecondaryRangeName?: string;
    /**
    * The IP Stack type of the cluster. Choose between IPV4 and IPV4_IPV6. Default type is IPV4 Only if not set
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#stack_type GoogleContainerCluster#stack_type}
    */
    readonly stackType?: string;
    /**
    * additional_pod_ranges_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#additional_pod_ranges_config GoogleContainerCluster#additional_pod_ranges_config}
    */
    readonly additionalPodRangesConfig?: GoogleContainerClusterIpAllocationPolicyAdditionalPodRangesConfig;
    /**
    * pod_cidr_overprovision_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#pod_cidr_overprovision_config GoogleContainerCluster#pod_cidr_overprovision_config}
    */
    readonly podCidrOverprovisionConfig?: GoogleContainerClusterIpAllocationPolicyPodCidrOverprovisionConfig;
}
export declare function googleContainerClusterIpAllocationPolicyToTerraform(struct?: GoogleContainerClusterIpAllocationPolicyOutputReference | GoogleContainerClusterIpAllocationPolicy): any;
export declare function googleContainerClusterIpAllocationPolicyToHclTerraform(struct?: GoogleContainerClusterIpAllocationPolicyOutputReference | GoogleContainerClusterIpAllocationPolicy): any;
export declare class GoogleContainerClusterIpAllocationPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterIpAllocationPolicy | undefined;
    set internalValue(value: GoogleContainerClusterIpAllocationPolicy | undefined);
    private _clusterIpv4CidrBlock?;
    get clusterIpv4CidrBlock(): string;
    set clusterIpv4CidrBlock(value: string);
    resetClusterIpv4CidrBlock(): void;
    get clusterIpv4CidrBlockInput(): string | undefined;
    private _clusterSecondaryRangeName?;
    get clusterSecondaryRangeName(): string;
    set clusterSecondaryRangeName(value: string);
    resetClusterSecondaryRangeName(): void;
    get clusterSecondaryRangeNameInput(): string | undefined;
    private _servicesIpv4CidrBlock?;
    get servicesIpv4CidrBlock(): string;
    set servicesIpv4CidrBlock(value: string);
    resetServicesIpv4CidrBlock(): void;
    get servicesIpv4CidrBlockInput(): string | undefined;
    private _servicesSecondaryRangeName?;
    get servicesSecondaryRangeName(): string;
    set servicesSecondaryRangeName(value: string);
    resetServicesSecondaryRangeName(): void;
    get servicesSecondaryRangeNameInput(): string | undefined;
    private _stackType?;
    get stackType(): string;
    set stackType(value: string);
    resetStackType(): void;
    get stackTypeInput(): string | undefined;
    private _additionalPodRangesConfig;
    get additionalPodRangesConfig(): GoogleContainerClusterIpAllocationPolicyAdditionalPodRangesConfigOutputReference;
    putAdditionalPodRangesConfig(value: GoogleContainerClusterIpAllocationPolicyAdditionalPodRangesConfig): void;
    resetAdditionalPodRangesConfig(): void;
    get additionalPodRangesConfigInput(): GoogleContainerClusterIpAllocationPolicyAdditionalPodRangesConfig | undefined;
    private _podCidrOverprovisionConfig;
    get podCidrOverprovisionConfig(): GoogleContainerClusterIpAllocationPolicyPodCidrOverprovisionConfigOutputReference;
    putPodCidrOverprovisionConfig(value: GoogleContainerClusterIpAllocationPolicyPodCidrOverprovisionConfig): void;
    resetPodCidrOverprovisionConfig(): void;
    get podCidrOverprovisionConfigInput(): GoogleContainerClusterIpAllocationPolicyPodCidrOverprovisionConfig | undefined;
}
export interface GoogleContainerClusterLoggingConfig {
    /**
    * GKE components exposing logs. Valid values include SYSTEM_COMPONENTS, APISERVER, CONTROLLER_MANAGER, SCHEDULER, and WORKLOADS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enable_components GoogleContainerCluster#enable_components}
    */
    readonly enableComponents: string[];
}
export declare function googleContainerClusterLoggingConfigToTerraform(struct?: GoogleContainerClusterLoggingConfigOutputReference | GoogleContainerClusterLoggingConfig): any;
export declare function googleContainerClusterLoggingConfigToHclTerraform(struct?: GoogleContainerClusterLoggingConfigOutputReference | GoogleContainerClusterLoggingConfig): any;
export declare class GoogleContainerClusterLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterLoggingConfig | undefined;
    set internalValue(value: GoogleContainerClusterLoggingConfig | undefined);
    private _enableComponents?;
    get enableComponents(): string[];
    set enableComponents(value: string[]);
    get enableComponentsInput(): string[] | undefined;
}
export interface GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#start_time GoogleContainerCluster#start_time}
    */
    readonly startTime: string;
}
export declare function googleContainerClusterMaintenancePolicyDailyMaintenanceWindowToTerraform(struct?: GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindowOutputReference | GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow): any;
export declare function googleContainerClusterMaintenancePolicyDailyMaintenanceWindowToHclTerraform(struct?: GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindowOutputReference | GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow): any;
export declare class GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow | undefined;
    set internalValue(value: GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow | undefined);
    get duration(): string;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    get startTimeInput(): string | undefined;
}
export interface GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions {
    /**
    * The scope of automatic upgrades to restrict in the exclusion window.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#scope GoogleContainerCluster#scope}
    */
    readonly scope: string;
}
export declare function googleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptionsToTerraform(struct?: GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptionsOutputReference | GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions): any;
export declare function googleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptionsToHclTerraform(struct?: GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptionsOutputReference | GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions): any;
export declare class GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions | undefined;
    set internalValue(value: GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions | undefined);
    private _scope?;
    get scope(): string;
    set scope(value: string);
    get scopeInput(): string | undefined;
}
export interface GoogleContainerClusterMaintenancePolicyMaintenanceExclusion {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#end_time GoogleContainerCluster#end_time}
    */
    readonly endTime: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#exclusion_name GoogleContainerCluster#exclusion_name}
    */
    readonly exclusionName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#start_time GoogleContainerCluster#start_time}
    */
    readonly startTime: string;
    /**
    * exclusion_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#exclusion_options GoogleContainerCluster#exclusion_options}
    */
    readonly exclusionOptions?: GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions;
}
export declare function googleContainerClusterMaintenancePolicyMaintenanceExclusionToTerraform(struct?: GoogleContainerClusterMaintenancePolicyMaintenanceExclusion | cdktf.IResolvable): any;
export declare function googleContainerClusterMaintenancePolicyMaintenanceExclusionToHclTerraform(struct?: GoogleContainerClusterMaintenancePolicyMaintenanceExclusion | cdktf.IResolvable): any;
export declare class GoogleContainerClusterMaintenancePolicyMaintenanceExclusionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerClusterMaintenancePolicyMaintenanceExclusion | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerClusterMaintenancePolicyMaintenanceExclusion | cdktf.IResolvable | undefined);
    private _endTime?;
    get endTime(): string;
    set endTime(value: string);
    get endTimeInput(): string | undefined;
    private _exclusionName?;
    get exclusionName(): string;
    set exclusionName(value: string);
    get exclusionNameInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    get startTimeInput(): string | undefined;
    private _exclusionOptions;
    get exclusionOptions(): GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptionsOutputReference;
    putExclusionOptions(value: GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions): void;
    resetExclusionOptions(): void;
    get exclusionOptionsInput(): GoogleContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions | undefined;
}
export declare class GoogleContainerClusterMaintenancePolicyMaintenanceExclusionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerClusterMaintenancePolicyMaintenanceExclusion[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerClusterMaintenancePolicyMaintenanceExclusionOutputReference;
}
export interface GoogleContainerClusterMaintenancePolicyRecurringWindow {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#end_time GoogleContainerCluster#end_time}
    */
    readonly endTime: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#recurrence GoogleContainerCluster#recurrence}
    */
    readonly recurrence: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#start_time GoogleContainerCluster#start_time}
    */
    readonly startTime: string;
}
export declare function googleContainerClusterMaintenancePolicyRecurringWindowToTerraform(struct?: GoogleContainerClusterMaintenancePolicyRecurringWindowOutputReference | GoogleContainerClusterMaintenancePolicyRecurringWindow): any;
export declare function googleContainerClusterMaintenancePolicyRecurringWindowToHclTerraform(struct?: GoogleContainerClusterMaintenancePolicyRecurringWindowOutputReference | GoogleContainerClusterMaintenancePolicyRecurringWindow): any;
export declare class GoogleContainerClusterMaintenancePolicyRecurringWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterMaintenancePolicyRecurringWindow | undefined;
    set internalValue(value: GoogleContainerClusterMaintenancePolicyRecurringWindow | undefined);
    private _endTime?;
    get endTime(): string;
    set endTime(value: string);
    get endTimeInput(): string | undefined;
    private _recurrence?;
    get recurrence(): string;
    set recurrence(value: string);
    get recurrenceInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    get startTimeInput(): string | undefined;
}
export interface GoogleContainerClusterMaintenancePolicy {
    /**
    * daily_maintenance_window block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#daily_maintenance_window GoogleContainerCluster#daily_maintenance_window}
    */
    readonly dailyMaintenanceWindow?: GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow;
    /**
    * maintenance_exclusion block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#maintenance_exclusion GoogleContainerCluster#maintenance_exclusion}
    */
    readonly maintenanceExclusion?: GoogleContainerClusterMaintenancePolicyMaintenanceExclusion[] | cdktf.IResolvable;
    /**
    * recurring_window block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#recurring_window GoogleContainerCluster#recurring_window}
    */
    readonly recurringWindow?: GoogleContainerClusterMaintenancePolicyRecurringWindow;
}
export declare function googleContainerClusterMaintenancePolicyToTerraform(struct?: GoogleContainerClusterMaintenancePolicyOutputReference | GoogleContainerClusterMaintenancePolicy): any;
export declare function googleContainerClusterMaintenancePolicyToHclTerraform(struct?: GoogleContainerClusterMaintenancePolicyOutputReference | GoogleContainerClusterMaintenancePolicy): any;
export declare class GoogleContainerClusterMaintenancePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterMaintenancePolicy | undefined;
    set internalValue(value: GoogleContainerClusterMaintenancePolicy | undefined);
    private _dailyMaintenanceWindow;
    get dailyMaintenanceWindow(): GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindowOutputReference;
    putDailyMaintenanceWindow(value: GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow): void;
    resetDailyMaintenanceWindow(): void;
    get dailyMaintenanceWindowInput(): GoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow | undefined;
    private _maintenanceExclusion;
    get maintenanceExclusion(): GoogleContainerClusterMaintenancePolicyMaintenanceExclusionList;
    putMaintenanceExclusion(value: GoogleContainerClusterMaintenancePolicyMaintenanceExclusion[] | cdktf.IResolvable): void;
    resetMaintenanceExclusion(): void;
    get maintenanceExclusionInput(): cdktf.IResolvable | GoogleContainerClusterMaintenancePolicyMaintenanceExclusion[] | undefined;
    private _recurringWindow;
    get recurringWindow(): GoogleContainerClusterMaintenancePolicyRecurringWindowOutputReference;
    putRecurringWindow(value: GoogleContainerClusterMaintenancePolicyRecurringWindow): void;
    resetRecurringWindow(): void;
    get recurringWindowInput(): GoogleContainerClusterMaintenancePolicyRecurringWindow | undefined;
}
export interface GoogleContainerClusterMasterAuthClientCertificateConfig {
    /**
    * Whether client certificate authorization is enabled for this cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#issue_client_certificate GoogleContainerCluster#issue_client_certificate}
    */
    readonly issueClientCertificate: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterMasterAuthClientCertificateConfigToTerraform(struct?: GoogleContainerClusterMasterAuthClientCertificateConfigOutputReference | GoogleContainerClusterMasterAuthClientCertificateConfig): any;
export declare function googleContainerClusterMasterAuthClientCertificateConfigToHclTerraform(struct?: GoogleContainerClusterMasterAuthClientCertificateConfigOutputReference | GoogleContainerClusterMasterAuthClientCertificateConfig): any;
export declare class GoogleContainerClusterMasterAuthClientCertificateConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterMasterAuthClientCertificateConfig | undefined;
    set internalValue(value: GoogleContainerClusterMasterAuthClientCertificateConfig | undefined);
    private _issueClientCertificate?;
    get issueClientCertificate(): boolean | cdktf.IResolvable;
    set issueClientCertificate(value: boolean | cdktf.IResolvable);
    get issueClientCertificateInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterMasterAuth {
    /**
    * client_certificate_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#client_certificate_config GoogleContainerCluster#client_certificate_config}
    */
    readonly clientCertificateConfig: GoogleContainerClusterMasterAuthClientCertificateConfig;
}
export declare function googleContainerClusterMasterAuthToTerraform(struct?: GoogleContainerClusterMasterAuthOutputReference | GoogleContainerClusterMasterAuth): any;
export declare function googleContainerClusterMasterAuthToHclTerraform(struct?: GoogleContainerClusterMasterAuthOutputReference | GoogleContainerClusterMasterAuth): any;
export declare class GoogleContainerClusterMasterAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterMasterAuth | undefined;
    set internalValue(value: GoogleContainerClusterMasterAuth | undefined);
    get clientCertificate(): string;
    get clientKey(): string;
    get clusterCaCertificate(): string;
    private _clientCertificateConfig;
    get clientCertificateConfig(): GoogleContainerClusterMasterAuthClientCertificateConfigOutputReference;
    putClientCertificateConfig(value: GoogleContainerClusterMasterAuthClientCertificateConfig): void;
    get clientCertificateConfigInput(): GoogleContainerClusterMasterAuthClientCertificateConfig | undefined;
}
export interface GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks {
    /**
    * External network that can access Kubernetes master through HTTPS. Must be specified in CIDR notation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#cidr_block GoogleContainerCluster#cidr_block}
    */
    readonly cidrBlock: string;
    /**
    * Field for users to identify CIDR blocks.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#display_name GoogleContainerCluster#display_name}
    */
    readonly displayName?: string;
}
export declare function googleContainerClusterMasterAuthorizedNetworksConfigCidrBlocksToTerraform(struct?: GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks | cdktf.IResolvable): any;
export declare function googleContainerClusterMasterAuthorizedNetworksConfigCidrBlocksToHclTerraform(struct?: GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks | cdktf.IResolvable): any;
export declare class GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks | cdktf.IResolvable | undefined);
    private _cidrBlock?;
    get cidrBlock(): string;
    set cidrBlock(value: string);
    get cidrBlockInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
}
export declare class GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocksOutputReference;
}
export interface GoogleContainerClusterMasterAuthorizedNetworksConfig {
    /**
    * Whether master is accessbile via Google Compute Engine Public IP addresses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#gcp_public_cidrs_access_enabled GoogleContainerCluster#gcp_public_cidrs_access_enabled}
    */
    readonly gcpPublicCidrsAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * cidr_blocks block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#cidr_blocks GoogleContainerCluster#cidr_blocks}
    */
    readonly cidrBlocks?: GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks[] | cdktf.IResolvable;
}
export declare function googleContainerClusterMasterAuthorizedNetworksConfigToTerraform(struct?: GoogleContainerClusterMasterAuthorizedNetworksConfigOutputReference | GoogleContainerClusterMasterAuthorizedNetworksConfig): any;
export declare function googleContainerClusterMasterAuthorizedNetworksConfigToHclTerraform(struct?: GoogleContainerClusterMasterAuthorizedNetworksConfigOutputReference | GoogleContainerClusterMasterAuthorizedNetworksConfig): any;
export declare class GoogleContainerClusterMasterAuthorizedNetworksConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterMasterAuthorizedNetworksConfig | undefined;
    set internalValue(value: GoogleContainerClusterMasterAuthorizedNetworksConfig | undefined);
    private _gcpPublicCidrsAccessEnabled?;
    get gcpPublicCidrsAccessEnabled(): boolean | cdktf.IResolvable;
    set gcpPublicCidrsAccessEnabled(value: boolean | cdktf.IResolvable);
    resetGcpPublicCidrsAccessEnabled(): void;
    get gcpPublicCidrsAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cidrBlocks;
    get cidrBlocks(): GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocksList;
    putCidrBlocks(value: GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks[] | cdktf.IResolvable): void;
    resetCidrBlocks(): void;
    get cidrBlocksInput(): cdktf.IResolvable | GoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks[] | undefined;
}
export interface GoogleContainerClusterMeshCertificates {
    /**
    * When enabled the GKE Workload Identity Certificates controller and node agent will be deployed in the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enable_certificates GoogleContainerCluster#enable_certificates}
    */
    readonly enableCertificates: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterMeshCertificatesToTerraform(struct?: GoogleContainerClusterMeshCertificatesOutputReference | GoogleContainerClusterMeshCertificates): any;
export declare function googleContainerClusterMeshCertificatesToHclTerraform(struct?: GoogleContainerClusterMeshCertificatesOutputReference | GoogleContainerClusterMeshCertificates): any;
export declare class GoogleContainerClusterMeshCertificatesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterMeshCertificates | undefined;
    set internalValue(value: GoogleContainerClusterMeshCertificates | undefined);
    private _enableCertificates?;
    get enableCertificates(): boolean | cdktf.IResolvable;
    set enableCertificates(value: boolean | cdktf.IResolvable);
    get enableCertificatesInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterMonitoringConfigAdvancedDatapathObservabilityConfig {
    /**
    * Whether or not the advanced datapath metrics are enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enable_metrics GoogleContainerCluster#enable_metrics}
    */
    readonly enableMetrics: boolean | cdktf.IResolvable;
    /**
    * Whether or not Relay is enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enable_relay GoogleContainerCluster#enable_relay}
    */
    readonly enableRelay?: boolean | cdktf.IResolvable;
    /**
    * Mode used to make Relay available.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#relay_mode GoogleContainerCluster#relay_mode}
    */
    readonly relayMode?: string;
}
export declare function googleContainerClusterMonitoringConfigAdvancedDatapathObservabilityConfigToTerraform(struct?: GoogleContainerClusterMonitoringConfigAdvancedDatapathObservabilityConfigOutputReference | GoogleContainerClusterMonitoringConfigAdvancedDatapathObservabilityConfig): any;
export declare function googleContainerClusterMonitoringConfigAdvancedDatapathObservabilityConfigToHclTerraform(struct?: GoogleContainerClusterMonitoringConfigAdvancedDatapathObservabilityConfigOutputReference | GoogleContainerClusterMonitoringConfigAdvancedDatapathObservabilityConfig): any;
export declare class GoogleContainerClusterMonitoringConfigAdvancedDatapathObservabilityConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterMonitoringConfigAdvancedDatapathObservabilityConfig | undefined;
    set internalValue(value: GoogleContainerClusterMonitoringConfigAdvancedDatapathObservabilityConfig | undefined);
    private _enableMetrics?;
    get enableMetrics(): boolean | cdktf.IResolvable;
    set enableMetrics(value: boolean | cdktf.IResolvable);
    get enableMetricsInput(): boolean | cdktf.IResolvable | undefined;
    private _enableRelay?;
    get enableRelay(): boolean | cdktf.IResolvable;
    set enableRelay(value: boolean | cdktf.IResolvable);
    resetEnableRelay(): void;
    get enableRelayInput(): boolean | cdktf.IResolvable | undefined;
    private _relayMode?;
    get relayMode(): string;
    set relayMode(value: string);
    resetRelayMode(): void;
    get relayModeInput(): string | undefined;
}
export interface GoogleContainerClusterMonitoringConfigManagedPrometheus {
    /**
    * Whether or not the managed collection is enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterMonitoringConfigManagedPrometheusToTerraform(struct?: GoogleContainerClusterMonitoringConfigManagedPrometheusOutputReference | GoogleContainerClusterMonitoringConfigManagedPrometheus): any;
export declare function googleContainerClusterMonitoringConfigManagedPrometheusToHclTerraform(struct?: GoogleContainerClusterMonitoringConfigManagedPrometheusOutputReference | GoogleContainerClusterMonitoringConfigManagedPrometheus): any;
export declare class GoogleContainerClusterMonitoringConfigManagedPrometheusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterMonitoringConfigManagedPrometheus | undefined;
    set internalValue(value: GoogleContainerClusterMonitoringConfigManagedPrometheus | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterMonitoringConfig {
    /**
    * GKE components exposing metrics. Valid values include SYSTEM_COMPONENTS, APISERVER, SCHEDULER, CONTROLLER_MANAGER, STORAGE, HPA, POD, DAEMONSET, DEPLOYMENT, STATEFULSET and WORKLOADS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enable_components GoogleContainerCluster#enable_components}
    */
    readonly enableComponents?: string[];
    /**
    * advanced_datapath_observability_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#advanced_datapath_observability_config GoogleContainerCluster#advanced_datapath_observability_config}
    */
    readonly advancedDatapathObservabilityConfig?: GoogleContainerClusterMonitoringConfigAdvancedDatapathObservabilityConfig;
    /**
    * managed_prometheus block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#managed_prometheus GoogleContainerCluster#managed_prometheus}
    */
    readonly managedPrometheus?: GoogleContainerClusterMonitoringConfigManagedPrometheus;
}
export declare function googleContainerClusterMonitoringConfigToTerraform(struct?: GoogleContainerClusterMonitoringConfigOutputReference | GoogleContainerClusterMonitoringConfig): any;
export declare function googleContainerClusterMonitoringConfigToHclTerraform(struct?: GoogleContainerClusterMonitoringConfigOutputReference | GoogleContainerClusterMonitoringConfig): any;
export declare class GoogleContainerClusterMonitoringConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterMonitoringConfig | undefined;
    set internalValue(value: GoogleContainerClusterMonitoringConfig | undefined);
    private _enableComponents?;
    get enableComponents(): string[];
    set enableComponents(value: string[]);
    resetEnableComponents(): void;
    get enableComponentsInput(): string[] | undefined;
    private _advancedDatapathObservabilityConfig;
    get advancedDatapathObservabilityConfig(): GoogleContainerClusterMonitoringConfigAdvancedDatapathObservabilityConfigOutputReference;
    putAdvancedDatapathObservabilityConfig(value: GoogleContainerClusterMonitoringConfigAdvancedDatapathObservabilityConfig): void;
    resetAdvancedDatapathObservabilityConfig(): void;
    get advancedDatapathObservabilityConfigInput(): GoogleContainerClusterMonitoringConfigAdvancedDatapathObservabilityConfig | undefined;
    private _managedPrometheus;
    get managedPrometheus(): GoogleContainerClusterMonitoringConfigManagedPrometheusOutputReference;
    putManagedPrometheus(value: GoogleContainerClusterMonitoringConfigManagedPrometheus): void;
    resetManagedPrometheus(): void;
    get managedPrometheusInput(): GoogleContainerClusterMonitoringConfigManagedPrometheus | undefined;
}
export interface GoogleContainerClusterNetworkPolicy {
    /**
    * Whether network policy is enabled on the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * The selected network policy provider.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#provider GoogleContainerCluster#provider}
    */
    readonly provider?: string;
}
export declare function googleContainerClusterNetworkPolicyToTerraform(struct?: GoogleContainerClusterNetworkPolicyOutputReference | GoogleContainerClusterNetworkPolicy): any;
export declare function googleContainerClusterNetworkPolicyToHclTerraform(struct?: GoogleContainerClusterNetworkPolicyOutputReference | GoogleContainerClusterNetworkPolicy): any;
export declare class GoogleContainerClusterNetworkPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNetworkPolicy | undefined;
    set internalValue(value: GoogleContainerClusterNetworkPolicy | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _provider?;
    get provider(): string;
    set provider(value: string);
    resetProvider(): void;
    get providerInput(): string | undefined;
}
export interface GoogleContainerClusterNodeConfigEffectiveTaints {
}
export declare function googleContainerClusterNodeConfigEffectiveTaintsToTerraform(struct?: GoogleContainerClusterNodeConfigEffectiveTaints): any;
export declare function googleContainerClusterNodeConfigEffectiveTaintsToHclTerraform(struct?: GoogleContainerClusterNodeConfigEffectiveTaints): any;
export declare class GoogleContainerClusterNodeConfigEffectiveTaintsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerClusterNodeConfigEffectiveTaints | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigEffectiveTaints | undefined);
    get effect(): string;
    get key(): string;
    get value(): string;
}
export declare class GoogleContainerClusterNodeConfigEffectiveTaintsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerClusterNodeConfigEffectiveTaintsOutputReference;
}
export interface GoogleContainerClusterNodeConfigGuestAcceleratorGpuDriverInstallationConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#gpu_driver_version GoogleContainerCluster#gpu_driver_version}
    */
    readonly gpuDriverVersion?: string;
}
export declare function googleContainerClusterNodeConfigGuestAcceleratorGpuDriverInstallationConfigToTerraform(struct?: GoogleContainerClusterNodeConfigGuestAcceleratorGpuDriverInstallationConfig | cdktf.IResolvable): any;
export declare function googleContainerClusterNodeConfigGuestAcceleratorGpuDriverInstallationConfigToHclTerraform(struct?: GoogleContainerClusterNodeConfigGuestAcceleratorGpuDriverInstallationConfig | cdktf.IResolvable): any;
export declare class GoogleContainerClusterNodeConfigGuestAcceleratorGpuDriverInstallationConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerClusterNodeConfigGuestAcceleratorGpuDriverInstallationConfig | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigGuestAcceleratorGpuDriverInstallationConfig | cdktf.IResolvable | undefined);
    private _gpuDriverVersion?;
    get gpuDriverVersion(): string;
    set gpuDriverVersion(value: string);
    resetGpuDriverVersion(): void;
    get gpuDriverVersionInput(): string | undefined;
}
export declare class GoogleContainerClusterNodeConfigGuestAcceleratorGpuDriverInstallationConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerClusterNodeConfigGuestAcceleratorGpuDriverInstallationConfig[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerClusterNodeConfigGuestAcceleratorGpuDriverInstallationConfigOutputReference;
}
export interface GoogleContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#gpu_sharing_strategy GoogleContainerCluster#gpu_sharing_strategy}
    */
    readonly gpuSharingStrategy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#max_shared_clients_per_gpu GoogleContainerCluster#max_shared_clients_per_gpu}
    */
    readonly maxSharedClientsPerGpu?: number;
}
export declare function googleContainerClusterNodeConfigGuestAcceleratorGpuSharingConfigToTerraform(struct?: GoogleContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig | cdktf.IResolvable): any;
export declare function googleContainerClusterNodeConfigGuestAcceleratorGpuSharingConfigToHclTerraform(struct?: GoogleContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig | cdktf.IResolvable): any;
export declare class GoogleContainerClusterNodeConfigGuestAcceleratorGpuSharingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig | cdktf.IResolvable | undefined);
    private _gpuSharingStrategy?;
    get gpuSharingStrategy(): string;
    set gpuSharingStrategy(value: string);
    resetGpuSharingStrategy(): void;
    get gpuSharingStrategyInput(): string | undefined;
    private _maxSharedClientsPerGpu?;
    get maxSharedClientsPerGpu(): number;
    set maxSharedClientsPerGpu(value: number);
    resetMaxSharedClientsPerGpu(): void;
    get maxSharedClientsPerGpuInput(): number | undefined;
}
export declare class GoogleContainerClusterNodeConfigGuestAcceleratorGpuSharingConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerClusterNodeConfigGuestAcceleratorGpuSharingConfigOutputReference;
}
export interface GoogleContainerClusterNodeConfigGuestAccelerator {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#count GoogleContainerCluster#count}
    */
    readonly count?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#gpu_driver_installation_config GoogleContainerCluster#gpu_driver_installation_config}
    */
    readonly gpuDriverInstallationConfig?: GoogleContainerClusterNodeConfigGuestAcceleratorGpuDriverInstallationConfig[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#gpu_partition_size GoogleContainerCluster#gpu_partition_size}
    */
    readonly gpuPartitionSize?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#gpu_sharing_config GoogleContainerCluster#gpu_sharing_config}
    */
    readonly gpuSharingConfig?: GoogleContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#type GoogleContainerCluster#type}
    */
    readonly type?: string;
}
export declare function googleContainerClusterNodeConfigGuestAcceleratorToTerraform(struct?: GoogleContainerClusterNodeConfigGuestAccelerator | cdktf.IResolvable): any;
export declare function googleContainerClusterNodeConfigGuestAcceleratorToHclTerraform(struct?: GoogleContainerClusterNodeConfigGuestAccelerator | cdktf.IResolvable): any;
export declare class GoogleContainerClusterNodeConfigGuestAcceleratorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerClusterNodeConfigGuestAccelerator | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigGuestAccelerator | cdktf.IResolvable | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _gpuDriverInstallationConfig;
    get gpuDriverInstallationConfig(): GoogleContainerClusterNodeConfigGuestAcceleratorGpuDriverInstallationConfigList;
    putGpuDriverInstallationConfig(value: GoogleContainerClusterNodeConfigGuestAcceleratorGpuDriverInstallationConfig[] | cdktf.IResolvable): void;
    resetGpuDriverInstallationConfig(): void;
    get gpuDriverInstallationConfigInput(): cdktf.IResolvable | GoogleContainerClusterNodeConfigGuestAcceleratorGpuDriverInstallationConfig[] | undefined;
    private _gpuPartitionSize?;
    get gpuPartitionSize(): string;
    set gpuPartitionSize(value: string);
    resetGpuPartitionSize(): void;
    get gpuPartitionSizeInput(): string | undefined;
    private _gpuSharingConfig;
    get gpuSharingConfig(): GoogleContainerClusterNodeConfigGuestAcceleratorGpuSharingConfigList;
    putGpuSharingConfig(value: GoogleContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig[] | cdktf.IResolvable): void;
    resetGpuSharingConfig(): void;
    get gpuSharingConfigInput(): cdktf.IResolvable | GoogleContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class GoogleContainerClusterNodeConfigGuestAcceleratorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerClusterNodeConfigGuestAccelerator[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerClusterNodeConfigGuestAcceleratorOutputReference;
}
export interface GoogleContainerClusterNodeConfigAdvancedMachineFeatures {
    /**
    * The number of threads per physical core. To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#threads_per_core GoogleContainerCluster#threads_per_core}
    */
    readonly threadsPerCore: number;
}
export declare function googleContainerClusterNodeConfigAdvancedMachineFeaturesToTerraform(struct?: GoogleContainerClusterNodeConfigAdvancedMachineFeaturesOutputReference | GoogleContainerClusterNodeConfigAdvancedMachineFeatures): any;
export declare function googleContainerClusterNodeConfigAdvancedMachineFeaturesToHclTerraform(struct?: GoogleContainerClusterNodeConfigAdvancedMachineFeaturesOutputReference | GoogleContainerClusterNodeConfigAdvancedMachineFeatures): any;
export declare class GoogleContainerClusterNodeConfigAdvancedMachineFeaturesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodeConfigAdvancedMachineFeatures | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigAdvancedMachineFeatures | undefined);
    private _threadsPerCore?;
    get threadsPerCore(): number;
    set threadsPerCore(value: number);
    get threadsPerCoreInput(): number | undefined;
}
export interface GoogleContainerClusterNodeConfigConfidentialNodes {
    /**
    * Whether Confidential Nodes feature is enabled for all nodes in this pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterNodeConfigConfidentialNodesToTerraform(struct?: GoogleContainerClusterNodeConfigConfidentialNodesOutputReference | GoogleContainerClusterNodeConfigConfidentialNodes): any;
export declare function googleContainerClusterNodeConfigConfidentialNodesToHclTerraform(struct?: GoogleContainerClusterNodeConfigConfidentialNodesOutputReference | GoogleContainerClusterNodeConfigConfidentialNodes): any;
export declare class GoogleContainerClusterNodeConfigConfidentialNodesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodeConfigConfidentialNodes | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigConfidentialNodes | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterNodeConfigEphemeralStorageConfig {
    /**
    * Number of local SSDs to use to back ephemeral storage. Uses NVMe interfaces. Each local SSD must be 375 or 3000 GB in size, and all local SSDs must share the same size.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#local_ssd_count GoogleContainerCluster#local_ssd_count}
    */
    readonly localSsdCount: number;
}
export declare function googleContainerClusterNodeConfigEphemeralStorageConfigToTerraform(struct?: GoogleContainerClusterNodeConfigEphemeralStorageConfigOutputReference | GoogleContainerClusterNodeConfigEphemeralStorageConfig): any;
export declare function googleContainerClusterNodeConfigEphemeralStorageConfigToHclTerraform(struct?: GoogleContainerClusterNodeConfigEphemeralStorageConfigOutputReference | GoogleContainerClusterNodeConfigEphemeralStorageConfig): any;
export declare class GoogleContainerClusterNodeConfigEphemeralStorageConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodeConfigEphemeralStorageConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigEphemeralStorageConfig | undefined);
    private _localSsdCount?;
    get localSsdCount(): number;
    set localSsdCount(value: number);
    get localSsdCountInput(): number | undefined;
}
export interface GoogleContainerClusterNodeConfigEphemeralStorageLocalSsdConfig {
    /**
    * Number of local SSDs to use to back ephemeral storage. Uses NVMe interfaces. Each local SSD must be 375 or 3000 GB in size, and all local SSDs must share the same size.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#local_ssd_count GoogleContainerCluster#local_ssd_count}
    */
    readonly localSsdCount: number;
}
export declare function googleContainerClusterNodeConfigEphemeralStorageLocalSsdConfigToTerraform(struct?: GoogleContainerClusterNodeConfigEphemeralStorageLocalSsdConfigOutputReference | GoogleContainerClusterNodeConfigEphemeralStorageLocalSsdConfig): any;
export declare function googleContainerClusterNodeConfigEphemeralStorageLocalSsdConfigToHclTerraform(struct?: GoogleContainerClusterNodeConfigEphemeralStorageLocalSsdConfigOutputReference | GoogleContainerClusterNodeConfigEphemeralStorageLocalSsdConfig): any;
export declare class GoogleContainerClusterNodeConfigEphemeralStorageLocalSsdConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodeConfigEphemeralStorageLocalSsdConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigEphemeralStorageLocalSsdConfig | undefined);
    private _localSsdCount?;
    get localSsdCount(): number;
    set localSsdCount(value: number);
    get localSsdCountInput(): number | undefined;
}
export interface GoogleContainerClusterNodeConfigFastSocket {
    /**
    * Whether or not NCCL Fast Socket is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterNodeConfigFastSocketToTerraform(struct?: GoogleContainerClusterNodeConfigFastSocketOutputReference | GoogleContainerClusterNodeConfigFastSocket): any;
export declare function googleContainerClusterNodeConfigFastSocketToHclTerraform(struct?: GoogleContainerClusterNodeConfigFastSocketOutputReference | GoogleContainerClusterNodeConfigFastSocket): any;
export declare class GoogleContainerClusterNodeConfigFastSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodeConfigFastSocket | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigFastSocket | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterNodeConfigGcfsConfig {
    /**
    * Whether or not GCFS is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterNodeConfigGcfsConfigToTerraform(struct?: GoogleContainerClusterNodeConfigGcfsConfigOutputReference | GoogleContainerClusterNodeConfigGcfsConfig): any;
export declare function googleContainerClusterNodeConfigGcfsConfigToHclTerraform(struct?: GoogleContainerClusterNodeConfigGcfsConfigOutputReference | GoogleContainerClusterNodeConfigGcfsConfig): any;
export declare class GoogleContainerClusterNodeConfigGcfsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodeConfigGcfsConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigGcfsConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterNodeConfigGvnic {
    /**
    * Whether or not gvnic is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterNodeConfigGvnicToTerraform(struct?: GoogleContainerClusterNodeConfigGvnicOutputReference | GoogleContainerClusterNodeConfigGvnic): any;
export declare function googleContainerClusterNodeConfigGvnicToHclTerraform(struct?: GoogleContainerClusterNodeConfigGvnicOutputReference | GoogleContainerClusterNodeConfigGvnic): any;
export declare class GoogleContainerClusterNodeConfigGvnicOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodeConfigGvnic | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigGvnic | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterNodeConfigHostMaintenancePolicy {
    /**
    * .
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#maintenance_interval GoogleContainerCluster#maintenance_interval}
    */
    readonly maintenanceInterval: string;
}
export declare function googleContainerClusterNodeConfigHostMaintenancePolicyToTerraform(struct?: GoogleContainerClusterNodeConfigHostMaintenancePolicyOutputReference | GoogleContainerClusterNodeConfigHostMaintenancePolicy): any;
export declare function googleContainerClusterNodeConfigHostMaintenancePolicyToHclTerraform(struct?: GoogleContainerClusterNodeConfigHostMaintenancePolicyOutputReference | GoogleContainerClusterNodeConfigHostMaintenancePolicy): any;
export declare class GoogleContainerClusterNodeConfigHostMaintenancePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodeConfigHostMaintenancePolicy | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigHostMaintenancePolicy | undefined);
    private _maintenanceInterval?;
    get maintenanceInterval(): string;
    set maintenanceInterval(value: string);
    get maintenanceIntervalInput(): string | undefined;
}
export interface GoogleContainerClusterNodeConfigKubeletConfig {
    /**
    * Enable CPU CFS quota enforcement for containers that specify CPU limits.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#cpu_cfs_quota GoogleContainerCluster#cpu_cfs_quota}
    */
    readonly cpuCfsQuota?: boolean | cdktf.IResolvable;
    /**
    * Set the CPU CFS quota period value 'cpu.cfs_period_us'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#cpu_cfs_quota_period GoogleContainerCluster#cpu_cfs_quota_period}
    */
    readonly cpuCfsQuotaPeriod?: string;
    /**
    * Control the CPU management policy on the node.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#cpu_manager_policy GoogleContainerCluster#cpu_manager_policy}
    */
    readonly cpuManagerPolicy: string;
    /**
    * Controls the maximum number of processes allowed to run in a pod.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#pod_pids_limit GoogleContainerCluster#pod_pids_limit}
    */
    readonly podPidsLimit?: number;
}
export declare function googleContainerClusterNodeConfigKubeletConfigToTerraform(struct?: GoogleContainerClusterNodeConfigKubeletConfigOutputReference | GoogleContainerClusterNodeConfigKubeletConfig): any;
export declare function googleContainerClusterNodeConfigKubeletConfigToHclTerraform(struct?: GoogleContainerClusterNodeConfigKubeletConfigOutputReference | GoogleContainerClusterNodeConfigKubeletConfig): any;
export declare class GoogleContainerClusterNodeConfigKubeletConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodeConfigKubeletConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigKubeletConfig | undefined);
    private _cpuCfsQuota?;
    get cpuCfsQuota(): boolean | cdktf.IResolvable;
    set cpuCfsQuota(value: boolean | cdktf.IResolvable);
    resetCpuCfsQuota(): void;
    get cpuCfsQuotaInput(): boolean | cdktf.IResolvable | undefined;
    private _cpuCfsQuotaPeriod?;
    get cpuCfsQuotaPeriod(): string;
    set cpuCfsQuotaPeriod(value: string);
    resetCpuCfsQuotaPeriod(): void;
    get cpuCfsQuotaPeriodInput(): string | undefined;
    private _cpuManagerPolicy?;
    get cpuManagerPolicy(): string;
    set cpuManagerPolicy(value: string);
    get cpuManagerPolicyInput(): string | undefined;
    private _podPidsLimit?;
    get podPidsLimit(): number;
    set podPidsLimit(value: number);
    resetPodPidsLimit(): void;
    get podPidsLimitInput(): number | undefined;
}
export interface GoogleContainerClusterNodeConfigLinuxNodeConfig {
    /**
    * cgroupMode specifies the cgroup mode to be used on the node.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#cgroup_mode GoogleContainerCluster#cgroup_mode}
    */
    readonly cgroupMode?: string;
    /**
    * The Linux kernel parameters to be applied to the nodes and all pods running on the nodes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#sysctls GoogleContainerCluster#sysctls}
    */
    readonly sysctls?: {
        [key: string]: string;
    };
}
export declare function googleContainerClusterNodeConfigLinuxNodeConfigToTerraform(struct?: GoogleContainerClusterNodeConfigLinuxNodeConfigOutputReference | GoogleContainerClusterNodeConfigLinuxNodeConfig): any;
export declare function googleContainerClusterNodeConfigLinuxNodeConfigToHclTerraform(struct?: GoogleContainerClusterNodeConfigLinuxNodeConfigOutputReference | GoogleContainerClusterNodeConfigLinuxNodeConfig): any;
export declare class GoogleContainerClusterNodeConfigLinuxNodeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodeConfigLinuxNodeConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigLinuxNodeConfig | undefined);
    private _cgroupMode?;
    get cgroupMode(): string;
    set cgroupMode(value: string);
    resetCgroupMode(): void;
    get cgroupModeInput(): string | undefined;
    private _sysctls?;
    get sysctls(): {
        [key: string]: string;
    };
    set sysctls(value: {
        [key: string]: string;
    });
    resetSysctls(): void;
    get sysctlsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleContainerClusterNodeConfigLocalNvmeSsdBlockConfig {
    /**
    * Number of raw-block local NVMe SSD disks to be attached to the node. Each local SSD is 375 GB in size.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#local_ssd_count GoogleContainerCluster#local_ssd_count}
    */
    readonly localSsdCount: number;
}
export declare function googleContainerClusterNodeConfigLocalNvmeSsdBlockConfigToTerraform(struct?: GoogleContainerClusterNodeConfigLocalNvmeSsdBlockConfigOutputReference | GoogleContainerClusterNodeConfigLocalNvmeSsdBlockConfig): any;
export declare function googleContainerClusterNodeConfigLocalNvmeSsdBlockConfigToHclTerraform(struct?: GoogleContainerClusterNodeConfigLocalNvmeSsdBlockConfigOutputReference | GoogleContainerClusterNodeConfigLocalNvmeSsdBlockConfig): any;
export declare class GoogleContainerClusterNodeConfigLocalNvmeSsdBlockConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodeConfigLocalNvmeSsdBlockConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigLocalNvmeSsdBlockConfig | undefined);
    private _localSsdCount?;
    get localSsdCount(): number;
    set localSsdCount(value: number);
    get localSsdCountInput(): number | undefined;
}
export interface GoogleContainerClusterNodeConfigReservationAffinity {
    /**
    * Corresponds to the type of reservation consumption.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#consume_reservation_type GoogleContainerCluster#consume_reservation_type}
    */
    readonly consumeReservationType: string;
    /**
    * The label key of a reservation resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#key GoogleContainerCluster#key}
    */
    readonly key?: string;
    /**
    * The label values of the reservation resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#values GoogleContainerCluster#values}
    */
    readonly values?: string[];
}
export declare function googleContainerClusterNodeConfigReservationAffinityToTerraform(struct?: GoogleContainerClusterNodeConfigReservationAffinityOutputReference | GoogleContainerClusterNodeConfigReservationAffinity): any;
export declare function googleContainerClusterNodeConfigReservationAffinityToHclTerraform(struct?: GoogleContainerClusterNodeConfigReservationAffinityOutputReference | GoogleContainerClusterNodeConfigReservationAffinity): any;
export declare class GoogleContainerClusterNodeConfigReservationAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodeConfigReservationAffinity | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigReservationAffinity | undefined);
    private _consumeReservationType?;
    get consumeReservationType(): string;
    set consumeReservationType(value: string);
    get consumeReservationTypeInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface GoogleContainerClusterNodeConfigSandboxConfig {
    /**
    * Type of the sandbox to use for the node (e.g. 'gvisor')
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#sandbox_type GoogleContainerCluster#sandbox_type}
    */
    readonly sandboxType: string;
}
export declare function googleContainerClusterNodeConfigSandboxConfigToTerraform(struct?: GoogleContainerClusterNodeConfigSandboxConfigOutputReference | GoogleContainerClusterNodeConfigSandboxConfig): any;
export declare function googleContainerClusterNodeConfigSandboxConfigToHclTerraform(struct?: GoogleContainerClusterNodeConfigSandboxConfigOutputReference | GoogleContainerClusterNodeConfigSandboxConfig): any;
export declare class GoogleContainerClusterNodeConfigSandboxConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodeConfigSandboxConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigSandboxConfig | undefined);
    private _sandboxType?;
    get sandboxType(): string;
    set sandboxType(value: string);
    get sandboxTypeInput(): string | undefined;
}
export interface GoogleContainerClusterNodeConfigShieldedInstanceConfig {
    /**
    * Defines whether the instance has integrity monitoring enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enable_integrity_monitoring GoogleContainerCluster#enable_integrity_monitoring}
    */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Defines whether the instance has Secure Boot enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enable_secure_boot GoogleContainerCluster#enable_secure_boot}
    */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterNodeConfigShieldedInstanceConfigToTerraform(struct?: GoogleContainerClusterNodeConfigShieldedInstanceConfigOutputReference | GoogleContainerClusterNodeConfigShieldedInstanceConfig): any;
export declare function googleContainerClusterNodeConfigShieldedInstanceConfigToHclTerraform(struct?: GoogleContainerClusterNodeConfigShieldedInstanceConfigOutputReference | GoogleContainerClusterNodeConfigShieldedInstanceConfig): any;
export declare class GoogleContainerClusterNodeConfigShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodeConfigShieldedInstanceConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterNodeConfigSoleTenantConfigNodeAffinity {
    /**
    * .
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#key GoogleContainerCluster#key}
    */
    readonly key: string;
    /**
    * .
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#operator GoogleContainerCluster#operator}
    */
    readonly operator: string;
    /**
    * .
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#values GoogleContainerCluster#values}
    */
    readonly values: string[];
}
export declare function googleContainerClusterNodeConfigSoleTenantConfigNodeAffinityToTerraform(struct?: GoogleContainerClusterNodeConfigSoleTenantConfigNodeAffinity | cdktf.IResolvable): any;
export declare function googleContainerClusterNodeConfigSoleTenantConfigNodeAffinityToHclTerraform(struct?: GoogleContainerClusterNodeConfigSoleTenantConfigNodeAffinity | cdktf.IResolvable): any;
export declare class GoogleContainerClusterNodeConfigSoleTenantConfigNodeAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerClusterNodeConfigSoleTenantConfigNodeAffinity | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigSoleTenantConfigNodeAffinity | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class GoogleContainerClusterNodeConfigSoleTenantConfigNodeAffinityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerClusterNodeConfigSoleTenantConfigNodeAffinity[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerClusterNodeConfigSoleTenantConfigNodeAffinityOutputReference;
}
export interface GoogleContainerClusterNodeConfigSoleTenantConfig {
    /**
    * node_affinity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#node_affinity GoogleContainerCluster#node_affinity}
    */
    readonly nodeAffinity: GoogleContainerClusterNodeConfigSoleTenantConfigNodeAffinity[] | cdktf.IResolvable;
}
export declare function googleContainerClusterNodeConfigSoleTenantConfigToTerraform(struct?: GoogleContainerClusterNodeConfigSoleTenantConfigOutputReference | GoogleContainerClusterNodeConfigSoleTenantConfig): any;
export declare function googleContainerClusterNodeConfigSoleTenantConfigToHclTerraform(struct?: GoogleContainerClusterNodeConfigSoleTenantConfigOutputReference | GoogleContainerClusterNodeConfigSoleTenantConfig): any;
export declare class GoogleContainerClusterNodeConfigSoleTenantConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodeConfigSoleTenantConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigSoleTenantConfig | undefined);
    private _nodeAffinity;
    get nodeAffinity(): GoogleContainerClusterNodeConfigSoleTenantConfigNodeAffinityList;
    putNodeAffinity(value: GoogleContainerClusterNodeConfigSoleTenantConfigNodeAffinity[] | cdktf.IResolvable): void;
    get nodeAffinityInput(): cdktf.IResolvable | GoogleContainerClusterNodeConfigSoleTenantConfigNodeAffinity[] | undefined;
}
export interface GoogleContainerClusterNodeConfigTaint {
    /**
    * Effect for taint.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#effect GoogleContainerCluster#effect}
    */
    readonly effect: string;
    /**
    * Key for taint.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#key GoogleContainerCluster#key}
    */
    readonly key: string;
    /**
    * Value for taint.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#value GoogleContainerCluster#value}
    */
    readonly value: string;
}
export declare function googleContainerClusterNodeConfigTaintToTerraform(struct?: GoogleContainerClusterNodeConfigTaint | cdktf.IResolvable): any;
export declare function googleContainerClusterNodeConfigTaintToHclTerraform(struct?: GoogleContainerClusterNodeConfigTaint | cdktf.IResolvable): any;
export declare class GoogleContainerClusterNodeConfigTaintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerClusterNodeConfigTaint | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigTaint | cdktf.IResolvable | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class GoogleContainerClusterNodeConfigTaintList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerClusterNodeConfigTaint[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerClusterNodeConfigTaintOutputReference;
}
export interface GoogleContainerClusterNodeConfigWorkloadMetadataConfig {
    /**
    * Mode is the configuration for how to expose metadata to workloads running on the node.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#mode GoogleContainerCluster#mode}
    */
    readonly mode: string;
}
export declare function googleContainerClusterNodeConfigWorkloadMetadataConfigToTerraform(struct?: GoogleContainerClusterNodeConfigWorkloadMetadataConfigOutputReference | GoogleContainerClusterNodeConfigWorkloadMetadataConfig): any;
export declare function googleContainerClusterNodeConfigWorkloadMetadataConfigToHclTerraform(struct?: GoogleContainerClusterNodeConfigWorkloadMetadataConfigOutputReference | GoogleContainerClusterNodeConfigWorkloadMetadataConfig): any;
export declare class GoogleContainerClusterNodeConfigWorkloadMetadataConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodeConfigWorkloadMetadataConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfigWorkloadMetadataConfig | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
}
export interface GoogleContainerClusterNodeConfig {
    /**
    * The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#boot_disk_kms_key GoogleContainerCluster#boot_disk_kms_key}
    */
    readonly bootDiskKmsKey?: string;
    /**
    * Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#disk_size_gb GoogleContainerCluster#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * Type of the disk attached to each node. Such as pd-standard, pd-balanced or pd-ssd
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#disk_type GoogleContainerCluster#disk_type}
    */
    readonly diskType?: string;
    /**
    * If enabled boot disks are configured with confidential mode.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enable_confidential_storage GoogleContainerCluster#enable_confidential_storage}
    */
    readonly enableConfidentialStorage?: boolean | cdktf.IResolvable;
    /**
    * List of the type and count of accelerator cards attached to the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#guest_accelerator GoogleContainerCluster#guest_accelerator}
    */
    readonly guestAccelerator?: GoogleContainerClusterNodeConfigGuestAccelerator[] | cdktf.IResolvable;
    /**
    * The image type to use for this node. Note that for a given image type, the latest version of it will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#image_type GoogleContainerCluster#image_type}
    */
    readonly imageType?: string;
    /**
    * The map of Kubernetes labels (key/value pairs) to be applied to each node. These will added in addition to any default label(s) that Kubernetes may apply to the node.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#labels GoogleContainerCluster#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The number of local SSD disks to be attached to the node.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#local_ssd_count GoogleContainerCluster#local_ssd_count}
    */
    readonly localSsdCount?: number;
    /**
    * Type of logging agent that is used as the default value for node pools in the cluster. Valid values include DEFAULT and MAX_THROUGHPUT.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#logging_variant GoogleContainerCluster#logging_variant}
    */
    readonly loggingVariant?: string;
    /**
    * The name of a Google Compute Engine machine type.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#machine_type GoogleContainerCluster#machine_type}
    */
    readonly machineType?: string;
    /**
    * The metadata key/value pairs assigned to instances in the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#metadata GoogleContainerCluster#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Minimum CPU platform to be used by this instance. The instance may be scheduled on the specified or newer CPU platform.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#min_cpu_platform GoogleContainerCluster#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * Setting this field will assign instances of this pool to run on the specified node group. This is useful for running workloads on sole tenant nodes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#node_group GoogleContainerCluster#node_group}
    */
    readonly nodeGroup?: string;
    /**
    * The set of Google API scopes to be made available on all of the node VMs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#oauth_scopes GoogleContainerCluster#oauth_scopes}
    */
    readonly oauthScopes?: string[];
    /**
    * Whether the nodes are created as preemptible VM instances.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#preemptible GoogleContainerCluster#preemptible}
    */
    readonly preemptible?: boolean | cdktf.IResolvable;
    /**
    * The GCE resource labels (a map of key/value pairs) to be applied to the node pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#resource_labels GoogleContainerCluster#resource_labels}
    */
    readonly resourceLabels?: {
        [key: string]: string;
    };
    /**
    * A map of resource manager tags. Resource manager tag keys and values have the same definition as resource manager tags. Keys must be in the format tagKeys/{tag_key_id}, and values are in the format tagValues/456. The field is ignored (both PUT & PATCH) when empty.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#resource_manager_tags GoogleContainerCluster#resource_manager_tags}
    */
    readonly resourceManagerTags?: {
        [key: string]: string;
    };
    /**
    * The Google Cloud Platform Service Account to be used by the node VMs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#service_account GoogleContainerCluster#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * Whether the nodes are created as spot VM instances.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#spot GoogleContainerCluster#spot}
    */
    readonly spot?: boolean | cdktf.IResolvable;
    /**
    * The list of instance tags applied to all nodes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#tags GoogleContainerCluster#tags}
    */
    readonly tags?: string[];
    /**
    * advanced_machine_features block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#advanced_machine_features GoogleContainerCluster#advanced_machine_features}
    */
    readonly advancedMachineFeatures?: GoogleContainerClusterNodeConfigAdvancedMachineFeatures;
    /**
    * confidential_nodes block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#confidential_nodes GoogleContainerCluster#confidential_nodes}
    */
    readonly confidentialNodes?: GoogleContainerClusterNodeConfigConfidentialNodes;
    /**
    * ephemeral_storage_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#ephemeral_storage_config GoogleContainerCluster#ephemeral_storage_config}
    */
    readonly ephemeralStorageConfig?: GoogleContainerClusterNodeConfigEphemeralStorageConfig;
    /**
    * ephemeral_storage_local_ssd_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#ephemeral_storage_local_ssd_config GoogleContainerCluster#ephemeral_storage_local_ssd_config}
    */
    readonly ephemeralStorageLocalSsdConfig?: GoogleContainerClusterNodeConfigEphemeralStorageLocalSsdConfig;
    /**
    * fast_socket block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#fast_socket GoogleContainerCluster#fast_socket}
    */
    readonly fastSocket?: GoogleContainerClusterNodeConfigFastSocket;
    /**
    * gcfs_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#gcfs_config GoogleContainerCluster#gcfs_config}
    */
    readonly gcfsConfig?: GoogleContainerClusterNodeConfigGcfsConfig;
    /**
    * gvnic block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#gvnic GoogleContainerCluster#gvnic}
    */
    readonly gvnic?: GoogleContainerClusterNodeConfigGvnic;
    /**
    * host_maintenance_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#host_maintenance_policy GoogleContainerCluster#host_maintenance_policy}
    */
    readonly hostMaintenancePolicy?: GoogleContainerClusterNodeConfigHostMaintenancePolicy;
    /**
    * kubelet_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#kubelet_config GoogleContainerCluster#kubelet_config}
    */
    readonly kubeletConfig?: GoogleContainerClusterNodeConfigKubeletConfig;
    /**
    * linux_node_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#linux_node_config GoogleContainerCluster#linux_node_config}
    */
    readonly linuxNodeConfig?: GoogleContainerClusterNodeConfigLinuxNodeConfig;
    /**
    * local_nvme_ssd_block_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#local_nvme_ssd_block_config GoogleContainerCluster#local_nvme_ssd_block_config}
    */
    readonly localNvmeSsdBlockConfig?: GoogleContainerClusterNodeConfigLocalNvmeSsdBlockConfig;
    /**
    * reservation_affinity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#reservation_affinity GoogleContainerCluster#reservation_affinity}
    */
    readonly reservationAffinity?: GoogleContainerClusterNodeConfigReservationAffinity;
    /**
    * sandbox_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#sandbox_config GoogleContainerCluster#sandbox_config}
    */
    readonly sandboxConfig?: GoogleContainerClusterNodeConfigSandboxConfig;
    /**
    * shielded_instance_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#shielded_instance_config GoogleContainerCluster#shielded_instance_config}
    */
    readonly shieldedInstanceConfig?: GoogleContainerClusterNodeConfigShieldedInstanceConfig;
    /**
    * sole_tenant_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#sole_tenant_config GoogleContainerCluster#sole_tenant_config}
    */
    readonly soleTenantConfig?: GoogleContainerClusterNodeConfigSoleTenantConfig;
    /**
    * taint block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#taint GoogleContainerCluster#taint}
    */
    readonly taint?: GoogleContainerClusterNodeConfigTaint[] | cdktf.IResolvable;
    /**
    * workload_metadata_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#workload_metadata_config GoogleContainerCluster#workload_metadata_config}
    */
    readonly workloadMetadataConfig?: GoogleContainerClusterNodeConfigWorkloadMetadataConfig;
}
export declare function googleContainerClusterNodeConfigToTerraform(struct?: GoogleContainerClusterNodeConfigOutputReference | GoogleContainerClusterNodeConfig): any;
export declare function googleContainerClusterNodeConfigToHclTerraform(struct?: GoogleContainerClusterNodeConfigOutputReference | GoogleContainerClusterNodeConfig): any;
export declare class GoogleContainerClusterNodeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodeConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodeConfig | undefined);
    private _bootDiskKmsKey?;
    get bootDiskKmsKey(): string;
    set bootDiskKmsKey(value: string);
    resetBootDiskKmsKey(): void;
    get bootDiskKmsKeyInput(): string | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _diskType?;
    get diskType(): string;
    set diskType(value: string);
    resetDiskType(): void;
    get diskTypeInput(): string | undefined;
    private _effectiveTaints;
    get effectiveTaints(): GoogleContainerClusterNodeConfigEffectiveTaintsList;
    private _enableConfidentialStorage?;
    get enableConfidentialStorage(): boolean | cdktf.IResolvable;
    set enableConfidentialStorage(value: boolean | cdktf.IResolvable);
    resetEnableConfidentialStorage(): void;
    get enableConfidentialStorageInput(): boolean | cdktf.IResolvable | undefined;
    private _guestAccelerator;
    get guestAccelerator(): GoogleContainerClusterNodeConfigGuestAcceleratorList;
    putGuestAccelerator(value: GoogleContainerClusterNodeConfigGuestAccelerator[] | cdktf.IResolvable): void;
    resetGuestAccelerator(): void;
    get guestAcceleratorInput(): cdktf.IResolvable | GoogleContainerClusterNodeConfigGuestAccelerator[] | undefined;
    private _imageType?;
    get imageType(): string;
    set imageType(value: string);
    resetImageType(): void;
    get imageTypeInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _localSsdCount?;
    get localSsdCount(): number;
    set localSsdCount(value: number);
    resetLocalSsdCount(): void;
    get localSsdCountInput(): number | undefined;
    private _loggingVariant?;
    get loggingVariant(): string;
    set loggingVariant(value: string);
    resetLoggingVariant(): void;
    get loggingVariantInput(): string | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _nodeGroup?;
    get nodeGroup(): string;
    set nodeGroup(value: string);
    resetNodeGroup(): void;
    get nodeGroupInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
    private _preemptible?;
    get preemptible(): boolean | cdktf.IResolvable;
    set preemptible(value: boolean | cdktf.IResolvable);
    resetPreemptible(): void;
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceLabels?;
    get resourceLabels(): {
        [key: string]: string;
    };
    set resourceLabels(value: {
        [key: string]: string;
    });
    resetResourceLabels(): void;
    get resourceLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _resourceManagerTags?;
    get resourceManagerTags(): {
        [key: string]: string;
    };
    set resourceManagerTags(value: {
        [key: string]: string;
    });
    resetResourceManagerTags(): void;
    get resourceManagerTagsInput(): {
        [key: string]: string;
    } | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _spot?;
    get spot(): boolean | cdktf.IResolvable;
    set spot(value: boolean | cdktf.IResolvable);
    resetSpot(): void;
    get spotInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _advancedMachineFeatures;
    get advancedMachineFeatures(): GoogleContainerClusterNodeConfigAdvancedMachineFeaturesOutputReference;
    putAdvancedMachineFeatures(value: GoogleContainerClusterNodeConfigAdvancedMachineFeatures): void;
    resetAdvancedMachineFeatures(): void;
    get advancedMachineFeaturesInput(): GoogleContainerClusterNodeConfigAdvancedMachineFeatures | undefined;
    private _confidentialNodes;
    get confidentialNodes(): GoogleContainerClusterNodeConfigConfidentialNodesOutputReference;
    putConfidentialNodes(value: GoogleContainerClusterNodeConfigConfidentialNodes): void;
    resetConfidentialNodes(): void;
    get confidentialNodesInput(): GoogleContainerClusterNodeConfigConfidentialNodes | undefined;
    private _ephemeralStorageConfig;
    get ephemeralStorageConfig(): GoogleContainerClusterNodeConfigEphemeralStorageConfigOutputReference;
    putEphemeralStorageConfig(value: GoogleContainerClusterNodeConfigEphemeralStorageConfig): void;
    resetEphemeralStorageConfig(): void;
    get ephemeralStorageConfigInput(): GoogleContainerClusterNodeConfigEphemeralStorageConfig | undefined;
    private _ephemeralStorageLocalSsdConfig;
    get ephemeralStorageLocalSsdConfig(): GoogleContainerClusterNodeConfigEphemeralStorageLocalSsdConfigOutputReference;
    putEphemeralStorageLocalSsdConfig(value: GoogleContainerClusterNodeConfigEphemeralStorageLocalSsdConfig): void;
    resetEphemeralStorageLocalSsdConfig(): void;
    get ephemeralStorageLocalSsdConfigInput(): GoogleContainerClusterNodeConfigEphemeralStorageLocalSsdConfig | undefined;
    private _fastSocket;
    get fastSocket(): GoogleContainerClusterNodeConfigFastSocketOutputReference;
    putFastSocket(value: GoogleContainerClusterNodeConfigFastSocket): void;
    resetFastSocket(): void;
    get fastSocketInput(): GoogleContainerClusterNodeConfigFastSocket | undefined;
    private _gcfsConfig;
    get gcfsConfig(): GoogleContainerClusterNodeConfigGcfsConfigOutputReference;
    putGcfsConfig(value: GoogleContainerClusterNodeConfigGcfsConfig): void;
    resetGcfsConfig(): void;
    get gcfsConfigInput(): GoogleContainerClusterNodeConfigGcfsConfig | undefined;
    private _gvnic;
    get gvnic(): GoogleContainerClusterNodeConfigGvnicOutputReference;
    putGvnic(value: GoogleContainerClusterNodeConfigGvnic): void;
    resetGvnic(): void;
    get gvnicInput(): GoogleContainerClusterNodeConfigGvnic | undefined;
    private _hostMaintenancePolicy;
    get hostMaintenancePolicy(): GoogleContainerClusterNodeConfigHostMaintenancePolicyOutputReference;
    putHostMaintenancePolicy(value: GoogleContainerClusterNodeConfigHostMaintenancePolicy): void;
    resetHostMaintenancePolicy(): void;
    get hostMaintenancePolicyInput(): GoogleContainerClusterNodeConfigHostMaintenancePolicy | undefined;
    private _kubeletConfig;
    get kubeletConfig(): GoogleContainerClusterNodeConfigKubeletConfigOutputReference;
    putKubeletConfig(value: GoogleContainerClusterNodeConfigKubeletConfig): void;
    resetKubeletConfig(): void;
    get kubeletConfigInput(): GoogleContainerClusterNodeConfigKubeletConfig | undefined;
    private _linuxNodeConfig;
    get linuxNodeConfig(): GoogleContainerClusterNodeConfigLinuxNodeConfigOutputReference;
    putLinuxNodeConfig(value: GoogleContainerClusterNodeConfigLinuxNodeConfig): void;
    resetLinuxNodeConfig(): void;
    get linuxNodeConfigInput(): GoogleContainerClusterNodeConfigLinuxNodeConfig | undefined;
    private _localNvmeSsdBlockConfig;
    get localNvmeSsdBlockConfig(): GoogleContainerClusterNodeConfigLocalNvmeSsdBlockConfigOutputReference;
    putLocalNvmeSsdBlockConfig(value: GoogleContainerClusterNodeConfigLocalNvmeSsdBlockConfig): void;
    resetLocalNvmeSsdBlockConfig(): void;
    get localNvmeSsdBlockConfigInput(): GoogleContainerClusterNodeConfigLocalNvmeSsdBlockConfig | undefined;
    private _reservationAffinity;
    get reservationAffinity(): GoogleContainerClusterNodeConfigReservationAffinityOutputReference;
    putReservationAffinity(value: GoogleContainerClusterNodeConfigReservationAffinity): void;
    resetReservationAffinity(): void;
    get reservationAffinityInput(): GoogleContainerClusterNodeConfigReservationAffinity | undefined;
    private _sandboxConfig;
    get sandboxConfig(): GoogleContainerClusterNodeConfigSandboxConfigOutputReference;
    putSandboxConfig(value: GoogleContainerClusterNodeConfigSandboxConfig): void;
    resetSandboxConfig(): void;
    get sandboxConfigInput(): GoogleContainerClusterNodeConfigSandboxConfig | undefined;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): GoogleContainerClusterNodeConfigShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: GoogleContainerClusterNodeConfigShieldedInstanceConfig): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): GoogleContainerClusterNodeConfigShieldedInstanceConfig | undefined;
    private _soleTenantConfig;
    get soleTenantConfig(): GoogleContainerClusterNodeConfigSoleTenantConfigOutputReference;
    putSoleTenantConfig(value: GoogleContainerClusterNodeConfigSoleTenantConfig): void;
    resetSoleTenantConfig(): void;
    get soleTenantConfigInput(): GoogleContainerClusterNodeConfigSoleTenantConfig | undefined;
    private _taint;
    get taint(): GoogleContainerClusterNodeConfigTaintList;
    putTaint(value: GoogleContainerClusterNodeConfigTaint[] | cdktf.IResolvable): void;
    resetTaint(): void;
    get taintInput(): cdktf.IResolvable | GoogleContainerClusterNodeConfigTaint[] | undefined;
    private _workloadMetadataConfig;
    get workloadMetadataConfig(): GoogleContainerClusterNodeConfigWorkloadMetadataConfigOutputReference;
    putWorkloadMetadataConfig(value: GoogleContainerClusterNodeConfigWorkloadMetadataConfig): void;
    resetWorkloadMetadataConfig(): void;
    get workloadMetadataConfigInput(): GoogleContainerClusterNodeConfigWorkloadMetadataConfig | undefined;
}
export interface GoogleContainerClusterNodePoolAutoscaling {
    /**
    * Location policy specifies the algorithm used when scaling-up the node pool. "BALANCED" - Is a best effort policy that aims to balance the sizes of available zones. "ANY" - Instructs the cluster autoscaler to prioritize utilization of unused reservations, and reduces preemption risk for Spot VMs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#location_policy GoogleContainerCluster#location_policy}
    */
    readonly locationPolicy?: string;
    /**
    * Maximum number of nodes per zone in the node pool. Must be >= min_node_count. Cannot be used with total limits.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#max_node_count GoogleContainerCluster#max_node_count}
    */
    readonly maxNodeCount?: number;
    /**
    * Minimum number of nodes per zone in the node pool. Must be >=0 and <= max_node_count. Cannot be used with total limits.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#min_node_count GoogleContainerCluster#min_node_count}
    */
    readonly minNodeCount?: number;
    /**
    * Maximum number of all nodes in the node pool. Must be >= total_min_node_count. Cannot be used with per zone limits.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#total_max_node_count GoogleContainerCluster#total_max_node_count}
    */
    readonly totalMaxNodeCount?: number;
    /**
    * Minimum number of all nodes in the node pool. Must be >=0 and <= total_max_node_count. Cannot be used with per zone limits.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#total_min_node_count GoogleContainerCluster#total_min_node_count}
    */
    readonly totalMinNodeCount?: number;
}
export declare function googleContainerClusterNodePoolAutoscalingToTerraform(struct?: GoogleContainerClusterNodePoolAutoscalingOutputReference | GoogleContainerClusterNodePoolAutoscaling): any;
export declare function googleContainerClusterNodePoolAutoscalingToHclTerraform(struct?: GoogleContainerClusterNodePoolAutoscalingOutputReference | GoogleContainerClusterNodePoolAutoscaling): any;
export declare class GoogleContainerClusterNodePoolAutoscalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolAutoscaling | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolAutoscaling | undefined);
    private _locationPolicy?;
    get locationPolicy(): string;
    set locationPolicy(value: string);
    resetLocationPolicy(): void;
    get locationPolicyInput(): string | undefined;
    private _maxNodeCount?;
    get maxNodeCount(): number;
    set maxNodeCount(value: number);
    resetMaxNodeCount(): void;
    get maxNodeCountInput(): number | undefined;
    private _minNodeCount?;
    get minNodeCount(): number;
    set minNodeCount(value: number);
    resetMinNodeCount(): void;
    get minNodeCountInput(): number | undefined;
    private _totalMaxNodeCount?;
    get totalMaxNodeCount(): number;
    set totalMaxNodeCount(value: number);
    resetTotalMaxNodeCount(): void;
    get totalMaxNodeCountInput(): number | undefined;
    private _totalMinNodeCount?;
    get totalMinNodeCount(): number;
    set totalMinNodeCount(value: number);
    resetTotalMinNodeCount(): void;
    get totalMinNodeCountInput(): number | undefined;
}
export interface GoogleContainerClusterNodePoolManagement {
    /**
    * Whether the nodes will be automatically repaired. Enabled by default.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#auto_repair GoogleContainerCluster#auto_repair}
    */
    readonly autoRepair?: boolean | cdktf.IResolvable;
    /**
    * Whether the nodes will be automatically upgraded. Enabled by default.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#auto_upgrade GoogleContainerCluster#auto_upgrade}
    */
    readonly autoUpgrade?: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterNodePoolManagementToTerraform(struct?: GoogleContainerClusterNodePoolManagementOutputReference | GoogleContainerClusterNodePoolManagement): any;
export declare function googleContainerClusterNodePoolManagementToHclTerraform(struct?: GoogleContainerClusterNodePoolManagementOutputReference | GoogleContainerClusterNodePoolManagement): any;
export declare class GoogleContainerClusterNodePoolManagementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolManagement | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolManagement | undefined);
    private _autoRepair?;
    get autoRepair(): boolean | cdktf.IResolvable;
    set autoRepair(value: boolean | cdktf.IResolvable);
    resetAutoRepair(): void;
    get autoRepairInput(): boolean | cdktf.IResolvable | undefined;
    private _autoUpgrade?;
    get autoUpgrade(): boolean | cdktf.IResolvable;
    set autoUpgrade(value: boolean | cdktf.IResolvable);
    resetAutoUpgrade(): void;
    get autoUpgradeInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterNodePoolNetworkConfigAdditionalNodeNetworkConfigs {
    /**
    * Name of the VPC where the additional interface belongs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#network GoogleContainerCluster#network}
    */
    readonly network?: string;
    /**
    * Name of the subnetwork where the additional interface belongs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#subnetwork GoogleContainerCluster#subnetwork}
    */
    readonly subnetwork?: string;
}
export declare function googleContainerClusterNodePoolNetworkConfigAdditionalNodeNetworkConfigsToTerraform(struct?: GoogleContainerClusterNodePoolNetworkConfigAdditionalNodeNetworkConfigs | cdktf.IResolvable): any;
export declare function googleContainerClusterNodePoolNetworkConfigAdditionalNodeNetworkConfigsToHclTerraform(struct?: GoogleContainerClusterNodePoolNetworkConfigAdditionalNodeNetworkConfigs | cdktf.IResolvable): any;
export declare class GoogleContainerClusterNodePoolNetworkConfigAdditionalNodeNetworkConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerClusterNodePoolNetworkConfigAdditionalNodeNetworkConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNetworkConfigAdditionalNodeNetworkConfigs | cdktf.IResolvable | undefined);
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
}
export declare class GoogleContainerClusterNodePoolNetworkConfigAdditionalNodeNetworkConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerClusterNodePoolNetworkConfigAdditionalNodeNetworkConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerClusterNodePoolNetworkConfigAdditionalNodeNetworkConfigsOutputReference;
}
export interface GoogleContainerClusterNodePoolNetworkConfigAdditionalPodNetworkConfigs {
    /**
    * The maximum number of pods per node which use this pod network.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#max_pods_per_node GoogleContainerCluster#max_pods_per_node}
    */
    readonly maxPodsPerNode?: number;
    /**
    * The name of the secondary range on the subnet which provides IP address for this pod range.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#secondary_pod_range GoogleContainerCluster#secondary_pod_range}
    */
    readonly secondaryPodRange?: string;
    /**
    * Name of the subnetwork where the additional pod network belongs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#subnetwork GoogleContainerCluster#subnetwork}
    */
    readonly subnetwork?: string;
}
export declare function googleContainerClusterNodePoolNetworkConfigAdditionalPodNetworkConfigsToTerraform(struct?: GoogleContainerClusterNodePoolNetworkConfigAdditionalPodNetworkConfigs | cdktf.IResolvable): any;
export declare function googleContainerClusterNodePoolNetworkConfigAdditionalPodNetworkConfigsToHclTerraform(struct?: GoogleContainerClusterNodePoolNetworkConfigAdditionalPodNetworkConfigs | cdktf.IResolvable): any;
export declare class GoogleContainerClusterNodePoolNetworkConfigAdditionalPodNetworkConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerClusterNodePoolNetworkConfigAdditionalPodNetworkConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNetworkConfigAdditionalPodNetworkConfigs | cdktf.IResolvable | undefined);
    private _maxPodsPerNode?;
    get maxPodsPerNode(): number;
    set maxPodsPerNode(value: number);
    resetMaxPodsPerNode(): void;
    get maxPodsPerNodeInput(): number | undefined;
    private _secondaryPodRange?;
    get secondaryPodRange(): string;
    set secondaryPodRange(value: string);
    resetSecondaryPodRange(): void;
    get secondaryPodRangeInput(): string | undefined;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
}
export declare class GoogleContainerClusterNodePoolNetworkConfigAdditionalPodNetworkConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerClusterNodePoolNetworkConfigAdditionalPodNetworkConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerClusterNodePoolNetworkConfigAdditionalPodNetworkConfigsOutputReference;
}
export interface GoogleContainerClusterNodePoolNetworkConfigNetworkPerformanceConfig {
    /**
    * Specifies the total network bandwidth tier for the NodePool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#total_egress_bandwidth_tier GoogleContainerCluster#total_egress_bandwidth_tier}
    */
    readonly totalEgressBandwidthTier: string;
}
export declare function googleContainerClusterNodePoolNetworkConfigNetworkPerformanceConfigToTerraform(struct?: GoogleContainerClusterNodePoolNetworkConfigNetworkPerformanceConfigOutputReference | GoogleContainerClusterNodePoolNetworkConfigNetworkPerformanceConfig): any;
export declare function googleContainerClusterNodePoolNetworkConfigNetworkPerformanceConfigToHclTerraform(struct?: GoogleContainerClusterNodePoolNetworkConfigNetworkPerformanceConfigOutputReference | GoogleContainerClusterNodePoolNetworkConfigNetworkPerformanceConfig): any;
export declare class GoogleContainerClusterNodePoolNetworkConfigNetworkPerformanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNetworkConfigNetworkPerformanceConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNetworkConfigNetworkPerformanceConfig | undefined);
    private _totalEgressBandwidthTier?;
    get totalEgressBandwidthTier(): string;
    set totalEgressBandwidthTier(value: string);
    get totalEgressBandwidthTierInput(): string | undefined;
}
export interface GoogleContainerClusterNodePoolNetworkConfigPodCidrOverprovisionConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#disabled GoogleContainerCluster#disabled}
    */
    readonly disabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterNodePoolNetworkConfigPodCidrOverprovisionConfigToTerraform(struct?: GoogleContainerClusterNodePoolNetworkConfigPodCidrOverprovisionConfigOutputReference | GoogleContainerClusterNodePoolNetworkConfigPodCidrOverprovisionConfig): any;
export declare function googleContainerClusterNodePoolNetworkConfigPodCidrOverprovisionConfigToHclTerraform(struct?: GoogleContainerClusterNodePoolNetworkConfigPodCidrOverprovisionConfigOutputReference | GoogleContainerClusterNodePoolNetworkConfigPodCidrOverprovisionConfig): any;
export declare class GoogleContainerClusterNodePoolNetworkConfigPodCidrOverprovisionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNetworkConfigPodCidrOverprovisionConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNetworkConfigPodCidrOverprovisionConfig | undefined);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterNodePoolNetworkConfig {
    /**
    * Whether to create a new range for pod IPs in this node pool. Defaults are provided for pod_range and pod_ipv4_cidr_block if they are not specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#create_pod_range GoogleContainerCluster#create_pod_range}
    */
    readonly createPodRange?: boolean | cdktf.IResolvable;
    /**
    * Whether nodes have internal IP addresses only.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enable_private_nodes GoogleContainerCluster#enable_private_nodes}
    */
    readonly enablePrivateNodes?: boolean | cdktf.IResolvable;
    /**
    * The IP address range for pod IPs in this node pool. Only applicable if create_pod_range is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. /14) to have a range chosen with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) to pick a specific range to use.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#pod_ipv4_cidr_block GoogleContainerCluster#pod_ipv4_cidr_block}
    */
    readonly podIpv4CidrBlock?: string;
    /**
    * The ID of the secondary range for pod IPs. If create_pod_range is true, this ID is used for the new range. If create_pod_range is false, uses an existing secondary range with this ID.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#pod_range GoogleContainerCluster#pod_range}
    */
    readonly podRange?: string;
    /**
    * additional_node_network_configs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#additional_node_network_configs GoogleContainerCluster#additional_node_network_configs}
    */
    readonly additionalNodeNetworkConfigs?: GoogleContainerClusterNodePoolNetworkConfigAdditionalNodeNetworkConfigs[] | cdktf.IResolvable;
    /**
    * additional_pod_network_configs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#additional_pod_network_configs GoogleContainerCluster#additional_pod_network_configs}
    */
    readonly additionalPodNetworkConfigs?: GoogleContainerClusterNodePoolNetworkConfigAdditionalPodNetworkConfigs[] | cdktf.IResolvable;
    /**
    * network_performance_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#network_performance_config GoogleContainerCluster#network_performance_config}
    */
    readonly networkPerformanceConfig?: GoogleContainerClusterNodePoolNetworkConfigNetworkPerformanceConfig;
    /**
    * pod_cidr_overprovision_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#pod_cidr_overprovision_config GoogleContainerCluster#pod_cidr_overprovision_config}
    */
    readonly podCidrOverprovisionConfig?: GoogleContainerClusterNodePoolNetworkConfigPodCidrOverprovisionConfig;
}
export declare function googleContainerClusterNodePoolNetworkConfigToTerraform(struct?: GoogleContainerClusterNodePoolNetworkConfigOutputReference | GoogleContainerClusterNodePoolNetworkConfig): any;
export declare function googleContainerClusterNodePoolNetworkConfigToHclTerraform(struct?: GoogleContainerClusterNodePoolNetworkConfigOutputReference | GoogleContainerClusterNodePoolNetworkConfig): any;
export declare class GoogleContainerClusterNodePoolNetworkConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNetworkConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNetworkConfig | undefined);
    private _createPodRange?;
    get createPodRange(): boolean | cdktf.IResolvable;
    set createPodRange(value: boolean | cdktf.IResolvable);
    resetCreatePodRange(): void;
    get createPodRangeInput(): boolean | cdktf.IResolvable | undefined;
    private _enablePrivateNodes?;
    get enablePrivateNodes(): boolean | cdktf.IResolvable;
    set enablePrivateNodes(value: boolean | cdktf.IResolvable);
    resetEnablePrivateNodes(): void;
    get enablePrivateNodesInput(): boolean | cdktf.IResolvable | undefined;
    private _podIpv4CidrBlock?;
    get podIpv4CidrBlock(): string;
    set podIpv4CidrBlock(value: string);
    resetPodIpv4CidrBlock(): void;
    get podIpv4CidrBlockInput(): string | undefined;
    private _podRange?;
    get podRange(): string;
    set podRange(value: string);
    resetPodRange(): void;
    get podRangeInput(): string | undefined;
    private _additionalNodeNetworkConfigs;
    get additionalNodeNetworkConfigs(): GoogleContainerClusterNodePoolNetworkConfigAdditionalNodeNetworkConfigsList;
    putAdditionalNodeNetworkConfigs(value: GoogleContainerClusterNodePoolNetworkConfigAdditionalNodeNetworkConfigs[] | cdktf.IResolvable): void;
    resetAdditionalNodeNetworkConfigs(): void;
    get additionalNodeNetworkConfigsInput(): cdktf.IResolvable | GoogleContainerClusterNodePoolNetworkConfigAdditionalNodeNetworkConfigs[] | undefined;
    private _additionalPodNetworkConfigs;
    get additionalPodNetworkConfigs(): GoogleContainerClusterNodePoolNetworkConfigAdditionalPodNetworkConfigsList;
    putAdditionalPodNetworkConfigs(value: GoogleContainerClusterNodePoolNetworkConfigAdditionalPodNetworkConfigs[] | cdktf.IResolvable): void;
    resetAdditionalPodNetworkConfigs(): void;
    get additionalPodNetworkConfigsInput(): cdktf.IResolvable | GoogleContainerClusterNodePoolNetworkConfigAdditionalPodNetworkConfigs[] | undefined;
    private _networkPerformanceConfig;
    get networkPerformanceConfig(): GoogleContainerClusterNodePoolNetworkConfigNetworkPerformanceConfigOutputReference;
    putNetworkPerformanceConfig(value: GoogleContainerClusterNodePoolNetworkConfigNetworkPerformanceConfig): void;
    resetNetworkPerformanceConfig(): void;
    get networkPerformanceConfigInput(): GoogleContainerClusterNodePoolNetworkConfigNetworkPerformanceConfig | undefined;
    private _podCidrOverprovisionConfig;
    get podCidrOverprovisionConfig(): GoogleContainerClusterNodePoolNetworkConfigPodCidrOverprovisionConfigOutputReference;
    putPodCidrOverprovisionConfig(value: GoogleContainerClusterNodePoolNetworkConfigPodCidrOverprovisionConfig): void;
    resetPodCidrOverprovisionConfig(): void;
    get podCidrOverprovisionConfigInput(): GoogleContainerClusterNodePoolNetworkConfigPodCidrOverprovisionConfig | undefined;
}
export interface GoogleContainerClusterNodePoolNodeConfigEffectiveTaints {
}
export declare function googleContainerClusterNodePoolNodeConfigEffectiveTaintsToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigEffectiveTaints): any;
export declare function googleContainerClusterNodePoolNodeConfigEffectiveTaintsToHclTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigEffectiveTaints): any;
export declare class GoogleContainerClusterNodePoolNodeConfigEffectiveTaintsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigEffectiveTaints | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigEffectiveTaints | undefined);
    get effect(): string;
    get key(): string;
    get value(): string;
}
export declare class GoogleContainerClusterNodePoolNodeConfigEffectiveTaintsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerClusterNodePoolNodeConfigEffectiveTaintsOutputReference;
}
export interface GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuDriverInstallationConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#gpu_driver_version GoogleContainerCluster#gpu_driver_version}
    */
    readonly gpuDriverVersion?: string;
}
export declare function googleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuDriverInstallationConfigToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuDriverInstallationConfig | cdktf.IResolvable): any;
export declare function googleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuDriverInstallationConfigToHclTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuDriverInstallationConfig | cdktf.IResolvable): any;
export declare class GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuDriverInstallationConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuDriverInstallationConfig | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuDriverInstallationConfig | cdktf.IResolvable | undefined);
    private _gpuDriverVersion?;
    get gpuDriverVersion(): string;
    set gpuDriverVersion(value: string);
    resetGpuDriverVersion(): void;
    get gpuDriverVersionInput(): string | undefined;
}
export declare class GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuDriverInstallationConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuDriverInstallationConfig[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuDriverInstallationConfigOutputReference;
}
export interface GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#gpu_sharing_strategy GoogleContainerCluster#gpu_sharing_strategy}
    */
    readonly gpuSharingStrategy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#max_shared_clients_per_gpu GoogleContainerCluster#max_shared_clients_per_gpu}
    */
    readonly maxSharedClientsPerGpu?: number;
}
export declare function googleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfigToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig | cdktf.IResolvable): any;
export declare function googleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfigToHclTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig | cdktf.IResolvable): any;
export declare class GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig | cdktf.IResolvable | undefined);
    private _gpuSharingStrategy?;
    get gpuSharingStrategy(): string;
    set gpuSharingStrategy(value: string);
    resetGpuSharingStrategy(): void;
    get gpuSharingStrategyInput(): string | undefined;
    private _maxSharedClientsPerGpu?;
    get maxSharedClientsPerGpu(): number;
    set maxSharedClientsPerGpu(value: number);
    resetMaxSharedClientsPerGpu(): void;
    get maxSharedClientsPerGpuInput(): number | undefined;
}
export declare class GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfigOutputReference;
}
export interface GoogleContainerClusterNodePoolNodeConfigGuestAccelerator {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#count GoogleContainerCluster#count}
    */
    readonly count?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#gpu_driver_installation_config GoogleContainerCluster#gpu_driver_installation_config}
    */
    readonly gpuDriverInstallationConfig?: GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuDriverInstallationConfig[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#gpu_partition_size GoogleContainerCluster#gpu_partition_size}
    */
    readonly gpuPartitionSize?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#gpu_sharing_config GoogleContainerCluster#gpu_sharing_config}
    */
    readonly gpuSharingConfig?: GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#type GoogleContainerCluster#type}
    */
    readonly type?: string;
}
export declare function googleContainerClusterNodePoolNodeConfigGuestAcceleratorToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigGuestAccelerator | cdktf.IResolvable): any;
export declare function googleContainerClusterNodePoolNodeConfigGuestAcceleratorToHclTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigGuestAccelerator | cdktf.IResolvable): any;
export declare class GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigGuestAccelerator | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigGuestAccelerator | cdktf.IResolvable | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _gpuDriverInstallationConfig;
    get gpuDriverInstallationConfig(): GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuDriverInstallationConfigList;
    putGpuDriverInstallationConfig(value: GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuDriverInstallationConfig[] | cdktf.IResolvable): void;
    resetGpuDriverInstallationConfig(): void;
    get gpuDriverInstallationConfigInput(): cdktf.IResolvable | GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuDriverInstallationConfig[] | undefined;
    private _gpuPartitionSize?;
    get gpuPartitionSize(): string;
    set gpuPartitionSize(value: string);
    resetGpuPartitionSize(): void;
    get gpuPartitionSizeInput(): string | undefined;
    private _gpuSharingConfig;
    get gpuSharingConfig(): GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfigList;
    putGpuSharingConfig(value: GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig[] | cdktf.IResolvable): void;
    resetGpuSharingConfig(): void;
    get gpuSharingConfigInput(): cdktf.IResolvable | GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerClusterNodePoolNodeConfigGuestAccelerator[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorOutputReference;
}
export interface GoogleContainerClusterNodePoolNodeConfigAdvancedMachineFeatures {
    /**
    * The number of threads per physical core. To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#threads_per_core GoogleContainerCluster#threads_per_core}
    */
    readonly threadsPerCore: number;
}
export declare function googleContainerClusterNodePoolNodeConfigAdvancedMachineFeaturesToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigAdvancedMachineFeaturesOutputReference | GoogleContainerClusterNodePoolNodeConfigAdvancedMachineFeatures): any;
export declare function googleContainerClusterNodePoolNodeConfigAdvancedMachineFeaturesToHclTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigAdvancedMachineFeaturesOutputReference | GoogleContainerClusterNodePoolNodeConfigAdvancedMachineFeatures): any;
export declare class GoogleContainerClusterNodePoolNodeConfigAdvancedMachineFeaturesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigAdvancedMachineFeatures | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigAdvancedMachineFeatures | undefined);
    private _threadsPerCore?;
    get threadsPerCore(): number;
    set threadsPerCore(value: number);
    get threadsPerCoreInput(): number | undefined;
}
export interface GoogleContainerClusterNodePoolNodeConfigConfidentialNodes {
    /**
    * Whether Confidential Nodes feature is enabled for all nodes in this pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterNodePoolNodeConfigConfidentialNodesToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigConfidentialNodesOutputReference | GoogleContainerClusterNodePoolNodeConfigConfidentialNodes): any;
export declare function googleContainerClusterNodePoolNodeConfigConfidentialNodesToHclTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigConfidentialNodesOutputReference | GoogleContainerClusterNodePoolNodeConfigConfidentialNodes): any;
export declare class GoogleContainerClusterNodePoolNodeConfigConfidentialNodesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigConfidentialNodes | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigConfidentialNodes | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfig {
    /**
    * Number of local SSDs to use to back ephemeral storage. Uses NVMe interfaces. Each local SSD must be 375 or 3000 GB in size, and all local SSDs must share the same size.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#local_ssd_count GoogleContainerCluster#local_ssd_count}
    */
    readonly localSsdCount: number;
}
export declare function googleContainerClusterNodePoolNodeConfigEphemeralStorageConfigToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfigOutputReference | GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfig): any;
export declare function googleContainerClusterNodePoolNodeConfigEphemeralStorageConfigToHclTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfigOutputReference | GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfig): any;
export declare class GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfig | undefined);
    private _localSsdCount?;
    get localSsdCount(): number;
    set localSsdCount(value: number);
    get localSsdCountInput(): number | undefined;
}
export interface GoogleContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig {
    /**
    * Number of local SSDs to use to back ephemeral storage. Uses NVMe interfaces. Each local SSD must be 375 or 3000 GB in size, and all local SSDs must share the same size.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#local_ssd_count GoogleContainerCluster#local_ssd_count}
    */
    readonly localSsdCount: number;
}
export declare function googleContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfigToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfigOutputReference | GoogleContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig): any;
export declare function googleContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfigToHclTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfigOutputReference | GoogleContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig): any;
export declare class GoogleContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig | undefined);
    private _localSsdCount?;
    get localSsdCount(): number;
    set localSsdCount(value: number);
    get localSsdCountInput(): number | undefined;
}
export interface GoogleContainerClusterNodePoolNodeConfigFastSocket {
    /**
    * Whether or not NCCL Fast Socket is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterNodePoolNodeConfigFastSocketToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigFastSocketOutputReference | GoogleContainerClusterNodePoolNodeConfigFastSocket): any;
export declare function googleContainerClusterNodePoolNodeConfigFastSocketToHclTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigFastSocketOutputReference | GoogleContainerClusterNodePoolNodeConfigFastSocket): any;
export declare class GoogleContainerClusterNodePoolNodeConfigFastSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigFastSocket | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigFastSocket | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterNodePoolNodeConfigGcfsConfig {
    /**
    * Whether or not GCFS is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterNodePoolNodeConfigGcfsConfigToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigGcfsConfigOutputReference | GoogleContainerClusterNodePoolNodeConfigGcfsConfig): any;
export declare function googleContainerClusterNodePoolNodeConfigGcfsConfigToHclTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigGcfsConfigOutputReference | GoogleContainerClusterNodePoolNodeConfigGcfsConfig): any;
export declare class GoogleContainerClusterNodePoolNodeConfigGcfsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigGcfsConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigGcfsConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterNodePoolNodeConfigGvnic {
    /**
    * Whether or not gvnic is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterNodePoolNodeConfigGvnicToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigGvnicOutputReference | GoogleContainerClusterNodePoolNodeConfigGvnic): any;
export declare function googleContainerClusterNodePoolNodeConfigGvnicToHclTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigGvnicOutputReference | GoogleContainerClusterNodePoolNodeConfigGvnic): any;
export declare class GoogleContainerClusterNodePoolNodeConfigGvnicOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigGvnic | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigGvnic | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterNodePoolNodeConfigHostMaintenancePolicy {
    /**
    * .
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#maintenance_interval GoogleContainerCluster#maintenance_interval}
    */
    readonly maintenanceInterval: string;
}
export declare function googleContainerClusterNodePoolNodeConfigHostMaintenancePolicyToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigHostMaintenancePolicyOutputReference | GoogleContainerClusterNodePoolNodeConfigHostMaintenancePolicy): any;
export declare function googleContainerClusterNodePoolNodeConfigHostMaintenancePolicyToHclTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigHostMaintenancePolicyOutputReference | GoogleContainerClusterNodePoolNodeConfigHostMaintenancePolicy): any;
export declare class GoogleContainerClusterNodePoolNodeConfigHostMaintenancePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigHostMaintenancePolicy | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigHostMaintenancePolicy | undefined);
    private _maintenanceInterval?;
    get maintenanceInterval(): string;
    set maintenanceInterval(value: string);
    get maintenanceIntervalInput(): string | undefined;
}
export interface GoogleContainerClusterNodePoolNodeConfigKubeletConfig {
    /**
    * Enable CPU CFS quota enforcement for containers that specify CPU limits.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#cpu_cfs_quota GoogleContainerCluster#cpu_cfs_quota}
    */
    readonly cpuCfsQuota?: boolean | cdktf.IResolvable;
    /**
    * Set the CPU CFS quota period value 'cpu.cfs_period_us'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#cpu_cfs_quota_period GoogleContainerCluster#cpu_cfs_quota_period}
    */
    readonly cpuCfsQuotaPeriod?: string;
    /**
    * Control the CPU management policy on the node.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#cpu_manager_policy GoogleContainerCluster#cpu_manager_policy}
    */
    readonly cpuManagerPolicy: string;
    /**
    * Controls the maximum number of processes allowed to run in a pod.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#pod_pids_limit GoogleContainerCluster#pod_pids_limit}
    */
    readonly podPidsLimit?: number;
}
export declare function googleContainerClusterNodePoolNodeConfigKubeletConfigToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigKubeletConfigOutputReference | GoogleContainerClusterNodePoolNodeConfigKubeletConfig): any;
export declare function googleContainerClusterNodePoolNodeConfigKubeletConfigToHclTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigKubeletConfigOutputReference | GoogleContainerClusterNodePoolNodeConfigKubeletConfig): any;
export declare class GoogleContainerClusterNodePoolNodeConfigKubeletConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigKubeletConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigKubeletConfig | undefined);
    private _cpuCfsQuota?;
    get cpuCfsQuota(): boolean | cdktf.IResolvable;
    set cpuCfsQuota(value: boolean | cdktf.IResolvable);
    resetCpuCfsQuota(): void;
    get cpuCfsQuotaInput(): boolean | cdktf.IResolvable | undefined;
    private _cpuCfsQuotaPeriod?;
    get cpuCfsQuotaPeriod(): string;
    set cpuCfsQuotaPeriod(value: string);
    resetCpuCfsQuotaPeriod(): void;
    get cpuCfsQuotaPeriodInput(): string | undefined;
    private _cpuManagerPolicy?;
    get cpuManagerPolicy(): string;
    set cpuManagerPolicy(value: string);
    get cpuManagerPolicyInput(): string | undefined;
    private _podPidsLimit?;
    get podPidsLimit(): number;
    set podPidsLimit(value: number);
    resetPodPidsLimit(): void;
    get podPidsLimitInput(): number | undefined;
}
export interface GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfig {
    /**
    * cgroupMode specifies the cgroup mode to be used on the node.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#cgroup_mode GoogleContainerCluster#cgroup_mode}
    */
    readonly cgroupMode?: string;
    /**
    * The Linux kernel parameters to be applied to the nodes and all pods running on the nodes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#sysctls GoogleContainerCluster#sysctls}
    */
    readonly sysctls?: {
        [key: string]: string;
    };
}
export declare function googleContainerClusterNodePoolNodeConfigLinuxNodeConfigToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfigOutputReference | GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfig): any;
export declare function googleContainerClusterNodePoolNodeConfigLinuxNodeConfigToHclTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfigOutputReference | GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfig): any;
export declare class GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfig | undefined);
    private _cgroupMode?;
    get cgroupMode(): string;
    set cgroupMode(value: string);
    resetCgroupMode(): void;
    get cgroupModeInput(): string | undefined;
    private _sysctls?;
    get sysctls(): {
        [key: string]: string;
    };
    set sysctls(value: {
        [key: string]: string;
    });
    resetSysctls(): void;
    get sysctlsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig {
    /**
    * Number of raw-block local NVMe SSD disks to be attached to the node. Each local SSD is 375 GB in size.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#local_ssd_count GoogleContainerCluster#local_ssd_count}
    */
    readonly localSsdCount: number;
}
export declare function googleContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfigToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfigOutputReference | GoogleContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig): any;
export declare function googleContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfigToHclTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfigOutputReference | GoogleContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig): any;
export declare class GoogleContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig | undefined);
    private _localSsdCount?;
    get localSsdCount(): number;
    set localSsdCount(value: number);
    get localSsdCountInput(): number | undefined;
}
export interface GoogleContainerClusterNodePoolNodeConfigReservationAffinity {
    /**
    * Corresponds to the type of reservation consumption.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#consume_reservation_type GoogleContainerCluster#consume_reservation_type}
    */
    readonly consumeReservationType: string;
    /**
    * The label key of a reservation resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#key GoogleContainerCluster#key}
    */
    readonly key?: string;
    /**
    * The label values of the reservation resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#values GoogleContainerCluster#values}
    */
    readonly values?: string[];
}
export declare function googleContainerClusterNodePoolNodeConfigReservationAffinityToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigReservationAffinityOutputReference | GoogleContainerClusterNodePoolNodeConfigReservationAffinity): any;
export declare function googleContainerClusterNodePoolNodeConfigReservationAffinityToHclTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigReservationAffinityOutputReference | GoogleContainerClusterNodePoolNodeConfigReservationAffinity): any;
export declare class GoogleContainerClusterNodePoolNodeConfigReservationAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigReservationAffinity | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigReservationAffinity | undefined);
    private _consumeReservationType?;
    get consumeReservationType(): string;
    set consumeReservationType(value: string);
    get consumeReservationTypeInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface GoogleContainerClusterNodePoolNodeConfigSandboxConfig {
    /**
    * Type of the sandbox to use for the node (e.g. 'gvisor')
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#sandbox_type GoogleContainerCluster#sandbox_type}
    */
    readonly sandboxType: string;
}
export declare function googleContainerClusterNodePoolNodeConfigSandboxConfigToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigSandboxConfigOutputReference | GoogleContainerClusterNodePoolNodeConfigSandboxConfig): any;
export declare function googleContainerClusterNodePoolNodeConfigSandboxConfigToHclTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigSandboxConfigOutputReference | GoogleContainerClusterNodePoolNodeConfigSandboxConfig): any;
export declare class GoogleContainerClusterNodePoolNodeConfigSandboxConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigSandboxConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigSandboxConfig | undefined);
    private _sandboxType?;
    get sandboxType(): string;
    set sandboxType(value: string);
    get sandboxTypeInput(): string | undefined;
}
export interface GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig {
    /**
    * Defines whether the instance has integrity monitoring enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enable_integrity_monitoring GoogleContainerCluster#enable_integrity_monitoring}
    */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Defines whether the instance has Secure Boot enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enable_secure_boot GoogleContainerCluster#enable_secure_boot}
    */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterNodePoolNodeConfigShieldedInstanceConfigToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfigOutputReference | GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig): any;
export declare function googleContainerClusterNodePoolNodeConfigShieldedInstanceConfigToHclTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfigOutputReference | GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig): any;
export declare class GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterNodePoolNodeConfigSoleTenantConfigNodeAffinity {
    /**
    * .
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#key GoogleContainerCluster#key}
    */
    readonly key: string;
    /**
    * .
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#operator GoogleContainerCluster#operator}
    */
    readonly operator: string;
    /**
    * .
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#values GoogleContainerCluster#values}
    */
    readonly values: string[];
}
export declare function googleContainerClusterNodePoolNodeConfigSoleTenantConfigNodeAffinityToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigSoleTenantConfigNodeAffinity | cdktf.IResolvable): any;
export declare function googleContainerClusterNodePoolNodeConfigSoleTenantConfigNodeAffinityToHclTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigSoleTenantConfigNodeAffinity | cdktf.IResolvable): any;
export declare class GoogleContainerClusterNodePoolNodeConfigSoleTenantConfigNodeAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigSoleTenantConfigNodeAffinity | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigSoleTenantConfigNodeAffinity | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class GoogleContainerClusterNodePoolNodeConfigSoleTenantConfigNodeAffinityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerClusterNodePoolNodeConfigSoleTenantConfigNodeAffinity[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerClusterNodePoolNodeConfigSoleTenantConfigNodeAffinityOutputReference;
}
export interface GoogleContainerClusterNodePoolNodeConfigSoleTenantConfig {
    /**
    * node_affinity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#node_affinity GoogleContainerCluster#node_affinity}
    */
    readonly nodeAffinity: GoogleContainerClusterNodePoolNodeConfigSoleTenantConfigNodeAffinity[] | cdktf.IResolvable;
}
export declare function googleContainerClusterNodePoolNodeConfigSoleTenantConfigToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigSoleTenantConfigOutputReference | GoogleContainerClusterNodePoolNodeConfigSoleTenantConfig): any;
export declare function googleContainerClusterNodePoolNodeConfigSoleTenantConfigToHclTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigSoleTenantConfigOutputReference | GoogleContainerClusterNodePoolNodeConfigSoleTenantConfig): any;
export declare class GoogleContainerClusterNodePoolNodeConfigSoleTenantConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigSoleTenantConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigSoleTenantConfig | undefined);
    private _nodeAffinity;
    get nodeAffinity(): GoogleContainerClusterNodePoolNodeConfigSoleTenantConfigNodeAffinityList;
    putNodeAffinity(value: GoogleContainerClusterNodePoolNodeConfigSoleTenantConfigNodeAffinity[] | cdktf.IResolvable): void;
    get nodeAffinityInput(): cdktf.IResolvable | GoogleContainerClusterNodePoolNodeConfigSoleTenantConfigNodeAffinity[] | undefined;
}
export interface GoogleContainerClusterNodePoolNodeConfigTaint {
    /**
    * Effect for taint.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#effect GoogleContainerCluster#effect}
    */
    readonly effect: string;
    /**
    * Key for taint.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#key GoogleContainerCluster#key}
    */
    readonly key: string;
    /**
    * Value for taint.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#value GoogleContainerCluster#value}
    */
    readonly value: string;
}
export declare function googleContainerClusterNodePoolNodeConfigTaintToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigTaint | cdktf.IResolvable): any;
export declare function googleContainerClusterNodePoolNodeConfigTaintToHclTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigTaint | cdktf.IResolvable): any;
export declare class GoogleContainerClusterNodePoolNodeConfigTaintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigTaint | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigTaint | cdktf.IResolvable | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class GoogleContainerClusterNodePoolNodeConfigTaintList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerClusterNodePoolNodeConfigTaint[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerClusterNodePoolNodeConfigTaintOutputReference;
}
export interface GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig {
    /**
    * Mode is the configuration for how to expose metadata to workloads running on the node.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#mode GoogleContainerCluster#mode}
    */
    readonly mode: string;
}
export declare function googleContainerClusterNodePoolNodeConfigWorkloadMetadataConfigToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfigOutputReference | GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig): any;
export declare function googleContainerClusterNodePoolNodeConfigWorkloadMetadataConfigToHclTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfigOutputReference | GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig): any;
export declare class GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
}
export interface GoogleContainerClusterNodePoolNodeConfig {
    /**
    * The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#boot_disk_kms_key GoogleContainerCluster#boot_disk_kms_key}
    */
    readonly bootDiskKmsKey?: string;
    /**
    * Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#disk_size_gb GoogleContainerCluster#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * Type of the disk attached to each node. Such as pd-standard, pd-balanced or pd-ssd
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#disk_type GoogleContainerCluster#disk_type}
    */
    readonly diskType?: string;
    /**
    * If enabled boot disks are configured with confidential mode.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enable_confidential_storage GoogleContainerCluster#enable_confidential_storage}
    */
    readonly enableConfidentialStorage?: boolean | cdktf.IResolvable;
    /**
    * List of the type and count of accelerator cards attached to the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#guest_accelerator GoogleContainerCluster#guest_accelerator}
    */
    readonly guestAccelerator?: GoogleContainerClusterNodePoolNodeConfigGuestAccelerator[] | cdktf.IResolvable;
    /**
    * The image type to use for this node. Note that for a given image type, the latest version of it will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#image_type GoogleContainerCluster#image_type}
    */
    readonly imageType?: string;
    /**
    * The map of Kubernetes labels (key/value pairs) to be applied to each node. These will added in addition to any default label(s) that Kubernetes may apply to the node.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#labels GoogleContainerCluster#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The number of local SSD disks to be attached to the node.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#local_ssd_count GoogleContainerCluster#local_ssd_count}
    */
    readonly localSsdCount?: number;
    /**
    * Type of logging agent that is used as the default value for node pools in the cluster. Valid values include DEFAULT and MAX_THROUGHPUT.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#logging_variant GoogleContainerCluster#logging_variant}
    */
    readonly loggingVariant?: string;
    /**
    * The name of a Google Compute Engine machine type.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#machine_type GoogleContainerCluster#machine_type}
    */
    readonly machineType?: string;
    /**
    * The metadata key/value pairs assigned to instances in the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#metadata GoogleContainerCluster#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Minimum CPU platform to be used by this instance. The instance may be scheduled on the specified or newer CPU platform.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#min_cpu_platform GoogleContainerCluster#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * Setting this field will assign instances of this pool to run on the specified node group. This is useful for running workloads on sole tenant nodes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#node_group GoogleContainerCluster#node_group}
    */
    readonly nodeGroup?: string;
    /**
    * The set of Google API scopes to be made available on all of the node VMs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#oauth_scopes GoogleContainerCluster#oauth_scopes}
    */
    readonly oauthScopes?: string[];
    /**
    * Whether the nodes are created as preemptible VM instances.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#preemptible GoogleContainerCluster#preemptible}
    */
    readonly preemptible?: boolean | cdktf.IResolvable;
    /**
    * The GCE resource labels (a map of key/value pairs) to be applied to the node pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#resource_labels GoogleContainerCluster#resource_labels}
    */
    readonly resourceLabels?: {
        [key: string]: string;
    };
    /**
    * A map of resource manager tags. Resource manager tag keys and values have the same definition as resource manager tags. Keys must be in the format tagKeys/{tag_key_id}, and values are in the format tagValues/456. The field is ignored (both PUT & PATCH) when empty.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#resource_manager_tags GoogleContainerCluster#resource_manager_tags}
    */
    readonly resourceManagerTags?: {
        [key: string]: string;
    };
    /**
    * The Google Cloud Platform Service Account to be used by the node VMs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#service_account GoogleContainerCluster#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * Whether the nodes are created as spot VM instances.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#spot GoogleContainerCluster#spot}
    */
    readonly spot?: boolean | cdktf.IResolvable;
    /**
    * The list of instance tags applied to all nodes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#tags GoogleContainerCluster#tags}
    */
    readonly tags?: string[];
    /**
    * advanced_machine_features block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#advanced_machine_features GoogleContainerCluster#advanced_machine_features}
    */
    readonly advancedMachineFeatures?: GoogleContainerClusterNodePoolNodeConfigAdvancedMachineFeatures;
    /**
    * confidential_nodes block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#confidential_nodes GoogleContainerCluster#confidential_nodes}
    */
    readonly confidentialNodes?: GoogleContainerClusterNodePoolNodeConfigConfidentialNodes;
    /**
    * ephemeral_storage_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#ephemeral_storage_config GoogleContainerCluster#ephemeral_storage_config}
    */
    readonly ephemeralStorageConfig?: GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfig;
    /**
    * ephemeral_storage_local_ssd_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#ephemeral_storage_local_ssd_config GoogleContainerCluster#ephemeral_storage_local_ssd_config}
    */
    readonly ephemeralStorageLocalSsdConfig?: GoogleContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig;
    /**
    * fast_socket block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#fast_socket GoogleContainerCluster#fast_socket}
    */
    readonly fastSocket?: GoogleContainerClusterNodePoolNodeConfigFastSocket;
    /**
    * gcfs_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#gcfs_config GoogleContainerCluster#gcfs_config}
    */
    readonly gcfsConfig?: GoogleContainerClusterNodePoolNodeConfigGcfsConfig;
    /**
    * gvnic block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#gvnic GoogleContainerCluster#gvnic}
    */
    readonly gvnic?: GoogleContainerClusterNodePoolNodeConfigGvnic;
    /**
    * host_maintenance_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#host_maintenance_policy GoogleContainerCluster#host_maintenance_policy}
    */
    readonly hostMaintenancePolicy?: GoogleContainerClusterNodePoolNodeConfigHostMaintenancePolicy;
    /**
    * kubelet_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#kubelet_config GoogleContainerCluster#kubelet_config}
    */
    readonly kubeletConfig?: GoogleContainerClusterNodePoolNodeConfigKubeletConfig;
    /**
    * linux_node_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#linux_node_config GoogleContainerCluster#linux_node_config}
    */
    readonly linuxNodeConfig?: GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfig;
    /**
    * local_nvme_ssd_block_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#local_nvme_ssd_block_config GoogleContainerCluster#local_nvme_ssd_block_config}
    */
    readonly localNvmeSsdBlockConfig?: GoogleContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig;
    /**
    * reservation_affinity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#reservation_affinity GoogleContainerCluster#reservation_affinity}
    */
    readonly reservationAffinity?: GoogleContainerClusterNodePoolNodeConfigReservationAffinity;
    /**
    * sandbox_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#sandbox_config GoogleContainerCluster#sandbox_config}
    */
    readonly sandboxConfig?: GoogleContainerClusterNodePoolNodeConfigSandboxConfig;
    /**
    * shielded_instance_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#shielded_instance_config GoogleContainerCluster#shielded_instance_config}
    */
    readonly shieldedInstanceConfig?: GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig;
    /**
    * sole_tenant_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#sole_tenant_config GoogleContainerCluster#sole_tenant_config}
    */
    readonly soleTenantConfig?: GoogleContainerClusterNodePoolNodeConfigSoleTenantConfig;
    /**
    * taint block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#taint GoogleContainerCluster#taint}
    */
    readonly taint?: GoogleContainerClusterNodePoolNodeConfigTaint[] | cdktf.IResolvable;
    /**
    * workload_metadata_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#workload_metadata_config GoogleContainerCluster#workload_metadata_config}
    */
    readonly workloadMetadataConfig?: GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig;
}
export declare function googleContainerClusterNodePoolNodeConfigToTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigOutputReference | GoogleContainerClusterNodePoolNodeConfig): any;
export declare function googleContainerClusterNodePoolNodeConfigToHclTerraform(struct?: GoogleContainerClusterNodePoolNodeConfigOutputReference | GoogleContainerClusterNodePoolNodeConfig): any;
export declare class GoogleContainerClusterNodePoolNodeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolNodeConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolNodeConfig | undefined);
    private _bootDiskKmsKey?;
    get bootDiskKmsKey(): string;
    set bootDiskKmsKey(value: string);
    resetBootDiskKmsKey(): void;
    get bootDiskKmsKeyInput(): string | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _diskType?;
    get diskType(): string;
    set diskType(value: string);
    resetDiskType(): void;
    get diskTypeInput(): string | undefined;
    private _effectiveTaints;
    get effectiveTaints(): GoogleContainerClusterNodePoolNodeConfigEffectiveTaintsList;
    private _enableConfidentialStorage?;
    get enableConfidentialStorage(): boolean | cdktf.IResolvable;
    set enableConfidentialStorage(value: boolean | cdktf.IResolvable);
    resetEnableConfidentialStorage(): void;
    get enableConfidentialStorageInput(): boolean | cdktf.IResolvable | undefined;
    private _guestAccelerator;
    get guestAccelerator(): GoogleContainerClusterNodePoolNodeConfigGuestAcceleratorList;
    putGuestAccelerator(value: GoogleContainerClusterNodePoolNodeConfigGuestAccelerator[] | cdktf.IResolvable): void;
    resetGuestAccelerator(): void;
    get guestAcceleratorInput(): cdktf.IResolvable | GoogleContainerClusterNodePoolNodeConfigGuestAccelerator[] | undefined;
    private _imageType?;
    get imageType(): string;
    set imageType(value: string);
    resetImageType(): void;
    get imageTypeInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _localSsdCount?;
    get localSsdCount(): number;
    set localSsdCount(value: number);
    resetLocalSsdCount(): void;
    get localSsdCountInput(): number | undefined;
    private _loggingVariant?;
    get loggingVariant(): string;
    set loggingVariant(value: string);
    resetLoggingVariant(): void;
    get loggingVariantInput(): string | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _nodeGroup?;
    get nodeGroup(): string;
    set nodeGroup(value: string);
    resetNodeGroup(): void;
    get nodeGroupInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
    private _preemptible?;
    get preemptible(): boolean | cdktf.IResolvable;
    set preemptible(value: boolean | cdktf.IResolvable);
    resetPreemptible(): void;
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceLabels?;
    get resourceLabels(): {
        [key: string]: string;
    };
    set resourceLabels(value: {
        [key: string]: string;
    });
    resetResourceLabels(): void;
    get resourceLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _resourceManagerTags?;
    get resourceManagerTags(): {
        [key: string]: string;
    };
    set resourceManagerTags(value: {
        [key: string]: string;
    });
    resetResourceManagerTags(): void;
    get resourceManagerTagsInput(): {
        [key: string]: string;
    } | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _spot?;
    get spot(): boolean | cdktf.IResolvable;
    set spot(value: boolean | cdktf.IResolvable);
    resetSpot(): void;
    get spotInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _advancedMachineFeatures;
    get advancedMachineFeatures(): GoogleContainerClusterNodePoolNodeConfigAdvancedMachineFeaturesOutputReference;
    putAdvancedMachineFeatures(value: GoogleContainerClusterNodePoolNodeConfigAdvancedMachineFeatures): void;
    resetAdvancedMachineFeatures(): void;
    get advancedMachineFeaturesInput(): GoogleContainerClusterNodePoolNodeConfigAdvancedMachineFeatures | undefined;
    private _confidentialNodes;
    get confidentialNodes(): GoogleContainerClusterNodePoolNodeConfigConfidentialNodesOutputReference;
    putConfidentialNodes(value: GoogleContainerClusterNodePoolNodeConfigConfidentialNodes): void;
    resetConfidentialNodes(): void;
    get confidentialNodesInput(): GoogleContainerClusterNodePoolNodeConfigConfidentialNodes | undefined;
    private _ephemeralStorageConfig;
    get ephemeralStorageConfig(): GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfigOutputReference;
    putEphemeralStorageConfig(value: GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfig): void;
    resetEphemeralStorageConfig(): void;
    get ephemeralStorageConfigInput(): GoogleContainerClusterNodePoolNodeConfigEphemeralStorageConfig | undefined;
    private _ephemeralStorageLocalSsdConfig;
    get ephemeralStorageLocalSsdConfig(): GoogleContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfigOutputReference;
    putEphemeralStorageLocalSsdConfig(value: GoogleContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig): void;
    resetEphemeralStorageLocalSsdConfig(): void;
    get ephemeralStorageLocalSsdConfigInput(): GoogleContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig | undefined;
    private _fastSocket;
    get fastSocket(): GoogleContainerClusterNodePoolNodeConfigFastSocketOutputReference;
    putFastSocket(value: GoogleContainerClusterNodePoolNodeConfigFastSocket): void;
    resetFastSocket(): void;
    get fastSocketInput(): GoogleContainerClusterNodePoolNodeConfigFastSocket | undefined;
    private _gcfsConfig;
    get gcfsConfig(): GoogleContainerClusterNodePoolNodeConfigGcfsConfigOutputReference;
    putGcfsConfig(value: GoogleContainerClusterNodePoolNodeConfigGcfsConfig): void;
    resetGcfsConfig(): void;
    get gcfsConfigInput(): GoogleContainerClusterNodePoolNodeConfigGcfsConfig | undefined;
    private _gvnic;
    get gvnic(): GoogleContainerClusterNodePoolNodeConfigGvnicOutputReference;
    putGvnic(value: GoogleContainerClusterNodePoolNodeConfigGvnic): void;
    resetGvnic(): void;
    get gvnicInput(): GoogleContainerClusterNodePoolNodeConfigGvnic | undefined;
    private _hostMaintenancePolicy;
    get hostMaintenancePolicy(): GoogleContainerClusterNodePoolNodeConfigHostMaintenancePolicyOutputReference;
    putHostMaintenancePolicy(value: GoogleContainerClusterNodePoolNodeConfigHostMaintenancePolicy): void;
    resetHostMaintenancePolicy(): void;
    get hostMaintenancePolicyInput(): GoogleContainerClusterNodePoolNodeConfigHostMaintenancePolicy | undefined;
    private _kubeletConfig;
    get kubeletConfig(): GoogleContainerClusterNodePoolNodeConfigKubeletConfigOutputReference;
    putKubeletConfig(value: GoogleContainerClusterNodePoolNodeConfigKubeletConfig): void;
    resetKubeletConfig(): void;
    get kubeletConfigInput(): GoogleContainerClusterNodePoolNodeConfigKubeletConfig | undefined;
    private _linuxNodeConfig;
    get linuxNodeConfig(): GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfigOutputReference;
    putLinuxNodeConfig(value: GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfig): void;
    resetLinuxNodeConfig(): void;
    get linuxNodeConfigInput(): GoogleContainerClusterNodePoolNodeConfigLinuxNodeConfig | undefined;
    private _localNvmeSsdBlockConfig;
    get localNvmeSsdBlockConfig(): GoogleContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfigOutputReference;
    putLocalNvmeSsdBlockConfig(value: GoogleContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig): void;
    resetLocalNvmeSsdBlockConfig(): void;
    get localNvmeSsdBlockConfigInput(): GoogleContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig | undefined;
    private _reservationAffinity;
    get reservationAffinity(): GoogleContainerClusterNodePoolNodeConfigReservationAffinityOutputReference;
    putReservationAffinity(value: GoogleContainerClusterNodePoolNodeConfigReservationAffinity): void;
    resetReservationAffinity(): void;
    get reservationAffinityInput(): GoogleContainerClusterNodePoolNodeConfigReservationAffinity | undefined;
    private _sandboxConfig;
    get sandboxConfig(): GoogleContainerClusterNodePoolNodeConfigSandboxConfigOutputReference;
    putSandboxConfig(value: GoogleContainerClusterNodePoolNodeConfigSandboxConfig): void;
    resetSandboxConfig(): void;
    get sandboxConfigInput(): GoogleContainerClusterNodePoolNodeConfigSandboxConfig | undefined;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): GoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig | undefined;
    private _soleTenantConfig;
    get soleTenantConfig(): GoogleContainerClusterNodePoolNodeConfigSoleTenantConfigOutputReference;
    putSoleTenantConfig(value: GoogleContainerClusterNodePoolNodeConfigSoleTenantConfig): void;
    resetSoleTenantConfig(): void;
    get soleTenantConfigInput(): GoogleContainerClusterNodePoolNodeConfigSoleTenantConfig | undefined;
    private _taint;
    get taint(): GoogleContainerClusterNodePoolNodeConfigTaintList;
    putTaint(value: GoogleContainerClusterNodePoolNodeConfigTaint[] | cdktf.IResolvable): void;
    resetTaint(): void;
    get taintInput(): cdktf.IResolvable | GoogleContainerClusterNodePoolNodeConfigTaint[] | undefined;
    private _workloadMetadataConfig;
    get workloadMetadataConfig(): GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfigOutputReference;
    putWorkloadMetadataConfig(value: GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig): void;
    resetWorkloadMetadataConfig(): void;
    get workloadMetadataConfigInput(): GoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig | undefined;
}
export interface GoogleContainerClusterNodePoolPlacementPolicy {
    /**
    * If set, refers to the name of a custom resource policy supplied by the user. The resource policy must be in the same project and region as the node pool. If not found, InvalidArgument error is returned.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#policy_name GoogleContainerCluster#policy_name}
    */
    readonly policyName?: string;
    /**
    * TPU placement topology for pod slice node pool. https://cloud.google.com/tpu/docs/types-topologies#tpu_topologies
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#tpu_topology GoogleContainerCluster#tpu_topology}
    */
    readonly tpuTopology?: string;
    /**
    * Type defines the type of placement policy
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#type GoogleContainerCluster#type}
    */
    readonly type: string;
}
export declare function googleContainerClusterNodePoolPlacementPolicyToTerraform(struct?: GoogleContainerClusterNodePoolPlacementPolicyOutputReference | GoogleContainerClusterNodePoolPlacementPolicy): any;
export declare function googleContainerClusterNodePoolPlacementPolicyToHclTerraform(struct?: GoogleContainerClusterNodePoolPlacementPolicyOutputReference | GoogleContainerClusterNodePoolPlacementPolicy): any;
export declare class GoogleContainerClusterNodePoolPlacementPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolPlacementPolicy | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolPlacementPolicy | undefined);
    private _policyName?;
    get policyName(): string;
    set policyName(value: string);
    resetPolicyName(): void;
    get policyNameInput(): string | undefined;
    private _tpuTopology?;
    get tpuTopology(): string;
    set tpuTopology(value: string);
    resetTpuTopology(): void;
    get tpuTopologyInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface GoogleContainerClusterNodePoolQueuedProvisioning {
    /**
    * Whether nodes in this node pool are obtainable solely through the ProvisioningRequest API
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterNodePoolQueuedProvisioningToTerraform(struct?: GoogleContainerClusterNodePoolQueuedProvisioningOutputReference | GoogleContainerClusterNodePoolQueuedProvisioning): any;
export declare function googleContainerClusterNodePoolQueuedProvisioningToHclTerraform(struct?: GoogleContainerClusterNodePoolQueuedProvisioningOutputReference | GoogleContainerClusterNodePoolQueuedProvisioning): any;
export declare class GoogleContainerClusterNodePoolQueuedProvisioningOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolQueuedProvisioning | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolQueuedProvisioning | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy {
    /**
    * Number of blue nodes to drain in a batch.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#batch_node_count GoogleContainerCluster#batch_node_count}
    */
    readonly batchNodeCount?: number;
    /**
    * Percentage of the blue pool nodes to drain in a batch.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#batch_percentage GoogleContainerCluster#batch_percentage}
    */
    readonly batchPercentage?: number;
    /**
    * Soak time after each batch gets drained.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#batch_soak_duration GoogleContainerCluster#batch_soak_duration}
    */
    readonly batchSoakDuration?: string;
}
export declare function googleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyToTerraform(struct?: GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference | GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy): any;
export declare function googleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyToHclTerraform(struct?: GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference | GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy): any;
export declare class GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy | undefined);
    private _batchNodeCount?;
    get batchNodeCount(): number;
    set batchNodeCount(value: number);
    resetBatchNodeCount(): void;
    get batchNodeCountInput(): number | undefined;
    private _batchPercentage?;
    get batchPercentage(): number;
    set batchPercentage(value: number);
    resetBatchPercentage(): void;
    get batchPercentageInput(): number | undefined;
    private _batchSoakDuration?;
    get batchSoakDuration(): string;
    set batchSoakDuration(value: string);
    resetBatchSoakDuration(): void;
    get batchSoakDurationInput(): string | undefined;
}
export interface GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettings {
    /**
    * Time needed after draining entire blue pool. After this period, blue pool will be cleaned up.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#node_pool_soak_duration GoogleContainerCluster#node_pool_soak_duration}
    */
    readonly nodePoolSoakDuration?: string;
    /**
    * standard_rollout_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#standard_rollout_policy GoogleContainerCluster#standard_rollout_policy}
    */
    readonly standardRolloutPolicy: GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy;
}
export declare function googleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsToTerraform(struct?: GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsOutputReference | GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettings): any;
export declare function googleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsToHclTerraform(struct?: GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsOutputReference | GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettings): any;
export declare class GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettings | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettings | undefined);
    private _nodePoolSoakDuration?;
    get nodePoolSoakDuration(): string;
    set nodePoolSoakDuration(value: string);
    resetNodePoolSoakDuration(): void;
    get nodePoolSoakDurationInput(): string | undefined;
    private _standardRolloutPolicy;
    get standardRolloutPolicy(): GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference;
    putStandardRolloutPolicy(value: GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy): void;
    get standardRolloutPolicyInput(): GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy | undefined;
}
export interface GoogleContainerClusterNodePoolUpgradeSettings {
    /**
    * The number of additional nodes that can be added to the node pool during an upgrade. Increasing max_surge raises the number of nodes that can be upgraded simultaneously. Can be set to 0 or greater.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#max_surge GoogleContainerCluster#max_surge}
    */
    readonly maxSurge?: number;
    /**
    * The number of nodes that can be simultaneously unavailable during an upgrade. Increasing max_unavailable raises the number of nodes that can be upgraded in parallel. Can be set to 0 or greater.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#max_unavailable GoogleContainerCluster#max_unavailable}
    */
    readonly maxUnavailable?: number;
    /**
    * Update strategy for the given nodepool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#strategy GoogleContainerCluster#strategy}
    */
    readonly strategy?: string;
    /**
    * blue_green_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#blue_green_settings GoogleContainerCluster#blue_green_settings}
    */
    readonly blueGreenSettings?: GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettings;
}
export declare function googleContainerClusterNodePoolUpgradeSettingsToTerraform(struct?: GoogleContainerClusterNodePoolUpgradeSettingsOutputReference | GoogleContainerClusterNodePoolUpgradeSettings): any;
export declare function googleContainerClusterNodePoolUpgradeSettingsToHclTerraform(struct?: GoogleContainerClusterNodePoolUpgradeSettingsOutputReference | GoogleContainerClusterNodePoolUpgradeSettings): any;
export declare class GoogleContainerClusterNodePoolUpgradeSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolUpgradeSettings | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolUpgradeSettings | undefined);
    private _maxSurge?;
    get maxSurge(): number;
    set maxSurge(value: number);
    resetMaxSurge(): void;
    get maxSurgeInput(): number | undefined;
    private _maxUnavailable?;
    get maxUnavailable(): number;
    set maxUnavailable(value: number);
    resetMaxUnavailable(): void;
    get maxUnavailableInput(): number | undefined;
    private _strategy?;
    get strategy(): string;
    set strategy(value: string);
    resetStrategy(): void;
    get strategyInput(): string | undefined;
    private _blueGreenSettings;
    get blueGreenSettings(): GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsOutputReference;
    putBlueGreenSettings(value: GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettings): void;
    resetBlueGreenSettings(): void;
    get blueGreenSettingsInput(): GoogleContainerClusterNodePoolUpgradeSettingsBlueGreenSettings | undefined;
}
export interface GoogleContainerClusterNodePool {
    /**
    * The initial number of nodes for the pool. In regional or multi-zonal clusters, this is the number of nodes per zone. Changing this will force recreation of the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#initial_node_count GoogleContainerCluster#initial_node_count}
    */
    readonly initialNodeCount?: number;
    /**
    * The maximum number of pods per node in this node pool. Note that this does not work on node pools which are "route-based" - that is, node pools belonging to clusters that do not have IP Aliasing enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#max_pods_per_node GoogleContainerCluster#max_pods_per_node}
    */
    readonly maxPodsPerNode?: number;
    /**
    * The name of the node pool. If left blank, Terraform will auto-generate a unique name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#name GoogleContainerCluster#name}
    */
    readonly name?: string;
    /**
    * Creates a unique name for the node pool beginning with the specified prefix. Conflicts with name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#name_prefix GoogleContainerCluster#name_prefix}
    */
    readonly namePrefix?: string;
    /**
    * The number of nodes per instance group. This field can be used to update the number of nodes per instance group but should not be used alongside autoscaling.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#node_count GoogleContainerCluster#node_count}
    */
    readonly nodeCount?: number;
    /**
    * The list of zones in which the node pool's nodes should be located. Nodes must be in the region of their regional cluster or in the same region as their cluster's zone for zonal clusters. If unspecified, the cluster-level node_locations will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#node_locations GoogleContainerCluster#node_locations}
    */
    readonly nodeLocations?: string[];
    /**
    * The Kubernetes version for the nodes in this pool. Note that if this field and auto_upgrade are both specified, they will fight each other for what the node version should be, so setting both is highly discouraged. While a fuzzy version can be specified, it's recommended that you specify explicit versions as Terraform will see spurious diffs when fuzzy versions are used. See the google_container_engine_versions data source's version_prefix field to approximate fuzzy versions in a Terraform-compatible way.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#version GoogleContainerCluster#version}
    */
    readonly version?: string;
    /**
    * autoscaling block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#autoscaling GoogleContainerCluster#autoscaling}
    */
    readonly autoscaling?: GoogleContainerClusterNodePoolAutoscaling;
    /**
    * management block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#management GoogleContainerCluster#management}
    */
    readonly management?: GoogleContainerClusterNodePoolManagement;
    /**
    * network_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#network_config GoogleContainerCluster#network_config}
    */
    readonly networkConfig?: GoogleContainerClusterNodePoolNetworkConfig;
    /**
    * node_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#node_config GoogleContainerCluster#node_config}
    */
    readonly nodeConfig?: GoogleContainerClusterNodePoolNodeConfig;
    /**
    * placement_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#placement_policy GoogleContainerCluster#placement_policy}
    */
    readonly placementPolicy?: GoogleContainerClusterNodePoolPlacementPolicy;
    /**
    * queued_provisioning block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#queued_provisioning GoogleContainerCluster#queued_provisioning}
    */
    readonly queuedProvisioning?: GoogleContainerClusterNodePoolQueuedProvisioning;
    /**
    * upgrade_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#upgrade_settings GoogleContainerCluster#upgrade_settings}
    */
    readonly upgradeSettings?: GoogleContainerClusterNodePoolUpgradeSettings;
}
export declare function googleContainerClusterNodePoolToTerraform(struct?: GoogleContainerClusterNodePool | cdktf.IResolvable): any;
export declare function googleContainerClusterNodePoolToHclTerraform(struct?: GoogleContainerClusterNodePool | cdktf.IResolvable): any;
export declare class GoogleContainerClusterNodePoolOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerClusterNodePool | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerClusterNodePool | cdktf.IResolvable | undefined);
    private _initialNodeCount?;
    get initialNodeCount(): number;
    set initialNodeCount(value: number);
    resetInitialNodeCount(): void;
    get initialNodeCountInput(): number | undefined;
    get instanceGroupUrls(): string[];
    get managedInstanceGroupUrls(): string[];
    private _maxPodsPerNode?;
    get maxPodsPerNode(): number;
    set maxPodsPerNode(value: number);
    resetMaxPodsPerNode(): void;
    get maxPodsPerNodeInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namePrefix?;
    get namePrefix(): string;
    set namePrefix(value: string);
    resetNamePrefix(): void;
    get namePrefixInput(): string | undefined;
    private _nodeCount?;
    get nodeCount(): number;
    set nodeCount(value: number);
    resetNodeCount(): void;
    get nodeCountInput(): number | undefined;
    private _nodeLocations?;
    get nodeLocations(): string[];
    set nodeLocations(value: string[]);
    resetNodeLocations(): void;
    get nodeLocationsInput(): string[] | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _autoscaling;
    get autoscaling(): GoogleContainerClusterNodePoolAutoscalingOutputReference;
    putAutoscaling(value: GoogleContainerClusterNodePoolAutoscaling): void;
    resetAutoscaling(): void;
    get autoscalingInput(): GoogleContainerClusterNodePoolAutoscaling | undefined;
    private _management;
    get management(): GoogleContainerClusterNodePoolManagementOutputReference;
    putManagement(value: GoogleContainerClusterNodePoolManagement): void;
    resetManagement(): void;
    get managementInput(): GoogleContainerClusterNodePoolManagement | undefined;
    private _networkConfig;
    get networkConfig(): GoogleContainerClusterNodePoolNetworkConfigOutputReference;
    putNetworkConfig(value: GoogleContainerClusterNodePoolNetworkConfig): void;
    resetNetworkConfig(): void;
    get networkConfigInput(): GoogleContainerClusterNodePoolNetworkConfig | undefined;
    private _nodeConfig;
    get nodeConfig(): GoogleContainerClusterNodePoolNodeConfigOutputReference;
    putNodeConfig(value: GoogleContainerClusterNodePoolNodeConfig): void;
    resetNodeConfig(): void;
    get nodeConfigInput(): GoogleContainerClusterNodePoolNodeConfig | undefined;
    private _placementPolicy;
    get placementPolicy(): GoogleContainerClusterNodePoolPlacementPolicyOutputReference;
    putPlacementPolicy(value: GoogleContainerClusterNodePoolPlacementPolicy): void;
    resetPlacementPolicy(): void;
    get placementPolicyInput(): GoogleContainerClusterNodePoolPlacementPolicy | undefined;
    private _queuedProvisioning;
    get queuedProvisioning(): GoogleContainerClusterNodePoolQueuedProvisioningOutputReference;
    putQueuedProvisioning(value: GoogleContainerClusterNodePoolQueuedProvisioning): void;
    resetQueuedProvisioning(): void;
    get queuedProvisioningInput(): GoogleContainerClusterNodePoolQueuedProvisioning | undefined;
    private _upgradeSettings;
    get upgradeSettings(): GoogleContainerClusterNodePoolUpgradeSettingsOutputReference;
    putUpgradeSettings(value: GoogleContainerClusterNodePoolUpgradeSettings): void;
    resetUpgradeSettings(): void;
    get upgradeSettingsInput(): GoogleContainerClusterNodePoolUpgradeSettings | undefined;
}
export declare class GoogleContainerClusterNodePoolList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerClusterNodePool[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerClusterNodePoolOutputReference;
}
export interface GoogleContainerClusterNodePoolAutoConfigNetworkTags {
    /**
    * List of network tags applied to auto-provisioned node pools.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#tags GoogleContainerCluster#tags}
    */
    readonly tags?: string[];
}
export declare function googleContainerClusterNodePoolAutoConfigNetworkTagsToTerraform(struct?: GoogleContainerClusterNodePoolAutoConfigNetworkTagsOutputReference | GoogleContainerClusterNodePoolAutoConfigNetworkTags): any;
export declare function googleContainerClusterNodePoolAutoConfigNetworkTagsToHclTerraform(struct?: GoogleContainerClusterNodePoolAutoConfigNetworkTagsOutputReference | GoogleContainerClusterNodePoolAutoConfigNetworkTags): any;
export declare class GoogleContainerClusterNodePoolAutoConfigNetworkTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolAutoConfigNetworkTags | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolAutoConfigNetworkTags | undefined);
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
}
export interface GoogleContainerClusterNodePoolAutoConfig {
    /**
    * network_tags block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#network_tags GoogleContainerCluster#network_tags}
    */
    readonly networkTags?: GoogleContainerClusterNodePoolAutoConfigNetworkTags;
}
export declare function googleContainerClusterNodePoolAutoConfigToTerraform(struct?: GoogleContainerClusterNodePoolAutoConfigOutputReference | GoogleContainerClusterNodePoolAutoConfig): any;
export declare function googleContainerClusterNodePoolAutoConfigToHclTerraform(struct?: GoogleContainerClusterNodePoolAutoConfigOutputReference | GoogleContainerClusterNodePoolAutoConfig): any;
export declare class GoogleContainerClusterNodePoolAutoConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolAutoConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolAutoConfig | undefined);
    private _networkTags;
    get networkTags(): GoogleContainerClusterNodePoolAutoConfigNetworkTagsOutputReference;
    putNetworkTags(value: GoogleContainerClusterNodePoolAutoConfigNetworkTags): void;
    resetNetworkTags(): void;
    get networkTagsInput(): GoogleContainerClusterNodePoolAutoConfigNetworkTags | undefined;
}
export interface GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfig {
    /**
    * Whether or not GCFS is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfigToTerraform(struct?: GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfigOutputReference | GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfig): any;
export declare function googleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfigToHclTerraform(struct?: GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfigOutputReference | GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfig): any;
export declare class GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfig | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults {
    /**
    * Type of logging agent that is used as the default value for node pools in the cluster. Valid values include DEFAULT and MAX_THROUGHPUT.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#logging_variant GoogleContainerCluster#logging_variant}
    */
    readonly loggingVariant?: string;
    /**
    * gcfs_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#gcfs_config GoogleContainerCluster#gcfs_config}
    */
    readonly gcfsConfig?: GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfig;
}
export declare function googleContainerClusterNodePoolDefaultsNodeConfigDefaultsToTerraform(struct?: GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsOutputReference | GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults): any;
export declare function googleContainerClusterNodePoolDefaultsNodeConfigDefaultsToHclTerraform(struct?: GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsOutputReference | GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults): any;
export declare class GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults | undefined);
    private _loggingVariant?;
    get loggingVariant(): string;
    set loggingVariant(value: string);
    resetLoggingVariant(): void;
    get loggingVariantInput(): string | undefined;
    private _gcfsConfig;
    get gcfsConfig(): GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfigOutputReference;
    putGcfsConfig(value: GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfig): void;
    resetGcfsConfig(): void;
    get gcfsConfigInput(): GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsGcfsConfig | undefined;
}
export interface GoogleContainerClusterNodePoolDefaults {
    /**
    * node_config_defaults block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#node_config_defaults GoogleContainerCluster#node_config_defaults}
    */
    readonly nodeConfigDefaults?: GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults;
}
export declare function googleContainerClusterNodePoolDefaultsToTerraform(struct?: GoogleContainerClusterNodePoolDefaultsOutputReference | GoogleContainerClusterNodePoolDefaults): any;
export declare function googleContainerClusterNodePoolDefaultsToHclTerraform(struct?: GoogleContainerClusterNodePoolDefaultsOutputReference | GoogleContainerClusterNodePoolDefaults): any;
export declare class GoogleContainerClusterNodePoolDefaultsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNodePoolDefaults | undefined;
    set internalValue(value: GoogleContainerClusterNodePoolDefaults | undefined);
    private _nodeConfigDefaults;
    get nodeConfigDefaults(): GoogleContainerClusterNodePoolDefaultsNodeConfigDefaultsOutputReference;
    putNodeConfigDefaults(value: GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults): void;
    resetNodeConfigDefaults(): void;
    get nodeConfigDefaultsInput(): GoogleContainerClusterNodePoolDefaultsNodeConfigDefaults | undefined;
}
export interface GoogleContainerClusterNotificationConfigPubsubFilter {
    /**
    * Can be used to filter what notifications are sent. Valid values include include UPGRADE_AVAILABLE_EVENT, UPGRADE_EVENT and SECURITY_BULLETIN_EVENT
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#event_type GoogleContainerCluster#event_type}
    */
    readonly eventType: string[];
}
export declare function googleContainerClusterNotificationConfigPubsubFilterToTerraform(struct?: GoogleContainerClusterNotificationConfigPubsubFilterOutputReference | GoogleContainerClusterNotificationConfigPubsubFilter): any;
export declare function googleContainerClusterNotificationConfigPubsubFilterToHclTerraform(struct?: GoogleContainerClusterNotificationConfigPubsubFilterOutputReference | GoogleContainerClusterNotificationConfigPubsubFilter): any;
export declare class GoogleContainerClusterNotificationConfigPubsubFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNotificationConfigPubsubFilter | undefined;
    set internalValue(value: GoogleContainerClusterNotificationConfigPubsubFilter | undefined);
    private _eventType?;
    get eventType(): string[];
    set eventType(value: string[]);
    get eventTypeInput(): string[] | undefined;
}
export interface GoogleContainerClusterNotificationConfigPubsub {
    /**
    * Whether or not the notification config is enabled
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * The pubsub topic to push upgrade notifications to. Must be in the same project as the cluster. Must be in the format: projects/{project}/topics/{topic}.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#topic GoogleContainerCluster#topic}
    */
    readonly topic?: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#filter GoogleContainerCluster#filter}
    */
    readonly filter?: GoogleContainerClusterNotificationConfigPubsubFilter;
}
export declare function googleContainerClusterNotificationConfigPubsubToTerraform(struct?: GoogleContainerClusterNotificationConfigPubsubOutputReference | GoogleContainerClusterNotificationConfigPubsub): any;
export declare function googleContainerClusterNotificationConfigPubsubToHclTerraform(struct?: GoogleContainerClusterNotificationConfigPubsubOutputReference | GoogleContainerClusterNotificationConfigPubsub): any;
export declare class GoogleContainerClusterNotificationConfigPubsubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNotificationConfigPubsub | undefined;
    set internalValue(value: GoogleContainerClusterNotificationConfigPubsub | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _topic?;
    get topic(): string;
    set topic(value: string);
    resetTopic(): void;
    get topicInput(): string | undefined;
    private _filter;
    get filter(): GoogleContainerClusterNotificationConfigPubsubFilterOutputReference;
    putFilter(value: GoogleContainerClusterNotificationConfigPubsubFilter): void;
    resetFilter(): void;
    get filterInput(): GoogleContainerClusterNotificationConfigPubsubFilter | undefined;
}
export interface GoogleContainerClusterNotificationConfig {
    /**
    * pubsub block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#pubsub GoogleContainerCluster#pubsub}
    */
    readonly pubsub: GoogleContainerClusterNotificationConfigPubsub;
}
export declare function googleContainerClusterNotificationConfigToTerraform(struct?: GoogleContainerClusterNotificationConfigOutputReference | GoogleContainerClusterNotificationConfig): any;
export declare function googleContainerClusterNotificationConfigToHclTerraform(struct?: GoogleContainerClusterNotificationConfigOutputReference | GoogleContainerClusterNotificationConfig): any;
export declare class GoogleContainerClusterNotificationConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterNotificationConfig | undefined;
    set internalValue(value: GoogleContainerClusterNotificationConfig | undefined);
    private _pubsub;
    get pubsub(): GoogleContainerClusterNotificationConfigPubsubOutputReference;
    putPubsub(value: GoogleContainerClusterNotificationConfigPubsub): void;
    get pubsubInput(): GoogleContainerClusterNotificationConfigPubsub | undefined;
}
export interface GoogleContainerClusterPodSecurityPolicyConfig {
    /**
    * Enable the PodSecurityPolicy controller for this cluster. If enabled, pods must be valid under a PodSecurityPolicy to be created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterPodSecurityPolicyConfigToTerraform(struct?: GoogleContainerClusterPodSecurityPolicyConfigOutputReference | GoogleContainerClusterPodSecurityPolicyConfig): any;
export declare function googleContainerClusterPodSecurityPolicyConfigToHclTerraform(struct?: GoogleContainerClusterPodSecurityPolicyConfigOutputReference | GoogleContainerClusterPodSecurityPolicyConfig): any;
export declare class GoogleContainerClusterPodSecurityPolicyConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterPodSecurityPolicyConfig | undefined;
    set internalValue(value: GoogleContainerClusterPodSecurityPolicyConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig {
    /**
    * Whether the cluster master is accessible globally or not.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterPrivateClusterConfigMasterGlobalAccessConfigToTerraform(struct?: GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfigOutputReference | GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig): any;
export declare function googleContainerClusterPrivateClusterConfigMasterGlobalAccessConfigToHclTerraform(struct?: GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfigOutputReference | GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig): any;
export declare class GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig | undefined;
    set internalValue(value: GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterPrivateClusterConfig {
    /**
    * When true, the cluster's private endpoint is used as the cluster endpoint and access through the public endpoint is disabled. When false, either endpoint can be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enable_private_endpoint GoogleContainerCluster#enable_private_endpoint}
    */
    readonly enablePrivateEndpoint?: boolean | cdktf.IResolvable;
    /**
    * Enables the private cluster feature, creating a private endpoint on the cluster. In a private cluster, nodes only have RFC 1918 private addresses and communicate with the master's private endpoint via private networking.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enable_private_nodes GoogleContainerCluster#enable_private_nodes}
    */
    readonly enablePrivateNodes?: boolean | cdktf.IResolvable;
    /**
    * The IP range in CIDR notation to use for the hosted master network. This range will be used for assigning private IP addresses to the cluster master(s) and the ILB VIP. This range must not overlap with any other ranges in use within the cluster's network, and it must be a /28 subnet. See Private Cluster Limitations for more details. This field only applies to private clusters, when enable_private_nodes is true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#master_ipv4_cidr_block GoogleContainerCluster#master_ipv4_cidr_block}
    */
    readonly masterIpv4CidrBlock?: string;
    /**
    * Subnetwork in cluster's network where master's endpoint will be provisioned.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#private_endpoint_subnetwork GoogleContainerCluster#private_endpoint_subnetwork}
    */
    readonly privateEndpointSubnetwork?: string;
    /**
    * master_global_access_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#master_global_access_config GoogleContainerCluster#master_global_access_config}
    */
    readonly masterGlobalAccessConfig?: GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig;
}
export declare function googleContainerClusterPrivateClusterConfigToTerraform(struct?: GoogleContainerClusterPrivateClusterConfigOutputReference | GoogleContainerClusterPrivateClusterConfig): any;
export declare function googleContainerClusterPrivateClusterConfigToHclTerraform(struct?: GoogleContainerClusterPrivateClusterConfigOutputReference | GoogleContainerClusterPrivateClusterConfig): any;
export declare class GoogleContainerClusterPrivateClusterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterPrivateClusterConfig | undefined;
    set internalValue(value: GoogleContainerClusterPrivateClusterConfig | undefined);
    private _enablePrivateEndpoint?;
    get enablePrivateEndpoint(): boolean | cdktf.IResolvable;
    set enablePrivateEndpoint(value: boolean | cdktf.IResolvable);
    resetEnablePrivateEndpoint(): void;
    get enablePrivateEndpointInput(): boolean | cdktf.IResolvable | undefined;
    private _enablePrivateNodes?;
    get enablePrivateNodes(): boolean | cdktf.IResolvable;
    set enablePrivateNodes(value: boolean | cdktf.IResolvable);
    resetEnablePrivateNodes(): void;
    get enablePrivateNodesInput(): boolean | cdktf.IResolvable | undefined;
    private _masterIpv4CidrBlock?;
    get masterIpv4CidrBlock(): string;
    set masterIpv4CidrBlock(value: string);
    resetMasterIpv4CidrBlock(): void;
    get masterIpv4CidrBlockInput(): string | undefined;
    get peeringName(): string;
    get privateEndpoint(): string;
    private _privateEndpointSubnetwork?;
    get privateEndpointSubnetwork(): string;
    set privateEndpointSubnetwork(value: string);
    resetPrivateEndpointSubnetwork(): void;
    get privateEndpointSubnetworkInput(): string | undefined;
    get publicEndpoint(): string;
    private _masterGlobalAccessConfig;
    get masterGlobalAccessConfig(): GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfigOutputReference;
    putMasterGlobalAccessConfig(value: GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig): void;
    resetMasterGlobalAccessConfig(): void;
    get masterGlobalAccessConfigInput(): GoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig | undefined;
}
export interface GoogleContainerClusterProtectConfigWorkloadConfig {
    /**
    * Sets which mode of auditing should be used for the cluster's workloads. Accepted values are DISABLED, BASIC.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#audit_mode GoogleContainerCluster#audit_mode}
    */
    readonly auditMode: string;
}
export declare function googleContainerClusterProtectConfigWorkloadConfigToTerraform(struct?: GoogleContainerClusterProtectConfigWorkloadConfigOutputReference | GoogleContainerClusterProtectConfigWorkloadConfig): any;
export declare function googleContainerClusterProtectConfigWorkloadConfigToHclTerraform(struct?: GoogleContainerClusterProtectConfigWorkloadConfigOutputReference | GoogleContainerClusterProtectConfigWorkloadConfig): any;
export declare class GoogleContainerClusterProtectConfigWorkloadConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterProtectConfigWorkloadConfig | undefined;
    set internalValue(value: GoogleContainerClusterProtectConfigWorkloadConfig | undefined);
    private _auditMode?;
    get auditMode(): string;
    set auditMode(value: string);
    get auditModeInput(): string | undefined;
}
export interface GoogleContainerClusterProtectConfig {
    /**
    * Sets which mode to use for Protect workload vulnerability scanning feature. Accepted values are DISABLED, BASIC.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#workload_vulnerability_mode GoogleContainerCluster#workload_vulnerability_mode}
    */
    readonly workloadVulnerabilityMode?: string;
    /**
    * workload_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#workload_config GoogleContainerCluster#workload_config}
    */
    readonly workloadConfig?: GoogleContainerClusterProtectConfigWorkloadConfig;
}
export declare function googleContainerClusterProtectConfigToTerraform(struct?: GoogleContainerClusterProtectConfigOutputReference | GoogleContainerClusterProtectConfig): any;
export declare function googleContainerClusterProtectConfigToHclTerraform(struct?: GoogleContainerClusterProtectConfigOutputReference | GoogleContainerClusterProtectConfig): any;
export declare class GoogleContainerClusterProtectConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterProtectConfig | undefined;
    set internalValue(value: GoogleContainerClusterProtectConfig | undefined);
    private _workloadVulnerabilityMode?;
    get workloadVulnerabilityMode(): string;
    set workloadVulnerabilityMode(value: string);
    resetWorkloadVulnerabilityMode(): void;
    get workloadVulnerabilityModeInput(): string | undefined;
    private _workloadConfig;
    get workloadConfig(): GoogleContainerClusterProtectConfigWorkloadConfigOutputReference;
    putWorkloadConfig(value: GoogleContainerClusterProtectConfigWorkloadConfig): void;
    resetWorkloadConfig(): void;
    get workloadConfigInput(): GoogleContainerClusterProtectConfigWorkloadConfig | undefined;
}
export interface GoogleContainerClusterReleaseChannel {
    /**
    * The selected release channel. Accepted values are:
    * * UNSPECIFIED: Not set.
    * * RAPID: Weekly upgrade cadence; Early testers and developers who requires new features.
    * * REGULAR: Multiple per month upgrade cadence; Production users who need features not yet offered in the Stable channel.
    * * STABLE: Every few months upgrade cadence; Production users who need stability above all else, and for whom frequent upgrades are too risky.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#channel GoogleContainerCluster#channel}
    */
    readonly channel: string;
}
export declare function googleContainerClusterReleaseChannelToTerraform(struct?: GoogleContainerClusterReleaseChannelOutputReference | GoogleContainerClusterReleaseChannel): any;
export declare function googleContainerClusterReleaseChannelToHclTerraform(struct?: GoogleContainerClusterReleaseChannelOutputReference | GoogleContainerClusterReleaseChannel): any;
export declare class GoogleContainerClusterReleaseChannelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterReleaseChannel | undefined;
    set internalValue(value: GoogleContainerClusterReleaseChannel | undefined);
    private _channel?;
    get channel(): string;
    set channel(value: string);
    get channelInput(): string | undefined;
}
export interface GoogleContainerClusterResourceUsageExportConfigBigqueryDestination {
    /**
    * The ID of a BigQuery Dataset.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#dataset_id GoogleContainerCluster#dataset_id}
    */
    readonly datasetId: string;
}
export declare function googleContainerClusterResourceUsageExportConfigBigqueryDestinationToTerraform(struct?: GoogleContainerClusterResourceUsageExportConfigBigqueryDestinationOutputReference | GoogleContainerClusterResourceUsageExportConfigBigqueryDestination): any;
export declare function googleContainerClusterResourceUsageExportConfigBigqueryDestinationToHclTerraform(struct?: GoogleContainerClusterResourceUsageExportConfigBigqueryDestinationOutputReference | GoogleContainerClusterResourceUsageExportConfigBigqueryDestination): any;
export declare class GoogleContainerClusterResourceUsageExportConfigBigqueryDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterResourceUsageExportConfigBigqueryDestination | undefined;
    set internalValue(value: GoogleContainerClusterResourceUsageExportConfigBigqueryDestination | undefined);
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
}
export interface GoogleContainerClusterResourceUsageExportConfig {
    /**
    * Whether to enable network egress metering for this cluster. If enabled, a daemonset will be created in the cluster to meter network egress traffic.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enable_network_egress_metering GoogleContainerCluster#enable_network_egress_metering}
    */
    readonly enableNetworkEgressMetering?: boolean | cdktf.IResolvable;
    /**
    * Whether to enable resource consumption metering on this cluster. When enabled, a table will be created in the resource export BigQuery dataset to store resource consumption data. The resulting table can be joined with the resource usage table or with BigQuery billing export. Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enable_resource_consumption_metering GoogleContainerCluster#enable_resource_consumption_metering}
    */
    readonly enableResourceConsumptionMetering?: boolean | cdktf.IResolvable;
    /**
    * bigquery_destination block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#bigquery_destination GoogleContainerCluster#bigquery_destination}
    */
    readonly bigqueryDestination: GoogleContainerClusterResourceUsageExportConfigBigqueryDestination;
}
export declare function googleContainerClusterResourceUsageExportConfigToTerraform(struct?: GoogleContainerClusterResourceUsageExportConfigOutputReference | GoogleContainerClusterResourceUsageExportConfig): any;
export declare function googleContainerClusterResourceUsageExportConfigToHclTerraform(struct?: GoogleContainerClusterResourceUsageExportConfigOutputReference | GoogleContainerClusterResourceUsageExportConfig): any;
export declare class GoogleContainerClusterResourceUsageExportConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterResourceUsageExportConfig | undefined;
    set internalValue(value: GoogleContainerClusterResourceUsageExportConfig | undefined);
    private _enableNetworkEgressMetering?;
    get enableNetworkEgressMetering(): boolean | cdktf.IResolvable;
    set enableNetworkEgressMetering(value: boolean | cdktf.IResolvable);
    resetEnableNetworkEgressMetering(): void;
    get enableNetworkEgressMeteringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableResourceConsumptionMetering?;
    get enableResourceConsumptionMetering(): boolean | cdktf.IResolvable;
    set enableResourceConsumptionMetering(value: boolean | cdktf.IResolvable);
    resetEnableResourceConsumptionMetering(): void;
    get enableResourceConsumptionMeteringInput(): boolean | cdktf.IResolvable | undefined;
    private _bigqueryDestination;
    get bigqueryDestination(): GoogleContainerClusterResourceUsageExportConfigBigqueryDestinationOutputReference;
    putBigqueryDestination(value: GoogleContainerClusterResourceUsageExportConfigBigqueryDestination): void;
    get bigqueryDestinationInput(): GoogleContainerClusterResourceUsageExportConfigBigqueryDestination | undefined;
}
