/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import * as cdktf from 'cdktf';
export interface GoogleContainerClusterSecurityPostureConfig {
    /**
    * Sets the mode of the Kubernetes security posture API's off-cluster features. Available options include DISABLED and BASIC.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#mode GoogleContainerCluster#mode}
    */
    readonly mode?: string;
    /**
    * Sets the mode of the Kubernetes security posture API's workload vulnerability scanning. Available options include VULNERABILITY_DISABLED, VULNERABILITY_BASIC and VULNERABILITY_ENTERPRISE.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#vulnerability_mode GoogleContainerCluster#vulnerability_mode}
    */
    readonly vulnerabilityMode?: string;
}
export declare function googleContainerClusterSecurityPostureConfigToTerraform(struct?: GoogleContainerClusterSecurityPostureConfigOutputReference | GoogleContainerClusterSecurityPostureConfig): any;
export declare function googleContainerClusterSecurityPostureConfigToHclTerraform(struct?: GoogleContainerClusterSecurityPostureConfigOutputReference | GoogleContainerClusterSecurityPostureConfig): any;
export declare class GoogleContainerClusterSecurityPostureConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterSecurityPostureConfig | undefined;
    set internalValue(value: GoogleContainerClusterSecurityPostureConfig | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _vulnerabilityMode?;
    get vulnerabilityMode(): string;
    set vulnerabilityMode(value: string);
    resetVulnerabilityMode(): void;
    get vulnerabilityModeInput(): string | undefined;
}
export interface GoogleContainerClusterServiceExternalIpsConfig {
    /**
    * When enabled, services with exterenal ips specified will be allowed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterServiceExternalIpsConfigToTerraform(struct?: GoogleContainerClusterServiceExternalIpsConfigOutputReference | GoogleContainerClusterServiceExternalIpsConfig): any;
export declare function googleContainerClusterServiceExternalIpsConfigToHclTerraform(struct?: GoogleContainerClusterServiceExternalIpsConfigOutputReference | GoogleContainerClusterServiceExternalIpsConfig): any;
export declare class GoogleContainerClusterServiceExternalIpsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterServiceExternalIpsConfig | undefined;
    set internalValue(value: GoogleContainerClusterServiceExternalIpsConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#create GoogleContainerCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#delete GoogleContainerCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#read GoogleContainerCluster#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#update GoogleContainerCluster#update}
    */
    readonly update?: string;
}
export declare function googleContainerClusterTimeoutsToTerraform(struct?: GoogleContainerClusterTimeouts | cdktf.IResolvable): any;
export declare function googleContainerClusterTimeoutsToHclTerraform(struct?: GoogleContainerClusterTimeouts | cdktf.IResolvable): any;
export declare class GoogleContainerClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleContainerClusterTpuConfig {
    /**
    * Whether Cloud TPU integration is enabled or not
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Whether to use service networking for Cloud TPU or not
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#use_service_networking GoogleContainerCluster#use_service_networking}
    */
    readonly useServiceNetworking?: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterTpuConfigToTerraform(struct?: GoogleContainerClusterTpuConfigOutputReference | GoogleContainerClusterTpuConfig): any;
export declare function googleContainerClusterTpuConfigToHclTerraform(struct?: GoogleContainerClusterTpuConfigOutputReference | GoogleContainerClusterTpuConfig): any;
export declare class GoogleContainerClusterTpuConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterTpuConfig | undefined;
    set internalValue(value: GoogleContainerClusterTpuConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get ipv4CidrBlock(): string;
    private _useServiceNetworking?;
    get useServiceNetworking(): boolean | cdktf.IResolvable;
    set useServiceNetworking(value: boolean | cdktf.IResolvable);
    resetUseServiceNetworking(): void;
    get useServiceNetworkingInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterVerticalPodAutoscaling {
    /**
    * Enables vertical pod autoscaling.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enabled GoogleContainerCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterVerticalPodAutoscalingToTerraform(struct?: GoogleContainerClusterVerticalPodAutoscalingOutputReference | GoogleContainerClusterVerticalPodAutoscaling): any;
export declare function googleContainerClusterVerticalPodAutoscalingToHclTerraform(struct?: GoogleContainerClusterVerticalPodAutoscalingOutputReference | GoogleContainerClusterVerticalPodAutoscaling): any;
export declare class GoogleContainerClusterVerticalPodAutoscalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterVerticalPodAutoscaling | undefined;
    set internalValue(value: GoogleContainerClusterVerticalPodAutoscaling | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterWorkloadAltsConfig {
    /**
    * Whether the alts handshaker should be enabled or not for direct-path. Requires Workload Identity (workloadPool must be non-empty).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enable_alts GoogleContainerCluster#enable_alts}
    */
    readonly enableAlts: boolean | cdktf.IResolvable;
}
export declare function googleContainerClusterWorkloadAltsConfigToTerraform(struct?: GoogleContainerClusterWorkloadAltsConfigOutputReference | GoogleContainerClusterWorkloadAltsConfig): any;
export declare function googleContainerClusterWorkloadAltsConfigToHclTerraform(struct?: GoogleContainerClusterWorkloadAltsConfigOutputReference | GoogleContainerClusterWorkloadAltsConfig): any;
export declare class GoogleContainerClusterWorkloadAltsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterWorkloadAltsConfig | undefined;
    set internalValue(value: GoogleContainerClusterWorkloadAltsConfig | undefined);
    private _enableAlts?;
    get enableAlts(): boolean | cdktf.IResolvable;
    set enableAlts(value: boolean | cdktf.IResolvable);
    get enableAltsInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerClusterWorkloadIdentityConfig {
    /**
    * The workload pool to attach all Kubernetes service accounts to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#workload_pool GoogleContainerCluster#workload_pool}
    */
    readonly workloadPool?: string;
}
export declare function googleContainerClusterWorkloadIdentityConfigToTerraform(struct?: GoogleContainerClusterWorkloadIdentityConfigOutputReference | GoogleContainerClusterWorkloadIdentityConfig): any;
export declare function googleContainerClusterWorkloadIdentityConfigToHclTerraform(struct?: GoogleContainerClusterWorkloadIdentityConfigOutputReference | GoogleContainerClusterWorkloadIdentityConfig): any;
export declare class GoogleContainerClusterWorkloadIdentityConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerClusterWorkloadIdentityConfig | undefined;
    set internalValue(value: GoogleContainerClusterWorkloadIdentityConfig | undefined);
    private _workloadPool?;
    get workloadPool(): string;
    set workloadPool(value: string);
    resetWorkloadPool(): void;
    get workloadPoolInput(): string | undefined;
}
