/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { GoogleContainerClusterAddonsConfig, GoogleContainerClusterAddonsConfigOutputReference, GoogleContainerClusterAuthenticatorGroupsConfig, GoogleContainerClusterAuthenticatorGroupsConfigOutputReference, GoogleContainerClusterBinaryAuthorization, GoogleContainerClusterBinaryAuthorizationOutputReference, GoogleContainerClusterClusterAutoscaling, GoogleContainerClusterClusterAutoscalingOutputReference, GoogleContainerClusterClusterTelemetry, GoogleContainerClusterClusterTelemetryOutputReference, GoogleContainerClusterConfidentialNodes, GoogleContainerClusterConfidentialNodesOutputReference, GoogleContainerClusterCostManagementConfig, GoogleContainerClusterCostManagementConfigOutputReference, GoogleContainerClusterDatabaseEncryption, GoogleContainerClusterDatabaseEncryptionOutputReference, GoogleContainerClusterDefaultSnatStatus, GoogleContainerClusterDefaultSnatStatusOutputReference, GoogleContainerClusterDnsConfig, GoogleContainerClusterDnsConfigOutputReference, GoogleContainerClusterEnableK8SBetaApis, GoogleContainerClusterEnableK8SBetaApisOutputReference, GoogleContainerClusterFleet, GoogleContainerClusterFleetOutputReference, GoogleContainerClusterGatewayApiConfig, GoogleContainerClusterGatewayApiConfigOutputReference, GoogleContainerClusterIdentityServiceConfig, GoogleContainerClusterIdentityServiceConfigOutputReference, GoogleContainerClusterIpAllocationPolicy, GoogleContainerClusterIpAllocationPolicyOutputReference, GoogleContainerClusterLoggingConfig, GoogleContainerClusterLoggingConfigOutputReference, GoogleContainerClusterMaintenancePolicy, GoogleContainerClusterMaintenancePolicyOutputReference, GoogleContainerClusterMasterAuth, GoogleContainerClusterMasterAuthOutputReference, GoogleContainerClusterMasterAuthorizedNetworksConfig, GoogleContainerClusterMasterAuthorizedNetworksConfigOutputReference, GoogleContainerClusterMeshCertificates, GoogleContainerClusterMeshCertificatesOutputReference, GoogleContainerClusterMonitoringConfig, GoogleContainerClusterMonitoringConfigOutputReference, GoogleContainerClusterNetworkPolicy, GoogleContainerClusterNetworkPolicyOutputReference, GoogleContainerClusterNodeConfig, GoogleContainerClusterNodeConfigOutputReference, GoogleContainerClusterNodePool, GoogleContainerClusterNodePoolList, GoogleContainerClusterNodePoolAutoConfig, GoogleContainerClusterNodePoolAutoConfigOutputReference, GoogleContainerClusterNodePoolDefaults, GoogleContainerClusterNodePoolDefaultsOutputReference, GoogleContainerClusterNotificationConfig, GoogleContainerClusterNotificationConfigOutputReference, GoogleContainerClusterPodSecurityPolicyConfig, GoogleContainerClusterPodSecurityPolicyConfigOutputReference, GoogleContainerClusterPrivateClusterConfig, GoogleContainerClusterPrivateClusterConfigOutputReference, GoogleContainerClusterProtectConfig, GoogleContainerClusterProtectConfigOutputReference, GoogleContainerClusterReleaseChannel, GoogleContainerClusterReleaseChannelOutputReference, GoogleContainerClusterResourceUsageExportConfig, GoogleContainerClusterResourceUsageExportConfigOutputReference, GoogleContainerClusterSecurityPostureConfig, GoogleContainerClusterSecurityPostureConfigOutputReference, GoogleContainerClusterServiceExternalIpsConfig, GoogleContainerClusterServiceExternalIpsConfigOutputReference, GoogleContainerClusterTimeouts, GoogleContainerClusterTimeoutsOutputReference, GoogleContainerClusterTpuConfig, GoogleContainerClusterTpuConfigOutputReference, GoogleContainerClusterVerticalPodAutoscaling, GoogleContainerClusterVerticalPodAutoscalingOutputReference, GoogleContainerClusterWorkloadAltsConfig, GoogleContainerClusterWorkloadAltsConfigOutputReference, GoogleContainerClusterWorkloadIdentityConfig, GoogleContainerClusterWorkloadIdentityConfigOutputReference } from './index-structs';
export * from './index-structs';
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleContainerClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Enable NET_ADMIN for this cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#allow_net_admin GoogleContainerCluster#allow_net_admin}
    */
    readonly allowNetAdmin?: boolean | cdktf.IResolvable;
    /**
    * The IP address range of the Kubernetes pods in this cluster in CIDR notation (e.g. 10.96.0.0/14). Leave blank to have one automatically chosen or specify a /14 block in 10.0.0.0/8. This field will only work for routes-based clusters, where ip_allocation_policy is not defined.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#cluster_ipv4_cidr GoogleContainerCluster#cluster_ipv4_cidr}
    */
    readonly clusterIpv4Cidr?: string;
    /**
    * The desired datapath provider for this cluster. By default, uses the IPTables-based kube-proxy implementation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#datapath_provider GoogleContainerCluster#datapath_provider}
    */
    readonly datapathProvider?: string;
    /**
    * The default maximum number of pods per node in this cluster. This doesn't work on "routes-based" clusters, clusters that don't have IP Aliasing enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#default_max_pods_per_node GoogleContainerCluster#default_max_pods_per_node}
    */
    readonly defaultMaxPodsPerNode?: number;
    /**
    * Whether or not to allow Terraform to destroy the instance. Defaults to true. Unless this field is set to false in Terraform state, a terraform destroy or terraform apply that would delete the cluster will fail.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#deletion_protection GoogleContainerCluster#deletion_protection}
    */
    readonly deletionProtection?: boolean | cdktf.IResolvable;
    /**
    *  Description of the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#description GoogleContainerCluster#description}
    */
    readonly description?: string;
    /**
    * Enable Autopilot for this cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enable_autopilot GoogleContainerCluster#enable_autopilot}
    */
    readonly enableAutopilot?: boolean | cdktf.IResolvable;
    /**
    * Whether FQDN Network Policy is enabled on this cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enable_fqdn_network_policy GoogleContainerCluster#enable_fqdn_network_policy}
    */
    readonly enableFqdnNetworkPolicy?: boolean | cdktf.IResolvable;
    /**
    * Whether Intra-node visibility is enabled for this cluster. This makes same node pod to pod traffic visible for VPC network.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enable_intranode_visibility GoogleContainerCluster#enable_intranode_visibility}
    */
    readonly enableIntranodeVisibility?: boolean | cdktf.IResolvable;
    /**
    * Whether to enable Kubernetes Alpha features for this cluster. Note that when this option is enabled, the cluster cannot be upgraded and will be automatically deleted after 30 days.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enable_kubernetes_alpha GoogleContainerCluster#enable_kubernetes_alpha}
    */
    readonly enableKubernetesAlpha?: boolean | cdktf.IResolvable;
    /**
    * Whether L4ILB Subsetting is enabled for this cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enable_l4_ilb_subsetting GoogleContainerCluster#enable_l4_ilb_subsetting}
    */
    readonly enableL4IlbSubsetting?: boolean | cdktf.IResolvable;
    /**
    * Whether the ABAC authorizer is enabled for this cluster. When enabled, identities in the system, including service accounts, nodes, and controllers, will have statically granted permissions beyond those provided by the RBAC configuration or IAM. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enable_legacy_abac GoogleContainerCluster#enable_legacy_abac}
    */
    readonly enableLegacyAbac?: boolean | cdktf.IResolvable;
    /**
    * Whether multi-networking is enabled for this cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enable_multi_networking GoogleContainerCluster#enable_multi_networking}
    */
    readonly enableMultiNetworking?: boolean | cdktf.IResolvable;
    /**
    * Enable Shielded Nodes features on all nodes in this cluster. Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enable_shielded_nodes GoogleContainerCluster#enable_shielded_nodes}
    */
    readonly enableShieldedNodes?: boolean | cdktf.IResolvable;
    /**
    * Whether to enable Cloud TPU resources in this cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enable_tpu GoogleContainerCluster#enable_tpu}
    */
    readonly enableTpu?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#id GoogleContainerCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The number of nodes to create in this cluster's default node pool. In regional or multi-zonal clusters, this is the number of nodes per zone. Must be set if node_pool is not set. If you're using google_container_node_pool objects with no default node pool, you'll need to set this to a value of at least 1, alongside setting remove_default_node_pool to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#initial_node_count GoogleContainerCluster#initial_node_count}
    */
    readonly initialNodeCount?: number;
    /**
    * The location (region or zone) in which the cluster master will be created, as well as the default node location. If you specify a zone (such as us-central1-a), the cluster will be a zonal cluster with a single cluster master. If you specify a region (such as us-west1), the cluster will be a regional cluster with multiple masters spread across zones in the region, and with default node locations in those zones as well.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#location GoogleContainerCluster#location}
    */
    readonly location?: string;
    /**
    * The logging service that the cluster should write logs to. Available options include logging.googleapis.com(Legacy Stackdriver), logging.googleapis.com/kubernetes(Stackdriver Kubernetes Engine Logging), and none. Defaults to logging.googleapis.com/kubernetes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#logging_service GoogleContainerCluster#logging_service}
    */
    readonly loggingService?: string;
    /**
    * The minimum version of the master. GKE will auto-update the master to new versions, so this does not guarantee the current master version--use the read-only master_version field to obtain that. If unset, the cluster's version will be set by GKE to the version of the most recent official release (which is not necessarily the latest version).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#min_master_version GoogleContainerCluster#min_master_version}
    */
    readonly minMasterVersion?: string;
    /**
    * The monitoring service that the cluster should write metrics to. Automatically send metrics from pods in the cluster to the Google Cloud Monitoring API. VM metrics will be collected by Google Compute Engine regardless of this setting Available options include monitoring.googleapis.com(Legacy Stackdriver), monitoring.googleapis.com/kubernetes(Stackdriver Kubernetes Engine Monitoring), and none. Defaults to monitoring.googleapis.com/kubernetes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#monitoring_service GoogleContainerCluster#monitoring_service}
    */
    readonly monitoringService?: string;
    /**
    * The name of the cluster, unique within the project and location.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#name GoogleContainerCluster#name}
    */
    readonly name: string;
    /**
    * The name or self_link of the Google Compute Engine network to which the cluster is connected. For Shared VPC, set this to the self link of the shared network.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#network GoogleContainerCluster#network}
    */
    readonly network?: string;
    /**
    * Determines whether alias IPs or routes will be used for pod IPs in the cluster. Defaults to VPC_NATIVE for new clusters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#networking_mode GoogleContainerCluster#networking_mode}
    */
    readonly networkingMode?: string;
    /**
    * The list of zones in which the cluster's nodes are located. Nodes must be in the region of their regional cluster or in the same region as their cluster's zone for zonal clusters. If this is specified for a zonal cluster, omit the cluster's zone.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#node_locations GoogleContainerCluster#node_locations}
    */
    readonly nodeLocations?: string[];
    /**
    * The Kubernetes version on the nodes. Must either be unset or set to the same value as min_master_version on create. Defaults to the default version set by GKE which is not necessarily the latest version. This only affects nodes in the default node pool. While a fuzzy version can be specified, it's recommended that you specify explicit versions as Terraform will see spurious diffs when fuzzy versions are used. See the google_container_engine_versions data source's version_prefix field to approximate fuzzy versions in a Terraform-compatible way. To update nodes in other node pools, use the version attribute on the node pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#node_version GoogleContainerCluster#node_version}
    */
    readonly nodeVersion?: string;
    /**
    * The desired state of IPv6 connectivity to Google Services. By default, no private IPv6 access to or from Google Services (all access will be via IPv4).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#private_ipv6_google_access GoogleContainerCluster#private_ipv6_google_access}
    */
    readonly privateIpv6GoogleAccess?: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#project GoogleContainerCluster#project}
    */
    readonly project?: string;
    /**
    * If true, deletes the default node pool upon cluster creation. If you're using google_container_node_pool resources with no default node pool, this should be set to true, alongside setting initial_node_count to at least 1.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#remove_default_node_pool GoogleContainerCluster#remove_default_node_pool}
    */
    readonly removeDefaultNodePool?: boolean | cdktf.IResolvable;
    /**
    * The GCE resource labels (a map of key/value pairs) to be applied to the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#resource_labels GoogleContainerCluster#resource_labels}
    */
    readonly resourceLabels?: {
        [key: string]: string;
    };
    /**
    * The name or self_link of the Google Compute Engine subnetwork in which the cluster's instances are launched.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#subnetwork GoogleContainerCluster#subnetwork}
    */
    readonly subnetwork?: string;
    /**
    * addons_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#addons_config GoogleContainerCluster#addons_config}
    */
    readonly addonsConfig?: GoogleContainerClusterAddonsConfig;
    /**
    * authenticator_groups_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#authenticator_groups_config GoogleContainerCluster#authenticator_groups_config}
    */
    readonly authenticatorGroupsConfig?: GoogleContainerClusterAuthenticatorGroupsConfig;
    /**
    * binary_authorization block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#binary_authorization GoogleContainerCluster#binary_authorization}
    */
    readonly binaryAuthorization?: GoogleContainerClusterBinaryAuthorization;
    /**
    * cluster_autoscaling block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#cluster_autoscaling GoogleContainerCluster#cluster_autoscaling}
    */
    readonly clusterAutoscaling?: GoogleContainerClusterClusterAutoscaling;
    /**
    * cluster_telemetry block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#cluster_telemetry GoogleContainerCluster#cluster_telemetry}
    */
    readonly clusterTelemetry?: GoogleContainerClusterClusterTelemetry;
    /**
    * confidential_nodes block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#confidential_nodes GoogleContainerCluster#confidential_nodes}
    */
    readonly confidentialNodes?: GoogleContainerClusterConfidentialNodes;
    /**
    * cost_management_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#cost_management_config GoogleContainerCluster#cost_management_config}
    */
    readonly costManagementConfig?: GoogleContainerClusterCostManagementConfig;
    /**
    * database_encryption block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#database_encryption GoogleContainerCluster#database_encryption}
    */
    readonly databaseEncryption?: GoogleContainerClusterDatabaseEncryption;
    /**
    * default_snat_status block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#default_snat_status GoogleContainerCluster#default_snat_status}
    */
    readonly defaultSnatStatus?: GoogleContainerClusterDefaultSnatStatus;
    /**
    * dns_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#dns_config GoogleContainerCluster#dns_config}
    */
    readonly dnsConfig?: GoogleContainerClusterDnsConfig;
    /**
    * enable_k8s_beta_apis block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#enable_k8s_beta_apis GoogleContainerCluster#enable_k8s_beta_apis}
    */
    readonly enableK8SBetaApis?: GoogleContainerClusterEnableK8SBetaApis;
    /**
    * fleet block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#fleet GoogleContainerCluster#fleet}
    */
    readonly fleet?: GoogleContainerClusterFleet;
    /**
    * gateway_api_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#gateway_api_config GoogleContainerCluster#gateway_api_config}
    */
    readonly gatewayApiConfig?: GoogleContainerClusterGatewayApiConfig;
    /**
    * identity_service_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#identity_service_config GoogleContainerCluster#identity_service_config}
    */
    readonly identityServiceConfig?: GoogleContainerClusterIdentityServiceConfig;
    /**
    * ip_allocation_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#ip_allocation_policy GoogleContainerCluster#ip_allocation_policy}
    */
    readonly ipAllocationPolicy?: GoogleContainerClusterIpAllocationPolicy;
    /**
    * logging_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#logging_config GoogleContainerCluster#logging_config}
    */
    readonly loggingConfig?: GoogleContainerClusterLoggingConfig;
    /**
    * maintenance_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#maintenance_policy GoogleContainerCluster#maintenance_policy}
    */
    readonly maintenancePolicy?: GoogleContainerClusterMaintenancePolicy;
    /**
    * master_auth block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#master_auth GoogleContainerCluster#master_auth}
    */
    readonly masterAuth?: GoogleContainerClusterMasterAuth;
    /**
    * master_authorized_networks_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#master_authorized_networks_config GoogleContainerCluster#master_authorized_networks_config}
    */
    readonly masterAuthorizedNetworksConfig?: GoogleContainerClusterMasterAuthorizedNetworksConfig;
    /**
    * mesh_certificates block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#mesh_certificates GoogleContainerCluster#mesh_certificates}
    */
    readonly meshCertificates?: GoogleContainerClusterMeshCertificates;
    /**
    * monitoring_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#monitoring_config GoogleContainerCluster#monitoring_config}
    */
    readonly monitoringConfig?: GoogleContainerClusterMonitoringConfig;
    /**
    * network_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#network_policy GoogleContainerCluster#network_policy}
    */
    readonly networkPolicy?: GoogleContainerClusterNetworkPolicy;
    /**
    * node_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#node_config GoogleContainerCluster#node_config}
    */
    readonly nodeConfig?: GoogleContainerClusterNodeConfig;
    /**
    * node_pool block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#node_pool GoogleContainerCluster#node_pool}
    */
    readonly nodePool?: GoogleContainerClusterNodePool[] | cdktf.IResolvable;
    /**
    * node_pool_auto_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#node_pool_auto_config GoogleContainerCluster#node_pool_auto_config}
    */
    readonly nodePoolAutoConfig?: GoogleContainerClusterNodePoolAutoConfig;
    /**
    * node_pool_defaults block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#node_pool_defaults GoogleContainerCluster#node_pool_defaults}
    */
    readonly nodePoolDefaults?: GoogleContainerClusterNodePoolDefaults;
    /**
    * notification_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#notification_config GoogleContainerCluster#notification_config}
    */
    readonly notificationConfig?: GoogleContainerClusterNotificationConfig;
    /**
    * pod_security_policy_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#pod_security_policy_config GoogleContainerCluster#pod_security_policy_config}
    */
    readonly podSecurityPolicyConfig?: GoogleContainerClusterPodSecurityPolicyConfig;
    /**
    * private_cluster_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#private_cluster_config GoogleContainerCluster#private_cluster_config}
    */
    readonly privateClusterConfig?: GoogleContainerClusterPrivateClusterConfig;
    /**
    * protect_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#protect_config GoogleContainerCluster#protect_config}
    */
    readonly protectConfig?: GoogleContainerClusterProtectConfig;
    /**
    * release_channel block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#release_channel GoogleContainerCluster#release_channel}
    */
    readonly releaseChannel?: GoogleContainerClusterReleaseChannel;
    /**
    * resource_usage_export_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#resource_usage_export_config GoogleContainerCluster#resource_usage_export_config}
    */
    readonly resourceUsageExportConfig?: GoogleContainerClusterResourceUsageExportConfig;
    /**
    * security_posture_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#security_posture_config GoogleContainerCluster#security_posture_config}
    */
    readonly securityPostureConfig?: GoogleContainerClusterSecurityPostureConfig;
    /**
    * service_external_ips_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#service_external_ips_config GoogleContainerCluster#service_external_ips_config}
    */
    readonly serviceExternalIpsConfig?: GoogleContainerClusterServiceExternalIpsConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#timeouts GoogleContainerCluster#timeouts}
    */
    readonly timeouts?: GoogleContainerClusterTimeouts;
    /**
    * tpu_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#tpu_config GoogleContainerCluster#tpu_config}
    */
    readonly tpuConfig?: GoogleContainerClusterTpuConfig;
    /**
    * vertical_pod_autoscaling block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#vertical_pod_autoscaling GoogleContainerCluster#vertical_pod_autoscaling}
    */
    readonly verticalPodAutoscaling?: GoogleContainerClusterVerticalPodAutoscaling;
    /**
    * workload_alts_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#workload_alts_config GoogleContainerCluster#workload_alts_config}
    */
    readonly workloadAltsConfig?: GoogleContainerClusterWorkloadAltsConfig;
    /**
    * workload_identity_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#workload_identity_config GoogleContainerCluster#workload_identity_config}
    */
    readonly workloadIdentityConfig?: GoogleContainerClusterWorkloadIdentityConfig;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster google_container_cluster}
*/
export declare class GoogleContainerCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_container_cluster";
    /**
    * Generates CDKTF code for importing a GoogleContainerCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleContainerCluster to import
    * @param importFromId The id of the existing GoogleContainerCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleContainerCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster google_container_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleContainerClusterConfig
    */
    constructor(scope: Construct, id: string, config: GoogleContainerClusterConfig);
    private _allowNetAdmin?;
    get allowNetAdmin(): boolean | cdktf.IResolvable;
    set allowNetAdmin(value: boolean | cdktf.IResolvable);
    resetAllowNetAdmin(): void;
    get allowNetAdminInput(): boolean | cdktf.IResolvable | undefined;
    private _clusterIpv4Cidr?;
    get clusterIpv4Cidr(): string;
    set clusterIpv4Cidr(value: string);
    resetClusterIpv4Cidr(): void;
    get clusterIpv4CidrInput(): string | undefined;
    private _datapathProvider?;
    get datapathProvider(): string;
    set datapathProvider(value: string);
    resetDatapathProvider(): void;
    get datapathProviderInput(): string | undefined;
    private _defaultMaxPodsPerNode?;
    get defaultMaxPodsPerNode(): number;
    set defaultMaxPodsPerNode(value: number);
    resetDefaultMaxPodsPerNode(): void;
    get defaultMaxPodsPerNodeInput(): number | undefined;
    private _deletionProtection?;
    get deletionProtection(): boolean | cdktf.IResolvable;
    set deletionProtection(value: boolean | cdktf.IResolvable);
    resetDeletionProtection(): void;
    get deletionProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enableAutopilot?;
    get enableAutopilot(): boolean | cdktf.IResolvable;
    set enableAutopilot(value: boolean | cdktf.IResolvable);
    resetEnableAutopilot(): void;
    get enableAutopilotInput(): boolean | cdktf.IResolvable | undefined;
    private _enableFqdnNetworkPolicy?;
    get enableFqdnNetworkPolicy(): boolean | cdktf.IResolvable;
    set enableFqdnNetworkPolicy(value: boolean | cdktf.IResolvable);
    resetEnableFqdnNetworkPolicy(): void;
    get enableFqdnNetworkPolicyInput(): boolean | cdktf.IResolvable | undefined;
    private _enableIntranodeVisibility?;
    get enableIntranodeVisibility(): boolean | cdktf.IResolvable;
    set enableIntranodeVisibility(value: boolean | cdktf.IResolvable);
    resetEnableIntranodeVisibility(): void;
    get enableIntranodeVisibilityInput(): boolean | cdktf.IResolvable | undefined;
    private _enableKubernetesAlpha?;
    get enableKubernetesAlpha(): boolean | cdktf.IResolvable;
    set enableKubernetesAlpha(value: boolean | cdktf.IResolvable);
    resetEnableKubernetesAlpha(): void;
    get enableKubernetesAlphaInput(): boolean | cdktf.IResolvable | undefined;
    private _enableL4IlbSubsetting?;
    get enableL4IlbSubsetting(): boolean | cdktf.IResolvable;
    set enableL4IlbSubsetting(value: boolean | cdktf.IResolvable);
    resetEnableL4IlbSubsetting(): void;
    get enableL4IlbSubsettingInput(): boolean | cdktf.IResolvable | undefined;
    private _enableLegacyAbac?;
    get enableLegacyAbac(): boolean | cdktf.IResolvable;
    set enableLegacyAbac(value: boolean | cdktf.IResolvable);
    resetEnableLegacyAbac(): void;
    get enableLegacyAbacInput(): boolean | cdktf.IResolvable | undefined;
    private _enableMultiNetworking?;
    get enableMultiNetworking(): boolean | cdktf.IResolvable;
    set enableMultiNetworking(value: boolean | cdktf.IResolvable);
    resetEnableMultiNetworking(): void;
    get enableMultiNetworkingInput(): boolean | cdktf.IResolvable | undefined;
    private _enableShieldedNodes?;
    get enableShieldedNodes(): boolean | cdktf.IResolvable;
    set enableShieldedNodes(value: boolean | cdktf.IResolvable);
    resetEnableShieldedNodes(): void;
    get enableShieldedNodesInput(): boolean | cdktf.IResolvable | undefined;
    private _enableTpu?;
    get enableTpu(): boolean | cdktf.IResolvable;
    set enableTpu(value: boolean | cdktf.IResolvable);
    resetEnableTpu(): void;
    get enableTpuInput(): boolean | cdktf.IResolvable | undefined;
    get endpoint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _initialNodeCount?;
    get initialNodeCount(): number;
    set initialNodeCount(value: number);
    resetInitialNodeCount(): void;
    get initialNodeCountInput(): number | undefined;
    get labelFingerprint(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _loggingService?;
    get loggingService(): string;
    set loggingService(value: string);
    resetLoggingService(): void;
    get loggingServiceInput(): string | undefined;
    get masterVersion(): string;
    private _minMasterVersion?;
    get minMasterVersion(): string;
    set minMasterVersion(value: string);
    resetMinMasterVersion(): void;
    get minMasterVersionInput(): string | undefined;
    private _monitoringService?;
    get monitoringService(): string;
    set monitoringService(value: string);
    resetMonitoringService(): void;
    get monitoringServiceInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _networkingMode?;
    get networkingMode(): string;
    set networkingMode(value: string);
    resetNetworkingMode(): void;
    get networkingModeInput(): string | undefined;
    private _nodeLocations?;
    get nodeLocations(): string[];
    set nodeLocations(value: string[]);
    resetNodeLocations(): void;
    get nodeLocationsInput(): string[] | undefined;
    private _nodeVersion?;
    get nodeVersion(): string;
    set nodeVersion(value: string);
    resetNodeVersion(): void;
    get nodeVersionInput(): string | undefined;
    get operation(): string;
    private _privateIpv6GoogleAccess?;
    get privateIpv6GoogleAccess(): string;
    set privateIpv6GoogleAccess(value: string);
    resetPrivateIpv6GoogleAccess(): void;
    get privateIpv6GoogleAccessInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _removeDefaultNodePool?;
    get removeDefaultNodePool(): boolean | cdktf.IResolvable;
    set removeDefaultNodePool(value: boolean | cdktf.IResolvable);
    resetRemoveDefaultNodePool(): void;
    get removeDefaultNodePoolInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceLabels?;
    get resourceLabels(): {
        [key: string]: string;
    };
    set resourceLabels(value: {
        [key: string]: string;
    });
    resetResourceLabels(): void;
    get resourceLabelsInput(): {
        [key: string]: string;
    } | undefined;
    get selfLink(): string;
    get servicesIpv4Cidr(): string;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    get tpuIpv4CidrBlock(): string;
    private _addonsConfig;
    get addonsConfig(): GoogleContainerClusterAddonsConfigOutputReference;
    putAddonsConfig(value: GoogleContainerClusterAddonsConfig): void;
    resetAddonsConfig(): void;
    get addonsConfigInput(): GoogleContainerClusterAddonsConfig | undefined;
    private _authenticatorGroupsConfig;
    get authenticatorGroupsConfig(): GoogleContainerClusterAuthenticatorGroupsConfigOutputReference;
    putAuthenticatorGroupsConfig(value: GoogleContainerClusterAuthenticatorGroupsConfig): void;
    resetAuthenticatorGroupsConfig(): void;
    get authenticatorGroupsConfigInput(): GoogleContainerClusterAuthenticatorGroupsConfig | undefined;
    private _binaryAuthorization;
    get binaryAuthorization(): GoogleContainerClusterBinaryAuthorizationOutputReference;
    putBinaryAuthorization(value: GoogleContainerClusterBinaryAuthorization): void;
    resetBinaryAuthorization(): void;
    get binaryAuthorizationInput(): GoogleContainerClusterBinaryAuthorization | undefined;
    private _clusterAutoscaling;
    get clusterAutoscaling(): GoogleContainerClusterClusterAutoscalingOutputReference;
    putClusterAutoscaling(value: GoogleContainerClusterClusterAutoscaling): void;
    resetClusterAutoscaling(): void;
    get clusterAutoscalingInput(): GoogleContainerClusterClusterAutoscaling | undefined;
    private _clusterTelemetry;
    get clusterTelemetry(): GoogleContainerClusterClusterTelemetryOutputReference;
    putClusterTelemetry(value: GoogleContainerClusterClusterTelemetry): void;
    resetClusterTelemetry(): void;
    get clusterTelemetryInput(): GoogleContainerClusterClusterTelemetry | undefined;
    private _confidentialNodes;
    get confidentialNodes(): GoogleContainerClusterConfidentialNodesOutputReference;
    putConfidentialNodes(value: GoogleContainerClusterConfidentialNodes): void;
    resetConfidentialNodes(): void;
    get confidentialNodesInput(): GoogleContainerClusterConfidentialNodes | undefined;
    private _costManagementConfig;
    get costManagementConfig(): GoogleContainerClusterCostManagementConfigOutputReference;
    putCostManagementConfig(value: GoogleContainerClusterCostManagementConfig): void;
    resetCostManagementConfig(): void;
    get costManagementConfigInput(): GoogleContainerClusterCostManagementConfig | undefined;
    private _databaseEncryption;
    get databaseEncryption(): GoogleContainerClusterDatabaseEncryptionOutputReference;
    putDatabaseEncryption(value: GoogleContainerClusterDatabaseEncryption): void;
    resetDatabaseEncryption(): void;
    get databaseEncryptionInput(): GoogleContainerClusterDatabaseEncryption | undefined;
    private _defaultSnatStatus;
    get defaultSnatStatus(): GoogleContainerClusterDefaultSnatStatusOutputReference;
    putDefaultSnatStatus(value: GoogleContainerClusterDefaultSnatStatus): void;
    resetDefaultSnatStatus(): void;
    get defaultSnatStatusInput(): GoogleContainerClusterDefaultSnatStatus | undefined;
    private _dnsConfig;
    get dnsConfig(): GoogleContainerClusterDnsConfigOutputReference;
    putDnsConfig(value: GoogleContainerClusterDnsConfig): void;
    resetDnsConfig(): void;
    get dnsConfigInput(): GoogleContainerClusterDnsConfig | undefined;
    private _enableK8SBetaApis;
    get enableK8SBetaApis(): GoogleContainerClusterEnableK8SBetaApisOutputReference;
    putEnableK8SBetaApis(value: GoogleContainerClusterEnableK8SBetaApis): void;
    resetEnableK8SBetaApis(): void;
    get enableK8SBetaApisInput(): GoogleContainerClusterEnableK8SBetaApis | undefined;
    private _fleet;
    get fleet(): GoogleContainerClusterFleetOutputReference;
    putFleet(value: GoogleContainerClusterFleet): void;
    resetFleet(): void;
    get fleetInput(): GoogleContainerClusterFleet | undefined;
    private _gatewayApiConfig;
    get gatewayApiConfig(): GoogleContainerClusterGatewayApiConfigOutputReference;
    putGatewayApiConfig(value: GoogleContainerClusterGatewayApiConfig): void;
    resetGatewayApiConfig(): void;
    get gatewayApiConfigInput(): GoogleContainerClusterGatewayApiConfig | undefined;
    private _identityServiceConfig;
    get identityServiceConfig(): GoogleContainerClusterIdentityServiceConfigOutputReference;
    putIdentityServiceConfig(value: GoogleContainerClusterIdentityServiceConfig): void;
    resetIdentityServiceConfig(): void;
    get identityServiceConfigInput(): GoogleContainerClusterIdentityServiceConfig | undefined;
    private _ipAllocationPolicy;
    get ipAllocationPolicy(): GoogleContainerClusterIpAllocationPolicyOutputReference;
    putIpAllocationPolicy(value: GoogleContainerClusterIpAllocationPolicy): void;
    resetIpAllocationPolicy(): void;
    get ipAllocationPolicyInput(): GoogleContainerClusterIpAllocationPolicy | undefined;
    private _loggingConfig;
    get loggingConfig(): GoogleContainerClusterLoggingConfigOutputReference;
    putLoggingConfig(value: GoogleContainerClusterLoggingConfig): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): GoogleContainerClusterLoggingConfig | undefined;
    private _maintenancePolicy;
    get maintenancePolicy(): GoogleContainerClusterMaintenancePolicyOutputReference;
    putMaintenancePolicy(value: GoogleContainerClusterMaintenancePolicy): void;
    resetMaintenancePolicy(): void;
    get maintenancePolicyInput(): GoogleContainerClusterMaintenancePolicy | undefined;
    private _masterAuth;
    get masterAuth(): GoogleContainerClusterMasterAuthOutputReference;
    putMasterAuth(value: GoogleContainerClusterMasterAuth): void;
    resetMasterAuth(): void;
    get masterAuthInput(): GoogleContainerClusterMasterAuth | undefined;
    private _masterAuthorizedNetworksConfig;
    get masterAuthorizedNetworksConfig(): GoogleContainerClusterMasterAuthorizedNetworksConfigOutputReference;
    putMasterAuthorizedNetworksConfig(value: GoogleContainerClusterMasterAuthorizedNetworksConfig): void;
    resetMasterAuthorizedNetworksConfig(): void;
    get masterAuthorizedNetworksConfigInput(): GoogleContainerClusterMasterAuthorizedNetworksConfig | undefined;
    private _meshCertificates;
    get meshCertificates(): GoogleContainerClusterMeshCertificatesOutputReference;
    putMeshCertificates(value: GoogleContainerClusterMeshCertificates): void;
    resetMeshCertificates(): void;
    get meshCertificatesInput(): GoogleContainerClusterMeshCertificates | undefined;
    private _monitoringConfig;
    get monitoringConfig(): GoogleContainerClusterMonitoringConfigOutputReference;
    putMonitoringConfig(value: GoogleContainerClusterMonitoringConfig): void;
    resetMonitoringConfig(): void;
    get monitoringConfigInput(): GoogleContainerClusterMonitoringConfig | undefined;
    private _networkPolicy;
    get networkPolicy(): GoogleContainerClusterNetworkPolicyOutputReference;
    putNetworkPolicy(value: GoogleContainerClusterNetworkPolicy): void;
    resetNetworkPolicy(): void;
    get networkPolicyInput(): GoogleContainerClusterNetworkPolicy | undefined;
    private _nodeConfig;
    get nodeConfig(): GoogleContainerClusterNodeConfigOutputReference;
    putNodeConfig(value: GoogleContainerClusterNodeConfig): void;
    resetNodeConfig(): void;
    get nodeConfigInput(): GoogleContainerClusterNodeConfig | undefined;
    private _nodePool;
    get nodePool(): GoogleContainerClusterNodePoolList;
    putNodePool(value: GoogleContainerClusterNodePool[] | cdktf.IResolvable): void;
    resetNodePool(): void;
    get nodePoolInput(): cdktf.IResolvable | GoogleContainerClusterNodePool[] | undefined;
    private _nodePoolAutoConfig;
    get nodePoolAutoConfig(): GoogleContainerClusterNodePoolAutoConfigOutputReference;
    putNodePoolAutoConfig(value: GoogleContainerClusterNodePoolAutoConfig): void;
    resetNodePoolAutoConfig(): void;
    get nodePoolAutoConfigInput(): GoogleContainerClusterNodePoolAutoConfig | undefined;
    private _nodePoolDefaults;
    get nodePoolDefaults(): GoogleContainerClusterNodePoolDefaultsOutputReference;
    putNodePoolDefaults(value: GoogleContainerClusterNodePoolDefaults): void;
    resetNodePoolDefaults(): void;
    get nodePoolDefaultsInput(): GoogleContainerClusterNodePoolDefaults | undefined;
    private _notificationConfig;
    get notificationConfig(): GoogleContainerClusterNotificationConfigOutputReference;
    putNotificationConfig(value: GoogleContainerClusterNotificationConfig): void;
    resetNotificationConfig(): void;
    get notificationConfigInput(): GoogleContainerClusterNotificationConfig | undefined;
    private _podSecurityPolicyConfig;
    get podSecurityPolicyConfig(): GoogleContainerClusterPodSecurityPolicyConfigOutputReference;
    putPodSecurityPolicyConfig(value: GoogleContainerClusterPodSecurityPolicyConfig): void;
    resetPodSecurityPolicyConfig(): void;
    get podSecurityPolicyConfigInput(): GoogleContainerClusterPodSecurityPolicyConfig | undefined;
    private _privateClusterConfig;
    get privateClusterConfig(): GoogleContainerClusterPrivateClusterConfigOutputReference;
    putPrivateClusterConfig(value: GoogleContainerClusterPrivateClusterConfig): void;
    resetPrivateClusterConfig(): void;
    get privateClusterConfigInput(): GoogleContainerClusterPrivateClusterConfig | undefined;
    private _protectConfig;
    get protectConfig(): GoogleContainerClusterProtectConfigOutputReference;
    putProtectConfig(value: GoogleContainerClusterProtectConfig): void;
    resetProtectConfig(): void;
    get protectConfigInput(): GoogleContainerClusterProtectConfig | undefined;
    private _releaseChannel;
    get releaseChannel(): GoogleContainerClusterReleaseChannelOutputReference;
    putReleaseChannel(value: GoogleContainerClusterReleaseChannel): void;
    resetReleaseChannel(): void;
    get releaseChannelInput(): GoogleContainerClusterReleaseChannel | undefined;
    private _resourceUsageExportConfig;
    get resourceUsageExportConfig(): GoogleContainerClusterResourceUsageExportConfigOutputReference;
    putResourceUsageExportConfig(value: GoogleContainerClusterResourceUsageExportConfig): void;
    resetResourceUsageExportConfig(): void;
    get resourceUsageExportConfigInput(): GoogleContainerClusterResourceUsageExportConfig | undefined;
    private _securityPostureConfig;
    get securityPostureConfig(): GoogleContainerClusterSecurityPostureConfigOutputReference;
    putSecurityPostureConfig(value: GoogleContainerClusterSecurityPostureConfig): void;
    resetSecurityPostureConfig(): void;
    get securityPostureConfigInput(): GoogleContainerClusterSecurityPostureConfig | undefined;
    private _serviceExternalIpsConfig;
    get serviceExternalIpsConfig(): GoogleContainerClusterServiceExternalIpsConfigOutputReference;
    putServiceExternalIpsConfig(value: GoogleContainerClusterServiceExternalIpsConfig): void;
    resetServiceExternalIpsConfig(): void;
    get serviceExternalIpsConfigInput(): GoogleContainerClusterServiceExternalIpsConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleContainerClusterTimeoutsOutputReference;
    putTimeouts(value: GoogleContainerClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleContainerClusterTimeouts | undefined;
    private _tpuConfig;
    get tpuConfig(): GoogleContainerClusterTpuConfigOutputReference;
    putTpuConfig(value: GoogleContainerClusterTpuConfig): void;
    resetTpuConfig(): void;
    get tpuConfigInput(): GoogleContainerClusterTpuConfig | undefined;
    private _verticalPodAutoscaling;
    get verticalPodAutoscaling(): GoogleContainerClusterVerticalPodAutoscalingOutputReference;
    putVerticalPodAutoscaling(value: GoogleContainerClusterVerticalPodAutoscaling): void;
    resetVerticalPodAutoscaling(): void;
    get verticalPodAutoscalingInput(): GoogleContainerClusterVerticalPodAutoscaling | undefined;
    private _workloadAltsConfig;
    get workloadAltsConfig(): GoogleContainerClusterWorkloadAltsConfigOutputReference;
    putWorkloadAltsConfig(value: GoogleContainerClusterWorkloadAltsConfig): void;
    resetWorkloadAltsConfig(): void;
    get workloadAltsConfigInput(): GoogleContainerClusterWorkloadAltsConfig | undefined;
    private _workloadIdentityConfig;
    get workloadIdentityConfig(): GoogleContainerClusterWorkloadIdentityConfigOutputReference;
    putWorkloadIdentityConfig(value: GoogleContainerClusterWorkloadIdentityConfig): void;
    resetWorkloadIdentityConfig(): void;
    get workloadIdentityConfigInput(): GoogleContainerClusterWorkloadIdentityConfig | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
