"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoogleContainerCluster = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
// generated from terraform resource schema
const index_structs_1 = require("./index-structs");
__exportStar(require("./index-structs"), exports);
const cdktf = require("cdktf");
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster google_container_cluster}
*/
class GoogleContainerCluster extends cdktf.TerraformResource {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a GoogleContainerCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleContainerCluster to import
    * @param importFromId The id of the existing GoogleContainerCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleContainerCluster to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "google_container_cluster", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_container_cluster google_container_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleContainerClusterConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'google_container_cluster',
            terraformGeneratorMetadata: {
                providerName: 'google-beta',
                providerVersion: '5.21.0',
                providerVersionConstraint: '~> 5.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // addons_config - computed: false, optional: true, required: false
        this._addonsConfig = new index_structs_1.GoogleContainerClusterAddonsConfigOutputReference(this, "addons_config");
        // authenticator_groups_config - computed: false, optional: true, required: false
        this._authenticatorGroupsConfig = new index_structs_1.GoogleContainerClusterAuthenticatorGroupsConfigOutputReference(this, "authenticator_groups_config");
        // binary_authorization - computed: false, optional: true, required: false
        this._binaryAuthorization = new index_structs_1.GoogleContainerClusterBinaryAuthorizationOutputReference(this, "binary_authorization");
        // cluster_autoscaling - computed: false, optional: true, required: false
        this._clusterAutoscaling = new index_structs_1.GoogleContainerClusterClusterAutoscalingOutputReference(this, "cluster_autoscaling");
        // cluster_telemetry - computed: false, optional: true, required: false
        this._clusterTelemetry = new index_structs_1.GoogleContainerClusterClusterTelemetryOutputReference(this, "cluster_telemetry");
        // confidential_nodes - computed: false, optional: true, required: false
        this._confidentialNodes = new index_structs_1.GoogleContainerClusterConfidentialNodesOutputReference(this, "confidential_nodes");
        // cost_management_config - computed: false, optional: true, required: false
        this._costManagementConfig = new index_structs_1.GoogleContainerClusterCostManagementConfigOutputReference(this, "cost_management_config");
        // database_encryption - computed: false, optional: true, required: false
        this._databaseEncryption = new index_structs_1.GoogleContainerClusterDatabaseEncryptionOutputReference(this, "database_encryption");
        // default_snat_status - computed: false, optional: true, required: false
        this._defaultSnatStatus = new index_structs_1.GoogleContainerClusterDefaultSnatStatusOutputReference(this, "default_snat_status");
        // dns_config - computed: false, optional: true, required: false
        this._dnsConfig = new index_structs_1.GoogleContainerClusterDnsConfigOutputReference(this, "dns_config");
        // enable_k8s_beta_apis - computed: false, optional: true, required: false
        this._enableK8SBetaApis = new index_structs_1.GoogleContainerClusterEnableK8SBetaApisOutputReference(this, "enable_k8s_beta_apis");
        // fleet - computed: false, optional: true, required: false
        this._fleet = new index_structs_1.GoogleContainerClusterFleetOutputReference(this, "fleet");
        // gateway_api_config - computed: false, optional: true, required: false
        this._gatewayApiConfig = new index_structs_1.GoogleContainerClusterGatewayApiConfigOutputReference(this, "gateway_api_config");
        // identity_service_config - computed: false, optional: true, required: false
        this._identityServiceConfig = new index_structs_1.GoogleContainerClusterIdentityServiceConfigOutputReference(this, "identity_service_config");
        // ip_allocation_policy - computed: false, optional: true, required: false
        this._ipAllocationPolicy = new index_structs_1.GoogleContainerClusterIpAllocationPolicyOutputReference(this, "ip_allocation_policy");
        // logging_config - computed: false, optional: true, required: false
        this._loggingConfig = new index_structs_1.GoogleContainerClusterLoggingConfigOutputReference(this, "logging_config");
        // maintenance_policy - computed: false, optional: true, required: false
        this._maintenancePolicy = new index_structs_1.GoogleContainerClusterMaintenancePolicyOutputReference(this, "maintenance_policy");
        // master_auth - computed: false, optional: true, required: false
        this._masterAuth = new index_structs_1.GoogleContainerClusterMasterAuthOutputReference(this, "master_auth");
        // master_authorized_networks_config - computed: false, optional: true, required: false
        this._masterAuthorizedNetworksConfig = new index_structs_1.GoogleContainerClusterMasterAuthorizedNetworksConfigOutputReference(this, "master_authorized_networks_config");
        // mesh_certificates - computed: false, optional: true, required: false
        this._meshCertificates = new index_structs_1.GoogleContainerClusterMeshCertificatesOutputReference(this, "mesh_certificates");
        // monitoring_config - computed: false, optional: true, required: false
        this._monitoringConfig = new index_structs_1.GoogleContainerClusterMonitoringConfigOutputReference(this, "monitoring_config");
        // network_policy - computed: false, optional: true, required: false
        this._networkPolicy = new index_structs_1.GoogleContainerClusterNetworkPolicyOutputReference(this, "network_policy");
        // node_config - computed: false, optional: true, required: false
        this._nodeConfig = new index_structs_1.GoogleContainerClusterNodeConfigOutputReference(this, "node_config");
        // node_pool - computed: false, optional: true, required: false
        this._nodePool = new index_structs_1.GoogleContainerClusterNodePoolList(this, "node_pool", false);
        // node_pool_auto_config - computed: false, optional: true, required: false
        this._nodePoolAutoConfig = new index_structs_1.GoogleContainerClusterNodePoolAutoConfigOutputReference(this, "node_pool_auto_config");
        // node_pool_defaults - computed: false, optional: true, required: false
        this._nodePoolDefaults = new index_structs_1.GoogleContainerClusterNodePoolDefaultsOutputReference(this, "node_pool_defaults");
        // notification_config - computed: false, optional: true, required: false
        this._notificationConfig = new index_structs_1.GoogleContainerClusterNotificationConfigOutputReference(this, "notification_config");
        // pod_security_policy_config - computed: false, optional: true, required: false
        this._podSecurityPolicyConfig = new index_structs_1.GoogleContainerClusterPodSecurityPolicyConfigOutputReference(this, "pod_security_policy_config");
        // private_cluster_config - computed: false, optional: true, required: false
        this._privateClusterConfig = new index_structs_1.GoogleContainerClusterPrivateClusterConfigOutputReference(this, "private_cluster_config");
        // protect_config - computed: false, optional: true, required: false
        this._protectConfig = new index_structs_1.GoogleContainerClusterProtectConfigOutputReference(this, "protect_config");
        // release_channel - computed: false, optional: true, required: false
        this._releaseChannel = new index_structs_1.GoogleContainerClusterReleaseChannelOutputReference(this, "release_channel");
        // resource_usage_export_config - computed: false, optional: true, required: false
        this._resourceUsageExportConfig = new index_structs_1.GoogleContainerClusterResourceUsageExportConfigOutputReference(this, "resource_usage_export_config");
        // security_posture_config - computed: false, optional: true, required: false
        this._securityPostureConfig = new index_structs_1.GoogleContainerClusterSecurityPostureConfigOutputReference(this, "security_posture_config");
        // service_external_ips_config - computed: false, optional: true, required: false
        this._serviceExternalIpsConfig = new index_structs_1.GoogleContainerClusterServiceExternalIpsConfigOutputReference(this, "service_external_ips_config");
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new index_structs_1.GoogleContainerClusterTimeoutsOutputReference(this, "timeouts");
        // tpu_config - computed: false, optional: true, required: false
        this._tpuConfig = new index_structs_1.GoogleContainerClusterTpuConfigOutputReference(this, "tpu_config");
        // vertical_pod_autoscaling - computed: false, optional: true, required: false
        this._verticalPodAutoscaling = new index_structs_1.GoogleContainerClusterVerticalPodAutoscalingOutputReference(this, "vertical_pod_autoscaling");
        // workload_alts_config - computed: false, optional: true, required: false
        this._workloadAltsConfig = new index_structs_1.GoogleContainerClusterWorkloadAltsConfigOutputReference(this, "workload_alts_config");
        // workload_identity_config - computed: false, optional: true, required: false
        this._workloadIdentityConfig = new index_structs_1.GoogleContainerClusterWorkloadIdentityConfigOutputReference(this, "workload_identity_config");
        this._allowNetAdmin = config.allowNetAdmin;
        this._clusterIpv4Cidr = config.clusterIpv4Cidr;
        this._datapathProvider = config.datapathProvider;
        this._defaultMaxPodsPerNode = config.defaultMaxPodsPerNode;
        this._deletionProtection = config.deletionProtection;
        this._description = config.description;
        this._enableAutopilot = config.enableAutopilot;
        this._enableFqdnNetworkPolicy = config.enableFqdnNetworkPolicy;
        this._enableIntranodeVisibility = config.enableIntranodeVisibility;
        this._enableKubernetesAlpha = config.enableKubernetesAlpha;
        this._enableL4IlbSubsetting = config.enableL4IlbSubsetting;
        this._enableLegacyAbac = config.enableLegacyAbac;
        this._enableMultiNetworking = config.enableMultiNetworking;
        this._enableShieldedNodes = config.enableShieldedNodes;
        this._enableTpu = config.enableTpu;
        this._id = config.id;
        this._initialNodeCount = config.initialNodeCount;
        this._location = config.location;
        this._loggingService = config.loggingService;
        this._minMasterVersion = config.minMasterVersion;
        this._monitoringService = config.monitoringService;
        this._name = config.name;
        this._network = config.network;
        this._networkingMode = config.networkingMode;
        this._nodeLocations = config.nodeLocations;
        this._nodeVersion = config.nodeVersion;
        this._privateIpv6GoogleAccess = config.privateIpv6GoogleAccess;
        this._project = config.project;
        this._removeDefaultNodePool = config.removeDefaultNodePool;
        this._resourceLabels = config.resourceLabels;
        this._subnetwork = config.subnetwork;
        this._addonsConfig.internalValue = config.addonsConfig;
        this._authenticatorGroupsConfig.internalValue = config.authenticatorGroupsConfig;
        this._binaryAuthorization.internalValue = config.binaryAuthorization;
        this._clusterAutoscaling.internalValue = config.clusterAutoscaling;
        this._clusterTelemetry.internalValue = config.clusterTelemetry;
        this._confidentialNodes.internalValue = config.confidentialNodes;
        this._costManagementConfig.internalValue = config.costManagementConfig;
        this._databaseEncryption.internalValue = config.databaseEncryption;
        this._defaultSnatStatus.internalValue = config.defaultSnatStatus;
        this._dnsConfig.internalValue = config.dnsConfig;
        this._enableK8SBetaApis.internalValue = config.enableK8SBetaApis;
        this._fleet.internalValue = config.fleet;
        this._gatewayApiConfig.internalValue = config.gatewayApiConfig;
        this._identityServiceConfig.internalValue = config.identityServiceConfig;
        this._ipAllocationPolicy.internalValue = config.ipAllocationPolicy;
        this._loggingConfig.internalValue = config.loggingConfig;
        this._maintenancePolicy.internalValue = config.maintenancePolicy;
        this._masterAuth.internalValue = config.masterAuth;
        this._masterAuthorizedNetworksConfig.internalValue = config.masterAuthorizedNetworksConfig;
        this._meshCertificates.internalValue = config.meshCertificates;
        this._monitoringConfig.internalValue = config.monitoringConfig;
        this._networkPolicy.internalValue = config.networkPolicy;
        this._nodeConfig.internalValue = config.nodeConfig;
        this._nodePool.internalValue = config.nodePool;
        this._nodePoolAutoConfig.internalValue = config.nodePoolAutoConfig;
        this._nodePoolDefaults.internalValue = config.nodePoolDefaults;
        this._notificationConfig.internalValue = config.notificationConfig;
        this._podSecurityPolicyConfig.internalValue = config.podSecurityPolicyConfig;
        this._privateClusterConfig.internalValue = config.privateClusterConfig;
        this._protectConfig.internalValue = config.protectConfig;
        this._releaseChannel.internalValue = config.releaseChannel;
        this._resourceUsageExportConfig.internalValue = config.resourceUsageExportConfig;
        this._securityPostureConfig.internalValue = config.securityPostureConfig;
        this._serviceExternalIpsConfig.internalValue = config.serviceExternalIpsConfig;
        this._timeouts.internalValue = config.timeouts;
        this._tpuConfig.internalValue = config.tpuConfig;
        this._verticalPodAutoscaling.internalValue = config.verticalPodAutoscaling;
        this._workloadAltsConfig.internalValue = config.workloadAltsConfig;
        this._workloadIdentityConfig.internalValue = config.workloadIdentityConfig;
    }
    get allowNetAdmin() {
        return this.getBooleanAttribute('allow_net_admin');
    }
    set allowNetAdmin(value) {
        this._allowNetAdmin = value;
    }
    resetAllowNetAdmin() {
        this._allowNetAdmin = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowNetAdminInput() {
        return this._allowNetAdmin;
    }
    get clusterIpv4Cidr() {
        return this.getStringAttribute('cluster_ipv4_cidr');
    }
    set clusterIpv4Cidr(value) {
        this._clusterIpv4Cidr = value;
    }
    resetClusterIpv4Cidr() {
        this._clusterIpv4Cidr = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clusterIpv4CidrInput() {
        return this._clusterIpv4Cidr;
    }
    get datapathProvider() {
        return this.getStringAttribute('datapath_provider');
    }
    set datapathProvider(value) {
        this._datapathProvider = value;
    }
    resetDatapathProvider() {
        this._datapathProvider = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get datapathProviderInput() {
        return this._datapathProvider;
    }
    get defaultMaxPodsPerNode() {
        return this.getNumberAttribute('default_max_pods_per_node');
    }
    set defaultMaxPodsPerNode(value) {
        this._defaultMaxPodsPerNode = value;
    }
    resetDefaultMaxPodsPerNode() {
        this._defaultMaxPodsPerNode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultMaxPodsPerNodeInput() {
        return this._defaultMaxPodsPerNode;
    }
    get deletionProtection() {
        return this.getBooleanAttribute('deletion_protection');
    }
    set deletionProtection(value) {
        this._deletionProtection = value;
    }
    resetDeletionProtection() {
        this._deletionProtection = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deletionProtectionInput() {
        return this._deletionProtection;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get enableAutopilot() {
        return this.getBooleanAttribute('enable_autopilot');
    }
    set enableAutopilot(value) {
        this._enableAutopilot = value;
    }
    resetEnableAutopilot() {
        this._enableAutopilot = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableAutopilotInput() {
        return this._enableAutopilot;
    }
    get enableFqdnNetworkPolicy() {
        return this.getBooleanAttribute('enable_fqdn_network_policy');
    }
    set enableFqdnNetworkPolicy(value) {
        this._enableFqdnNetworkPolicy = value;
    }
    resetEnableFqdnNetworkPolicy() {
        this._enableFqdnNetworkPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableFqdnNetworkPolicyInput() {
        return this._enableFqdnNetworkPolicy;
    }
    get enableIntranodeVisibility() {
        return this.getBooleanAttribute('enable_intranode_visibility');
    }
    set enableIntranodeVisibility(value) {
        this._enableIntranodeVisibility = value;
    }
    resetEnableIntranodeVisibility() {
        this._enableIntranodeVisibility = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableIntranodeVisibilityInput() {
        return this._enableIntranodeVisibility;
    }
    get enableKubernetesAlpha() {
        return this.getBooleanAttribute('enable_kubernetes_alpha');
    }
    set enableKubernetesAlpha(value) {
        this._enableKubernetesAlpha = value;
    }
    resetEnableKubernetesAlpha() {
        this._enableKubernetesAlpha = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableKubernetesAlphaInput() {
        return this._enableKubernetesAlpha;
    }
    get enableL4IlbSubsetting() {
        return this.getBooleanAttribute('enable_l4_ilb_subsetting');
    }
    set enableL4IlbSubsetting(value) {
        this._enableL4IlbSubsetting = value;
    }
    resetEnableL4IlbSubsetting() {
        this._enableL4IlbSubsetting = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableL4IlbSubsettingInput() {
        return this._enableL4IlbSubsetting;
    }
    get enableLegacyAbac() {
        return this.getBooleanAttribute('enable_legacy_abac');
    }
    set enableLegacyAbac(value) {
        this._enableLegacyAbac = value;
    }
    resetEnableLegacyAbac() {
        this._enableLegacyAbac = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableLegacyAbacInput() {
        return this._enableLegacyAbac;
    }
    get enableMultiNetworking() {
        return this.getBooleanAttribute('enable_multi_networking');
    }
    set enableMultiNetworking(value) {
        this._enableMultiNetworking = value;
    }
    resetEnableMultiNetworking() {
        this._enableMultiNetworking = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableMultiNetworkingInput() {
        return this._enableMultiNetworking;
    }
    get enableShieldedNodes() {
        return this.getBooleanAttribute('enable_shielded_nodes');
    }
    set enableShieldedNodes(value) {
        this._enableShieldedNodes = value;
    }
    resetEnableShieldedNodes() {
        this._enableShieldedNodes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableShieldedNodesInput() {
        return this._enableShieldedNodes;
    }
    get enableTpu() {
        return this.getBooleanAttribute('enable_tpu');
    }
    set enableTpu(value) {
        this._enableTpu = value;
    }
    resetEnableTpu() {
        this._enableTpu = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableTpuInput() {
        return this._enableTpu;
    }
    // endpoint - computed: true, optional: false, required: false
    get endpoint() {
        return this.getStringAttribute('endpoint');
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get initialNodeCount() {
        return this.getNumberAttribute('initial_node_count');
    }
    set initialNodeCount(value) {
        this._initialNodeCount = value;
    }
    resetInitialNodeCount() {
        this._initialNodeCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get initialNodeCountInput() {
        return this._initialNodeCount;
    }
    // label_fingerprint - computed: true, optional: false, required: false
    get labelFingerprint() {
        return this.getStringAttribute('label_fingerprint');
    }
    get location() {
        return this.getStringAttribute('location');
    }
    set location(value) {
        this._location = value;
    }
    resetLocation() {
        this._location = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get locationInput() {
        return this._location;
    }
    get loggingService() {
        return this.getStringAttribute('logging_service');
    }
    set loggingService(value) {
        this._loggingService = value;
    }
    resetLoggingService() {
        this._loggingService = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get loggingServiceInput() {
        return this._loggingService;
    }
    // master_version - computed: true, optional: false, required: false
    get masterVersion() {
        return this.getStringAttribute('master_version');
    }
    get minMasterVersion() {
        return this.getStringAttribute('min_master_version');
    }
    set minMasterVersion(value) {
        this._minMasterVersion = value;
    }
    resetMinMasterVersion() {
        this._minMasterVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minMasterVersionInput() {
        return this._minMasterVersion;
    }
    get monitoringService() {
        return this.getStringAttribute('monitoring_service');
    }
    set monitoringService(value) {
        this._monitoringService = value;
    }
    resetMonitoringService() {
        this._monitoringService = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get monitoringServiceInput() {
        return this._monitoringService;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get network() {
        return this.getStringAttribute('network');
    }
    set network(value) {
        this._network = value;
    }
    resetNetwork() {
        this._network = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get networkInput() {
        return this._network;
    }
    get networkingMode() {
        return this.getStringAttribute('networking_mode');
    }
    set networkingMode(value) {
        this._networkingMode = value;
    }
    resetNetworkingMode() {
        this._networkingMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get networkingModeInput() {
        return this._networkingMode;
    }
    get nodeLocations() {
        return cdktf.Fn.tolist(this.getListAttribute('node_locations'));
    }
    set nodeLocations(value) {
        this._nodeLocations = value;
    }
    resetNodeLocations() {
        this._nodeLocations = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nodeLocationsInput() {
        return this._nodeLocations;
    }
    get nodeVersion() {
        return this.getStringAttribute('node_version');
    }
    set nodeVersion(value) {
        this._nodeVersion = value;
    }
    resetNodeVersion() {
        this._nodeVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nodeVersionInput() {
        return this._nodeVersion;
    }
    // operation - computed: true, optional: false, required: false
    get operation() {
        return this.getStringAttribute('operation');
    }
    get privateIpv6GoogleAccess() {
        return this.getStringAttribute('private_ipv6_google_access');
    }
    set privateIpv6GoogleAccess(value) {
        this._privateIpv6GoogleAccess = value;
    }
    resetPrivateIpv6GoogleAccess() {
        this._privateIpv6GoogleAccess = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get privateIpv6GoogleAccessInput() {
        return this._privateIpv6GoogleAccess;
    }
    get project() {
        return this.getStringAttribute('project');
    }
    set project(value) {
        this._project = value;
    }
    resetProject() {
        this._project = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get projectInput() {
        return this._project;
    }
    get removeDefaultNodePool() {
        return this.getBooleanAttribute('remove_default_node_pool');
    }
    set removeDefaultNodePool(value) {
        this._removeDefaultNodePool = value;
    }
    resetRemoveDefaultNodePool() {
        this._removeDefaultNodePool = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get removeDefaultNodePoolInput() {
        return this._removeDefaultNodePool;
    }
    get resourceLabels() {
        return this.getStringMapAttribute('resource_labels');
    }
    set resourceLabels(value) {
        this._resourceLabels = value;
    }
    resetResourceLabels() {
        this._resourceLabels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get resourceLabelsInput() {
        return this._resourceLabels;
    }
    // self_link - computed: true, optional: false, required: false
    get selfLink() {
        return this.getStringAttribute('self_link');
    }
    // services_ipv4_cidr - computed: true, optional: false, required: false
    get servicesIpv4Cidr() {
        return this.getStringAttribute('services_ipv4_cidr');
    }
    get subnetwork() {
        return this.getStringAttribute('subnetwork');
    }
    set subnetwork(value) {
        this._subnetwork = value;
    }
    resetSubnetwork() {
        this._subnetwork = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get subnetworkInput() {
        return this._subnetwork;
    }
    // tpu_ipv4_cidr_block - computed: true, optional: false, required: false
    get tpuIpv4CidrBlock() {
        return this.getStringAttribute('tpu_ipv4_cidr_block');
    }
    get addonsConfig() {
        return this._addonsConfig;
    }
    putAddonsConfig(value) {
        this._addonsConfig.internalValue = value;
    }
    resetAddonsConfig() {
        this._addonsConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get addonsConfigInput() {
        return this._addonsConfig.internalValue;
    }
    get authenticatorGroupsConfig() {
        return this._authenticatorGroupsConfig;
    }
    putAuthenticatorGroupsConfig(value) {
        this._authenticatorGroupsConfig.internalValue = value;
    }
    resetAuthenticatorGroupsConfig() {
        this._authenticatorGroupsConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authenticatorGroupsConfigInput() {
        return this._authenticatorGroupsConfig.internalValue;
    }
    get binaryAuthorization() {
        return this._binaryAuthorization;
    }
    putBinaryAuthorization(value) {
        this._binaryAuthorization.internalValue = value;
    }
    resetBinaryAuthorization() {
        this._binaryAuthorization.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get binaryAuthorizationInput() {
        return this._binaryAuthorization.internalValue;
    }
    get clusterAutoscaling() {
        return this._clusterAutoscaling;
    }
    putClusterAutoscaling(value) {
        this._clusterAutoscaling.internalValue = value;
    }
    resetClusterAutoscaling() {
        this._clusterAutoscaling.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clusterAutoscalingInput() {
        return this._clusterAutoscaling.internalValue;
    }
    get clusterTelemetry() {
        return this._clusterTelemetry;
    }
    putClusterTelemetry(value) {
        this._clusterTelemetry.internalValue = value;
    }
    resetClusterTelemetry() {
        this._clusterTelemetry.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clusterTelemetryInput() {
        return this._clusterTelemetry.internalValue;
    }
    get confidentialNodes() {
        return this._confidentialNodes;
    }
    putConfidentialNodes(value) {
        this._confidentialNodes.internalValue = value;
    }
    resetConfidentialNodes() {
        this._confidentialNodes.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get confidentialNodesInput() {
        return this._confidentialNodes.internalValue;
    }
    get costManagementConfig() {
        return this._costManagementConfig;
    }
    putCostManagementConfig(value) {
        this._costManagementConfig.internalValue = value;
    }
    resetCostManagementConfig() {
        this._costManagementConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get costManagementConfigInput() {
        return this._costManagementConfig.internalValue;
    }
    get databaseEncryption() {
        return this._databaseEncryption;
    }
    putDatabaseEncryption(value) {
        this._databaseEncryption.internalValue = value;
    }
    resetDatabaseEncryption() {
        this._databaseEncryption.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get databaseEncryptionInput() {
        return this._databaseEncryption.internalValue;
    }
    get defaultSnatStatus() {
        return this._defaultSnatStatus;
    }
    putDefaultSnatStatus(value) {
        this._defaultSnatStatus.internalValue = value;
    }
    resetDefaultSnatStatus() {
        this._defaultSnatStatus.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultSnatStatusInput() {
        return this._defaultSnatStatus.internalValue;
    }
    get dnsConfig() {
        return this._dnsConfig;
    }
    putDnsConfig(value) {
        this._dnsConfig.internalValue = value;
    }
    resetDnsConfig() {
        this._dnsConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dnsConfigInput() {
        return this._dnsConfig.internalValue;
    }
    get enableK8SBetaApis() {
        return this._enableK8SBetaApis;
    }
    putEnableK8SBetaApis(value) {
        this._enableK8SBetaApis.internalValue = value;
    }
    resetEnableK8SBetaApis() {
        this._enableK8SBetaApis.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableK8SBetaApisInput() {
        return this._enableK8SBetaApis.internalValue;
    }
    get fleet() {
        return this._fleet;
    }
    putFleet(value) {
        this._fleet.internalValue = value;
    }
    resetFleet() {
        this._fleet.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fleetInput() {
        return this._fleet.internalValue;
    }
    get gatewayApiConfig() {
        return this._gatewayApiConfig;
    }
    putGatewayApiConfig(value) {
        this._gatewayApiConfig.internalValue = value;
    }
    resetGatewayApiConfig() {
        this._gatewayApiConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gatewayApiConfigInput() {
        return this._gatewayApiConfig.internalValue;
    }
    get identityServiceConfig() {
        return this._identityServiceConfig;
    }
    putIdentityServiceConfig(value) {
        this._identityServiceConfig.internalValue = value;
    }
    resetIdentityServiceConfig() {
        this._identityServiceConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get identityServiceConfigInput() {
        return this._identityServiceConfig.internalValue;
    }
    get ipAllocationPolicy() {
        return this._ipAllocationPolicy;
    }
    putIpAllocationPolicy(value) {
        this._ipAllocationPolicy.internalValue = value;
    }
    resetIpAllocationPolicy() {
        this._ipAllocationPolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ipAllocationPolicyInput() {
        return this._ipAllocationPolicy.internalValue;
    }
    get loggingConfig() {
        return this._loggingConfig;
    }
    putLoggingConfig(value) {
        this._loggingConfig.internalValue = value;
    }
    resetLoggingConfig() {
        this._loggingConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get loggingConfigInput() {
        return this._loggingConfig.internalValue;
    }
    get maintenancePolicy() {
        return this._maintenancePolicy;
    }
    putMaintenancePolicy(value) {
        this._maintenancePolicy.internalValue = value;
    }
    resetMaintenancePolicy() {
        this._maintenancePolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maintenancePolicyInput() {
        return this._maintenancePolicy.internalValue;
    }
    get masterAuth() {
        return this._masterAuth;
    }
    putMasterAuth(value) {
        this._masterAuth.internalValue = value;
    }
    resetMasterAuth() {
        this._masterAuth.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get masterAuthInput() {
        return this._masterAuth.internalValue;
    }
    get masterAuthorizedNetworksConfig() {
        return this._masterAuthorizedNetworksConfig;
    }
    putMasterAuthorizedNetworksConfig(value) {
        this._masterAuthorizedNetworksConfig.internalValue = value;
    }
    resetMasterAuthorizedNetworksConfig() {
        this._masterAuthorizedNetworksConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get masterAuthorizedNetworksConfigInput() {
        return this._masterAuthorizedNetworksConfig.internalValue;
    }
    get meshCertificates() {
        return this._meshCertificates;
    }
    putMeshCertificates(value) {
        this._meshCertificates.internalValue = value;
    }
    resetMeshCertificates() {
        this._meshCertificates.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get meshCertificatesInput() {
        return this._meshCertificates.internalValue;
    }
    get monitoringConfig() {
        return this._monitoringConfig;
    }
    putMonitoringConfig(value) {
        this._monitoringConfig.internalValue = value;
    }
    resetMonitoringConfig() {
        this._monitoringConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get monitoringConfigInput() {
        return this._monitoringConfig.internalValue;
    }
    get networkPolicy() {
        return this._networkPolicy;
    }
    putNetworkPolicy(value) {
        this._networkPolicy.internalValue = value;
    }
    resetNetworkPolicy() {
        this._networkPolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get networkPolicyInput() {
        return this._networkPolicy.internalValue;
    }
    get nodeConfig() {
        return this._nodeConfig;
    }
    putNodeConfig(value) {
        this._nodeConfig.internalValue = value;
    }
    resetNodeConfig() {
        this._nodeConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nodeConfigInput() {
        return this._nodeConfig.internalValue;
    }
    get nodePool() {
        return this._nodePool;
    }
    putNodePool(value) {
        this._nodePool.internalValue = value;
    }
    resetNodePool() {
        this._nodePool.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nodePoolInput() {
        return this._nodePool.internalValue;
    }
    get nodePoolAutoConfig() {
        return this._nodePoolAutoConfig;
    }
    putNodePoolAutoConfig(value) {
        this._nodePoolAutoConfig.internalValue = value;
    }
    resetNodePoolAutoConfig() {
        this._nodePoolAutoConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nodePoolAutoConfigInput() {
        return this._nodePoolAutoConfig.internalValue;
    }
    get nodePoolDefaults() {
        return this._nodePoolDefaults;
    }
    putNodePoolDefaults(value) {
        this._nodePoolDefaults.internalValue = value;
    }
    resetNodePoolDefaults() {
        this._nodePoolDefaults.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nodePoolDefaultsInput() {
        return this._nodePoolDefaults.internalValue;
    }
    get notificationConfig() {
        return this._notificationConfig;
    }
    putNotificationConfig(value) {
        this._notificationConfig.internalValue = value;
    }
    resetNotificationConfig() {
        this._notificationConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get notificationConfigInput() {
        return this._notificationConfig.internalValue;
    }
    get podSecurityPolicyConfig() {
        return this._podSecurityPolicyConfig;
    }
    putPodSecurityPolicyConfig(value) {
        this._podSecurityPolicyConfig.internalValue = value;
    }
    resetPodSecurityPolicyConfig() {
        this._podSecurityPolicyConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get podSecurityPolicyConfigInput() {
        return this._podSecurityPolicyConfig.internalValue;
    }
    get privateClusterConfig() {
        return this._privateClusterConfig;
    }
    putPrivateClusterConfig(value) {
        this._privateClusterConfig.internalValue = value;
    }
    resetPrivateClusterConfig() {
        this._privateClusterConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get privateClusterConfigInput() {
        return this._privateClusterConfig.internalValue;
    }
    get protectConfig() {
        return this._protectConfig;
    }
    putProtectConfig(value) {
        this._protectConfig.internalValue = value;
    }
    resetProtectConfig() {
        this._protectConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get protectConfigInput() {
        return this._protectConfig.internalValue;
    }
    get releaseChannel() {
        return this._releaseChannel;
    }
    putReleaseChannel(value) {
        this._releaseChannel.internalValue = value;
    }
    resetReleaseChannel() {
        this._releaseChannel.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get releaseChannelInput() {
        return this._releaseChannel.internalValue;
    }
    get resourceUsageExportConfig() {
        return this._resourceUsageExportConfig;
    }
    putResourceUsageExportConfig(value) {
        this._resourceUsageExportConfig.internalValue = value;
    }
    resetResourceUsageExportConfig() {
        this._resourceUsageExportConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get resourceUsageExportConfigInput() {
        return this._resourceUsageExportConfig.internalValue;
    }
    get securityPostureConfig() {
        return this._securityPostureConfig;
    }
    putSecurityPostureConfig(value) {
        this._securityPostureConfig.internalValue = value;
    }
    resetSecurityPostureConfig() {
        this._securityPostureConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get securityPostureConfigInput() {
        return this._securityPostureConfig.internalValue;
    }
    get serviceExternalIpsConfig() {
        return this._serviceExternalIpsConfig;
    }
    putServiceExternalIpsConfig(value) {
        this._serviceExternalIpsConfig.internalValue = value;
    }
    resetServiceExternalIpsConfig() {
        this._serviceExternalIpsConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serviceExternalIpsConfigInput() {
        return this._serviceExternalIpsConfig.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    get tpuConfig() {
        return this._tpuConfig;
    }
    putTpuConfig(value) {
        this._tpuConfig.internalValue = value;
    }
    resetTpuConfig() {
        this._tpuConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tpuConfigInput() {
        return this._tpuConfig.internalValue;
    }
    get verticalPodAutoscaling() {
        return this._verticalPodAutoscaling;
    }
    putVerticalPodAutoscaling(value) {
        this._verticalPodAutoscaling.internalValue = value;
    }
    resetVerticalPodAutoscaling() {
        this._verticalPodAutoscaling.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get verticalPodAutoscalingInput() {
        return this._verticalPodAutoscaling.internalValue;
    }
    get workloadAltsConfig() {
        return this._workloadAltsConfig;
    }
    putWorkloadAltsConfig(value) {
        this._workloadAltsConfig.internalValue = value;
    }
    resetWorkloadAltsConfig() {
        this._workloadAltsConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get workloadAltsConfigInput() {
        return this._workloadAltsConfig.internalValue;
    }
    get workloadIdentityConfig() {
        return this._workloadIdentityConfig;
    }
    putWorkloadIdentityConfig(value) {
        this._workloadIdentityConfig.internalValue = value;
    }
    resetWorkloadIdentityConfig() {
        this._workloadIdentityConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get workloadIdentityConfigInput() {
        return this._workloadIdentityConfig.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            allow_net_admin: cdktf.booleanToTerraform(this._allowNetAdmin),
            cluster_ipv4_cidr: cdktf.stringToTerraform(this._clusterIpv4Cidr),
            datapath_provider: cdktf.stringToTerraform(this._datapathProvider),
            default_max_pods_per_node: cdktf.numberToTerraform(this._defaultMaxPodsPerNode),
            deletion_protection: cdktf.booleanToTerraform(this._deletionProtection),
            description: cdktf.stringToTerraform(this._description),
            enable_autopilot: cdktf.booleanToTerraform(this._enableAutopilot),
            enable_fqdn_network_policy: cdktf.booleanToTerraform(this._enableFqdnNetworkPolicy),
            enable_intranode_visibility: cdktf.booleanToTerraform(this._enableIntranodeVisibility),
            enable_kubernetes_alpha: cdktf.booleanToTerraform(this._enableKubernetesAlpha),
            enable_l4_ilb_subsetting: cdktf.booleanToTerraform(this._enableL4IlbSubsetting),
            enable_legacy_abac: cdktf.booleanToTerraform(this._enableLegacyAbac),
            enable_multi_networking: cdktf.booleanToTerraform(this._enableMultiNetworking),
            enable_shielded_nodes: cdktf.booleanToTerraform(this._enableShieldedNodes),
            enable_tpu: cdktf.booleanToTerraform(this._enableTpu),
            id: cdktf.stringToTerraform(this._id),
            initial_node_count: cdktf.numberToTerraform(this._initialNodeCount),
            location: cdktf.stringToTerraform(this._location),
            logging_service: cdktf.stringToTerraform(this._loggingService),
            min_master_version: cdktf.stringToTerraform(this._minMasterVersion),
            monitoring_service: cdktf.stringToTerraform(this._monitoringService),
            name: cdktf.stringToTerraform(this._name),
            network: cdktf.stringToTerraform(this._network),
            networking_mode: cdktf.stringToTerraform(this._networkingMode),
            node_locations: cdktf.listMapper(cdktf.stringToTerraform, false)(this._nodeLocations),
            node_version: cdktf.stringToTerraform(this._nodeVersion),
            private_ipv6_google_access: cdktf.stringToTerraform(this._privateIpv6GoogleAccess),
            project: cdktf.stringToTerraform(this._project),
            remove_default_node_pool: cdktf.booleanToTerraform(this._removeDefaultNodePool),
            resource_labels: cdktf.hashMapper(cdktf.stringToTerraform)(this._resourceLabels),
            subnetwork: cdktf.stringToTerraform(this._subnetwork),
            addons_config: (0, index_structs_1.googleContainerClusterAddonsConfigToTerraform)(this._addonsConfig.internalValue),
            authenticator_groups_config: (0, index_structs_1.googleContainerClusterAuthenticatorGroupsConfigToTerraform)(this._authenticatorGroupsConfig.internalValue),
            binary_authorization: (0, index_structs_1.googleContainerClusterBinaryAuthorizationToTerraform)(this._binaryAuthorization.internalValue),
            cluster_autoscaling: (0, index_structs_1.googleContainerClusterClusterAutoscalingToTerraform)(this._clusterAutoscaling.internalValue),
            cluster_telemetry: (0, index_structs_1.googleContainerClusterClusterTelemetryToTerraform)(this._clusterTelemetry.internalValue),
            confidential_nodes: (0, index_structs_1.googleContainerClusterConfidentialNodesToTerraform)(this._confidentialNodes.internalValue),
            cost_management_config: (0, index_structs_1.googleContainerClusterCostManagementConfigToTerraform)(this._costManagementConfig.internalValue),
            database_encryption: (0, index_structs_1.googleContainerClusterDatabaseEncryptionToTerraform)(this._databaseEncryption.internalValue),
            default_snat_status: (0, index_structs_1.googleContainerClusterDefaultSnatStatusToTerraform)(this._defaultSnatStatus.internalValue),
            dns_config: (0, index_structs_1.googleContainerClusterDnsConfigToTerraform)(this._dnsConfig.internalValue),
            enable_k8s_beta_apis: (0, index_structs_1.googleContainerClusterEnableK8SBetaApisToTerraform)(this._enableK8SBetaApis.internalValue),
            fleet: (0, index_structs_1.googleContainerClusterFleetToTerraform)(this._fleet.internalValue),
            gateway_api_config: (0, index_structs_1.googleContainerClusterGatewayApiConfigToTerraform)(this._gatewayApiConfig.internalValue),
            identity_service_config: (0, index_structs_1.googleContainerClusterIdentityServiceConfigToTerraform)(this._identityServiceConfig.internalValue),
            ip_allocation_policy: (0, index_structs_1.googleContainerClusterIpAllocationPolicyToTerraform)(this._ipAllocationPolicy.internalValue),
            logging_config: (0, index_structs_1.googleContainerClusterLoggingConfigToTerraform)(this._loggingConfig.internalValue),
            maintenance_policy: (0, index_structs_1.googleContainerClusterMaintenancePolicyToTerraform)(this._maintenancePolicy.internalValue),
            master_auth: (0, index_structs_1.googleContainerClusterMasterAuthToTerraform)(this._masterAuth.internalValue),
            master_authorized_networks_config: (0, index_structs_1.googleContainerClusterMasterAuthorizedNetworksConfigToTerraform)(this._masterAuthorizedNetworksConfig.internalValue),
            mesh_certificates: (0, index_structs_1.googleContainerClusterMeshCertificatesToTerraform)(this._meshCertificates.internalValue),
            monitoring_config: (0, index_structs_1.googleContainerClusterMonitoringConfigToTerraform)(this._monitoringConfig.internalValue),
            network_policy: (0, index_structs_1.googleContainerClusterNetworkPolicyToTerraform)(this._networkPolicy.internalValue),
            node_config: (0, index_structs_1.googleContainerClusterNodeConfigToTerraform)(this._nodeConfig.internalValue),
            node_pool: cdktf.listMapper(index_structs_1.googleContainerClusterNodePoolToTerraform, true)(this._nodePool.internalValue),
            node_pool_auto_config: (0, index_structs_1.googleContainerClusterNodePoolAutoConfigToTerraform)(this._nodePoolAutoConfig.internalValue),
            node_pool_defaults: (0, index_structs_1.googleContainerClusterNodePoolDefaultsToTerraform)(this._nodePoolDefaults.internalValue),
            notification_config: (0, index_structs_1.googleContainerClusterNotificationConfigToTerraform)(this._notificationConfig.internalValue),
            pod_security_policy_config: (0, index_structs_1.googleContainerClusterPodSecurityPolicyConfigToTerraform)(this._podSecurityPolicyConfig.internalValue),
            private_cluster_config: (0, index_structs_1.googleContainerClusterPrivateClusterConfigToTerraform)(this._privateClusterConfig.internalValue),
            protect_config: (0, index_structs_1.googleContainerClusterProtectConfigToTerraform)(this._protectConfig.internalValue),
            release_channel: (0, index_structs_1.googleContainerClusterReleaseChannelToTerraform)(this._releaseChannel.internalValue),
            resource_usage_export_config: (0, index_structs_1.googleContainerClusterResourceUsageExportConfigToTerraform)(this._resourceUsageExportConfig.internalValue),
            security_posture_config: (0, index_structs_1.googleContainerClusterSecurityPostureConfigToTerraform)(this._securityPostureConfig.internalValue),
            service_external_ips_config: (0, index_structs_1.googleContainerClusterServiceExternalIpsConfigToTerraform)(this._serviceExternalIpsConfig.internalValue),
            timeouts: (0, index_structs_1.googleContainerClusterTimeoutsToTerraform)(this._timeouts.internalValue),
            tpu_config: (0, index_structs_1.googleContainerClusterTpuConfigToTerraform)(this._tpuConfig.internalValue),
            vertical_pod_autoscaling: (0, index_structs_1.googleContainerClusterVerticalPodAutoscalingToTerraform)(this._verticalPodAutoscaling.internalValue),
            workload_alts_config: (0, index_structs_1.googleContainerClusterWorkloadAltsConfigToTerraform)(this._workloadAltsConfig.internalValue),
            workload_identity_config: (0, index_structs_1.googleContainerClusterWorkloadIdentityConfigToTerraform)(this._workloadIdentityConfig.internalValue),
        };
    }
    synthesizeHclAttributes() {
        const attrs = {
            allow_net_admin: {
                value: cdktf.booleanToHclTerraform(this._allowNetAdmin),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            cluster_ipv4_cidr: {
                value: cdktf.stringToHclTerraform(this._clusterIpv4Cidr),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            datapath_provider: {
                value: cdktf.stringToHclTerraform(this._datapathProvider),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            default_max_pods_per_node: {
                value: cdktf.numberToHclTerraform(this._defaultMaxPodsPerNode),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            deletion_protection: {
                value: cdktf.booleanToHclTerraform(this._deletionProtection),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            description: {
                value: cdktf.stringToHclTerraform(this._description),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            enable_autopilot: {
                value: cdktf.booleanToHclTerraform(this._enableAutopilot),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            enable_fqdn_network_policy: {
                value: cdktf.booleanToHclTerraform(this._enableFqdnNetworkPolicy),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            enable_intranode_visibility: {
                value: cdktf.booleanToHclTerraform(this._enableIntranodeVisibility),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            enable_kubernetes_alpha: {
                value: cdktf.booleanToHclTerraform(this._enableKubernetesAlpha),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            enable_l4_ilb_subsetting: {
                value: cdktf.booleanToHclTerraform(this._enableL4IlbSubsetting),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            enable_legacy_abac: {
                value: cdktf.booleanToHclTerraform(this._enableLegacyAbac),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            enable_multi_networking: {
                value: cdktf.booleanToHclTerraform(this._enableMultiNetworking),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            enable_shielded_nodes: {
                value: cdktf.booleanToHclTerraform(this._enableShieldedNodes),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            enable_tpu: {
                value: cdktf.booleanToHclTerraform(this._enableTpu),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            id: {
                value: cdktf.stringToHclTerraform(this._id),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            initial_node_count: {
                value: cdktf.numberToHclTerraform(this._initialNodeCount),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            location: {
                value: cdktf.stringToHclTerraform(this._location),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            logging_service: {
                value: cdktf.stringToHclTerraform(this._loggingService),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            min_master_version: {
                value: cdktf.stringToHclTerraform(this._minMasterVersion),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            monitoring_service: {
                value: cdktf.stringToHclTerraform(this._monitoringService),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            name: {
                value: cdktf.stringToHclTerraform(this._name),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            network: {
                value: cdktf.stringToHclTerraform(this._network),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            networking_mode: {
                value: cdktf.stringToHclTerraform(this._networkingMode),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            node_locations: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._nodeLocations),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            node_version: {
                value: cdktf.stringToHclTerraform(this._nodeVersion),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            private_ipv6_google_access: {
                value: cdktf.stringToHclTerraform(this._privateIpv6GoogleAccess),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            project: {
                value: cdktf.stringToHclTerraform(this._project),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            remove_default_node_pool: {
                value: cdktf.booleanToHclTerraform(this._removeDefaultNodePool),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            resource_labels: {
                value: cdktf.hashMapperHcl(cdktf.stringToHclTerraform)(this._resourceLabels),
                isBlock: false,
                type: "map",
                storageClassType: "stringMap",
            },
            subnetwork: {
                value: cdktf.stringToHclTerraform(this._subnetwork),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            addons_config: {
                value: (0, index_structs_1.googleContainerClusterAddonsConfigToHclTerraform)(this._addonsConfig.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterAddonsConfigList",
            },
            authenticator_groups_config: {
                value: (0, index_structs_1.googleContainerClusterAuthenticatorGroupsConfigToHclTerraform)(this._authenticatorGroupsConfig.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterAuthenticatorGroupsConfigList",
            },
            binary_authorization: {
                value: (0, index_structs_1.googleContainerClusterBinaryAuthorizationToHclTerraform)(this._binaryAuthorization.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterBinaryAuthorizationList",
            },
            cluster_autoscaling: {
                value: (0, index_structs_1.googleContainerClusterClusterAutoscalingToHclTerraform)(this._clusterAutoscaling.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterClusterAutoscalingList",
            },
            cluster_telemetry: {
                value: (0, index_structs_1.googleContainerClusterClusterTelemetryToHclTerraform)(this._clusterTelemetry.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterClusterTelemetryList",
            },
            confidential_nodes: {
                value: (0, index_structs_1.googleContainerClusterConfidentialNodesToHclTerraform)(this._confidentialNodes.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterConfidentialNodesList",
            },
            cost_management_config: {
                value: (0, index_structs_1.googleContainerClusterCostManagementConfigToHclTerraform)(this._costManagementConfig.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterCostManagementConfigList",
            },
            database_encryption: {
                value: (0, index_structs_1.googleContainerClusterDatabaseEncryptionToHclTerraform)(this._databaseEncryption.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterDatabaseEncryptionList",
            },
            default_snat_status: {
                value: (0, index_structs_1.googleContainerClusterDefaultSnatStatusToHclTerraform)(this._defaultSnatStatus.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterDefaultSnatStatusList",
            },
            dns_config: {
                value: (0, index_structs_1.googleContainerClusterDnsConfigToHclTerraform)(this._dnsConfig.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterDnsConfigList",
            },
            enable_k8s_beta_apis: {
                value: (0, index_structs_1.googleContainerClusterEnableK8SBetaApisToHclTerraform)(this._enableK8SBetaApis.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterEnableK8SBetaApisList",
            },
            fleet: {
                value: (0, index_structs_1.googleContainerClusterFleetToHclTerraform)(this._fleet.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterFleetList",
            },
            gateway_api_config: {
                value: (0, index_structs_1.googleContainerClusterGatewayApiConfigToHclTerraform)(this._gatewayApiConfig.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterGatewayApiConfigList",
            },
            identity_service_config: {
                value: (0, index_structs_1.googleContainerClusterIdentityServiceConfigToHclTerraform)(this._identityServiceConfig.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterIdentityServiceConfigList",
            },
            ip_allocation_policy: {
                value: (0, index_structs_1.googleContainerClusterIpAllocationPolicyToHclTerraform)(this._ipAllocationPolicy.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterIpAllocationPolicyList",
            },
            logging_config: {
                value: (0, index_structs_1.googleContainerClusterLoggingConfigToHclTerraform)(this._loggingConfig.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterLoggingConfigList",
            },
            maintenance_policy: {
                value: (0, index_structs_1.googleContainerClusterMaintenancePolicyToHclTerraform)(this._maintenancePolicy.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterMaintenancePolicyList",
            },
            master_auth: {
                value: (0, index_structs_1.googleContainerClusterMasterAuthToHclTerraform)(this._masterAuth.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterMasterAuthList",
            },
            master_authorized_networks_config: {
                value: (0, index_structs_1.googleContainerClusterMasterAuthorizedNetworksConfigToHclTerraform)(this._masterAuthorizedNetworksConfig.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterMasterAuthorizedNetworksConfigList",
            },
            mesh_certificates: {
                value: (0, index_structs_1.googleContainerClusterMeshCertificatesToHclTerraform)(this._meshCertificates.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterMeshCertificatesList",
            },
            monitoring_config: {
                value: (0, index_structs_1.googleContainerClusterMonitoringConfigToHclTerraform)(this._monitoringConfig.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterMonitoringConfigList",
            },
            network_policy: {
                value: (0, index_structs_1.googleContainerClusterNetworkPolicyToHclTerraform)(this._networkPolicy.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterNetworkPolicyList",
            },
            node_config: {
                value: (0, index_structs_1.googleContainerClusterNodeConfigToHclTerraform)(this._nodeConfig.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterNodeConfigList",
            },
            node_pool: {
                value: cdktf.listMapperHcl(index_structs_1.googleContainerClusterNodePoolToHclTerraform, true)(this._nodePool.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterNodePoolList",
            },
            node_pool_auto_config: {
                value: (0, index_structs_1.googleContainerClusterNodePoolAutoConfigToHclTerraform)(this._nodePoolAutoConfig.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterNodePoolAutoConfigList",
            },
            node_pool_defaults: {
                value: (0, index_structs_1.googleContainerClusterNodePoolDefaultsToHclTerraform)(this._nodePoolDefaults.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterNodePoolDefaultsList",
            },
            notification_config: {
                value: (0, index_structs_1.googleContainerClusterNotificationConfigToHclTerraform)(this._notificationConfig.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterNotificationConfigList",
            },
            pod_security_policy_config: {
                value: (0, index_structs_1.googleContainerClusterPodSecurityPolicyConfigToHclTerraform)(this._podSecurityPolicyConfig.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterPodSecurityPolicyConfigList",
            },
            private_cluster_config: {
                value: (0, index_structs_1.googleContainerClusterPrivateClusterConfigToHclTerraform)(this._privateClusterConfig.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterPrivateClusterConfigList",
            },
            protect_config: {
                value: (0, index_structs_1.googleContainerClusterProtectConfigToHclTerraform)(this._protectConfig.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterProtectConfigList",
            },
            release_channel: {
                value: (0, index_structs_1.googleContainerClusterReleaseChannelToHclTerraform)(this._releaseChannel.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterReleaseChannelList",
            },
            resource_usage_export_config: {
                value: (0, index_structs_1.googleContainerClusterResourceUsageExportConfigToHclTerraform)(this._resourceUsageExportConfig.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterResourceUsageExportConfigList",
            },
            security_posture_config: {
                value: (0, index_structs_1.googleContainerClusterSecurityPostureConfigToHclTerraform)(this._securityPostureConfig.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterSecurityPostureConfigList",
            },
            service_external_ips_config: {
                value: (0, index_structs_1.googleContainerClusterServiceExternalIpsConfigToHclTerraform)(this._serviceExternalIpsConfig.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterServiceExternalIpsConfigList",
            },
            timeouts: {
                value: (0, index_structs_1.googleContainerClusterTimeoutsToHclTerraform)(this._timeouts.internalValue),
                isBlock: true,
                type: "struct",
                storageClassType: "GoogleContainerClusterTimeouts",
            },
            tpu_config: {
                value: (0, index_structs_1.googleContainerClusterTpuConfigToHclTerraform)(this._tpuConfig.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterTpuConfigList",
            },
            vertical_pod_autoscaling: {
                value: (0, index_structs_1.googleContainerClusterVerticalPodAutoscalingToHclTerraform)(this._verticalPodAutoscaling.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterVerticalPodAutoscalingList",
            },
            workload_alts_config: {
                value: (0, index_structs_1.googleContainerClusterWorkloadAltsConfigToHclTerraform)(this._workloadAltsConfig.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterWorkloadAltsConfigList",
            },
            workload_identity_config: {
                value: (0, index_structs_1.googleContainerClusterWorkloadIdentityConfigToHclTerraform)(this._workloadIdentityConfig.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "GoogleContainerClusterWorkloadIdentityConfigList",
            },
        };
        // remove undefined attributes
        return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
    }
}
exports.GoogleContainerCluster = GoogleContainerCluster;
_a = JSII_RTTI_SYMBOL_1;
GoogleContainerCluster[_a] = { fqn: "@cdktf/provider-google-beta.googleContainerCluster.GoogleContainerCluster", version: "13.10.0" };
// =================
// STATIC PROPERTIES
// =================
GoogleContainerCluster.tfResourceType = "google_container_cluster";
//# sourceMappingURL=data:application/json;base64,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