/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDataCatalogPolicyTagConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description of this policy tag. It must: contain only unicode characters, tabs,
    * newlines, carriage returns and page breaks; and be at most 2000 bytes long when
    * encoded in UTF-8. If not set, defaults to an empty description.
    * If not set, defaults to an empty description.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_catalog_policy_tag#description GoogleDataCatalogPolicyTag#description}
    */
    readonly description?: string;
    /**
    * User defined name of this policy tag. It must: be unique within the parent
    * taxonomy; contain only unicode letters, numbers, underscores, dashes and spaces;
    * not start or end with spaces; and be at most 200 bytes long when encoded in UTF-8.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_catalog_policy_tag#display_name GoogleDataCatalogPolicyTag#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_catalog_policy_tag#id GoogleDataCatalogPolicyTag#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Resource name of this policy tag's parent policy tag.
    * If empty, it means this policy tag is a top level policy tag.
    * If not set, defaults to an empty string.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_catalog_policy_tag#parent_policy_tag GoogleDataCatalogPolicyTag#parent_policy_tag}
    */
    readonly parentPolicyTag?: string;
    /**
    * Taxonomy the policy tag is associated with
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_catalog_policy_tag#taxonomy GoogleDataCatalogPolicyTag#taxonomy}
    */
    readonly taxonomy: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_catalog_policy_tag#timeouts GoogleDataCatalogPolicyTag#timeouts}
    */
    readonly timeouts?: GoogleDataCatalogPolicyTagTimeouts;
}
export interface GoogleDataCatalogPolicyTagTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_catalog_policy_tag#create GoogleDataCatalogPolicyTag#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_catalog_policy_tag#delete GoogleDataCatalogPolicyTag#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_catalog_policy_tag#update GoogleDataCatalogPolicyTag#update}
    */
    readonly update?: string;
}
export declare function googleDataCatalogPolicyTagTimeoutsToTerraform(struct?: GoogleDataCatalogPolicyTagTimeouts | cdktf.IResolvable): any;
export declare function googleDataCatalogPolicyTagTimeoutsToHclTerraform(struct?: GoogleDataCatalogPolicyTagTimeouts | cdktf.IResolvable): any;
export declare class GoogleDataCatalogPolicyTagTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataCatalogPolicyTagTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataCatalogPolicyTagTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_catalog_policy_tag google_data_catalog_policy_tag}
*/
export declare class GoogleDataCatalogPolicyTag extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_data_catalog_policy_tag";
    /**
    * Generates CDKTF code for importing a GoogleDataCatalogPolicyTag resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleDataCatalogPolicyTag to import
    * @param importFromId The id of the existing GoogleDataCatalogPolicyTag that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_catalog_policy_tag#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleDataCatalogPolicyTag to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_catalog_policy_tag google_data_catalog_policy_tag} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDataCatalogPolicyTagConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDataCatalogPolicyTagConfig);
    get childPolicyTags(): string[];
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _parentPolicyTag?;
    get parentPolicyTag(): string;
    set parentPolicyTag(value: string);
    resetParentPolicyTag(): void;
    get parentPolicyTagInput(): string | undefined;
    private _taxonomy?;
    get taxonomy(): string;
    set taxonomy(value: string);
    get taxonomyInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleDataCatalogPolicyTagTimeoutsOutputReference;
    putTimeouts(value: GoogleDataCatalogPolicyTagTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDataCatalogPolicyTagTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
