/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { GoogleDataLossPreventionDeidentifyTemplateDeidentifyConfig, GoogleDataLossPreventionDeidentifyTemplateDeidentifyConfigOutputReference, GoogleDataLossPreventionDeidentifyTemplateTimeouts, GoogleDataLossPreventionDeidentifyTemplateTimeoutsOutputReference } from './index-structs';
export * from './index-structs';
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDataLossPreventionDeidentifyTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
    * A description of the template.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_deidentify_template#description GoogleDataLossPreventionDeidentifyTemplate#description}
    */
    readonly description?: string;
    /**
    * User set display name of the template.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_deidentify_template#display_name GoogleDataLossPreventionDeidentifyTemplate#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_deidentify_template#id GoogleDataLossPreventionDeidentifyTemplate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The parent of the template in any of the following formats:
    *
    * * 'projects/{{project}}'
    * * 'projects/{{project}}/locations/{{location}}'
    * * 'organizations/{{organization_id}}'
    * * 'organizations/{{organization_id}}/locations/{{location}}'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_deidentify_template#parent GoogleDataLossPreventionDeidentifyTemplate#parent}
    */
    readonly parent: string;
    /**
    * The template id can contain uppercase and lowercase letters, numbers, and hyphens;
    * that is, it must match the regular expression: [a-zA-Z\d-_]+. The maximum length is
    * 100 characters. Can be empty to allow the system to generate one.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_deidentify_template#template_id GoogleDataLossPreventionDeidentifyTemplate#template_id}
    */
    readonly templateId?: string;
    /**
    * deidentify_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_deidentify_template#deidentify_config GoogleDataLossPreventionDeidentifyTemplate#deidentify_config}
    */
    readonly deidentifyConfig: GoogleDataLossPreventionDeidentifyTemplateDeidentifyConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_deidentify_template#timeouts GoogleDataLossPreventionDeidentifyTemplate#timeouts}
    */
    readonly timeouts?: GoogleDataLossPreventionDeidentifyTemplateTimeouts;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_deidentify_template google_data_loss_prevention_deidentify_template}
*/
export declare class GoogleDataLossPreventionDeidentifyTemplate extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_data_loss_prevention_deidentify_template";
    /**
    * Generates CDKTF code for importing a GoogleDataLossPreventionDeidentifyTemplate resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleDataLossPreventionDeidentifyTemplate to import
    * @param importFromId The id of the existing GoogleDataLossPreventionDeidentifyTemplate that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_deidentify_template#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleDataLossPreventionDeidentifyTemplate to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_deidentify_template google_data_loss_prevention_deidentify_template} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDataLossPreventionDeidentifyTemplateConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDataLossPreventionDeidentifyTemplateConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _templateId?;
    get templateId(): string;
    set templateId(value: string);
    resetTemplateId(): void;
    get templateIdInput(): string | undefined;
    get updateTime(): string;
    private _deidentifyConfig;
    get deidentifyConfig(): GoogleDataLossPreventionDeidentifyTemplateDeidentifyConfigOutputReference;
    putDeidentifyConfig(value: GoogleDataLossPreventionDeidentifyTemplateDeidentifyConfig): void;
    get deidentifyConfigInput(): GoogleDataLossPreventionDeidentifyTemplateDeidentifyConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleDataLossPreventionDeidentifyTemplateTimeoutsOutputReference;
    putTimeouts(value: GoogleDataLossPreventionDeidentifyTemplateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDataLossPreventionDeidentifyTemplateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
