/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDataLossPreventionStoredInfoTypeConfig extends cdktf.TerraformMetaArguments {
    /**
    * A description of the info type.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type#description GoogleDataLossPreventionStoredInfoType#description}
    */
    readonly description?: string;
    /**
    * User set display name of the info type.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type#display_name GoogleDataLossPreventionStoredInfoType#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type#id GoogleDataLossPreventionStoredInfoType#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The parent of the info type in any of the following formats:
    *
    * * 'projects/{{project}}'
    * * 'projects/{{project}}/locations/{{location}}'
    * * 'organizations/{{organization_id}}'
    * * 'organizations/{{organization_id}}/locations/{{location}}'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type#parent GoogleDataLossPreventionStoredInfoType#parent}
    */
    readonly parent: string;
    /**
    * The storedInfoType ID can contain uppercase and lowercase letters, numbers, and hyphens;
    * that is, it must match the regular expression: [a-zA-Z\d-_]+. The maximum length is 100
    * characters. Can be empty to allow the system to generate one.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type#stored_info_type_id GoogleDataLossPreventionStoredInfoType#stored_info_type_id}
    */
    readonly storedInfoTypeId?: string;
    /**
    * dictionary block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type#dictionary GoogleDataLossPreventionStoredInfoType#dictionary}
    */
    readonly dictionary?: GoogleDataLossPreventionStoredInfoTypeDictionary;
    /**
    * large_custom_dictionary block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type#large_custom_dictionary GoogleDataLossPreventionStoredInfoType#large_custom_dictionary}
    */
    readonly largeCustomDictionary?: GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionary;
    /**
    * regex block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type#regex GoogleDataLossPreventionStoredInfoType#regex}
    */
    readonly regex?: GoogleDataLossPreventionStoredInfoTypeRegex;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type#timeouts GoogleDataLossPreventionStoredInfoType#timeouts}
    */
    readonly timeouts?: GoogleDataLossPreventionStoredInfoTypeTimeouts;
}
export interface GoogleDataLossPreventionStoredInfoTypeDictionaryCloudStoragePath {
    /**
    * A url representing a file or path (no wildcards) in Cloud Storage. Example: 'gs://[BUCKET_NAME]/dictionary.txt'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type#path GoogleDataLossPreventionStoredInfoType#path}
    */
    readonly path: string;
}
export declare function googleDataLossPreventionStoredInfoTypeDictionaryCloudStoragePathToTerraform(struct?: GoogleDataLossPreventionStoredInfoTypeDictionaryCloudStoragePathOutputReference | GoogleDataLossPreventionStoredInfoTypeDictionaryCloudStoragePath): any;
export declare function googleDataLossPreventionStoredInfoTypeDictionaryCloudStoragePathToHclTerraform(struct?: GoogleDataLossPreventionStoredInfoTypeDictionaryCloudStoragePathOutputReference | GoogleDataLossPreventionStoredInfoTypeDictionaryCloudStoragePath): any;
export declare class GoogleDataLossPreventionStoredInfoTypeDictionaryCloudStoragePathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataLossPreventionStoredInfoTypeDictionaryCloudStoragePath | undefined;
    set internalValue(value: GoogleDataLossPreventionStoredInfoTypeDictionaryCloudStoragePath | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
}
export interface GoogleDataLossPreventionStoredInfoTypeDictionaryWordListStruct {
    /**
    * Words or phrases defining the dictionary. The dictionary must contain at least one
    * phrase and every phrase must contain at least 2 characters that are letters or digits.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type#words GoogleDataLossPreventionStoredInfoType#words}
    */
    readonly words: string[];
}
export declare function googleDataLossPreventionStoredInfoTypeDictionaryWordListStructToTerraform(struct?: GoogleDataLossPreventionStoredInfoTypeDictionaryWordListStructOutputReference | GoogleDataLossPreventionStoredInfoTypeDictionaryWordListStruct): any;
export declare function googleDataLossPreventionStoredInfoTypeDictionaryWordListStructToHclTerraform(struct?: GoogleDataLossPreventionStoredInfoTypeDictionaryWordListStructOutputReference | GoogleDataLossPreventionStoredInfoTypeDictionaryWordListStruct): any;
export declare class GoogleDataLossPreventionStoredInfoTypeDictionaryWordListStructOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataLossPreventionStoredInfoTypeDictionaryWordListStruct | undefined;
    set internalValue(value: GoogleDataLossPreventionStoredInfoTypeDictionaryWordListStruct | undefined);
    private _words?;
    get words(): string[];
    set words(value: string[]);
    get wordsInput(): string[] | undefined;
}
export interface GoogleDataLossPreventionStoredInfoTypeDictionary {
    /**
    * cloud_storage_path block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type#cloud_storage_path GoogleDataLossPreventionStoredInfoType#cloud_storage_path}
    */
    readonly cloudStoragePath?: GoogleDataLossPreventionStoredInfoTypeDictionaryCloudStoragePath;
    /**
    * word_list block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type#word_list GoogleDataLossPreventionStoredInfoType#word_list}
    */
    readonly wordList?: GoogleDataLossPreventionStoredInfoTypeDictionaryWordListStruct;
}
export declare function googleDataLossPreventionStoredInfoTypeDictionaryToTerraform(struct?: GoogleDataLossPreventionStoredInfoTypeDictionaryOutputReference | GoogleDataLossPreventionStoredInfoTypeDictionary): any;
export declare function googleDataLossPreventionStoredInfoTypeDictionaryToHclTerraform(struct?: GoogleDataLossPreventionStoredInfoTypeDictionaryOutputReference | GoogleDataLossPreventionStoredInfoTypeDictionary): any;
export declare class GoogleDataLossPreventionStoredInfoTypeDictionaryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataLossPreventionStoredInfoTypeDictionary | undefined;
    set internalValue(value: GoogleDataLossPreventionStoredInfoTypeDictionary | undefined);
    private _cloudStoragePath;
    get cloudStoragePath(): GoogleDataLossPreventionStoredInfoTypeDictionaryCloudStoragePathOutputReference;
    putCloudStoragePath(value: GoogleDataLossPreventionStoredInfoTypeDictionaryCloudStoragePath): void;
    resetCloudStoragePath(): void;
    get cloudStoragePathInput(): GoogleDataLossPreventionStoredInfoTypeDictionaryCloudStoragePath | undefined;
    private _wordList;
    get wordList(): GoogleDataLossPreventionStoredInfoTypeDictionaryWordListStructOutputReference;
    putWordList(value: GoogleDataLossPreventionStoredInfoTypeDictionaryWordListStruct): void;
    resetWordList(): void;
    get wordListInput(): GoogleDataLossPreventionStoredInfoTypeDictionaryWordListStruct | undefined;
}
export interface GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldField {
    /**
    * Name describing the field.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type#name GoogleDataLossPreventionStoredInfoType#name}
    */
    readonly name: string;
}
export declare function googleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldFieldToTerraform(struct?: GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldFieldOutputReference | GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldField): any;
export declare function googleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldFieldToHclTerraform(struct?: GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldFieldOutputReference | GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldField): any;
export declare class GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldFieldOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldField | undefined;
    set internalValue(value: GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldField | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTable {
    /**
    * The dataset ID of the table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type#dataset_id GoogleDataLossPreventionStoredInfoType#dataset_id}
    */
    readonly datasetId: string;
    /**
    * The Google Cloud Platform project ID of the project containing the table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type#project_id GoogleDataLossPreventionStoredInfoType#project_id}
    */
    readonly projectId: string;
    /**
    * The name of the table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type#table_id GoogleDataLossPreventionStoredInfoType#table_id}
    */
    readonly tableId: string;
}
export declare function googleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTableToTerraform(struct?: GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTableOutputReference | GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTable): any;
export declare function googleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTableToHclTerraform(struct?: GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTableOutputReference | GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTable): any;
export declare class GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTable | undefined;
    set internalValue(value: GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTable | undefined);
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _tableId?;
    get tableId(): string;
    set tableId(value: string);
    get tableIdInput(): string | undefined;
}
export interface GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryField {
    /**
    * field block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type#field GoogleDataLossPreventionStoredInfoType#field}
    */
    readonly field: GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldField;
    /**
    * table block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type#table GoogleDataLossPreventionStoredInfoType#table}
    */
    readonly table: GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTable;
}
export declare function googleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldToTerraform(struct?: GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldOutputReference | GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryField): any;
export declare function googleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldToHclTerraform(struct?: GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldOutputReference | GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryField): any;
export declare class GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryField | undefined;
    set internalValue(value: GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryField | undefined);
    private _field;
    get field(): GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldFieldOutputReference;
    putField(value: GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldField): void;
    get fieldInput(): GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldField | undefined;
    private _table;
    get table(): GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTableOutputReference;
    putTable(value: GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTable): void;
    get tableInput(): GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTable | undefined;
}
export interface GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSet {
    /**
    * The url, in the format 'gs://<bucket>/<path>'. Trailing wildcard in the path is allowed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type#url GoogleDataLossPreventionStoredInfoType#url}
    */
    readonly url: string;
}
export declare function googleDataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSetToTerraform(struct?: GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSetOutputReference | GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSet): any;
export declare function googleDataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSetToHclTerraform(struct?: GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSetOutputReference | GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSet): any;
export declare class GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSet | undefined;
    set internalValue(value: GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSet | undefined);
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export interface GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPath {
    /**
    * A url representing a file or path (no wildcards) in Cloud Storage. Example: 'gs://[BUCKET_NAME]/dictionary.txt'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type#path GoogleDataLossPreventionStoredInfoType#path}
    */
    readonly path: string;
}
export declare function googleDataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPathToTerraform(struct?: GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPathOutputReference | GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPath): any;
export declare function googleDataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPathToHclTerraform(struct?: GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPathOutputReference | GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPath): any;
export declare class GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPath | undefined;
    set internalValue(value: GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPath | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
}
export interface GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionary {
    /**
    * big_query_field block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type#big_query_field GoogleDataLossPreventionStoredInfoType#big_query_field}
    */
    readonly bigQueryField?: GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryField;
    /**
    * cloud_storage_file_set block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type#cloud_storage_file_set GoogleDataLossPreventionStoredInfoType#cloud_storage_file_set}
    */
    readonly cloudStorageFileSet?: GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSet;
    /**
    * output_path block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type#output_path GoogleDataLossPreventionStoredInfoType#output_path}
    */
    readonly outputPath: GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPath;
}
export declare function googleDataLossPreventionStoredInfoTypeLargeCustomDictionaryToTerraform(struct?: GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputReference | GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionary): any;
export declare function googleDataLossPreventionStoredInfoTypeLargeCustomDictionaryToHclTerraform(struct?: GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputReference | GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionary): any;
export declare class GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionary | undefined;
    set internalValue(value: GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionary | undefined);
    private _bigQueryField;
    get bigQueryField(): GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldOutputReference;
    putBigQueryField(value: GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryField): void;
    resetBigQueryField(): void;
    get bigQueryFieldInput(): GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryField | undefined;
    private _cloudStorageFileSet;
    get cloudStorageFileSet(): GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSetOutputReference;
    putCloudStorageFileSet(value: GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSet): void;
    resetCloudStorageFileSet(): void;
    get cloudStorageFileSetInput(): GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSet | undefined;
    private _outputPath;
    get outputPath(): GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPathOutputReference;
    putOutputPath(value: GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPath): void;
    get outputPathInput(): GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPath | undefined;
}
export interface GoogleDataLossPreventionStoredInfoTypeRegex {
    /**
    * The index of the submatch to extract as findings. When not specified, the entire match is returned. No more than 3 may be included.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type#group_indexes GoogleDataLossPreventionStoredInfoType#group_indexes}
    */
    readonly groupIndexes?: number[];
    /**
    * Pattern defining the regular expression.
    * Its syntax (https://github.com/google/re2/wiki/Syntax) can be found under the google/re2 repository on GitHub.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type#pattern GoogleDataLossPreventionStoredInfoType#pattern}
    */
    readonly pattern: string;
}
export declare function googleDataLossPreventionStoredInfoTypeRegexToTerraform(struct?: GoogleDataLossPreventionStoredInfoTypeRegexOutputReference | GoogleDataLossPreventionStoredInfoTypeRegex): any;
export declare function googleDataLossPreventionStoredInfoTypeRegexToHclTerraform(struct?: GoogleDataLossPreventionStoredInfoTypeRegexOutputReference | GoogleDataLossPreventionStoredInfoTypeRegex): any;
export declare class GoogleDataLossPreventionStoredInfoTypeRegexOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataLossPreventionStoredInfoTypeRegex | undefined;
    set internalValue(value: GoogleDataLossPreventionStoredInfoTypeRegex | undefined);
    private _groupIndexes?;
    get groupIndexes(): number[];
    set groupIndexes(value: number[]);
    resetGroupIndexes(): void;
    get groupIndexesInput(): number[] | undefined;
    private _pattern?;
    get pattern(): string;
    set pattern(value: string);
    get patternInput(): string | undefined;
}
export interface GoogleDataLossPreventionStoredInfoTypeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type#create GoogleDataLossPreventionStoredInfoType#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type#delete GoogleDataLossPreventionStoredInfoType#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type#update GoogleDataLossPreventionStoredInfoType#update}
    */
    readonly update?: string;
}
export declare function googleDataLossPreventionStoredInfoTypeTimeoutsToTerraform(struct?: GoogleDataLossPreventionStoredInfoTypeTimeouts | cdktf.IResolvable): any;
export declare function googleDataLossPreventionStoredInfoTypeTimeoutsToHclTerraform(struct?: GoogleDataLossPreventionStoredInfoTypeTimeouts | cdktf.IResolvable): any;
export declare class GoogleDataLossPreventionStoredInfoTypeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataLossPreventionStoredInfoTypeTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataLossPreventionStoredInfoTypeTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type google_data_loss_prevention_stored_info_type}
*/
export declare class GoogleDataLossPreventionStoredInfoType extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_data_loss_prevention_stored_info_type";
    /**
    * Generates CDKTF code for importing a GoogleDataLossPreventionStoredInfoType resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleDataLossPreventionStoredInfoType to import
    * @param importFromId The id of the existing GoogleDataLossPreventionStoredInfoType that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleDataLossPreventionStoredInfoType to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_loss_prevention_stored_info_type google_data_loss_prevention_stored_info_type} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDataLossPreventionStoredInfoTypeConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDataLossPreventionStoredInfoTypeConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _storedInfoTypeId?;
    get storedInfoTypeId(): string;
    set storedInfoTypeId(value: string);
    resetStoredInfoTypeId(): void;
    get storedInfoTypeIdInput(): string | undefined;
    private _dictionary;
    get dictionary(): GoogleDataLossPreventionStoredInfoTypeDictionaryOutputReference;
    putDictionary(value: GoogleDataLossPreventionStoredInfoTypeDictionary): void;
    resetDictionary(): void;
    get dictionaryInput(): GoogleDataLossPreventionStoredInfoTypeDictionary | undefined;
    private _largeCustomDictionary;
    get largeCustomDictionary(): GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputReference;
    putLargeCustomDictionary(value: GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionary): void;
    resetLargeCustomDictionary(): void;
    get largeCustomDictionaryInput(): GoogleDataLossPreventionStoredInfoTypeLargeCustomDictionary | undefined;
    private _regex;
    get regex(): GoogleDataLossPreventionStoredInfoTypeRegexOutputReference;
    putRegex(value: GoogleDataLossPreventionStoredInfoTypeRegex): void;
    resetRegex(): void;
    get regexInput(): GoogleDataLossPreventionStoredInfoTypeRegex | undefined;
    private _timeouts;
    get timeouts(): GoogleDataLossPreventionStoredInfoTypeTimeoutsOutputReference;
    putTimeouts(value: GoogleDataLossPreventionStoredInfoTypeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDataLossPreventionStoredInfoTypeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
