/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDataPipelinePipelineConfig extends cdktf.TerraformMetaArguments {
    /**
    * The display name of the pipeline. It can contain only letters ([A-Za-z]), numbers ([0-9]), hyphens (-), and underscores (_).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#display_name GoogleDataPipelinePipeline#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#id GoogleDataPipelinePipeline#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * "The pipeline name. For example': 'projects/PROJECT_ID/locations/LOCATION_ID/pipelines/PIPELINE_ID."
    * "- PROJECT_ID can contain letters ([A-Za-z]), numbers ([0-9]), hyphens (-), colons (:), and periods (.). For more information, see Identifying projects."
    * "LOCATION_ID is the canonical ID for the pipeline's location. The list of available locations can be obtained by calling google.cloud.location.Locations.ListLocations. Note that the Data Pipelines service is not available in all regions. It depends on Cloud Scheduler, an App Engine application, so it's only available in App Engine regions."
    * "PIPELINE_ID is the ID of the pipeline. Must be unique for the selected project and location."
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#name GoogleDataPipelinePipeline#name}
    */
    readonly name: string;
    /**
    * The sources of the pipeline (for example, Dataplex). The keys and values are set by the corresponding sources during pipeline creation.
    * An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#pipeline_sources GoogleDataPipelinePipeline#pipeline_sources}
    */
    readonly pipelineSources?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#project GoogleDataPipelinePipeline#project}
    */
    readonly project?: string;
    /**
    * A reference to the region
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#region GoogleDataPipelinePipeline#region}
    */
    readonly region?: string;
    /**
    * Optional. A service account email to be used with the Cloud Scheduler job. If not specified, the default compute engine service account will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#scheduler_service_account_email GoogleDataPipelinePipeline#scheduler_service_account_email}
    */
    readonly schedulerServiceAccountEmail?: string;
    /**
    * The state of the pipeline. When the pipeline is created, the state is set to 'PIPELINE_STATE_ACTIVE' by default. State changes can be requested by setting the state to stopping, paused, or resuming. State cannot be changed through pipelines.patch requests.
    * https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#state Possible values: ["STATE_UNSPECIFIED", "STATE_RESUMING", "STATE_ACTIVE", "STATE_STOPPING", "STATE_ARCHIVED", "STATE_PAUSED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#state GoogleDataPipelinePipeline#state}
    */
    readonly state: string;
    /**
    * The type of the pipeline. This field affects the scheduling of the pipeline and the type of metrics to show for the pipeline.
    * https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#pipelinetype Possible values: ["PIPELINE_TYPE_UNSPECIFIED", "PIPELINE_TYPE_BATCH", "PIPELINE_TYPE_STREAMING"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#type GoogleDataPipelinePipeline#type}
    */
    readonly type: string;
    /**
    * schedule_info block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#schedule_info GoogleDataPipelinePipeline#schedule_info}
    */
    readonly scheduleInfo?: GoogleDataPipelinePipelineScheduleInfo;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#timeouts GoogleDataPipelinePipeline#timeouts}
    */
    readonly timeouts?: GoogleDataPipelinePipelineTimeouts;
    /**
    * workload block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#workload GoogleDataPipelinePipeline#workload}
    */
    readonly workload?: GoogleDataPipelinePipelineWorkload;
}
export interface GoogleDataPipelinePipelineScheduleInfo {
    /**
    * Unix-cron format of the schedule. This information is retrieved from the linked Cloud Scheduler.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#schedule GoogleDataPipelinePipeline#schedule}
    */
    readonly schedule?: string;
    /**
    * Timezone ID. This matches the timezone IDs used by the Cloud Scheduler API. If empty, UTC time is assumed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#time_zone GoogleDataPipelinePipeline#time_zone}
    */
    readonly timeZone?: string;
}
export declare function googleDataPipelinePipelineScheduleInfoToTerraform(struct?: GoogleDataPipelinePipelineScheduleInfoOutputReference | GoogleDataPipelinePipelineScheduleInfo): any;
export declare function googleDataPipelinePipelineScheduleInfoToHclTerraform(struct?: GoogleDataPipelinePipelineScheduleInfoOutputReference | GoogleDataPipelinePipelineScheduleInfo): any;
export declare class GoogleDataPipelinePipelineScheduleInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataPipelinePipelineScheduleInfo | undefined;
    set internalValue(value: GoogleDataPipelinePipelineScheduleInfo | undefined);
    get nextJobTime(): string;
    private _schedule?;
    get schedule(): string;
    set schedule(value: string);
    resetSchedule(): void;
    get scheduleInput(): string | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    resetTimeZone(): void;
    get timeZoneInput(): string | undefined;
}
export interface GoogleDataPipelinePipelineTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#create GoogleDataPipelinePipeline#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#delete GoogleDataPipelinePipeline#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#update GoogleDataPipelinePipeline#update}
    */
    readonly update?: string;
}
export declare function googleDataPipelinePipelineTimeoutsToTerraform(struct?: GoogleDataPipelinePipelineTimeouts | cdktf.IResolvable): any;
export declare function googleDataPipelinePipelineTimeoutsToHclTerraform(struct?: GoogleDataPipelinePipelineTimeouts | cdktf.IResolvable): any;
export declare class GoogleDataPipelinePipelineTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataPipelinePipelineTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataPipelinePipelineTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironment {
    /**
    * Additional experiment flags for the job.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#additional_experiments GoogleDataPipelinePipeline#additional_experiments}
    */
    readonly additionalExperiments?: string[];
    /**
    * Additional user labels to be specified for the job. Keys and values should follow the restrictions specified in the labeling restrictions page. An object containing a list of key/value pairs.
    * 'Example: { "name": "wrench", "mass": "1kg", "count": "3" }.'
    * 'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#additional_user_labels GoogleDataPipelinePipeline#additional_user_labels}
    */
    readonly additionalUserLabels?: {
        [key: string]: string;
    };
    /**
    * Whether to enable Streaming Engine for the job.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#enable_streaming_engine GoogleDataPipelinePipeline#enable_streaming_engine}
    */
    readonly enableStreamingEngine?: boolean | cdktf.IResolvable;
    /**
    * Set FlexRS goal for the job. https://cloud.google.com/dataflow/docs/guides/flexrs
    * https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#FlexResourceSchedulingGoal Possible values: ["FLEXRS_UNSPECIFIED", "FLEXRS_SPEED_OPTIMIZED", "FLEXRS_COST_OPTIMIZED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#flexrs_goal GoogleDataPipelinePipeline#flexrs_goal}
    */
    readonly flexrsGoal?: string;
    /**
    * Configuration for VM IPs.
    * https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#WorkerIPAddressConfiguration Possible values: ["WORKER_IP_UNSPECIFIED", "WORKER_IP_PUBLIC", "WORKER_IP_PRIVATE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#ip_configuration GoogleDataPipelinePipeline#ip_configuration}
    */
    readonly ipConfiguration?: string;
    /**
    * 'Name for the Cloud KMS key for the job. The key format is: projects//locations//keyRings//cryptoKeys/'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#kms_key_name GoogleDataPipelinePipeline#kms_key_name}
    */
    readonly kmsKeyName?: string;
    /**
    * The machine type to use for the job. Defaults to the value from the template if not specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#machine_type GoogleDataPipelinePipeline#machine_type}
    */
    readonly machineType?: string;
    /**
    * The maximum number of Compute Engine instances to be made available to your pipeline during execution, from 1 to 1000.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#max_workers GoogleDataPipelinePipeline#max_workers}
    */
    readonly maxWorkers?: number;
    /**
    * Network to which VMs will be assigned. If empty or unspecified, the service will use the network "default".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#network GoogleDataPipelinePipeline#network}
    */
    readonly network?: string;
    /**
    * The initial number of Compute Engine instances for the job.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#num_workers GoogleDataPipelinePipeline#num_workers}
    */
    readonly numWorkers?: number;
    /**
    * The email address of the service account to run the job as.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#service_account_email GoogleDataPipelinePipeline#service_account_email}
    */
    readonly serviceAccountEmail?: string;
    /**
    * Subnetwork to which VMs will be assigned, if desired. You can specify a subnetwork using either a complete URL or an abbreviated path. Expected to be of the form "https://www.googleapis.com/compute/v1/projects/HOST_PROJECT_ID/regions/REGION/subnetworks/SUBNETWORK" or "regions/REGION/subnetworks/SUBNETWORK". If the subnetwork is located in a Shared VPC network, you must use the complete URL.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#subnetwork GoogleDataPipelinePipeline#subnetwork}
    */
    readonly subnetwork?: string;
    /**
    * The Cloud Storage path to use for temporary files. Must be a valid Cloud Storage URL, beginning with gs://.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#temp_location GoogleDataPipelinePipeline#temp_location}
    */
    readonly tempLocation?: string;
    /**
    * The Compute Engine region (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1". Mutually exclusive with workerZone. If neither workerRegion nor workerZone is specified, default to the control plane's region.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#worker_region GoogleDataPipelinePipeline#worker_region}
    */
    readonly workerRegion?: string;
    /**
    * The Compute Engine zone (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1-a". Mutually exclusive with workerRegion. If neither workerRegion nor workerZone is specified, a zone in the control plane's region is chosen based on available capacity. If both workerZone and zone are set, workerZone takes precedence.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#worker_zone GoogleDataPipelinePipeline#worker_zone}
    */
    readonly workerZone?: string;
    /**
    * The Compute Engine availability zone for launching worker instances to run your pipeline. In the future, workerZone will take precedence.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#zone GoogleDataPipelinePipeline#zone}
    */
    readonly zone?: string;
}
export declare function googleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironmentToTerraform(struct?: GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironmentOutputReference | GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironment): any;
export declare function googleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironmentToHclTerraform(struct?: GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironmentOutputReference | GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironment): any;
export declare class GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironment | undefined;
    set internalValue(value: GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironment | undefined);
    private _additionalExperiments?;
    get additionalExperiments(): string[];
    set additionalExperiments(value: string[]);
    resetAdditionalExperiments(): void;
    get additionalExperimentsInput(): string[] | undefined;
    private _additionalUserLabels?;
    get additionalUserLabels(): {
        [key: string]: string;
    };
    set additionalUserLabels(value: {
        [key: string]: string;
    });
    resetAdditionalUserLabels(): void;
    get additionalUserLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _enableStreamingEngine?;
    get enableStreamingEngine(): boolean | cdktf.IResolvable;
    set enableStreamingEngine(value: boolean | cdktf.IResolvable);
    resetEnableStreamingEngine(): void;
    get enableStreamingEngineInput(): boolean | cdktf.IResolvable | undefined;
    private _flexrsGoal?;
    get flexrsGoal(): string;
    set flexrsGoal(value: string);
    resetFlexrsGoal(): void;
    get flexrsGoalInput(): string | undefined;
    private _ipConfiguration?;
    get ipConfiguration(): string;
    set ipConfiguration(value: string);
    resetIpConfiguration(): void;
    get ipConfigurationInput(): string | undefined;
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _maxWorkers?;
    get maxWorkers(): number;
    set maxWorkers(value: number);
    resetMaxWorkers(): void;
    get maxWorkersInput(): number | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _numWorkers?;
    get numWorkers(): number;
    set numWorkers(value: number);
    resetNumWorkers(): void;
    get numWorkersInput(): number | undefined;
    private _serviceAccountEmail?;
    get serviceAccountEmail(): string;
    set serviceAccountEmail(value: string);
    resetServiceAccountEmail(): void;
    get serviceAccountEmailInput(): string | undefined;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    private _tempLocation?;
    get tempLocation(): string;
    set tempLocation(value: string);
    resetTempLocation(): void;
    get tempLocationInput(): string | undefined;
    private _workerRegion?;
    get workerRegion(): string;
    set workerRegion(value: string);
    resetWorkerRegion(): void;
    get workerRegionInput(): string | undefined;
    private _workerZone?;
    get workerZone(): string;
    set workerZone(value: string);
    resetWorkerZone(): void;
    get workerZoneInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
}
export interface GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestLaunchParameter {
    /**
    * Cloud Storage path to a file with a JSON-serialized ContainerSpec as content.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#container_spec_gcs_path GoogleDataPipelinePipeline#container_spec_gcs_path}
    */
    readonly containerSpecGcsPath?: string;
    /**
    * The job name to use for the created job. For an update job request, the job name should be the same as the existing running job.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#job_name GoogleDataPipelinePipeline#job_name}
    */
    readonly jobName: string;
    /**
    * Launch options for this Flex Template job. This is a common set of options across languages and templates. This should not be used to pass job parameters.
    * 'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#launch_options GoogleDataPipelinePipeline#launch_options}
    */
    readonly launchOptions?: {
        [key: string]: string;
    };
    /**
    * 'The parameters for the Flex Template. Example: {"numWorkers":"5"}'
    * 'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#parameters GoogleDataPipelinePipeline#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * 'Use this to pass transform name mappings for streaming update jobs. Example: {"oldTransformName":"newTransformName",...}'
    * 'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#transform_name_mappings GoogleDataPipelinePipeline#transform_name_mappings}
    */
    readonly transformNameMappings?: {
        [key: string]: string;
    };
    /**
    * Set this to true if you are sending a request to update a running streaming job. When set, the job name should be the same as the running job.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#update GoogleDataPipelinePipeline#update}
    */
    readonly update?: boolean | cdktf.IResolvable;
    /**
    * environment block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#environment GoogleDataPipelinePipeline#environment}
    */
    readonly environment?: GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironment;
}
export declare function googleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestLaunchParameterToTerraform(struct?: GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestLaunchParameterOutputReference | GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestLaunchParameter): any;
export declare function googleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestLaunchParameterToHclTerraform(struct?: GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestLaunchParameterOutputReference | GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestLaunchParameter): any;
export declare class GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestLaunchParameterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestLaunchParameter | undefined;
    set internalValue(value: GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestLaunchParameter | undefined);
    private _containerSpecGcsPath?;
    get containerSpecGcsPath(): string;
    set containerSpecGcsPath(value: string);
    resetContainerSpecGcsPath(): void;
    get containerSpecGcsPathInput(): string | undefined;
    private _jobName?;
    get jobName(): string;
    set jobName(value: string);
    get jobNameInput(): string | undefined;
    private _launchOptions?;
    get launchOptions(): {
        [key: string]: string;
    };
    set launchOptions(value: {
        [key: string]: string;
    });
    resetLaunchOptions(): void;
    get launchOptionsInput(): {
        [key: string]: string;
    } | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _transformNameMappings?;
    get transformNameMappings(): {
        [key: string]: string;
    };
    set transformNameMappings(value: {
        [key: string]: string;
    });
    resetTransformNameMappings(): void;
    get transformNameMappingsInput(): {
        [key: string]: string;
    } | undefined;
    private _update?;
    get update(): boolean | cdktf.IResolvable;
    set update(value: boolean | cdktf.IResolvable);
    resetUpdate(): void;
    get updateInput(): boolean | cdktf.IResolvable | undefined;
    private _environment;
    get environment(): GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironmentOutputReference;
    putEnvironment(value: GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironment): void;
    resetEnvironment(): void;
    get environmentInput(): GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironment | undefined;
}
export interface GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequest {
    /**
    * The regional endpoint to which to direct the request. For example, us-central1, us-west1.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#location GoogleDataPipelinePipeline#location}
    */
    readonly location: string;
    /**
    * The ID of the Cloud Platform project that the job belongs to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#project_id GoogleDataPipelinePipeline#project_id}
    */
    readonly projectId: string;
    /**
    * If true, the request is validated but not actually executed. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#validate_only GoogleDataPipelinePipeline#validate_only}
    */
    readonly validateOnly?: boolean | cdktf.IResolvable;
    /**
    * launch_parameter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#launch_parameter GoogleDataPipelinePipeline#launch_parameter}
    */
    readonly launchParameter: GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestLaunchParameter;
}
export declare function googleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestToTerraform(struct?: GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestOutputReference | GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequest): any;
export declare function googleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestToHclTerraform(struct?: GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestOutputReference | GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequest): any;
export declare class GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequest | undefined;
    set internalValue(value: GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequest | undefined);
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _validateOnly?;
    get validateOnly(): boolean | cdktf.IResolvable;
    set validateOnly(value: boolean | cdktf.IResolvable);
    resetValidateOnly(): void;
    get validateOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _launchParameter;
    get launchParameter(): GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestLaunchParameterOutputReference;
    putLaunchParameter(value: GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestLaunchParameter): void;
    get launchParameterInput(): GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestLaunchParameter | undefined;
}
export interface GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironment {
    /**
    * Additional experiment flags for the job.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#additional_experiments GoogleDataPipelinePipeline#additional_experiments}
    */
    readonly additionalExperiments?: string[];
    /**
    * Additional user labels to be specified for the job. Keys and values should follow the restrictions specified in the labeling restrictions page. An object containing a list of key/value pairs.
    * 'Example: { "name": "wrench", "mass": "1kg", "count": "3" }.'
    * 'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#additional_user_labels GoogleDataPipelinePipeline#additional_user_labels}
    */
    readonly additionalUserLabels?: {
        [key: string]: string;
    };
    /**
    * Whether to bypass the safety checks for the job's temporary directory. Use with caution.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#bypass_temp_dir_validation GoogleDataPipelinePipeline#bypass_temp_dir_validation}
    */
    readonly bypassTempDirValidation?: boolean | cdktf.IResolvable;
    /**
    * Whether to enable Streaming Engine for the job.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#enable_streaming_engine GoogleDataPipelinePipeline#enable_streaming_engine}
    */
    readonly enableStreamingEngine?: boolean | cdktf.IResolvable;
    /**
    * Configuration for VM IPs.
    * https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#WorkerIPAddressConfiguration Possible values: ["WORKER_IP_UNSPECIFIED", "WORKER_IP_PUBLIC", "WORKER_IP_PRIVATE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#ip_configuration GoogleDataPipelinePipeline#ip_configuration}
    */
    readonly ipConfiguration?: string;
    /**
    * 'Name for the Cloud KMS key for the job. The key format is: projects//locations//keyRings//cryptoKeys/'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#kms_key_name GoogleDataPipelinePipeline#kms_key_name}
    */
    readonly kmsKeyName?: string;
    /**
    * The machine type to use for the job. Defaults to the value from the template if not specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#machine_type GoogleDataPipelinePipeline#machine_type}
    */
    readonly machineType?: string;
    /**
    * The maximum number of Compute Engine instances to be made available to your pipeline during execution, from 1 to 1000.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#max_workers GoogleDataPipelinePipeline#max_workers}
    */
    readonly maxWorkers?: number;
    /**
    * Network to which VMs will be assigned. If empty or unspecified, the service will use the network "default".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#network GoogleDataPipelinePipeline#network}
    */
    readonly network?: string;
    /**
    * The initial number of Compute Engine instances for the job.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#num_workers GoogleDataPipelinePipeline#num_workers}
    */
    readonly numWorkers?: number;
    /**
    * The email address of the service account to run the job as.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#service_account_email GoogleDataPipelinePipeline#service_account_email}
    */
    readonly serviceAccountEmail?: string;
    /**
    * Subnetwork to which VMs will be assigned, if desired. You can specify a subnetwork using either a complete URL or an abbreviated path. Expected to be of the form "https://www.googleapis.com/compute/v1/projects/HOST_PROJECT_ID/regions/REGION/subnetworks/SUBNETWORK" or "regions/REGION/subnetworks/SUBNETWORK". If the subnetwork is located in a Shared VPC network, you must use the complete URL.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#subnetwork GoogleDataPipelinePipeline#subnetwork}
    */
    readonly subnetwork?: string;
    /**
    * The Cloud Storage path to use for temporary files. Must be a valid Cloud Storage URL, beginning with gs://.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#temp_location GoogleDataPipelinePipeline#temp_location}
    */
    readonly tempLocation?: string;
    /**
    * The Compute Engine region (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1". Mutually exclusive with workerZone. If neither workerRegion nor workerZone is specified, default to the control plane's region.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#worker_region GoogleDataPipelinePipeline#worker_region}
    */
    readonly workerRegion?: string;
    /**
    * The Compute Engine zone (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1-a". Mutually exclusive with workerRegion. If neither workerRegion nor workerZone is specified, a zone in the control plane's region is chosen based on available capacity. If both workerZone and zone are set, workerZone takes precedence.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#worker_zone GoogleDataPipelinePipeline#worker_zone}
    */
    readonly workerZone?: string;
    /**
    * The Compute Engine availability zone for launching worker instances to run your pipeline. In the future, workerZone will take precedence.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#zone GoogleDataPipelinePipeline#zone}
    */
    readonly zone?: string;
}
export declare function googleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironmentToTerraform(struct?: GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironmentOutputReference | GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironment): any;
export declare function googleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironmentToHclTerraform(struct?: GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironmentOutputReference | GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironment): any;
export declare class GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironment | undefined;
    set internalValue(value: GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironment | undefined);
    private _additionalExperiments?;
    get additionalExperiments(): string[];
    set additionalExperiments(value: string[]);
    resetAdditionalExperiments(): void;
    get additionalExperimentsInput(): string[] | undefined;
    private _additionalUserLabels?;
    get additionalUserLabels(): {
        [key: string]: string;
    };
    set additionalUserLabels(value: {
        [key: string]: string;
    });
    resetAdditionalUserLabels(): void;
    get additionalUserLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _bypassTempDirValidation?;
    get bypassTempDirValidation(): boolean | cdktf.IResolvable;
    set bypassTempDirValidation(value: boolean | cdktf.IResolvable);
    resetBypassTempDirValidation(): void;
    get bypassTempDirValidationInput(): boolean | cdktf.IResolvable | undefined;
    private _enableStreamingEngine?;
    get enableStreamingEngine(): boolean | cdktf.IResolvable;
    set enableStreamingEngine(value: boolean | cdktf.IResolvable);
    resetEnableStreamingEngine(): void;
    get enableStreamingEngineInput(): boolean | cdktf.IResolvable | undefined;
    private _ipConfiguration?;
    get ipConfiguration(): string;
    set ipConfiguration(value: string);
    resetIpConfiguration(): void;
    get ipConfigurationInput(): string | undefined;
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _maxWorkers?;
    get maxWorkers(): number;
    set maxWorkers(value: number);
    resetMaxWorkers(): void;
    get maxWorkersInput(): number | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _numWorkers?;
    get numWorkers(): number;
    set numWorkers(value: number);
    resetNumWorkers(): void;
    get numWorkersInput(): number | undefined;
    private _serviceAccountEmail?;
    get serviceAccountEmail(): string;
    set serviceAccountEmail(value: string);
    resetServiceAccountEmail(): void;
    get serviceAccountEmailInput(): string | undefined;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    private _tempLocation?;
    get tempLocation(): string;
    set tempLocation(value: string);
    resetTempLocation(): void;
    get tempLocationInput(): string | undefined;
    private _workerRegion?;
    get workerRegion(): string;
    set workerRegion(value: string);
    resetWorkerRegion(): void;
    get workerRegionInput(): string | undefined;
    private _workerZone?;
    get workerZone(): string;
    set workerZone(value: string);
    resetWorkerZone(): void;
    get workerZoneInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
}
export interface GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestLaunchParameters {
    /**
    * The job name to use for the created job.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#job_name GoogleDataPipelinePipeline#job_name}
    */
    readonly jobName: string;
    /**
    * The runtime parameters to pass to the job.
    * 'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#parameters GoogleDataPipelinePipeline#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * Map of transform name prefixes of the job to be replaced to the corresponding name prefixes of the new job. Only applicable when updating a pipeline.
    * 'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#transform_name_mapping GoogleDataPipelinePipeline#transform_name_mapping}
    */
    readonly transformNameMapping?: {
        [key: string]: string;
    };
    /**
    * If set, replace the existing pipeline with the name specified by jobName with this pipeline, preserving state.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#update GoogleDataPipelinePipeline#update}
    */
    readonly update?: boolean | cdktf.IResolvable;
    /**
    * environment block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#environment GoogleDataPipelinePipeline#environment}
    */
    readonly environment?: GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironment;
}
export declare function googleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersToTerraform(struct?: GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersOutputReference | GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestLaunchParameters): any;
export declare function googleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersToHclTerraform(struct?: GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersOutputReference | GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestLaunchParameters): any;
export declare class GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestLaunchParameters | undefined;
    set internalValue(value: GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestLaunchParameters | undefined);
    private _jobName?;
    get jobName(): string;
    set jobName(value: string);
    get jobNameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _transformNameMapping?;
    get transformNameMapping(): {
        [key: string]: string;
    };
    set transformNameMapping(value: {
        [key: string]: string;
    });
    resetTransformNameMapping(): void;
    get transformNameMappingInput(): {
        [key: string]: string;
    } | undefined;
    private _update?;
    get update(): boolean | cdktf.IResolvable;
    set update(value: boolean | cdktf.IResolvable);
    resetUpdate(): void;
    get updateInput(): boolean | cdktf.IResolvable | undefined;
    private _environment;
    get environment(): GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironmentOutputReference;
    putEnvironment(value: GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironment): void;
    resetEnvironment(): void;
    get environmentInput(): GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironment | undefined;
}
export interface GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequest {
    /**
    * A Cloud Storage path to the template from which to create the job. Must be a valid Cloud Storage URL, beginning with 'gs://'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#gcs_path GoogleDataPipelinePipeline#gcs_path}
    */
    readonly gcsPath?: string;
    /**
    * The regional endpoint to which to direct the request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#location GoogleDataPipelinePipeline#location}
    */
    readonly location?: string;
    /**
    * The ID of the Cloud Platform project that the job belongs to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#project_id GoogleDataPipelinePipeline#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#validate_only GoogleDataPipelinePipeline#validate_only}
    */
    readonly validateOnly?: boolean | cdktf.IResolvable;
    /**
    * launch_parameters block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#launch_parameters GoogleDataPipelinePipeline#launch_parameters}
    */
    readonly launchParameters?: GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestLaunchParameters;
}
export declare function googleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestToTerraform(struct?: GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestOutputReference | GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequest): any;
export declare function googleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestToHclTerraform(struct?: GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestOutputReference | GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequest): any;
export declare class GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequest | undefined;
    set internalValue(value: GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequest | undefined);
    private _gcsPath?;
    get gcsPath(): string;
    set gcsPath(value: string);
    resetGcsPath(): void;
    get gcsPathInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _validateOnly?;
    get validateOnly(): boolean | cdktf.IResolvable;
    set validateOnly(value: boolean | cdktf.IResolvable);
    resetValidateOnly(): void;
    get validateOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _launchParameters;
    get launchParameters(): GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersOutputReference;
    putLaunchParameters(value: GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestLaunchParameters): void;
    resetLaunchParameters(): void;
    get launchParametersInput(): GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestLaunchParameters | undefined;
}
export interface GoogleDataPipelinePipelineWorkload {
    /**
    * dataflow_flex_template_request block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#dataflow_flex_template_request GoogleDataPipelinePipeline#dataflow_flex_template_request}
    */
    readonly dataflowFlexTemplateRequest?: GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequest;
    /**
    * dataflow_launch_template_request block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#dataflow_launch_template_request GoogleDataPipelinePipeline#dataflow_launch_template_request}
    */
    readonly dataflowLaunchTemplateRequest?: GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequest;
}
export declare function googleDataPipelinePipelineWorkloadToTerraform(struct?: GoogleDataPipelinePipelineWorkloadOutputReference | GoogleDataPipelinePipelineWorkload): any;
export declare function googleDataPipelinePipelineWorkloadToHclTerraform(struct?: GoogleDataPipelinePipelineWorkloadOutputReference | GoogleDataPipelinePipelineWorkload): any;
export declare class GoogleDataPipelinePipelineWorkloadOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataPipelinePipelineWorkload | undefined;
    set internalValue(value: GoogleDataPipelinePipelineWorkload | undefined);
    private _dataflowFlexTemplateRequest;
    get dataflowFlexTemplateRequest(): GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequestOutputReference;
    putDataflowFlexTemplateRequest(value: GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequest): void;
    resetDataflowFlexTemplateRequest(): void;
    get dataflowFlexTemplateRequestInput(): GoogleDataPipelinePipelineWorkloadDataflowFlexTemplateRequest | undefined;
    private _dataflowLaunchTemplateRequest;
    get dataflowLaunchTemplateRequest(): GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequestOutputReference;
    putDataflowLaunchTemplateRequest(value: GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequest): void;
    resetDataflowLaunchTemplateRequest(): void;
    get dataflowLaunchTemplateRequestInput(): GoogleDataPipelinePipelineWorkloadDataflowLaunchTemplateRequest | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline google_data_pipeline_pipeline}
*/
export declare class GoogleDataPipelinePipeline extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_data_pipeline_pipeline";
    /**
    * Generates CDKTF code for importing a GoogleDataPipelinePipeline resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleDataPipelinePipeline to import
    * @param importFromId The id of the existing GoogleDataPipelinePipeline that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleDataPipelinePipeline to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_data_pipeline_pipeline google_data_pipeline_pipeline} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDataPipelinePipelineConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDataPipelinePipelineConfig);
    get createTime(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get jobCount(): number;
    get lastUpdateTime(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _pipelineSources?;
    get pipelineSources(): {
        [key: string]: string;
    };
    set pipelineSources(value: {
        [key: string]: string;
    });
    resetPipelineSources(): void;
    get pipelineSourcesInput(): {
        [key: string]: string;
    } | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _schedulerServiceAccountEmail?;
    get schedulerServiceAccountEmail(): string;
    set schedulerServiceAccountEmail(value: string);
    resetSchedulerServiceAccountEmail(): void;
    get schedulerServiceAccountEmailInput(): string | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    get stateInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _scheduleInfo;
    get scheduleInfo(): GoogleDataPipelinePipelineScheduleInfoOutputReference;
    putScheduleInfo(value: GoogleDataPipelinePipelineScheduleInfo): void;
    resetScheduleInfo(): void;
    get scheduleInfoInput(): GoogleDataPipelinePipelineScheduleInfo | undefined;
    private _timeouts;
    get timeouts(): GoogleDataPipelinePipelineTimeoutsOutputReference;
    putTimeouts(value: GoogleDataPipelinePipelineTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDataPipelinePipelineTimeouts | undefined;
    private _workload;
    get workload(): GoogleDataPipelinePipelineWorkloadOutputReference;
    putWorkload(value: GoogleDataPipelinePipelineWorkload): void;
    resetWorkload(): void;
    get workloadInput(): GoogleDataPipelinePipelineWorkload | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
