/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDatabaseMigrationServiceConnectionProfileConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of the connection profile.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#connection_profile_id GoogleDatabaseMigrationServiceConnectionProfile#connection_profile_id}
    */
    readonly connectionProfileId: string;
    /**
    * The connection profile display name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#display_name GoogleDatabaseMigrationServiceConnectionProfile#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#id GoogleDatabaseMigrationServiceConnectionProfile#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The resource labels for connection profile to use to annotate any related underlying resources such as Compute Engine VMs.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#labels GoogleDatabaseMigrationServiceConnectionProfile#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location where the connection profile should reside.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#location GoogleDatabaseMigrationServiceConnectionProfile#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#project GoogleDatabaseMigrationServiceConnectionProfile#project}
    */
    readonly project?: string;
    /**
    * alloydb block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#alloydb GoogleDatabaseMigrationServiceConnectionProfile#alloydb}
    */
    readonly alloydb?: GoogleDatabaseMigrationServiceConnectionProfileAlloydb;
    /**
    * cloudsql block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#cloudsql GoogleDatabaseMigrationServiceConnectionProfile#cloudsql}
    */
    readonly cloudsql?: GoogleDatabaseMigrationServiceConnectionProfileCloudsql;
    /**
    * mysql block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#mysql GoogleDatabaseMigrationServiceConnectionProfile#mysql}
    */
    readonly mysql?: GoogleDatabaseMigrationServiceConnectionProfileMysql;
    /**
    * oracle block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#oracle GoogleDatabaseMigrationServiceConnectionProfile#oracle}
    */
    readonly oracle?: GoogleDatabaseMigrationServiceConnectionProfileOracle;
    /**
    * postgresql block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#postgresql GoogleDatabaseMigrationServiceConnectionProfile#postgresql}
    */
    readonly postgresql?: GoogleDatabaseMigrationServiceConnectionProfilePostgresql;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#timeouts GoogleDatabaseMigrationServiceConnectionProfile#timeouts}
    */
    readonly timeouts?: GoogleDatabaseMigrationServiceConnectionProfileTimeouts;
}
export interface GoogleDatabaseMigrationServiceConnectionProfileError {
}
export declare function googleDatabaseMigrationServiceConnectionProfileErrorToTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileError): any;
export declare function googleDatabaseMigrationServiceConnectionProfileErrorToHclTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileError): any;
export declare class GoogleDatabaseMigrationServiceConnectionProfileErrorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDatabaseMigrationServiceConnectionProfileError | undefined;
    set internalValue(value: GoogleDatabaseMigrationServiceConnectionProfileError | undefined);
    get code(): number;
    private _details;
    get details(): cdktf.StringMapList;
    get message(): string;
}
export declare class GoogleDatabaseMigrationServiceConnectionProfileErrorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDatabaseMigrationServiceConnectionProfileErrorOutputReference;
}
export interface GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsInitialUser {
    /**
    * The initial password for the user.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#password GoogleDatabaseMigrationServiceConnectionProfile#password}
    */
    readonly password: string;
    /**
    * The database username.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#user GoogleDatabaseMigrationServiceConnectionProfile#user}
    */
    readonly user: string;
}
export declare function googleDatabaseMigrationServiceConnectionProfileAlloydbSettingsInitialUserToTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsInitialUserOutputReference | GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsInitialUser): any;
export declare function googleDatabaseMigrationServiceConnectionProfileAlloydbSettingsInitialUserToHclTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsInitialUserOutputReference | GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsInitialUser): any;
export declare class GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsInitialUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsInitialUser | undefined;
    set internalValue(value: GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsInitialUser | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    get passwordSet(): cdktf.IResolvable;
    private _user?;
    get user(): string;
    set user(value: string);
    get userInput(): string | undefined;
}
export interface GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfig {
    /**
    * The number of CPU's in the VM instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#cpu_count GoogleDatabaseMigrationServiceConnectionProfile#cpu_count}
    */
    readonly cpuCount: number;
}
export declare function googleDatabaseMigrationServiceConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfigToTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfigOutputReference | GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfig): any;
export declare function googleDatabaseMigrationServiceConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfigToHclTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfigOutputReference | GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfig): any;
export declare class GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfig | undefined;
    set internalValue(value: GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfig | undefined);
    private _cpuCount?;
    get cpuCount(): number;
    set cpuCount(value: number);
    get cpuCountInput(): number | undefined;
}
export interface GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsPrimaryInstanceSettings {
    /**
    * Database flags to pass to AlloyDB when DMS is creating the AlloyDB cluster and instances. See the AlloyDB documentation for how these can be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#database_flags GoogleDatabaseMigrationServiceConnectionProfile#database_flags}
    */
    readonly databaseFlags?: {
        [key: string]: string;
    };
    /**
    * The database username.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#id GoogleDatabaseMigrationServiceConnectionProfile#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * Labels for the AlloyDB primary instance created by DMS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#labels GoogleDatabaseMigrationServiceConnectionProfile#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * machine_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#machine_config GoogleDatabaseMigrationServiceConnectionProfile#machine_config}
    */
    readonly machineConfig: GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfig;
}
export declare function googleDatabaseMigrationServiceConnectionProfileAlloydbSettingsPrimaryInstanceSettingsToTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsPrimaryInstanceSettingsOutputReference | GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsPrimaryInstanceSettings): any;
export declare function googleDatabaseMigrationServiceConnectionProfileAlloydbSettingsPrimaryInstanceSettingsToHclTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsPrimaryInstanceSettingsOutputReference | GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsPrimaryInstanceSettings): any;
export declare class GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsPrimaryInstanceSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsPrimaryInstanceSettings | undefined;
    set internalValue(value: GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsPrimaryInstanceSettings | undefined);
    private _databaseFlags?;
    get databaseFlags(): {
        [key: string]: string;
    };
    set databaseFlags(value: {
        [key: string]: string;
    });
    resetDatabaseFlags(): void;
    get databaseFlagsInput(): {
        [key: string]: string;
    } | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get privateIp(): string;
    private _machineConfig;
    get machineConfig(): GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfigOutputReference;
    putMachineConfig(value: GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfig): void;
    get machineConfigInput(): GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfig | undefined;
}
export interface GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettings {
    /**
    * Labels for the AlloyDB cluster created by DMS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#labels GoogleDatabaseMigrationServiceConnectionProfile#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Required. The resource link for the VPC network in which cluster resources are created and from which they are accessible via Private IP. The network must belong to the same project as the cluster.
    * It is specified in the form: 'projects/{project_number}/global/networks/{network_id}'. This is required to create a cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#vpc_network GoogleDatabaseMigrationServiceConnectionProfile#vpc_network}
    */
    readonly vpcNetwork: string;
    /**
    * initial_user block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#initial_user GoogleDatabaseMigrationServiceConnectionProfile#initial_user}
    */
    readonly initialUser: GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsInitialUser;
    /**
    * primary_instance_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#primary_instance_settings GoogleDatabaseMigrationServiceConnectionProfile#primary_instance_settings}
    */
    readonly primaryInstanceSettings?: GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsPrimaryInstanceSettings;
}
export declare function googleDatabaseMigrationServiceConnectionProfileAlloydbSettingsToTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsOutputReference | GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettings): any;
export declare function googleDatabaseMigrationServiceConnectionProfileAlloydbSettingsToHclTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsOutputReference | GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettings): any;
export declare class GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettings | undefined;
    set internalValue(value: GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettings | undefined);
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _vpcNetwork?;
    get vpcNetwork(): string;
    set vpcNetwork(value: string);
    get vpcNetworkInput(): string | undefined;
    private _initialUser;
    get initialUser(): GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsInitialUserOutputReference;
    putInitialUser(value: GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsInitialUser): void;
    get initialUserInput(): GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsInitialUser | undefined;
    private _primaryInstanceSettings;
    get primaryInstanceSettings(): GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsPrimaryInstanceSettingsOutputReference;
    putPrimaryInstanceSettings(value: GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsPrimaryInstanceSettings): void;
    resetPrimaryInstanceSettings(): void;
    get primaryInstanceSettingsInput(): GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsPrimaryInstanceSettings | undefined;
}
export interface GoogleDatabaseMigrationServiceConnectionProfileAlloydb {
    /**
    * Required. The AlloyDB cluster ID that this connection profile is associated with.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#cluster_id GoogleDatabaseMigrationServiceConnectionProfile#cluster_id}
    */
    readonly clusterId: string;
    /**
    * settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#settings GoogleDatabaseMigrationServiceConnectionProfile#settings}
    */
    readonly settings?: GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettings;
}
export declare function googleDatabaseMigrationServiceConnectionProfileAlloydbToTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileAlloydbOutputReference | GoogleDatabaseMigrationServiceConnectionProfileAlloydb): any;
export declare function googleDatabaseMigrationServiceConnectionProfileAlloydbToHclTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileAlloydbOutputReference | GoogleDatabaseMigrationServiceConnectionProfileAlloydb): any;
export declare class GoogleDatabaseMigrationServiceConnectionProfileAlloydbOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatabaseMigrationServiceConnectionProfileAlloydb | undefined;
    set internalValue(value: GoogleDatabaseMigrationServiceConnectionProfileAlloydb | undefined);
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    private _settings;
    get settings(): GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettingsOutputReference;
    putSettings(value: GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettings): void;
    resetSettings(): void;
    get settingsInput(): GoogleDatabaseMigrationServiceConnectionProfileAlloydbSettings | undefined;
}
export interface GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworks {
    /**
    * The time when this access control entry expires in RFC 3339 format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#expire_time GoogleDatabaseMigrationServiceConnectionProfile#expire_time}
    */
    readonly expireTime?: string;
    /**
    * A label to identify this entry.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#label GoogleDatabaseMigrationServiceConnectionProfile#label}
    */
    readonly label?: string;
    /**
    * Input only. The time-to-leave of this access control entry.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#ttl GoogleDatabaseMigrationServiceConnectionProfile#ttl}
    */
    readonly ttl?: string;
    /**
    * The allowlisted value for the access control list.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#value GoogleDatabaseMigrationServiceConnectionProfile#value}
    */
    readonly value: string;
}
export declare function googleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworksToTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworks | cdktf.IResolvable): any;
export declare function googleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworksToHclTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworks | cdktf.IResolvable): any;
export declare class GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworks | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworks | cdktf.IResolvable | undefined);
    private _expireTime?;
    get expireTime(): string;
    set expireTime(value: string);
    resetExpireTime(): void;
    get expireTimeInput(): string | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _ttl?;
    get ttl(): string;
    set ttl(value: string);
    resetTtl(): void;
    get ttlInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworks[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworksOutputReference;
}
export interface GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsIpConfig {
    /**
    * Whether the instance should be assigned an IPv4 address or not.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#enable_ipv4 GoogleDatabaseMigrationServiceConnectionProfile#enable_ipv4}
    */
    readonly enableIpv4?: boolean | cdktf.IResolvable;
    /**
    * The resource link for the VPC network from which the Cloud SQL instance is accessible for private IP. For example, projects/myProject/global/networks/default.
    * This setting can be updated, but it cannot be removed after it is set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#private_network GoogleDatabaseMigrationServiceConnectionProfile#private_network}
    */
    readonly privateNetwork?: string;
    /**
    * Whether SSL connections over IP should be enforced or not.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#require_ssl GoogleDatabaseMigrationServiceConnectionProfile#require_ssl}
    */
    readonly requireSsl?: boolean | cdktf.IResolvable;
    /**
    * authorized_networks block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#authorized_networks GoogleDatabaseMigrationServiceConnectionProfile#authorized_networks}
    */
    readonly authorizedNetworks?: GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworks[] | cdktf.IResolvable;
}
export declare function googleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsIpConfigToTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsIpConfigOutputReference | GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsIpConfig): any;
export declare function googleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsIpConfigToHclTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsIpConfigOutputReference | GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsIpConfig): any;
export declare class GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsIpConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsIpConfig | undefined;
    set internalValue(value: GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsIpConfig | undefined);
    private _enableIpv4?;
    get enableIpv4(): boolean | cdktf.IResolvable;
    set enableIpv4(value: boolean | cdktf.IResolvable);
    resetEnableIpv4(): void;
    get enableIpv4Input(): boolean | cdktf.IResolvable | undefined;
    private _privateNetwork?;
    get privateNetwork(): string;
    set privateNetwork(value: string);
    resetPrivateNetwork(): void;
    get privateNetworkInput(): string | undefined;
    private _requireSsl?;
    get requireSsl(): boolean | cdktf.IResolvable;
    set requireSsl(value: boolean | cdktf.IResolvable);
    resetRequireSsl(): void;
    get requireSslInput(): boolean | cdktf.IResolvable | undefined;
    private _authorizedNetworks;
    get authorizedNetworks(): GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworksList;
    putAuthorizedNetworks(value: GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworks[] | cdktf.IResolvable): void;
    resetAuthorizedNetworks(): void;
    get authorizedNetworksInput(): cdktf.IResolvable | GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworks[] | undefined;
}
export interface GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettings {
    /**
    * The activation policy specifies when the instance is activated; it is applicable only when the instance state is 'RUNNABLE'. Possible values: ["ALWAYS", "NEVER"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#activation_policy GoogleDatabaseMigrationServiceConnectionProfile#activation_policy}
    */
    readonly activationPolicy?: string;
    /**
    * If you enable this setting, Cloud SQL checks your available storage every 30 seconds. If the available storage falls below a threshold size, Cloud SQL automatically adds additional storage capacity.
    * If the available storage repeatedly falls below the threshold size, Cloud SQL continues to add storage until it reaches the maximum of 30 TB.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#auto_storage_increase GoogleDatabaseMigrationServiceConnectionProfile#auto_storage_increase}
    */
    readonly autoStorageIncrease?: boolean | cdktf.IResolvable;
    /**
    * The KMS key name used for the csql instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#cmek_key_name GoogleDatabaseMigrationServiceConnectionProfile#cmek_key_name}
    */
    readonly cmekKeyName?: string;
    /**
    * The Cloud SQL default instance level collation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#collation GoogleDatabaseMigrationServiceConnectionProfile#collation}
    */
    readonly collation?: string;
    /**
    * The storage capacity available to the database, in GB. The minimum (and default) size is 10GB.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#data_disk_size_gb GoogleDatabaseMigrationServiceConnectionProfile#data_disk_size_gb}
    */
    readonly dataDiskSizeGb?: string;
    /**
    * The type of storage. Possible values: ["PD_SSD", "PD_HDD"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#data_disk_type GoogleDatabaseMigrationServiceConnectionProfile#data_disk_type}
    */
    readonly dataDiskType?: string;
    /**
    * The database flags passed to the Cloud SQL instance at startup.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#database_flags GoogleDatabaseMigrationServiceConnectionProfile#database_flags}
    */
    readonly databaseFlags?: {
        [key: string]: string;
    };
    /**
    * The database engine type and version.
    * Currently supported values located at https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.connectionProfiles#sqldatabaseversion
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#database_version GoogleDatabaseMigrationServiceConnectionProfile#database_version}
    */
    readonly databaseVersion?: string;
    /**
    * The edition of the given Cloud SQL instance. Possible values: ["ENTERPRISE", "ENTERPRISE_PLUS"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#edition GoogleDatabaseMigrationServiceConnectionProfile#edition}
    */
    readonly edition?: string;
    /**
    * Input only. Initial root password.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#root_password GoogleDatabaseMigrationServiceConnectionProfile#root_password}
    */
    readonly rootPassword?: string;
    /**
    * The Database Migration Service source connection profile ID, in the format: projects/my_project_name/locations/us-central1/connectionProfiles/connection_profile_ID
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#source_id GoogleDatabaseMigrationServiceConnectionProfile#source_id}
    */
    readonly sourceId: string;
    /**
    * The maximum size to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#storage_auto_resize_limit GoogleDatabaseMigrationServiceConnectionProfile#storage_auto_resize_limit}
    */
    readonly storageAutoResizeLimit?: string;
    /**
    * The tier (or machine type) for this instance, for example: db-n1-standard-1 (MySQL instances) or db-custom-1-3840 (PostgreSQL instances).
    * For more information, see https://cloud.google.com/sql/docs/mysql/instance-settings
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#tier GoogleDatabaseMigrationServiceConnectionProfile#tier}
    */
    readonly tier?: string;
    /**
    * The resource labels for a Cloud SQL instance to use to annotate any related underlying resources such as Compute Engine VMs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#user_labels GoogleDatabaseMigrationServiceConnectionProfile#user_labels}
    */
    readonly userLabels?: {
        [key: string]: string;
    };
    /**
    * The Google Cloud Platform zone where your Cloud SQL datdabse instance is located.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#zone GoogleDatabaseMigrationServiceConnectionProfile#zone}
    */
    readonly zone?: string;
    /**
    * ip_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#ip_config GoogleDatabaseMigrationServiceConnectionProfile#ip_config}
    */
    readonly ipConfig?: GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsIpConfig;
}
export declare function googleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsToTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsOutputReference | GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettings): any;
export declare function googleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsToHclTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsOutputReference | GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettings): any;
export declare class GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettings | undefined;
    set internalValue(value: GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettings | undefined);
    private _activationPolicy?;
    get activationPolicy(): string;
    set activationPolicy(value: string);
    resetActivationPolicy(): void;
    get activationPolicyInput(): string | undefined;
    private _autoStorageIncrease?;
    get autoStorageIncrease(): boolean | cdktf.IResolvable;
    set autoStorageIncrease(value: boolean | cdktf.IResolvable);
    resetAutoStorageIncrease(): void;
    get autoStorageIncreaseInput(): boolean | cdktf.IResolvable | undefined;
    private _cmekKeyName?;
    get cmekKeyName(): string;
    set cmekKeyName(value: string);
    resetCmekKeyName(): void;
    get cmekKeyNameInput(): string | undefined;
    private _collation?;
    get collation(): string;
    set collation(value: string);
    resetCollation(): void;
    get collationInput(): string | undefined;
    private _dataDiskSizeGb?;
    get dataDiskSizeGb(): string;
    set dataDiskSizeGb(value: string);
    resetDataDiskSizeGb(): void;
    get dataDiskSizeGbInput(): string | undefined;
    private _dataDiskType?;
    get dataDiskType(): string;
    set dataDiskType(value: string);
    resetDataDiskType(): void;
    get dataDiskTypeInput(): string | undefined;
    private _databaseFlags?;
    get databaseFlags(): {
        [key: string]: string;
    };
    set databaseFlags(value: {
        [key: string]: string;
    });
    resetDatabaseFlags(): void;
    get databaseFlagsInput(): {
        [key: string]: string;
    } | undefined;
    private _databaseVersion?;
    get databaseVersion(): string;
    set databaseVersion(value: string);
    resetDatabaseVersion(): void;
    get databaseVersionInput(): string | undefined;
    private _edition?;
    get edition(): string;
    set edition(value: string);
    resetEdition(): void;
    get editionInput(): string | undefined;
    private _rootPassword?;
    get rootPassword(): string;
    set rootPassword(value: string);
    resetRootPassword(): void;
    get rootPasswordInput(): string | undefined;
    get rootPasswordSet(): cdktf.IResolvable;
    private _sourceId?;
    get sourceId(): string;
    set sourceId(value: string);
    get sourceIdInput(): string | undefined;
    private _storageAutoResizeLimit?;
    get storageAutoResizeLimit(): string;
    set storageAutoResizeLimit(value: string);
    resetStorageAutoResizeLimit(): void;
    get storageAutoResizeLimitInput(): string | undefined;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    resetTier(): void;
    get tierInput(): string | undefined;
    private _userLabels?;
    get userLabels(): {
        [key: string]: string;
    };
    set userLabels(value: {
        [key: string]: string;
    });
    resetUserLabels(): void;
    get userLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _ipConfig;
    get ipConfig(): GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsIpConfigOutputReference;
    putIpConfig(value: GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsIpConfig): void;
    resetIpConfig(): void;
    get ipConfigInput(): GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsIpConfig | undefined;
}
export interface GoogleDatabaseMigrationServiceConnectionProfileCloudsql {
    /**
    * settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#settings GoogleDatabaseMigrationServiceConnectionProfile#settings}
    */
    readonly settings?: GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettings;
}
export declare function googleDatabaseMigrationServiceConnectionProfileCloudsqlToTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileCloudsqlOutputReference | GoogleDatabaseMigrationServiceConnectionProfileCloudsql): any;
export declare function googleDatabaseMigrationServiceConnectionProfileCloudsqlToHclTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileCloudsqlOutputReference | GoogleDatabaseMigrationServiceConnectionProfileCloudsql): any;
export declare class GoogleDatabaseMigrationServiceConnectionProfileCloudsqlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatabaseMigrationServiceConnectionProfileCloudsql | undefined;
    set internalValue(value: GoogleDatabaseMigrationServiceConnectionProfileCloudsql | undefined);
    get cloudSqlId(): string;
    get privateIp(): string;
    get publicIp(): string;
    private _settings;
    get settings(): GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettingsOutputReference;
    putSettings(value: GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettings): void;
    resetSettings(): void;
    get settingsInput(): GoogleDatabaseMigrationServiceConnectionProfileCloudsqlSettings | undefined;
}
export interface GoogleDatabaseMigrationServiceConnectionProfileMysqlSsl {
    /**
    * Required. Input only. The x509 PEM-encoded certificate of the CA that signed the source database server's certificate.
    * The replica will use this certificate to verify it's connecting to the right host.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#ca_certificate GoogleDatabaseMigrationServiceConnectionProfile#ca_certificate}
    */
    readonly caCertificate: string;
    /**
    * Input only. The x509 PEM-encoded certificate that will be used by the replica to authenticate against the source database server.
    * If this field is used then the 'clientKey' field is mandatory
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#client_certificate GoogleDatabaseMigrationServiceConnectionProfile#client_certificate}
    */
    readonly clientCertificate?: string;
    /**
    * Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key associated with the Client Certificate.
    * If this field is used then the 'clientCertificate' field is mandatory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#client_key GoogleDatabaseMigrationServiceConnectionProfile#client_key}
    */
    readonly clientKey?: string;
}
export declare function googleDatabaseMigrationServiceConnectionProfileMysqlSslToTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileMysqlSslOutputReference | GoogleDatabaseMigrationServiceConnectionProfileMysqlSsl): any;
export declare function googleDatabaseMigrationServiceConnectionProfileMysqlSslToHclTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileMysqlSslOutputReference | GoogleDatabaseMigrationServiceConnectionProfileMysqlSsl): any;
export declare class GoogleDatabaseMigrationServiceConnectionProfileMysqlSslOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatabaseMigrationServiceConnectionProfileMysqlSsl | undefined;
    set internalValue(value: GoogleDatabaseMigrationServiceConnectionProfileMysqlSsl | undefined);
    private _caCertificate?;
    get caCertificate(): string;
    set caCertificate(value: string);
    get caCertificateInput(): string | undefined;
    private _clientCertificate?;
    get clientCertificate(): string;
    set clientCertificate(value: string);
    resetClientCertificate(): void;
    get clientCertificateInput(): string | undefined;
    private _clientKey?;
    get clientKey(): string;
    set clientKey(value: string);
    resetClientKey(): void;
    get clientKeyInput(): string | undefined;
    get type(): string;
}
export interface GoogleDatabaseMigrationServiceConnectionProfileMysql {
    /**
    * If the source is a Cloud SQL database, use this field to provide the Cloud SQL instance ID of the source.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#cloud_sql_id GoogleDatabaseMigrationServiceConnectionProfile#cloud_sql_id}
    */
    readonly cloudSqlId?: string;
    /**
    * Required. The IP or hostname of the source MySQL database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#host GoogleDatabaseMigrationServiceConnectionProfile#host}
    */
    readonly host: string;
    /**
    * Required. Input only. The password for the user that Database Migration Service will be using to connect to the database.
    * This field is not returned on request, and the value is encrypted when stored in Database Migration Service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#password GoogleDatabaseMigrationServiceConnectionProfile#password}
    */
    readonly password: string;
    /**
    * Required. The network port of the source MySQL database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#port GoogleDatabaseMigrationServiceConnectionProfile#port}
    */
    readonly port: number;
    /**
    * Required. The username that Database Migration Service will use to connect to the database. The value is encrypted when stored in Database Migration Service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#username GoogleDatabaseMigrationServiceConnectionProfile#username}
    */
    readonly username: string;
    /**
    * ssl block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#ssl GoogleDatabaseMigrationServiceConnectionProfile#ssl}
    */
    readonly ssl?: GoogleDatabaseMigrationServiceConnectionProfileMysqlSsl;
}
export declare function googleDatabaseMigrationServiceConnectionProfileMysqlToTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileMysqlOutputReference | GoogleDatabaseMigrationServiceConnectionProfileMysql): any;
export declare function googleDatabaseMigrationServiceConnectionProfileMysqlToHclTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileMysqlOutputReference | GoogleDatabaseMigrationServiceConnectionProfileMysql): any;
export declare class GoogleDatabaseMigrationServiceConnectionProfileMysqlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatabaseMigrationServiceConnectionProfileMysql | undefined;
    set internalValue(value: GoogleDatabaseMigrationServiceConnectionProfileMysql | undefined);
    private _cloudSqlId?;
    get cloudSqlId(): string;
    set cloudSqlId(value: string);
    resetCloudSqlId(): void;
    get cloudSqlIdInput(): string | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    get hostInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    get passwordSet(): cdktf.IResolvable;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _ssl;
    get ssl(): GoogleDatabaseMigrationServiceConnectionProfileMysqlSslOutputReference;
    putSsl(value: GoogleDatabaseMigrationServiceConnectionProfileMysqlSsl): void;
    resetSsl(): void;
    get sslInput(): GoogleDatabaseMigrationServiceConnectionProfileMysqlSsl | undefined;
}
export interface GoogleDatabaseMigrationServiceConnectionProfileOracleForwardSshConnectivity {
    /**
    * Required. Hostname for the SSH tunnel.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#hostname GoogleDatabaseMigrationServiceConnectionProfile#hostname}
    */
    readonly hostname: string;
    /**
    * Input only. SSH password. Only one of 'password' and 'private_key' can be configured.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#password GoogleDatabaseMigrationServiceConnectionProfile#password}
    */
    readonly password?: string;
    /**
    * Port for the SSH tunnel, default value is 22.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#port GoogleDatabaseMigrationServiceConnectionProfile#port}
    */
    readonly port: number;
    /**
    * Input only. SSH private key. Only one of 'password' and 'private_key' can be configured.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#private_key GoogleDatabaseMigrationServiceConnectionProfile#private_key}
    */
    readonly privateKey?: string;
    /**
    * Required. Username for the SSH tunnel.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#username GoogleDatabaseMigrationServiceConnectionProfile#username}
    */
    readonly username: string;
}
export declare function googleDatabaseMigrationServiceConnectionProfileOracleForwardSshConnectivityToTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileOracleForwardSshConnectivityOutputReference | GoogleDatabaseMigrationServiceConnectionProfileOracleForwardSshConnectivity): any;
export declare function googleDatabaseMigrationServiceConnectionProfileOracleForwardSshConnectivityToHclTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileOracleForwardSshConnectivityOutputReference | GoogleDatabaseMigrationServiceConnectionProfileOracleForwardSshConnectivity): any;
export declare class GoogleDatabaseMigrationServiceConnectionProfileOracleForwardSshConnectivityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatabaseMigrationServiceConnectionProfileOracleForwardSshConnectivity | undefined;
    set internalValue(value: GoogleDatabaseMigrationServiceConnectionProfileOracleForwardSshConnectivity | undefined);
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    get hostnameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _privateKey?;
    get privateKey(): string;
    set privateKey(value: string);
    resetPrivateKey(): void;
    get privateKeyInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface GoogleDatabaseMigrationServiceConnectionProfileOraclePrivateConnectivity {
    /**
    * Required. The resource name (URI) of the private connection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#private_connection GoogleDatabaseMigrationServiceConnectionProfile#private_connection}
    */
    readonly privateConnection: string;
}
export declare function googleDatabaseMigrationServiceConnectionProfileOraclePrivateConnectivityToTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileOraclePrivateConnectivityOutputReference | GoogleDatabaseMigrationServiceConnectionProfileOraclePrivateConnectivity): any;
export declare function googleDatabaseMigrationServiceConnectionProfileOraclePrivateConnectivityToHclTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileOraclePrivateConnectivityOutputReference | GoogleDatabaseMigrationServiceConnectionProfileOraclePrivateConnectivity): any;
export declare class GoogleDatabaseMigrationServiceConnectionProfileOraclePrivateConnectivityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatabaseMigrationServiceConnectionProfileOraclePrivateConnectivity | undefined;
    set internalValue(value: GoogleDatabaseMigrationServiceConnectionProfileOraclePrivateConnectivity | undefined);
    private _privateConnection?;
    get privateConnection(): string;
    set privateConnection(value: string);
    get privateConnectionInput(): string | undefined;
}
export interface GoogleDatabaseMigrationServiceConnectionProfileOracleSsl {
    /**
    * Required. Input only. The x509 PEM-encoded certificate of the CA that signed the source database server's certificate.
    * The replica will use this certificate to verify it's connecting to the right host.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#ca_certificate GoogleDatabaseMigrationServiceConnectionProfile#ca_certificate}
    */
    readonly caCertificate: string;
    /**
    * Input only. The x509 PEM-encoded certificate that will be used by the replica to authenticate against the source database server.
    * If this field is used then the 'clientKey' field is mandatory
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#client_certificate GoogleDatabaseMigrationServiceConnectionProfile#client_certificate}
    */
    readonly clientCertificate?: string;
    /**
    * Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key associated with the Client Certificate.
    * If this field is used then the 'clientCertificate' field is mandatory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#client_key GoogleDatabaseMigrationServiceConnectionProfile#client_key}
    */
    readonly clientKey?: string;
}
export declare function googleDatabaseMigrationServiceConnectionProfileOracleSslToTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileOracleSslOutputReference | GoogleDatabaseMigrationServiceConnectionProfileOracleSsl): any;
export declare function googleDatabaseMigrationServiceConnectionProfileOracleSslToHclTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileOracleSslOutputReference | GoogleDatabaseMigrationServiceConnectionProfileOracleSsl): any;
export declare class GoogleDatabaseMigrationServiceConnectionProfileOracleSslOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatabaseMigrationServiceConnectionProfileOracleSsl | undefined;
    set internalValue(value: GoogleDatabaseMigrationServiceConnectionProfileOracleSsl | undefined);
    private _caCertificate?;
    get caCertificate(): string;
    set caCertificate(value: string);
    get caCertificateInput(): string | undefined;
    private _clientCertificate?;
    get clientCertificate(): string;
    set clientCertificate(value: string);
    resetClientCertificate(): void;
    get clientCertificateInput(): string | undefined;
    private _clientKey?;
    get clientKey(): string;
    set clientKey(value: string);
    resetClientKey(): void;
    get clientKeyInput(): string | undefined;
    get type(): string;
}
export interface GoogleDatabaseMigrationServiceConnectionProfileOracleStaticServiceIpConnectivity {
}
export declare function googleDatabaseMigrationServiceConnectionProfileOracleStaticServiceIpConnectivityToTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileOracleStaticServiceIpConnectivityOutputReference | GoogleDatabaseMigrationServiceConnectionProfileOracleStaticServiceIpConnectivity): any;
export declare function googleDatabaseMigrationServiceConnectionProfileOracleStaticServiceIpConnectivityToHclTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileOracleStaticServiceIpConnectivityOutputReference | GoogleDatabaseMigrationServiceConnectionProfileOracleStaticServiceIpConnectivity): any;
export declare class GoogleDatabaseMigrationServiceConnectionProfileOracleStaticServiceIpConnectivityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatabaseMigrationServiceConnectionProfileOracleStaticServiceIpConnectivity | undefined;
    set internalValue(value: GoogleDatabaseMigrationServiceConnectionProfileOracleStaticServiceIpConnectivity | undefined);
}
export interface GoogleDatabaseMigrationServiceConnectionProfileOracle {
    /**
    * Required. Database service for the Oracle connection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#database_service GoogleDatabaseMigrationServiceConnectionProfile#database_service}
    */
    readonly databaseService: string;
    /**
    * Required. The IP or hostname of the source Oracle database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#host GoogleDatabaseMigrationServiceConnectionProfile#host}
    */
    readonly host: string;
    /**
    * Required. Input only. The password for the user that Database Migration Service will be using to connect to the database.
    * This field is not returned on request, and the value is encrypted when stored in Database Migration Service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#password GoogleDatabaseMigrationServiceConnectionProfile#password}
    */
    readonly password: string;
    /**
    * Required. The network port of the source Oracle database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#port GoogleDatabaseMigrationServiceConnectionProfile#port}
    */
    readonly port: number;
    /**
    * Required. The username that Database Migration Service will use to connect to the database. The value is encrypted when stored in Database Migration Service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#username GoogleDatabaseMigrationServiceConnectionProfile#username}
    */
    readonly username: string;
    /**
    * forward_ssh_connectivity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#forward_ssh_connectivity GoogleDatabaseMigrationServiceConnectionProfile#forward_ssh_connectivity}
    */
    readonly forwardSshConnectivity?: GoogleDatabaseMigrationServiceConnectionProfileOracleForwardSshConnectivity;
    /**
    * private_connectivity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#private_connectivity GoogleDatabaseMigrationServiceConnectionProfile#private_connectivity}
    */
    readonly privateConnectivity?: GoogleDatabaseMigrationServiceConnectionProfileOraclePrivateConnectivity;
    /**
    * ssl block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#ssl GoogleDatabaseMigrationServiceConnectionProfile#ssl}
    */
    readonly ssl?: GoogleDatabaseMigrationServiceConnectionProfileOracleSsl;
    /**
    * static_service_ip_connectivity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#static_service_ip_connectivity GoogleDatabaseMigrationServiceConnectionProfile#static_service_ip_connectivity}
    */
    readonly staticServiceIpConnectivity?: GoogleDatabaseMigrationServiceConnectionProfileOracleStaticServiceIpConnectivity;
}
export declare function googleDatabaseMigrationServiceConnectionProfileOracleToTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileOracleOutputReference | GoogleDatabaseMigrationServiceConnectionProfileOracle): any;
export declare function googleDatabaseMigrationServiceConnectionProfileOracleToHclTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileOracleOutputReference | GoogleDatabaseMigrationServiceConnectionProfileOracle): any;
export declare class GoogleDatabaseMigrationServiceConnectionProfileOracleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatabaseMigrationServiceConnectionProfileOracle | undefined;
    set internalValue(value: GoogleDatabaseMigrationServiceConnectionProfileOracle | undefined);
    private _databaseService?;
    get databaseService(): string;
    set databaseService(value: string);
    get databaseServiceInput(): string | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    get hostInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    get passwordSet(): cdktf.IResolvable;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _forwardSshConnectivity;
    get forwardSshConnectivity(): GoogleDatabaseMigrationServiceConnectionProfileOracleForwardSshConnectivityOutputReference;
    putForwardSshConnectivity(value: GoogleDatabaseMigrationServiceConnectionProfileOracleForwardSshConnectivity): void;
    resetForwardSshConnectivity(): void;
    get forwardSshConnectivityInput(): GoogleDatabaseMigrationServiceConnectionProfileOracleForwardSshConnectivity | undefined;
    private _privateConnectivity;
    get privateConnectivity(): GoogleDatabaseMigrationServiceConnectionProfileOraclePrivateConnectivityOutputReference;
    putPrivateConnectivity(value: GoogleDatabaseMigrationServiceConnectionProfileOraclePrivateConnectivity): void;
    resetPrivateConnectivity(): void;
    get privateConnectivityInput(): GoogleDatabaseMigrationServiceConnectionProfileOraclePrivateConnectivity | undefined;
    private _ssl;
    get ssl(): GoogleDatabaseMigrationServiceConnectionProfileOracleSslOutputReference;
    putSsl(value: GoogleDatabaseMigrationServiceConnectionProfileOracleSsl): void;
    resetSsl(): void;
    get sslInput(): GoogleDatabaseMigrationServiceConnectionProfileOracleSsl | undefined;
    private _staticServiceIpConnectivity;
    get staticServiceIpConnectivity(): GoogleDatabaseMigrationServiceConnectionProfileOracleStaticServiceIpConnectivityOutputReference;
    putStaticServiceIpConnectivity(value: GoogleDatabaseMigrationServiceConnectionProfileOracleStaticServiceIpConnectivity): void;
    resetStaticServiceIpConnectivity(): void;
    get staticServiceIpConnectivityInput(): GoogleDatabaseMigrationServiceConnectionProfileOracleStaticServiceIpConnectivity | undefined;
}
export interface GoogleDatabaseMigrationServiceConnectionProfilePostgresqlSsl {
    /**
    * Required. Input only. The x509 PEM-encoded certificate of the CA that signed the source database server's certificate.
    * The replica will use this certificate to verify it's connecting to the right host.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#ca_certificate GoogleDatabaseMigrationServiceConnectionProfile#ca_certificate}
    */
    readonly caCertificate: string;
    /**
    * Input only. The x509 PEM-encoded certificate that will be used by the replica to authenticate against the source database server.
    * If this field is used then the 'clientKey' field is mandatory
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#client_certificate GoogleDatabaseMigrationServiceConnectionProfile#client_certificate}
    */
    readonly clientCertificate?: string;
    /**
    * Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key associated with the Client Certificate.
    * If this field is used then the 'clientCertificate' field is mandatory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#client_key GoogleDatabaseMigrationServiceConnectionProfile#client_key}
    */
    readonly clientKey?: string;
}
export declare function googleDatabaseMigrationServiceConnectionProfilePostgresqlSslToTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfilePostgresqlSslOutputReference | GoogleDatabaseMigrationServiceConnectionProfilePostgresqlSsl): any;
export declare function googleDatabaseMigrationServiceConnectionProfilePostgresqlSslToHclTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfilePostgresqlSslOutputReference | GoogleDatabaseMigrationServiceConnectionProfilePostgresqlSsl): any;
export declare class GoogleDatabaseMigrationServiceConnectionProfilePostgresqlSslOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatabaseMigrationServiceConnectionProfilePostgresqlSsl | undefined;
    set internalValue(value: GoogleDatabaseMigrationServiceConnectionProfilePostgresqlSsl | undefined);
    private _caCertificate?;
    get caCertificate(): string;
    set caCertificate(value: string);
    get caCertificateInput(): string | undefined;
    private _clientCertificate?;
    get clientCertificate(): string;
    set clientCertificate(value: string);
    resetClientCertificate(): void;
    get clientCertificateInput(): string | undefined;
    private _clientKey?;
    get clientKey(): string;
    set clientKey(value: string);
    resetClientKey(): void;
    get clientKeyInput(): string | undefined;
    get type(): string;
}
export interface GoogleDatabaseMigrationServiceConnectionProfilePostgresql {
    /**
    * If the source is a Cloud SQL database, use this field to provide the Cloud SQL instance ID of the source.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#cloud_sql_id GoogleDatabaseMigrationServiceConnectionProfile#cloud_sql_id}
    */
    readonly cloudSqlId?: string;
    /**
    * Required. The IP or hostname of the source MySQL database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#host GoogleDatabaseMigrationServiceConnectionProfile#host}
    */
    readonly host: string;
    /**
    * Required. Input only. The password for the user that Database Migration Service will be using to connect to the database.
    * This field is not returned on request, and the value is encrypted when stored in Database Migration Service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#password GoogleDatabaseMigrationServiceConnectionProfile#password}
    */
    readonly password: string;
    /**
    * Required. The network port of the source MySQL database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#port GoogleDatabaseMigrationServiceConnectionProfile#port}
    */
    readonly port: number;
    /**
    * Required. The username that Database Migration Service will use to connect to the database. The value is encrypted when stored in Database Migration Service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#username GoogleDatabaseMigrationServiceConnectionProfile#username}
    */
    readonly username: string;
    /**
    * ssl block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#ssl GoogleDatabaseMigrationServiceConnectionProfile#ssl}
    */
    readonly ssl?: GoogleDatabaseMigrationServiceConnectionProfilePostgresqlSsl;
}
export declare function googleDatabaseMigrationServiceConnectionProfilePostgresqlToTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfilePostgresqlOutputReference | GoogleDatabaseMigrationServiceConnectionProfilePostgresql): any;
export declare function googleDatabaseMigrationServiceConnectionProfilePostgresqlToHclTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfilePostgresqlOutputReference | GoogleDatabaseMigrationServiceConnectionProfilePostgresql): any;
export declare class GoogleDatabaseMigrationServiceConnectionProfilePostgresqlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatabaseMigrationServiceConnectionProfilePostgresql | undefined;
    set internalValue(value: GoogleDatabaseMigrationServiceConnectionProfilePostgresql | undefined);
    private _cloudSqlId?;
    get cloudSqlId(): string;
    set cloudSqlId(value: string);
    resetCloudSqlId(): void;
    get cloudSqlIdInput(): string | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    get hostInput(): string | undefined;
    get networkArchitecture(): string;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    get passwordSet(): cdktf.IResolvable;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _ssl;
    get ssl(): GoogleDatabaseMigrationServiceConnectionProfilePostgresqlSslOutputReference;
    putSsl(value: GoogleDatabaseMigrationServiceConnectionProfilePostgresqlSsl): void;
    resetSsl(): void;
    get sslInput(): GoogleDatabaseMigrationServiceConnectionProfilePostgresqlSsl | undefined;
}
export interface GoogleDatabaseMigrationServiceConnectionProfileTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#create GoogleDatabaseMigrationServiceConnectionProfile#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#delete GoogleDatabaseMigrationServiceConnectionProfile#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#update GoogleDatabaseMigrationServiceConnectionProfile#update}
    */
    readonly update?: string;
}
export declare function googleDatabaseMigrationServiceConnectionProfileTimeoutsToTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileTimeouts | cdktf.IResolvable): any;
export declare function googleDatabaseMigrationServiceConnectionProfileTimeoutsToHclTerraform(struct?: GoogleDatabaseMigrationServiceConnectionProfileTimeouts | cdktf.IResolvable): any;
export declare class GoogleDatabaseMigrationServiceConnectionProfileTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatabaseMigrationServiceConnectionProfileTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDatabaseMigrationServiceConnectionProfileTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile google_database_migration_service_connection_profile}
*/
export declare class GoogleDatabaseMigrationServiceConnectionProfile extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_database_migration_service_connection_profile";
    /**
    * Generates CDKTF code for importing a GoogleDatabaseMigrationServiceConnectionProfile resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleDatabaseMigrationServiceConnectionProfile to import
    * @param importFromId The id of the existing GoogleDatabaseMigrationServiceConnectionProfile that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleDatabaseMigrationServiceConnectionProfile to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_connection_profile google_database_migration_service_connection_profile} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDatabaseMigrationServiceConnectionProfileConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDatabaseMigrationServiceConnectionProfileConfig);
    private _connectionProfileId?;
    get connectionProfileId(): string;
    set connectionProfileId(value: string);
    get connectionProfileIdInput(): string | undefined;
    get createTime(): string;
    get dbprovider(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _error;
    get error(): GoogleDatabaseMigrationServiceConnectionProfileErrorList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _alloydb;
    get alloydb(): GoogleDatabaseMigrationServiceConnectionProfileAlloydbOutputReference;
    putAlloydb(value: GoogleDatabaseMigrationServiceConnectionProfileAlloydb): void;
    resetAlloydb(): void;
    get alloydbInput(): GoogleDatabaseMigrationServiceConnectionProfileAlloydb | undefined;
    private _cloudsql;
    get cloudsql(): GoogleDatabaseMigrationServiceConnectionProfileCloudsqlOutputReference;
    putCloudsql(value: GoogleDatabaseMigrationServiceConnectionProfileCloudsql): void;
    resetCloudsql(): void;
    get cloudsqlInput(): GoogleDatabaseMigrationServiceConnectionProfileCloudsql | undefined;
    private _mysql;
    get mysql(): GoogleDatabaseMigrationServiceConnectionProfileMysqlOutputReference;
    putMysql(value: GoogleDatabaseMigrationServiceConnectionProfileMysql): void;
    resetMysql(): void;
    get mysqlInput(): GoogleDatabaseMigrationServiceConnectionProfileMysql | undefined;
    private _oracle;
    get oracle(): GoogleDatabaseMigrationServiceConnectionProfileOracleOutputReference;
    putOracle(value: GoogleDatabaseMigrationServiceConnectionProfileOracle): void;
    resetOracle(): void;
    get oracleInput(): GoogleDatabaseMigrationServiceConnectionProfileOracle | undefined;
    private _postgresql;
    get postgresql(): GoogleDatabaseMigrationServiceConnectionProfilePostgresqlOutputReference;
    putPostgresql(value: GoogleDatabaseMigrationServiceConnectionProfilePostgresql): void;
    resetPostgresql(): void;
    get postgresqlInput(): GoogleDatabaseMigrationServiceConnectionProfilePostgresql | undefined;
    private _timeouts;
    get timeouts(): GoogleDatabaseMigrationServiceConnectionProfileTimeoutsOutputReference;
    putTimeouts(value: GoogleDatabaseMigrationServiceConnectionProfileTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDatabaseMigrationServiceConnectionProfileTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
