/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDatabaseMigrationServicePrivateConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Display name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_private_connection#display_name GoogleDatabaseMigrationServicePrivateConnection#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_private_connection#id GoogleDatabaseMigrationServicePrivateConnection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Labels.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_private_connection#labels GoogleDatabaseMigrationServicePrivateConnection#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The name of the location this private connection is located in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_private_connection#location GoogleDatabaseMigrationServicePrivateConnection#location}
    */
    readonly location: string;
    /**
    * The private connectivity identifier.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_private_connection#private_connection_id GoogleDatabaseMigrationServicePrivateConnection#private_connection_id}
    */
    readonly privateConnectionId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_private_connection#project GoogleDatabaseMigrationServicePrivateConnection#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_private_connection#timeouts GoogleDatabaseMigrationServicePrivateConnection#timeouts}
    */
    readonly timeouts?: GoogleDatabaseMigrationServicePrivateConnectionTimeouts;
    /**
    * vpc_peering_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_private_connection#vpc_peering_config GoogleDatabaseMigrationServicePrivateConnection#vpc_peering_config}
    */
    readonly vpcPeeringConfig: GoogleDatabaseMigrationServicePrivateConnectionVpcPeeringConfig;
}
export interface GoogleDatabaseMigrationServicePrivateConnectionError {
}
export declare function googleDatabaseMigrationServicePrivateConnectionErrorToTerraform(struct?: GoogleDatabaseMigrationServicePrivateConnectionError): any;
export declare function googleDatabaseMigrationServicePrivateConnectionErrorToHclTerraform(struct?: GoogleDatabaseMigrationServicePrivateConnectionError): any;
export declare class GoogleDatabaseMigrationServicePrivateConnectionErrorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDatabaseMigrationServicePrivateConnectionError | undefined;
    set internalValue(value: GoogleDatabaseMigrationServicePrivateConnectionError | undefined);
    private _details;
    get details(): cdktf.StringMap;
    get message(): string;
}
export declare class GoogleDatabaseMigrationServicePrivateConnectionErrorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDatabaseMigrationServicePrivateConnectionErrorOutputReference;
}
export interface GoogleDatabaseMigrationServicePrivateConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_private_connection#create GoogleDatabaseMigrationServicePrivateConnection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_private_connection#delete GoogleDatabaseMigrationServicePrivateConnection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_private_connection#update GoogleDatabaseMigrationServicePrivateConnection#update}
    */
    readonly update?: string;
}
export declare function googleDatabaseMigrationServicePrivateConnectionTimeoutsToTerraform(struct?: GoogleDatabaseMigrationServicePrivateConnectionTimeouts | cdktf.IResolvable): any;
export declare function googleDatabaseMigrationServicePrivateConnectionTimeoutsToHclTerraform(struct?: GoogleDatabaseMigrationServicePrivateConnectionTimeouts | cdktf.IResolvable): any;
export declare class GoogleDatabaseMigrationServicePrivateConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatabaseMigrationServicePrivateConnectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDatabaseMigrationServicePrivateConnectionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleDatabaseMigrationServicePrivateConnectionVpcPeeringConfig {
    /**
    * A free subnet for peering. (CIDR of /29)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_private_connection#subnet GoogleDatabaseMigrationServicePrivateConnection#subnet}
    */
    readonly subnet: string;
    /**
    * Fully qualified name of the VPC that Database Migration Service will peer to.
    * Format: projects/{project}/global/{networks}/{name}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_private_connection#vpc_name GoogleDatabaseMigrationServicePrivateConnection#vpc_name}
    */
    readonly vpcName: string;
}
export declare function googleDatabaseMigrationServicePrivateConnectionVpcPeeringConfigToTerraform(struct?: GoogleDatabaseMigrationServicePrivateConnectionVpcPeeringConfigOutputReference | GoogleDatabaseMigrationServicePrivateConnectionVpcPeeringConfig): any;
export declare function googleDatabaseMigrationServicePrivateConnectionVpcPeeringConfigToHclTerraform(struct?: GoogleDatabaseMigrationServicePrivateConnectionVpcPeeringConfigOutputReference | GoogleDatabaseMigrationServicePrivateConnectionVpcPeeringConfig): any;
export declare class GoogleDatabaseMigrationServicePrivateConnectionVpcPeeringConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatabaseMigrationServicePrivateConnectionVpcPeeringConfig | undefined;
    set internalValue(value: GoogleDatabaseMigrationServicePrivateConnectionVpcPeeringConfig | undefined);
    private _subnet?;
    get subnet(): string;
    set subnet(value: string);
    get subnetInput(): string | undefined;
    private _vpcName?;
    get vpcName(): string;
    set vpcName(value: string);
    get vpcNameInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_private_connection google_database_migration_service_private_connection}
*/
export declare class GoogleDatabaseMigrationServicePrivateConnection extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_database_migration_service_private_connection";
    /**
    * Generates CDKTF code for importing a GoogleDatabaseMigrationServicePrivateConnection resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleDatabaseMigrationServicePrivateConnection to import
    * @param importFromId The id of the existing GoogleDatabaseMigrationServicePrivateConnection that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_private_connection#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleDatabaseMigrationServicePrivateConnection to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_database_migration_service_private_connection google_database_migration_service_private_connection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDatabaseMigrationServicePrivateConnectionConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDatabaseMigrationServicePrivateConnectionConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _error;
    get error(): GoogleDatabaseMigrationServicePrivateConnectionErrorList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _privateConnectionId?;
    get privateConnectionId(): string;
    set privateConnectionId(value: string);
    get privateConnectionIdInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): GoogleDatabaseMigrationServicePrivateConnectionTimeoutsOutputReference;
    putTimeouts(value: GoogleDatabaseMigrationServicePrivateConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDatabaseMigrationServicePrivateConnectionTimeouts | undefined;
    private _vpcPeeringConfig;
    get vpcPeeringConfig(): GoogleDatabaseMigrationServicePrivateConnectionVpcPeeringConfigOutputReference;
    putVpcPeeringConfig(value: GoogleDatabaseMigrationServicePrivateConnectionVpcPeeringConfig): void;
    get vpcPeeringConfigInput(): GoogleDatabaseMigrationServicePrivateConnectionVpcPeeringConfig | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
