/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDataflowFlexTemplateJobConfig extends cdktf.TerraformMetaArguments {
    /**
    * List of experiments that should be used by the job. An example value is ["enable_stackdriver_agent_metrics"].
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataflow_flex_template_job#additional_experiments GoogleDataflowFlexTemplateJob#additional_experiments}
    */
    readonly additionalExperiments?: string[];
    /**
    * The algorithm to use for autoscaling
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataflow_flex_template_job#autoscaling_algorithm GoogleDataflowFlexTemplateJob#autoscaling_algorithm}
    */
    readonly autoscalingAlgorithm?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataflow_flex_template_job#container_spec_gcs_path GoogleDataflowFlexTemplateJob#container_spec_gcs_path}
    */
    readonly containerSpecGcsPath: string;
    /**
    * Indicates if the job should use the streaming engine feature.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataflow_flex_template_job#enable_streaming_engine GoogleDataflowFlexTemplateJob#enable_streaming_engine}
    */
    readonly enableStreamingEngine?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataflow_flex_template_job#id GoogleDataflowFlexTemplateJob#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The configuration for VM IPs. Options are "WORKER_IP_PUBLIC" or "WORKER_IP_PRIVATE".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataflow_flex_template_job#ip_configuration GoogleDataflowFlexTemplateJob#ip_configuration}
    */
    readonly ipConfiguration?: string;
    /**
    * The name for the Cloud KMS key for the job. Key format is: projects/PROJECT_ID/locations/LOCATION/keyRings/KEY_RING/cryptoKeys/KEY
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataflow_flex_template_job#kms_key_name GoogleDataflowFlexTemplateJob#kms_key_name}
    */
    readonly kmsKeyName?: string;
    /**
    * User labels to be specified for the job. Keys and values should follow the restrictions specified in the labeling restrictions page. NOTE: This field is non-authoritative, and will only manage the labels present in your configuration.
    * 				Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataflow_flex_template_job#labels GoogleDataflowFlexTemplateJob#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The machine type to use for launching the job. The default is n1-standard-1.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataflow_flex_template_job#launcher_machine_type GoogleDataflowFlexTemplateJob#launcher_machine_type}
    */
    readonly launcherMachineType?: string;
    /**
    * The machine type to use for the job.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataflow_flex_template_job#machine_type GoogleDataflowFlexTemplateJob#machine_type}
    */
    readonly machineType?: string;
    /**
    * The maximum number of Google Compute Engine instances to be made available to your pipeline during execution, from 1 to 1000.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataflow_flex_template_job#max_workers GoogleDataflowFlexTemplateJob#max_workers}
    */
    readonly maxWorkers?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataflow_flex_template_job#name GoogleDataflowFlexTemplateJob#name}
    */
    readonly name: string;
    /**
    * The network to which VMs will be assigned. If it is not provided, "default" will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataflow_flex_template_job#network GoogleDataflowFlexTemplateJob#network}
    */
    readonly network?: string;
    /**
    * The initial number of Google Compute Engine instances for the job.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataflow_flex_template_job#num_workers GoogleDataflowFlexTemplateJob#num_workers}
    */
    readonly numWorkers?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataflow_flex_template_job#on_delete GoogleDataflowFlexTemplateJob#on_delete}
    */
    readonly onDelete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataflow_flex_template_job#parameters GoogleDataflowFlexTemplateJob#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataflow_flex_template_job#project GoogleDataflowFlexTemplateJob#project}
    */
    readonly project?: string;
    /**
    * The region in which the created job should run.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataflow_flex_template_job#region GoogleDataflowFlexTemplateJob#region}
    */
    readonly region?: string;
    /**
    * Docker registry location of container image to use for the 'worker harness. Default is the container for the version of the SDK. Note this field is only valid for portable pipelines.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataflow_flex_template_job#sdk_container_image GoogleDataflowFlexTemplateJob#sdk_container_image}
    */
    readonly sdkContainerImage?: string;
    /**
    * The Service Account email used to create the job.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataflow_flex_template_job#service_account_email GoogleDataflowFlexTemplateJob#service_account_email}
    */
    readonly serviceAccountEmail?: string;
    /**
    * If true, treat DRAINING and CANCELLING as terminal job states and do not wait for further changes before removing from terraform state and moving on. WARNING: this will lead to job name conflicts if you do not ensure that the job names are different, e.g. by embedding a release ID or by using a random_id.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataflow_flex_template_job#skip_wait_on_job_termination GoogleDataflowFlexTemplateJob#skip_wait_on_job_termination}
    */
    readonly skipWaitOnJobTermination?: boolean | cdktf.IResolvable;
    /**
    * The Cloud Storage path to use for staging files. Must be a valid Cloud Storage URL, beginning with gs://.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataflow_flex_template_job#staging_location GoogleDataflowFlexTemplateJob#staging_location}
    */
    readonly stagingLocation?: string;
    /**
    * The subnetwork to which VMs will be assigned. Should be of the form "regions/REGION/subnetworks/SUBNETWORK".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataflow_flex_template_job#subnetwork GoogleDataflowFlexTemplateJob#subnetwork}
    */
    readonly subnetwork?: string;
    /**
    * The Cloud Storage path to use for temporary files. Must be a valid Cloud Storage URL, beginning with gs://.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataflow_flex_template_job#temp_location GoogleDataflowFlexTemplateJob#temp_location}
    */
    readonly tempLocation?: string;
    /**
    * Only applicable when updating a pipeline. Map of transform name prefixes of the job to be replaced with the corresponding name prefixes of the new job.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataflow_flex_template_job#transform_name_mapping GoogleDataflowFlexTemplateJob#transform_name_mapping}
    */
    readonly transformNameMapping?: {
        [key: string]: string;
    };
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataflow_flex_template_job google_dataflow_flex_template_job}
*/
export declare class GoogleDataflowFlexTemplateJob extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dataflow_flex_template_job";
    /**
    * Generates CDKTF code for importing a GoogleDataflowFlexTemplateJob resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleDataflowFlexTemplateJob to import
    * @param importFromId The id of the existing GoogleDataflowFlexTemplateJob that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataflow_flex_template_job#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleDataflowFlexTemplateJob to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataflow_flex_template_job google_dataflow_flex_template_job} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDataflowFlexTemplateJobConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDataflowFlexTemplateJobConfig);
    private _additionalExperiments?;
    get additionalExperiments(): string[];
    set additionalExperiments(value: string[]);
    resetAdditionalExperiments(): void;
    get additionalExperimentsInput(): string[] | undefined;
    private _autoscalingAlgorithm?;
    get autoscalingAlgorithm(): string;
    set autoscalingAlgorithm(value: string);
    resetAutoscalingAlgorithm(): void;
    get autoscalingAlgorithmInput(): string | undefined;
    private _containerSpecGcsPath?;
    get containerSpecGcsPath(): string;
    set containerSpecGcsPath(value: string);
    get containerSpecGcsPathInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _enableStreamingEngine?;
    get enableStreamingEngine(): boolean | cdktf.IResolvable;
    set enableStreamingEngine(value: boolean | cdktf.IResolvable);
    resetEnableStreamingEngine(): void;
    get enableStreamingEngineInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipConfiguration?;
    get ipConfiguration(): string;
    set ipConfiguration(value: string);
    resetIpConfiguration(): void;
    get ipConfigurationInput(): string | undefined;
    get jobId(): string;
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _launcherMachineType?;
    get launcherMachineType(): string;
    set launcherMachineType(value: string);
    resetLauncherMachineType(): void;
    get launcherMachineTypeInput(): string | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _maxWorkers?;
    get maxWorkers(): number;
    set maxWorkers(value: number);
    resetMaxWorkers(): void;
    get maxWorkersInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _numWorkers?;
    get numWorkers(): number;
    set numWorkers(value: number);
    resetNumWorkers(): void;
    get numWorkersInput(): number | undefined;
    private _onDelete?;
    get onDelete(): string;
    set onDelete(value: string);
    resetOnDelete(): void;
    get onDeleteInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _sdkContainerImage?;
    get sdkContainerImage(): string;
    set sdkContainerImage(value: string);
    resetSdkContainerImage(): void;
    get sdkContainerImageInput(): string | undefined;
    private _serviceAccountEmail?;
    get serviceAccountEmail(): string;
    set serviceAccountEmail(value: string);
    resetServiceAccountEmail(): void;
    get serviceAccountEmailInput(): string | undefined;
    private _skipWaitOnJobTermination?;
    get skipWaitOnJobTermination(): boolean | cdktf.IResolvable;
    set skipWaitOnJobTermination(value: boolean | cdktf.IResolvable);
    resetSkipWaitOnJobTermination(): void;
    get skipWaitOnJobTerminationInput(): boolean | cdktf.IResolvable | undefined;
    private _stagingLocation?;
    get stagingLocation(): string;
    set stagingLocation(value: string);
    resetStagingLocation(): void;
    get stagingLocationInput(): string | undefined;
    get state(): string;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    private _tempLocation?;
    get tempLocation(): string;
    set tempLocation(value: string);
    resetTempLocation(): void;
    get tempLocationInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _transformNameMapping?;
    get transformNameMapping(): {
        [key: string]: string;
    };
    set transformNameMapping(value: {
        [key: string]: string;
    });
    resetTransformNameMapping(): void;
    get transformNameMappingInput(): {
        [key: string]: string;
    } | undefined;
    get type(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
