/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDataformRepositoryReleaseConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. Optional schedule (in cron format) for automatic creation of compilation results.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_release_config#cron_schedule GoogleDataformRepositoryReleaseConfig#cron_schedule}
    */
    readonly cronSchedule?: string;
    /**
    * Git commit/tag/branch name at which the repository should be compiled. Must exist in the remote repository.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_release_config#git_commitish GoogleDataformRepositoryReleaseConfig#git_commitish}
    */
    readonly gitCommitish: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_release_config#id GoogleDataformRepositoryReleaseConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The release's name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_release_config#name GoogleDataformRepositoryReleaseConfig#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_release_config#project GoogleDataformRepositoryReleaseConfig#project}
    */
    readonly project?: string;
    /**
    * A reference to the region
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_release_config#region GoogleDataformRepositoryReleaseConfig#region}
    */
    readonly region?: string;
    /**
    * A reference to the Dataform repository
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_release_config#repository GoogleDataformRepositoryReleaseConfig#repository}
    */
    readonly repository?: string;
    /**
    * Optional. Specifies the time zone to be used when interpreting cronSchedule. Must be a time zone name from the time zone database (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left unspecified, the default is UTC.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_release_config#time_zone GoogleDataformRepositoryReleaseConfig#time_zone}
    */
    readonly timeZone?: string;
    /**
    * code_compilation_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_release_config#code_compilation_config GoogleDataformRepositoryReleaseConfig#code_compilation_config}
    */
    readonly codeCompilationConfig?: GoogleDataformRepositoryReleaseConfigCodeCompilationConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_release_config#timeouts GoogleDataformRepositoryReleaseConfig#timeouts}
    */
    readonly timeouts?: GoogleDataformRepositoryReleaseConfigTimeouts;
}
export interface GoogleDataformRepositoryReleaseConfigRecentScheduledReleaseRecordsErrorStatus {
}
export declare function googleDataformRepositoryReleaseConfigRecentScheduledReleaseRecordsErrorStatusToTerraform(struct?: GoogleDataformRepositoryReleaseConfigRecentScheduledReleaseRecordsErrorStatus): any;
export declare function googleDataformRepositoryReleaseConfigRecentScheduledReleaseRecordsErrorStatusToHclTerraform(struct?: GoogleDataformRepositoryReleaseConfigRecentScheduledReleaseRecordsErrorStatus): any;
export declare class GoogleDataformRepositoryReleaseConfigRecentScheduledReleaseRecordsErrorStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataformRepositoryReleaseConfigRecentScheduledReleaseRecordsErrorStatus | undefined;
    set internalValue(value: GoogleDataformRepositoryReleaseConfigRecentScheduledReleaseRecordsErrorStatus | undefined);
    get code(): number;
    get message(): string;
}
export declare class GoogleDataformRepositoryReleaseConfigRecentScheduledReleaseRecordsErrorStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataformRepositoryReleaseConfigRecentScheduledReleaseRecordsErrorStatusOutputReference;
}
export interface GoogleDataformRepositoryReleaseConfigRecentScheduledReleaseRecords {
}
export declare function googleDataformRepositoryReleaseConfigRecentScheduledReleaseRecordsToTerraform(struct?: GoogleDataformRepositoryReleaseConfigRecentScheduledReleaseRecords): any;
export declare function googleDataformRepositoryReleaseConfigRecentScheduledReleaseRecordsToHclTerraform(struct?: GoogleDataformRepositoryReleaseConfigRecentScheduledReleaseRecords): any;
export declare class GoogleDataformRepositoryReleaseConfigRecentScheduledReleaseRecordsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataformRepositoryReleaseConfigRecentScheduledReleaseRecords | undefined;
    set internalValue(value: GoogleDataformRepositoryReleaseConfigRecentScheduledReleaseRecords | undefined);
    get compilationResult(): string;
    private _errorStatus;
    get errorStatus(): GoogleDataformRepositoryReleaseConfigRecentScheduledReleaseRecordsErrorStatusList;
    get releaseTime(): string;
}
export declare class GoogleDataformRepositoryReleaseConfigRecentScheduledReleaseRecordsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataformRepositoryReleaseConfigRecentScheduledReleaseRecordsOutputReference;
}
export interface GoogleDataformRepositoryReleaseConfigCodeCompilationConfig {
    /**
    * Optional. The default schema (BigQuery dataset ID) for assertions.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_release_config#assertion_schema GoogleDataformRepositoryReleaseConfig#assertion_schema}
    */
    readonly assertionSchema?: string;
    /**
    * Optional. The suffix that should be appended to all database (Google Cloud project ID) names.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_release_config#database_suffix GoogleDataformRepositoryReleaseConfig#database_suffix}
    */
    readonly databaseSuffix?: string;
    /**
    * Optional. The default database (Google Cloud project ID).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_release_config#default_database GoogleDataformRepositoryReleaseConfig#default_database}
    */
    readonly defaultDatabase?: string;
    /**
    * Optional. The default BigQuery location to use. Defaults to "US".
    * See the BigQuery docs for a full list of locations: https://cloud.google.com/bigquery/docs/locations.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_release_config#default_location GoogleDataformRepositoryReleaseConfig#default_location}
    */
    readonly defaultLocation?: string;
    /**
    * Optional. The default schema (BigQuery dataset ID).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_release_config#default_schema GoogleDataformRepositoryReleaseConfig#default_schema}
    */
    readonly defaultSchema?: string;
    /**
    * Optional. The suffix that should be appended to all schema (BigQuery dataset ID) names.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_release_config#schema_suffix GoogleDataformRepositoryReleaseConfig#schema_suffix}
    */
    readonly schemaSuffix?: string;
    /**
    * Optional. The prefix that should be prepended to all table names.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_release_config#table_prefix GoogleDataformRepositoryReleaseConfig#table_prefix}
    */
    readonly tablePrefix?: string;
    /**
    * Optional. User-defined variables that are made available to project code during compilation.
    * An object containing a list of "key": value pairs.
    * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_release_config#vars GoogleDataformRepositoryReleaseConfig#vars}
    */
    readonly vars?: {
        [key: string]: string;
    };
}
export declare function googleDataformRepositoryReleaseConfigCodeCompilationConfigToTerraform(struct?: GoogleDataformRepositoryReleaseConfigCodeCompilationConfigOutputReference | GoogleDataformRepositoryReleaseConfigCodeCompilationConfig): any;
export declare function googleDataformRepositoryReleaseConfigCodeCompilationConfigToHclTerraform(struct?: GoogleDataformRepositoryReleaseConfigCodeCompilationConfigOutputReference | GoogleDataformRepositoryReleaseConfigCodeCompilationConfig): any;
export declare class GoogleDataformRepositoryReleaseConfigCodeCompilationConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataformRepositoryReleaseConfigCodeCompilationConfig | undefined;
    set internalValue(value: GoogleDataformRepositoryReleaseConfigCodeCompilationConfig | undefined);
    private _assertionSchema?;
    get assertionSchema(): string;
    set assertionSchema(value: string);
    resetAssertionSchema(): void;
    get assertionSchemaInput(): string | undefined;
    private _databaseSuffix?;
    get databaseSuffix(): string;
    set databaseSuffix(value: string);
    resetDatabaseSuffix(): void;
    get databaseSuffixInput(): string | undefined;
    private _defaultDatabase?;
    get defaultDatabase(): string;
    set defaultDatabase(value: string);
    resetDefaultDatabase(): void;
    get defaultDatabaseInput(): string | undefined;
    private _defaultLocation?;
    get defaultLocation(): string;
    set defaultLocation(value: string);
    resetDefaultLocation(): void;
    get defaultLocationInput(): string | undefined;
    private _defaultSchema?;
    get defaultSchema(): string;
    set defaultSchema(value: string);
    resetDefaultSchema(): void;
    get defaultSchemaInput(): string | undefined;
    private _schemaSuffix?;
    get schemaSuffix(): string;
    set schemaSuffix(value: string);
    resetSchemaSuffix(): void;
    get schemaSuffixInput(): string | undefined;
    private _tablePrefix?;
    get tablePrefix(): string;
    set tablePrefix(value: string);
    resetTablePrefix(): void;
    get tablePrefixInput(): string | undefined;
    private _vars?;
    get vars(): {
        [key: string]: string;
    };
    set vars(value: {
        [key: string]: string;
    });
    resetVars(): void;
    get varsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleDataformRepositoryReleaseConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_release_config#create GoogleDataformRepositoryReleaseConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_release_config#delete GoogleDataformRepositoryReleaseConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_release_config#update GoogleDataformRepositoryReleaseConfig#update}
    */
    readonly update?: string;
}
export declare function googleDataformRepositoryReleaseConfigTimeoutsToTerraform(struct?: GoogleDataformRepositoryReleaseConfigTimeouts | cdktf.IResolvable): any;
export declare function googleDataformRepositoryReleaseConfigTimeoutsToHclTerraform(struct?: GoogleDataformRepositoryReleaseConfigTimeouts | cdktf.IResolvable): any;
export declare class GoogleDataformRepositoryReleaseConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataformRepositoryReleaseConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataformRepositoryReleaseConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_release_config google_dataform_repository_release_config}
*/
export declare class GoogleDataformRepositoryReleaseConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dataform_repository_release_config";
    /**
    * Generates CDKTF code for importing a GoogleDataformRepositoryReleaseConfig resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleDataformRepositoryReleaseConfig to import
    * @param importFromId The id of the existing GoogleDataformRepositoryReleaseConfig that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_release_config#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleDataformRepositoryReleaseConfig to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_release_config google_dataform_repository_release_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDataformRepositoryReleaseConfigConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDataformRepositoryReleaseConfigConfig);
    private _cronSchedule?;
    get cronSchedule(): string;
    set cronSchedule(value: string);
    resetCronSchedule(): void;
    get cronScheduleInput(): string | undefined;
    private _gitCommitish?;
    get gitCommitish(): string;
    set gitCommitish(value: string);
    get gitCommitishInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _recentScheduledReleaseRecords;
    get recentScheduledReleaseRecords(): GoogleDataformRepositoryReleaseConfigRecentScheduledReleaseRecordsList;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _repository?;
    get repository(): string;
    set repository(value: string);
    resetRepository(): void;
    get repositoryInput(): string | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    resetTimeZone(): void;
    get timeZoneInput(): string | undefined;
    private _codeCompilationConfig;
    get codeCompilationConfig(): GoogleDataformRepositoryReleaseConfigCodeCompilationConfigOutputReference;
    putCodeCompilationConfig(value: GoogleDataformRepositoryReleaseConfigCodeCompilationConfig): void;
    resetCodeCompilationConfig(): void;
    get codeCompilationConfigInput(): GoogleDataformRepositoryReleaseConfigCodeCompilationConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleDataformRepositoryReleaseConfigTimeoutsOutputReference;
    putTimeouts(value: GoogleDataformRepositoryReleaseConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDataformRepositoryReleaseConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
