/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDataformRepositoryWorkflowConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. Optional schedule (in cron format) for automatic creation of compilation results.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_workflow_config#cron_schedule GoogleDataformRepositoryWorkflowConfig#cron_schedule}
    */
    readonly cronSchedule?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_workflow_config#id GoogleDataformRepositoryWorkflowConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The workflow's name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_workflow_config#name GoogleDataformRepositoryWorkflowConfig#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_workflow_config#project GoogleDataformRepositoryWorkflowConfig#project}
    */
    readonly project?: string;
    /**
    * A reference to the region
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_workflow_config#region GoogleDataformRepositoryWorkflowConfig#region}
    */
    readonly region?: string;
    /**
    * The name of the release config whose releaseCompilationResult should be executed. Must be in the format projects/* /locations/* /repositories/* /releaseConfigs/*.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_workflow_config#release_config GoogleDataformRepositoryWorkflowConfig#release_config}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly releaseConfig: string;
    /**
    * A reference to the Dataform repository
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_workflow_config#repository GoogleDataformRepositoryWorkflowConfig#repository}
    */
    readonly repository?: string;
    /**
    * Optional. Specifies the time zone to be used when interpreting cronSchedule. Must be a time zone name from the time zone database (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left unspecified, the default is UTC.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_workflow_config#time_zone GoogleDataformRepositoryWorkflowConfig#time_zone}
    */
    readonly timeZone?: string;
    /**
    * invocation_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_workflow_config#invocation_config GoogleDataformRepositoryWorkflowConfig#invocation_config}
    */
    readonly invocationConfig?: GoogleDataformRepositoryWorkflowConfigInvocationConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_workflow_config#timeouts GoogleDataformRepositoryWorkflowConfig#timeouts}
    */
    readonly timeouts?: GoogleDataformRepositoryWorkflowConfigTimeouts;
}
export interface GoogleDataformRepositoryWorkflowConfigRecentScheduledExecutionRecordsErrorStatus {
}
export declare function googleDataformRepositoryWorkflowConfigRecentScheduledExecutionRecordsErrorStatusToTerraform(struct?: GoogleDataformRepositoryWorkflowConfigRecentScheduledExecutionRecordsErrorStatus): any;
export declare function googleDataformRepositoryWorkflowConfigRecentScheduledExecutionRecordsErrorStatusToHclTerraform(struct?: GoogleDataformRepositoryWorkflowConfigRecentScheduledExecutionRecordsErrorStatus): any;
export declare class GoogleDataformRepositoryWorkflowConfigRecentScheduledExecutionRecordsErrorStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataformRepositoryWorkflowConfigRecentScheduledExecutionRecordsErrorStatus | undefined;
    set internalValue(value: GoogleDataformRepositoryWorkflowConfigRecentScheduledExecutionRecordsErrorStatus | undefined);
    get code(): number;
    get message(): string;
}
export declare class GoogleDataformRepositoryWorkflowConfigRecentScheduledExecutionRecordsErrorStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataformRepositoryWorkflowConfigRecentScheduledExecutionRecordsErrorStatusOutputReference;
}
export interface GoogleDataformRepositoryWorkflowConfigRecentScheduledExecutionRecords {
}
export declare function googleDataformRepositoryWorkflowConfigRecentScheduledExecutionRecordsToTerraform(struct?: GoogleDataformRepositoryWorkflowConfigRecentScheduledExecutionRecords): any;
export declare function googleDataformRepositoryWorkflowConfigRecentScheduledExecutionRecordsToHclTerraform(struct?: GoogleDataformRepositoryWorkflowConfigRecentScheduledExecutionRecords): any;
export declare class GoogleDataformRepositoryWorkflowConfigRecentScheduledExecutionRecordsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataformRepositoryWorkflowConfigRecentScheduledExecutionRecords | undefined;
    set internalValue(value: GoogleDataformRepositoryWorkflowConfigRecentScheduledExecutionRecords | undefined);
    private _errorStatus;
    get errorStatus(): GoogleDataformRepositoryWorkflowConfigRecentScheduledExecutionRecordsErrorStatusList;
    get executionTime(): string;
    get workflowInvocation(): string;
}
export declare class GoogleDataformRepositoryWorkflowConfigRecentScheduledExecutionRecordsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataformRepositoryWorkflowConfigRecentScheduledExecutionRecordsOutputReference;
}
export interface GoogleDataformRepositoryWorkflowConfigInvocationConfigIncludedTargets {
    /**
    * The action's database (Google Cloud project ID).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_workflow_config#database GoogleDataformRepositoryWorkflowConfig#database}
    */
    readonly database?: string;
    /**
    * The action's name, within database and schema.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_workflow_config#name GoogleDataformRepositoryWorkflowConfig#name}
    */
    readonly name?: string;
    /**
    * The action's schema (BigQuery dataset ID), within database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_workflow_config#schema GoogleDataformRepositoryWorkflowConfig#schema}
    */
    readonly schema?: string;
}
export declare function googleDataformRepositoryWorkflowConfigInvocationConfigIncludedTargetsToTerraform(struct?: GoogleDataformRepositoryWorkflowConfigInvocationConfigIncludedTargets | cdktf.IResolvable): any;
export declare function googleDataformRepositoryWorkflowConfigInvocationConfigIncludedTargetsToHclTerraform(struct?: GoogleDataformRepositoryWorkflowConfigInvocationConfigIncludedTargets | cdktf.IResolvable): any;
export declare class GoogleDataformRepositoryWorkflowConfigInvocationConfigIncludedTargetsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataformRepositoryWorkflowConfigInvocationConfigIncludedTargets | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataformRepositoryWorkflowConfigInvocationConfigIncludedTargets | cdktf.IResolvable | undefined);
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
}
export declare class GoogleDataformRepositoryWorkflowConfigInvocationConfigIncludedTargetsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDataformRepositoryWorkflowConfigInvocationConfigIncludedTargets[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataformRepositoryWorkflowConfigInvocationConfigIncludedTargetsOutputReference;
}
export interface GoogleDataformRepositoryWorkflowConfigInvocationConfig {
    /**
    * Optional. When set to true, any incremental tables will be fully refreshed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_workflow_config#fully_refresh_incremental_tables_enabled GoogleDataformRepositoryWorkflowConfig#fully_refresh_incremental_tables_enabled}
    */
    readonly fullyRefreshIncrementalTablesEnabled?: boolean | cdktf.IResolvable;
    /**
    * Optional. The set of tags to include.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_workflow_config#included_tags GoogleDataformRepositoryWorkflowConfig#included_tags}
    */
    readonly includedTags?: string[];
    /**
    * Optional. The service account to run workflow invocations under.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_workflow_config#service_account GoogleDataformRepositoryWorkflowConfig#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * Optional. When set to true, transitive dependencies of included actions will be executed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_workflow_config#transitive_dependencies_included GoogleDataformRepositoryWorkflowConfig#transitive_dependencies_included}
    */
    readonly transitiveDependenciesIncluded?: boolean | cdktf.IResolvable;
    /**
    * Optional. When set to true, transitive dependents of included actions will be executed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_workflow_config#transitive_dependents_included GoogleDataformRepositoryWorkflowConfig#transitive_dependents_included}
    */
    readonly transitiveDependentsIncluded?: boolean | cdktf.IResolvable;
    /**
    * included_targets block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_workflow_config#included_targets GoogleDataformRepositoryWorkflowConfig#included_targets}
    */
    readonly includedTargets?: GoogleDataformRepositoryWorkflowConfigInvocationConfigIncludedTargets[] | cdktf.IResolvable;
}
export declare function googleDataformRepositoryWorkflowConfigInvocationConfigToTerraform(struct?: GoogleDataformRepositoryWorkflowConfigInvocationConfigOutputReference | GoogleDataformRepositoryWorkflowConfigInvocationConfig): any;
export declare function googleDataformRepositoryWorkflowConfigInvocationConfigToHclTerraform(struct?: GoogleDataformRepositoryWorkflowConfigInvocationConfigOutputReference | GoogleDataformRepositoryWorkflowConfigInvocationConfig): any;
export declare class GoogleDataformRepositoryWorkflowConfigInvocationConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataformRepositoryWorkflowConfigInvocationConfig | undefined;
    set internalValue(value: GoogleDataformRepositoryWorkflowConfigInvocationConfig | undefined);
    private _fullyRefreshIncrementalTablesEnabled?;
    get fullyRefreshIncrementalTablesEnabled(): boolean | cdktf.IResolvable;
    set fullyRefreshIncrementalTablesEnabled(value: boolean | cdktf.IResolvable);
    resetFullyRefreshIncrementalTablesEnabled(): void;
    get fullyRefreshIncrementalTablesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _includedTags?;
    get includedTags(): string[];
    set includedTags(value: string[]);
    resetIncludedTags(): void;
    get includedTagsInput(): string[] | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _transitiveDependenciesIncluded?;
    get transitiveDependenciesIncluded(): boolean | cdktf.IResolvable;
    set transitiveDependenciesIncluded(value: boolean | cdktf.IResolvable);
    resetTransitiveDependenciesIncluded(): void;
    get transitiveDependenciesIncludedInput(): boolean | cdktf.IResolvable | undefined;
    private _transitiveDependentsIncluded?;
    get transitiveDependentsIncluded(): boolean | cdktf.IResolvable;
    set transitiveDependentsIncluded(value: boolean | cdktf.IResolvable);
    resetTransitiveDependentsIncluded(): void;
    get transitiveDependentsIncludedInput(): boolean | cdktf.IResolvable | undefined;
    private _includedTargets;
    get includedTargets(): GoogleDataformRepositoryWorkflowConfigInvocationConfigIncludedTargetsList;
    putIncludedTargets(value: GoogleDataformRepositoryWorkflowConfigInvocationConfigIncludedTargets[] | cdktf.IResolvable): void;
    resetIncludedTargets(): void;
    get includedTargetsInput(): cdktf.IResolvable | GoogleDataformRepositoryWorkflowConfigInvocationConfigIncludedTargets[] | undefined;
}
export interface GoogleDataformRepositoryWorkflowConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_workflow_config#create GoogleDataformRepositoryWorkflowConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_workflow_config#delete GoogleDataformRepositoryWorkflowConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_workflow_config#update GoogleDataformRepositoryWorkflowConfig#update}
    */
    readonly update?: string;
}
export declare function googleDataformRepositoryWorkflowConfigTimeoutsToTerraform(struct?: GoogleDataformRepositoryWorkflowConfigTimeouts | cdktf.IResolvable): any;
export declare function googleDataformRepositoryWorkflowConfigTimeoutsToHclTerraform(struct?: GoogleDataformRepositoryWorkflowConfigTimeouts | cdktf.IResolvable): any;
export declare class GoogleDataformRepositoryWorkflowConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataformRepositoryWorkflowConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataformRepositoryWorkflowConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_workflow_config google_dataform_repository_workflow_config}
*/
export declare class GoogleDataformRepositoryWorkflowConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dataform_repository_workflow_config";
    /**
    * Generates CDKTF code for importing a GoogleDataformRepositoryWorkflowConfig resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleDataformRepositoryWorkflowConfig to import
    * @param importFromId The id of the existing GoogleDataformRepositoryWorkflowConfig that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_workflow_config#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleDataformRepositoryWorkflowConfig to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository_workflow_config google_dataform_repository_workflow_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDataformRepositoryWorkflowConfigConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDataformRepositoryWorkflowConfigConfig);
    private _cronSchedule?;
    get cronSchedule(): string;
    set cronSchedule(value: string);
    resetCronSchedule(): void;
    get cronScheduleInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _recentScheduledExecutionRecords;
    get recentScheduledExecutionRecords(): GoogleDataformRepositoryWorkflowConfigRecentScheduledExecutionRecordsList;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _releaseConfig?;
    get releaseConfig(): string;
    set releaseConfig(value: string);
    get releaseConfigInput(): string | undefined;
    private _repository?;
    get repository(): string;
    set repository(value: string);
    resetRepository(): void;
    get repositoryInput(): string | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    resetTimeZone(): void;
    get timeZoneInput(): string | undefined;
    private _invocationConfig;
    get invocationConfig(): GoogleDataformRepositoryWorkflowConfigInvocationConfigOutputReference;
    putInvocationConfig(value: GoogleDataformRepositoryWorkflowConfigInvocationConfig): void;
    resetInvocationConfig(): void;
    get invocationConfigInput(): GoogleDataformRepositoryWorkflowConfigInvocationConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleDataformRepositoryWorkflowConfigTimeoutsOutputReference;
    putTimeouts(value: GoogleDataformRepositoryWorkflowConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDataformRepositoryWorkflowConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
