/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDataformRepositoryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. The repository's user-friendly name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository#display_name GoogleDataformRepository#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository#id GoogleDataformRepository#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Optional. Repository user labels.
    * An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository#labels GoogleDataformRepository#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The repository's name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository#name GoogleDataformRepository#name}
    */
    readonly name: string;
    /**
    * Optional. The name of the Secret Manager secret version to be used to interpolate variables into the .npmrc file for package installation operations. Must be in the format projects/* /secrets/* /versions/*. The file itself must be in a JSON format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository#npmrc_environment_variables_secret_version GoogleDataformRepository#npmrc_environment_variables_secret_version}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly npmrcEnvironmentVariablesSecretVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository#project GoogleDataformRepository#project}
    */
    readonly project?: string;
    /**
    * A reference to the region
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository#region GoogleDataformRepository#region}
    */
    readonly region?: string;
    /**
    * The service account to run workflow invocations under.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository#service_account GoogleDataformRepository#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * git_remote_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository#git_remote_settings GoogleDataformRepository#git_remote_settings}
    */
    readonly gitRemoteSettings?: GoogleDataformRepositoryGitRemoteSettings;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository#timeouts GoogleDataformRepository#timeouts}
    */
    readonly timeouts?: GoogleDataformRepositoryTimeouts;
    /**
    * workspace_compilation_overrides block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository#workspace_compilation_overrides GoogleDataformRepository#workspace_compilation_overrides}
    */
    readonly workspaceCompilationOverrides?: GoogleDataformRepositoryWorkspaceCompilationOverrides;
}
export interface GoogleDataformRepositoryGitRemoteSettingsSshAuthenticationConfig {
    /**
    * Content of a public SSH key to verify an identity of a remote Git host.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository#host_public_key GoogleDataformRepository#host_public_key}
    */
    readonly hostPublicKey: string;
    /**
    * The name of the Secret Manager secret version to use as a ssh private key for Git operations. Must be in the format projects/* /secrets/* /versions/*.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository#user_private_key_secret_version GoogleDataformRepository#user_private_key_secret_version}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly userPrivateKeySecretVersion: string;
}
export declare function googleDataformRepositoryGitRemoteSettingsSshAuthenticationConfigToTerraform(struct?: GoogleDataformRepositoryGitRemoteSettingsSshAuthenticationConfigOutputReference | GoogleDataformRepositoryGitRemoteSettingsSshAuthenticationConfig): any;
export declare function googleDataformRepositoryGitRemoteSettingsSshAuthenticationConfigToHclTerraform(struct?: GoogleDataformRepositoryGitRemoteSettingsSshAuthenticationConfigOutputReference | GoogleDataformRepositoryGitRemoteSettingsSshAuthenticationConfig): any;
export declare class GoogleDataformRepositoryGitRemoteSettingsSshAuthenticationConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataformRepositoryGitRemoteSettingsSshAuthenticationConfig | undefined;
    set internalValue(value: GoogleDataformRepositoryGitRemoteSettingsSshAuthenticationConfig | undefined);
    private _hostPublicKey?;
    get hostPublicKey(): string;
    set hostPublicKey(value: string);
    get hostPublicKeyInput(): string | undefined;
    private _userPrivateKeySecretVersion?;
    get userPrivateKeySecretVersion(): string;
    set userPrivateKeySecretVersion(value: string);
    get userPrivateKeySecretVersionInput(): string | undefined;
}
export interface GoogleDataformRepositoryGitRemoteSettings {
    /**
    * The name of the Secret Manager secret version to use as an authentication token for Git operations. This secret is for assigning with HTTPS only(for SSH use 'ssh_authentication_config'). Must be in the format projects/* /secrets/* /versions/*.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository#authentication_token_secret_version GoogleDataformRepository#authentication_token_secret_version}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly authenticationTokenSecretVersion?: string;
    /**
    * The Git remote's default branch name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository#default_branch GoogleDataformRepository#default_branch}
    */
    readonly defaultBranch: string;
    /**
    * The Git remote's URL.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository#url GoogleDataformRepository#url}
    */
    readonly url: string;
    /**
    * ssh_authentication_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository#ssh_authentication_config GoogleDataformRepository#ssh_authentication_config}
    */
    readonly sshAuthenticationConfig?: GoogleDataformRepositoryGitRemoteSettingsSshAuthenticationConfig;
}
export declare function googleDataformRepositoryGitRemoteSettingsToTerraform(struct?: GoogleDataformRepositoryGitRemoteSettingsOutputReference | GoogleDataformRepositoryGitRemoteSettings): any;
export declare function googleDataformRepositoryGitRemoteSettingsToHclTerraform(struct?: GoogleDataformRepositoryGitRemoteSettingsOutputReference | GoogleDataformRepositoryGitRemoteSettings): any;
export declare class GoogleDataformRepositoryGitRemoteSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataformRepositoryGitRemoteSettings | undefined;
    set internalValue(value: GoogleDataformRepositoryGitRemoteSettings | undefined);
    private _authenticationTokenSecretVersion?;
    get authenticationTokenSecretVersion(): string;
    set authenticationTokenSecretVersion(value: string);
    resetAuthenticationTokenSecretVersion(): void;
    get authenticationTokenSecretVersionInput(): string | undefined;
    private _defaultBranch?;
    get defaultBranch(): string;
    set defaultBranch(value: string);
    get defaultBranchInput(): string | undefined;
    get tokenStatus(): string;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    private _sshAuthenticationConfig;
    get sshAuthenticationConfig(): GoogleDataformRepositoryGitRemoteSettingsSshAuthenticationConfigOutputReference;
    putSshAuthenticationConfig(value: GoogleDataformRepositoryGitRemoteSettingsSshAuthenticationConfig): void;
    resetSshAuthenticationConfig(): void;
    get sshAuthenticationConfigInput(): GoogleDataformRepositoryGitRemoteSettingsSshAuthenticationConfig | undefined;
}
export interface GoogleDataformRepositoryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository#create GoogleDataformRepository#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository#delete GoogleDataformRepository#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository#update GoogleDataformRepository#update}
    */
    readonly update?: string;
}
export declare function googleDataformRepositoryTimeoutsToTerraform(struct?: GoogleDataformRepositoryTimeouts | cdktf.IResolvable): any;
export declare function googleDataformRepositoryTimeoutsToHclTerraform(struct?: GoogleDataformRepositoryTimeouts | cdktf.IResolvable): any;
export declare class GoogleDataformRepositoryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataformRepositoryTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataformRepositoryTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleDataformRepositoryWorkspaceCompilationOverrides {
    /**
    * The default database (Google Cloud project ID).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository#default_database GoogleDataformRepository#default_database}
    */
    readonly defaultDatabase?: string;
    /**
    * The suffix that should be appended to all schema (BigQuery dataset ID) names.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository#schema_suffix GoogleDataformRepository#schema_suffix}
    */
    readonly schemaSuffix?: string;
    /**
    * The prefix that should be prepended to all table names.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository#table_prefix GoogleDataformRepository#table_prefix}
    */
    readonly tablePrefix?: string;
}
export declare function googleDataformRepositoryWorkspaceCompilationOverridesToTerraform(struct?: GoogleDataformRepositoryWorkspaceCompilationOverridesOutputReference | GoogleDataformRepositoryWorkspaceCompilationOverrides): any;
export declare function googleDataformRepositoryWorkspaceCompilationOverridesToHclTerraform(struct?: GoogleDataformRepositoryWorkspaceCompilationOverridesOutputReference | GoogleDataformRepositoryWorkspaceCompilationOverrides): any;
export declare class GoogleDataformRepositoryWorkspaceCompilationOverridesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataformRepositoryWorkspaceCompilationOverrides | undefined;
    set internalValue(value: GoogleDataformRepositoryWorkspaceCompilationOverrides | undefined);
    private _defaultDatabase?;
    get defaultDatabase(): string;
    set defaultDatabase(value: string);
    resetDefaultDatabase(): void;
    get defaultDatabaseInput(): string | undefined;
    private _schemaSuffix?;
    get schemaSuffix(): string;
    set schemaSuffix(value: string);
    resetSchemaSuffix(): void;
    get schemaSuffixInput(): string | undefined;
    private _tablePrefix?;
    get tablePrefix(): string;
    set tablePrefix(value: string);
    resetTablePrefix(): void;
    get tablePrefixInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository google_dataform_repository}
*/
export declare class GoogleDataformRepository extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dataform_repository";
    /**
    * Generates CDKTF code for importing a GoogleDataformRepository resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleDataformRepository to import
    * @param importFromId The id of the existing GoogleDataformRepository that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleDataformRepository to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataform_repository google_dataform_repository} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDataformRepositoryConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDataformRepositoryConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _npmrcEnvironmentVariablesSecretVersion?;
    get npmrcEnvironmentVariablesSecretVersion(): string;
    set npmrcEnvironmentVariablesSecretVersion(value: string);
    resetNpmrcEnvironmentVariablesSecretVersion(): void;
    get npmrcEnvironmentVariablesSecretVersionInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _gitRemoteSettings;
    get gitRemoteSettings(): GoogleDataformRepositoryGitRemoteSettingsOutputReference;
    putGitRemoteSettings(value: GoogleDataformRepositoryGitRemoteSettings): void;
    resetGitRemoteSettings(): void;
    get gitRemoteSettingsInput(): GoogleDataformRepositoryGitRemoteSettings | undefined;
    private _timeouts;
    get timeouts(): GoogleDataformRepositoryTimeoutsOutputReference;
    putTimeouts(value: GoogleDataformRepositoryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDataformRepositoryTimeouts | undefined;
    private _workspaceCompilationOverrides;
    get workspaceCompilationOverrides(): GoogleDataformRepositoryWorkspaceCompilationOverridesOutputReference;
    putWorkspaceCompilationOverrides(value: GoogleDataformRepositoryWorkspaceCompilationOverrides): void;
    resetWorkspaceCompilationOverrides(): void;
    get workspaceCompilationOverridesInput(): GoogleDataformRepositoryWorkspaceCompilationOverrides | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
