/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDataplexAssetConfig extends cdktf.TerraformMetaArguments {
    /**
    * The zone for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#dataplex_zone GoogleDataplexAsset#dataplex_zone}
    */
    readonly dataplexZone: string;
    /**
    * Optional. Description of the asset.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#description GoogleDataplexAsset#description}
    */
    readonly description?: string;
    /**
    * Optional. User friendly display name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#display_name GoogleDataplexAsset#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#id GoogleDataplexAsset#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Optional. User defined labels for the asset.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field `effective_labels` for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#labels GoogleDataplexAsset#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The lake for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#lake GoogleDataplexAsset#lake}
    */
    readonly lake: string;
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#location GoogleDataplexAsset#location}
    */
    readonly location: string;
    /**
    * The name of the asset.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#name GoogleDataplexAsset#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#project GoogleDataplexAsset#project}
    */
    readonly project?: string;
    /**
    * discovery_spec block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#discovery_spec GoogleDataplexAsset#discovery_spec}
    */
    readonly discoverySpec: GoogleDataplexAssetDiscoverySpec;
    /**
    * resource_spec block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#resource_spec GoogleDataplexAsset#resource_spec}
    */
    readonly resourceSpec: GoogleDataplexAssetResourceSpec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#timeouts GoogleDataplexAsset#timeouts}
    */
    readonly timeouts?: GoogleDataplexAssetTimeouts;
}
export interface GoogleDataplexAssetDiscoveryStatusStats {
}
export declare function googleDataplexAssetDiscoveryStatusStatsToTerraform(struct?: GoogleDataplexAssetDiscoveryStatusStats): any;
export declare function googleDataplexAssetDiscoveryStatusStatsToHclTerraform(struct?: GoogleDataplexAssetDiscoveryStatusStats): any;
export declare class GoogleDataplexAssetDiscoveryStatusStatsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataplexAssetDiscoveryStatusStats | undefined;
    set internalValue(value: GoogleDataplexAssetDiscoveryStatusStats | undefined);
    get dataItems(): number;
    get dataSize(): number;
    get filesets(): number;
    get tables(): number;
}
export declare class GoogleDataplexAssetDiscoveryStatusStatsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataplexAssetDiscoveryStatusStatsOutputReference;
}
export interface GoogleDataplexAssetDiscoveryStatus {
}
export declare function googleDataplexAssetDiscoveryStatusToTerraform(struct?: GoogleDataplexAssetDiscoveryStatus): any;
export declare function googleDataplexAssetDiscoveryStatusToHclTerraform(struct?: GoogleDataplexAssetDiscoveryStatus): any;
export declare class GoogleDataplexAssetDiscoveryStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataplexAssetDiscoveryStatus | undefined;
    set internalValue(value: GoogleDataplexAssetDiscoveryStatus | undefined);
    get lastRunDuration(): string;
    get lastRunTime(): string;
    get message(): string;
    get state(): string;
    private _stats;
    get stats(): GoogleDataplexAssetDiscoveryStatusStatsList;
    get updateTime(): string;
}
export declare class GoogleDataplexAssetDiscoveryStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataplexAssetDiscoveryStatusOutputReference;
}
export interface GoogleDataplexAssetResourceStatus {
}
export declare function googleDataplexAssetResourceStatusToTerraform(struct?: GoogleDataplexAssetResourceStatus): any;
export declare function googleDataplexAssetResourceStatusToHclTerraform(struct?: GoogleDataplexAssetResourceStatus): any;
export declare class GoogleDataplexAssetResourceStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataplexAssetResourceStatus | undefined;
    set internalValue(value: GoogleDataplexAssetResourceStatus | undefined);
    get message(): string;
    get state(): string;
    get updateTime(): string;
}
export declare class GoogleDataplexAssetResourceStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataplexAssetResourceStatusOutputReference;
}
export interface GoogleDataplexAssetSecurityStatus {
}
export declare function googleDataplexAssetSecurityStatusToTerraform(struct?: GoogleDataplexAssetSecurityStatus): any;
export declare function googleDataplexAssetSecurityStatusToHclTerraform(struct?: GoogleDataplexAssetSecurityStatus): any;
export declare class GoogleDataplexAssetSecurityStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataplexAssetSecurityStatus | undefined;
    set internalValue(value: GoogleDataplexAssetSecurityStatus | undefined);
    get message(): string;
    get state(): string;
    get updateTime(): string;
}
export declare class GoogleDataplexAssetSecurityStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataplexAssetSecurityStatusOutputReference;
}
export interface GoogleDataplexAssetDiscoverySpecCsvOptions {
    /**
    * Optional. The delimiter being used to separate values. This defaults to ','.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#delimiter GoogleDataplexAsset#delimiter}
    */
    readonly delimiter?: string;
    /**
    * Optional. Whether to disable the inference of data type for CSV data. If true, all columns will be registered as strings.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#disable_type_inference GoogleDataplexAsset#disable_type_inference}
    */
    readonly disableTypeInference?: boolean | cdktf.IResolvable;
    /**
    * Optional. The character encoding of the data. The default is UTF-8.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#encoding GoogleDataplexAsset#encoding}
    */
    readonly encoding?: string;
    /**
    * Optional. The number of rows to interpret as header rows that should be skipped when reading data rows.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#header_rows GoogleDataplexAsset#header_rows}
    */
    readonly headerRows?: number;
}
export declare function googleDataplexAssetDiscoverySpecCsvOptionsToTerraform(struct?: GoogleDataplexAssetDiscoverySpecCsvOptionsOutputReference | GoogleDataplexAssetDiscoverySpecCsvOptions): any;
export declare function googleDataplexAssetDiscoverySpecCsvOptionsToHclTerraform(struct?: GoogleDataplexAssetDiscoverySpecCsvOptionsOutputReference | GoogleDataplexAssetDiscoverySpecCsvOptions): any;
export declare class GoogleDataplexAssetDiscoverySpecCsvOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexAssetDiscoverySpecCsvOptions | undefined;
    set internalValue(value: GoogleDataplexAssetDiscoverySpecCsvOptions | undefined);
    private _delimiter?;
    get delimiter(): string;
    set delimiter(value: string);
    resetDelimiter(): void;
    get delimiterInput(): string | undefined;
    private _disableTypeInference?;
    get disableTypeInference(): boolean | cdktf.IResolvable;
    set disableTypeInference(value: boolean | cdktf.IResolvable);
    resetDisableTypeInference(): void;
    get disableTypeInferenceInput(): boolean | cdktf.IResolvable | undefined;
    private _encoding?;
    get encoding(): string;
    set encoding(value: string);
    resetEncoding(): void;
    get encodingInput(): string | undefined;
    private _headerRows?;
    get headerRows(): number;
    set headerRows(value: number);
    resetHeaderRows(): void;
    get headerRowsInput(): number | undefined;
}
export interface GoogleDataplexAssetDiscoverySpecJsonOptions {
    /**
    * Optional. Whether to disable the inference of data type for Json data. If true, all columns will be registered as their primitive types (strings, number or boolean).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#disable_type_inference GoogleDataplexAsset#disable_type_inference}
    */
    readonly disableTypeInference?: boolean | cdktf.IResolvable;
    /**
    * Optional. The character encoding of the data. The default is UTF-8.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#encoding GoogleDataplexAsset#encoding}
    */
    readonly encoding?: string;
}
export declare function googleDataplexAssetDiscoverySpecJsonOptionsToTerraform(struct?: GoogleDataplexAssetDiscoverySpecJsonOptionsOutputReference | GoogleDataplexAssetDiscoverySpecJsonOptions): any;
export declare function googleDataplexAssetDiscoverySpecJsonOptionsToHclTerraform(struct?: GoogleDataplexAssetDiscoverySpecJsonOptionsOutputReference | GoogleDataplexAssetDiscoverySpecJsonOptions): any;
export declare class GoogleDataplexAssetDiscoverySpecJsonOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexAssetDiscoverySpecJsonOptions | undefined;
    set internalValue(value: GoogleDataplexAssetDiscoverySpecJsonOptions | undefined);
    private _disableTypeInference?;
    get disableTypeInference(): boolean | cdktf.IResolvable;
    set disableTypeInference(value: boolean | cdktf.IResolvable);
    resetDisableTypeInference(): void;
    get disableTypeInferenceInput(): boolean | cdktf.IResolvable | undefined;
    private _encoding?;
    get encoding(): string;
    set encoding(value: string);
    resetEncoding(): void;
    get encodingInput(): string | undefined;
}
export interface GoogleDataplexAssetDiscoverySpec {
    /**
    * Required. Whether discovery is enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#enabled GoogleDataplexAsset#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Optional. The list of patterns to apply for selecting data to exclude during discovery. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#exclude_patterns GoogleDataplexAsset#exclude_patterns}
    */
    readonly excludePatterns?: string[];
    /**
    * Optional. The list of patterns to apply for selecting data to include during discovery if only a subset of the data should considered. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#include_patterns GoogleDataplexAsset#include_patterns}
    */
    readonly includePatterns?: string[];
    /**
    * Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for running discovery periodically. Successive discovery runs must be scheduled at least 60 minutes apart. The default value is to run discovery every 60 minutes. To explicitly set a timezone to the cron tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone database. For example, "CRON_TZ=America/New_York 1 * * * *", or "TZ=America/New_York 1 * * * *".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#schedule GoogleDataplexAsset#schedule}
    */
    readonly schedule?: string;
    /**
    * csv_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#csv_options GoogleDataplexAsset#csv_options}
    */
    readonly csvOptions?: GoogleDataplexAssetDiscoverySpecCsvOptions;
    /**
    * json_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#json_options GoogleDataplexAsset#json_options}
    */
    readonly jsonOptions?: GoogleDataplexAssetDiscoverySpecJsonOptions;
}
export declare function googleDataplexAssetDiscoverySpecToTerraform(struct?: GoogleDataplexAssetDiscoverySpecOutputReference | GoogleDataplexAssetDiscoverySpec): any;
export declare function googleDataplexAssetDiscoverySpecToHclTerraform(struct?: GoogleDataplexAssetDiscoverySpecOutputReference | GoogleDataplexAssetDiscoverySpec): any;
export declare class GoogleDataplexAssetDiscoverySpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexAssetDiscoverySpec | undefined;
    set internalValue(value: GoogleDataplexAssetDiscoverySpec | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _excludePatterns?;
    get excludePatterns(): string[];
    set excludePatterns(value: string[]);
    resetExcludePatterns(): void;
    get excludePatternsInput(): string[] | undefined;
    private _includePatterns?;
    get includePatterns(): string[];
    set includePatterns(value: string[]);
    resetIncludePatterns(): void;
    get includePatternsInput(): string[] | undefined;
    private _schedule?;
    get schedule(): string;
    set schedule(value: string);
    resetSchedule(): void;
    get scheduleInput(): string | undefined;
    private _csvOptions;
    get csvOptions(): GoogleDataplexAssetDiscoverySpecCsvOptionsOutputReference;
    putCsvOptions(value: GoogleDataplexAssetDiscoverySpecCsvOptions): void;
    resetCsvOptions(): void;
    get csvOptionsInput(): GoogleDataplexAssetDiscoverySpecCsvOptions | undefined;
    private _jsonOptions;
    get jsonOptions(): GoogleDataplexAssetDiscoverySpecJsonOptionsOutputReference;
    putJsonOptions(value: GoogleDataplexAssetDiscoverySpecJsonOptions): void;
    resetJsonOptions(): void;
    get jsonOptionsInput(): GoogleDataplexAssetDiscoverySpecJsonOptions | undefined;
}
export interface GoogleDataplexAssetResourceSpec {
    /**
    * Immutable. Relative name of the cloud resource that contains the data that is being managed within a lake. For example: `projects/{project_number}/buckets/{bucket_id}` `projects/{project_number}/datasets/{dataset_id}`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#name GoogleDataplexAsset#name}
    */
    readonly name?: string;
    /**
    * Optional. Determines how read permissions are handled for each asset and their associated tables. Only available to storage buckets assets. Possible values: DIRECT, MANAGED
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#read_access_mode GoogleDataplexAsset#read_access_mode}
    */
    readonly readAccessMode?: string;
    /**
    * Required. Immutable. Type of resource. Possible values: STORAGE_BUCKET, BIGQUERY_DATASET
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#type GoogleDataplexAsset#type}
    */
    readonly type: string;
}
export declare function googleDataplexAssetResourceSpecToTerraform(struct?: GoogleDataplexAssetResourceSpecOutputReference | GoogleDataplexAssetResourceSpec): any;
export declare function googleDataplexAssetResourceSpecToHclTerraform(struct?: GoogleDataplexAssetResourceSpecOutputReference | GoogleDataplexAssetResourceSpec): any;
export declare class GoogleDataplexAssetResourceSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexAssetResourceSpec | undefined;
    set internalValue(value: GoogleDataplexAssetResourceSpec | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _readAccessMode?;
    get readAccessMode(): string;
    set readAccessMode(value: string);
    resetReadAccessMode(): void;
    get readAccessModeInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface GoogleDataplexAssetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#create GoogleDataplexAsset#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#delete GoogleDataplexAsset#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#update GoogleDataplexAsset#update}
    */
    readonly update?: string;
}
export declare function googleDataplexAssetTimeoutsToTerraform(struct?: GoogleDataplexAssetTimeouts | cdktf.IResolvable): any;
export declare function googleDataplexAssetTimeoutsToHclTerraform(struct?: GoogleDataplexAssetTimeouts | cdktf.IResolvable): any;
export declare class GoogleDataplexAssetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexAssetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataplexAssetTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset google_dataplex_asset}
*/
export declare class GoogleDataplexAsset extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dataplex_asset";
    /**
    * Generates CDKTF code for importing a GoogleDataplexAsset resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleDataplexAsset to import
    * @param importFromId The id of the existing GoogleDataplexAsset that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleDataplexAsset to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_asset google_dataplex_asset} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDataplexAssetConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDataplexAssetConfig);
    get createTime(): string;
    private _dataplexZone?;
    get dataplexZone(): string;
    set dataplexZone(value: string);
    get dataplexZoneInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _discoveryStatus;
    get discoveryStatus(): GoogleDataplexAssetDiscoveryStatusList;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _lake?;
    get lake(): string;
    set lake(value: string);
    get lakeInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _resourceStatus;
    get resourceStatus(): GoogleDataplexAssetResourceStatusList;
    private _securityStatus;
    get securityStatus(): GoogleDataplexAssetSecurityStatusList;
    get state(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get uid(): string;
    get updateTime(): string;
    private _discoverySpec;
    get discoverySpec(): GoogleDataplexAssetDiscoverySpecOutputReference;
    putDiscoverySpec(value: GoogleDataplexAssetDiscoverySpec): void;
    get discoverySpecInput(): GoogleDataplexAssetDiscoverySpec | undefined;
    private _resourceSpec;
    get resourceSpec(): GoogleDataplexAssetResourceSpecOutputReference;
    putResourceSpec(value: GoogleDataplexAssetResourceSpec): void;
    get resourceSpecInput(): GoogleDataplexAssetResourceSpec | undefined;
    private _timeouts;
    get timeouts(): GoogleDataplexAssetTimeoutsOutputReference;
    putTimeouts(value: GoogleDataplexAssetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDataplexAssetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
