/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDataplexDatascanConfig extends cdktf.TerraformMetaArguments {
    /**
    * DataScan identifier. Must contain only lowercase letters, numbers and hyphens. Must start with a letter. Must end with a number or a letter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#data_scan_id GoogleDataplexDatascan#data_scan_id}
    */
    readonly dataScanId: string;
    /**
    * Description of the scan.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#description GoogleDataplexDatascan#description}
    */
    readonly description?: string;
    /**
    * User friendly display name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#display_name GoogleDataplexDatascan#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#id GoogleDataplexDatascan#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * User-defined labels for the scan. A list of key->value pairs.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#labels GoogleDataplexDatascan#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location where the data scan should reside.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#location GoogleDataplexDatascan#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#project GoogleDataplexDatascan#project}
    */
    readonly project?: string;
    /**
    * data block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#data GoogleDataplexDatascan#data}
    */
    readonly data: GoogleDataplexDatascanData;
    /**
    * data_profile_spec block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#data_profile_spec GoogleDataplexDatascan#data_profile_spec}
    */
    readonly dataProfileSpec?: GoogleDataplexDatascanDataProfileSpec;
    /**
    * data_quality_spec block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#data_quality_spec GoogleDataplexDatascan#data_quality_spec}
    */
    readonly dataQualitySpec?: GoogleDataplexDatascanDataQualitySpec;
    /**
    * execution_spec block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#execution_spec GoogleDataplexDatascan#execution_spec}
    */
    readonly executionSpec: GoogleDataplexDatascanExecutionSpec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#timeouts GoogleDataplexDatascan#timeouts}
    */
    readonly timeouts?: GoogleDataplexDatascanTimeouts;
}
export interface GoogleDataplexDatascanExecutionStatus {
}
export declare function googleDataplexDatascanExecutionStatusToTerraform(struct?: GoogleDataplexDatascanExecutionStatus): any;
export declare function googleDataplexDatascanExecutionStatusToHclTerraform(struct?: GoogleDataplexDatascanExecutionStatus): any;
export declare class GoogleDataplexDatascanExecutionStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataplexDatascanExecutionStatus | undefined;
    set internalValue(value: GoogleDataplexDatascanExecutionStatus | undefined);
    get latestJobEndTime(): string;
    get latestJobStartTime(): string;
}
export declare class GoogleDataplexDatascanExecutionStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataplexDatascanExecutionStatusOutputReference;
}
export interface GoogleDataplexDatascanData {
    /**
    * The Dataplex entity that represents the data source(e.g. BigQuery table) for Datascan.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#entity GoogleDataplexDatascan#entity}
    */
    readonly entity?: string;
    /**
    * The service-qualified full resource name of the cloud resource for a DataScan job to scan against. The field could be:
    * (Cloud Storage bucket for DataDiscoveryScan)BigQuery table of type "TABLE" for DataProfileScan/DataQualityScan.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#resource GoogleDataplexDatascan#resource}
    */
    readonly resource?: string;
}
export declare function googleDataplexDatascanDataToTerraform(struct?: GoogleDataplexDatascanDataOutputReference | GoogleDataplexDatascanData): any;
export declare function googleDataplexDatascanDataToHclTerraform(struct?: GoogleDataplexDatascanDataOutputReference | GoogleDataplexDatascanData): any;
export declare class GoogleDataplexDatascanDataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexDatascanData | undefined;
    set internalValue(value: GoogleDataplexDatascanData | undefined);
    private _entity?;
    get entity(): string;
    set entity(value: string);
    resetEntity(): void;
    get entityInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    resetResource(): void;
    get resourceInput(): string | undefined;
}
export interface GoogleDataplexDatascanDataProfileSpecExcludeFields {
    /**
    * Expected input is a list of fully qualified names of fields as in the schema.
    * Only top-level field names for nested fields are supported.
    * For instance, if 'x' is of nested field type, listing 'x' is supported but 'x.y.z' is not supported. Here 'y' and 'y.z' are nested fields of 'x'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#field_names GoogleDataplexDatascan#field_names}
    */
    readonly fieldNames?: string[];
}
export declare function googleDataplexDatascanDataProfileSpecExcludeFieldsToTerraform(struct?: GoogleDataplexDatascanDataProfileSpecExcludeFieldsOutputReference | GoogleDataplexDatascanDataProfileSpecExcludeFields): any;
export declare function googleDataplexDatascanDataProfileSpecExcludeFieldsToHclTerraform(struct?: GoogleDataplexDatascanDataProfileSpecExcludeFieldsOutputReference | GoogleDataplexDatascanDataProfileSpecExcludeFields): any;
export declare class GoogleDataplexDatascanDataProfileSpecExcludeFieldsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexDatascanDataProfileSpecExcludeFields | undefined;
    set internalValue(value: GoogleDataplexDatascanDataProfileSpecExcludeFields | undefined);
    private _fieldNames?;
    get fieldNames(): string[];
    set fieldNames(value: string[]);
    resetFieldNames(): void;
    get fieldNamesInput(): string[] | undefined;
}
export interface GoogleDataplexDatascanDataProfileSpecIncludeFields {
    /**
    * Expected input is a list of fully qualified names of fields as in the schema.
    * Only top-level field names for nested fields are supported.
    * For instance, if 'x' is of nested field type, listing 'x' is supported but 'x.y.z' is not supported. Here 'y' and 'y.z' are nested fields of 'x'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#field_names GoogleDataplexDatascan#field_names}
    */
    readonly fieldNames?: string[];
}
export declare function googleDataplexDatascanDataProfileSpecIncludeFieldsToTerraform(struct?: GoogleDataplexDatascanDataProfileSpecIncludeFieldsOutputReference | GoogleDataplexDatascanDataProfileSpecIncludeFields): any;
export declare function googleDataplexDatascanDataProfileSpecIncludeFieldsToHclTerraform(struct?: GoogleDataplexDatascanDataProfileSpecIncludeFieldsOutputReference | GoogleDataplexDatascanDataProfileSpecIncludeFields): any;
export declare class GoogleDataplexDatascanDataProfileSpecIncludeFieldsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexDatascanDataProfileSpecIncludeFields | undefined;
    set internalValue(value: GoogleDataplexDatascanDataProfileSpecIncludeFields | undefined);
    private _fieldNames?;
    get fieldNames(): string[];
    set fieldNames(value: string[]);
    resetFieldNames(): void;
    get fieldNamesInput(): string[] | undefined;
}
export interface GoogleDataplexDatascanDataProfileSpecPostScanActionsBigqueryExport {
    /**
    * The BigQuery table to export DataProfileScan results to.
    * Format://bigquery.googleapis.com/projects/PROJECT_ID/datasets/DATASET_ID/tables/TABLE_ID
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#results_table GoogleDataplexDatascan#results_table}
    */
    readonly resultsTable?: string;
}
export declare function googleDataplexDatascanDataProfileSpecPostScanActionsBigqueryExportToTerraform(struct?: GoogleDataplexDatascanDataProfileSpecPostScanActionsBigqueryExportOutputReference | GoogleDataplexDatascanDataProfileSpecPostScanActionsBigqueryExport): any;
export declare function googleDataplexDatascanDataProfileSpecPostScanActionsBigqueryExportToHclTerraform(struct?: GoogleDataplexDatascanDataProfileSpecPostScanActionsBigqueryExportOutputReference | GoogleDataplexDatascanDataProfileSpecPostScanActionsBigqueryExport): any;
export declare class GoogleDataplexDatascanDataProfileSpecPostScanActionsBigqueryExportOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexDatascanDataProfileSpecPostScanActionsBigqueryExport | undefined;
    set internalValue(value: GoogleDataplexDatascanDataProfileSpecPostScanActionsBigqueryExport | undefined);
    private _resultsTable?;
    get resultsTable(): string;
    set resultsTable(value: string);
    resetResultsTable(): void;
    get resultsTableInput(): string | undefined;
}
export interface GoogleDataplexDatascanDataProfileSpecPostScanActions {
    /**
    * bigquery_export block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#bigquery_export GoogleDataplexDatascan#bigquery_export}
    */
    readonly bigqueryExport?: GoogleDataplexDatascanDataProfileSpecPostScanActionsBigqueryExport;
}
export declare function googleDataplexDatascanDataProfileSpecPostScanActionsToTerraform(struct?: GoogleDataplexDatascanDataProfileSpecPostScanActionsOutputReference | GoogleDataplexDatascanDataProfileSpecPostScanActions): any;
export declare function googleDataplexDatascanDataProfileSpecPostScanActionsToHclTerraform(struct?: GoogleDataplexDatascanDataProfileSpecPostScanActionsOutputReference | GoogleDataplexDatascanDataProfileSpecPostScanActions): any;
export declare class GoogleDataplexDatascanDataProfileSpecPostScanActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexDatascanDataProfileSpecPostScanActions | undefined;
    set internalValue(value: GoogleDataplexDatascanDataProfileSpecPostScanActions | undefined);
    private _bigqueryExport;
    get bigqueryExport(): GoogleDataplexDatascanDataProfileSpecPostScanActionsBigqueryExportOutputReference;
    putBigqueryExport(value: GoogleDataplexDatascanDataProfileSpecPostScanActionsBigqueryExport): void;
    resetBigqueryExport(): void;
    get bigqueryExportInput(): GoogleDataplexDatascanDataProfileSpecPostScanActionsBigqueryExport | undefined;
}
export interface GoogleDataplexDatascanDataProfileSpec {
    /**
    * A filter applied to all rows in a single DataScan job. The filter needs to be a valid SQL expression for a WHERE clause in BigQuery standard SQL syntax. Example: col1 >= 0 AND col2 < 10
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#row_filter GoogleDataplexDatascan#row_filter}
    */
    readonly rowFilter?: string;
    /**
    * The percentage of the records to be selected from the dataset for DataScan.
    * Value can range between 0.0 and 100.0 with up to 3 significant decimal digits.
    * Sampling is not applied if 'sampling_percent' is not specified, 0 or 100.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#sampling_percent GoogleDataplexDatascan#sampling_percent}
    */
    readonly samplingPercent?: number;
    /**
    * exclude_fields block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#exclude_fields GoogleDataplexDatascan#exclude_fields}
    */
    readonly excludeFields?: GoogleDataplexDatascanDataProfileSpecExcludeFields;
    /**
    * include_fields block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#include_fields GoogleDataplexDatascan#include_fields}
    */
    readonly includeFields?: GoogleDataplexDatascanDataProfileSpecIncludeFields;
    /**
    * post_scan_actions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#post_scan_actions GoogleDataplexDatascan#post_scan_actions}
    */
    readonly postScanActions?: GoogleDataplexDatascanDataProfileSpecPostScanActions;
}
export declare function googleDataplexDatascanDataProfileSpecToTerraform(struct?: GoogleDataplexDatascanDataProfileSpecOutputReference | GoogleDataplexDatascanDataProfileSpec): any;
export declare function googleDataplexDatascanDataProfileSpecToHclTerraform(struct?: GoogleDataplexDatascanDataProfileSpecOutputReference | GoogleDataplexDatascanDataProfileSpec): any;
export declare class GoogleDataplexDatascanDataProfileSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexDatascanDataProfileSpec | undefined;
    set internalValue(value: GoogleDataplexDatascanDataProfileSpec | undefined);
    private _rowFilter?;
    get rowFilter(): string;
    set rowFilter(value: string);
    resetRowFilter(): void;
    get rowFilterInput(): string | undefined;
    private _samplingPercent?;
    get samplingPercent(): number;
    set samplingPercent(value: number);
    resetSamplingPercent(): void;
    get samplingPercentInput(): number | undefined;
    private _excludeFields;
    get excludeFields(): GoogleDataplexDatascanDataProfileSpecExcludeFieldsOutputReference;
    putExcludeFields(value: GoogleDataplexDatascanDataProfileSpecExcludeFields): void;
    resetExcludeFields(): void;
    get excludeFieldsInput(): GoogleDataplexDatascanDataProfileSpecExcludeFields | undefined;
    private _includeFields;
    get includeFields(): GoogleDataplexDatascanDataProfileSpecIncludeFieldsOutputReference;
    putIncludeFields(value: GoogleDataplexDatascanDataProfileSpecIncludeFields): void;
    resetIncludeFields(): void;
    get includeFieldsInput(): GoogleDataplexDatascanDataProfileSpecIncludeFields | undefined;
    private _postScanActions;
    get postScanActions(): GoogleDataplexDatascanDataProfileSpecPostScanActionsOutputReference;
    putPostScanActions(value: GoogleDataplexDatascanDataProfileSpecPostScanActions): void;
    resetPostScanActions(): void;
    get postScanActionsInput(): GoogleDataplexDatascanDataProfileSpecPostScanActions | undefined;
}
export interface GoogleDataplexDatascanDataQualitySpecPostScanActionsBigqueryExport {
    /**
    * The BigQuery table to export DataQualityScan results to.
    * Format://bigquery.googleapis.com/projects/PROJECT_ID/datasets/DATASET_ID/tables/TABLE_ID
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#results_table GoogleDataplexDatascan#results_table}
    */
    readonly resultsTable?: string;
}
export declare function googleDataplexDatascanDataQualitySpecPostScanActionsBigqueryExportToTerraform(struct?: GoogleDataplexDatascanDataQualitySpecPostScanActionsBigqueryExportOutputReference | GoogleDataplexDatascanDataQualitySpecPostScanActionsBigqueryExport): any;
export declare function googleDataplexDatascanDataQualitySpecPostScanActionsBigqueryExportToHclTerraform(struct?: GoogleDataplexDatascanDataQualitySpecPostScanActionsBigqueryExportOutputReference | GoogleDataplexDatascanDataQualitySpecPostScanActionsBigqueryExport): any;
export declare class GoogleDataplexDatascanDataQualitySpecPostScanActionsBigqueryExportOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexDatascanDataQualitySpecPostScanActionsBigqueryExport | undefined;
    set internalValue(value: GoogleDataplexDatascanDataQualitySpecPostScanActionsBigqueryExport | undefined);
    private _resultsTable?;
    get resultsTable(): string;
    set resultsTable(value: string);
    resetResultsTable(): void;
    get resultsTableInput(): string | undefined;
}
export interface GoogleDataplexDatascanDataQualitySpecPostScanActions {
    /**
    * bigquery_export block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#bigquery_export GoogleDataplexDatascan#bigquery_export}
    */
    readonly bigqueryExport?: GoogleDataplexDatascanDataQualitySpecPostScanActionsBigqueryExport;
}
export declare function googleDataplexDatascanDataQualitySpecPostScanActionsToTerraform(struct?: GoogleDataplexDatascanDataQualitySpecPostScanActionsOutputReference | GoogleDataplexDatascanDataQualitySpecPostScanActions): any;
export declare function googleDataplexDatascanDataQualitySpecPostScanActionsToHclTerraform(struct?: GoogleDataplexDatascanDataQualitySpecPostScanActionsOutputReference | GoogleDataplexDatascanDataQualitySpecPostScanActions): any;
export declare class GoogleDataplexDatascanDataQualitySpecPostScanActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexDatascanDataQualitySpecPostScanActions | undefined;
    set internalValue(value: GoogleDataplexDatascanDataQualitySpecPostScanActions | undefined);
    private _bigqueryExport;
    get bigqueryExport(): GoogleDataplexDatascanDataQualitySpecPostScanActionsBigqueryExportOutputReference;
    putBigqueryExport(value: GoogleDataplexDatascanDataQualitySpecPostScanActionsBigqueryExport): void;
    resetBigqueryExport(): void;
    get bigqueryExportInput(): GoogleDataplexDatascanDataQualitySpecPostScanActionsBigqueryExport | undefined;
}
export interface GoogleDataplexDatascanDataQualitySpecRulesNonNullExpectation {
}
export declare function googleDataplexDatascanDataQualitySpecRulesNonNullExpectationToTerraform(struct?: GoogleDataplexDatascanDataQualitySpecRulesNonNullExpectationOutputReference | GoogleDataplexDatascanDataQualitySpecRulesNonNullExpectation): any;
export declare function googleDataplexDatascanDataQualitySpecRulesNonNullExpectationToHclTerraform(struct?: GoogleDataplexDatascanDataQualitySpecRulesNonNullExpectationOutputReference | GoogleDataplexDatascanDataQualitySpecRulesNonNullExpectation): any;
export declare class GoogleDataplexDatascanDataQualitySpecRulesNonNullExpectationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexDatascanDataQualitySpecRulesNonNullExpectation | undefined;
    set internalValue(value: GoogleDataplexDatascanDataQualitySpecRulesNonNullExpectation | undefined);
}
export interface GoogleDataplexDatascanDataQualitySpecRulesRangeExpectation {
    /**
    * The maximum column value allowed for a row to pass this validation. At least one of minValue and maxValue need to be provided.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#max_value GoogleDataplexDatascan#max_value}
    */
    readonly maxValue?: string;
    /**
    * The minimum column value allowed for a row to pass this validation. At least one of minValue and maxValue need to be provided.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#min_value GoogleDataplexDatascan#min_value}
    */
    readonly minValue?: string;
    /**
    * Whether each value needs to be strictly lesser than ('<') the maximum, or if equality is allowed.
    * Only relevant if a maxValue has been defined. Default = false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#strict_max_enabled GoogleDataplexDatascan#strict_max_enabled}
    */
    readonly strictMaxEnabled?: boolean | cdktf.IResolvable;
    /**
    * Whether each value needs to be strictly greater than ('>') the minimum, or if equality is allowed.
    * Only relevant if a minValue has been defined. Default = false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#strict_min_enabled GoogleDataplexDatascan#strict_min_enabled}
    */
    readonly strictMinEnabled?: boolean | cdktf.IResolvable;
}
export declare function googleDataplexDatascanDataQualitySpecRulesRangeExpectationToTerraform(struct?: GoogleDataplexDatascanDataQualitySpecRulesRangeExpectationOutputReference | GoogleDataplexDatascanDataQualitySpecRulesRangeExpectation): any;
export declare function googleDataplexDatascanDataQualitySpecRulesRangeExpectationToHclTerraform(struct?: GoogleDataplexDatascanDataQualitySpecRulesRangeExpectationOutputReference | GoogleDataplexDatascanDataQualitySpecRulesRangeExpectation): any;
export declare class GoogleDataplexDatascanDataQualitySpecRulesRangeExpectationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexDatascanDataQualitySpecRulesRangeExpectation | undefined;
    set internalValue(value: GoogleDataplexDatascanDataQualitySpecRulesRangeExpectation | undefined);
    private _maxValue?;
    get maxValue(): string;
    set maxValue(value: string);
    resetMaxValue(): void;
    get maxValueInput(): string | undefined;
    private _minValue?;
    get minValue(): string;
    set minValue(value: string);
    resetMinValue(): void;
    get minValueInput(): string | undefined;
    private _strictMaxEnabled?;
    get strictMaxEnabled(): boolean | cdktf.IResolvable;
    set strictMaxEnabled(value: boolean | cdktf.IResolvable);
    resetStrictMaxEnabled(): void;
    get strictMaxEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _strictMinEnabled?;
    get strictMinEnabled(): boolean | cdktf.IResolvable;
    set strictMinEnabled(value: boolean | cdktf.IResolvable);
    resetStrictMinEnabled(): void;
    get strictMinEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleDataplexDatascanDataQualitySpecRulesRegexExpectation {
    /**
    * A regular expression the column value is expected to match.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#regex GoogleDataplexDatascan#regex}
    */
    readonly regex: string;
}
export declare function googleDataplexDatascanDataQualitySpecRulesRegexExpectationToTerraform(struct?: GoogleDataplexDatascanDataQualitySpecRulesRegexExpectationOutputReference | GoogleDataplexDatascanDataQualitySpecRulesRegexExpectation): any;
export declare function googleDataplexDatascanDataQualitySpecRulesRegexExpectationToHclTerraform(struct?: GoogleDataplexDatascanDataQualitySpecRulesRegexExpectationOutputReference | GoogleDataplexDatascanDataQualitySpecRulesRegexExpectation): any;
export declare class GoogleDataplexDatascanDataQualitySpecRulesRegexExpectationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexDatascanDataQualitySpecRulesRegexExpectation | undefined;
    set internalValue(value: GoogleDataplexDatascanDataQualitySpecRulesRegexExpectation | undefined);
    private _regex?;
    get regex(): string;
    set regex(value: string);
    get regexInput(): string | undefined;
}
export interface GoogleDataplexDatascanDataQualitySpecRulesRowConditionExpectation {
    /**
    * The SQL expression.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#sql_expression GoogleDataplexDatascan#sql_expression}
    */
    readonly sqlExpression: string;
}
export declare function googleDataplexDatascanDataQualitySpecRulesRowConditionExpectationToTerraform(struct?: GoogleDataplexDatascanDataQualitySpecRulesRowConditionExpectationOutputReference | GoogleDataplexDatascanDataQualitySpecRulesRowConditionExpectation): any;
export declare function googleDataplexDatascanDataQualitySpecRulesRowConditionExpectationToHclTerraform(struct?: GoogleDataplexDatascanDataQualitySpecRulesRowConditionExpectationOutputReference | GoogleDataplexDatascanDataQualitySpecRulesRowConditionExpectation): any;
export declare class GoogleDataplexDatascanDataQualitySpecRulesRowConditionExpectationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexDatascanDataQualitySpecRulesRowConditionExpectation | undefined;
    set internalValue(value: GoogleDataplexDatascanDataQualitySpecRulesRowConditionExpectation | undefined);
    private _sqlExpression?;
    get sqlExpression(): string;
    set sqlExpression(value: string);
    get sqlExpressionInput(): string | undefined;
}
export interface GoogleDataplexDatascanDataQualitySpecRulesSetExpectation {
    /**
    * Expected values for the column value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#values GoogleDataplexDatascan#values}
    */
    readonly values: string[];
}
export declare function googleDataplexDatascanDataQualitySpecRulesSetExpectationToTerraform(struct?: GoogleDataplexDatascanDataQualitySpecRulesSetExpectationOutputReference | GoogleDataplexDatascanDataQualitySpecRulesSetExpectation): any;
export declare function googleDataplexDatascanDataQualitySpecRulesSetExpectationToHclTerraform(struct?: GoogleDataplexDatascanDataQualitySpecRulesSetExpectationOutputReference | GoogleDataplexDatascanDataQualitySpecRulesSetExpectation): any;
export declare class GoogleDataplexDatascanDataQualitySpecRulesSetExpectationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexDatascanDataQualitySpecRulesSetExpectation | undefined;
    set internalValue(value: GoogleDataplexDatascanDataQualitySpecRulesSetExpectation | undefined);
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface GoogleDataplexDatascanDataQualitySpecRulesStatisticRangeExpectation {
    /**
    * The maximum column statistic value allowed for a row to pass this validation.
    * At least one of minValue and maxValue need to be provided.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#max_value GoogleDataplexDatascan#max_value}
    */
    readonly maxValue?: string;
    /**
    * The minimum column statistic value allowed for a row to pass this validation.
    * At least one of minValue and maxValue need to be provided.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#min_value GoogleDataplexDatascan#min_value}
    */
    readonly minValue?: string;
    /**
    * column statistics. Possible values: ["STATISTIC_UNDEFINED", "MEAN", "MIN", "MAX"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#statistic GoogleDataplexDatascan#statistic}
    */
    readonly statistic: string;
    /**
    * Whether column statistic needs to be strictly lesser than ('<') the maximum, or if equality is allowed.
    * Only relevant if a maxValue has been defined. Default = false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#strict_max_enabled GoogleDataplexDatascan#strict_max_enabled}
    */
    readonly strictMaxEnabled?: boolean | cdktf.IResolvable;
    /**
    * Whether column statistic needs to be strictly greater than ('>') the minimum, or if equality is allowed.
    * Only relevant if a minValue has been defined. Default = false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#strict_min_enabled GoogleDataplexDatascan#strict_min_enabled}
    */
    readonly strictMinEnabled?: boolean | cdktf.IResolvable;
}
export declare function googleDataplexDatascanDataQualitySpecRulesStatisticRangeExpectationToTerraform(struct?: GoogleDataplexDatascanDataQualitySpecRulesStatisticRangeExpectationOutputReference | GoogleDataplexDatascanDataQualitySpecRulesStatisticRangeExpectation): any;
export declare function googleDataplexDatascanDataQualitySpecRulesStatisticRangeExpectationToHclTerraform(struct?: GoogleDataplexDatascanDataQualitySpecRulesStatisticRangeExpectationOutputReference | GoogleDataplexDatascanDataQualitySpecRulesStatisticRangeExpectation): any;
export declare class GoogleDataplexDatascanDataQualitySpecRulesStatisticRangeExpectationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexDatascanDataQualitySpecRulesStatisticRangeExpectation | undefined;
    set internalValue(value: GoogleDataplexDatascanDataQualitySpecRulesStatisticRangeExpectation | undefined);
    private _maxValue?;
    get maxValue(): string;
    set maxValue(value: string);
    resetMaxValue(): void;
    get maxValueInput(): string | undefined;
    private _minValue?;
    get minValue(): string;
    set minValue(value: string);
    resetMinValue(): void;
    get minValueInput(): string | undefined;
    private _statistic?;
    get statistic(): string;
    set statistic(value: string);
    get statisticInput(): string | undefined;
    private _strictMaxEnabled?;
    get strictMaxEnabled(): boolean | cdktf.IResolvable;
    set strictMaxEnabled(value: boolean | cdktf.IResolvable);
    resetStrictMaxEnabled(): void;
    get strictMaxEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _strictMinEnabled?;
    get strictMinEnabled(): boolean | cdktf.IResolvable;
    set strictMinEnabled(value: boolean | cdktf.IResolvable);
    resetStrictMinEnabled(): void;
    get strictMinEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleDataplexDatascanDataQualitySpecRulesTableConditionExpectation {
    /**
    * The SQL expression.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#sql_expression GoogleDataplexDatascan#sql_expression}
    */
    readonly sqlExpression: string;
}
export declare function googleDataplexDatascanDataQualitySpecRulesTableConditionExpectationToTerraform(struct?: GoogleDataplexDatascanDataQualitySpecRulesTableConditionExpectationOutputReference | GoogleDataplexDatascanDataQualitySpecRulesTableConditionExpectation): any;
export declare function googleDataplexDatascanDataQualitySpecRulesTableConditionExpectationToHclTerraform(struct?: GoogleDataplexDatascanDataQualitySpecRulesTableConditionExpectationOutputReference | GoogleDataplexDatascanDataQualitySpecRulesTableConditionExpectation): any;
export declare class GoogleDataplexDatascanDataQualitySpecRulesTableConditionExpectationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexDatascanDataQualitySpecRulesTableConditionExpectation | undefined;
    set internalValue(value: GoogleDataplexDatascanDataQualitySpecRulesTableConditionExpectation | undefined);
    private _sqlExpression?;
    get sqlExpression(): string;
    set sqlExpression(value: string);
    get sqlExpressionInput(): string | undefined;
}
export interface GoogleDataplexDatascanDataQualitySpecRulesUniquenessExpectation {
}
export declare function googleDataplexDatascanDataQualitySpecRulesUniquenessExpectationToTerraform(struct?: GoogleDataplexDatascanDataQualitySpecRulesUniquenessExpectationOutputReference | GoogleDataplexDatascanDataQualitySpecRulesUniquenessExpectation): any;
export declare function googleDataplexDatascanDataQualitySpecRulesUniquenessExpectationToHclTerraform(struct?: GoogleDataplexDatascanDataQualitySpecRulesUniquenessExpectationOutputReference | GoogleDataplexDatascanDataQualitySpecRulesUniquenessExpectation): any;
export declare class GoogleDataplexDatascanDataQualitySpecRulesUniquenessExpectationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexDatascanDataQualitySpecRulesUniquenessExpectation | undefined;
    set internalValue(value: GoogleDataplexDatascanDataQualitySpecRulesUniquenessExpectation | undefined);
}
export interface GoogleDataplexDatascanDataQualitySpecRules {
    /**
    * The unnested column which this rule is evaluated against.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#column GoogleDataplexDatascan#column}
    */
    readonly column?: string;
    /**
    * Description of the rule.
    * The maximum length is 1,024 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#description GoogleDataplexDatascan#description}
    */
    readonly description?: string;
    /**
    * The dimension a rule belongs to. Results are also aggregated at the dimension level. Supported dimensions are ["COMPLETENESS", "ACCURACY", "CONSISTENCY", "VALIDITY", "UNIQUENESS", "INTEGRITY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#dimension GoogleDataplexDatascan#dimension}
    */
    readonly dimension: string;
    /**
    * Rows with null values will automatically fail a rule, unless ignoreNull is true. In that case, such null rows are trivially considered passing. Only applicable to ColumnMap rules.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#ignore_null GoogleDataplexDatascan#ignore_null}
    */
    readonly ignoreNull?: boolean | cdktf.IResolvable;
    /**
    * A mutable name for the rule.
    * The name must contain only letters (a-z, A-Z), numbers (0-9), or hyphens (-).
    * The maximum length is 63 characters.
    * Must start with a letter.
    * Must end with a number or a letter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#name GoogleDataplexDatascan#name}
    */
    readonly name?: string;
    /**
    * The minimum ratio of passing_rows / total_rows required to pass this rule, with a range of [0.0, 1.0]. 0 indicates default value (i.e. 1.0).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#threshold GoogleDataplexDatascan#threshold}
    */
    readonly threshold?: number;
    /**
    * non_null_expectation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#non_null_expectation GoogleDataplexDatascan#non_null_expectation}
    */
    readonly nonNullExpectation?: GoogleDataplexDatascanDataQualitySpecRulesNonNullExpectation;
    /**
    * range_expectation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#range_expectation GoogleDataplexDatascan#range_expectation}
    */
    readonly rangeExpectation?: GoogleDataplexDatascanDataQualitySpecRulesRangeExpectation;
    /**
    * regex_expectation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#regex_expectation GoogleDataplexDatascan#regex_expectation}
    */
    readonly regexExpectation?: GoogleDataplexDatascanDataQualitySpecRulesRegexExpectation;
    /**
    * row_condition_expectation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#row_condition_expectation GoogleDataplexDatascan#row_condition_expectation}
    */
    readonly rowConditionExpectation?: GoogleDataplexDatascanDataQualitySpecRulesRowConditionExpectation;
    /**
    * set_expectation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#set_expectation GoogleDataplexDatascan#set_expectation}
    */
    readonly setExpectation?: GoogleDataplexDatascanDataQualitySpecRulesSetExpectation;
    /**
    * statistic_range_expectation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#statistic_range_expectation GoogleDataplexDatascan#statistic_range_expectation}
    */
    readonly statisticRangeExpectation?: GoogleDataplexDatascanDataQualitySpecRulesStatisticRangeExpectation;
    /**
    * table_condition_expectation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#table_condition_expectation GoogleDataplexDatascan#table_condition_expectation}
    */
    readonly tableConditionExpectation?: GoogleDataplexDatascanDataQualitySpecRulesTableConditionExpectation;
    /**
    * uniqueness_expectation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#uniqueness_expectation GoogleDataplexDatascan#uniqueness_expectation}
    */
    readonly uniquenessExpectation?: GoogleDataplexDatascanDataQualitySpecRulesUniquenessExpectation;
}
export declare function googleDataplexDatascanDataQualitySpecRulesToTerraform(struct?: GoogleDataplexDatascanDataQualitySpecRules | cdktf.IResolvable): any;
export declare function googleDataplexDatascanDataQualitySpecRulesToHclTerraform(struct?: GoogleDataplexDatascanDataQualitySpecRules | cdktf.IResolvable): any;
export declare class GoogleDataplexDatascanDataQualitySpecRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataplexDatascanDataQualitySpecRules | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataplexDatascanDataQualitySpecRules | cdktf.IResolvable | undefined);
    private _column?;
    get column(): string;
    set column(value: string);
    resetColumn(): void;
    get columnInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _dimension?;
    get dimension(): string;
    set dimension(value: string);
    get dimensionInput(): string | undefined;
    private _ignoreNull?;
    get ignoreNull(): boolean | cdktf.IResolvable;
    set ignoreNull(value: boolean | cdktf.IResolvable);
    resetIgnoreNull(): void;
    get ignoreNullInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _threshold?;
    get threshold(): number;
    set threshold(value: number);
    resetThreshold(): void;
    get thresholdInput(): number | undefined;
    private _nonNullExpectation;
    get nonNullExpectation(): GoogleDataplexDatascanDataQualitySpecRulesNonNullExpectationOutputReference;
    putNonNullExpectation(value: GoogleDataplexDatascanDataQualitySpecRulesNonNullExpectation): void;
    resetNonNullExpectation(): void;
    get nonNullExpectationInput(): GoogleDataplexDatascanDataQualitySpecRulesNonNullExpectation | undefined;
    private _rangeExpectation;
    get rangeExpectation(): GoogleDataplexDatascanDataQualitySpecRulesRangeExpectationOutputReference;
    putRangeExpectation(value: GoogleDataplexDatascanDataQualitySpecRulesRangeExpectation): void;
    resetRangeExpectation(): void;
    get rangeExpectationInput(): GoogleDataplexDatascanDataQualitySpecRulesRangeExpectation | undefined;
    private _regexExpectation;
    get regexExpectation(): GoogleDataplexDatascanDataQualitySpecRulesRegexExpectationOutputReference;
    putRegexExpectation(value: GoogleDataplexDatascanDataQualitySpecRulesRegexExpectation): void;
    resetRegexExpectation(): void;
    get regexExpectationInput(): GoogleDataplexDatascanDataQualitySpecRulesRegexExpectation | undefined;
    private _rowConditionExpectation;
    get rowConditionExpectation(): GoogleDataplexDatascanDataQualitySpecRulesRowConditionExpectationOutputReference;
    putRowConditionExpectation(value: GoogleDataplexDatascanDataQualitySpecRulesRowConditionExpectation): void;
    resetRowConditionExpectation(): void;
    get rowConditionExpectationInput(): GoogleDataplexDatascanDataQualitySpecRulesRowConditionExpectation | undefined;
    private _setExpectation;
    get setExpectation(): GoogleDataplexDatascanDataQualitySpecRulesSetExpectationOutputReference;
    putSetExpectation(value: GoogleDataplexDatascanDataQualitySpecRulesSetExpectation): void;
    resetSetExpectation(): void;
    get setExpectationInput(): GoogleDataplexDatascanDataQualitySpecRulesSetExpectation | undefined;
    private _statisticRangeExpectation;
    get statisticRangeExpectation(): GoogleDataplexDatascanDataQualitySpecRulesStatisticRangeExpectationOutputReference;
    putStatisticRangeExpectation(value: GoogleDataplexDatascanDataQualitySpecRulesStatisticRangeExpectation): void;
    resetStatisticRangeExpectation(): void;
    get statisticRangeExpectationInput(): GoogleDataplexDatascanDataQualitySpecRulesStatisticRangeExpectation | undefined;
    private _tableConditionExpectation;
    get tableConditionExpectation(): GoogleDataplexDatascanDataQualitySpecRulesTableConditionExpectationOutputReference;
    putTableConditionExpectation(value: GoogleDataplexDatascanDataQualitySpecRulesTableConditionExpectation): void;
    resetTableConditionExpectation(): void;
    get tableConditionExpectationInput(): GoogleDataplexDatascanDataQualitySpecRulesTableConditionExpectation | undefined;
    private _uniquenessExpectation;
    get uniquenessExpectation(): GoogleDataplexDatascanDataQualitySpecRulesUniquenessExpectationOutputReference;
    putUniquenessExpectation(value: GoogleDataplexDatascanDataQualitySpecRulesUniquenessExpectation): void;
    resetUniquenessExpectation(): void;
    get uniquenessExpectationInput(): GoogleDataplexDatascanDataQualitySpecRulesUniquenessExpectation | undefined;
}
export declare class GoogleDataplexDatascanDataQualitySpecRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDataplexDatascanDataQualitySpecRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataplexDatascanDataQualitySpecRulesOutputReference;
}
export interface GoogleDataplexDatascanDataQualitySpec {
    /**
    * A filter applied to all rows in a single DataScan job. The filter needs to be a valid SQL expression for a WHERE clause in BigQuery standard SQL syntax. Example: col1 >= 0 AND col2 < 10
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#row_filter GoogleDataplexDatascan#row_filter}
    */
    readonly rowFilter?: string;
    /**
    * The percentage of the records to be selected from the dataset for DataScan.
    * Value can range between 0.0 and 100.0 with up to 3 significant decimal digits.
    * Sampling is not applied if 'sampling_percent' is not specified, 0 or 100.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#sampling_percent GoogleDataplexDatascan#sampling_percent}
    */
    readonly samplingPercent?: number;
    /**
    * post_scan_actions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#post_scan_actions GoogleDataplexDatascan#post_scan_actions}
    */
    readonly postScanActions?: GoogleDataplexDatascanDataQualitySpecPostScanActions;
    /**
    * rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#rules GoogleDataplexDatascan#rules}
    */
    readonly rules?: GoogleDataplexDatascanDataQualitySpecRules[] | cdktf.IResolvable;
}
export declare function googleDataplexDatascanDataQualitySpecToTerraform(struct?: GoogleDataplexDatascanDataQualitySpecOutputReference | GoogleDataplexDatascanDataQualitySpec): any;
export declare function googleDataplexDatascanDataQualitySpecToHclTerraform(struct?: GoogleDataplexDatascanDataQualitySpecOutputReference | GoogleDataplexDatascanDataQualitySpec): any;
export declare class GoogleDataplexDatascanDataQualitySpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexDatascanDataQualitySpec | undefined;
    set internalValue(value: GoogleDataplexDatascanDataQualitySpec | undefined);
    private _rowFilter?;
    get rowFilter(): string;
    set rowFilter(value: string);
    resetRowFilter(): void;
    get rowFilterInput(): string | undefined;
    private _samplingPercent?;
    get samplingPercent(): number;
    set samplingPercent(value: number);
    resetSamplingPercent(): void;
    get samplingPercentInput(): number | undefined;
    private _postScanActions;
    get postScanActions(): GoogleDataplexDatascanDataQualitySpecPostScanActionsOutputReference;
    putPostScanActions(value: GoogleDataplexDatascanDataQualitySpecPostScanActions): void;
    resetPostScanActions(): void;
    get postScanActionsInput(): GoogleDataplexDatascanDataQualitySpecPostScanActions | undefined;
    private _rules;
    get rules(): GoogleDataplexDatascanDataQualitySpecRulesList;
    putRules(value: GoogleDataplexDatascanDataQualitySpecRules[] | cdktf.IResolvable): void;
    resetRules(): void;
    get rulesInput(): cdktf.IResolvable | GoogleDataplexDatascanDataQualitySpecRules[] | undefined;
}
export interface GoogleDataplexDatascanExecutionSpecTriggerOnDemand {
}
export declare function googleDataplexDatascanExecutionSpecTriggerOnDemandToTerraform(struct?: GoogleDataplexDatascanExecutionSpecTriggerOnDemandOutputReference | GoogleDataplexDatascanExecutionSpecTriggerOnDemand): any;
export declare function googleDataplexDatascanExecutionSpecTriggerOnDemandToHclTerraform(struct?: GoogleDataplexDatascanExecutionSpecTriggerOnDemandOutputReference | GoogleDataplexDatascanExecutionSpecTriggerOnDemand): any;
export declare class GoogleDataplexDatascanExecutionSpecTriggerOnDemandOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexDatascanExecutionSpecTriggerOnDemand | undefined;
    set internalValue(value: GoogleDataplexDatascanExecutionSpecTriggerOnDemand | undefined);
}
export interface GoogleDataplexDatascanExecutionSpecTriggerSchedule {
    /**
    * Cron schedule for running scans periodically. This field is required for Schedule scans.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#cron GoogleDataplexDatascan#cron}
    */
    readonly cron: string;
}
export declare function googleDataplexDatascanExecutionSpecTriggerScheduleToTerraform(struct?: GoogleDataplexDatascanExecutionSpecTriggerScheduleOutputReference | GoogleDataplexDatascanExecutionSpecTriggerSchedule): any;
export declare function googleDataplexDatascanExecutionSpecTriggerScheduleToHclTerraform(struct?: GoogleDataplexDatascanExecutionSpecTriggerScheduleOutputReference | GoogleDataplexDatascanExecutionSpecTriggerSchedule): any;
export declare class GoogleDataplexDatascanExecutionSpecTriggerScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexDatascanExecutionSpecTriggerSchedule | undefined;
    set internalValue(value: GoogleDataplexDatascanExecutionSpecTriggerSchedule | undefined);
    private _cron?;
    get cron(): string;
    set cron(value: string);
    get cronInput(): string | undefined;
}
export interface GoogleDataplexDatascanExecutionSpecTrigger {
    /**
    * on_demand block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#on_demand GoogleDataplexDatascan#on_demand}
    */
    readonly onDemand?: GoogleDataplexDatascanExecutionSpecTriggerOnDemand;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#schedule GoogleDataplexDatascan#schedule}
    */
    readonly schedule?: GoogleDataplexDatascanExecutionSpecTriggerSchedule;
}
export declare function googleDataplexDatascanExecutionSpecTriggerToTerraform(struct?: GoogleDataplexDatascanExecutionSpecTriggerOutputReference | GoogleDataplexDatascanExecutionSpecTrigger): any;
export declare function googleDataplexDatascanExecutionSpecTriggerToHclTerraform(struct?: GoogleDataplexDatascanExecutionSpecTriggerOutputReference | GoogleDataplexDatascanExecutionSpecTrigger): any;
export declare class GoogleDataplexDatascanExecutionSpecTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexDatascanExecutionSpecTrigger | undefined;
    set internalValue(value: GoogleDataplexDatascanExecutionSpecTrigger | undefined);
    private _onDemand;
    get onDemand(): GoogleDataplexDatascanExecutionSpecTriggerOnDemandOutputReference;
    putOnDemand(value: GoogleDataplexDatascanExecutionSpecTriggerOnDemand): void;
    resetOnDemand(): void;
    get onDemandInput(): GoogleDataplexDatascanExecutionSpecTriggerOnDemand | undefined;
    private _schedule;
    get schedule(): GoogleDataplexDatascanExecutionSpecTriggerScheduleOutputReference;
    putSchedule(value: GoogleDataplexDatascanExecutionSpecTriggerSchedule): void;
    resetSchedule(): void;
    get scheduleInput(): GoogleDataplexDatascanExecutionSpecTriggerSchedule | undefined;
}
export interface GoogleDataplexDatascanExecutionSpec {
    /**
    * The unnested field (of type Date or Timestamp) that contains values which monotonically increase over time. If not specified, a data scan will run for all data in the table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#field GoogleDataplexDatascan#field}
    */
    readonly field?: string;
    /**
    * trigger block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#trigger GoogleDataplexDatascan#trigger}
    */
    readonly trigger: GoogleDataplexDatascanExecutionSpecTrigger;
}
export declare function googleDataplexDatascanExecutionSpecToTerraform(struct?: GoogleDataplexDatascanExecutionSpecOutputReference | GoogleDataplexDatascanExecutionSpec): any;
export declare function googleDataplexDatascanExecutionSpecToHclTerraform(struct?: GoogleDataplexDatascanExecutionSpecOutputReference | GoogleDataplexDatascanExecutionSpec): any;
export declare class GoogleDataplexDatascanExecutionSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexDatascanExecutionSpec | undefined;
    set internalValue(value: GoogleDataplexDatascanExecutionSpec | undefined);
    private _field?;
    get field(): string;
    set field(value: string);
    resetField(): void;
    get fieldInput(): string | undefined;
    private _trigger;
    get trigger(): GoogleDataplexDatascanExecutionSpecTriggerOutputReference;
    putTrigger(value: GoogleDataplexDatascanExecutionSpecTrigger): void;
    get triggerInput(): GoogleDataplexDatascanExecutionSpecTrigger | undefined;
}
export interface GoogleDataplexDatascanTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#create GoogleDataplexDatascan#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#delete GoogleDataplexDatascan#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#update GoogleDataplexDatascan#update}
    */
    readonly update?: string;
}
export declare function googleDataplexDatascanTimeoutsToTerraform(struct?: GoogleDataplexDatascanTimeouts | cdktf.IResolvable): any;
export declare function googleDataplexDatascanTimeoutsToHclTerraform(struct?: GoogleDataplexDatascanTimeouts | cdktf.IResolvable): any;
export declare class GoogleDataplexDatascanTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexDatascanTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataplexDatascanTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan google_dataplex_datascan}
*/
export declare class GoogleDataplexDatascan extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dataplex_datascan";
    /**
    * Generates CDKTF code for importing a GoogleDataplexDatascan resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleDataplexDatascan to import
    * @param importFromId The id of the existing GoogleDataplexDatascan that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleDataplexDatascan to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_datascan google_dataplex_datascan} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDataplexDatascanConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDataplexDatascanConfig);
    get createTime(): string;
    private _dataScanId?;
    get dataScanId(): string;
    set dataScanId(value: string);
    get dataScanIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _executionStatus;
    get executionStatus(): GoogleDataplexDatascanExecutionStatusList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get type(): string;
    get uid(): string;
    get updateTime(): string;
    private _data;
    get data(): GoogleDataplexDatascanDataOutputReference;
    putData(value: GoogleDataplexDatascanData): void;
    get dataInput(): GoogleDataplexDatascanData | undefined;
    private _dataProfileSpec;
    get dataProfileSpec(): GoogleDataplexDatascanDataProfileSpecOutputReference;
    putDataProfileSpec(value: GoogleDataplexDatascanDataProfileSpec): void;
    resetDataProfileSpec(): void;
    get dataProfileSpecInput(): GoogleDataplexDatascanDataProfileSpec | undefined;
    private _dataQualitySpec;
    get dataQualitySpec(): GoogleDataplexDatascanDataQualitySpecOutputReference;
    putDataQualitySpec(value: GoogleDataplexDatascanDataQualitySpec): void;
    resetDataQualitySpec(): void;
    get dataQualitySpecInput(): GoogleDataplexDatascanDataQualitySpec | undefined;
    private _executionSpec;
    get executionSpec(): GoogleDataplexDatascanExecutionSpecOutputReference;
    putExecutionSpec(value: GoogleDataplexDatascanExecutionSpec): void;
    get executionSpecInput(): GoogleDataplexDatascanExecutionSpec | undefined;
    private _timeouts;
    get timeouts(): GoogleDataplexDatascanTimeoutsOutputReference;
    putTimeouts(value: GoogleDataplexDatascanTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDataplexDatascanTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
