/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDataplexTaskConfig extends cdktf.TerraformMetaArguments {
    /**
    * User-provided description of the task.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#description GoogleDataplexTask#description}
    */
    readonly description?: string;
    /**
    * User friendly display name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#display_name GoogleDataplexTask#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#id GoogleDataplexTask#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * User-defined labels for the task.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#labels GoogleDataplexTask#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The lake in which the task will be created in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#lake GoogleDataplexTask#lake}
    */
    readonly lake?: string;
    /**
    * The location in which the task will be created in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#location GoogleDataplexTask#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#project GoogleDataplexTask#project}
    */
    readonly project?: string;
    /**
    * The task Id of the task.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#task_id GoogleDataplexTask#task_id}
    */
    readonly taskId?: string;
    /**
    * execution_spec block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#execution_spec GoogleDataplexTask#execution_spec}
    */
    readonly executionSpec: GoogleDataplexTaskExecutionSpec;
    /**
    * notebook block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#notebook GoogleDataplexTask#notebook}
    */
    readonly notebook?: GoogleDataplexTaskNotebook;
    /**
    * spark block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#spark GoogleDataplexTask#spark}
    */
    readonly spark?: GoogleDataplexTaskSpark;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#timeouts GoogleDataplexTask#timeouts}
    */
    readonly timeouts?: GoogleDataplexTaskTimeouts;
    /**
    * trigger_spec block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#trigger_spec GoogleDataplexTask#trigger_spec}
    */
    readonly triggerSpec: GoogleDataplexTaskTriggerSpec;
}
export interface GoogleDataplexTaskExecutionStatusLatestJob {
}
export declare function googleDataplexTaskExecutionStatusLatestJobToTerraform(struct?: GoogleDataplexTaskExecutionStatusLatestJob): any;
export declare function googleDataplexTaskExecutionStatusLatestJobToHclTerraform(struct?: GoogleDataplexTaskExecutionStatusLatestJob): any;
export declare class GoogleDataplexTaskExecutionStatusLatestJobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataplexTaskExecutionStatusLatestJob | undefined;
    set internalValue(value: GoogleDataplexTaskExecutionStatusLatestJob | undefined);
    get endTime(): string;
    get message(): string;
    get name(): string;
    get retryCount(): number;
    get service(): string;
    get serviceJob(): string;
    get startTime(): string;
    get state(): string;
    get uid(): string;
}
export declare class GoogleDataplexTaskExecutionStatusLatestJobList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataplexTaskExecutionStatusLatestJobOutputReference;
}
export interface GoogleDataplexTaskExecutionStatus {
}
export declare function googleDataplexTaskExecutionStatusToTerraform(struct?: GoogleDataplexTaskExecutionStatus): any;
export declare function googleDataplexTaskExecutionStatusToHclTerraform(struct?: GoogleDataplexTaskExecutionStatus): any;
export declare class GoogleDataplexTaskExecutionStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataplexTaskExecutionStatus | undefined;
    set internalValue(value: GoogleDataplexTaskExecutionStatus | undefined);
    private _latestJob;
    get latestJob(): GoogleDataplexTaskExecutionStatusLatestJobList;
    get updateTime(): string;
}
export declare class GoogleDataplexTaskExecutionStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataplexTaskExecutionStatusOutputReference;
}
export interface GoogleDataplexTaskExecutionSpec {
    /**
    * The arguments to pass to the task. The args can use placeholders of the format ${placeholder} as part of key/value string. These will be interpolated before passing the args to the driver. Currently supported placeholders: - ${taskId} - ${job_time} To pass positional args, set the key as TASK_ARGS. The value should be a comma-separated string of all the positional arguments. To use a delimiter other than comma, refer to https://cloud.google.com/sdk/gcloud/reference/topic/escaping. In case of other keys being present in the args, then TASK_ARGS will be passed as the last argument. An object containing a list of 'key': value pairs. Example: { 'name': 'wrench', 'mass': '1.3kg', 'count': '3' }.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#args GoogleDataplexTask#args}
    */
    readonly args?: {
        [key: string]: string;
    };
    /**
    * The Cloud KMS key to use for encryption, of the form: projects/{project_number}/locations/{locationId}/keyRings/{key-ring-name}/cryptoKeys/{key-name}.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#kms_key GoogleDataplexTask#kms_key}
    */
    readonly kmsKey?: string;
    /**
    * The maximum duration after which the job execution is expired. A duration in seconds with up to nine fractional digits, ending with 's'. Example: '3.5s'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#max_job_execution_lifetime GoogleDataplexTask#max_job_execution_lifetime}
    */
    readonly maxJobExecutionLifetime?: string;
    /**
    * The project in which jobs are run. By default, the project containing the Lake is used. If a project is provided, the ExecutionSpec.service_account must belong to this project.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#project GoogleDataplexTask#project}
    */
    readonly project?: string;
    /**
    * Service account to use to execute a task. If not provided, the default Compute service account for the project is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#service_account GoogleDataplexTask#service_account}
    */
    readonly serviceAccount: string;
}
export declare function googleDataplexTaskExecutionSpecToTerraform(struct?: GoogleDataplexTaskExecutionSpecOutputReference | GoogleDataplexTaskExecutionSpec): any;
export declare function googleDataplexTaskExecutionSpecToHclTerraform(struct?: GoogleDataplexTaskExecutionSpecOutputReference | GoogleDataplexTaskExecutionSpec): any;
export declare class GoogleDataplexTaskExecutionSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexTaskExecutionSpec | undefined;
    set internalValue(value: GoogleDataplexTaskExecutionSpec | undefined);
    private _args?;
    get args(): {
        [key: string]: string;
    };
    set args(value: {
        [key: string]: string;
    });
    resetArgs(): void;
    get argsInput(): {
        [key: string]: string;
    } | undefined;
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
    private _maxJobExecutionLifetime?;
    get maxJobExecutionLifetime(): string;
    set maxJobExecutionLifetime(value: string);
    resetMaxJobExecutionLifetime(): void;
    get maxJobExecutionLifetimeInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    get serviceAccountInput(): string | undefined;
}
export interface GoogleDataplexTaskNotebookInfrastructureSpecBatch {
    /**
    * Total number of job executors. Executor Count should be between 2 and 100. [Default=2]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#executors_count GoogleDataplexTask#executors_count}
    */
    readonly executorsCount?: number;
    /**
    * Max configurable executors. If maxExecutorsCount > executorsCount, then auto-scaling is enabled. Max Executor Count should be between 2 and 1000. [Default=1000]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#max_executors_count GoogleDataplexTask#max_executors_count}
    */
    readonly maxExecutorsCount?: number;
}
export declare function googleDataplexTaskNotebookInfrastructureSpecBatchToTerraform(struct?: GoogleDataplexTaskNotebookInfrastructureSpecBatchOutputReference | GoogleDataplexTaskNotebookInfrastructureSpecBatch): any;
export declare function googleDataplexTaskNotebookInfrastructureSpecBatchToHclTerraform(struct?: GoogleDataplexTaskNotebookInfrastructureSpecBatchOutputReference | GoogleDataplexTaskNotebookInfrastructureSpecBatch): any;
export declare class GoogleDataplexTaskNotebookInfrastructureSpecBatchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexTaskNotebookInfrastructureSpecBatch | undefined;
    set internalValue(value: GoogleDataplexTaskNotebookInfrastructureSpecBatch | undefined);
    private _executorsCount?;
    get executorsCount(): number;
    set executorsCount(value: number);
    resetExecutorsCount(): void;
    get executorsCountInput(): number | undefined;
    private _maxExecutorsCount?;
    get maxExecutorsCount(): number;
    set maxExecutorsCount(value: number);
    resetMaxExecutorsCount(): void;
    get maxExecutorsCountInput(): number | undefined;
}
export interface GoogleDataplexTaskNotebookInfrastructureSpecContainerImage {
    /**
    * Container image to use.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#image GoogleDataplexTask#image}
    */
    readonly image?: string;
    /**
    * A list of Java JARS to add to the classpath. Valid input includes Cloud Storage URIs to Jar binaries. For example, gs://bucket-name/my/path/to/file.jar
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#java_jars GoogleDataplexTask#java_jars}
    */
    readonly javaJars?: string[];
    /**
    * Override to common configuration of open source components installed on the Dataproc cluster. The properties to set on daemon config files. Property keys are specified in prefix:property format, for example core:hadoop.tmp.dir. For more information, see Cluster properties.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#properties GoogleDataplexTask#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * A list of python packages to be installed. Valid formats include Cloud Storage URI to a PIP installable library. For example, gs://bucket-name/my/path/to/lib.tar.gz
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#python_packages GoogleDataplexTask#python_packages}
    */
    readonly pythonPackages?: string[];
}
export declare function googleDataplexTaskNotebookInfrastructureSpecContainerImageToTerraform(struct?: GoogleDataplexTaskNotebookInfrastructureSpecContainerImageOutputReference | GoogleDataplexTaskNotebookInfrastructureSpecContainerImage): any;
export declare function googleDataplexTaskNotebookInfrastructureSpecContainerImageToHclTerraform(struct?: GoogleDataplexTaskNotebookInfrastructureSpecContainerImageOutputReference | GoogleDataplexTaskNotebookInfrastructureSpecContainerImage): any;
export declare class GoogleDataplexTaskNotebookInfrastructureSpecContainerImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexTaskNotebookInfrastructureSpecContainerImage | undefined;
    set internalValue(value: GoogleDataplexTaskNotebookInfrastructureSpecContainerImage | undefined);
    private _image?;
    get image(): string;
    set image(value: string);
    resetImage(): void;
    get imageInput(): string | undefined;
    private _javaJars?;
    get javaJars(): string[];
    set javaJars(value: string[]);
    resetJavaJars(): void;
    get javaJarsInput(): string[] | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _pythonPackages?;
    get pythonPackages(): string[];
    set pythonPackages(value: string[]);
    resetPythonPackages(): void;
    get pythonPackagesInput(): string[] | undefined;
}
export interface GoogleDataplexTaskNotebookInfrastructureSpecVpcNetwork {
    /**
    * The Cloud VPC network in which the job is run. By default, the Cloud VPC network named Default within the project is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#network GoogleDataplexTask#network}
    */
    readonly network?: string;
    /**
    * List of network tags to apply to the job.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#network_tags GoogleDataplexTask#network_tags}
    */
    readonly networkTags?: string[];
    /**
    * The Cloud VPC sub-network in which the job is run.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#sub_network GoogleDataplexTask#sub_network}
    */
    readonly subNetwork?: string;
}
export declare function googleDataplexTaskNotebookInfrastructureSpecVpcNetworkToTerraform(struct?: GoogleDataplexTaskNotebookInfrastructureSpecVpcNetworkOutputReference | GoogleDataplexTaskNotebookInfrastructureSpecVpcNetwork): any;
export declare function googleDataplexTaskNotebookInfrastructureSpecVpcNetworkToHclTerraform(struct?: GoogleDataplexTaskNotebookInfrastructureSpecVpcNetworkOutputReference | GoogleDataplexTaskNotebookInfrastructureSpecVpcNetwork): any;
export declare class GoogleDataplexTaskNotebookInfrastructureSpecVpcNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexTaskNotebookInfrastructureSpecVpcNetwork | undefined;
    set internalValue(value: GoogleDataplexTaskNotebookInfrastructureSpecVpcNetwork | undefined);
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _networkTags?;
    get networkTags(): string[];
    set networkTags(value: string[]);
    resetNetworkTags(): void;
    get networkTagsInput(): string[] | undefined;
    private _subNetwork?;
    get subNetwork(): string;
    set subNetwork(value: string);
    resetSubNetwork(): void;
    get subNetworkInput(): string | undefined;
}
export interface GoogleDataplexTaskNotebookInfrastructureSpec {
    /**
    * batch block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#batch GoogleDataplexTask#batch}
    */
    readonly batch?: GoogleDataplexTaskNotebookInfrastructureSpecBatch;
    /**
    * container_image block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#container_image GoogleDataplexTask#container_image}
    */
    readonly containerImage?: GoogleDataplexTaskNotebookInfrastructureSpecContainerImage;
    /**
    * vpc_network block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#vpc_network GoogleDataplexTask#vpc_network}
    */
    readonly vpcNetwork?: GoogleDataplexTaskNotebookInfrastructureSpecVpcNetwork;
}
export declare function googleDataplexTaskNotebookInfrastructureSpecToTerraform(struct?: GoogleDataplexTaskNotebookInfrastructureSpecOutputReference | GoogleDataplexTaskNotebookInfrastructureSpec): any;
export declare function googleDataplexTaskNotebookInfrastructureSpecToHclTerraform(struct?: GoogleDataplexTaskNotebookInfrastructureSpecOutputReference | GoogleDataplexTaskNotebookInfrastructureSpec): any;
export declare class GoogleDataplexTaskNotebookInfrastructureSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexTaskNotebookInfrastructureSpec | undefined;
    set internalValue(value: GoogleDataplexTaskNotebookInfrastructureSpec | undefined);
    private _batch;
    get batch(): GoogleDataplexTaskNotebookInfrastructureSpecBatchOutputReference;
    putBatch(value: GoogleDataplexTaskNotebookInfrastructureSpecBatch): void;
    resetBatch(): void;
    get batchInput(): GoogleDataplexTaskNotebookInfrastructureSpecBatch | undefined;
    private _containerImage;
    get containerImage(): GoogleDataplexTaskNotebookInfrastructureSpecContainerImageOutputReference;
    putContainerImage(value: GoogleDataplexTaskNotebookInfrastructureSpecContainerImage): void;
    resetContainerImage(): void;
    get containerImageInput(): GoogleDataplexTaskNotebookInfrastructureSpecContainerImage | undefined;
    private _vpcNetwork;
    get vpcNetwork(): GoogleDataplexTaskNotebookInfrastructureSpecVpcNetworkOutputReference;
    putVpcNetwork(value: GoogleDataplexTaskNotebookInfrastructureSpecVpcNetwork): void;
    resetVpcNetwork(): void;
    get vpcNetworkInput(): GoogleDataplexTaskNotebookInfrastructureSpecVpcNetwork | undefined;
}
export interface GoogleDataplexTaskNotebook {
    /**
    * Cloud Storage URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#archive_uris GoogleDataplexTask#archive_uris}
    */
    readonly archiveUris?: string[];
    /**
    * Cloud Storage URIs of files to be placed in the working directory of each executor.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#file_uris GoogleDataplexTask#file_uris}
    */
    readonly fileUris?: string[];
    /**
    * Path to input notebook. This can be the Cloud Storage URI of the notebook file or the path to a Notebook Content. The execution args are accessible as environment variables (TASK_key=value).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#notebook GoogleDataplexTask#notebook}
    */
    readonly notebook: string;
    /**
    * infrastructure_spec block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#infrastructure_spec GoogleDataplexTask#infrastructure_spec}
    */
    readonly infrastructureSpec?: GoogleDataplexTaskNotebookInfrastructureSpec;
}
export declare function googleDataplexTaskNotebookToTerraform(struct?: GoogleDataplexTaskNotebookOutputReference | GoogleDataplexTaskNotebook): any;
export declare function googleDataplexTaskNotebookToHclTerraform(struct?: GoogleDataplexTaskNotebookOutputReference | GoogleDataplexTaskNotebook): any;
export declare class GoogleDataplexTaskNotebookOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexTaskNotebook | undefined;
    set internalValue(value: GoogleDataplexTaskNotebook | undefined);
    private _archiveUris?;
    get archiveUris(): string[];
    set archiveUris(value: string[]);
    resetArchiveUris(): void;
    get archiveUrisInput(): string[] | undefined;
    private _fileUris?;
    get fileUris(): string[];
    set fileUris(value: string[]);
    resetFileUris(): void;
    get fileUrisInput(): string[] | undefined;
    private _notebook?;
    get notebook(): string;
    set notebook(value: string);
    get notebookInput(): string | undefined;
    private _infrastructureSpec;
    get infrastructureSpec(): GoogleDataplexTaskNotebookInfrastructureSpecOutputReference;
    putInfrastructureSpec(value: GoogleDataplexTaskNotebookInfrastructureSpec): void;
    resetInfrastructureSpec(): void;
    get infrastructureSpecInput(): GoogleDataplexTaskNotebookInfrastructureSpec | undefined;
}
export interface GoogleDataplexTaskSparkInfrastructureSpecBatch {
    /**
    * Total number of job executors. Executor Count should be between 2 and 100. [Default=2]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#executors_count GoogleDataplexTask#executors_count}
    */
    readonly executorsCount?: number;
    /**
    * Max configurable executors. If maxExecutorsCount > executorsCount, then auto-scaling is enabled. Max Executor Count should be between 2 and 1000. [Default=1000]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#max_executors_count GoogleDataplexTask#max_executors_count}
    */
    readonly maxExecutorsCount?: number;
}
export declare function googleDataplexTaskSparkInfrastructureSpecBatchToTerraform(struct?: GoogleDataplexTaskSparkInfrastructureSpecBatchOutputReference | GoogleDataplexTaskSparkInfrastructureSpecBatch): any;
export declare function googleDataplexTaskSparkInfrastructureSpecBatchToHclTerraform(struct?: GoogleDataplexTaskSparkInfrastructureSpecBatchOutputReference | GoogleDataplexTaskSparkInfrastructureSpecBatch): any;
export declare class GoogleDataplexTaskSparkInfrastructureSpecBatchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexTaskSparkInfrastructureSpecBatch | undefined;
    set internalValue(value: GoogleDataplexTaskSparkInfrastructureSpecBatch | undefined);
    private _executorsCount?;
    get executorsCount(): number;
    set executorsCount(value: number);
    resetExecutorsCount(): void;
    get executorsCountInput(): number | undefined;
    private _maxExecutorsCount?;
    get maxExecutorsCount(): number;
    set maxExecutorsCount(value: number);
    resetMaxExecutorsCount(): void;
    get maxExecutorsCountInput(): number | undefined;
}
export interface GoogleDataplexTaskSparkInfrastructureSpecContainerImage {
    /**
    * Container image to use.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#image GoogleDataplexTask#image}
    */
    readonly image?: string;
    /**
    * A list of Java JARS to add to the classpath. Valid input includes Cloud Storage URIs to Jar binaries. For example, gs://bucket-name/my/path/to/file.jar
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#java_jars GoogleDataplexTask#java_jars}
    */
    readonly javaJars?: string[];
    /**
    * Override to common configuration of open source components installed on the Dataproc cluster. The properties to set on daemon config files. Property keys are specified in prefix:property format, for example core:hadoop.tmp.dir. For more information, see Cluster properties.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#properties GoogleDataplexTask#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * A list of python packages to be installed. Valid formats include Cloud Storage URI to a PIP installable library. For example, gs://bucket-name/my/path/to/lib.tar.gz
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#python_packages GoogleDataplexTask#python_packages}
    */
    readonly pythonPackages?: string[];
}
export declare function googleDataplexTaskSparkInfrastructureSpecContainerImageToTerraform(struct?: GoogleDataplexTaskSparkInfrastructureSpecContainerImageOutputReference | GoogleDataplexTaskSparkInfrastructureSpecContainerImage): any;
export declare function googleDataplexTaskSparkInfrastructureSpecContainerImageToHclTerraform(struct?: GoogleDataplexTaskSparkInfrastructureSpecContainerImageOutputReference | GoogleDataplexTaskSparkInfrastructureSpecContainerImage): any;
export declare class GoogleDataplexTaskSparkInfrastructureSpecContainerImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexTaskSparkInfrastructureSpecContainerImage | undefined;
    set internalValue(value: GoogleDataplexTaskSparkInfrastructureSpecContainerImage | undefined);
    private _image?;
    get image(): string;
    set image(value: string);
    resetImage(): void;
    get imageInput(): string | undefined;
    private _javaJars?;
    get javaJars(): string[];
    set javaJars(value: string[]);
    resetJavaJars(): void;
    get javaJarsInput(): string[] | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _pythonPackages?;
    get pythonPackages(): string[];
    set pythonPackages(value: string[]);
    resetPythonPackages(): void;
    get pythonPackagesInput(): string[] | undefined;
}
export interface GoogleDataplexTaskSparkInfrastructureSpecVpcNetwork {
    /**
    * The Cloud VPC network in which the job is run. By default, the Cloud VPC network named Default within the project is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#network GoogleDataplexTask#network}
    */
    readonly network?: string;
    /**
    * List of network tags to apply to the job.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#network_tags GoogleDataplexTask#network_tags}
    */
    readonly networkTags?: string[];
    /**
    * The Cloud VPC sub-network in which the job is run.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#sub_network GoogleDataplexTask#sub_network}
    */
    readonly subNetwork?: string;
}
export declare function googleDataplexTaskSparkInfrastructureSpecVpcNetworkToTerraform(struct?: GoogleDataplexTaskSparkInfrastructureSpecVpcNetworkOutputReference | GoogleDataplexTaskSparkInfrastructureSpecVpcNetwork): any;
export declare function googleDataplexTaskSparkInfrastructureSpecVpcNetworkToHclTerraform(struct?: GoogleDataplexTaskSparkInfrastructureSpecVpcNetworkOutputReference | GoogleDataplexTaskSparkInfrastructureSpecVpcNetwork): any;
export declare class GoogleDataplexTaskSparkInfrastructureSpecVpcNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexTaskSparkInfrastructureSpecVpcNetwork | undefined;
    set internalValue(value: GoogleDataplexTaskSparkInfrastructureSpecVpcNetwork | undefined);
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _networkTags?;
    get networkTags(): string[];
    set networkTags(value: string[]);
    resetNetworkTags(): void;
    get networkTagsInput(): string[] | undefined;
    private _subNetwork?;
    get subNetwork(): string;
    set subNetwork(value: string);
    resetSubNetwork(): void;
    get subNetworkInput(): string | undefined;
}
export interface GoogleDataplexTaskSparkInfrastructureSpec {
    /**
    * batch block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#batch GoogleDataplexTask#batch}
    */
    readonly batch?: GoogleDataplexTaskSparkInfrastructureSpecBatch;
    /**
    * container_image block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#container_image GoogleDataplexTask#container_image}
    */
    readonly containerImage?: GoogleDataplexTaskSparkInfrastructureSpecContainerImage;
    /**
    * vpc_network block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#vpc_network GoogleDataplexTask#vpc_network}
    */
    readonly vpcNetwork?: GoogleDataplexTaskSparkInfrastructureSpecVpcNetwork;
}
export declare function googleDataplexTaskSparkInfrastructureSpecToTerraform(struct?: GoogleDataplexTaskSparkInfrastructureSpecOutputReference | GoogleDataplexTaskSparkInfrastructureSpec): any;
export declare function googleDataplexTaskSparkInfrastructureSpecToHclTerraform(struct?: GoogleDataplexTaskSparkInfrastructureSpecOutputReference | GoogleDataplexTaskSparkInfrastructureSpec): any;
export declare class GoogleDataplexTaskSparkInfrastructureSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexTaskSparkInfrastructureSpec | undefined;
    set internalValue(value: GoogleDataplexTaskSparkInfrastructureSpec | undefined);
    private _batch;
    get batch(): GoogleDataplexTaskSparkInfrastructureSpecBatchOutputReference;
    putBatch(value: GoogleDataplexTaskSparkInfrastructureSpecBatch): void;
    resetBatch(): void;
    get batchInput(): GoogleDataplexTaskSparkInfrastructureSpecBatch | undefined;
    private _containerImage;
    get containerImage(): GoogleDataplexTaskSparkInfrastructureSpecContainerImageOutputReference;
    putContainerImage(value: GoogleDataplexTaskSparkInfrastructureSpecContainerImage): void;
    resetContainerImage(): void;
    get containerImageInput(): GoogleDataplexTaskSparkInfrastructureSpecContainerImage | undefined;
    private _vpcNetwork;
    get vpcNetwork(): GoogleDataplexTaskSparkInfrastructureSpecVpcNetworkOutputReference;
    putVpcNetwork(value: GoogleDataplexTaskSparkInfrastructureSpecVpcNetwork): void;
    resetVpcNetwork(): void;
    get vpcNetworkInput(): GoogleDataplexTaskSparkInfrastructureSpecVpcNetwork | undefined;
}
export interface GoogleDataplexTaskSpark {
    /**
    * Cloud Storage URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#archive_uris GoogleDataplexTask#archive_uris}
    */
    readonly archiveUris?: string[];
    /**
    * Cloud Storage URIs of files to be placed in the working directory of each executor.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#file_uris GoogleDataplexTask#file_uris}
    */
    readonly fileUris?: string[];
    /**
    * The name of the driver's main class. The jar file that contains the class must be in the default CLASSPATH or specified in jar_file_uris. The execution args are passed in as a sequence of named process arguments (--key=value).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#main_class GoogleDataplexTask#main_class}
    */
    readonly mainClass?: string;
    /**
    * The Cloud Storage URI of the jar file that contains the main class. The execution args are passed in as a sequence of named process arguments (--key=value).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#main_jar_file_uri GoogleDataplexTask#main_jar_file_uri}
    */
    readonly mainJarFileUri?: string;
    /**
    * The Gcloud Storage URI of the main Python file to use as the driver. Must be a .py file. The execution args are passed in as a sequence of named process arguments (--key=value).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#python_script_file GoogleDataplexTask#python_script_file}
    */
    readonly pythonScriptFile?: string;
    /**
    * The query text. The execution args are used to declare a set of script variables (set key='value';).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#sql_script GoogleDataplexTask#sql_script}
    */
    readonly sqlScript?: string;
    /**
    * A reference to a query file. This can be the Cloud Storage URI of the query file or it can the path to a SqlScript Content. The execution args are used to declare a set of script variables (set key='value';).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#sql_script_file GoogleDataplexTask#sql_script_file}
    */
    readonly sqlScriptFile?: string;
    /**
    * infrastructure_spec block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#infrastructure_spec GoogleDataplexTask#infrastructure_spec}
    */
    readonly infrastructureSpec?: GoogleDataplexTaskSparkInfrastructureSpec;
}
export declare function googleDataplexTaskSparkToTerraform(struct?: GoogleDataplexTaskSparkOutputReference | GoogleDataplexTaskSpark): any;
export declare function googleDataplexTaskSparkToHclTerraform(struct?: GoogleDataplexTaskSparkOutputReference | GoogleDataplexTaskSpark): any;
export declare class GoogleDataplexTaskSparkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexTaskSpark | undefined;
    set internalValue(value: GoogleDataplexTaskSpark | undefined);
    private _archiveUris?;
    get archiveUris(): string[];
    set archiveUris(value: string[]);
    resetArchiveUris(): void;
    get archiveUrisInput(): string[] | undefined;
    private _fileUris?;
    get fileUris(): string[];
    set fileUris(value: string[]);
    resetFileUris(): void;
    get fileUrisInput(): string[] | undefined;
    private _mainClass?;
    get mainClass(): string;
    set mainClass(value: string);
    resetMainClass(): void;
    get mainClassInput(): string | undefined;
    private _mainJarFileUri?;
    get mainJarFileUri(): string;
    set mainJarFileUri(value: string);
    resetMainJarFileUri(): void;
    get mainJarFileUriInput(): string | undefined;
    private _pythonScriptFile?;
    get pythonScriptFile(): string;
    set pythonScriptFile(value: string);
    resetPythonScriptFile(): void;
    get pythonScriptFileInput(): string | undefined;
    private _sqlScript?;
    get sqlScript(): string;
    set sqlScript(value: string);
    resetSqlScript(): void;
    get sqlScriptInput(): string | undefined;
    private _sqlScriptFile?;
    get sqlScriptFile(): string;
    set sqlScriptFile(value: string);
    resetSqlScriptFile(): void;
    get sqlScriptFileInput(): string | undefined;
    private _infrastructureSpec;
    get infrastructureSpec(): GoogleDataplexTaskSparkInfrastructureSpecOutputReference;
    putInfrastructureSpec(value: GoogleDataplexTaskSparkInfrastructureSpec): void;
    resetInfrastructureSpec(): void;
    get infrastructureSpecInput(): GoogleDataplexTaskSparkInfrastructureSpec | undefined;
}
export interface GoogleDataplexTaskTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#create GoogleDataplexTask#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#delete GoogleDataplexTask#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#update GoogleDataplexTask#update}
    */
    readonly update?: string;
}
export declare function googleDataplexTaskTimeoutsToTerraform(struct?: GoogleDataplexTaskTimeouts | cdktf.IResolvable): any;
export declare function googleDataplexTaskTimeoutsToHclTerraform(struct?: GoogleDataplexTaskTimeouts | cdktf.IResolvable): any;
export declare class GoogleDataplexTaskTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexTaskTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataplexTaskTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleDataplexTaskTriggerSpec {
    /**
    * Prevent the task from executing. This does not cancel already running tasks. It is intended to temporarily disable RECURRING tasks.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#disabled GoogleDataplexTask#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * Number of retry attempts before aborting. Set to zero to never attempt to retry a failed task.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#max_retries GoogleDataplexTask#max_retries}
    */
    readonly maxRetries?: number;
    /**
    * Cron schedule (https://en.wikipedia.org/wiki/Cron) for running tasks periodically. To explicitly set a timezone to the cron tab, apply a prefix in the cron tab: 'CRON_TZ=${IANA_TIME_ZONE}' or 'TZ=${IANA_TIME_ZONE}'. The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone database. For example, CRON_TZ=America/New_York 1 * * * *, or TZ=America/New_York 1 * * * *. This field is required for RECURRING tasks.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#schedule GoogleDataplexTask#schedule}
    */
    readonly schedule?: string;
    /**
    * The first run of the task will be after this time. If not specified, the task will run shortly after being submitted if ON_DEMAND and based on the schedule if RECURRING.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#start_time GoogleDataplexTask#start_time}
    */
    readonly startTime?: string;
    /**
    * Trigger type of the user-specified Task Possible values: ["ON_DEMAND", "RECURRING"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#type GoogleDataplexTask#type}
    */
    readonly type: string;
}
export declare function googleDataplexTaskTriggerSpecToTerraform(struct?: GoogleDataplexTaskTriggerSpecOutputReference | GoogleDataplexTaskTriggerSpec): any;
export declare function googleDataplexTaskTriggerSpecToHclTerraform(struct?: GoogleDataplexTaskTriggerSpecOutputReference | GoogleDataplexTaskTriggerSpec): any;
export declare class GoogleDataplexTaskTriggerSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexTaskTriggerSpec | undefined;
    set internalValue(value: GoogleDataplexTaskTriggerSpec | undefined);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _maxRetries?;
    get maxRetries(): number;
    set maxRetries(value: number);
    resetMaxRetries(): void;
    get maxRetriesInput(): number | undefined;
    private _schedule?;
    get schedule(): string;
    set schedule(value: string);
    resetSchedule(): void;
    get scheduleInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task google_dataplex_task}
*/
export declare class GoogleDataplexTask extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dataplex_task";
    /**
    * Generates CDKTF code for importing a GoogleDataplexTask resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleDataplexTask to import
    * @param importFromId The id of the existing GoogleDataplexTask that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleDataplexTask to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataplex_task google_dataplex_task} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDataplexTaskConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDataplexTaskConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _executionStatus;
    get executionStatus(): GoogleDataplexTaskExecutionStatusList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _lake?;
    get lake(): string;
    set lake(value: string);
    resetLake(): void;
    get lakeInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    private _taskId?;
    get taskId(): string;
    set taskId(value: string);
    resetTaskId(): void;
    get taskIdInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get uid(): string;
    get updateTime(): string;
    private _executionSpec;
    get executionSpec(): GoogleDataplexTaskExecutionSpecOutputReference;
    putExecutionSpec(value: GoogleDataplexTaskExecutionSpec): void;
    get executionSpecInput(): GoogleDataplexTaskExecutionSpec | undefined;
    private _notebook;
    get notebook(): GoogleDataplexTaskNotebookOutputReference;
    putNotebook(value: GoogleDataplexTaskNotebook): void;
    resetNotebook(): void;
    get notebookInput(): GoogleDataplexTaskNotebook | undefined;
    private _spark;
    get spark(): GoogleDataplexTaskSparkOutputReference;
    putSpark(value: GoogleDataplexTaskSpark): void;
    resetSpark(): void;
    get sparkInput(): GoogleDataplexTaskSpark | undefined;
    private _timeouts;
    get timeouts(): GoogleDataplexTaskTimeoutsOutputReference;
    putTimeouts(value: GoogleDataplexTaskTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDataplexTaskTimeouts | undefined;
    private _triggerSpec;
    get triggerSpec(): GoogleDataplexTaskTriggerSpecOutputReference;
    putTriggerSpec(value: GoogleDataplexTaskTriggerSpec): void;
    get triggerSpecInput(): GoogleDataplexTaskTriggerSpec | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
