/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDataprocJobConfig extends cdktf.TerraformMetaArguments {
    /**
    * By default, you can only delete inactive jobs within Dataproc. Setting this to true, and calling destroy, will ensure that the job is first cancelled before issuing the delete.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#force_delete GoogleDataprocJob#force_delete}
    */
    readonly forceDelete?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#id GoogleDataprocJob#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Optional. The labels to associate with this job.
    *
    * 				**Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * 				Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#labels GoogleDataprocJob#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The project in which the cluster can be found and jobs subsequently run against. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#project GoogleDataprocJob#project}
    */
    readonly project?: string;
    /**
    * The Cloud Dataproc region. This essentially determines which clusters are available for this job to be submitted to. If not specified, defaults to global.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#region GoogleDataprocJob#region}
    */
    readonly region?: string;
    /**
    * hadoop_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#hadoop_config GoogleDataprocJob#hadoop_config}
    */
    readonly hadoopConfig?: GoogleDataprocJobHadoopConfig;
    /**
    * hive_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#hive_config GoogleDataprocJob#hive_config}
    */
    readonly hiveConfig?: GoogleDataprocJobHiveConfig;
    /**
    * pig_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#pig_config GoogleDataprocJob#pig_config}
    */
    readonly pigConfig?: GoogleDataprocJobPigConfig;
    /**
    * placement block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#placement GoogleDataprocJob#placement}
    */
    readonly placement: GoogleDataprocJobPlacement;
    /**
    * presto_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#presto_config GoogleDataprocJob#presto_config}
    */
    readonly prestoConfig?: GoogleDataprocJobPrestoConfig;
    /**
    * pyspark_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#pyspark_config GoogleDataprocJob#pyspark_config}
    */
    readonly pysparkConfig?: GoogleDataprocJobPysparkConfig;
    /**
    * reference block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#reference GoogleDataprocJob#reference}
    */
    readonly reference?: GoogleDataprocJobReference;
    /**
    * scheduling block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#scheduling GoogleDataprocJob#scheduling}
    */
    readonly scheduling?: GoogleDataprocJobScheduling;
    /**
    * spark_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#spark_config GoogleDataprocJob#spark_config}
    */
    readonly sparkConfig?: GoogleDataprocJobSparkConfig;
    /**
    * sparksql_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#sparksql_config GoogleDataprocJob#sparksql_config}
    */
    readonly sparksqlConfig?: GoogleDataprocJobSparksqlConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#timeouts GoogleDataprocJob#timeouts}
    */
    readonly timeouts?: GoogleDataprocJobTimeouts;
}
export interface GoogleDataprocJobStatus {
}
export declare function googleDataprocJobStatusToTerraform(struct?: GoogleDataprocJobStatus): any;
export declare function googleDataprocJobStatusToHclTerraform(struct?: GoogleDataprocJobStatus): any;
export declare class GoogleDataprocJobStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataprocJobStatus | undefined;
    set internalValue(value: GoogleDataprocJobStatus | undefined);
    get details(): string;
    get state(): string;
    get stateStartTime(): string;
    get substate(): string;
}
export declare class GoogleDataprocJobStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataprocJobStatusOutputReference;
}
export interface GoogleDataprocJobHadoopConfigLoggingConfig {
    /**
    * Optional. The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#driver_log_levels GoogleDataprocJob#driver_log_levels}
    */
    readonly driverLogLevels: {
        [key: string]: string;
    };
}
export declare function googleDataprocJobHadoopConfigLoggingConfigToTerraform(struct?: GoogleDataprocJobHadoopConfigLoggingConfigOutputReference | GoogleDataprocJobHadoopConfigLoggingConfig): any;
export declare function googleDataprocJobHadoopConfigLoggingConfigToHclTerraform(struct?: GoogleDataprocJobHadoopConfigLoggingConfigOutputReference | GoogleDataprocJobHadoopConfigLoggingConfig): any;
export declare class GoogleDataprocJobHadoopConfigLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocJobHadoopConfigLoggingConfig | undefined;
    set internalValue(value: GoogleDataprocJobHadoopConfigLoggingConfig | undefined);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    };
    set driverLogLevels(value: {
        [key: string]: string;
    });
    get driverLogLevelsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleDataprocJobHadoopConfig {
    /**
    * HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#archive_uris GoogleDataprocJob#archive_uris}
    */
    readonly archiveUris?: string[];
    /**
    * The arguments to pass to the driver.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#args GoogleDataprocJob#args}
    */
    readonly args?: string[];
    /**
    * HCFS URIs of files to be copied to the working directory of Spark drivers and distributed tasks. Useful for naively parallel tasks.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#file_uris GoogleDataprocJob#file_uris}
    */
    readonly fileUris?: string[];
    /**
    * HCFS URIs of jar files to add to the CLASSPATHs of the Spark driver and tasks.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#jar_file_uris GoogleDataprocJob#jar_file_uris}
    */
    readonly jarFileUris?: string[];
    /**
    * The class containing the main method of the driver. Must be in a provided jar or jar that is already on the classpath. Conflicts with main_jar_file_uri
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#main_class GoogleDataprocJob#main_class}
    */
    readonly mainClass?: string;
    /**
    * The HCFS URI of jar file containing the driver jar. Conflicts with main_class
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#main_jar_file_uri GoogleDataprocJob#main_jar_file_uri}
    */
    readonly mainJarFileUri?: string;
    /**
    * A mapping of property names to values, used to configure Spark. Properties that conflict with values set by the Cloud Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#properties GoogleDataprocJob#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * logging_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#logging_config GoogleDataprocJob#logging_config}
    */
    readonly loggingConfig?: GoogleDataprocJobHadoopConfigLoggingConfig;
}
export declare function googleDataprocJobHadoopConfigToTerraform(struct?: GoogleDataprocJobHadoopConfigOutputReference | GoogleDataprocJobHadoopConfig): any;
export declare function googleDataprocJobHadoopConfigToHclTerraform(struct?: GoogleDataprocJobHadoopConfigOutputReference | GoogleDataprocJobHadoopConfig): any;
export declare class GoogleDataprocJobHadoopConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocJobHadoopConfig | undefined;
    set internalValue(value: GoogleDataprocJobHadoopConfig | undefined);
    private _archiveUris?;
    get archiveUris(): string[];
    set archiveUris(value: string[]);
    resetArchiveUris(): void;
    get archiveUrisInput(): string[] | undefined;
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _fileUris?;
    get fileUris(): string[];
    set fileUris(value: string[]);
    resetFileUris(): void;
    get fileUrisInput(): string[] | undefined;
    private _jarFileUris?;
    get jarFileUris(): string[];
    set jarFileUris(value: string[]);
    resetJarFileUris(): void;
    get jarFileUrisInput(): string[] | undefined;
    private _mainClass?;
    get mainClass(): string;
    set mainClass(value: string);
    resetMainClass(): void;
    get mainClassInput(): string | undefined;
    private _mainJarFileUri?;
    get mainJarFileUri(): string;
    set mainJarFileUri(value: string);
    resetMainJarFileUri(): void;
    get mainJarFileUriInput(): string | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _loggingConfig;
    get loggingConfig(): GoogleDataprocJobHadoopConfigLoggingConfigOutputReference;
    putLoggingConfig(value: GoogleDataprocJobHadoopConfigLoggingConfig): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): GoogleDataprocJobHadoopConfigLoggingConfig | undefined;
}
export interface GoogleDataprocJobHiveConfig {
    /**
    * Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#continue_on_failure GoogleDataprocJob#continue_on_failure}
    */
    readonly continueOnFailure?: boolean | cdktf.IResolvable;
    /**
    * HCFS URIs of jar files to add to the CLASSPATH of the Hive server and Hadoop MapReduce (MR) tasks. Can contain Hive SerDes and UDFs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#jar_file_uris GoogleDataprocJob#jar_file_uris}
    */
    readonly jarFileUris?: string[];
    /**
    * A mapping of property names and values, used to configure Hive. Properties that conflict with values set by the Cloud Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml, /etc/hive/conf/hive-site.xml, and classes in user code.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#properties GoogleDataprocJob#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * HCFS URI of file containing Hive script to execute as the job. Conflicts with query_list
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#query_file_uri GoogleDataprocJob#query_file_uri}
    */
    readonly queryFileUri?: string;
    /**
    * The list of Hive queries or statements to execute as part of the job. Conflicts with query_file_uri
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#query_list GoogleDataprocJob#query_list}
    */
    readonly queryList?: string[];
    /**
    * Mapping of query variable names to values (equivalent to the Hive command: SET name="value";).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#script_variables GoogleDataprocJob#script_variables}
    */
    readonly scriptVariables?: {
        [key: string]: string;
    };
}
export declare function googleDataprocJobHiveConfigToTerraform(struct?: GoogleDataprocJobHiveConfigOutputReference | GoogleDataprocJobHiveConfig): any;
export declare function googleDataprocJobHiveConfigToHclTerraform(struct?: GoogleDataprocJobHiveConfigOutputReference | GoogleDataprocJobHiveConfig): any;
export declare class GoogleDataprocJobHiveConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocJobHiveConfig | undefined;
    set internalValue(value: GoogleDataprocJobHiveConfig | undefined);
    private _continueOnFailure?;
    get continueOnFailure(): boolean | cdktf.IResolvable;
    set continueOnFailure(value: boolean | cdktf.IResolvable);
    resetContinueOnFailure(): void;
    get continueOnFailureInput(): boolean | cdktf.IResolvable | undefined;
    private _jarFileUris?;
    get jarFileUris(): string[];
    set jarFileUris(value: string[]);
    resetJarFileUris(): void;
    get jarFileUrisInput(): string[] | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _queryFileUri?;
    get queryFileUri(): string;
    set queryFileUri(value: string);
    resetQueryFileUri(): void;
    get queryFileUriInput(): string | undefined;
    private _queryList?;
    get queryList(): string[];
    set queryList(value: string[]);
    resetQueryList(): void;
    get queryListInput(): string[] | undefined;
    private _scriptVariables?;
    get scriptVariables(): {
        [key: string]: string;
    };
    set scriptVariables(value: {
        [key: string]: string;
    });
    resetScriptVariables(): void;
    get scriptVariablesInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleDataprocJobPigConfigLoggingConfig {
    /**
    * Optional. The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#driver_log_levels GoogleDataprocJob#driver_log_levels}
    */
    readonly driverLogLevels: {
        [key: string]: string;
    };
}
export declare function googleDataprocJobPigConfigLoggingConfigToTerraform(struct?: GoogleDataprocJobPigConfigLoggingConfigOutputReference | GoogleDataprocJobPigConfigLoggingConfig): any;
export declare function googleDataprocJobPigConfigLoggingConfigToHclTerraform(struct?: GoogleDataprocJobPigConfigLoggingConfigOutputReference | GoogleDataprocJobPigConfigLoggingConfig): any;
export declare class GoogleDataprocJobPigConfigLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocJobPigConfigLoggingConfig | undefined;
    set internalValue(value: GoogleDataprocJobPigConfigLoggingConfig | undefined);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    };
    set driverLogLevels(value: {
        [key: string]: string;
    });
    get driverLogLevelsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleDataprocJobPigConfig {
    /**
    * Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#continue_on_failure GoogleDataprocJob#continue_on_failure}
    */
    readonly continueOnFailure?: boolean | cdktf.IResolvable;
    /**
    * HCFS URIs of jar files to add to the CLASSPATH of the Pig Client and Hadoop MapReduce (MR) tasks. Can contain Pig UDFs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#jar_file_uris GoogleDataprocJob#jar_file_uris}
    */
    readonly jarFileUris?: string[];
    /**
    * A mapping of property names to values, used to configure Pig. Properties that conflict with values set by the Cloud Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml, /etc/pig/conf/pig.properties, and classes in user code.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#properties GoogleDataprocJob#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * HCFS URI of file containing Hive script to execute as the job. Conflicts with query_list
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#query_file_uri GoogleDataprocJob#query_file_uri}
    */
    readonly queryFileUri?: string;
    /**
    * The list of Hive queries or statements to execute as part of the job. Conflicts with query_file_uri
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#query_list GoogleDataprocJob#query_list}
    */
    readonly queryList?: string[];
    /**
    * Mapping of query variable names to values (equivalent to the Pig command: name=[value]).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#script_variables GoogleDataprocJob#script_variables}
    */
    readonly scriptVariables?: {
        [key: string]: string;
    };
    /**
    * logging_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#logging_config GoogleDataprocJob#logging_config}
    */
    readonly loggingConfig?: GoogleDataprocJobPigConfigLoggingConfig;
}
export declare function googleDataprocJobPigConfigToTerraform(struct?: GoogleDataprocJobPigConfigOutputReference | GoogleDataprocJobPigConfig): any;
export declare function googleDataprocJobPigConfigToHclTerraform(struct?: GoogleDataprocJobPigConfigOutputReference | GoogleDataprocJobPigConfig): any;
export declare class GoogleDataprocJobPigConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocJobPigConfig | undefined;
    set internalValue(value: GoogleDataprocJobPigConfig | undefined);
    private _continueOnFailure?;
    get continueOnFailure(): boolean | cdktf.IResolvable;
    set continueOnFailure(value: boolean | cdktf.IResolvable);
    resetContinueOnFailure(): void;
    get continueOnFailureInput(): boolean | cdktf.IResolvable | undefined;
    private _jarFileUris?;
    get jarFileUris(): string[];
    set jarFileUris(value: string[]);
    resetJarFileUris(): void;
    get jarFileUrisInput(): string[] | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _queryFileUri?;
    get queryFileUri(): string;
    set queryFileUri(value: string);
    resetQueryFileUri(): void;
    get queryFileUriInput(): string | undefined;
    private _queryList?;
    get queryList(): string[];
    set queryList(value: string[]);
    resetQueryList(): void;
    get queryListInput(): string[] | undefined;
    private _scriptVariables?;
    get scriptVariables(): {
        [key: string]: string;
    };
    set scriptVariables(value: {
        [key: string]: string;
    });
    resetScriptVariables(): void;
    get scriptVariablesInput(): {
        [key: string]: string;
    } | undefined;
    private _loggingConfig;
    get loggingConfig(): GoogleDataprocJobPigConfigLoggingConfigOutputReference;
    putLoggingConfig(value: GoogleDataprocJobPigConfigLoggingConfig): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): GoogleDataprocJobPigConfigLoggingConfig | undefined;
}
export interface GoogleDataprocJobPlacement {
    /**
    * The name of the cluster where the job will be submitted
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#cluster_name GoogleDataprocJob#cluster_name}
    */
    readonly clusterName: string;
}
export declare function googleDataprocJobPlacementToTerraform(struct?: GoogleDataprocJobPlacementOutputReference | GoogleDataprocJobPlacement): any;
export declare function googleDataprocJobPlacementToHclTerraform(struct?: GoogleDataprocJobPlacementOutputReference | GoogleDataprocJobPlacement): any;
export declare class GoogleDataprocJobPlacementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocJobPlacement | undefined;
    set internalValue(value: GoogleDataprocJobPlacement | undefined);
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    get clusterUuid(): string;
}
export interface GoogleDataprocJobPrestoConfigLoggingConfig {
    /**
    * Optional. The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#driver_log_levels GoogleDataprocJob#driver_log_levels}
    */
    readonly driverLogLevels: {
        [key: string]: string;
    };
}
export declare function googleDataprocJobPrestoConfigLoggingConfigToTerraform(struct?: GoogleDataprocJobPrestoConfigLoggingConfigOutputReference | GoogleDataprocJobPrestoConfigLoggingConfig): any;
export declare function googleDataprocJobPrestoConfigLoggingConfigToHclTerraform(struct?: GoogleDataprocJobPrestoConfigLoggingConfigOutputReference | GoogleDataprocJobPrestoConfigLoggingConfig): any;
export declare class GoogleDataprocJobPrestoConfigLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocJobPrestoConfigLoggingConfig | undefined;
    set internalValue(value: GoogleDataprocJobPrestoConfigLoggingConfig | undefined);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    };
    set driverLogLevels(value: {
        [key: string]: string;
    });
    get driverLogLevelsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleDataprocJobPrestoConfig {
    /**
    * Presto client tags to attach to this query.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#client_tags GoogleDataprocJob#client_tags}
    */
    readonly clientTags?: string[];
    /**
    * Whether to continue executing queries if a query fails. Setting to true can be useful when executing independent parallel queries. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#continue_on_failure GoogleDataprocJob#continue_on_failure}
    */
    readonly continueOnFailure?: boolean | cdktf.IResolvable;
    /**
    * The format in which query output will be displayed. See the Presto documentation for supported output formats.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#output_format GoogleDataprocJob#output_format}
    */
    readonly outputFormat?: string;
    /**
    * A mapping of property names to values. Used to set Presto session properties Equivalent to using the --session flag in the Presto CLI.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#properties GoogleDataprocJob#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * The HCFS URI of the script that contains SQL queries. Conflicts with query_list
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#query_file_uri GoogleDataprocJob#query_file_uri}
    */
    readonly queryFileUri?: string;
    /**
    * The list of SQL queries or statements to execute as part of the job. Conflicts with query_file_uri
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#query_list GoogleDataprocJob#query_list}
    */
    readonly queryList?: string[];
    /**
    * logging_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#logging_config GoogleDataprocJob#logging_config}
    */
    readonly loggingConfig?: GoogleDataprocJobPrestoConfigLoggingConfig;
}
export declare function googleDataprocJobPrestoConfigToTerraform(struct?: GoogleDataprocJobPrestoConfigOutputReference | GoogleDataprocJobPrestoConfig): any;
export declare function googleDataprocJobPrestoConfigToHclTerraform(struct?: GoogleDataprocJobPrestoConfigOutputReference | GoogleDataprocJobPrestoConfig): any;
export declare class GoogleDataprocJobPrestoConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocJobPrestoConfig | undefined;
    set internalValue(value: GoogleDataprocJobPrestoConfig | undefined);
    private _clientTags?;
    get clientTags(): string[];
    set clientTags(value: string[]);
    resetClientTags(): void;
    get clientTagsInput(): string[] | undefined;
    private _continueOnFailure?;
    get continueOnFailure(): boolean | cdktf.IResolvable;
    set continueOnFailure(value: boolean | cdktf.IResolvable);
    resetContinueOnFailure(): void;
    get continueOnFailureInput(): boolean | cdktf.IResolvable | undefined;
    private _outputFormat?;
    get outputFormat(): string;
    set outputFormat(value: string);
    resetOutputFormat(): void;
    get outputFormatInput(): string | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _queryFileUri?;
    get queryFileUri(): string;
    set queryFileUri(value: string);
    resetQueryFileUri(): void;
    get queryFileUriInput(): string | undefined;
    private _queryList?;
    get queryList(): string[];
    set queryList(value: string[]);
    resetQueryList(): void;
    get queryListInput(): string[] | undefined;
    private _loggingConfig;
    get loggingConfig(): GoogleDataprocJobPrestoConfigLoggingConfigOutputReference;
    putLoggingConfig(value: GoogleDataprocJobPrestoConfigLoggingConfig): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): GoogleDataprocJobPrestoConfigLoggingConfig | undefined;
}
export interface GoogleDataprocJobPysparkConfigLoggingConfig {
    /**
    * Optional. The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#driver_log_levels GoogleDataprocJob#driver_log_levels}
    */
    readonly driverLogLevels: {
        [key: string]: string;
    };
}
export declare function googleDataprocJobPysparkConfigLoggingConfigToTerraform(struct?: GoogleDataprocJobPysparkConfigLoggingConfigOutputReference | GoogleDataprocJobPysparkConfigLoggingConfig): any;
export declare function googleDataprocJobPysparkConfigLoggingConfigToHclTerraform(struct?: GoogleDataprocJobPysparkConfigLoggingConfigOutputReference | GoogleDataprocJobPysparkConfigLoggingConfig): any;
export declare class GoogleDataprocJobPysparkConfigLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocJobPysparkConfigLoggingConfig | undefined;
    set internalValue(value: GoogleDataprocJobPysparkConfigLoggingConfig | undefined);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    };
    set driverLogLevels(value: {
        [key: string]: string;
    });
    get driverLogLevelsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleDataprocJobPysparkConfig {
    /**
    * Optional. HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#archive_uris GoogleDataprocJob#archive_uris}
    */
    readonly archiveUris?: string[];
    /**
    * Optional. The arguments to pass to the driver. Do not include arguments, such as --conf, that can be set as job properties, since a collision may occur that causes an incorrect job submission
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#args GoogleDataprocJob#args}
    */
    readonly args?: string[];
    /**
    * Optional. HCFS URIs of files to be copied to the working directory of Python drivers and distributed tasks. Useful for naively parallel tasks
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#file_uris GoogleDataprocJob#file_uris}
    */
    readonly fileUris?: string[];
    /**
    * Optional. HCFS URIs of jar files to add to the CLASSPATHs of the Python driver and tasks
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#jar_file_uris GoogleDataprocJob#jar_file_uris}
    */
    readonly jarFileUris?: string[];
    /**
    * Required. The HCFS URI of the main Python file to use as the driver. Must be a .py file
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#main_python_file_uri GoogleDataprocJob#main_python_file_uri}
    */
    readonly mainPythonFileUri: string;
    /**
    * Optional. A mapping of property names to values, used to configure PySpark. Properties that conflict with values set by the Cloud Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#properties GoogleDataprocJob#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * Optional. HCFS file URIs of Python files to pass to the PySpark framework. Supported file types: .py, .egg, and .zip
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#python_file_uris GoogleDataprocJob#python_file_uris}
    */
    readonly pythonFileUris?: string[];
    /**
    * logging_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#logging_config GoogleDataprocJob#logging_config}
    */
    readonly loggingConfig?: GoogleDataprocJobPysparkConfigLoggingConfig;
}
export declare function googleDataprocJobPysparkConfigToTerraform(struct?: GoogleDataprocJobPysparkConfigOutputReference | GoogleDataprocJobPysparkConfig): any;
export declare function googleDataprocJobPysparkConfigToHclTerraform(struct?: GoogleDataprocJobPysparkConfigOutputReference | GoogleDataprocJobPysparkConfig): any;
export declare class GoogleDataprocJobPysparkConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocJobPysparkConfig | undefined;
    set internalValue(value: GoogleDataprocJobPysparkConfig | undefined);
    private _archiveUris?;
    get archiveUris(): string[];
    set archiveUris(value: string[]);
    resetArchiveUris(): void;
    get archiveUrisInput(): string[] | undefined;
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _fileUris?;
    get fileUris(): string[];
    set fileUris(value: string[]);
    resetFileUris(): void;
    get fileUrisInput(): string[] | undefined;
    private _jarFileUris?;
    get jarFileUris(): string[];
    set jarFileUris(value: string[]);
    resetJarFileUris(): void;
    get jarFileUrisInput(): string[] | undefined;
    private _mainPythonFileUri?;
    get mainPythonFileUri(): string;
    set mainPythonFileUri(value: string);
    get mainPythonFileUriInput(): string | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _pythonFileUris?;
    get pythonFileUris(): string[];
    set pythonFileUris(value: string[]);
    resetPythonFileUris(): void;
    get pythonFileUrisInput(): string[] | undefined;
    private _loggingConfig;
    get loggingConfig(): GoogleDataprocJobPysparkConfigLoggingConfigOutputReference;
    putLoggingConfig(value: GoogleDataprocJobPysparkConfigLoggingConfig): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): GoogleDataprocJobPysparkConfigLoggingConfig | undefined;
}
export interface GoogleDataprocJobReference {
    /**
    * The job ID, which must be unique within the project. The job ID is generated by the server upon job submission or provided by the user as a means to perform retries without creating duplicate jobs
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#job_id GoogleDataprocJob#job_id}
    */
    readonly jobId?: string;
}
export declare function googleDataprocJobReferenceToTerraform(struct?: GoogleDataprocJobReferenceOutputReference | GoogleDataprocJobReference): any;
export declare function googleDataprocJobReferenceToHclTerraform(struct?: GoogleDataprocJobReferenceOutputReference | GoogleDataprocJobReference): any;
export declare class GoogleDataprocJobReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocJobReference | undefined;
    set internalValue(value: GoogleDataprocJobReference | undefined);
    private _jobId?;
    get jobId(): string;
    set jobId(value: string);
    resetJobId(): void;
    get jobIdInput(): string | undefined;
}
export interface GoogleDataprocJobScheduling {
    /**
    * Maximum number of times per hour a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#max_failures_per_hour GoogleDataprocJob#max_failures_per_hour}
    */
    readonly maxFailuresPerHour: number;
    /**
    * Maximum number of times in total a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#max_failures_total GoogleDataprocJob#max_failures_total}
    */
    readonly maxFailuresTotal: number;
}
export declare function googleDataprocJobSchedulingToTerraform(struct?: GoogleDataprocJobSchedulingOutputReference | GoogleDataprocJobScheduling): any;
export declare function googleDataprocJobSchedulingToHclTerraform(struct?: GoogleDataprocJobSchedulingOutputReference | GoogleDataprocJobScheduling): any;
export declare class GoogleDataprocJobSchedulingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocJobScheduling | undefined;
    set internalValue(value: GoogleDataprocJobScheduling | undefined);
    private _maxFailuresPerHour?;
    get maxFailuresPerHour(): number;
    set maxFailuresPerHour(value: number);
    get maxFailuresPerHourInput(): number | undefined;
    private _maxFailuresTotal?;
    get maxFailuresTotal(): number;
    set maxFailuresTotal(value: number);
    get maxFailuresTotalInput(): number | undefined;
}
export interface GoogleDataprocJobSparkConfigLoggingConfig {
    /**
    * Optional. The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#driver_log_levels GoogleDataprocJob#driver_log_levels}
    */
    readonly driverLogLevels: {
        [key: string]: string;
    };
}
export declare function googleDataprocJobSparkConfigLoggingConfigToTerraform(struct?: GoogleDataprocJobSparkConfigLoggingConfigOutputReference | GoogleDataprocJobSparkConfigLoggingConfig): any;
export declare function googleDataprocJobSparkConfigLoggingConfigToHclTerraform(struct?: GoogleDataprocJobSparkConfigLoggingConfigOutputReference | GoogleDataprocJobSparkConfigLoggingConfig): any;
export declare class GoogleDataprocJobSparkConfigLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocJobSparkConfigLoggingConfig | undefined;
    set internalValue(value: GoogleDataprocJobSparkConfigLoggingConfig | undefined);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    };
    set driverLogLevels(value: {
        [key: string]: string;
    });
    get driverLogLevelsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleDataprocJobSparkConfig {
    /**
    * HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#archive_uris GoogleDataprocJob#archive_uris}
    */
    readonly archiveUris?: string[];
    /**
    * The arguments to pass to the driver.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#args GoogleDataprocJob#args}
    */
    readonly args?: string[];
    /**
    * HCFS URIs of files to be copied to the working directory of Spark drivers and distributed tasks. Useful for naively parallel tasks.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#file_uris GoogleDataprocJob#file_uris}
    */
    readonly fileUris?: string[];
    /**
    * HCFS URIs of jar files to add to the CLASSPATHs of the Spark driver and tasks.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#jar_file_uris GoogleDataprocJob#jar_file_uris}
    */
    readonly jarFileUris?: string[];
    /**
    * The class containing the main method of the driver. Must be in a provided jar or jar that is already on the classpath. Conflicts with main_jar_file_uri
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#main_class GoogleDataprocJob#main_class}
    */
    readonly mainClass?: string;
    /**
    * The HCFS URI of jar file containing the driver jar. Conflicts with main_class
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#main_jar_file_uri GoogleDataprocJob#main_jar_file_uri}
    */
    readonly mainJarFileUri?: string;
    /**
    * A mapping of property names to values, used to configure Spark. Properties that conflict with values set by the Cloud Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#properties GoogleDataprocJob#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * logging_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#logging_config GoogleDataprocJob#logging_config}
    */
    readonly loggingConfig?: GoogleDataprocJobSparkConfigLoggingConfig;
}
export declare function googleDataprocJobSparkConfigToTerraform(struct?: GoogleDataprocJobSparkConfigOutputReference | GoogleDataprocJobSparkConfig): any;
export declare function googleDataprocJobSparkConfigToHclTerraform(struct?: GoogleDataprocJobSparkConfigOutputReference | GoogleDataprocJobSparkConfig): any;
export declare class GoogleDataprocJobSparkConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocJobSparkConfig | undefined;
    set internalValue(value: GoogleDataprocJobSparkConfig | undefined);
    private _archiveUris?;
    get archiveUris(): string[];
    set archiveUris(value: string[]);
    resetArchiveUris(): void;
    get archiveUrisInput(): string[] | undefined;
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _fileUris?;
    get fileUris(): string[];
    set fileUris(value: string[]);
    resetFileUris(): void;
    get fileUrisInput(): string[] | undefined;
    private _jarFileUris?;
    get jarFileUris(): string[];
    set jarFileUris(value: string[]);
    resetJarFileUris(): void;
    get jarFileUrisInput(): string[] | undefined;
    private _mainClass?;
    get mainClass(): string;
    set mainClass(value: string);
    resetMainClass(): void;
    get mainClassInput(): string | undefined;
    private _mainJarFileUri?;
    get mainJarFileUri(): string;
    set mainJarFileUri(value: string);
    resetMainJarFileUri(): void;
    get mainJarFileUriInput(): string | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _loggingConfig;
    get loggingConfig(): GoogleDataprocJobSparkConfigLoggingConfigOutputReference;
    putLoggingConfig(value: GoogleDataprocJobSparkConfigLoggingConfig): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): GoogleDataprocJobSparkConfigLoggingConfig | undefined;
}
export interface GoogleDataprocJobSparksqlConfigLoggingConfig {
    /**
    * Optional. The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#driver_log_levels GoogleDataprocJob#driver_log_levels}
    */
    readonly driverLogLevels: {
        [key: string]: string;
    };
}
export declare function googleDataprocJobSparksqlConfigLoggingConfigToTerraform(struct?: GoogleDataprocJobSparksqlConfigLoggingConfigOutputReference | GoogleDataprocJobSparksqlConfigLoggingConfig): any;
export declare function googleDataprocJobSparksqlConfigLoggingConfigToHclTerraform(struct?: GoogleDataprocJobSparksqlConfigLoggingConfigOutputReference | GoogleDataprocJobSparksqlConfigLoggingConfig): any;
export declare class GoogleDataprocJobSparksqlConfigLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocJobSparksqlConfigLoggingConfig | undefined;
    set internalValue(value: GoogleDataprocJobSparksqlConfigLoggingConfig | undefined);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    };
    set driverLogLevels(value: {
        [key: string]: string;
    });
    get driverLogLevelsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleDataprocJobSparksqlConfig {
    /**
    * HCFS URIs of jar files to be added to the Spark CLASSPATH.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#jar_file_uris GoogleDataprocJob#jar_file_uris}
    */
    readonly jarFileUris?: string[];
    /**
    * A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#properties GoogleDataprocJob#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * The HCFS URI of the script that contains SQL queries. Conflicts with query_list
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#query_file_uri GoogleDataprocJob#query_file_uri}
    */
    readonly queryFileUri?: string;
    /**
    * The list of SQL queries or statements to execute as part of the job. Conflicts with query_file_uri
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#query_list GoogleDataprocJob#query_list}
    */
    readonly queryList?: string[];
    /**
    * Mapping of query variable names to values (equivalent to the Spark SQL command: SET name="value";).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#script_variables GoogleDataprocJob#script_variables}
    */
    readonly scriptVariables?: {
        [key: string]: string;
    };
    /**
    * logging_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#logging_config GoogleDataprocJob#logging_config}
    */
    readonly loggingConfig?: GoogleDataprocJobSparksqlConfigLoggingConfig;
}
export declare function googleDataprocJobSparksqlConfigToTerraform(struct?: GoogleDataprocJobSparksqlConfigOutputReference | GoogleDataprocJobSparksqlConfig): any;
export declare function googleDataprocJobSparksqlConfigToHclTerraform(struct?: GoogleDataprocJobSparksqlConfigOutputReference | GoogleDataprocJobSparksqlConfig): any;
export declare class GoogleDataprocJobSparksqlConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocJobSparksqlConfig | undefined;
    set internalValue(value: GoogleDataprocJobSparksqlConfig | undefined);
    private _jarFileUris?;
    get jarFileUris(): string[];
    set jarFileUris(value: string[]);
    resetJarFileUris(): void;
    get jarFileUrisInput(): string[] | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _queryFileUri?;
    get queryFileUri(): string;
    set queryFileUri(value: string);
    resetQueryFileUri(): void;
    get queryFileUriInput(): string | undefined;
    private _queryList?;
    get queryList(): string[];
    set queryList(value: string[]);
    resetQueryList(): void;
    get queryListInput(): string[] | undefined;
    private _scriptVariables?;
    get scriptVariables(): {
        [key: string]: string;
    };
    set scriptVariables(value: {
        [key: string]: string;
    });
    resetScriptVariables(): void;
    get scriptVariablesInput(): {
        [key: string]: string;
    } | undefined;
    private _loggingConfig;
    get loggingConfig(): GoogleDataprocJobSparksqlConfigLoggingConfigOutputReference;
    putLoggingConfig(value: GoogleDataprocJobSparksqlConfigLoggingConfig): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): GoogleDataprocJobSparksqlConfigLoggingConfig | undefined;
}
export interface GoogleDataprocJobTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#create GoogleDataprocJob#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#delete GoogleDataprocJob#delete}
    */
    readonly delete?: string;
}
export declare function googleDataprocJobTimeoutsToTerraform(struct?: GoogleDataprocJobTimeouts | cdktf.IResolvable): any;
export declare function googleDataprocJobTimeoutsToHclTerraform(struct?: GoogleDataprocJobTimeouts | cdktf.IResolvable): any;
export declare class GoogleDataprocJobTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataprocJobTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataprocJobTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job google_dataproc_job}
*/
export declare class GoogleDataprocJob extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dataproc_job";
    /**
    * Generates CDKTF code for importing a GoogleDataprocJob resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleDataprocJob to import
    * @param importFromId The id of the existing GoogleDataprocJob that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleDataprocJob to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dataproc_job google_dataproc_job} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDataprocJobConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDataprocJobConfig);
    get driverControlsFilesUri(): string;
    get driverOutputResourceUri(): string;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _forceDelete?;
    get forceDelete(): boolean | cdktf.IResolvable;
    set forceDelete(value: boolean | cdktf.IResolvable);
    resetForceDelete(): void;
    get forceDeleteInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _status;
    get status(): GoogleDataprocJobStatusList;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _hadoopConfig;
    get hadoopConfig(): GoogleDataprocJobHadoopConfigOutputReference;
    putHadoopConfig(value: GoogleDataprocJobHadoopConfig): void;
    resetHadoopConfig(): void;
    get hadoopConfigInput(): GoogleDataprocJobHadoopConfig | undefined;
    private _hiveConfig;
    get hiveConfig(): GoogleDataprocJobHiveConfigOutputReference;
    putHiveConfig(value: GoogleDataprocJobHiveConfig): void;
    resetHiveConfig(): void;
    get hiveConfigInput(): GoogleDataprocJobHiveConfig | undefined;
    private _pigConfig;
    get pigConfig(): GoogleDataprocJobPigConfigOutputReference;
    putPigConfig(value: GoogleDataprocJobPigConfig): void;
    resetPigConfig(): void;
    get pigConfigInput(): GoogleDataprocJobPigConfig | undefined;
    private _placement;
    get placement(): GoogleDataprocJobPlacementOutputReference;
    putPlacement(value: GoogleDataprocJobPlacement): void;
    get placementInput(): GoogleDataprocJobPlacement | undefined;
    private _prestoConfig;
    get prestoConfig(): GoogleDataprocJobPrestoConfigOutputReference;
    putPrestoConfig(value: GoogleDataprocJobPrestoConfig): void;
    resetPrestoConfig(): void;
    get prestoConfigInput(): GoogleDataprocJobPrestoConfig | undefined;
    private _pysparkConfig;
    get pysparkConfig(): GoogleDataprocJobPysparkConfigOutputReference;
    putPysparkConfig(value: GoogleDataprocJobPysparkConfig): void;
    resetPysparkConfig(): void;
    get pysparkConfigInput(): GoogleDataprocJobPysparkConfig | undefined;
    private _reference;
    get reference(): GoogleDataprocJobReferenceOutputReference;
    putReference(value: GoogleDataprocJobReference): void;
    resetReference(): void;
    get referenceInput(): GoogleDataprocJobReference | undefined;
    private _scheduling;
    get scheduling(): GoogleDataprocJobSchedulingOutputReference;
    putScheduling(value: GoogleDataprocJobScheduling): void;
    resetScheduling(): void;
    get schedulingInput(): GoogleDataprocJobScheduling | undefined;
    private _sparkConfig;
    get sparkConfig(): GoogleDataprocJobSparkConfigOutputReference;
    putSparkConfig(value: GoogleDataprocJobSparkConfig): void;
    resetSparkConfig(): void;
    get sparkConfigInput(): GoogleDataprocJobSparkConfig | undefined;
    private _sparksqlConfig;
    get sparksqlConfig(): GoogleDataprocJobSparksqlConfigOutputReference;
    putSparksqlConfig(value: GoogleDataprocJobSparksqlConfig): void;
    resetSparksqlConfig(): void;
    get sparksqlConfigInput(): GoogleDataprocJobSparksqlConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleDataprocJobTimeoutsOutputReference;
    putTimeouts(value: GoogleDataprocJobTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDataprocJobTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
