/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDatastoreIndexConfig extends cdktf.TerraformMetaArguments {
    /**
    * Policy for including ancestors in the index. Default value: "NONE" Possible values: ["NONE", "ALL_ANCESTORS"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_datastore_index#ancestor GoogleDatastoreIndex#ancestor}
    */
    readonly ancestor?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_datastore_index#id GoogleDatastoreIndex#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The entity kind which the index applies to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_datastore_index#kind GoogleDatastoreIndex#kind}
    */
    readonly kind: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_datastore_index#project GoogleDatastoreIndex#project}
    */
    readonly project?: string;
    /**
    * properties block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_datastore_index#properties GoogleDatastoreIndex#properties}
    */
    readonly properties?: GoogleDatastoreIndexProperties[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_datastore_index#timeouts GoogleDatastoreIndex#timeouts}
    */
    readonly timeouts?: GoogleDatastoreIndexTimeouts;
}
export interface GoogleDatastoreIndexProperties {
    /**
    * The direction the index should optimize for sorting. Possible values: ["ASCENDING", "DESCENDING"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_datastore_index#direction GoogleDatastoreIndex#direction}
    */
    readonly direction: string;
    /**
    * The property name to index.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_datastore_index#name GoogleDatastoreIndex#name}
    */
    readonly name: string;
}
export declare function googleDatastoreIndexPropertiesToTerraform(struct?: GoogleDatastoreIndexProperties | cdktf.IResolvable): any;
export declare function googleDatastoreIndexPropertiesToHclTerraform(struct?: GoogleDatastoreIndexProperties | cdktf.IResolvable): any;
export declare class GoogleDatastoreIndexPropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDatastoreIndexProperties | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDatastoreIndexProperties | cdktf.IResolvable | undefined);
    private _direction?;
    get direction(): string;
    set direction(value: string);
    get directionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class GoogleDatastoreIndexPropertiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDatastoreIndexProperties[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDatastoreIndexPropertiesOutputReference;
}
export interface GoogleDatastoreIndexTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_datastore_index#create GoogleDatastoreIndex#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_datastore_index#delete GoogleDatastoreIndex#delete}
    */
    readonly delete?: string;
}
export declare function googleDatastoreIndexTimeoutsToTerraform(struct?: GoogleDatastoreIndexTimeouts | cdktf.IResolvable): any;
export declare function googleDatastoreIndexTimeoutsToHclTerraform(struct?: GoogleDatastoreIndexTimeouts | cdktf.IResolvable): any;
export declare class GoogleDatastoreIndexTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatastoreIndexTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDatastoreIndexTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_datastore_index google_datastore_index}
*/
export declare class GoogleDatastoreIndex extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_datastore_index";
    /**
    * Generates CDKTF code for importing a GoogleDatastoreIndex resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleDatastoreIndex to import
    * @param importFromId The id of the existing GoogleDatastoreIndex that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_datastore_index#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleDatastoreIndex to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_datastore_index google_datastore_index} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDatastoreIndexConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDatastoreIndexConfig);
    private _ancestor?;
    get ancestor(): string;
    set ancestor(value: string);
    resetAncestor(): void;
    get ancestorInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get indexId(): string;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _properties;
    get properties(): GoogleDatastoreIndexPropertiesList;
    putProperties(value: GoogleDatastoreIndexProperties[] | cdktf.IResolvable): void;
    resetProperties(): void;
    get propertiesInput(): cdktf.IResolvable | GoogleDatastoreIndexProperties[] | undefined;
    private _timeouts;
    get timeouts(): GoogleDatastoreIndexTimeoutsOutputReference;
    putTimeouts(value: GoogleDatastoreIndexTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDatastoreIndexTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
