/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDialogflowCxAgentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The URI of the agent's avatar. Avatars are used throughout the Dialogflow console and in the self-hosted Web Demo integration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#avatar_uri GoogleDialogflowCxAgent#avatar_uri}
    */
    readonly avatarUri?: string;
    /**
    * The default language of the agent as a language tag. [See Language Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
    * for a list of the currently supported language codes. This field cannot be updated after creation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#default_language_code GoogleDialogflowCxAgent#default_language_code}
    */
    readonly defaultLanguageCode: string;
    /**
    * The description of this agent. The maximum length is 500 characters. If exceeded, the request is rejected.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#description GoogleDialogflowCxAgent#description}
    */
    readonly description?: string;
    /**
    * The human-readable name of the agent, unique within the location.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#display_name GoogleDialogflowCxAgent#display_name}
    */
    readonly displayName: string;
    /**
    * Indicates if automatic spell correction is enabled in detect intent requests.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#enable_spell_correction GoogleDialogflowCxAgent#enable_spell_correction}
    */
    readonly enableSpellCorrection?: boolean | cdktf.IResolvable;
    /**
    * Determines whether this agent should log conversation queries.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#enable_stackdriver_logging GoogleDialogflowCxAgent#enable_stackdriver_logging}
    */
    readonly enableStackdriverLogging?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#id GoogleDialogflowCxAgent#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the location this agent is located in.
    *
    * ~> **Note:** The first time you are deploying an Agent in your project you must configure location settings.
    *  This is a one time step but at the moment you can only [configure location settings](https://cloud.google.com/dialogflow/cx/docs/concept/region#location-settings) via the Dialogflow CX console.
    *  Another options is to use global location so you don't need to manually configure location settings.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#location GoogleDialogflowCxAgent#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#project GoogleDialogflowCxAgent#project}
    */
    readonly project?: string;
    /**
    * Name of the SecuritySettings reference for the agent. Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#security_settings GoogleDialogflowCxAgent#security_settings}
    */
    readonly securitySettings?: string;
    /**
    * The list of all languages supported by this agent (except for the default_language_code).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#supported_language_codes GoogleDialogflowCxAgent#supported_language_codes}
    */
    readonly supportedLanguageCodes?: string[];
    /**
    * The time zone of this agent from the [time zone database](https://www.iana.org/time-zones), e.g., America/New_York,
    * Europe/Paris.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#time_zone GoogleDialogflowCxAgent#time_zone}
    */
    readonly timeZone: string;
    /**
    * advanced_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#advanced_settings GoogleDialogflowCxAgent#advanced_settings}
    */
    readonly advancedSettings?: GoogleDialogflowCxAgentAdvancedSettings;
    /**
    * git_integration_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#git_integration_settings GoogleDialogflowCxAgent#git_integration_settings}
    */
    readonly gitIntegrationSettings?: GoogleDialogflowCxAgentGitIntegrationSettings;
    /**
    * speech_to_text_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#speech_to_text_settings GoogleDialogflowCxAgent#speech_to_text_settings}
    */
    readonly speechToTextSettings?: GoogleDialogflowCxAgentSpeechToTextSettings;
    /**
    * text_to_speech_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#text_to_speech_settings GoogleDialogflowCxAgent#text_to_speech_settings}
    */
    readonly textToSpeechSettings?: GoogleDialogflowCxAgentTextToSpeechSettings;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#timeouts GoogleDialogflowCxAgent#timeouts}
    */
    readonly timeouts?: GoogleDialogflowCxAgentTimeouts;
}
export interface GoogleDialogflowCxAgentAdvancedSettingsAudioExportGcsDestination {
    /**
    * The Google Cloud Storage URI for the exported objects. Whether a full object name, or just a prefix, its usage depends on the Dialogflow operation.
    * Format: gs://bucket/object-name-or-prefix
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#uri GoogleDialogflowCxAgent#uri}
    */
    readonly uri?: string;
}
export declare function googleDialogflowCxAgentAdvancedSettingsAudioExportGcsDestinationToTerraform(struct?: GoogleDialogflowCxAgentAdvancedSettingsAudioExportGcsDestinationOutputReference | GoogleDialogflowCxAgentAdvancedSettingsAudioExportGcsDestination): any;
export declare function googleDialogflowCxAgentAdvancedSettingsAudioExportGcsDestinationToHclTerraform(struct?: GoogleDialogflowCxAgentAdvancedSettingsAudioExportGcsDestinationOutputReference | GoogleDialogflowCxAgentAdvancedSettingsAudioExportGcsDestination): any;
export declare class GoogleDialogflowCxAgentAdvancedSettingsAudioExportGcsDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxAgentAdvancedSettingsAudioExportGcsDestination | undefined;
    set internalValue(value: GoogleDialogflowCxAgentAdvancedSettingsAudioExportGcsDestination | undefined);
    private _uri?;
    get uri(): string;
    set uri(value: string);
    resetUri(): void;
    get uriInput(): string | undefined;
}
export interface GoogleDialogflowCxAgentAdvancedSettingsDtmfSettings {
    /**
    * If true, incoming audio is processed for DTMF (dual tone multi frequency) events. For example, if the caller presses a button on their telephone keypad and DTMF processing is enabled, Dialogflow will detect the event (e.g. a "3" was pressed) in the incoming audio and pass the event to the bot to drive business logic (e.g. when 3 is pressed, return the account balance).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#enabled GoogleDialogflowCxAgent#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The digit that terminates a DTMF digit sequence.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#finish_digit GoogleDialogflowCxAgent#finish_digit}
    */
    readonly finishDigit?: string;
    /**
    * Max length of DTMF digits.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#max_digits GoogleDialogflowCxAgent#max_digits}
    */
    readonly maxDigits?: number;
}
export declare function googleDialogflowCxAgentAdvancedSettingsDtmfSettingsToTerraform(struct?: GoogleDialogflowCxAgentAdvancedSettingsDtmfSettingsOutputReference | GoogleDialogflowCxAgentAdvancedSettingsDtmfSettings): any;
export declare function googleDialogflowCxAgentAdvancedSettingsDtmfSettingsToHclTerraform(struct?: GoogleDialogflowCxAgentAdvancedSettingsDtmfSettingsOutputReference | GoogleDialogflowCxAgentAdvancedSettingsDtmfSettings): any;
export declare class GoogleDialogflowCxAgentAdvancedSettingsDtmfSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxAgentAdvancedSettingsDtmfSettings | undefined;
    set internalValue(value: GoogleDialogflowCxAgentAdvancedSettingsDtmfSettings | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _finishDigit?;
    get finishDigit(): string;
    set finishDigit(value: string);
    resetFinishDigit(): void;
    get finishDigitInput(): string | undefined;
    private _maxDigits?;
    get maxDigits(): number;
    set maxDigits(value: number);
    resetMaxDigits(): void;
    get maxDigitsInput(): number | undefined;
}
export interface GoogleDialogflowCxAgentAdvancedSettings {
    /**
    * audio_export_gcs_destination block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#audio_export_gcs_destination GoogleDialogflowCxAgent#audio_export_gcs_destination}
    */
    readonly audioExportGcsDestination?: GoogleDialogflowCxAgentAdvancedSettingsAudioExportGcsDestination;
    /**
    * dtmf_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#dtmf_settings GoogleDialogflowCxAgent#dtmf_settings}
    */
    readonly dtmfSettings?: GoogleDialogflowCxAgentAdvancedSettingsDtmfSettings;
}
export declare function googleDialogflowCxAgentAdvancedSettingsToTerraform(struct?: GoogleDialogflowCxAgentAdvancedSettingsOutputReference | GoogleDialogflowCxAgentAdvancedSettings): any;
export declare function googleDialogflowCxAgentAdvancedSettingsToHclTerraform(struct?: GoogleDialogflowCxAgentAdvancedSettingsOutputReference | GoogleDialogflowCxAgentAdvancedSettings): any;
export declare class GoogleDialogflowCxAgentAdvancedSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxAgentAdvancedSettings | undefined;
    set internalValue(value: GoogleDialogflowCxAgentAdvancedSettings | undefined);
    private _audioExportGcsDestination;
    get audioExportGcsDestination(): GoogleDialogflowCxAgentAdvancedSettingsAudioExportGcsDestinationOutputReference;
    putAudioExportGcsDestination(value: GoogleDialogflowCxAgentAdvancedSettingsAudioExportGcsDestination): void;
    resetAudioExportGcsDestination(): void;
    get audioExportGcsDestinationInput(): GoogleDialogflowCxAgentAdvancedSettingsAudioExportGcsDestination | undefined;
    private _dtmfSettings;
    get dtmfSettings(): GoogleDialogflowCxAgentAdvancedSettingsDtmfSettingsOutputReference;
    putDtmfSettings(value: GoogleDialogflowCxAgentAdvancedSettingsDtmfSettings): void;
    resetDtmfSettings(): void;
    get dtmfSettingsInput(): GoogleDialogflowCxAgentAdvancedSettingsDtmfSettings | undefined;
}
export interface GoogleDialogflowCxAgentGitIntegrationSettingsGithubSettings {
    /**
    * The access token used to authenticate the access to the GitHub repository.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#access_token GoogleDialogflowCxAgent#access_token}
    */
    readonly accessToken?: string;
    /**
    * A list of branches configured to be used from Dialogflow.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#branches GoogleDialogflowCxAgent#branches}
    */
    readonly branches?: string[];
    /**
    * The unique repository display name for the GitHub repository.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#display_name GoogleDialogflowCxAgent#display_name}
    */
    readonly displayName?: string;
    /**
    * The GitHub repository URI related to the agent.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#repository_uri GoogleDialogflowCxAgent#repository_uri}
    */
    readonly repositoryUri?: string;
    /**
    * The branch of the GitHub repository tracked for this agent.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#tracking_branch GoogleDialogflowCxAgent#tracking_branch}
    */
    readonly trackingBranch?: string;
}
export declare function googleDialogflowCxAgentGitIntegrationSettingsGithubSettingsToTerraform(struct?: GoogleDialogflowCxAgentGitIntegrationSettingsGithubSettingsOutputReference | GoogleDialogflowCxAgentGitIntegrationSettingsGithubSettings): any;
export declare function googleDialogflowCxAgentGitIntegrationSettingsGithubSettingsToHclTerraform(struct?: GoogleDialogflowCxAgentGitIntegrationSettingsGithubSettingsOutputReference | GoogleDialogflowCxAgentGitIntegrationSettingsGithubSettings): any;
export declare class GoogleDialogflowCxAgentGitIntegrationSettingsGithubSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxAgentGitIntegrationSettingsGithubSettings | undefined;
    set internalValue(value: GoogleDialogflowCxAgentGitIntegrationSettingsGithubSettings | undefined);
    private _accessToken?;
    get accessToken(): string;
    set accessToken(value: string);
    resetAccessToken(): void;
    get accessTokenInput(): string | undefined;
    private _branches?;
    get branches(): string[];
    set branches(value: string[]);
    resetBranches(): void;
    get branchesInput(): string[] | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _repositoryUri?;
    get repositoryUri(): string;
    set repositoryUri(value: string);
    resetRepositoryUri(): void;
    get repositoryUriInput(): string | undefined;
    private _trackingBranch?;
    get trackingBranch(): string;
    set trackingBranch(value: string);
    resetTrackingBranch(): void;
    get trackingBranchInput(): string | undefined;
}
export interface GoogleDialogflowCxAgentGitIntegrationSettings {
    /**
    * github_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#github_settings GoogleDialogflowCxAgent#github_settings}
    */
    readonly githubSettings?: GoogleDialogflowCxAgentGitIntegrationSettingsGithubSettings;
}
export declare function googleDialogflowCxAgentGitIntegrationSettingsToTerraform(struct?: GoogleDialogflowCxAgentGitIntegrationSettingsOutputReference | GoogleDialogflowCxAgentGitIntegrationSettings): any;
export declare function googleDialogflowCxAgentGitIntegrationSettingsToHclTerraform(struct?: GoogleDialogflowCxAgentGitIntegrationSettingsOutputReference | GoogleDialogflowCxAgentGitIntegrationSettings): any;
export declare class GoogleDialogflowCxAgentGitIntegrationSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxAgentGitIntegrationSettings | undefined;
    set internalValue(value: GoogleDialogflowCxAgentGitIntegrationSettings | undefined);
    private _githubSettings;
    get githubSettings(): GoogleDialogflowCxAgentGitIntegrationSettingsGithubSettingsOutputReference;
    putGithubSettings(value: GoogleDialogflowCxAgentGitIntegrationSettingsGithubSettings): void;
    resetGithubSettings(): void;
    get githubSettingsInput(): GoogleDialogflowCxAgentGitIntegrationSettingsGithubSettings | undefined;
}
export interface GoogleDialogflowCxAgentSpeechToTextSettings {
    /**
    * Whether to use speech adaptation for speech recognition.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#enable_speech_adaptation GoogleDialogflowCxAgent#enable_speech_adaptation}
    */
    readonly enableSpeechAdaptation?: boolean | cdktf.IResolvable;
}
export declare function googleDialogflowCxAgentSpeechToTextSettingsToTerraform(struct?: GoogleDialogflowCxAgentSpeechToTextSettingsOutputReference | GoogleDialogflowCxAgentSpeechToTextSettings): any;
export declare function googleDialogflowCxAgentSpeechToTextSettingsToHclTerraform(struct?: GoogleDialogflowCxAgentSpeechToTextSettingsOutputReference | GoogleDialogflowCxAgentSpeechToTextSettings): any;
export declare class GoogleDialogflowCxAgentSpeechToTextSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxAgentSpeechToTextSettings | undefined;
    set internalValue(value: GoogleDialogflowCxAgentSpeechToTextSettings | undefined);
    private _enableSpeechAdaptation?;
    get enableSpeechAdaptation(): boolean | cdktf.IResolvable;
    set enableSpeechAdaptation(value: boolean | cdktf.IResolvable);
    resetEnableSpeechAdaptation(): void;
    get enableSpeechAdaptationInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleDialogflowCxAgentTextToSpeechSettings {
    /**
    * Configuration of how speech should be synthesized, mapping from [language](https://cloud.google.com/dialogflow/cx/docs/reference/language) to [SynthesizeSpeechConfig](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents#synthesizespeechconfig).
    * These settings affect:
    * * The phone gateway synthesize configuration set via Agent.text_to_speech_settings.
    * * How speech is synthesized when invoking session APIs. 'Agent.text_to_speech_settings' only applies if 'OutputAudioConfig.synthesize_speech_config' is not specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#synthesize_speech_configs GoogleDialogflowCxAgent#synthesize_speech_configs}
    */
    readonly synthesizeSpeechConfigs?: string;
}
export declare function googleDialogflowCxAgentTextToSpeechSettingsToTerraform(struct?: GoogleDialogflowCxAgentTextToSpeechSettingsOutputReference | GoogleDialogflowCxAgentTextToSpeechSettings): any;
export declare function googleDialogflowCxAgentTextToSpeechSettingsToHclTerraform(struct?: GoogleDialogflowCxAgentTextToSpeechSettingsOutputReference | GoogleDialogflowCxAgentTextToSpeechSettings): any;
export declare class GoogleDialogflowCxAgentTextToSpeechSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxAgentTextToSpeechSettings | undefined;
    set internalValue(value: GoogleDialogflowCxAgentTextToSpeechSettings | undefined);
    private _synthesizeSpeechConfigs?;
    get synthesizeSpeechConfigs(): string;
    set synthesizeSpeechConfigs(value: string);
    resetSynthesizeSpeechConfigs(): void;
    get synthesizeSpeechConfigsInput(): string | undefined;
}
export interface GoogleDialogflowCxAgentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#create GoogleDialogflowCxAgent#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#delete GoogleDialogflowCxAgent#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#update GoogleDialogflowCxAgent#update}
    */
    readonly update?: string;
}
export declare function googleDialogflowCxAgentTimeoutsToTerraform(struct?: GoogleDialogflowCxAgentTimeouts | cdktf.IResolvable): any;
export declare function googleDialogflowCxAgentTimeoutsToHclTerraform(struct?: GoogleDialogflowCxAgentTimeouts | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxAgentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxAgentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxAgentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent google_dialogflow_cx_agent}
*/
export declare class GoogleDialogflowCxAgent extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dialogflow_cx_agent";
    /**
    * Generates CDKTF code for importing a GoogleDialogflowCxAgent resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleDialogflowCxAgent to import
    * @param importFromId The id of the existing GoogleDialogflowCxAgent that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleDialogflowCxAgent to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_agent google_dialogflow_cx_agent} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDialogflowCxAgentConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDialogflowCxAgentConfig);
    private _avatarUri?;
    get avatarUri(): string;
    set avatarUri(value: string);
    resetAvatarUri(): void;
    get avatarUriInput(): string | undefined;
    private _defaultLanguageCode?;
    get defaultLanguageCode(): string;
    set defaultLanguageCode(value: string);
    get defaultLanguageCodeInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enableSpellCorrection?;
    get enableSpellCorrection(): boolean | cdktf.IResolvable;
    set enableSpellCorrection(value: boolean | cdktf.IResolvable);
    resetEnableSpellCorrection(): void;
    get enableSpellCorrectionInput(): boolean | cdktf.IResolvable | undefined;
    private _enableStackdriverLogging?;
    get enableStackdriverLogging(): boolean | cdktf.IResolvable;
    set enableStackdriverLogging(value: boolean | cdktf.IResolvable);
    resetEnableStackdriverLogging(): void;
    get enableStackdriverLoggingInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _securitySettings?;
    get securitySettings(): string;
    set securitySettings(value: string);
    resetSecuritySettings(): void;
    get securitySettingsInput(): string | undefined;
    get startFlow(): string;
    private _supportedLanguageCodes?;
    get supportedLanguageCodes(): string[];
    set supportedLanguageCodes(value: string[]);
    resetSupportedLanguageCodes(): void;
    get supportedLanguageCodesInput(): string[] | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    get timeZoneInput(): string | undefined;
    private _advancedSettings;
    get advancedSettings(): GoogleDialogflowCxAgentAdvancedSettingsOutputReference;
    putAdvancedSettings(value: GoogleDialogflowCxAgentAdvancedSettings): void;
    resetAdvancedSettings(): void;
    get advancedSettingsInput(): GoogleDialogflowCxAgentAdvancedSettings | undefined;
    private _gitIntegrationSettings;
    get gitIntegrationSettings(): GoogleDialogflowCxAgentGitIntegrationSettingsOutputReference;
    putGitIntegrationSettings(value: GoogleDialogflowCxAgentGitIntegrationSettings): void;
    resetGitIntegrationSettings(): void;
    get gitIntegrationSettingsInput(): GoogleDialogflowCxAgentGitIntegrationSettings | undefined;
    private _speechToTextSettings;
    get speechToTextSettings(): GoogleDialogflowCxAgentSpeechToTextSettingsOutputReference;
    putSpeechToTextSettings(value: GoogleDialogflowCxAgentSpeechToTextSettings): void;
    resetSpeechToTextSettings(): void;
    get speechToTextSettingsInput(): GoogleDialogflowCxAgentSpeechToTextSettings | undefined;
    private _textToSpeechSettings;
    get textToSpeechSettings(): GoogleDialogflowCxAgentTextToSpeechSettingsOutputReference;
    putTextToSpeechSettings(value: GoogleDialogflowCxAgentTextToSpeechSettings): void;
    resetTextToSpeechSettings(): void;
    get textToSpeechSettingsInput(): GoogleDialogflowCxAgentTextToSpeechSettings | undefined;
    private _timeouts;
    get timeouts(): GoogleDialogflowCxAgentTimeoutsOutputReference;
    putTimeouts(value: GoogleDialogflowCxAgentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDialogflowCxAgentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
