/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDialogflowCxEntityTypeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Represents kinds of entities.
    * * AUTO_EXPANSION_MODE_UNSPECIFIED: Auto expansion disabled for the entity.
    * * AUTO_EXPANSION_MODE_DEFAULT: Allows an agent to recognize values that have not been explicitly listed in the entity. Possible values: ["AUTO_EXPANSION_MODE_DEFAULT", "AUTO_EXPANSION_MODE_UNSPECIFIED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_entity_type#auto_expansion_mode GoogleDialogflowCxEntityType#auto_expansion_mode}
    */
    readonly autoExpansionMode?: string;
    /**
    * The human-readable name of the entity type, unique within the agent.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_entity_type#display_name GoogleDialogflowCxEntityType#display_name}
    */
    readonly displayName: string;
    /**
    * Enables fuzzy entity extraction during classification.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_entity_type#enable_fuzzy_extraction GoogleDialogflowCxEntityType#enable_fuzzy_extraction}
    */
    readonly enableFuzzyExtraction?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_entity_type#id GoogleDialogflowCxEntityType#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Indicates whether the entity type can be automatically expanded.
    * * KIND_MAP: Map entity types allow mapping of a group of synonyms to a canonical value.
    * * KIND_LIST: List entity types contain a set of entries that do not map to canonical values. However, list entity types can contain references to other entity types (with or without aliases).
    * * KIND_REGEXP: Regexp entity types allow to specify regular expressions in entries values. Possible values: ["KIND_MAP", "KIND_LIST", "KIND_REGEXP"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_entity_type#kind GoogleDialogflowCxEntityType#kind}
    */
    readonly kind: string;
    /**
    * The language of the following fields in entityType:
    * EntityType.entities.value
    * EntityType.entities.synonyms
    * EntityType.excluded_phrases.value
    * If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_entity_type#language_code GoogleDialogflowCxEntityType#language_code}
    */
    readonly languageCode?: string;
    /**
    * The agent to create a entity type for.
    * Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_entity_type#parent GoogleDialogflowCxEntityType#parent}
    */
    readonly parent?: string;
    /**
    * Indicates whether parameters of the entity type should be redacted in log. If redaction is enabled, page parameters and intent parameters referring to the entity type will be replaced by parameter name when logging.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_entity_type#redact GoogleDialogflowCxEntityType#redact}
    */
    readonly redact?: boolean | cdktf.IResolvable;
    /**
    * entities block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_entity_type#entities GoogleDialogflowCxEntityType#entities}
    */
    readonly entities: GoogleDialogflowCxEntityTypeEntities[] | cdktf.IResolvable;
    /**
    * excluded_phrases block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_entity_type#excluded_phrases GoogleDialogflowCxEntityType#excluded_phrases}
    */
    readonly excludedPhrases?: GoogleDialogflowCxEntityTypeExcludedPhrases[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_entity_type#timeouts GoogleDialogflowCxEntityType#timeouts}
    */
    readonly timeouts?: GoogleDialogflowCxEntityTypeTimeouts;
}
export interface GoogleDialogflowCxEntityTypeEntities {
    /**
    * A collection of value synonyms. For example, if the entity type is vegetable, and value is scallions, a synonym could be green onions.
    * For KIND_LIST entity types: This collection must contain exactly one synonym equal to value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_entity_type#synonyms GoogleDialogflowCxEntityType#synonyms}
    */
    readonly synonyms?: string[];
    /**
    * The primary value associated with this entity entry. For example, if the entity type is vegetable, the value could be scallions.
    * For KIND_MAP entity types: A canonical value to be used in place of synonyms.
    * For KIND_LIST entity types: A string that can contain references to other entity types (with or without aliases).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_entity_type#value GoogleDialogflowCxEntityType#value}
    */
    readonly value?: string;
}
export declare function googleDialogflowCxEntityTypeEntitiesToTerraform(struct?: GoogleDialogflowCxEntityTypeEntities | cdktf.IResolvable): any;
export declare function googleDialogflowCxEntityTypeEntitiesToHclTerraform(struct?: GoogleDialogflowCxEntityTypeEntities | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxEntityTypeEntitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxEntityTypeEntities | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxEntityTypeEntities | cdktf.IResolvable | undefined);
    private _synonyms?;
    get synonyms(): string[];
    set synonyms(value: string[]);
    resetSynonyms(): void;
    get synonymsInput(): string[] | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class GoogleDialogflowCxEntityTypeEntitiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxEntityTypeEntities[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxEntityTypeEntitiesOutputReference;
}
export interface GoogleDialogflowCxEntityTypeExcludedPhrases {
    /**
    * The word or phrase to be excluded.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_entity_type#value GoogleDialogflowCxEntityType#value}
    */
    readonly value?: string;
}
export declare function googleDialogflowCxEntityTypeExcludedPhrasesToTerraform(struct?: GoogleDialogflowCxEntityTypeExcludedPhrases | cdktf.IResolvable): any;
export declare function googleDialogflowCxEntityTypeExcludedPhrasesToHclTerraform(struct?: GoogleDialogflowCxEntityTypeExcludedPhrases | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxEntityTypeExcludedPhrasesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxEntityTypeExcludedPhrases | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxEntityTypeExcludedPhrases | cdktf.IResolvable | undefined);
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class GoogleDialogflowCxEntityTypeExcludedPhrasesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxEntityTypeExcludedPhrases[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxEntityTypeExcludedPhrasesOutputReference;
}
export interface GoogleDialogflowCxEntityTypeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_entity_type#create GoogleDialogflowCxEntityType#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_entity_type#delete GoogleDialogflowCxEntityType#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_entity_type#update GoogleDialogflowCxEntityType#update}
    */
    readonly update?: string;
}
export declare function googleDialogflowCxEntityTypeTimeoutsToTerraform(struct?: GoogleDialogflowCxEntityTypeTimeouts | cdktf.IResolvable): any;
export declare function googleDialogflowCxEntityTypeTimeoutsToHclTerraform(struct?: GoogleDialogflowCxEntityTypeTimeouts | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxEntityTypeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxEntityTypeTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxEntityTypeTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_entity_type google_dialogflow_cx_entity_type}
*/
export declare class GoogleDialogflowCxEntityType extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dialogflow_cx_entity_type";
    /**
    * Generates CDKTF code for importing a GoogleDialogflowCxEntityType resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleDialogflowCxEntityType to import
    * @param importFromId The id of the existing GoogleDialogflowCxEntityType that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_entity_type#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleDialogflowCxEntityType to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_entity_type google_dialogflow_cx_entity_type} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDialogflowCxEntityTypeConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDialogflowCxEntityTypeConfig);
    private _autoExpansionMode?;
    get autoExpansionMode(): string;
    set autoExpansionMode(value: string);
    resetAutoExpansionMode(): void;
    get autoExpansionModeInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enableFuzzyExtraction?;
    get enableFuzzyExtraction(): boolean | cdktf.IResolvable;
    set enableFuzzyExtraction(value: boolean | cdktf.IResolvable);
    resetEnableFuzzyExtraction(): void;
    get enableFuzzyExtractionInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _languageCode?;
    get languageCode(): string;
    set languageCode(value: string);
    resetLanguageCode(): void;
    get languageCodeInput(): string | undefined;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    resetParent(): void;
    get parentInput(): string | undefined;
    private _redact?;
    get redact(): boolean | cdktf.IResolvable;
    set redact(value: boolean | cdktf.IResolvable);
    resetRedact(): void;
    get redactInput(): boolean | cdktf.IResolvable | undefined;
    private _entities;
    get entities(): GoogleDialogflowCxEntityTypeEntitiesList;
    putEntities(value: GoogleDialogflowCxEntityTypeEntities[] | cdktf.IResolvable): void;
    get entitiesInput(): cdktf.IResolvable | GoogleDialogflowCxEntityTypeEntities[] | undefined;
    private _excludedPhrases;
    get excludedPhrases(): GoogleDialogflowCxEntityTypeExcludedPhrasesList;
    putExcludedPhrases(value: GoogleDialogflowCxEntityTypeExcludedPhrases[] | cdktf.IResolvable): void;
    resetExcludedPhrases(): void;
    get excludedPhrasesInput(): cdktf.IResolvable | GoogleDialogflowCxEntityTypeExcludedPhrases[] | undefined;
    private _timeouts;
    get timeouts(): GoogleDialogflowCxEntityTypeTimeoutsOutputReference;
    putTimeouts(value: GoogleDialogflowCxEntityTypeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDialogflowCxEntityTypeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
