/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDialogflowCxEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The human-readable description of the environment. The maximum length is 500 characters. If exceeded, the request is rejected.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_environment#description GoogleDialogflowCxEnvironment#description}
    */
    readonly description?: string;
    /**
    * The human-readable name of the environment (unique in an agent). Limit of 64 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_environment#display_name GoogleDialogflowCxEnvironment#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_environment#id GoogleDialogflowCxEnvironment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The Agent to create an Environment for.
    * Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_environment#parent GoogleDialogflowCxEnvironment#parent}
    */
    readonly parent?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_environment#timeouts GoogleDialogflowCxEnvironment#timeouts}
    */
    readonly timeouts?: GoogleDialogflowCxEnvironmentTimeouts;
    /**
    * version_configs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_environment#version_configs GoogleDialogflowCxEnvironment#version_configs}
    */
    readonly versionConfigs: GoogleDialogflowCxEnvironmentVersionConfigs[] | cdktf.IResolvable;
}
export interface GoogleDialogflowCxEnvironmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_environment#create GoogleDialogflowCxEnvironment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_environment#delete GoogleDialogflowCxEnvironment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_environment#update GoogleDialogflowCxEnvironment#update}
    */
    readonly update?: string;
}
export declare function googleDialogflowCxEnvironmentTimeoutsToTerraform(struct?: GoogleDialogflowCxEnvironmentTimeouts | cdktf.IResolvable): any;
export declare function googleDialogflowCxEnvironmentTimeoutsToHclTerraform(struct?: GoogleDialogflowCxEnvironmentTimeouts | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxEnvironmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxEnvironmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxEnvironmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleDialogflowCxEnvironmentVersionConfigs {
    /**
    * Format: projects/{{project}}/locations/{{location}}/agents/{{agent}}/flows/{{flow}}/versions/{{version}}.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_environment#version GoogleDialogflowCxEnvironment#version}
    */
    readonly version: string;
}
export declare function googleDialogflowCxEnvironmentVersionConfigsToTerraform(struct?: GoogleDialogflowCxEnvironmentVersionConfigs | cdktf.IResolvable): any;
export declare function googleDialogflowCxEnvironmentVersionConfigsToHclTerraform(struct?: GoogleDialogflowCxEnvironmentVersionConfigs | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxEnvironmentVersionConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxEnvironmentVersionConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxEnvironmentVersionConfigs | cdktf.IResolvable | undefined);
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
}
export declare class GoogleDialogflowCxEnvironmentVersionConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxEnvironmentVersionConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxEnvironmentVersionConfigsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_environment google_dialogflow_cx_environment}
*/
export declare class GoogleDialogflowCxEnvironment extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dialogflow_cx_environment";
    /**
    * Generates CDKTF code for importing a GoogleDialogflowCxEnvironment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleDialogflowCxEnvironment to import
    * @param importFromId The id of the existing GoogleDialogflowCxEnvironment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_environment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleDialogflowCxEnvironment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_environment google_dialogflow_cx_environment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDialogflowCxEnvironmentConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDialogflowCxEnvironmentConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    resetParent(): void;
    get parentInput(): string | undefined;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): GoogleDialogflowCxEnvironmentTimeoutsOutputReference;
    putTimeouts(value: GoogleDialogflowCxEnvironmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDialogflowCxEnvironmentTimeouts | undefined;
    private _versionConfigs;
    get versionConfigs(): GoogleDialogflowCxEnvironmentVersionConfigsList;
    putVersionConfigs(value: GoogleDialogflowCxEnvironmentVersionConfigs[] | cdktf.IResolvable): void;
    get versionConfigsInput(): cdktf.IResolvable | GoogleDialogflowCxEnvironmentVersionConfigs[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
