/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDialogflowCxFlowConfig extends cdktf.TerraformMetaArguments {
    /**
    * The description of the flow. The maximum length is 500 characters. If exceeded, the request is rejected.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#description GoogleDialogflowCxFlow#description}
    */
    readonly description?: string;
    /**
    * The human-readable name of the flow.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#display_name GoogleDialogflowCxFlow#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#id GoogleDialogflowCxFlow#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Marks this as the [Default Start Flow](https://cloud.google.com/dialogflow/cx/docs/concept/flow#start) for an agent. When you create an agent, the Default Start Flow is created automatically.
    * The Default Start Flow cannot be deleted; deleting the 'google_dialogflow_cx_flow' resource does nothing to the underlying GCP resources.
    *
    * ~> Avoid having multiple 'google_dialogflow_cx_flow' resources linked to the same agent with 'is_default_start_flow = true' because they will compete to control a single Default Start Flow resource in GCP.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#is_default_start_flow GoogleDialogflowCxFlow#is_default_start_flow}
    */
    readonly isDefaultStartFlow?: boolean | cdktf.IResolvable;
    /**
    * The language of the following fields in flow:
    * Flow.event_handlers.trigger_fulfillment.messages
    * Flow.event_handlers.trigger_fulfillment.conditional_cases
    * Flow.transition_routes.trigger_fulfillment.messages
    * Flow.transition_routes.trigger_fulfillment.conditional_cases
    * If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#language_code GoogleDialogflowCxFlow#language_code}
    */
    readonly languageCode?: string;
    /**
    * The agent to create a flow for.
    * Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#parent GoogleDialogflowCxFlow#parent}
    */
    readonly parent?: string;
    /**
    * A flow's transition route group serve two purposes:
    * They are responsible for matching the user's first utterances in the flow.
    * They are inherited by every page's [transition route groups][Page.transition_route_groups]. Transition route groups defined in the page have higher priority than those defined in the flow.
    * Format:projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#transition_route_groups GoogleDialogflowCxFlow#transition_route_groups}
    */
    readonly transitionRouteGroups?: string[];
    /**
    * advanced_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#advanced_settings GoogleDialogflowCxFlow#advanced_settings}
    */
    readonly advancedSettings?: GoogleDialogflowCxFlowAdvancedSettings;
    /**
    * event_handlers block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#event_handlers GoogleDialogflowCxFlow#event_handlers}
    */
    readonly eventHandlers?: GoogleDialogflowCxFlowEventHandlers[] | cdktf.IResolvable;
    /**
    * nlu_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#nlu_settings GoogleDialogflowCxFlow#nlu_settings}
    */
    readonly nluSettings?: GoogleDialogflowCxFlowNluSettings;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#timeouts GoogleDialogflowCxFlow#timeouts}
    */
    readonly timeouts?: GoogleDialogflowCxFlowTimeouts;
    /**
    * transition_routes block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#transition_routes GoogleDialogflowCxFlow#transition_routes}
    */
    readonly transitionRoutes?: GoogleDialogflowCxFlowTransitionRoutes[] | cdktf.IResolvable;
}
export interface GoogleDialogflowCxFlowAdvancedSettingsAudioExportGcsDestination {
    /**
    * The Google Cloud Storage URI for the exported objects. Whether a full object name, or just a prefix, its usage depends on the Dialogflow operation.
    * Format: gs://bucket/object-name-or-prefix
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#uri GoogleDialogflowCxFlow#uri}
    */
    readonly uri?: string;
}
export declare function googleDialogflowCxFlowAdvancedSettingsAudioExportGcsDestinationToTerraform(struct?: GoogleDialogflowCxFlowAdvancedSettingsAudioExportGcsDestinationOutputReference | GoogleDialogflowCxFlowAdvancedSettingsAudioExportGcsDestination): any;
export declare function googleDialogflowCxFlowAdvancedSettingsAudioExportGcsDestinationToHclTerraform(struct?: GoogleDialogflowCxFlowAdvancedSettingsAudioExportGcsDestinationOutputReference | GoogleDialogflowCxFlowAdvancedSettingsAudioExportGcsDestination): any;
export declare class GoogleDialogflowCxFlowAdvancedSettingsAudioExportGcsDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxFlowAdvancedSettingsAudioExportGcsDestination | undefined;
    set internalValue(value: GoogleDialogflowCxFlowAdvancedSettingsAudioExportGcsDestination | undefined);
    private _uri?;
    get uri(): string;
    set uri(value: string);
    resetUri(): void;
    get uriInput(): string | undefined;
}
export interface GoogleDialogflowCxFlowAdvancedSettingsDtmfSettings {
    /**
    * If true, incoming audio is processed for DTMF (dual tone multi frequency) events. For example, if the caller presses a button on their telephone keypad and DTMF processing is enabled, Dialogflow will detect the event (e.g. a "3" was pressed) in the incoming audio and pass the event to the bot to drive business logic (e.g. when 3 is pressed, return the account balance).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#enabled GoogleDialogflowCxFlow#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The digit that terminates a DTMF digit sequence.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#finish_digit GoogleDialogflowCxFlow#finish_digit}
    */
    readonly finishDigit?: string;
    /**
    * Max length of DTMF digits.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#max_digits GoogleDialogflowCxFlow#max_digits}
    */
    readonly maxDigits?: number;
}
export declare function googleDialogflowCxFlowAdvancedSettingsDtmfSettingsToTerraform(struct?: GoogleDialogflowCxFlowAdvancedSettingsDtmfSettingsOutputReference | GoogleDialogflowCxFlowAdvancedSettingsDtmfSettings): any;
export declare function googleDialogflowCxFlowAdvancedSettingsDtmfSettingsToHclTerraform(struct?: GoogleDialogflowCxFlowAdvancedSettingsDtmfSettingsOutputReference | GoogleDialogflowCxFlowAdvancedSettingsDtmfSettings): any;
export declare class GoogleDialogflowCxFlowAdvancedSettingsDtmfSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxFlowAdvancedSettingsDtmfSettings | undefined;
    set internalValue(value: GoogleDialogflowCxFlowAdvancedSettingsDtmfSettings | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _finishDigit?;
    get finishDigit(): string;
    set finishDigit(value: string);
    resetFinishDigit(): void;
    get finishDigitInput(): string | undefined;
    private _maxDigits?;
    get maxDigits(): number;
    set maxDigits(value: number);
    resetMaxDigits(): void;
    get maxDigitsInput(): number | undefined;
}
export interface GoogleDialogflowCxFlowAdvancedSettings {
    /**
    * audio_export_gcs_destination block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#audio_export_gcs_destination GoogleDialogflowCxFlow#audio_export_gcs_destination}
    */
    readonly audioExportGcsDestination?: GoogleDialogflowCxFlowAdvancedSettingsAudioExportGcsDestination;
    /**
    * dtmf_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#dtmf_settings GoogleDialogflowCxFlow#dtmf_settings}
    */
    readonly dtmfSettings?: GoogleDialogflowCxFlowAdvancedSettingsDtmfSettings;
}
export declare function googleDialogflowCxFlowAdvancedSettingsToTerraform(struct?: GoogleDialogflowCxFlowAdvancedSettingsOutputReference | GoogleDialogflowCxFlowAdvancedSettings): any;
export declare function googleDialogflowCxFlowAdvancedSettingsToHclTerraform(struct?: GoogleDialogflowCxFlowAdvancedSettingsOutputReference | GoogleDialogflowCxFlowAdvancedSettings): any;
export declare class GoogleDialogflowCxFlowAdvancedSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxFlowAdvancedSettings | undefined;
    set internalValue(value: GoogleDialogflowCxFlowAdvancedSettings | undefined);
    private _audioExportGcsDestination;
    get audioExportGcsDestination(): GoogleDialogflowCxFlowAdvancedSettingsAudioExportGcsDestinationOutputReference;
    putAudioExportGcsDestination(value: GoogleDialogflowCxFlowAdvancedSettingsAudioExportGcsDestination): void;
    resetAudioExportGcsDestination(): void;
    get audioExportGcsDestinationInput(): GoogleDialogflowCxFlowAdvancedSettingsAudioExportGcsDestination | undefined;
    private _dtmfSettings;
    get dtmfSettings(): GoogleDialogflowCxFlowAdvancedSettingsDtmfSettingsOutputReference;
    putDtmfSettings(value: GoogleDialogflowCxFlowAdvancedSettingsDtmfSettings): void;
    resetDtmfSettings(): void;
    get dtmfSettingsInput(): GoogleDialogflowCxFlowAdvancedSettingsDtmfSettings | undefined;
}
export interface GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentConditionalCases {
    /**
    * A JSON encoded list of cascading if-else conditions. Cases are mutually exclusive. The first one with a matching condition is selected, all the rest ignored.
    * See [Case](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/Fulfillment#case) for the schema.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#cases GoogleDialogflowCxFlow#cases}
    */
    readonly cases?: string;
}
export declare function googleDialogflowCxFlowEventHandlersTriggerFulfillmentConditionalCasesToTerraform(struct?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentConditionalCases | cdktf.IResolvable): any;
export declare function googleDialogflowCxFlowEventHandlersTriggerFulfillmentConditionalCasesToHclTerraform(struct?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentConditionalCases | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentConditionalCasesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentConditionalCases | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentConditionalCases | cdktf.IResolvable | undefined);
    private _cases?;
    get cases(): string;
    set cases(value: string);
    resetCases(): void;
    get casesInput(): string | undefined;
}
export declare class GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentConditionalCasesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentConditionalCases[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentConditionalCasesOutputReference;
}
export interface GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesConversationSuccess {
    /**
    * Custom metadata. Dialogflow doesn't impose any structure on this.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#metadata GoogleDialogflowCxFlow#metadata}
    */
    readonly metadata?: string;
}
export declare function googleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesConversationSuccessToTerraform(struct?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesConversationSuccessOutputReference | GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesConversationSuccess): any;
export declare function googleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesConversationSuccessToHclTerraform(struct?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesConversationSuccessOutputReference | GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesConversationSuccess): any;
export declare class GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesConversationSuccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesConversationSuccess | undefined;
    set internalValue(value: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesConversationSuccess | undefined);
    private _metadata?;
    get metadata(): string;
    set metadata(value: string);
    resetMetadata(): void;
    get metadataInput(): string | undefined;
}
export interface GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesLiveAgentHandoff {
    /**
    * Custom metadata. Dialogflow doesn't impose any structure on this.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#metadata GoogleDialogflowCxFlow#metadata}
    */
    readonly metadata?: string;
}
export declare function googleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesLiveAgentHandoffToTerraform(struct?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesLiveAgentHandoffOutputReference | GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesLiveAgentHandoff): any;
export declare function googleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesLiveAgentHandoffToHclTerraform(struct?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesLiveAgentHandoffOutputReference | GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesLiveAgentHandoff): any;
export declare class GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesLiveAgentHandoffOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesLiveAgentHandoff | undefined;
    set internalValue(value: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesLiveAgentHandoff | undefined);
    private _metadata?;
    get metadata(): string;
    set metadata(value: string);
    resetMetadata(): void;
    get metadataInput(): string | undefined;
}
export interface GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesOutputAudioText {
    /**
    * The SSML text to be synthesized. For more information, see SSML.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#ssml GoogleDialogflowCxFlow#ssml}
    */
    readonly ssml?: string;
    /**
    * The raw text to be synthesized.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#text GoogleDialogflowCxFlow#text}
    */
    readonly text?: string;
}
export declare function googleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesOutputAudioTextToTerraform(struct?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesOutputAudioTextOutputReference | GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesOutputAudioText): any;
export declare function googleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesOutputAudioTextToHclTerraform(struct?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesOutputAudioTextOutputReference | GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesOutputAudioText): any;
export declare class GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesOutputAudioTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesOutputAudioText | undefined;
    set internalValue(value: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesOutputAudioText | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _ssml?;
    get ssml(): string;
    set ssml(value: string);
    resetSsml(): void;
    get ssmlInput(): string | undefined;
    private _text?;
    get text(): string;
    set text(value: string);
    resetText(): void;
    get textInput(): string | undefined;
}
export interface GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesPlayAudio {
    /**
    * URI of the audio clip. Dialogflow does not impose any validation on this value. It is specific to the client that reads it.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#audio_uri GoogleDialogflowCxFlow#audio_uri}
    */
    readonly audioUri: string;
}
export declare function googleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesPlayAudioToTerraform(struct?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesPlayAudioOutputReference | GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesPlayAudio): any;
export declare function googleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesPlayAudioToHclTerraform(struct?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesPlayAudioOutputReference | GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesPlayAudio): any;
export declare class GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesPlayAudioOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesPlayAudio | undefined;
    set internalValue(value: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesPlayAudio | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _audioUri?;
    get audioUri(): string;
    set audioUri(value: string);
    get audioUriInput(): string | undefined;
}
export interface GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTelephonyTransferCall {
    /**
    * Transfer the call to a phone number in E.164 format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#phone_number GoogleDialogflowCxFlow#phone_number}
    */
    readonly phoneNumber: string;
}
export declare function googleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTelephonyTransferCallToTerraform(struct?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTelephonyTransferCallOutputReference | GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTelephonyTransferCall): any;
export declare function googleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTelephonyTransferCallToHclTerraform(struct?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTelephonyTransferCallOutputReference | GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTelephonyTransferCall): any;
export declare class GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTelephonyTransferCallOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTelephonyTransferCall | undefined;
    set internalValue(value: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTelephonyTransferCall | undefined);
    private _phoneNumber?;
    get phoneNumber(): string;
    set phoneNumber(value: string);
    get phoneNumberInput(): string | undefined;
}
export interface GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText {
    /**
    * A collection of text responses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#text GoogleDialogflowCxFlow#text}
    */
    readonly text?: string[];
}
export declare function googleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTextToTerraform(struct?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTextOutputReference | GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText): any;
export declare function googleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTextToHclTerraform(struct?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTextOutputReference | GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText): any;
export declare class GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText | undefined;
    set internalValue(value: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _text?;
    get text(): string[];
    set text(value: string[]);
    resetText(): void;
    get textInput(): string[] | undefined;
}
export interface GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessages {
    /**
    * The channel which the response is associated with. Clients can specify the channel via QueryParameters.channel, and only associated channel response will be returned.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#channel GoogleDialogflowCxFlow#channel}
    */
    readonly channel?: string;
    /**
    * A custom, platform-specific payload.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#payload GoogleDialogflowCxFlow#payload}
    */
    readonly payload?: string;
    /**
    * conversation_success block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#conversation_success GoogleDialogflowCxFlow#conversation_success}
    */
    readonly conversationSuccess?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesConversationSuccess;
    /**
    * live_agent_handoff block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#live_agent_handoff GoogleDialogflowCxFlow#live_agent_handoff}
    */
    readonly liveAgentHandoff?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesLiveAgentHandoff;
    /**
    * output_audio_text block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#output_audio_text GoogleDialogflowCxFlow#output_audio_text}
    */
    readonly outputAudioText?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesOutputAudioText;
    /**
    * play_audio block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#play_audio GoogleDialogflowCxFlow#play_audio}
    */
    readonly playAudio?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesPlayAudio;
    /**
    * telephony_transfer_call block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#telephony_transfer_call GoogleDialogflowCxFlow#telephony_transfer_call}
    */
    readonly telephonyTransferCall?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTelephonyTransferCall;
    /**
    * text block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#text GoogleDialogflowCxFlow#text}
    */
    readonly text?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText;
}
export declare function googleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesToTerraform(struct?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessages | cdktf.IResolvable): any;
export declare function googleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesToHclTerraform(struct?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessages | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessages | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessages | cdktf.IResolvable | undefined);
    private _channel?;
    get channel(): string;
    set channel(value: string);
    resetChannel(): void;
    get channelInput(): string | undefined;
    private _payload?;
    get payload(): string;
    set payload(value: string);
    resetPayload(): void;
    get payloadInput(): string | undefined;
    private _conversationSuccess;
    get conversationSuccess(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesConversationSuccessOutputReference;
    putConversationSuccess(value: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesConversationSuccess): void;
    resetConversationSuccess(): void;
    get conversationSuccessInput(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesConversationSuccess | undefined;
    private _liveAgentHandoff;
    get liveAgentHandoff(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesLiveAgentHandoffOutputReference;
    putLiveAgentHandoff(value: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesLiveAgentHandoff): void;
    resetLiveAgentHandoff(): void;
    get liveAgentHandoffInput(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesLiveAgentHandoff | undefined;
    private _outputAudioText;
    get outputAudioText(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesOutputAudioTextOutputReference;
    putOutputAudioText(value: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesOutputAudioText): void;
    resetOutputAudioText(): void;
    get outputAudioTextInput(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesOutputAudioText | undefined;
    private _playAudio;
    get playAudio(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesPlayAudioOutputReference;
    putPlayAudio(value: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesPlayAudio): void;
    resetPlayAudio(): void;
    get playAudioInput(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesPlayAudio | undefined;
    private _telephonyTransferCall;
    get telephonyTransferCall(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTelephonyTransferCallOutputReference;
    putTelephonyTransferCall(value: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTelephonyTransferCall): void;
    resetTelephonyTransferCall(): void;
    get telephonyTransferCallInput(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTelephonyTransferCall | undefined;
    private _text;
    get text(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTextOutputReference;
    putText(value: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText): void;
    resetText(): void;
    get textInput(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText | undefined;
}
export declare class GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessages[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesOutputReference;
}
export interface GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentSetParameterActions {
    /**
    * Display name of the parameter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#parameter GoogleDialogflowCxFlow#parameter}
    */
    readonly parameter?: string;
    /**
    * The new JSON-encoded value of the parameter. A null value clears the parameter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#value GoogleDialogflowCxFlow#value}
    */
    readonly value?: string;
}
export declare function googleDialogflowCxFlowEventHandlersTriggerFulfillmentSetParameterActionsToTerraform(struct?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentSetParameterActions | cdktf.IResolvable): any;
export declare function googleDialogflowCxFlowEventHandlersTriggerFulfillmentSetParameterActionsToHclTerraform(struct?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentSetParameterActions | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentSetParameterActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentSetParameterActions | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentSetParameterActions | cdktf.IResolvable | undefined);
    private _parameter?;
    get parameter(): string;
    set parameter(value: string);
    resetParameter(): void;
    get parameterInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentSetParameterActionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentSetParameterActions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentSetParameterActionsOutputReference;
}
export interface GoogleDialogflowCxFlowEventHandlersTriggerFulfillment {
    /**
    * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs. If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#return_partial_responses GoogleDialogflowCxFlow#return_partial_responses}
    */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
    * The tag used by the webhook to identify which fulfillment is being called. This field is required if webhook is specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#tag GoogleDialogflowCxFlow#tag}
    */
    readonly tag?: string;
    /**
    * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#webhook GoogleDialogflowCxFlow#webhook}
    */
    readonly webhook?: string;
    /**
    * conditional_cases block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#conditional_cases GoogleDialogflowCxFlow#conditional_cases}
    */
    readonly conditionalCases?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentConditionalCases[] | cdktf.IResolvable;
    /**
    * messages block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#messages GoogleDialogflowCxFlow#messages}
    */
    readonly messages?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessages[] | cdktf.IResolvable;
    /**
    * set_parameter_actions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#set_parameter_actions GoogleDialogflowCxFlow#set_parameter_actions}
    */
    readonly setParameterActions?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentSetParameterActions[] | cdktf.IResolvable;
}
export declare function googleDialogflowCxFlowEventHandlersTriggerFulfillmentToTerraform(struct?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentOutputReference | GoogleDialogflowCxFlowEventHandlersTriggerFulfillment): any;
export declare function googleDialogflowCxFlowEventHandlersTriggerFulfillmentToHclTerraform(struct?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentOutputReference | GoogleDialogflowCxFlowEventHandlersTriggerFulfillment): any;
export declare class GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillment | undefined;
    set internalValue(value: GoogleDialogflowCxFlowEventHandlersTriggerFulfillment | undefined);
    private _returnPartialResponses?;
    get returnPartialResponses(): boolean | cdktf.IResolvable;
    set returnPartialResponses(value: boolean | cdktf.IResolvable);
    resetReturnPartialResponses(): void;
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _webhook?;
    get webhook(): string;
    set webhook(value: string);
    resetWebhook(): void;
    get webhookInput(): string | undefined;
    private _conditionalCases;
    get conditionalCases(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentConditionalCasesList;
    putConditionalCases(value: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentConditionalCases[] | cdktf.IResolvable): void;
    resetConditionalCases(): void;
    get conditionalCasesInput(): cdktf.IResolvable | GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentConditionalCases[] | undefined;
    private _messages;
    get messages(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesList;
    putMessages(value: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessages[] | cdktf.IResolvable): void;
    resetMessages(): void;
    get messagesInput(): cdktf.IResolvable | GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessages[] | undefined;
    private _setParameterActions;
    get setParameterActions(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentSetParameterActionsList;
    putSetParameterActions(value: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentSetParameterActions[] | cdktf.IResolvable): void;
    resetSetParameterActions(): void;
    get setParameterActionsInput(): cdktf.IResolvable | GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentSetParameterActions[] | undefined;
}
export interface GoogleDialogflowCxFlowEventHandlers {
    /**
    * The name of the event to handle.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#event GoogleDialogflowCxFlow#event}
    */
    readonly event?: string;
    /**
    * The target flow to transition to.
    * Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#target_flow GoogleDialogflowCxFlow#target_flow}
    */
    readonly targetFlow?: string;
    /**
    * The target page to transition to.
    * Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#target_page GoogleDialogflowCxFlow#target_page}
    */
    readonly targetPage?: string;
    /**
    * trigger_fulfillment block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#trigger_fulfillment GoogleDialogflowCxFlow#trigger_fulfillment}
    */
    readonly triggerFulfillment?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillment;
}
export declare function googleDialogflowCxFlowEventHandlersToTerraform(struct?: GoogleDialogflowCxFlowEventHandlers | cdktf.IResolvable): any;
export declare function googleDialogflowCxFlowEventHandlersToHclTerraform(struct?: GoogleDialogflowCxFlowEventHandlers | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxFlowEventHandlersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxFlowEventHandlers | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxFlowEventHandlers | cdktf.IResolvable | undefined);
    private _event?;
    get event(): string;
    set event(value: string);
    resetEvent(): void;
    get eventInput(): string | undefined;
    get name(): string;
    private _targetFlow?;
    get targetFlow(): string;
    set targetFlow(value: string);
    resetTargetFlow(): void;
    get targetFlowInput(): string | undefined;
    private _targetPage?;
    get targetPage(): string;
    set targetPage(value: string);
    resetTargetPage(): void;
    get targetPageInput(): string | undefined;
    private _triggerFulfillment;
    get triggerFulfillment(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentOutputReference;
    putTriggerFulfillment(value: GoogleDialogflowCxFlowEventHandlersTriggerFulfillment): void;
    resetTriggerFulfillment(): void;
    get triggerFulfillmentInput(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillment | undefined;
}
export declare class GoogleDialogflowCxFlowEventHandlersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxFlowEventHandlers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxFlowEventHandlersOutputReference;
}
export interface GoogleDialogflowCxFlowNluSettings {
    /**
    * To filter out false positive results and still get variety in matched natural language inputs for your agent, you can tune the machine learning classification threshold.
    * If the returned score value is less than the threshold value, then a no-match event will be triggered. The score values range from 0.0 (completely uncertain) to 1.0 (completely certain). If set to 0.0, the default of 0.3 is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#classification_threshold GoogleDialogflowCxFlow#classification_threshold}
    */
    readonly classificationThreshold?: number;
    /**
    * Indicates NLU model training mode.
    * * MODEL_TRAINING_MODE_AUTOMATIC: NLU model training is automatically triggered when a flow gets modified. User can also manually trigger model training in this mode.
    * * MODEL_TRAINING_MODE_MANUAL: User needs to manually trigger NLU model training. Best for large flows whose models take long time to train. Possible values: ["MODEL_TRAINING_MODE_AUTOMATIC", "MODEL_TRAINING_MODE_MANUAL"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#model_training_mode GoogleDialogflowCxFlow#model_training_mode}
    */
    readonly modelTrainingMode?: string;
    /**
    * Indicates the type of NLU model.
    * * MODEL_TYPE_STANDARD: Use standard NLU model.
    * * MODEL_TYPE_ADVANCED: Use advanced NLU model. Possible values: ["MODEL_TYPE_STANDARD", "MODEL_TYPE_ADVANCED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#model_type GoogleDialogflowCxFlow#model_type}
    */
    readonly modelType?: string;
}
export declare function googleDialogflowCxFlowNluSettingsToTerraform(struct?: GoogleDialogflowCxFlowNluSettingsOutputReference | GoogleDialogflowCxFlowNluSettings): any;
export declare function googleDialogflowCxFlowNluSettingsToHclTerraform(struct?: GoogleDialogflowCxFlowNluSettingsOutputReference | GoogleDialogflowCxFlowNluSettings): any;
export declare class GoogleDialogflowCxFlowNluSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxFlowNluSettings | undefined;
    set internalValue(value: GoogleDialogflowCxFlowNluSettings | undefined);
    private _classificationThreshold?;
    get classificationThreshold(): number;
    set classificationThreshold(value: number);
    resetClassificationThreshold(): void;
    get classificationThresholdInput(): number | undefined;
    private _modelTrainingMode?;
    get modelTrainingMode(): string;
    set modelTrainingMode(value: string);
    resetModelTrainingMode(): void;
    get modelTrainingModeInput(): string | undefined;
    private _modelType?;
    get modelType(): string;
    set modelType(value: string);
    resetModelType(): void;
    get modelTypeInput(): string | undefined;
}
export interface GoogleDialogflowCxFlowTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#create GoogleDialogflowCxFlow#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#delete GoogleDialogflowCxFlow#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#update GoogleDialogflowCxFlow#update}
    */
    readonly update?: string;
}
export declare function googleDialogflowCxFlowTimeoutsToTerraform(struct?: GoogleDialogflowCxFlowTimeouts | cdktf.IResolvable): any;
export declare function googleDialogflowCxFlowTimeoutsToHclTerraform(struct?: GoogleDialogflowCxFlowTimeouts | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxFlowTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxFlowTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxFlowTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentConditionalCases {
    /**
    * A JSON encoded list of cascading if-else conditions. Cases are mutually exclusive. The first one with a matching condition is selected, all the rest ignored.
    * See [Case](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/Fulfillment#case) for the schema.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#cases GoogleDialogflowCxFlow#cases}
    */
    readonly cases?: string;
}
export declare function googleDialogflowCxFlowTransitionRoutesTriggerFulfillmentConditionalCasesToTerraform(struct?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentConditionalCases | cdktf.IResolvable): any;
export declare function googleDialogflowCxFlowTransitionRoutesTriggerFulfillmentConditionalCasesToHclTerraform(struct?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentConditionalCases | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentConditionalCasesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentConditionalCases | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentConditionalCases | cdktf.IResolvable | undefined);
    private _cases?;
    get cases(): string;
    set cases(value: string);
    resetCases(): void;
    get casesInput(): string | undefined;
}
export declare class GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentConditionalCasesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentConditionalCases[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentConditionalCasesOutputReference;
}
export interface GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesConversationSuccess {
    /**
    * Custom metadata. Dialogflow doesn't impose any structure on this.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#metadata GoogleDialogflowCxFlow#metadata}
    */
    readonly metadata?: string;
}
export declare function googleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesConversationSuccessToTerraform(struct?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesConversationSuccessOutputReference | GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesConversationSuccess): any;
export declare function googleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesConversationSuccessToHclTerraform(struct?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesConversationSuccessOutputReference | GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesConversationSuccess): any;
export declare class GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesConversationSuccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesConversationSuccess | undefined;
    set internalValue(value: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesConversationSuccess | undefined);
    private _metadata?;
    get metadata(): string;
    set metadata(value: string);
    resetMetadata(): void;
    get metadataInput(): string | undefined;
}
export interface GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesLiveAgentHandoff {
    /**
    * Custom metadata. Dialogflow doesn't impose any structure on this.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#metadata GoogleDialogflowCxFlow#metadata}
    */
    readonly metadata?: string;
}
export declare function googleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesLiveAgentHandoffToTerraform(struct?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesLiveAgentHandoffOutputReference | GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesLiveAgentHandoff): any;
export declare function googleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesLiveAgentHandoffToHclTerraform(struct?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesLiveAgentHandoffOutputReference | GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesLiveAgentHandoff): any;
export declare class GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesLiveAgentHandoffOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesLiveAgentHandoff | undefined;
    set internalValue(value: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesLiveAgentHandoff | undefined);
    private _metadata?;
    get metadata(): string;
    set metadata(value: string);
    resetMetadata(): void;
    get metadataInput(): string | undefined;
}
export interface GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesOutputAudioText {
    /**
    * The SSML text to be synthesized. For more information, see SSML.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#ssml GoogleDialogflowCxFlow#ssml}
    */
    readonly ssml?: string;
    /**
    * The raw text to be synthesized.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#text GoogleDialogflowCxFlow#text}
    */
    readonly text?: string;
}
export declare function googleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesOutputAudioTextToTerraform(struct?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesOutputAudioTextOutputReference | GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesOutputAudioText): any;
export declare function googleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesOutputAudioTextToHclTerraform(struct?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesOutputAudioTextOutputReference | GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesOutputAudioText): any;
export declare class GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesOutputAudioTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesOutputAudioText | undefined;
    set internalValue(value: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesOutputAudioText | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _ssml?;
    get ssml(): string;
    set ssml(value: string);
    resetSsml(): void;
    get ssmlInput(): string | undefined;
    private _text?;
    get text(): string;
    set text(value: string);
    resetText(): void;
    get textInput(): string | undefined;
}
export interface GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesPlayAudio {
    /**
    * URI of the audio clip. Dialogflow does not impose any validation on this value. It is specific to the client that reads it.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#audio_uri GoogleDialogflowCxFlow#audio_uri}
    */
    readonly audioUri: string;
}
export declare function googleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesPlayAudioToTerraform(struct?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesPlayAudioOutputReference | GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesPlayAudio): any;
export declare function googleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesPlayAudioToHclTerraform(struct?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesPlayAudioOutputReference | GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesPlayAudio): any;
export declare class GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesPlayAudioOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesPlayAudio | undefined;
    set internalValue(value: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesPlayAudio | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _audioUri?;
    get audioUri(): string;
    set audioUri(value: string);
    get audioUriInput(): string | undefined;
}
export interface GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTelephonyTransferCall {
    /**
    * Transfer the call to a phone number in E.164 format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#phone_number GoogleDialogflowCxFlow#phone_number}
    */
    readonly phoneNumber: string;
}
export declare function googleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTelephonyTransferCallToTerraform(struct?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTelephonyTransferCallOutputReference | GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTelephonyTransferCall): any;
export declare function googleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTelephonyTransferCallToHclTerraform(struct?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTelephonyTransferCallOutputReference | GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTelephonyTransferCall): any;
export declare class GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTelephonyTransferCallOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTelephonyTransferCall | undefined;
    set internalValue(value: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTelephonyTransferCall | undefined);
    private _phoneNumber?;
    get phoneNumber(): string;
    set phoneNumber(value: string);
    get phoneNumberInput(): string | undefined;
}
export interface GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText {
    /**
    * A collection of text responses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#text GoogleDialogflowCxFlow#text}
    */
    readonly text?: string[];
}
export declare function googleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTextToTerraform(struct?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTextOutputReference | GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText): any;
export declare function googleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTextToHclTerraform(struct?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTextOutputReference | GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText): any;
export declare class GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText | undefined;
    set internalValue(value: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _text?;
    get text(): string[];
    set text(value: string[]);
    resetText(): void;
    get textInput(): string[] | undefined;
}
export interface GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages {
    /**
    * The channel which the response is associated with. Clients can specify the channel via QueryParameters.channel, and only associated channel response will be returned.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#channel GoogleDialogflowCxFlow#channel}
    */
    readonly channel?: string;
    /**
    * A custom, platform-specific payload.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#payload GoogleDialogflowCxFlow#payload}
    */
    readonly payload?: string;
    /**
    * conversation_success block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#conversation_success GoogleDialogflowCxFlow#conversation_success}
    */
    readonly conversationSuccess?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesConversationSuccess;
    /**
    * live_agent_handoff block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#live_agent_handoff GoogleDialogflowCxFlow#live_agent_handoff}
    */
    readonly liveAgentHandoff?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesLiveAgentHandoff;
    /**
    * output_audio_text block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#output_audio_text GoogleDialogflowCxFlow#output_audio_text}
    */
    readonly outputAudioText?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesOutputAudioText;
    /**
    * play_audio block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#play_audio GoogleDialogflowCxFlow#play_audio}
    */
    readonly playAudio?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesPlayAudio;
    /**
    * telephony_transfer_call block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#telephony_transfer_call GoogleDialogflowCxFlow#telephony_transfer_call}
    */
    readonly telephonyTransferCall?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTelephonyTransferCall;
    /**
    * text block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#text GoogleDialogflowCxFlow#text}
    */
    readonly text?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText;
}
export declare function googleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesToTerraform(struct?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages | cdktf.IResolvable): any;
export declare function googleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesToHclTerraform(struct?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages | cdktf.IResolvable | undefined);
    private _channel?;
    get channel(): string;
    set channel(value: string);
    resetChannel(): void;
    get channelInput(): string | undefined;
    private _payload?;
    get payload(): string;
    set payload(value: string);
    resetPayload(): void;
    get payloadInput(): string | undefined;
    private _conversationSuccess;
    get conversationSuccess(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesConversationSuccessOutputReference;
    putConversationSuccess(value: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesConversationSuccess): void;
    resetConversationSuccess(): void;
    get conversationSuccessInput(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesConversationSuccess | undefined;
    private _liveAgentHandoff;
    get liveAgentHandoff(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesLiveAgentHandoffOutputReference;
    putLiveAgentHandoff(value: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesLiveAgentHandoff): void;
    resetLiveAgentHandoff(): void;
    get liveAgentHandoffInput(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesLiveAgentHandoff | undefined;
    private _outputAudioText;
    get outputAudioText(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesOutputAudioTextOutputReference;
    putOutputAudioText(value: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesOutputAudioText): void;
    resetOutputAudioText(): void;
    get outputAudioTextInput(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesOutputAudioText | undefined;
    private _playAudio;
    get playAudio(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesPlayAudioOutputReference;
    putPlayAudio(value: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesPlayAudio): void;
    resetPlayAudio(): void;
    get playAudioInput(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesPlayAudio | undefined;
    private _telephonyTransferCall;
    get telephonyTransferCall(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTelephonyTransferCallOutputReference;
    putTelephonyTransferCall(value: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTelephonyTransferCall): void;
    resetTelephonyTransferCall(): void;
    get telephonyTransferCallInput(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTelephonyTransferCall | undefined;
    private _text;
    get text(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTextOutputReference;
    putText(value: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText): void;
    resetText(): void;
    get textInput(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText | undefined;
}
export declare class GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesOutputReference;
}
export interface GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentSetParameterActions {
    /**
    * Display name of the parameter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#parameter GoogleDialogflowCxFlow#parameter}
    */
    readonly parameter?: string;
    /**
    * The new JSON-encoded value of the parameter. A null value clears the parameter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#value GoogleDialogflowCxFlow#value}
    */
    readonly value?: string;
}
export declare function googleDialogflowCxFlowTransitionRoutesTriggerFulfillmentSetParameterActionsToTerraform(struct?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentSetParameterActions | cdktf.IResolvable): any;
export declare function googleDialogflowCxFlowTransitionRoutesTriggerFulfillmentSetParameterActionsToHclTerraform(struct?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentSetParameterActions | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentSetParameterActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentSetParameterActions | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentSetParameterActions | cdktf.IResolvable | undefined);
    private _parameter?;
    get parameter(): string;
    set parameter(value: string);
    resetParameter(): void;
    get parameterInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentSetParameterActionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentSetParameterActions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentSetParameterActionsOutputReference;
}
export interface GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillment {
    /**
    * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs. If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#return_partial_responses GoogleDialogflowCxFlow#return_partial_responses}
    */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
    * The tag used by the webhook to identify which fulfillment is being called. This field is required if webhook is specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#tag GoogleDialogflowCxFlow#tag}
    */
    readonly tag?: string;
    /**
    * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#webhook GoogleDialogflowCxFlow#webhook}
    */
    readonly webhook?: string;
    /**
    * conditional_cases block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#conditional_cases GoogleDialogflowCxFlow#conditional_cases}
    */
    readonly conditionalCases?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentConditionalCases[] | cdktf.IResolvable;
    /**
    * messages block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#messages GoogleDialogflowCxFlow#messages}
    */
    readonly messages?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages[] | cdktf.IResolvable;
    /**
    * set_parameter_actions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#set_parameter_actions GoogleDialogflowCxFlow#set_parameter_actions}
    */
    readonly setParameterActions?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentSetParameterActions[] | cdktf.IResolvable;
}
export declare function googleDialogflowCxFlowTransitionRoutesTriggerFulfillmentToTerraform(struct?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentOutputReference | GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillment): any;
export declare function googleDialogflowCxFlowTransitionRoutesTriggerFulfillmentToHclTerraform(struct?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentOutputReference | GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillment): any;
export declare class GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillment | undefined;
    set internalValue(value: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillment | undefined);
    private _returnPartialResponses?;
    get returnPartialResponses(): boolean | cdktf.IResolvable;
    set returnPartialResponses(value: boolean | cdktf.IResolvable);
    resetReturnPartialResponses(): void;
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _webhook?;
    get webhook(): string;
    set webhook(value: string);
    resetWebhook(): void;
    get webhookInput(): string | undefined;
    private _conditionalCases;
    get conditionalCases(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentConditionalCasesList;
    putConditionalCases(value: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentConditionalCases[] | cdktf.IResolvable): void;
    resetConditionalCases(): void;
    get conditionalCasesInput(): cdktf.IResolvable | GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentConditionalCases[] | undefined;
    private _messages;
    get messages(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesList;
    putMessages(value: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages[] | cdktf.IResolvable): void;
    resetMessages(): void;
    get messagesInput(): cdktf.IResolvable | GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages[] | undefined;
    private _setParameterActions;
    get setParameterActions(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentSetParameterActionsList;
    putSetParameterActions(value: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentSetParameterActions[] | cdktf.IResolvable): void;
    resetSetParameterActions(): void;
    get setParameterActionsInput(): cdktf.IResolvable | GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentSetParameterActions[] | undefined;
}
export interface GoogleDialogflowCxFlowTransitionRoutes {
    /**
    * The condition to evaluate against form parameters or session parameters.
    * At least one of intent or condition must be specified. When both intent and condition are specified, the transition can only happen when both are fulfilled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#condition GoogleDialogflowCxFlow#condition}
    */
    readonly condition?: string;
    /**
    * The unique identifier of an Intent.
    * Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/intents/<Intent ID>. Indicates that the transition can only happen when the given intent is matched. At least one of intent or condition must be specified. When both intent and condition are specified, the transition can only happen when both are fulfilled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#intent GoogleDialogflowCxFlow#intent}
    */
    readonly intent?: string;
    /**
    * The target flow to transition to.
    * Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#target_flow GoogleDialogflowCxFlow#target_flow}
    */
    readonly targetFlow?: string;
    /**
    * The target page to transition to.
    * Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#target_page GoogleDialogflowCxFlow#target_page}
    */
    readonly targetPage?: string;
    /**
    * trigger_fulfillment block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#trigger_fulfillment GoogleDialogflowCxFlow#trigger_fulfillment}
    */
    readonly triggerFulfillment?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillment;
}
export declare function googleDialogflowCxFlowTransitionRoutesToTerraform(struct?: GoogleDialogflowCxFlowTransitionRoutes | cdktf.IResolvable): any;
export declare function googleDialogflowCxFlowTransitionRoutesToHclTerraform(struct?: GoogleDialogflowCxFlowTransitionRoutes | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxFlowTransitionRoutesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxFlowTransitionRoutes | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxFlowTransitionRoutes | cdktf.IResolvable | undefined);
    private _condition?;
    get condition(): string;
    set condition(value: string);
    resetCondition(): void;
    get conditionInput(): string | undefined;
    private _intent?;
    get intent(): string;
    set intent(value: string);
    resetIntent(): void;
    get intentInput(): string | undefined;
    get name(): string;
    private _targetFlow?;
    get targetFlow(): string;
    set targetFlow(value: string);
    resetTargetFlow(): void;
    get targetFlowInput(): string | undefined;
    private _targetPage?;
    get targetPage(): string;
    set targetPage(value: string);
    resetTargetPage(): void;
    get targetPageInput(): string | undefined;
    private _triggerFulfillment;
    get triggerFulfillment(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentOutputReference;
    putTriggerFulfillment(value: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillment): void;
    resetTriggerFulfillment(): void;
    get triggerFulfillmentInput(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillment | undefined;
}
export declare class GoogleDialogflowCxFlowTransitionRoutesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxFlowTransitionRoutes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxFlowTransitionRoutesOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow google_dialogflow_cx_flow}
*/
export declare class GoogleDialogflowCxFlow extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dialogflow_cx_flow";
    /**
    * Generates CDKTF code for importing a GoogleDialogflowCxFlow resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleDialogflowCxFlow to import
    * @param importFromId The id of the existing GoogleDialogflowCxFlow that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleDialogflowCxFlow to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_flow google_dialogflow_cx_flow} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDialogflowCxFlowConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDialogflowCxFlowConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isDefaultStartFlow?;
    get isDefaultStartFlow(): boolean | cdktf.IResolvable;
    set isDefaultStartFlow(value: boolean | cdktf.IResolvable);
    resetIsDefaultStartFlow(): void;
    get isDefaultStartFlowInput(): boolean | cdktf.IResolvable | undefined;
    private _languageCode?;
    get languageCode(): string;
    set languageCode(value: string);
    resetLanguageCode(): void;
    get languageCodeInput(): string | undefined;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    resetParent(): void;
    get parentInput(): string | undefined;
    private _transitionRouteGroups?;
    get transitionRouteGroups(): string[];
    set transitionRouteGroups(value: string[]);
    resetTransitionRouteGroups(): void;
    get transitionRouteGroupsInput(): string[] | undefined;
    private _advancedSettings;
    get advancedSettings(): GoogleDialogflowCxFlowAdvancedSettingsOutputReference;
    putAdvancedSettings(value: GoogleDialogflowCxFlowAdvancedSettings): void;
    resetAdvancedSettings(): void;
    get advancedSettingsInput(): GoogleDialogflowCxFlowAdvancedSettings | undefined;
    private _eventHandlers;
    get eventHandlers(): GoogleDialogflowCxFlowEventHandlersList;
    putEventHandlers(value: GoogleDialogflowCxFlowEventHandlers[] | cdktf.IResolvable): void;
    resetEventHandlers(): void;
    get eventHandlersInput(): cdktf.IResolvable | GoogleDialogflowCxFlowEventHandlers[] | undefined;
    private _nluSettings;
    get nluSettings(): GoogleDialogflowCxFlowNluSettingsOutputReference;
    putNluSettings(value: GoogleDialogflowCxFlowNluSettings): void;
    resetNluSettings(): void;
    get nluSettingsInput(): GoogleDialogflowCxFlowNluSettings | undefined;
    private _timeouts;
    get timeouts(): GoogleDialogflowCxFlowTimeoutsOutputReference;
    putTimeouts(value: GoogleDialogflowCxFlowTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDialogflowCxFlowTimeouts | undefined;
    private _transitionRoutes;
    get transitionRoutes(): GoogleDialogflowCxFlowTransitionRoutesList;
    putTransitionRoutes(value: GoogleDialogflowCxFlowTransitionRoutes[] | cdktf.IResolvable): void;
    resetTransitionRoutes(): void;
    get transitionRoutesInput(): cdktf.IResolvable | GoogleDialogflowCxFlowTransitionRoutes[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
