/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDialogflowCxPageConfig extends cdktf.TerraformMetaArguments {
    /**
    * The human-readable name of the page, unique within the agent.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#display_name GoogleDialogflowCxPage#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#id GoogleDialogflowCxPage#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The language of the following fields in page:
    *
    * Page.entry_fulfillment.messages
    * Page.entry_fulfillment.conditional_cases
    * Page.event_handlers.trigger_fulfillment.messages
    * Page.event_handlers.trigger_fulfillment.conditional_cases
    * Page.form.parameters.fill_behavior.initial_prompt_fulfillment.messages
    * Page.form.parameters.fill_behavior.initial_prompt_fulfillment.conditional_cases
    * Page.form.parameters.fill_behavior.reprompt_event_handlers.messages
    * Page.form.parameters.fill_behavior.reprompt_event_handlers.conditional_cases
    * Page.transition_routes.trigger_fulfillment.messages
    * Page.transition_routes.trigger_fulfillment.conditional_cases
    * If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#language_code GoogleDialogflowCxPage#language_code}
    */
    readonly languageCode?: string;
    /**
    * The flow to create a page for.
    * Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#parent GoogleDialogflowCxPage#parent}
    */
    readonly parent?: string;
    /**
    * Ordered list of TransitionRouteGroups associated with the page. Transition route groups must be unique within a page.
    * If multiple transition routes within a page scope refer to the same intent, then the precedence order is: page's transition route -> page's transition route group -> flow's transition routes.
    * If multiple transition route groups within a page contain the same intent, then the first group in the ordered list takes precedence.
    * Format:projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#transition_route_groups GoogleDialogflowCxPage#transition_route_groups}
    */
    readonly transitionRouteGroups?: string[];
    /**
    * advanced_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#advanced_settings GoogleDialogflowCxPage#advanced_settings}
    */
    readonly advancedSettings?: GoogleDialogflowCxPageAdvancedSettings;
    /**
    * entry_fulfillment block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#entry_fulfillment GoogleDialogflowCxPage#entry_fulfillment}
    */
    readonly entryFulfillment?: GoogleDialogflowCxPageEntryFulfillment;
    /**
    * event_handlers block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#event_handlers GoogleDialogflowCxPage#event_handlers}
    */
    readonly eventHandlers?: GoogleDialogflowCxPageEventHandlers[] | cdktf.IResolvable;
    /**
    * form block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#form GoogleDialogflowCxPage#form}
    */
    readonly form?: GoogleDialogflowCxPageForm;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#timeouts GoogleDialogflowCxPage#timeouts}
    */
    readonly timeouts?: GoogleDialogflowCxPageTimeouts;
    /**
    * transition_routes block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#transition_routes GoogleDialogflowCxPage#transition_routes}
    */
    readonly transitionRoutes?: GoogleDialogflowCxPageTransitionRoutes[] | cdktf.IResolvable;
}
export interface GoogleDialogflowCxPageAdvancedSettingsDtmfSettings {
    /**
    * If true, incoming audio is processed for DTMF (dual tone multi frequency) events. For example, if the caller presses a button on their telephone keypad and DTMF processing is enabled, Dialogflow will detect the event (e.g. a "3" was pressed) in the incoming audio and pass the event to the bot to drive business logic (e.g. when 3 is pressed, return the account balance).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#enabled GoogleDialogflowCxPage#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The digit that terminates a DTMF digit sequence.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#finish_digit GoogleDialogflowCxPage#finish_digit}
    */
    readonly finishDigit?: string;
    /**
    * Max length of DTMF digits.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#max_digits GoogleDialogflowCxPage#max_digits}
    */
    readonly maxDigits?: number;
}
export declare function googleDialogflowCxPageAdvancedSettingsDtmfSettingsToTerraform(struct?: GoogleDialogflowCxPageAdvancedSettingsDtmfSettingsOutputReference | GoogleDialogflowCxPageAdvancedSettingsDtmfSettings): any;
export declare function googleDialogflowCxPageAdvancedSettingsDtmfSettingsToHclTerraform(struct?: GoogleDialogflowCxPageAdvancedSettingsDtmfSettingsOutputReference | GoogleDialogflowCxPageAdvancedSettingsDtmfSettings): any;
export declare class GoogleDialogflowCxPageAdvancedSettingsDtmfSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageAdvancedSettingsDtmfSettings | undefined;
    set internalValue(value: GoogleDialogflowCxPageAdvancedSettingsDtmfSettings | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _finishDigit?;
    get finishDigit(): string;
    set finishDigit(value: string);
    resetFinishDigit(): void;
    get finishDigitInput(): string | undefined;
    private _maxDigits?;
    get maxDigits(): number;
    set maxDigits(value: number);
    resetMaxDigits(): void;
    get maxDigitsInput(): number | undefined;
}
export interface GoogleDialogflowCxPageAdvancedSettings {
    /**
    * dtmf_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#dtmf_settings GoogleDialogflowCxPage#dtmf_settings}
    */
    readonly dtmfSettings?: GoogleDialogflowCxPageAdvancedSettingsDtmfSettings;
}
export declare function googleDialogflowCxPageAdvancedSettingsToTerraform(struct?: GoogleDialogflowCxPageAdvancedSettingsOutputReference | GoogleDialogflowCxPageAdvancedSettings): any;
export declare function googleDialogflowCxPageAdvancedSettingsToHclTerraform(struct?: GoogleDialogflowCxPageAdvancedSettingsOutputReference | GoogleDialogflowCxPageAdvancedSettings): any;
export declare class GoogleDialogflowCxPageAdvancedSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageAdvancedSettings | undefined;
    set internalValue(value: GoogleDialogflowCxPageAdvancedSettings | undefined);
    private _dtmfSettings;
    get dtmfSettings(): GoogleDialogflowCxPageAdvancedSettingsDtmfSettingsOutputReference;
    putDtmfSettings(value: GoogleDialogflowCxPageAdvancedSettingsDtmfSettings): void;
    resetDtmfSettings(): void;
    get dtmfSettingsInput(): GoogleDialogflowCxPageAdvancedSettingsDtmfSettings | undefined;
}
export interface GoogleDialogflowCxPageEntryFulfillmentConditionalCases {
    /**
    * A JSON encoded list of cascading if-else conditions. Cases are mutually exclusive. The first one with a matching condition is selected, all the rest ignored.
    * See [Case](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/Fulfillment#case) for the schema.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#cases GoogleDialogflowCxPage#cases}
    */
    readonly cases?: string;
}
export declare function googleDialogflowCxPageEntryFulfillmentConditionalCasesToTerraform(struct?: GoogleDialogflowCxPageEntryFulfillmentConditionalCases | cdktf.IResolvable): any;
export declare function googleDialogflowCxPageEntryFulfillmentConditionalCasesToHclTerraform(struct?: GoogleDialogflowCxPageEntryFulfillmentConditionalCases | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxPageEntryFulfillmentConditionalCasesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxPageEntryFulfillmentConditionalCases | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxPageEntryFulfillmentConditionalCases | cdktf.IResolvable | undefined);
    private _cases?;
    get cases(): string;
    set cases(value: string);
    resetCases(): void;
    get casesInput(): string | undefined;
}
export declare class GoogleDialogflowCxPageEntryFulfillmentConditionalCasesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxPageEntryFulfillmentConditionalCases[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxPageEntryFulfillmentConditionalCasesOutputReference;
}
export interface GoogleDialogflowCxPageEntryFulfillmentMessagesConversationSuccess {
    /**
    * Custom metadata. Dialogflow doesn't impose any structure on this.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#metadata GoogleDialogflowCxPage#metadata}
    */
    readonly metadata?: string;
}
export declare function googleDialogflowCxPageEntryFulfillmentMessagesConversationSuccessToTerraform(struct?: GoogleDialogflowCxPageEntryFulfillmentMessagesConversationSuccessOutputReference | GoogleDialogflowCxPageEntryFulfillmentMessagesConversationSuccess): any;
export declare function googleDialogflowCxPageEntryFulfillmentMessagesConversationSuccessToHclTerraform(struct?: GoogleDialogflowCxPageEntryFulfillmentMessagesConversationSuccessOutputReference | GoogleDialogflowCxPageEntryFulfillmentMessagesConversationSuccess): any;
export declare class GoogleDialogflowCxPageEntryFulfillmentMessagesConversationSuccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageEntryFulfillmentMessagesConversationSuccess | undefined;
    set internalValue(value: GoogleDialogflowCxPageEntryFulfillmentMessagesConversationSuccess | undefined);
    private _metadata?;
    get metadata(): string;
    set metadata(value: string);
    resetMetadata(): void;
    get metadataInput(): string | undefined;
}
export interface GoogleDialogflowCxPageEntryFulfillmentMessagesLiveAgentHandoff {
    /**
    * Custom metadata. Dialogflow doesn't impose any structure on this.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#metadata GoogleDialogflowCxPage#metadata}
    */
    readonly metadata?: string;
}
export declare function googleDialogflowCxPageEntryFulfillmentMessagesLiveAgentHandoffToTerraform(struct?: GoogleDialogflowCxPageEntryFulfillmentMessagesLiveAgentHandoffOutputReference | GoogleDialogflowCxPageEntryFulfillmentMessagesLiveAgentHandoff): any;
export declare function googleDialogflowCxPageEntryFulfillmentMessagesLiveAgentHandoffToHclTerraform(struct?: GoogleDialogflowCxPageEntryFulfillmentMessagesLiveAgentHandoffOutputReference | GoogleDialogflowCxPageEntryFulfillmentMessagesLiveAgentHandoff): any;
export declare class GoogleDialogflowCxPageEntryFulfillmentMessagesLiveAgentHandoffOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageEntryFulfillmentMessagesLiveAgentHandoff | undefined;
    set internalValue(value: GoogleDialogflowCxPageEntryFulfillmentMessagesLiveAgentHandoff | undefined);
    private _metadata?;
    get metadata(): string;
    set metadata(value: string);
    resetMetadata(): void;
    get metadataInput(): string | undefined;
}
export interface GoogleDialogflowCxPageEntryFulfillmentMessagesOutputAudioText {
    /**
    * The SSML text to be synthesized. For more information, see SSML.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#ssml GoogleDialogflowCxPage#ssml}
    */
    readonly ssml?: string;
    /**
    * The raw text to be synthesized.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#text GoogleDialogflowCxPage#text}
    */
    readonly text?: string;
}
export declare function googleDialogflowCxPageEntryFulfillmentMessagesOutputAudioTextToTerraform(struct?: GoogleDialogflowCxPageEntryFulfillmentMessagesOutputAudioTextOutputReference | GoogleDialogflowCxPageEntryFulfillmentMessagesOutputAudioText): any;
export declare function googleDialogflowCxPageEntryFulfillmentMessagesOutputAudioTextToHclTerraform(struct?: GoogleDialogflowCxPageEntryFulfillmentMessagesOutputAudioTextOutputReference | GoogleDialogflowCxPageEntryFulfillmentMessagesOutputAudioText): any;
export declare class GoogleDialogflowCxPageEntryFulfillmentMessagesOutputAudioTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageEntryFulfillmentMessagesOutputAudioText | undefined;
    set internalValue(value: GoogleDialogflowCxPageEntryFulfillmentMessagesOutputAudioText | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _ssml?;
    get ssml(): string;
    set ssml(value: string);
    resetSsml(): void;
    get ssmlInput(): string | undefined;
    private _text?;
    get text(): string;
    set text(value: string);
    resetText(): void;
    get textInput(): string | undefined;
}
export interface GoogleDialogflowCxPageEntryFulfillmentMessagesPlayAudio {
    /**
    * URI of the audio clip. Dialogflow does not impose any validation on this value. It is specific to the client that reads it.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#audio_uri GoogleDialogflowCxPage#audio_uri}
    */
    readonly audioUri: string;
}
export declare function googleDialogflowCxPageEntryFulfillmentMessagesPlayAudioToTerraform(struct?: GoogleDialogflowCxPageEntryFulfillmentMessagesPlayAudioOutputReference | GoogleDialogflowCxPageEntryFulfillmentMessagesPlayAudio): any;
export declare function googleDialogflowCxPageEntryFulfillmentMessagesPlayAudioToHclTerraform(struct?: GoogleDialogflowCxPageEntryFulfillmentMessagesPlayAudioOutputReference | GoogleDialogflowCxPageEntryFulfillmentMessagesPlayAudio): any;
export declare class GoogleDialogflowCxPageEntryFulfillmentMessagesPlayAudioOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageEntryFulfillmentMessagesPlayAudio | undefined;
    set internalValue(value: GoogleDialogflowCxPageEntryFulfillmentMessagesPlayAudio | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _audioUri?;
    get audioUri(): string;
    set audioUri(value: string);
    get audioUriInput(): string | undefined;
}
export interface GoogleDialogflowCxPageEntryFulfillmentMessagesTelephonyTransferCall {
    /**
    * Transfer the call to a phone number in E.164 format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#phone_number GoogleDialogflowCxPage#phone_number}
    */
    readonly phoneNumber: string;
}
export declare function googleDialogflowCxPageEntryFulfillmentMessagesTelephonyTransferCallToTerraform(struct?: GoogleDialogflowCxPageEntryFulfillmentMessagesTelephonyTransferCallOutputReference | GoogleDialogflowCxPageEntryFulfillmentMessagesTelephonyTransferCall): any;
export declare function googleDialogflowCxPageEntryFulfillmentMessagesTelephonyTransferCallToHclTerraform(struct?: GoogleDialogflowCxPageEntryFulfillmentMessagesTelephonyTransferCallOutputReference | GoogleDialogflowCxPageEntryFulfillmentMessagesTelephonyTransferCall): any;
export declare class GoogleDialogflowCxPageEntryFulfillmentMessagesTelephonyTransferCallOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageEntryFulfillmentMessagesTelephonyTransferCall | undefined;
    set internalValue(value: GoogleDialogflowCxPageEntryFulfillmentMessagesTelephonyTransferCall | undefined);
    private _phoneNumber?;
    get phoneNumber(): string;
    set phoneNumber(value: string);
    get phoneNumberInput(): string | undefined;
}
export interface GoogleDialogflowCxPageEntryFulfillmentMessagesText {
    /**
    * A collection of text responses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#text GoogleDialogflowCxPage#text}
    */
    readonly text?: string[];
}
export declare function googleDialogflowCxPageEntryFulfillmentMessagesTextToTerraform(struct?: GoogleDialogflowCxPageEntryFulfillmentMessagesTextOutputReference | GoogleDialogflowCxPageEntryFulfillmentMessagesText): any;
export declare function googleDialogflowCxPageEntryFulfillmentMessagesTextToHclTerraform(struct?: GoogleDialogflowCxPageEntryFulfillmentMessagesTextOutputReference | GoogleDialogflowCxPageEntryFulfillmentMessagesText): any;
export declare class GoogleDialogflowCxPageEntryFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageEntryFulfillmentMessagesText | undefined;
    set internalValue(value: GoogleDialogflowCxPageEntryFulfillmentMessagesText | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _text?;
    get text(): string[];
    set text(value: string[]);
    resetText(): void;
    get textInput(): string[] | undefined;
}
export interface GoogleDialogflowCxPageEntryFulfillmentMessages {
    /**
    * The channel which the response is associated with. Clients can specify the channel via QueryParameters.channel, and only associated channel response will be returned.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#channel GoogleDialogflowCxPage#channel}
    */
    readonly channel?: string;
    /**
    * A custom, platform-specific payload.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#payload GoogleDialogflowCxPage#payload}
    */
    readonly payload?: string;
    /**
    * conversation_success block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#conversation_success GoogleDialogflowCxPage#conversation_success}
    */
    readonly conversationSuccess?: GoogleDialogflowCxPageEntryFulfillmentMessagesConversationSuccess;
    /**
    * live_agent_handoff block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#live_agent_handoff GoogleDialogflowCxPage#live_agent_handoff}
    */
    readonly liveAgentHandoff?: GoogleDialogflowCxPageEntryFulfillmentMessagesLiveAgentHandoff;
    /**
    * output_audio_text block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#output_audio_text GoogleDialogflowCxPage#output_audio_text}
    */
    readonly outputAudioText?: GoogleDialogflowCxPageEntryFulfillmentMessagesOutputAudioText;
    /**
    * play_audio block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#play_audio GoogleDialogflowCxPage#play_audio}
    */
    readonly playAudio?: GoogleDialogflowCxPageEntryFulfillmentMessagesPlayAudio;
    /**
    * telephony_transfer_call block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#telephony_transfer_call GoogleDialogflowCxPage#telephony_transfer_call}
    */
    readonly telephonyTransferCall?: GoogleDialogflowCxPageEntryFulfillmentMessagesTelephonyTransferCall;
    /**
    * text block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#text GoogleDialogflowCxPage#text}
    */
    readonly text?: GoogleDialogflowCxPageEntryFulfillmentMessagesText;
}
export declare function googleDialogflowCxPageEntryFulfillmentMessagesToTerraform(struct?: GoogleDialogflowCxPageEntryFulfillmentMessages | cdktf.IResolvable): any;
export declare function googleDialogflowCxPageEntryFulfillmentMessagesToHclTerraform(struct?: GoogleDialogflowCxPageEntryFulfillmentMessages | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxPageEntryFulfillmentMessagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxPageEntryFulfillmentMessages | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxPageEntryFulfillmentMessages | cdktf.IResolvable | undefined);
    private _channel?;
    get channel(): string;
    set channel(value: string);
    resetChannel(): void;
    get channelInput(): string | undefined;
    private _payload?;
    get payload(): string;
    set payload(value: string);
    resetPayload(): void;
    get payloadInput(): string | undefined;
    private _conversationSuccess;
    get conversationSuccess(): GoogleDialogflowCxPageEntryFulfillmentMessagesConversationSuccessOutputReference;
    putConversationSuccess(value: GoogleDialogflowCxPageEntryFulfillmentMessagesConversationSuccess): void;
    resetConversationSuccess(): void;
    get conversationSuccessInput(): GoogleDialogflowCxPageEntryFulfillmentMessagesConversationSuccess | undefined;
    private _liveAgentHandoff;
    get liveAgentHandoff(): GoogleDialogflowCxPageEntryFulfillmentMessagesLiveAgentHandoffOutputReference;
    putLiveAgentHandoff(value: GoogleDialogflowCxPageEntryFulfillmentMessagesLiveAgentHandoff): void;
    resetLiveAgentHandoff(): void;
    get liveAgentHandoffInput(): GoogleDialogflowCxPageEntryFulfillmentMessagesLiveAgentHandoff | undefined;
    private _outputAudioText;
    get outputAudioText(): GoogleDialogflowCxPageEntryFulfillmentMessagesOutputAudioTextOutputReference;
    putOutputAudioText(value: GoogleDialogflowCxPageEntryFulfillmentMessagesOutputAudioText): void;
    resetOutputAudioText(): void;
    get outputAudioTextInput(): GoogleDialogflowCxPageEntryFulfillmentMessagesOutputAudioText | undefined;
    private _playAudio;
    get playAudio(): GoogleDialogflowCxPageEntryFulfillmentMessagesPlayAudioOutputReference;
    putPlayAudio(value: GoogleDialogflowCxPageEntryFulfillmentMessagesPlayAudio): void;
    resetPlayAudio(): void;
    get playAudioInput(): GoogleDialogflowCxPageEntryFulfillmentMessagesPlayAudio | undefined;
    private _telephonyTransferCall;
    get telephonyTransferCall(): GoogleDialogflowCxPageEntryFulfillmentMessagesTelephonyTransferCallOutputReference;
    putTelephonyTransferCall(value: GoogleDialogflowCxPageEntryFulfillmentMessagesTelephonyTransferCall): void;
    resetTelephonyTransferCall(): void;
    get telephonyTransferCallInput(): GoogleDialogflowCxPageEntryFulfillmentMessagesTelephonyTransferCall | undefined;
    private _text;
    get text(): GoogleDialogflowCxPageEntryFulfillmentMessagesTextOutputReference;
    putText(value: GoogleDialogflowCxPageEntryFulfillmentMessagesText): void;
    resetText(): void;
    get textInput(): GoogleDialogflowCxPageEntryFulfillmentMessagesText | undefined;
}
export declare class GoogleDialogflowCxPageEntryFulfillmentMessagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxPageEntryFulfillmentMessages[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxPageEntryFulfillmentMessagesOutputReference;
}
export interface GoogleDialogflowCxPageEntryFulfillmentSetParameterActions {
    /**
    * Display name of the parameter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#parameter GoogleDialogflowCxPage#parameter}
    */
    readonly parameter?: string;
    /**
    * The new JSON-encoded value of the parameter. A null value clears the parameter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#value GoogleDialogflowCxPage#value}
    */
    readonly value?: string;
}
export declare function googleDialogflowCxPageEntryFulfillmentSetParameterActionsToTerraform(struct?: GoogleDialogflowCxPageEntryFulfillmentSetParameterActions | cdktf.IResolvable): any;
export declare function googleDialogflowCxPageEntryFulfillmentSetParameterActionsToHclTerraform(struct?: GoogleDialogflowCxPageEntryFulfillmentSetParameterActions | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxPageEntryFulfillmentSetParameterActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxPageEntryFulfillmentSetParameterActions | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxPageEntryFulfillmentSetParameterActions | cdktf.IResolvable | undefined);
    private _parameter?;
    get parameter(): string;
    set parameter(value: string);
    resetParameter(): void;
    get parameterInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class GoogleDialogflowCxPageEntryFulfillmentSetParameterActionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxPageEntryFulfillmentSetParameterActions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxPageEntryFulfillmentSetParameterActionsOutputReference;
}
export interface GoogleDialogflowCxPageEntryFulfillment {
    /**
    * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs. If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#return_partial_responses GoogleDialogflowCxPage#return_partial_responses}
    */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
    * The tag used by the webhook to identify which fulfillment is being called. This field is required if webhook is specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#tag GoogleDialogflowCxPage#tag}
    */
    readonly tag?: string;
    /**
    * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#webhook GoogleDialogflowCxPage#webhook}
    */
    readonly webhook?: string;
    /**
    * conditional_cases block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#conditional_cases GoogleDialogflowCxPage#conditional_cases}
    */
    readonly conditionalCases?: GoogleDialogflowCxPageEntryFulfillmentConditionalCases[] | cdktf.IResolvable;
    /**
    * messages block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#messages GoogleDialogflowCxPage#messages}
    */
    readonly messages?: GoogleDialogflowCxPageEntryFulfillmentMessages[] | cdktf.IResolvable;
    /**
    * set_parameter_actions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#set_parameter_actions GoogleDialogflowCxPage#set_parameter_actions}
    */
    readonly setParameterActions?: GoogleDialogflowCxPageEntryFulfillmentSetParameterActions[] | cdktf.IResolvable;
}
export declare function googleDialogflowCxPageEntryFulfillmentToTerraform(struct?: GoogleDialogflowCxPageEntryFulfillmentOutputReference | GoogleDialogflowCxPageEntryFulfillment): any;
export declare function googleDialogflowCxPageEntryFulfillmentToHclTerraform(struct?: GoogleDialogflowCxPageEntryFulfillmentOutputReference | GoogleDialogflowCxPageEntryFulfillment): any;
export declare class GoogleDialogflowCxPageEntryFulfillmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageEntryFulfillment | undefined;
    set internalValue(value: GoogleDialogflowCxPageEntryFulfillment | undefined);
    private _returnPartialResponses?;
    get returnPartialResponses(): boolean | cdktf.IResolvable;
    set returnPartialResponses(value: boolean | cdktf.IResolvable);
    resetReturnPartialResponses(): void;
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _webhook?;
    get webhook(): string;
    set webhook(value: string);
    resetWebhook(): void;
    get webhookInput(): string | undefined;
    private _conditionalCases;
    get conditionalCases(): GoogleDialogflowCxPageEntryFulfillmentConditionalCasesList;
    putConditionalCases(value: GoogleDialogflowCxPageEntryFulfillmentConditionalCases[] | cdktf.IResolvable): void;
    resetConditionalCases(): void;
    get conditionalCasesInput(): cdktf.IResolvable | GoogleDialogflowCxPageEntryFulfillmentConditionalCases[] | undefined;
    private _messages;
    get messages(): GoogleDialogflowCxPageEntryFulfillmentMessagesList;
    putMessages(value: GoogleDialogflowCxPageEntryFulfillmentMessages[] | cdktf.IResolvable): void;
    resetMessages(): void;
    get messagesInput(): cdktf.IResolvable | GoogleDialogflowCxPageEntryFulfillmentMessages[] | undefined;
    private _setParameterActions;
    get setParameterActions(): GoogleDialogflowCxPageEntryFulfillmentSetParameterActionsList;
    putSetParameterActions(value: GoogleDialogflowCxPageEntryFulfillmentSetParameterActions[] | cdktf.IResolvable): void;
    resetSetParameterActions(): void;
    get setParameterActionsInput(): cdktf.IResolvable | GoogleDialogflowCxPageEntryFulfillmentSetParameterActions[] | undefined;
}
export interface GoogleDialogflowCxPageEventHandlersTriggerFulfillmentConditionalCases {
    /**
    * A JSON encoded list of cascading if-else conditions. Cases are mutually exclusive. The first one with a matching condition is selected, all the rest ignored.
    * See [Case](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/Fulfillment#case) for the schema.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#cases GoogleDialogflowCxPage#cases}
    */
    readonly cases?: string;
}
export declare function googleDialogflowCxPageEventHandlersTriggerFulfillmentConditionalCasesToTerraform(struct?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentConditionalCases | cdktf.IResolvable): any;
export declare function googleDialogflowCxPageEventHandlersTriggerFulfillmentConditionalCasesToHclTerraform(struct?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentConditionalCases | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxPageEventHandlersTriggerFulfillmentConditionalCasesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentConditionalCases | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentConditionalCases | cdktf.IResolvable | undefined);
    private _cases?;
    get cases(): string;
    set cases(value: string);
    resetCases(): void;
    get casesInput(): string | undefined;
}
export declare class GoogleDialogflowCxPageEventHandlersTriggerFulfillmentConditionalCasesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentConditionalCases[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentConditionalCasesOutputReference;
}
export interface GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesConversationSuccess {
    /**
    * Custom metadata. Dialogflow doesn't impose any structure on this.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#metadata GoogleDialogflowCxPage#metadata}
    */
    readonly metadata?: string;
}
export declare function googleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesConversationSuccessToTerraform(struct?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesConversationSuccessOutputReference | GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesConversationSuccess): any;
export declare function googleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesConversationSuccessToHclTerraform(struct?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesConversationSuccessOutputReference | GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesConversationSuccess): any;
export declare class GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesConversationSuccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesConversationSuccess | undefined;
    set internalValue(value: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesConversationSuccess | undefined);
    private _metadata?;
    get metadata(): string;
    set metadata(value: string);
    resetMetadata(): void;
    get metadataInput(): string | undefined;
}
export interface GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesLiveAgentHandoff {
    /**
    * Custom metadata. Dialogflow doesn't impose any structure on this.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#metadata GoogleDialogflowCxPage#metadata}
    */
    readonly metadata?: string;
}
export declare function googleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesLiveAgentHandoffToTerraform(struct?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesLiveAgentHandoffOutputReference | GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesLiveAgentHandoff): any;
export declare function googleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesLiveAgentHandoffToHclTerraform(struct?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesLiveAgentHandoffOutputReference | GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesLiveAgentHandoff): any;
export declare class GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesLiveAgentHandoffOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesLiveAgentHandoff | undefined;
    set internalValue(value: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesLiveAgentHandoff | undefined);
    private _metadata?;
    get metadata(): string;
    set metadata(value: string);
    resetMetadata(): void;
    get metadataInput(): string | undefined;
}
export interface GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesOutputAudioText {
    /**
    * The SSML text to be synthesized. For more information, see SSML.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#ssml GoogleDialogflowCxPage#ssml}
    */
    readonly ssml?: string;
    /**
    * The raw text to be synthesized.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#text GoogleDialogflowCxPage#text}
    */
    readonly text?: string;
}
export declare function googleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesOutputAudioTextToTerraform(struct?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesOutputAudioTextOutputReference | GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesOutputAudioText): any;
export declare function googleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesOutputAudioTextToHclTerraform(struct?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesOutputAudioTextOutputReference | GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesOutputAudioText): any;
export declare class GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesOutputAudioTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesOutputAudioText | undefined;
    set internalValue(value: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesOutputAudioText | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _ssml?;
    get ssml(): string;
    set ssml(value: string);
    resetSsml(): void;
    get ssmlInput(): string | undefined;
    private _text?;
    get text(): string;
    set text(value: string);
    resetText(): void;
    get textInput(): string | undefined;
}
export interface GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesPlayAudio {
    /**
    * URI of the audio clip. Dialogflow does not impose any validation on this value. It is specific to the client that reads it.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#audio_uri GoogleDialogflowCxPage#audio_uri}
    */
    readonly audioUri: string;
}
export declare function googleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesPlayAudioToTerraform(struct?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesPlayAudioOutputReference | GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesPlayAudio): any;
export declare function googleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesPlayAudioToHclTerraform(struct?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesPlayAudioOutputReference | GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesPlayAudio): any;
export declare class GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesPlayAudioOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesPlayAudio | undefined;
    set internalValue(value: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesPlayAudio | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _audioUri?;
    get audioUri(): string;
    set audioUri(value: string);
    get audioUriInput(): string | undefined;
}
export interface GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesTelephonyTransferCall {
    /**
    * Transfer the call to a phone number in E.164 format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#phone_number GoogleDialogflowCxPage#phone_number}
    */
    readonly phoneNumber: string;
}
export declare function googleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesTelephonyTransferCallToTerraform(struct?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesTelephonyTransferCallOutputReference | GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesTelephonyTransferCall): any;
export declare function googleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesTelephonyTransferCallToHclTerraform(struct?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesTelephonyTransferCallOutputReference | GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesTelephonyTransferCall): any;
export declare class GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesTelephonyTransferCallOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesTelephonyTransferCall | undefined;
    set internalValue(value: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesTelephonyTransferCall | undefined);
    private _phoneNumber?;
    get phoneNumber(): string;
    set phoneNumber(value: string);
    get phoneNumberInput(): string | undefined;
}
export interface GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesText {
    /**
    * A collection of text responses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#text GoogleDialogflowCxPage#text}
    */
    readonly text?: string[];
}
export declare function googleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesTextToTerraform(struct?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesTextOutputReference | GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesText): any;
export declare function googleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesTextToHclTerraform(struct?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesTextOutputReference | GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesText): any;
export declare class GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesText | undefined;
    set internalValue(value: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesText | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _text?;
    get text(): string[];
    set text(value: string[]);
    resetText(): void;
    get textInput(): string[] | undefined;
}
export interface GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessages {
    /**
    * The channel which the response is associated with. Clients can specify the channel via QueryParameters.channel, and only associated channel response will be returned.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#channel GoogleDialogflowCxPage#channel}
    */
    readonly channel?: string;
    /**
    * A custom, platform-specific payload.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#payload GoogleDialogflowCxPage#payload}
    */
    readonly payload?: string;
    /**
    * conversation_success block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#conversation_success GoogleDialogflowCxPage#conversation_success}
    */
    readonly conversationSuccess?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesConversationSuccess;
    /**
    * live_agent_handoff block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#live_agent_handoff GoogleDialogflowCxPage#live_agent_handoff}
    */
    readonly liveAgentHandoff?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesLiveAgentHandoff;
    /**
    * output_audio_text block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#output_audio_text GoogleDialogflowCxPage#output_audio_text}
    */
    readonly outputAudioText?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesOutputAudioText;
    /**
    * play_audio block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#play_audio GoogleDialogflowCxPage#play_audio}
    */
    readonly playAudio?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesPlayAudio;
    /**
    * telephony_transfer_call block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#telephony_transfer_call GoogleDialogflowCxPage#telephony_transfer_call}
    */
    readonly telephonyTransferCall?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesTelephonyTransferCall;
    /**
    * text block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#text GoogleDialogflowCxPage#text}
    */
    readonly text?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesText;
}
export declare function googleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesToTerraform(struct?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessages | cdktf.IResolvable): any;
export declare function googleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesToHclTerraform(struct?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessages | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessages | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessages | cdktf.IResolvable | undefined);
    private _channel?;
    get channel(): string;
    set channel(value: string);
    resetChannel(): void;
    get channelInput(): string | undefined;
    private _payload?;
    get payload(): string;
    set payload(value: string);
    resetPayload(): void;
    get payloadInput(): string | undefined;
    private _conversationSuccess;
    get conversationSuccess(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesConversationSuccessOutputReference;
    putConversationSuccess(value: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesConversationSuccess): void;
    resetConversationSuccess(): void;
    get conversationSuccessInput(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesConversationSuccess | undefined;
    private _liveAgentHandoff;
    get liveAgentHandoff(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesLiveAgentHandoffOutputReference;
    putLiveAgentHandoff(value: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesLiveAgentHandoff): void;
    resetLiveAgentHandoff(): void;
    get liveAgentHandoffInput(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesLiveAgentHandoff | undefined;
    private _outputAudioText;
    get outputAudioText(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesOutputAudioTextOutputReference;
    putOutputAudioText(value: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesOutputAudioText): void;
    resetOutputAudioText(): void;
    get outputAudioTextInput(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesOutputAudioText | undefined;
    private _playAudio;
    get playAudio(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesPlayAudioOutputReference;
    putPlayAudio(value: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesPlayAudio): void;
    resetPlayAudio(): void;
    get playAudioInput(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesPlayAudio | undefined;
    private _telephonyTransferCall;
    get telephonyTransferCall(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesTelephonyTransferCallOutputReference;
    putTelephonyTransferCall(value: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesTelephonyTransferCall): void;
    resetTelephonyTransferCall(): void;
    get telephonyTransferCallInput(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesTelephonyTransferCall | undefined;
    private _text;
    get text(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesTextOutputReference;
    putText(value: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesText): void;
    resetText(): void;
    get textInput(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesText | undefined;
}
export declare class GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessages[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesOutputReference;
}
export interface GoogleDialogflowCxPageEventHandlersTriggerFulfillmentSetParameterActions {
    /**
    * Display name of the parameter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#parameter GoogleDialogflowCxPage#parameter}
    */
    readonly parameter?: string;
    /**
    * The new JSON-encoded value of the parameter. A null value clears the parameter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#value GoogleDialogflowCxPage#value}
    */
    readonly value?: string;
}
export declare function googleDialogflowCxPageEventHandlersTriggerFulfillmentSetParameterActionsToTerraform(struct?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentSetParameterActions | cdktf.IResolvable): any;
export declare function googleDialogflowCxPageEventHandlersTriggerFulfillmentSetParameterActionsToHclTerraform(struct?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentSetParameterActions | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxPageEventHandlersTriggerFulfillmentSetParameterActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentSetParameterActions | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentSetParameterActions | cdktf.IResolvable | undefined);
    private _parameter?;
    get parameter(): string;
    set parameter(value: string);
    resetParameter(): void;
    get parameterInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class GoogleDialogflowCxPageEventHandlersTriggerFulfillmentSetParameterActionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentSetParameterActions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentSetParameterActionsOutputReference;
}
export interface GoogleDialogflowCxPageEventHandlersTriggerFulfillment {
    /**
    * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs. If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#return_partial_responses GoogleDialogflowCxPage#return_partial_responses}
    */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
    * The tag used by the webhook to identify which fulfillment is being called. This field is required if webhook is specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#tag GoogleDialogflowCxPage#tag}
    */
    readonly tag?: string;
    /**
    * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#webhook GoogleDialogflowCxPage#webhook}
    */
    readonly webhook?: string;
    /**
    * conditional_cases block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#conditional_cases GoogleDialogflowCxPage#conditional_cases}
    */
    readonly conditionalCases?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentConditionalCases[] | cdktf.IResolvable;
    /**
    * messages block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#messages GoogleDialogflowCxPage#messages}
    */
    readonly messages?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessages[] | cdktf.IResolvable;
    /**
    * set_parameter_actions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#set_parameter_actions GoogleDialogflowCxPage#set_parameter_actions}
    */
    readonly setParameterActions?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentSetParameterActions[] | cdktf.IResolvable;
}
export declare function googleDialogflowCxPageEventHandlersTriggerFulfillmentToTerraform(struct?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentOutputReference | GoogleDialogflowCxPageEventHandlersTriggerFulfillment): any;
export declare function googleDialogflowCxPageEventHandlersTriggerFulfillmentToHclTerraform(struct?: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentOutputReference | GoogleDialogflowCxPageEventHandlersTriggerFulfillment): any;
export declare class GoogleDialogflowCxPageEventHandlersTriggerFulfillmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageEventHandlersTriggerFulfillment | undefined;
    set internalValue(value: GoogleDialogflowCxPageEventHandlersTriggerFulfillment | undefined);
    private _returnPartialResponses?;
    get returnPartialResponses(): boolean | cdktf.IResolvable;
    set returnPartialResponses(value: boolean | cdktf.IResolvable);
    resetReturnPartialResponses(): void;
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _webhook?;
    get webhook(): string;
    set webhook(value: string);
    resetWebhook(): void;
    get webhookInput(): string | undefined;
    private _conditionalCases;
    get conditionalCases(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentConditionalCasesList;
    putConditionalCases(value: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentConditionalCases[] | cdktf.IResolvable): void;
    resetConditionalCases(): void;
    get conditionalCasesInput(): cdktf.IResolvable | GoogleDialogflowCxPageEventHandlersTriggerFulfillmentConditionalCases[] | undefined;
    private _messages;
    get messages(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessagesList;
    putMessages(value: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessages[] | cdktf.IResolvable): void;
    resetMessages(): void;
    get messagesInput(): cdktf.IResolvable | GoogleDialogflowCxPageEventHandlersTriggerFulfillmentMessages[] | undefined;
    private _setParameterActions;
    get setParameterActions(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentSetParameterActionsList;
    putSetParameterActions(value: GoogleDialogflowCxPageEventHandlersTriggerFulfillmentSetParameterActions[] | cdktf.IResolvable): void;
    resetSetParameterActions(): void;
    get setParameterActionsInput(): cdktf.IResolvable | GoogleDialogflowCxPageEventHandlersTriggerFulfillmentSetParameterActions[] | undefined;
}
export interface GoogleDialogflowCxPageEventHandlers {
    /**
    * The name of the event to handle.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#event GoogleDialogflowCxPage#event}
    */
    readonly event?: string;
    /**
    * The target flow to transition to.
    * Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#target_flow GoogleDialogflowCxPage#target_flow}
    */
    readonly targetFlow?: string;
    /**
    * The target page to transition to.
    * Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#target_page GoogleDialogflowCxPage#target_page}
    */
    readonly targetPage?: string;
    /**
    * trigger_fulfillment block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#trigger_fulfillment GoogleDialogflowCxPage#trigger_fulfillment}
    */
    readonly triggerFulfillment?: GoogleDialogflowCxPageEventHandlersTriggerFulfillment;
}
export declare function googleDialogflowCxPageEventHandlersToTerraform(struct?: GoogleDialogflowCxPageEventHandlers | cdktf.IResolvable): any;
export declare function googleDialogflowCxPageEventHandlersToHclTerraform(struct?: GoogleDialogflowCxPageEventHandlers | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxPageEventHandlersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxPageEventHandlers | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxPageEventHandlers | cdktf.IResolvable | undefined);
    private _event?;
    get event(): string;
    set event(value: string);
    resetEvent(): void;
    get eventInput(): string | undefined;
    get name(): string;
    private _targetFlow?;
    get targetFlow(): string;
    set targetFlow(value: string);
    resetTargetFlow(): void;
    get targetFlowInput(): string | undefined;
    private _targetPage?;
    get targetPage(): string;
    set targetPage(value: string);
    resetTargetPage(): void;
    get targetPageInput(): string | undefined;
    private _triggerFulfillment;
    get triggerFulfillment(): GoogleDialogflowCxPageEventHandlersTriggerFulfillmentOutputReference;
    putTriggerFulfillment(value: GoogleDialogflowCxPageEventHandlersTriggerFulfillment): void;
    resetTriggerFulfillment(): void;
    get triggerFulfillmentInput(): GoogleDialogflowCxPageEventHandlersTriggerFulfillment | undefined;
}
export declare class GoogleDialogflowCxPageEventHandlersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxPageEventHandlers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxPageEventHandlersOutputReference;
}
export interface GoogleDialogflowCxPageFormParametersAdvancedSettingsDtmfSettings {
    /**
    * If true, incoming audio is processed for DTMF (dual tone multi frequency) events. For example, if the caller presses a button on their telephone keypad and DTMF processing is enabled, Dialogflow will detect the event (e.g. a "3" was pressed) in the incoming audio and pass the event to the bot to drive business logic (e.g. when 3 is pressed, return the account balance).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#enabled GoogleDialogflowCxPage#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The digit that terminates a DTMF digit sequence.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#finish_digit GoogleDialogflowCxPage#finish_digit}
    */
    readonly finishDigit?: string;
    /**
    * Max length of DTMF digits.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#max_digits GoogleDialogflowCxPage#max_digits}
    */
    readonly maxDigits?: number;
}
export declare function googleDialogflowCxPageFormParametersAdvancedSettingsDtmfSettingsToTerraform(struct?: GoogleDialogflowCxPageFormParametersAdvancedSettingsDtmfSettingsOutputReference | GoogleDialogflowCxPageFormParametersAdvancedSettingsDtmfSettings): any;
export declare function googleDialogflowCxPageFormParametersAdvancedSettingsDtmfSettingsToHclTerraform(struct?: GoogleDialogflowCxPageFormParametersAdvancedSettingsDtmfSettingsOutputReference | GoogleDialogflowCxPageFormParametersAdvancedSettingsDtmfSettings): any;
export declare class GoogleDialogflowCxPageFormParametersAdvancedSettingsDtmfSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageFormParametersAdvancedSettingsDtmfSettings | undefined;
    set internalValue(value: GoogleDialogflowCxPageFormParametersAdvancedSettingsDtmfSettings | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _finishDigit?;
    get finishDigit(): string;
    set finishDigit(value: string);
    resetFinishDigit(): void;
    get finishDigitInput(): string | undefined;
    private _maxDigits?;
    get maxDigits(): number;
    set maxDigits(value: number);
    resetMaxDigits(): void;
    get maxDigitsInput(): number | undefined;
}
export interface GoogleDialogflowCxPageFormParametersAdvancedSettings {
    /**
    * dtmf_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#dtmf_settings GoogleDialogflowCxPage#dtmf_settings}
    */
    readonly dtmfSettings?: GoogleDialogflowCxPageFormParametersAdvancedSettingsDtmfSettings;
}
export declare function googleDialogflowCxPageFormParametersAdvancedSettingsToTerraform(struct?: GoogleDialogflowCxPageFormParametersAdvancedSettingsOutputReference | GoogleDialogflowCxPageFormParametersAdvancedSettings): any;
export declare function googleDialogflowCxPageFormParametersAdvancedSettingsToHclTerraform(struct?: GoogleDialogflowCxPageFormParametersAdvancedSettingsOutputReference | GoogleDialogflowCxPageFormParametersAdvancedSettings): any;
export declare class GoogleDialogflowCxPageFormParametersAdvancedSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageFormParametersAdvancedSettings | undefined;
    set internalValue(value: GoogleDialogflowCxPageFormParametersAdvancedSettings | undefined);
    private _dtmfSettings;
    get dtmfSettings(): GoogleDialogflowCxPageFormParametersAdvancedSettingsDtmfSettingsOutputReference;
    putDtmfSettings(value: GoogleDialogflowCxPageFormParametersAdvancedSettingsDtmfSettings): void;
    resetDtmfSettings(): void;
    get dtmfSettingsInput(): GoogleDialogflowCxPageFormParametersAdvancedSettingsDtmfSettings | undefined;
}
export interface GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentConditionalCases {
    /**
    * A JSON encoded list of cascading if-else conditions. Cases are mutually exclusive. The first one with a matching condition is selected, all the rest ignored.
    * See [Case](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/Fulfillment#case) for the schema.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#cases GoogleDialogflowCxPage#cases}
    */
    readonly cases?: string;
}
export declare function googleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentConditionalCasesToTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentConditionalCases | cdktf.IResolvable): any;
export declare function googleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentConditionalCasesToHclTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentConditionalCases | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentConditionalCasesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentConditionalCases | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentConditionalCases | cdktf.IResolvable | undefined);
    private _cases?;
    get cases(): string;
    set cases(value: string);
    resetCases(): void;
    get casesInput(): string | undefined;
}
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentConditionalCasesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentConditionalCases[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentConditionalCasesOutputReference;
}
export interface GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesConversationSuccess {
    /**
    * Custom metadata. Dialogflow doesn't impose any structure on this.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#metadata GoogleDialogflowCxPage#metadata}
    */
    readonly metadata?: string;
}
export declare function googleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesConversationSuccessToTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesConversationSuccessOutputReference | GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesConversationSuccess): any;
export declare function googleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesConversationSuccessToHclTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesConversationSuccessOutputReference | GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesConversationSuccess): any;
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesConversationSuccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesConversationSuccess | undefined;
    set internalValue(value: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesConversationSuccess | undefined);
    private _metadata?;
    get metadata(): string;
    set metadata(value: string);
    resetMetadata(): void;
    get metadataInput(): string | undefined;
}
export interface GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesLiveAgentHandoff {
    /**
    * Custom metadata. Dialogflow doesn't impose any structure on this.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#metadata GoogleDialogflowCxPage#metadata}
    */
    readonly metadata?: string;
}
export declare function googleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesLiveAgentHandoffToTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesLiveAgentHandoffOutputReference | GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesLiveAgentHandoff): any;
export declare function googleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesLiveAgentHandoffToHclTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesLiveAgentHandoffOutputReference | GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesLiveAgentHandoff): any;
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesLiveAgentHandoffOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesLiveAgentHandoff | undefined;
    set internalValue(value: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesLiveAgentHandoff | undefined);
    private _metadata?;
    get metadata(): string;
    set metadata(value: string);
    resetMetadata(): void;
    get metadataInput(): string | undefined;
}
export interface GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesOutputAudioText {
    /**
    * The SSML text to be synthesized. For more information, see SSML.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#ssml GoogleDialogflowCxPage#ssml}
    */
    readonly ssml?: string;
    /**
    * The raw text to be synthesized.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#text GoogleDialogflowCxPage#text}
    */
    readonly text?: string;
}
export declare function googleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesOutputAudioTextToTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesOutputAudioTextOutputReference | GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesOutputAudioText): any;
export declare function googleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesOutputAudioTextToHclTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesOutputAudioTextOutputReference | GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesOutputAudioText): any;
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesOutputAudioTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesOutputAudioText | undefined;
    set internalValue(value: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesOutputAudioText | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _ssml?;
    get ssml(): string;
    set ssml(value: string);
    resetSsml(): void;
    get ssmlInput(): string | undefined;
    private _text?;
    get text(): string;
    set text(value: string);
    resetText(): void;
    get textInput(): string | undefined;
}
export interface GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesPlayAudio {
    /**
    * URI of the audio clip. Dialogflow does not impose any validation on this value. It is specific to the client that reads it.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#audio_uri GoogleDialogflowCxPage#audio_uri}
    */
    readonly audioUri: string;
}
export declare function googleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesPlayAudioToTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesPlayAudioOutputReference | GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesPlayAudio): any;
export declare function googleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesPlayAudioToHclTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesPlayAudioOutputReference | GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesPlayAudio): any;
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesPlayAudioOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesPlayAudio | undefined;
    set internalValue(value: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesPlayAudio | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _audioUri?;
    get audioUri(): string;
    set audioUri(value: string);
    get audioUriInput(): string | undefined;
}
export interface GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTelephonyTransferCall {
    /**
    * Transfer the call to a phone number in E.164 format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#phone_number GoogleDialogflowCxPage#phone_number}
    */
    readonly phoneNumber: string;
}
export declare function googleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTelephonyTransferCallToTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTelephonyTransferCallOutputReference | GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTelephonyTransferCall): any;
export declare function googleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTelephonyTransferCallToHclTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTelephonyTransferCallOutputReference | GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTelephonyTransferCall): any;
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTelephonyTransferCallOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTelephonyTransferCall | undefined;
    set internalValue(value: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTelephonyTransferCall | undefined);
    private _phoneNumber?;
    get phoneNumber(): string;
    set phoneNumber(value: string);
    get phoneNumberInput(): string | undefined;
}
export interface GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText {
    /**
    * A collection of text responses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#text GoogleDialogflowCxPage#text}
    */
    readonly text?: string[];
}
export declare function googleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTextToTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTextOutputReference | GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText): any;
export declare function googleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTextToHclTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTextOutputReference | GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText): any;
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText | undefined;
    set internalValue(value: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _text?;
    get text(): string[];
    set text(value: string[]);
    resetText(): void;
    get textInput(): string[] | undefined;
}
export interface GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages {
    /**
    * The channel which the response is associated with. Clients can specify the channel via QueryParameters.channel, and only associated channel response will be returned.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#channel GoogleDialogflowCxPage#channel}
    */
    readonly channel?: string;
    /**
    * A custom, platform-specific payload.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#payload GoogleDialogflowCxPage#payload}
    */
    readonly payload?: string;
    /**
    * conversation_success block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#conversation_success GoogleDialogflowCxPage#conversation_success}
    */
    readonly conversationSuccess?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesConversationSuccess;
    /**
    * live_agent_handoff block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#live_agent_handoff GoogleDialogflowCxPage#live_agent_handoff}
    */
    readonly liveAgentHandoff?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesLiveAgentHandoff;
    /**
    * output_audio_text block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#output_audio_text GoogleDialogflowCxPage#output_audio_text}
    */
    readonly outputAudioText?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesOutputAudioText;
    /**
    * play_audio block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#play_audio GoogleDialogflowCxPage#play_audio}
    */
    readonly playAudio?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesPlayAudio;
    /**
    * telephony_transfer_call block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#telephony_transfer_call GoogleDialogflowCxPage#telephony_transfer_call}
    */
    readonly telephonyTransferCall?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTelephonyTransferCall;
    /**
    * text block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#text GoogleDialogflowCxPage#text}
    */
    readonly text?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText;
}
export declare function googleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesToTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages | cdktf.IResolvable): any;
export declare function googleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesToHclTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages | cdktf.IResolvable | undefined);
    private _channel?;
    get channel(): string;
    set channel(value: string);
    resetChannel(): void;
    get channelInput(): string | undefined;
    private _payload?;
    get payload(): string;
    set payload(value: string);
    resetPayload(): void;
    get payloadInput(): string | undefined;
    private _conversationSuccess;
    get conversationSuccess(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesConversationSuccessOutputReference;
    putConversationSuccess(value: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesConversationSuccess): void;
    resetConversationSuccess(): void;
    get conversationSuccessInput(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesConversationSuccess | undefined;
    private _liveAgentHandoff;
    get liveAgentHandoff(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesLiveAgentHandoffOutputReference;
    putLiveAgentHandoff(value: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesLiveAgentHandoff): void;
    resetLiveAgentHandoff(): void;
    get liveAgentHandoffInput(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesLiveAgentHandoff | undefined;
    private _outputAudioText;
    get outputAudioText(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesOutputAudioTextOutputReference;
    putOutputAudioText(value: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesOutputAudioText): void;
    resetOutputAudioText(): void;
    get outputAudioTextInput(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesOutputAudioText | undefined;
    private _playAudio;
    get playAudio(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesPlayAudioOutputReference;
    putPlayAudio(value: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesPlayAudio): void;
    resetPlayAudio(): void;
    get playAudioInput(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesPlayAudio | undefined;
    private _telephonyTransferCall;
    get telephonyTransferCall(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTelephonyTransferCallOutputReference;
    putTelephonyTransferCall(value: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTelephonyTransferCall): void;
    resetTelephonyTransferCall(): void;
    get telephonyTransferCallInput(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTelephonyTransferCall | undefined;
    private _text;
    get text(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTextOutputReference;
    putText(value: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText): void;
    resetText(): void;
    get textInput(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText | undefined;
}
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesOutputReference;
}
export interface GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentSetParameterActions {
    /**
    * Display name of the parameter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#parameter GoogleDialogflowCxPage#parameter}
    */
    readonly parameter?: string;
    /**
    * The new JSON-encoded value of the parameter. A null value clears the parameter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#value GoogleDialogflowCxPage#value}
    */
    readonly value?: string;
}
export declare function googleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentSetParameterActionsToTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentSetParameterActions | cdktf.IResolvable): any;
export declare function googleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentSetParameterActionsToHclTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentSetParameterActions | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentSetParameterActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentSetParameterActions | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentSetParameterActions | cdktf.IResolvable | undefined);
    private _parameter?;
    get parameter(): string;
    set parameter(value: string);
    resetParameter(): void;
    get parameterInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentSetParameterActionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentSetParameterActions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentSetParameterActionsOutputReference;
}
export interface GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment {
    /**
    * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs. If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#return_partial_responses GoogleDialogflowCxPage#return_partial_responses}
    */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
    * The tag used by the webhook to identify which fulfillment is being called. This field is required if webhook is specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#tag GoogleDialogflowCxPage#tag}
    */
    readonly tag?: string;
    /**
    * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#webhook GoogleDialogflowCxPage#webhook}
    */
    readonly webhook?: string;
    /**
    * conditional_cases block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#conditional_cases GoogleDialogflowCxPage#conditional_cases}
    */
    readonly conditionalCases?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentConditionalCases[] | cdktf.IResolvable;
    /**
    * messages block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#messages GoogleDialogflowCxPage#messages}
    */
    readonly messages?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages[] | cdktf.IResolvable;
    /**
    * set_parameter_actions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#set_parameter_actions GoogleDialogflowCxPage#set_parameter_actions}
    */
    readonly setParameterActions?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentSetParameterActions[] | cdktf.IResolvable;
}
export declare function googleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentToTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentOutputReference | GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment): any;
export declare function googleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentToHclTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentOutputReference | GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment): any;
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment | undefined;
    set internalValue(value: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment | undefined);
    private _returnPartialResponses?;
    get returnPartialResponses(): boolean | cdktf.IResolvable;
    set returnPartialResponses(value: boolean | cdktf.IResolvable);
    resetReturnPartialResponses(): void;
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _webhook?;
    get webhook(): string;
    set webhook(value: string);
    resetWebhook(): void;
    get webhookInput(): string | undefined;
    private _conditionalCases;
    get conditionalCases(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentConditionalCasesList;
    putConditionalCases(value: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentConditionalCases[] | cdktf.IResolvable): void;
    resetConditionalCases(): void;
    get conditionalCasesInput(): cdktf.IResolvable | GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentConditionalCases[] | undefined;
    private _messages;
    get messages(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesList;
    putMessages(value: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages[] | cdktf.IResolvable): void;
    resetMessages(): void;
    get messagesInput(): cdktf.IResolvable | GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages[] | undefined;
    private _setParameterActions;
    get setParameterActions(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentSetParameterActionsList;
    putSetParameterActions(value: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentSetParameterActions[] | cdktf.IResolvable): void;
    resetSetParameterActions(): void;
    get setParameterActionsInput(): cdktf.IResolvable | GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentSetParameterActions[] | undefined;
}
export interface GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentConditionalCases {
    /**
    * A JSON encoded list of cascading if-else conditions. Cases are mutually exclusive. The first one with a matching condition is selected, all the rest ignored.
    * See [Case](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/Fulfillment#case) for the schema.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#cases GoogleDialogflowCxPage#cases}
    */
    readonly cases?: string;
}
export declare function googleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentConditionalCasesToTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentConditionalCases | cdktf.IResolvable): any;
export declare function googleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentConditionalCasesToHclTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentConditionalCases | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentConditionalCasesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentConditionalCases | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentConditionalCases | cdktf.IResolvable | undefined);
    private _cases?;
    get cases(): string;
    set cases(value: string);
    resetCases(): void;
    get casesInput(): string | undefined;
}
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentConditionalCasesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentConditionalCases[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentConditionalCasesOutputReference;
}
export interface GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesConversationSuccess {
    /**
    * Custom metadata. Dialogflow doesn't impose any structure on this.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#metadata GoogleDialogflowCxPage#metadata}
    */
    readonly metadata?: string;
}
export declare function googleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesConversationSuccessToTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesConversationSuccessOutputReference | GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesConversationSuccess): any;
export declare function googleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesConversationSuccessToHclTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesConversationSuccessOutputReference | GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesConversationSuccess): any;
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesConversationSuccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesConversationSuccess | undefined;
    set internalValue(value: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesConversationSuccess | undefined);
    private _metadata?;
    get metadata(): string;
    set metadata(value: string);
    resetMetadata(): void;
    get metadataInput(): string | undefined;
}
export interface GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesLiveAgentHandoff {
    /**
    * Custom metadata. Dialogflow doesn't impose any structure on this.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#metadata GoogleDialogflowCxPage#metadata}
    */
    readonly metadata?: string;
}
export declare function googleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesLiveAgentHandoffToTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesLiveAgentHandoffOutputReference | GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesLiveAgentHandoff): any;
export declare function googleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesLiveAgentHandoffToHclTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesLiveAgentHandoffOutputReference | GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesLiveAgentHandoff): any;
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesLiveAgentHandoffOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesLiveAgentHandoff | undefined;
    set internalValue(value: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesLiveAgentHandoff | undefined);
    private _metadata?;
    get metadata(): string;
    set metadata(value: string);
    resetMetadata(): void;
    get metadataInput(): string | undefined;
}
export interface GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesOutputAudioText {
    /**
    * The SSML text to be synthesized. For more information, see SSML.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#ssml GoogleDialogflowCxPage#ssml}
    */
    readonly ssml?: string;
    /**
    * The raw text to be synthesized.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#text GoogleDialogflowCxPage#text}
    */
    readonly text?: string;
}
export declare function googleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesOutputAudioTextToTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesOutputAudioTextOutputReference | GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesOutputAudioText): any;
export declare function googleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesOutputAudioTextToHclTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesOutputAudioTextOutputReference | GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesOutputAudioText): any;
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesOutputAudioTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesOutputAudioText | undefined;
    set internalValue(value: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesOutputAudioText | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _ssml?;
    get ssml(): string;
    set ssml(value: string);
    resetSsml(): void;
    get ssmlInput(): string | undefined;
    private _text?;
    get text(): string;
    set text(value: string);
    resetText(): void;
    get textInput(): string | undefined;
}
export interface GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesPlayAudio {
    /**
    * URI of the audio clip. Dialogflow does not impose any validation on this value. It is specific to the client that reads it.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#audio_uri GoogleDialogflowCxPage#audio_uri}
    */
    readonly audioUri: string;
}
export declare function googleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesPlayAudioToTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesPlayAudioOutputReference | GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesPlayAudio): any;
export declare function googleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesPlayAudioToHclTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesPlayAudioOutputReference | GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesPlayAudio): any;
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesPlayAudioOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesPlayAudio | undefined;
    set internalValue(value: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesPlayAudio | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _audioUri?;
    get audioUri(): string;
    set audioUri(value: string);
    get audioUriInput(): string | undefined;
}
export interface GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesTelephonyTransferCall {
    /**
    * Transfer the call to a phone number in E.164 format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#phone_number GoogleDialogflowCxPage#phone_number}
    */
    readonly phoneNumber: string;
}
export declare function googleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesTelephonyTransferCallToTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesTelephonyTransferCallOutputReference | GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesTelephonyTransferCall): any;
export declare function googleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesTelephonyTransferCallToHclTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesTelephonyTransferCallOutputReference | GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesTelephonyTransferCall): any;
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesTelephonyTransferCallOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesTelephonyTransferCall | undefined;
    set internalValue(value: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesTelephonyTransferCall | undefined);
    private _phoneNumber?;
    get phoneNumber(): string;
    set phoneNumber(value: string);
    get phoneNumberInput(): string | undefined;
}
export interface GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesText {
    /**
    * A collection of text responses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#text GoogleDialogflowCxPage#text}
    */
    readonly text?: string[];
}
export declare function googleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesTextToTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesTextOutputReference | GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesText): any;
export declare function googleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesTextToHclTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesTextOutputReference | GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesText): any;
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesText | undefined;
    set internalValue(value: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesText | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _text?;
    get text(): string[];
    set text(value: string[]);
    resetText(): void;
    get textInput(): string[] | undefined;
}
export interface GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessages {
    /**
    * The channel which the response is associated with. Clients can specify the channel via QueryParameters.channel, and only associated channel response will be returned.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#channel GoogleDialogflowCxPage#channel}
    */
    readonly channel?: string;
    /**
    * A custom, platform-specific payload.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#payload GoogleDialogflowCxPage#payload}
    */
    readonly payload?: string;
    /**
    * conversation_success block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#conversation_success GoogleDialogflowCxPage#conversation_success}
    */
    readonly conversationSuccess?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesConversationSuccess;
    /**
    * live_agent_handoff block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#live_agent_handoff GoogleDialogflowCxPage#live_agent_handoff}
    */
    readonly liveAgentHandoff?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesLiveAgentHandoff;
    /**
    * output_audio_text block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#output_audio_text GoogleDialogflowCxPage#output_audio_text}
    */
    readonly outputAudioText?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesOutputAudioText;
    /**
    * play_audio block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#play_audio GoogleDialogflowCxPage#play_audio}
    */
    readonly playAudio?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesPlayAudio;
    /**
    * telephony_transfer_call block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#telephony_transfer_call GoogleDialogflowCxPage#telephony_transfer_call}
    */
    readonly telephonyTransferCall?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesTelephonyTransferCall;
    /**
    * text block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#text GoogleDialogflowCxPage#text}
    */
    readonly text?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesText;
}
export declare function googleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesToTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessages | cdktf.IResolvable): any;
export declare function googleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesToHclTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessages | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessages | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessages | cdktf.IResolvable | undefined);
    private _channel?;
    get channel(): string;
    set channel(value: string);
    resetChannel(): void;
    get channelInput(): string | undefined;
    private _payload?;
    get payload(): string;
    set payload(value: string);
    resetPayload(): void;
    get payloadInput(): string | undefined;
    private _conversationSuccess;
    get conversationSuccess(): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesConversationSuccessOutputReference;
    putConversationSuccess(value: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesConversationSuccess): void;
    resetConversationSuccess(): void;
    get conversationSuccessInput(): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesConversationSuccess | undefined;
    private _liveAgentHandoff;
    get liveAgentHandoff(): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesLiveAgentHandoffOutputReference;
    putLiveAgentHandoff(value: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesLiveAgentHandoff): void;
    resetLiveAgentHandoff(): void;
    get liveAgentHandoffInput(): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesLiveAgentHandoff | undefined;
    private _outputAudioText;
    get outputAudioText(): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesOutputAudioTextOutputReference;
    putOutputAudioText(value: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesOutputAudioText): void;
    resetOutputAudioText(): void;
    get outputAudioTextInput(): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesOutputAudioText | undefined;
    private _playAudio;
    get playAudio(): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesPlayAudioOutputReference;
    putPlayAudio(value: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesPlayAudio): void;
    resetPlayAudio(): void;
    get playAudioInput(): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesPlayAudio | undefined;
    private _telephonyTransferCall;
    get telephonyTransferCall(): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesTelephonyTransferCallOutputReference;
    putTelephonyTransferCall(value: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesTelephonyTransferCall): void;
    resetTelephonyTransferCall(): void;
    get telephonyTransferCallInput(): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesTelephonyTransferCall | undefined;
    private _text;
    get text(): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesTextOutputReference;
    putText(value: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesText): void;
    resetText(): void;
    get textInput(): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesText | undefined;
}
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessages[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesOutputReference;
}
export interface GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentSetParameterActions {
    /**
    * Display name of the parameter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#parameter GoogleDialogflowCxPage#parameter}
    */
    readonly parameter?: string;
    /**
    * The new JSON-encoded value of the parameter. A null value clears the parameter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#value GoogleDialogflowCxPage#value}
    */
    readonly value?: string;
}
export declare function googleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentSetParameterActionsToTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentSetParameterActions | cdktf.IResolvable): any;
export declare function googleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentSetParameterActionsToHclTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentSetParameterActions | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentSetParameterActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentSetParameterActions | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentSetParameterActions | cdktf.IResolvable | undefined);
    private _parameter?;
    get parameter(): string;
    set parameter(value: string);
    resetParameter(): void;
    get parameterInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentSetParameterActionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentSetParameterActions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentSetParameterActionsOutputReference;
}
export interface GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillment {
    /**
    * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs. If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#return_partial_responses GoogleDialogflowCxPage#return_partial_responses}
    */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
    * The tag used by the webhook to identify which fulfillment is being called. This field is required if webhook is specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#tag GoogleDialogflowCxPage#tag}
    */
    readonly tag?: string;
    /**
    * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#webhook GoogleDialogflowCxPage#webhook}
    */
    readonly webhook?: string;
    /**
    * conditional_cases block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#conditional_cases GoogleDialogflowCxPage#conditional_cases}
    */
    readonly conditionalCases?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentConditionalCases[] | cdktf.IResolvable;
    /**
    * messages block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#messages GoogleDialogflowCxPage#messages}
    */
    readonly messages?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessages[] | cdktf.IResolvable;
    /**
    * set_parameter_actions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#set_parameter_actions GoogleDialogflowCxPage#set_parameter_actions}
    */
    readonly setParameterActions?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentSetParameterActions[] | cdktf.IResolvable;
}
export declare function googleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentToTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentOutputReference | GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillment): any;
export declare function googleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentToHclTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentOutputReference | GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillment): any;
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillment | undefined;
    set internalValue(value: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillment | undefined);
    private _returnPartialResponses?;
    get returnPartialResponses(): boolean | cdktf.IResolvable;
    set returnPartialResponses(value: boolean | cdktf.IResolvable);
    resetReturnPartialResponses(): void;
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _webhook?;
    get webhook(): string;
    set webhook(value: string);
    resetWebhook(): void;
    get webhookInput(): string | undefined;
    private _conditionalCases;
    get conditionalCases(): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentConditionalCasesList;
    putConditionalCases(value: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentConditionalCases[] | cdktf.IResolvable): void;
    resetConditionalCases(): void;
    get conditionalCasesInput(): cdktf.IResolvable | GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentConditionalCases[] | undefined;
    private _messages;
    get messages(): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessagesList;
    putMessages(value: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessages[] | cdktf.IResolvable): void;
    resetMessages(): void;
    get messagesInput(): cdktf.IResolvable | GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentMessages[] | undefined;
    private _setParameterActions;
    get setParameterActions(): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentSetParameterActionsList;
    putSetParameterActions(value: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentSetParameterActions[] | cdktf.IResolvable): void;
    resetSetParameterActions(): void;
    get setParameterActionsInput(): cdktf.IResolvable | GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentSetParameterActions[] | undefined;
}
export interface GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlers {
    /**
    * The name of the event to handle.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#event GoogleDialogflowCxPage#event}
    */
    readonly event?: string;
    /**
    * The target flow to transition to.
    * Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#target_flow GoogleDialogflowCxPage#target_flow}
    */
    readonly targetFlow?: string;
    /**
    * The target page to transition to.
    * Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#target_page GoogleDialogflowCxPage#target_page}
    */
    readonly targetPage?: string;
    /**
    * trigger_fulfillment block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#trigger_fulfillment GoogleDialogflowCxPage#trigger_fulfillment}
    */
    readonly triggerFulfillment?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillment;
}
export declare function googleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersToTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlers | cdktf.IResolvable): any;
export declare function googleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersToHclTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlers | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlers | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlers | cdktf.IResolvable | undefined);
    private _event?;
    get event(): string;
    set event(value: string);
    resetEvent(): void;
    get eventInput(): string | undefined;
    get name(): string;
    private _targetFlow?;
    get targetFlow(): string;
    set targetFlow(value: string);
    resetTargetFlow(): void;
    get targetFlowInput(): string | undefined;
    private _targetPage?;
    get targetPage(): string;
    set targetPage(value: string);
    resetTargetPage(): void;
    get targetPageInput(): string | undefined;
    private _triggerFulfillment;
    get triggerFulfillment(): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillmentOutputReference;
    putTriggerFulfillment(value: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillment): void;
    resetTriggerFulfillment(): void;
    get triggerFulfillmentInput(): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersTriggerFulfillment | undefined;
}
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersOutputReference;
}
export interface GoogleDialogflowCxPageFormParametersFillBehavior {
    /**
    * initial_prompt_fulfillment block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#initial_prompt_fulfillment GoogleDialogflowCxPage#initial_prompt_fulfillment}
    */
    readonly initialPromptFulfillment?: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment;
    /**
    * reprompt_event_handlers block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#reprompt_event_handlers GoogleDialogflowCxPage#reprompt_event_handlers}
    */
    readonly repromptEventHandlers?: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlers[] | cdktf.IResolvable;
}
export declare function googleDialogflowCxPageFormParametersFillBehaviorToTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorOutputReference | GoogleDialogflowCxPageFormParametersFillBehavior): any;
export declare function googleDialogflowCxPageFormParametersFillBehaviorToHclTerraform(struct?: GoogleDialogflowCxPageFormParametersFillBehaviorOutputReference | GoogleDialogflowCxPageFormParametersFillBehavior): any;
export declare class GoogleDialogflowCxPageFormParametersFillBehaviorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageFormParametersFillBehavior | undefined;
    set internalValue(value: GoogleDialogflowCxPageFormParametersFillBehavior | undefined);
    private _initialPromptFulfillment;
    get initialPromptFulfillment(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentOutputReference;
    putInitialPromptFulfillment(value: GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment): void;
    resetInitialPromptFulfillment(): void;
    get initialPromptFulfillmentInput(): GoogleDialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment | undefined;
    private _repromptEventHandlers;
    get repromptEventHandlers(): GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlersList;
    putRepromptEventHandlers(value: GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlers[] | cdktf.IResolvable): void;
    resetRepromptEventHandlers(): void;
    get repromptEventHandlersInput(): cdktf.IResolvable | GoogleDialogflowCxPageFormParametersFillBehaviorRepromptEventHandlers[] | undefined;
}
export interface GoogleDialogflowCxPageFormParameters {
    /**
    * The default value of an optional parameter. If the parameter is required, the default value will be ignored.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#default_value GoogleDialogflowCxPage#default_value}
    */
    readonly defaultValue?: string;
    /**
    * The human-readable name of the parameter, unique within the form.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#display_name GoogleDialogflowCxPage#display_name}
    */
    readonly displayName?: string;
    /**
    * The entity type of the parameter.
    * Format: projects/-/locations/-/agents/-/entityTypes/<System Entity Type ID> for system entity types (for example, projects/-/locations/-/agents/-/entityTypes/sys.date), or projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/entityTypes/<Entity Type ID> for developer entity types.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#entity_type GoogleDialogflowCxPage#entity_type}
    */
    readonly entityType?: string;
    /**
    * Indicates whether the parameter represents a list of values.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#is_list GoogleDialogflowCxPage#is_list}
    */
    readonly isList?: boolean | cdktf.IResolvable;
    /**
    * Indicates whether the parameter content should be redacted in log.
    * If redaction is enabled, the parameter content will be replaced by parameter name during logging. Note: the parameter content is subject to redaction if either parameter level redaction or entity type level redaction is enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#redact GoogleDialogflowCxPage#redact}
    */
    readonly redact?: boolean | cdktf.IResolvable;
    /**
    * Indicates whether the parameter is required. Optional parameters will not trigger prompts; however, they are filled if the user specifies them.
    * Required parameters must be filled before form filling concludes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#required GoogleDialogflowCxPage#required}
    */
    readonly required?: boolean | cdktf.IResolvable;
    /**
    * advanced_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#advanced_settings GoogleDialogflowCxPage#advanced_settings}
    */
    readonly advancedSettings?: GoogleDialogflowCxPageFormParametersAdvancedSettings;
    /**
    * fill_behavior block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#fill_behavior GoogleDialogflowCxPage#fill_behavior}
    */
    readonly fillBehavior?: GoogleDialogflowCxPageFormParametersFillBehavior;
}
export declare function googleDialogflowCxPageFormParametersToTerraform(struct?: GoogleDialogflowCxPageFormParameters | cdktf.IResolvable): any;
export declare function googleDialogflowCxPageFormParametersToHclTerraform(struct?: GoogleDialogflowCxPageFormParameters | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxPageFormParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxPageFormParameters | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxPageFormParameters | cdktf.IResolvable | undefined);
    private _defaultValue?;
    get defaultValue(): string;
    set defaultValue(value: string);
    resetDefaultValue(): void;
    get defaultValueInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _entityType?;
    get entityType(): string;
    set entityType(value: string);
    resetEntityType(): void;
    get entityTypeInput(): string | undefined;
    private _isList?;
    get isList(): boolean | cdktf.IResolvable;
    set isList(value: boolean | cdktf.IResolvable);
    resetIsList(): void;
    get isListInput(): boolean | cdktf.IResolvable | undefined;
    private _redact?;
    get redact(): boolean | cdktf.IResolvable;
    set redact(value: boolean | cdktf.IResolvable);
    resetRedact(): void;
    get redactInput(): boolean | cdktf.IResolvable | undefined;
    private _required?;
    get required(): boolean | cdktf.IResolvable;
    set required(value: boolean | cdktf.IResolvable);
    resetRequired(): void;
    get requiredInput(): boolean | cdktf.IResolvable | undefined;
    private _advancedSettings;
    get advancedSettings(): GoogleDialogflowCxPageFormParametersAdvancedSettingsOutputReference;
    putAdvancedSettings(value: GoogleDialogflowCxPageFormParametersAdvancedSettings): void;
    resetAdvancedSettings(): void;
    get advancedSettingsInput(): GoogleDialogflowCxPageFormParametersAdvancedSettings | undefined;
    private _fillBehavior;
    get fillBehavior(): GoogleDialogflowCxPageFormParametersFillBehaviorOutputReference;
    putFillBehavior(value: GoogleDialogflowCxPageFormParametersFillBehavior): void;
    resetFillBehavior(): void;
    get fillBehaviorInput(): GoogleDialogflowCxPageFormParametersFillBehavior | undefined;
}
export declare class GoogleDialogflowCxPageFormParametersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxPageFormParameters[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxPageFormParametersOutputReference;
}
export interface GoogleDialogflowCxPageForm {
    /**
    * parameters block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#parameters GoogleDialogflowCxPage#parameters}
    */
    readonly parameters?: GoogleDialogflowCxPageFormParameters[] | cdktf.IResolvable;
}
export declare function googleDialogflowCxPageFormToTerraform(struct?: GoogleDialogflowCxPageFormOutputReference | GoogleDialogflowCxPageForm): any;
export declare function googleDialogflowCxPageFormToHclTerraform(struct?: GoogleDialogflowCxPageFormOutputReference | GoogleDialogflowCxPageForm): any;
export declare class GoogleDialogflowCxPageFormOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageForm | undefined;
    set internalValue(value: GoogleDialogflowCxPageForm | undefined);
    private _parameters;
    get parameters(): GoogleDialogflowCxPageFormParametersList;
    putParameters(value: GoogleDialogflowCxPageFormParameters[] | cdktf.IResolvable): void;
    resetParameters(): void;
    get parametersInput(): cdktf.IResolvable | GoogleDialogflowCxPageFormParameters[] | undefined;
}
export interface GoogleDialogflowCxPageTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#create GoogleDialogflowCxPage#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#delete GoogleDialogflowCxPage#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#update GoogleDialogflowCxPage#update}
    */
    readonly update?: string;
}
export declare function googleDialogflowCxPageTimeoutsToTerraform(struct?: GoogleDialogflowCxPageTimeouts | cdktf.IResolvable): any;
export declare function googleDialogflowCxPageTimeoutsToHclTerraform(struct?: GoogleDialogflowCxPageTimeouts | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxPageTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxPageTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentConditionalCases {
    /**
    * A JSON encoded list of cascading if-else conditions. Cases are mutually exclusive. The first one with a matching condition is selected, all the rest ignored.
    * See [Case](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/Fulfillment#case) for the schema.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#cases GoogleDialogflowCxPage#cases}
    */
    readonly cases?: string;
}
export declare function googleDialogflowCxPageTransitionRoutesTriggerFulfillmentConditionalCasesToTerraform(struct?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentConditionalCases | cdktf.IResolvable): any;
export declare function googleDialogflowCxPageTransitionRoutesTriggerFulfillmentConditionalCasesToHclTerraform(struct?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentConditionalCases | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentConditionalCasesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentConditionalCases | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentConditionalCases | cdktf.IResolvable | undefined);
    private _cases?;
    get cases(): string;
    set cases(value: string);
    resetCases(): void;
    get casesInput(): string | undefined;
}
export declare class GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentConditionalCasesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentConditionalCases[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentConditionalCasesOutputReference;
}
export interface GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesConversationSuccess {
    /**
    * Custom metadata. Dialogflow doesn't impose any structure on this.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#metadata GoogleDialogflowCxPage#metadata}
    */
    readonly metadata?: string;
}
export declare function googleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesConversationSuccessToTerraform(struct?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesConversationSuccessOutputReference | GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesConversationSuccess): any;
export declare function googleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesConversationSuccessToHclTerraform(struct?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesConversationSuccessOutputReference | GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesConversationSuccess): any;
export declare class GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesConversationSuccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesConversationSuccess | undefined;
    set internalValue(value: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesConversationSuccess | undefined);
    private _metadata?;
    get metadata(): string;
    set metadata(value: string);
    resetMetadata(): void;
    get metadataInput(): string | undefined;
}
export interface GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesLiveAgentHandoff {
    /**
    * Custom metadata. Dialogflow doesn't impose any structure on this.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#metadata GoogleDialogflowCxPage#metadata}
    */
    readonly metadata?: string;
}
export declare function googleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesLiveAgentHandoffToTerraform(struct?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesLiveAgentHandoffOutputReference | GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesLiveAgentHandoff): any;
export declare function googleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesLiveAgentHandoffToHclTerraform(struct?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesLiveAgentHandoffOutputReference | GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesLiveAgentHandoff): any;
export declare class GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesLiveAgentHandoffOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesLiveAgentHandoff | undefined;
    set internalValue(value: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesLiveAgentHandoff | undefined);
    private _metadata?;
    get metadata(): string;
    set metadata(value: string);
    resetMetadata(): void;
    get metadataInput(): string | undefined;
}
export interface GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesOutputAudioText {
    /**
    * The SSML text to be synthesized. For more information, see SSML.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#ssml GoogleDialogflowCxPage#ssml}
    */
    readonly ssml?: string;
    /**
    * The raw text to be synthesized.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#text GoogleDialogflowCxPage#text}
    */
    readonly text?: string;
}
export declare function googleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesOutputAudioTextToTerraform(struct?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesOutputAudioTextOutputReference | GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesOutputAudioText): any;
export declare function googleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesOutputAudioTextToHclTerraform(struct?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesOutputAudioTextOutputReference | GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesOutputAudioText): any;
export declare class GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesOutputAudioTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesOutputAudioText | undefined;
    set internalValue(value: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesOutputAudioText | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _ssml?;
    get ssml(): string;
    set ssml(value: string);
    resetSsml(): void;
    get ssmlInput(): string | undefined;
    private _text?;
    get text(): string;
    set text(value: string);
    resetText(): void;
    get textInput(): string | undefined;
}
export interface GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesPlayAudio {
    /**
    * URI of the audio clip. Dialogflow does not impose any validation on this value. It is specific to the client that reads it.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#audio_uri GoogleDialogflowCxPage#audio_uri}
    */
    readonly audioUri: string;
}
export declare function googleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesPlayAudioToTerraform(struct?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesPlayAudioOutputReference | GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesPlayAudio): any;
export declare function googleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesPlayAudioToHclTerraform(struct?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesPlayAudioOutputReference | GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesPlayAudio): any;
export declare class GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesPlayAudioOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesPlayAudio | undefined;
    set internalValue(value: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesPlayAudio | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _audioUri?;
    get audioUri(): string;
    set audioUri(value: string);
    get audioUriInput(): string | undefined;
}
export interface GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTelephonyTransferCall {
    /**
    * Transfer the call to a phone number in E.164 format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#phone_number GoogleDialogflowCxPage#phone_number}
    */
    readonly phoneNumber: string;
}
export declare function googleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTelephonyTransferCallToTerraform(struct?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTelephonyTransferCallOutputReference | GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTelephonyTransferCall): any;
export declare function googleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTelephonyTransferCallToHclTerraform(struct?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTelephonyTransferCallOutputReference | GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTelephonyTransferCall): any;
export declare class GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTelephonyTransferCallOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTelephonyTransferCall | undefined;
    set internalValue(value: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTelephonyTransferCall | undefined);
    private _phoneNumber?;
    get phoneNumber(): string;
    set phoneNumber(value: string);
    get phoneNumberInput(): string | undefined;
}
export interface GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesText {
    /**
    * A collection of text responses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#text GoogleDialogflowCxPage#text}
    */
    readonly text?: string[];
}
export declare function googleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTextToTerraform(struct?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTextOutputReference | GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesText): any;
export declare function googleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTextToHclTerraform(struct?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTextOutputReference | GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesText): any;
export declare class GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesText | undefined;
    set internalValue(value: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesText | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _text?;
    get text(): string[];
    set text(value: string[]);
    resetText(): void;
    get textInput(): string[] | undefined;
}
export interface GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessages {
    /**
    * The channel which the response is associated with. Clients can specify the channel via QueryParameters.channel, and only associated channel response will be returned.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#channel GoogleDialogflowCxPage#channel}
    */
    readonly channel?: string;
    /**
    * A custom, platform-specific payload.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#payload GoogleDialogflowCxPage#payload}
    */
    readonly payload?: string;
    /**
    * conversation_success block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#conversation_success GoogleDialogflowCxPage#conversation_success}
    */
    readonly conversationSuccess?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesConversationSuccess;
    /**
    * live_agent_handoff block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#live_agent_handoff GoogleDialogflowCxPage#live_agent_handoff}
    */
    readonly liveAgentHandoff?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesLiveAgentHandoff;
    /**
    * output_audio_text block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#output_audio_text GoogleDialogflowCxPage#output_audio_text}
    */
    readonly outputAudioText?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesOutputAudioText;
    /**
    * play_audio block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#play_audio GoogleDialogflowCxPage#play_audio}
    */
    readonly playAudio?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesPlayAudio;
    /**
    * telephony_transfer_call block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#telephony_transfer_call GoogleDialogflowCxPage#telephony_transfer_call}
    */
    readonly telephonyTransferCall?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTelephonyTransferCall;
    /**
    * text block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#text GoogleDialogflowCxPage#text}
    */
    readonly text?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesText;
}
export declare function googleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesToTerraform(struct?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessages | cdktf.IResolvable): any;
export declare function googleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesToHclTerraform(struct?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessages | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessages | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessages | cdktf.IResolvable | undefined);
    private _channel?;
    get channel(): string;
    set channel(value: string);
    resetChannel(): void;
    get channelInput(): string | undefined;
    private _payload?;
    get payload(): string;
    set payload(value: string);
    resetPayload(): void;
    get payloadInput(): string | undefined;
    private _conversationSuccess;
    get conversationSuccess(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesConversationSuccessOutputReference;
    putConversationSuccess(value: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesConversationSuccess): void;
    resetConversationSuccess(): void;
    get conversationSuccessInput(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesConversationSuccess | undefined;
    private _liveAgentHandoff;
    get liveAgentHandoff(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesLiveAgentHandoffOutputReference;
    putLiveAgentHandoff(value: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesLiveAgentHandoff): void;
    resetLiveAgentHandoff(): void;
    get liveAgentHandoffInput(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesLiveAgentHandoff | undefined;
    private _outputAudioText;
    get outputAudioText(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesOutputAudioTextOutputReference;
    putOutputAudioText(value: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesOutputAudioText): void;
    resetOutputAudioText(): void;
    get outputAudioTextInput(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesOutputAudioText | undefined;
    private _playAudio;
    get playAudio(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesPlayAudioOutputReference;
    putPlayAudio(value: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesPlayAudio): void;
    resetPlayAudio(): void;
    get playAudioInput(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesPlayAudio | undefined;
    private _telephonyTransferCall;
    get telephonyTransferCall(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTelephonyTransferCallOutputReference;
    putTelephonyTransferCall(value: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTelephonyTransferCall): void;
    resetTelephonyTransferCall(): void;
    get telephonyTransferCallInput(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTelephonyTransferCall | undefined;
    private _text;
    get text(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTextOutputReference;
    putText(value: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesText): void;
    resetText(): void;
    get textInput(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesText | undefined;
}
export declare class GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessages[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesOutputReference;
}
export interface GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentSetParameterActions {
    /**
    * Display name of the parameter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#parameter GoogleDialogflowCxPage#parameter}
    */
    readonly parameter?: string;
    /**
    * The new JSON-encoded value of the parameter. A null value clears the parameter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#value GoogleDialogflowCxPage#value}
    */
    readonly value?: string;
}
export declare function googleDialogflowCxPageTransitionRoutesTriggerFulfillmentSetParameterActionsToTerraform(struct?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentSetParameterActions | cdktf.IResolvable): any;
export declare function googleDialogflowCxPageTransitionRoutesTriggerFulfillmentSetParameterActionsToHclTerraform(struct?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentSetParameterActions | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentSetParameterActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentSetParameterActions | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentSetParameterActions | cdktf.IResolvable | undefined);
    private _parameter?;
    get parameter(): string;
    set parameter(value: string);
    resetParameter(): void;
    get parameterInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentSetParameterActionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentSetParameterActions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentSetParameterActionsOutputReference;
}
export interface GoogleDialogflowCxPageTransitionRoutesTriggerFulfillment {
    /**
    * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs. If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#return_partial_responses GoogleDialogflowCxPage#return_partial_responses}
    */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
    * The tag used by the webhook to identify which fulfillment is being called. This field is required if webhook is specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#tag GoogleDialogflowCxPage#tag}
    */
    readonly tag?: string;
    /**
    * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#webhook GoogleDialogflowCxPage#webhook}
    */
    readonly webhook?: string;
    /**
    * conditional_cases block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#conditional_cases GoogleDialogflowCxPage#conditional_cases}
    */
    readonly conditionalCases?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentConditionalCases[] | cdktf.IResolvable;
    /**
    * messages block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#messages GoogleDialogflowCxPage#messages}
    */
    readonly messages?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessages[] | cdktf.IResolvable;
    /**
    * set_parameter_actions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#set_parameter_actions GoogleDialogflowCxPage#set_parameter_actions}
    */
    readonly setParameterActions?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentSetParameterActions[] | cdktf.IResolvable;
}
export declare function googleDialogflowCxPageTransitionRoutesTriggerFulfillmentToTerraform(struct?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentOutputReference | GoogleDialogflowCxPageTransitionRoutesTriggerFulfillment): any;
export declare function googleDialogflowCxPageTransitionRoutesTriggerFulfillmentToHclTerraform(struct?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentOutputReference | GoogleDialogflowCxPageTransitionRoutesTriggerFulfillment): any;
export declare class GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillment | undefined;
    set internalValue(value: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillment | undefined);
    private _returnPartialResponses?;
    get returnPartialResponses(): boolean | cdktf.IResolvable;
    set returnPartialResponses(value: boolean | cdktf.IResolvable);
    resetReturnPartialResponses(): void;
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _webhook?;
    get webhook(): string;
    set webhook(value: string);
    resetWebhook(): void;
    get webhookInput(): string | undefined;
    private _conditionalCases;
    get conditionalCases(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentConditionalCasesList;
    putConditionalCases(value: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentConditionalCases[] | cdktf.IResolvable): void;
    resetConditionalCases(): void;
    get conditionalCasesInput(): cdktf.IResolvable | GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentConditionalCases[] | undefined;
    private _messages;
    get messages(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesList;
    putMessages(value: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessages[] | cdktf.IResolvable): void;
    resetMessages(): void;
    get messagesInput(): cdktf.IResolvable | GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentMessages[] | undefined;
    private _setParameterActions;
    get setParameterActions(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentSetParameterActionsList;
    putSetParameterActions(value: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentSetParameterActions[] | cdktf.IResolvable): void;
    resetSetParameterActions(): void;
    get setParameterActionsInput(): cdktf.IResolvable | GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentSetParameterActions[] | undefined;
}
export interface GoogleDialogflowCxPageTransitionRoutes {
    /**
    * The condition to evaluate against form parameters or session parameters.
    * At least one of intent or condition must be specified. When both intent and condition are specified, the transition can only happen when both are fulfilled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#condition GoogleDialogflowCxPage#condition}
    */
    readonly condition?: string;
    /**
    * The unique identifier of an Intent.
    * Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/intents/<Intent ID>. Indicates that the transition can only happen when the given intent is matched. At least one of intent or condition must be specified. When both intent and condition are specified, the transition can only happen when both are fulfilled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#intent GoogleDialogflowCxPage#intent}
    */
    readonly intent?: string;
    /**
    * The target flow to transition to.
    * Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#target_flow GoogleDialogflowCxPage#target_flow}
    */
    readonly targetFlow?: string;
    /**
    * The target page to transition to.
    * Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#target_page GoogleDialogflowCxPage#target_page}
    */
    readonly targetPage?: string;
    /**
    * trigger_fulfillment block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#trigger_fulfillment GoogleDialogflowCxPage#trigger_fulfillment}
    */
    readonly triggerFulfillment?: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillment;
}
export declare function googleDialogflowCxPageTransitionRoutesToTerraform(struct?: GoogleDialogflowCxPageTransitionRoutes | cdktf.IResolvable): any;
export declare function googleDialogflowCxPageTransitionRoutesToHclTerraform(struct?: GoogleDialogflowCxPageTransitionRoutes | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxPageTransitionRoutesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxPageTransitionRoutes | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxPageTransitionRoutes | cdktf.IResolvable | undefined);
    private _condition?;
    get condition(): string;
    set condition(value: string);
    resetCondition(): void;
    get conditionInput(): string | undefined;
    private _intent?;
    get intent(): string;
    set intent(value: string);
    resetIntent(): void;
    get intentInput(): string | undefined;
    get name(): string;
    private _targetFlow?;
    get targetFlow(): string;
    set targetFlow(value: string);
    resetTargetFlow(): void;
    get targetFlowInput(): string | undefined;
    private _targetPage?;
    get targetPage(): string;
    set targetPage(value: string);
    resetTargetPage(): void;
    get targetPageInput(): string | undefined;
    private _triggerFulfillment;
    get triggerFulfillment(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillmentOutputReference;
    putTriggerFulfillment(value: GoogleDialogflowCxPageTransitionRoutesTriggerFulfillment): void;
    resetTriggerFulfillment(): void;
    get triggerFulfillmentInput(): GoogleDialogflowCxPageTransitionRoutesTriggerFulfillment | undefined;
}
export declare class GoogleDialogflowCxPageTransitionRoutesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxPageTransitionRoutes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxPageTransitionRoutesOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page google_dialogflow_cx_page}
*/
export declare class GoogleDialogflowCxPage extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dialogflow_cx_page";
    /**
    * Generates CDKTF code for importing a GoogleDialogflowCxPage resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleDialogflowCxPage to import
    * @param importFromId The id of the existing GoogleDialogflowCxPage that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleDialogflowCxPage to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_page google_dialogflow_cx_page} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDialogflowCxPageConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDialogflowCxPageConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _languageCode?;
    get languageCode(): string;
    set languageCode(value: string);
    resetLanguageCode(): void;
    get languageCodeInput(): string | undefined;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    resetParent(): void;
    get parentInput(): string | undefined;
    private _transitionRouteGroups?;
    get transitionRouteGroups(): string[];
    set transitionRouteGroups(value: string[]);
    resetTransitionRouteGroups(): void;
    get transitionRouteGroupsInput(): string[] | undefined;
    private _advancedSettings;
    get advancedSettings(): GoogleDialogflowCxPageAdvancedSettingsOutputReference;
    putAdvancedSettings(value: GoogleDialogflowCxPageAdvancedSettings): void;
    resetAdvancedSettings(): void;
    get advancedSettingsInput(): GoogleDialogflowCxPageAdvancedSettings | undefined;
    private _entryFulfillment;
    get entryFulfillment(): GoogleDialogflowCxPageEntryFulfillmentOutputReference;
    putEntryFulfillment(value: GoogleDialogflowCxPageEntryFulfillment): void;
    resetEntryFulfillment(): void;
    get entryFulfillmentInput(): GoogleDialogflowCxPageEntryFulfillment | undefined;
    private _eventHandlers;
    get eventHandlers(): GoogleDialogflowCxPageEventHandlersList;
    putEventHandlers(value: GoogleDialogflowCxPageEventHandlers[] | cdktf.IResolvable): void;
    resetEventHandlers(): void;
    get eventHandlersInput(): cdktf.IResolvable | GoogleDialogflowCxPageEventHandlers[] | undefined;
    private _form;
    get form(): GoogleDialogflowCxPageFormOutputReference;
    putForm(value: GoogleDialogflowCxPageForm): void;
    resetForm(): void;
    get formInput(): GoogleDialogflowCxPageForm | undefined;
    private _timeouts;
    get timeouts(): GoogleDialogflowCxPageTimeoutsOutputReference;
    putTimeouts(value: GoogleDialogflowCxPageTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDialogflowCxPageTimeouts | undefined;
    private _transitionRoutes;
    get transitionRoutes(): GoogleDialogflowCxPageTransitionRoutesList;
    putTransitionRoutes(value: GoogleDialogflowCxPageTransitionRoutes[] | cdktf.IResolvable): void;
    resetTransitionRoutes(): void;
    get transitionRoutesInput(): cdktf.IResolvable | GoogleDialogflowCxPageTransitionRoutes[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
