/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDialogflowCxSecuritySettingsConfig extends cdktf.TerraformMetaArguments {
    /**
    * [DLP](https://cloud.google.com/dlp/docs) deidentify template name. Use this template to define de-identification configuration for the content. If empty, Dialogflow replaces sensitive info with [redacted] text.
    * Note: deidentifyTemplate must be located in the same region as the SecuritySettings.
    * Format: projects/<Project ID>/locations/<Location ID>/deidentifyTemplates/<Template ID> OR organizations/<Organization ID>/locations/<Location ID>/deidentifyTemplates/<Template ID>
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_security_settings#deidentify_template GoogleDialogflowCxSecuritySettings#deidentify_template}
    */
    readonly deidentifyTemplate?: string;
    /**
    * The human-readable name of the security settings, unique within the location.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_security_settings#display_name GoogleDialogflowCxSecuritySettings#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_security_settings#id GoogleDialogflowCxSecuritySettings#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * [DLP](https://cloud.google.com/dlp/docs) inspect template name. Use this template to define inspect base settings. If empty, we use the default DLP inspect config.
    * Note: inspectTemplate must be located in the same region as the SecuritySettings.
    * Format: projects/<Project ID>/locations/<Location ID>/inspectTemplates/<Template ID> OR organizations/<Organization ID>/locations/<Location ID>/inspectTemplates/<Template ID>
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_security_settings#inspect_template GoogleDialogflowCxSecuritySettings#inspect_template}
    */
    readonly inspectTemplate?: string;
    /**
    * The location these settings are located in. Settings can only be applied to an agent in the same location.
    * See [Available Regions](https://cloud.google.com/dialogflow/cx/docs/concept/region#avail) for a list of supported locations.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_security_settings#location GoogleDialogflowCxSecuritySettings#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_security_settings#project GoogleDialogflowCxSecuritySettings#project}
    */
    readonly project?: string;
    /**
    * List of types of data to remove when retention settings triggers purge. Possible values: ["DIALOGFLOW_HISTORY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_security_settings#purge_data_types GoogleDialogflowCxSecuritySettings#purge_data_types}
    */
    readonly purgeDataTypes?: string[];
    /**
    * Defines what types of data to redact. If not set, defaults to not redacting any kind of data.
    * * REDACT_DISK_STORAGE: On data to be written to disk or similar devices that are capable of holding data even if power is disconnected. This includes data that are temporarily saved on disk. Possible values: ["REDACT_DISK_STORAGE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_security_settings#redaction_scope GoogleDialogflowCxSecuritySettings#redaction_scope}
    */
    readonly redactionScope?: string;
    /**
    * Defines how we redact data. If not set, defaults to not redacting.
    * * REDACT_WITH_SERVICE: Call redaction service to clean up the data to be persisted. Possible values: ["REDACT_WITH_SERVICE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_security_settings#redaction_strategy GoogleDialogflowCxSecuritySettings#redaction_strategy}
    */
    readonly redactionStrategy?: string;
    /**
    * Defines how long we retain persisted data that contains sensitive info. Only one of 'retention_window_days' and 'retention_strategy' may be set.
    * * REMOVE_AFTER_CONVERSATION: Removes data when the conversation ends. If there is no conversation explicitly established, a default conversation ends when the corresponding Dialogflow session ends. Possible values: ["REMOVE_AFTER_CONVERSATION"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_security_settings#retention_strategy GoogleDialogflowCxSecuritySettings#retention_strategy}
    */
    readonly retentionStrategy?: string;
    /**
    * Retains the data for the specified number of days. User must set a value lower than Dialogflow's default 365d TTL (30 days for Agent Assist traffic), higher value will be ignored and use default. Setting a value higher than that has no effect. A missing value or setting to 0 also means we use default TTL.
    * Only one of 'retention_window_days' and 'retention_strategy' may be set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_security_settings#retention_window_days GoogleDialogflowCxSecuritySettings#retention_window_days}
    */
    readonly retentionWindowDays?: number;
    /**
    * audio_export_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_security_settings#audio_export_settings GoogleDialogflowCxSecuritySettings#audio_export_settings}
    */
    readonly audioExportSettings?: GoogleDialogflowCxSecuritySettingsAudioExportSettings;
    /**
    * insights_export_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_security_settings#insights_export_settings GoogleDialogflowCxSecuritySettings#insights_export_settings}
    */
    readonly insightsExportSettings?: GoogleDialogflowCxSecuritySettingsInsightsExportSettings;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_security_settings#timeouts GoogleDialogflowCxSecuritySettings#timeouts}
    */
    readonly timeouts?: GoogleDialogflowCxSecuritySettingsTimeouts;
}
export interface GoogleDialogflowCxSecuritySettingsAudioExportSettings {
    /**
    * Filename pattern for exported audio.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_security_settings#audio_export_pattern GoogleDialogflowCxSecuritySettings#audio_export_pattern}
    */
    readonly audioExportPattern?: string;
    /**
    * File format for exported audio file. Currently only in telephony recordings.
    * * MULAW: G.711 mu-law PCM with 8kHz sample rate.
    * * MP3: MP3 file format.
    * * OGG: OGG Vorbis. Possible values: ["MULAW", "MP3", "OGG"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_security_settings#audio_format GoogleDialogflowCxSecuritySettings#audio_format}
    */
    readonly audioFormat?: string;
    /**
    * Enable audio redaction if it is true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_security_settings#enable_audio_redaction GoogleDialogflowCxSecuritySettings#enable_audio_redaction}
    */
    readonly enableAudioRedaction?: boolean | cdktf.IResolvable;
    /**
    * Cloud Storage bucket to export audio record to. Setting this field would grant the Storage Object Creator role to the Dialogflow Service Agent. API caller that tries to modify this field should have the permission of storage.buckets.setIamPolicy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_security_settings#gcs_bucket GoogleDialogflowCxSecuritySettings#gcs_bucket}
    */
    readonly gcsBucket?: string;
}
export declare function googleDialogflowCxSecuritySettingsAudioExportSettingsToTerraform(struct?: GoogleDialogflowCxSecuritySettingsAudioExportSettingsOutputReference | GoogleDialogflowCxSecuritySettingsAudioExportSettings): any;
export declare function googleDialogflowCxSecuritySettingsAudioExportSettingsToHclTerraform(struct?: GoogleDialogflowCxSecuritySettingsAudioExportSettingsOutputReference | GoogleDialogflowCxSecuritySettingsAudioExportSettings): any;
export declare class GoogleDialogflowCxSecuritySettingsAudioExportSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxSecuritySettingsAudioExportSettings | undefined;
    set internalValue(value: GoogleDialogflowCxSecuritySettingsAudioExportSettings | undefined);
    private _audioExportPattern?;
    get audioExportPattern(): string;
    set audioExportPattern(value: string);
    resetAudioExportPattern(): void;
    get audioExportPatternInput(): string | undefined;
    private _audioFormat?;
    get audioFormat(): string;
    set audioFormat(value: string);
    resetAudioFormat(): void;
    get audioFormatInput(): string | undefined;
    private _enableAudioRedaction?;
    get enableAudioRedaction(): boolean | cdktf.IResolvable;
    set enableAudioRedaction(value: boolean | cdktf.IResolvable);
    resetEnableAudioRedaction(): void;
    get enableAudioRedactionInput(): boolean | cdktf.IResolvable | undefined;
    private _gcsBucket?;
    get gcsBucket(): string;
    set gcsBucket(value: string);
    resetGcsBucket(): void;
    get gcsBucketInput(): string | undefined;
}
export interface GoogleDialogflowCxSecuritySettingsInsightsExportSettings {
    /**
    * If enabled, we will automatically exports conversations to Insights and Insights runs its analyzers.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_security_settings#enable_insights_export GoogleDialogflowCxSecuritySettings#enable_insights_export}
    */
    readonly enableInsightsExport: boolean | cdktf.IResolvable;
}
export declare function googleDialogflowCxSecuritySettingsInsightsExportSettingsToTerraform(struct?: GoogleDialogflowCxSecuritySettingsInsightsExportSettingsOutputReference | GoogleDialogflowCxSecuritySettingsInsightsExportSettings): any;
export declare function googleDialogflowCxSecuritySettingsInsightsExportSettingsToHclTerraform(struct?: GoogleDialogflowCxSecuritySettingsInsightsExportSettingsOutputReference | GoogleDialogflowCxSecuritySettingsInsightsExportSettings): any;
export declare class GoogleDialogflowCxSecuritySettingsInsightsExportSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxSecuritySettingsInsightsExportSettings | undefined;
    set internalValue(value: GoogleDialogflowCxSecuritySettingsInsightsExportSettings | undefined);
    private _enableInsightsExport?;
    get enableInsightsExport(): boolean | cdktf.IResolvable;
    set enableInsightsExport(value: boolean | cdktf.IResolvable);
    get enableInsightsExportInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleDialogflowCxSecuritySettingsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_security_settings#create GoogleDialogflowCxSecuritySettings#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_security_settings#delete GoogleDialogflowCxSecuritySettings#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_security_settings#update GoogleDialogflowCxSecuritySettings#update}
    */
    readonly update?: string;
}
export declare function googleDialogflowCxSecuritySettingsTimeoutsToTerraform(struct?: GoogleDialogflowCxSecuritySettingsTimeouts | cdktf.IResolvable): any;
export declare function googleDialogflowCxSecuritySettingsTimeoutsToHclTerraform(struct?: GoogleDialogflowCxSecuritySettingsTimeouts | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxSecuritySettingsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxSecuritySettingsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxSecuritySettingsTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_security_settings google_dialogflow_cx_security_settings}
*/
export declare class GoogleDialogflowCxSecuritySettings extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dialogflow_cx_security_settings";
    /**
    * Generates CDKTF code for importing a GoogleDialogflowCxSecuritySettings resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleDialogflowCxSecuritySettings to import
    * @param importFromId The id of the existing GoogleDialogflowCxSecuritySettings that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_security_settings#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleDialogflowCxSecuritySettings to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_security_settings google_dialogflow_cx_security_settings} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDialogflowCxSecuritySettingsConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDialogflowCxSecuritySettingsConfig);
    private _deidentifyTemplate?;
    get deidentifyTemplate(): string;
    set deidentifyTemplate(value: string);
    resetDeidentifyTemplate(): void;
    get deidentifyTemplateInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _inspectTemplate?;
    get inspectTemplate(): string;
    set inspectTemplate(value: string);
    resetInspectTemplate(): void;
    get inspectTemplateInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _purgeDataTypes?;
    get purgeDataTypes(): string[];
    set purgeDataTypes(value: string[]);
    resetPurgeDataTypes(): void;
    get purgeDataTypesInput(): string[] | undefined;
    private _redactionScope?;
    get redactionScope(): string;
    set redactionScope(value: string);
    resetRedactionScope(): void;
    get redactionScopeInput(): string | undefined;
    private _redactionStrategy?;
    get redactionStrategy(): string;
    set redactionStrategy(value: string);
    resetRedactionStrategy(): void;
    get redactionStrategyInput(): string | undefined;
    private _retentionStrategy?;
    get retentionStrategy(): string;
    set retentionStrategy(value: string);
    resetRetentionStrategy(): void;
    get retentionStrategyInput(): string | undefined;
    private _retentionWindowDays?;
    get retentionWindowDays(): number;
    set retentionWindowDays(value: number);
    resetRetentionWindowDays(): void;
    get retentionWindowDaysInput(): number | undefined;
    private _audioExportSettings;
    get audioExportSettings(): GoogleDialogflowCxSecuritySettingsAudioExportSettingsOutputReference;
    putAudioExportSettings(value: GoogleDialogflowCxSecuritySettingsAudioExportSettings): void;
    resetAudioExportSettings(): void;
    get audioExportSettingsInput(): GoogleDialogflowCxSecuritySettingsAudioExportSettings | undefined;
    private _insightsExportSettings;
    get insightsExportSettings(): GoogleDialogflowCxSecuritySettingsInsightsExportSettingsOutputReference;
    putInsightsExportSettings(value: GoogleDialogflowCxSecuritySettingsInsightsExportSettings): void;
    resetInsightsExportSettings(): void;
    get insightsExportSettingsInput(): GoogleDialogflowCxSecuritySettingsInsightsExportSettings | undefined;
    private _timeouts;
    get timeouts(): GoogleDialogflowCxSecuritySettingsTimeoutsOutputReference;
    putTimeouts(value: GoogleDialogflowCxSecuritySettingsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDialogflowCxSecuritySettingsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
