/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDialogflowCxTestCaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * The human-readable name of the test case, unique within the agent. Limit of 200 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#display_name GoogleDialogflowCxTestCase#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#id GoogleDialogflowCxTestCase#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Additional freeform notes about the test case. Limit of 400 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#notes GoogleDialogflowCxTestCase#notes}
    */
    readonly notes?: string;
    /**
    * The agent to create the test case for.
    * Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#parent GoogleDialogflowCxTestCase#parent}
    */
    readonly parent?: string;
    /**
    * Tags are short descriptions that users may apply to test cases for organizational and filtering purposes.
    * Each tag should start with "#" and has a limit of 30 characters
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#tags GoogleDialogflowCxTestCase#tags}
    */
    readonly tags?: string[];
    /**
    * test_case_conversation_turns block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#test_case_conversation_turns GoogleDialogflowCxTestCase#test_case_conversation_turns}
    */
    readonly testCaseConversationTurns?: GoogleDialogflowCxTestCaseTestCaseConversationTurns[] | cdktf.IResolvable;
    /**
    * test_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#test_config GoogleDialogflowCxTestCase#test_config}
    */
    readonly testConfig?: GoogleDialogflowCxTestCaseTestConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#timeouts GoogleDialogflowCxTestCase#timeouts}
    */
    readonly timeouts?: GoogleDialogflowCxTestCaseTimeouts;
}
export interface GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputDtmf {
}
export declare function googleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputDtmfToTerraform(struct?: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputDtmf): any;
export declare function googleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputDtmfToHclTerraform(struct?: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputDtmf): any;
export declare class GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputDtmfOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputDtmf | undefined;
    set internalValue(value: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputDtmf | undefined);
    get digits(): string;
    get finishDigit(): string;
}
export declare class GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputDtmfList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputDtmfOutputReference;
}
export interface GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputEvent {
}
export declare function googleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputEventToTerraform(struct?: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputEvent): any;
export declare function googleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputEventToHclTerraform(struct?: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputEvent): any;
export declare class GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputEventOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputEvent | undefined;
    set internalValue(value: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputEvent | undefined);
    get event(): string;
}
export declare class GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputEventList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputEventOutputReference;
}
export interface GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputText {
}
export declare function googleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputTextToTerraform(struct?: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputText): any;
export declare function googleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputTextToHclTerraform(struct?: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputText): any;
export declare class GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputText | undefined;
    set internalValue(value: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputText | undefined);
    get text(): string;
}
export declare class GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputTextList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputTextOutputReference;
}
export interface GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInput {
}
export declare function googleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputToTerraform(struct?: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInput): any;
export declare function googleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputToHclTerraform(struct?: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInput): any;
export declare class GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInput | undefined;
    set internalValue(value: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInput | undefined);
    private _dtmf;
    get dtmf(): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputDtmfList;
    private _event;
    get event(): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputEventList;
    get languageCode(): string;
    private _text;
    get text(): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputTextList;
}
export declare class GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputOutputReference;
}
export interface GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInput {
}
export declare function googleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputToTerraform(struct?: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInput): any;
export declare function googleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputToHclTerraform(struct?: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInput): any;
export declare class GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInput | undefined;
    set internalValue(value: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInput | undefined);
    get enableSentimentAnalysis(): cdktf.IResolvable;
    get injectedParameters(): string;
    private _input;
    get input(): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputInputList;
    get isWebhookEnabled(): cdktf.IResolvable;
}
export declare class GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputOutputReference;
}
export interface GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputCurrentPage {
}
export declare function googleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputCurrentPageToTerraform(struct?: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputCurrentPage): any;
export declare function googleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputCurrentPageToHclTerraform(struct?: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputCurrentPage): any;
export declare class GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputCurrentPageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputCurrentPage | undefined;
    set internalValue(value: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputCurrentPage | undefined);
    get displayName(): string;
    get name(): string;
}
export declare class GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputCurrentPageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputCurrentPageOutputReference;
}
export interface GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputDifferences {
}
export declare function googleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputDifferencesToTerraform(struct?: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputDifferences): any;
export declare function googleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputDifferencesToHclTerraform(struct?: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputDifferences): any;
export declare class GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputDifferencesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputDifferences | undefined;
    set internalValue(value: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputDifferences | undefined);
    get description(): string;
    get type(): string;
}
export declare class GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputDifferencesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputDifferencesOutputReference;
}
export interface GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputStatus {
}
export declare function googleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputStatusToTerraform(struct?: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputStatus): any;
export declare function googleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputStatusToHclTerraform(struct?: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputStatus): any;
export declare class GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputStatus | undefined;
    set internalValue(value: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputStatus | undefined);
    get code(): number;
    get details(): string;
    get message(): string;
}
export declare class GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputStatusOutputReference;
}
export interface GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputTextResponses {
}
export declare function googleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputTextResponsesToTerraform(struct?: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputTextResponses): any;
export declare function googleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputTextResponsesToHclTerraform(struct?: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputTextResponses): any;
export declare class GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputTextResponsesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputTextResponses | undefined;
    set internalValue(value: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputTextResponses | undefined);
    get text(): string[];
}
export declare class GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputTextResponsesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputTextResponsesOutputReference;
}
export interface GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputTriggeredIntent {
}
export declare function googleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputTriggeredIntentToTerraform(struct?: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputTriggeredIntent): any;
export declare function googleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputTriggeredIntentToHclTerraform(struct?: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputTriggeredIntent): any;
export declare class GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputTriggeredIntentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputTriggeredIntent | undefined;
    set internalValue(value: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputTriggeredIntent | undefined);
    get displayName(): string;
    get name(): string;
}
export declare class GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputTriggeredIntentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputTriggeredIntentOutputReference;
}
export interface GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutput {
}
export declare function googleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputToTerraform(struct?: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutput): any;
export declare function googleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputToHclTerraform(struct?: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutput): any;
export declare class GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutput | undefined;
    set internalValue(value: GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutput | undefined);
    private _currentPage;
    get currentPage(): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputCurrentPageList;
    private _differences;
    get differences(): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputDifferencesList;
    get sessionParameters(): string;
    private _status;
    get status(): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputStatusList;
    private _textResponses;
    get textResponses(): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputTextResponsesList;
    private _triggeredIntent;
    get triggeredIntent(): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputTriggeredIntentList;
}
export declare class GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputOutputReference;
}
export interface GoogleDialogflowCxTestCaseLastTestResultConversationTurns {
}
export declare function googleDialogflowCxTestCaseLastTestResultConversationTurnsToTerraform(struct?: GoogleDialogflowCxTestCaseLastTestResultConversationTurns): any;
export declare function googleDialogflowCxTestCaseLastTestResultConversationTurnsToHclTerraform(struct?: GoogleDialogflowCxTestCaseLastTestResultConversationTurns): any;
export declare class GoogleDialogflowCxTestCaseLastTestResultConversationTurnsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxTestCaseLastTestResultConversationTurns | undefined;
    set internalValue(value: GoogleDialogflowCxTestCaseLastTestResultConversationTurns | undefined);
    private _userInput;
    get userInput(): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsUserInputList;
    private _virtualAgentOutput;
    get virtualAgentOutput(): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsVirtualAgentOutputList;
}
export declare class GoogleDialogflowCxTestCaseLastTestResultConversationTurnsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsOutputReference;
}
export interface GoogleDialogflowCxTestCaseLastTestResult {
}
export declare function googleDialogflowCxTestCaseLastTestResultToTerraform(struct?: GoogleDialogflowCxTestCaseLastTestResult): any;
export declare function googleDialogflowCxTestCaseLastTestResultToHclTerraform(struct?: GoogleDialogflowCxTestCaseLastTestResult): any;
export declare class GoogleDialogflowCxTestCaseLastTestResultOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxTestCaseLastTestResult | undefined;
    set internalValue(value: GoogleDialogflowCxTestCaseLastTestResult | undefined);
    private _conversationTurns;
    get conversationTurns(): GoogleDialogflowCxTestCaseLastTestResultConversationTurnsList;
    get environment(): string;
    get name(): string;
    get testResult(): string;
    get testTime(): string;
}
export declare class GoogleDialogflowCxTestCaseLastTestResultList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxTestCaseLastTestResultOutputReference;
}
export interface GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputDtmf {
    /**
    * The dtmf digits.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#digits GoogleDialogflowCxTestCase#digits}
    */
    readonly digits?: string;
    /**
    * The finish digit (if any).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#finish_digit GoogleDialogflowCxTestCase#finish_digit}
    */
    readonly finishDigit?: string;
}
export declare function googleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputDtmfToTerraform(struct?: GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputDtmfOutputReference | GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputDtmf): any;
export declare function googleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputDtmfToHclTerraform(struct?: GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputDtmfOutputReference | GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputDtmf): any;
export declare class GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputDtmfOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputDtmf | undefined;
    set internalValue(value: GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputDtmf | undefined);
    private _digits?;
    get digits(): string;
    set digits(value: string);
    resetDigits(): void;
    get digitsInput(): string | undefined;
    private _finishDigit?;
    get finishDigit(): string;
    set finishDigit(value: string);
    resetFinishDigit(): void;
    get finishDigitInput(): string | undefined;
}
export interface GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputEvent {
    /**
    * Name of the event.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#event GoogleDialogflowCxTestCase#event}
    */
    readonly event: string;
}
export declare function googleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputEventToTerraform(struct?: GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputEventOutputReference | GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputEvent): any;
export declare function googleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputEventToHclTerraform(struct?: GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputEventOutputReference | GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputEvent): any;
export declare class GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputEventOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputEvent | undefined;
    set internalValue(value: GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputEvent | undefined);
    private _event?;
    get event(): string;
    set event(value: string);
    get eventInput(): string | undefined;
}
export interface GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputText {
    /**
    * The natural language text to be processed. Text length must not exceed 256 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#text GoogleDialogflowCxTestCase#text}
    */
    readonly text: string;
}
export declare function googleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputTextToTerraform(struct?: GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputTextOutputReference | GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputText): any;
export declare function googleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputTextToHclTerraform(struct?: GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputTextOutputReference | GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputText): any;
export declare class GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputText | undefined;
    set internalValue(value: GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputText | undefined);
    private _text?;
    get text(): string;
    set text(value: string);
    get textInput(): string | undefined;
}
export interface GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInput {
    /**
    * The language of the input. See [Language Support](https://cloud.google.com/dialogflow/cx/docs/reference/language) for a list of the currently supported language codes.
    * Note that queries in the same session do not necessarily need to specify the same language.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#language_code GoogleDialogflowCxTestCase#language_code}
    */
    readonly languageCode?: string;
    /**
    * dtmf block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#dtmf GoogleDialogflowCxTestCase#dtmf}
    */
    readonly dtmf?: GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputDtmf;
    /**
    * event block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#event GoogleDialogflowCxTestCase#event}
    */
    readonly event?: GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputEvent;
    /**
    * text block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#text GoogleDialogflowCxTestCase#text}
    */
    readonly text?: GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputText;
}
export declare function googleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputToTerraform(struct?: GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputOutputReference | GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInput): any;
export declare function googleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputToHclTerraform(struct?: GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputOutputReference | GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInput): any;
export declare class GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInput | undefined;
    set internalValue(value: GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInput | undefined);
    private _languageCode?;
    get languageCode(): string;
    set languageCode(value: string);
    resetLanguageCode(): void;
    get languageCodeInput(): string | undefined;
    private _dtmf;
    get dtmf(): GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputDtmfOutputReference;
    putDtmf(value: GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputDtmf): void;
    resetDtmf(): void;
    get dtmfInput(): GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputDtmf | undefined;
    private _event;
    get event(): GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputEventOutputReference;
    putEvent(value: GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputEvent): void;
    resetEvent(): void;
    get eventInput(): GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputEvent | undefined;
    private _text;
    get text(): GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputTextOutputReference;
    putText(value: GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputText): void;
    resetText(): void;
    get textInput(): GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputText | undefined;
}
export interface GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInput {
    /**
    * Whether sentiment analysis is enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#enable_sentiment_analysis GoogleDialogflowCxTestCase#enable_sentiment_analysis}
    */
    readonly enableSentimentAnalysis?: boolean | cdktf.IResolvable;
    /**
    * Parameters that need to be injected into the conversation during intent detection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#injected_parameters GoogleDialogflowCxTestCase#injected_parameters}
    */
    readonly injectedParameters?: string;
    /**
    * If webhooks should be allowed to trigger in response to the user utterance. Often if parameters are injected, webhooks should not be enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#is_webhook_enabled GoogleDialogflowCxTestCase#is_webhook_enabled}
    */
    readonly isWebhookEnabled?: boolean | cdktf.IResolvable;
    /**
    * input block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#input GoogleDialogflowCxTestCase#input}
    */
    readonly input?: GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInput;
}
export declare function googleDialogflowCxTestCaseTestCaseConversationTurnsUserInputToTerraform(struct?: GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputOutputReference | GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInput): any;
export declare function googleDialogflowCxTestCaseTestCaseConversationTurnsUserInputToHclTerraform(struct?: GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputOutputReference | GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInput): any;
export declare class GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInput | undefined;
    set internalValue(value: GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInput | undefined);
    private _enableSentimentAnalysis?;
    get enableSentimentAnalysis(): boolean | cdktf.IResolvable;
    set enableSentimentAnalysis(value: boolean | cdktf.IResolvable);
    resetEnableSentimentAnalysis(): void;
    get enableSentimentAnalysisInput(): boolean | cdktf.IResolvable | undefined;
    private _injectedParameters?;
    get injectedParameters(): string;
    set injectedParameters(value: string);
    resetInjectedParameters(): void;
    get injectedParametersInput(): string | undefined;
    private _isWebhookEnabled?;
    get isWebhookEnabled(): boolean | cdktf.IResolvable;
    set isWebhookEnabled(value: boolean | cdktf.IResolvable);
    resetIsWebhookEnabled(): void;
    get isWebhookEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _input;
    get input(): GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInputOutputReference;
    putInput(value: GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInput): void;
    resetInput(): void;
    get inputInput(): GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputInput | undefined;
}
export interface GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputCurrentPage {
    /**
    * The unique identifier of the page.
    * Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#name GoogleDialogflowCxTestCase#name}
    */
    readonly name?: string;
}
export declare function googleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputCurrentPageToTerraform(struct?: GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputCurrentPageOutputReference | GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputCurrentPage): any;
export declare function googleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputCurrentPageToHclTerraform(struct?: GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputCurrentPageOutputReference | GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputCurrentPage): any;
export declare class GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputCurrentPageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputCurrentPage | undefined;
    set internalValue(value: GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputCurrentPage | undefined);
    get displayName(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export interface GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputTextResponses {
    /**
    * A collection of text responses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#text GoogleDialogflowCxTestCase#text}
    */
    readonly text?: string[];
}
export declare function googleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputTextResponsesToTerraform(struct?: GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputTextResponses | cdktf.IResolvable): any;
export declare function googleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputTextResponsesToHclTerraform(struct?: GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputTextResponses | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputTextResponsesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputTextResponses | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputTextResponses | cdktf.IResolvable | undefined);
    private _text?;
    get text(): string[];
    set text(value: string[]);
    resetText(): void;
    get textInput(): string[] | undefined;
}
export declare class GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputTextResponsesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputTextResponses[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputTextResponsesOutputReference;
}
export interface GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputTriggeredIntent {
    /**
    * The unique identifier of the intent.
    * Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/intents/<Intent ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#name GoogleDialogflowCxTestCase#name}
    */
    readonly name?: string;
}
export declare function googleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputTriggeredIntentToTerraform(struct?: GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputTriggeredIntentOutputReference | GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputTriggeredIntent): any;
export declare function googleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputTriggeredIntentToHclTerraform(struct?: GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputTriggeredIntentOutputReference | GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputTriggeredIntent): any;
export declare class GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputTriggeredIntentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputTriggeredIntent | undefined;
    set internalValue(value: GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputTriggeredIntent | undefined);
    get displayName(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export interface GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutput {
    /**
    * The session parameters available to the bot at this point.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#session_parameters GoogleDialogflowCxTestCase#session_parameters}
    */
    readonly sessionParameters?: string;
    /**
    * current_page block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#current_page GoogleDialogflowCxTestCase#current_page}
    */
    readonly currentPage?: GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputCurrentPage;
    /**
    * text_responses block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#text_responses GoogleDialogflowCxTestCase#text_responses}
    */
    readonly textResponses?: GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputTextResponses[] | cdktf.IResolvable;
    /**
    * triggered_intent block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#triggered_intent GoogleDialogflowCxTestCase#triggered_intent}
    */
    readonly triggeredIntent?: GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputTriggeredIntent;
}
export declare function googleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputToTerraform(struct?: GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputOutputReference | GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutput): any;
export declare function googleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputToHclTerraform(struct?: GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputOutputReference | GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutput): any;
export declare class GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutput | undefined;
    set internalValue(value: GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutput | undefined);
    private _sessionParameters?;
    get sessionParameters(): string;
    set sessionParameters(value: string);
    resetSessionParameters(): void;
    get sessionParametersInput(): string | undefined;
    private _currentPage;
    get currentPage(): GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputCurrentPageOutputReference;
    putCurrentPage(value: GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputCurrentPage): void;
    resetCurrentPage(): void;
    get currentPageInput(): GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputCurrentPage | undefined;
    private _textResponses;
    get textResponses(): GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputTextResponsesList;
    putTextResponses(value: GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputTextResponses[] | cdktf.IResolvable): void;
    resetTextResponses(): void;
    get textResponsesInput(): cdktf.IResolvable | GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputTextResponses[] | undefined;
    private _triggeredIntent;
    get triggeredIntent(): GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputTriggeredIntentOutputReference;
    putTriggeredIntent(value: GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputTriggeredIntent): void;
    resetTriggeredIntent(): void;
    get triggeredIntentInput(): GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputTriggeredIntent | undefined;
}
export interface GoogleDialogflowCxTestCaseTestCaseConversationTurns {
    /**
    * user_input block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#user_input GoogleDialogflowCxTestCase#user_input}
    */
    readonly userInput?: GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInput;
    /**
    * virtual_agent_output block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#virtual_agent_output GoogleDialogflowCxTestCase#virtual_agent_output}
    */
    readonly virtualAgentOutput?: GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutput;
}
export declare function googleDialogflowCxTestCaseTestCaseConversationTurnsToTerraform(struct?: GoogleDialogflowCxTestCaseTestCaseConversationTurns | cdktf.IResolvable): any;
export declare function googleDialogflowCxTestCaseTestCaseConversationTurnsToHclTerraform(struct?: GoogleDialogflowCxTestCaseTestCaseConversationTurns | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxTestCaseTestCaseConversationTurnsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxTestCaseTestCaseConversationTurns | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxTestCaseTestCaseConversationTurns | cdktf.IResolvable | undefined);
    private _userInput;
    get userInput(): GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInputOutputReference;
    putUserInput(value: GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInput): void;
    resetUserInput(): void;
    get userInputInput(): GoogleDialogflowCxTestCaseTestCaseConversationTurnsUserInput | undefined;
    private _virtualAgentOutput;
    get virtualAgentOutput(): GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutputOutputReference;
    putVirtualAgentOutput(value: GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutput): void;
    resetVirtualAgentOutput(): void;
    get virtualAgentOutputInput(): GoogleDialogflowCxTestCaseTestCaseConversationTurnsVirtualAgentOutput | undefined;
}
export declare class GoogleDialogflowCxTestCaseTestCaseConversationTurnsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxTestCaseTestCaseConversationTurns[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxTestCaseTestCaseConversationTurnsOutputReference;
}
export interface GoogleDialogflowCxTestCaseTestConfig {
    /**
    * Flow name to start the test case with.
    * Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
    * Only one of flow and page should be set to indicate the starting point of the test case. If neither is set, the test case will start with start page on the default start flow.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#flow GoogleDialogflowCxTestCase#flow}
    */
    readonly flow?: string;
    /**
    * The page to start the test case with.
    * Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
    * Only one of flow and page should be set to indicate the starting point of the test case. If neither is set, the test case will start with start page on the default start flow.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#page GoogleDialogflowCxTestCase#page}
    */
    readonly page?: string;
    /**
    * Session parameters to be compared when calculating differences.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#tracking_parameters GoogleDialogflowCxTestCase#tracking_parameters}
    */
    readonly trackingParameters?: string[];
}
export declare function googleDialogflowCxTestCaseTestConfigToTerraform(struct?: GoogleDialogflowCxTestCaseTestConfigOutputReference | GoogleDialogflowCxTestCaseTestConfig): any;
export declare function googleDialogflowCxTestCaseTestConfigToHclTerraform(struct?: GoogleDialogflowCxTestCaseTestConfigOutputReference | GoogleDialogflowCxTestCaseTestConfig): any;
export declare class GoogleDialogflowCxTestCaseTestConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxTestCaseTestConfig | undefined;
    set internalValue(value: GoogleDialogflowCxTestCaseTestConfig | undefined);
    private _flow?;
    get flow(): string;
    set flow(value: string);
    resetFlow(): void;
    get flowInput(): string | undefined;
    private _page?;
    get page(): string;
    set page(value: string);
    resetPage(): void;
    get pageInput(): string | undefined;
    private _trackingParameters?;
    get trackingParameters(): string[];
    set trackingParameters(value: string[]);
    resetTrackingParameters(): void;
    get trackingParametersInput(): string[] | undefined;
}
export interface GoogleDialogflowCxTestCaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#create GoogleDialogflowCxTestCase#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#delete GoogleDialogflowCxTestCase#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#update GoogleDialogflowCxTestCase#update}
    */
    readonly update?: string;
}
export declare function googleDialogflowCxTestCaseTimeoutsToTerraform(struct?: GoogleDialogflowCxTestCaseTimeouts | cdktf.IResolvable): any;
export declare function googleDialogflowCxTestCaseTimeoutsToHclTerraform(struct?: GoogleDialogflowCxTestCaseTimeouts | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxTestCaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxTestCaseTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxTestCaseTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case google_dialogflow_cx_test_case}
*/
export declare class GoogleDialogflowCxTestCase extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dialogflow_cx_test_case";
    /**
    * Generates CDKTF code for importing a GoogleDialogflowCxTestCase resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleDialogflowCxTestCase to import
    * @param importFromId The id of the existing GoogleDialogflowCxTestCase that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleDialogflowCxTestCase to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_test_case google_dialogflow_cx_test_case} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDialogflowCxTestCaseConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDialogflowCxTestCaseConfig);
    get creationTime(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _lastTestResult;
    get lastTestResult(): GoogleDialogflowCxTestCaseLastTestResultList;
    get name(): string;
    private _notes?;
    get notes(): string;
    set notes(value: string);
    resetNotes(): void;
    get notesInput(): string | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    resetParent(): void;
    get parentInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _testCaseConversationTurns;
    get testCaseConversationTurns(): GoogleDialogflowCxTestCaseTestCaseConversationTurnsList;
    putTestCaseConversationTurns(value: GoogleDialogflowCxTestCaseTestCaseConversationTurns[] | cdktf.IResolvable): void;
    resetTestCaseConversationTurns(): void;
    get testCaseConversationTurnsInput(): cdktf.IResolvable | GoogleDialogflowCxTestCaseTestCaseConversationTurns[] | undefined;
    private _testConfig;
    get testConfig(): GoogleDialogflowCxTestCaseTestConfigOutputReference;
    putTestConfig(value: GoogleDialogflowCxTestCaseTestConfig): void;
    resetTestConfig(): void;
    get testConfigInput(): GoogleDialogflowCxTestCaseTestConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleDialogflowCxTestCaseTimeoutsOutputReference;
    putTimeouts(value: GoogleDialogflowCxTestCaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDialogflowCxTestCaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
