/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDialogflowCxWebhookConfig extends cdktf.TerraformMetaArguments {
    /**
    * Indicates whether the webhook is disabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_webhook#disabled GoogleDialogflowCxWebhook#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * The human-readable name of the webhook, unique within the agent.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_webhook#display_name GoogleDialogflowCxWebhook#display_name}
    */
    readonly displayName: string;
    /**
    * Indicates if automatic spell correction is enabled in detect intent requests.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_webhook#enable_spell_correction GoogleDialogflowCxWebhook#enable_spell_correction}
    */
    readonly enableSpellCorrection?: boolean | cdktf.IResolvable;
    /**
    * Determines whether this agent should log conversation queries.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_webhook#enable_stackdriver_logging GoogleDialogflowCxWebhook#enable_stackdriver_logging}
    */
    readonly enableStackdriverLogging?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_webhook#id GoogleDialogflowCxWebhook#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The agent to create a webhook for.
    * Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_webhook#parent GoogleDialogflowCxWebhook#parent}
    */
    readonly parent?: string;
    /**
    * Name of the SecuritySettings reference for the agent. Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_webhook#security_settings GoogleDialogflowCxWebhook#security_settings}
    */
    readonly securitySettings?: string;
    /**
    * Webhook execution timeout.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_webhook#timeout GoogleDialogflowCxWebhook#timeout}
    */
    readonly timeout?: string;
    /**
    * generic_web_service block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_webhook#generic_web_service GoogleDialogflowCxWebhook#generic_web_service}
    */
    readonly genericWebService?: GoogleDialogflowCxWebhookGenericWebService;
    /**
    * service_directory block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_webhook#service_directory GoogleDialogflowCxWebhook#service_directory}
    */
    readonly serviceDirectory?: GoogleDialogflowCxWebhookServiceDirectory;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_webhook#timeouts GoogleDialogflowCxWebhook#timeouts}
    */
    readonly timeouts?: GoogleDialogflowCxWebhookTimeouts;
}
export interface GoogleDialogflowCxWebhookGenericWebService {
    /**
    * Specifies a list of allowed custom CA certificates (in DER format) for HTTPS verification.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_webhook#allowed_ca_certs GoogleDialogflowCxWebhook#allowed_ca_certs}
    */
    readonly allowedCaCerts?: string[];
    /**
    * The HTTP request headers to send together with webhook requests.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_webhook#request_headers GoogleDialogflowCxWebhook#request_headers}
    */
    readonly requestHeaders?: {
        [key: string]: string;
    };
    /**
    * Whether to use speech adaptation for speech recognition.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_webhook#uri GoogleDialogflowCxWebhook#uri}
    */
    readonly uri: string;
}
export declare function googleDialogflowCxWebhookGenericWebServiceToTerraform(struct?: GoogleDialogflowCxWebhookGenericWebServiceOutputReference | GoogleDialogflowCxWebhookGenericWebService): any;
export declare function googleDialogflowCxWebhookGenericWebServiceToHclTerraform(struct?: GoogleDialogflowCxWebhookGenericWebServiceOutputReference | GoogleDialogflowCxWebhookGenericWebService): any;
export declare class GoogleDialogflowCxWebhookGenericWebServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxWebhookGenericWebService | undefined;
    set internalValue(value: GoogleDialogflowCxWebhookGenericWebService | undefined);
    private _allowedCaCerts?;
    get allowedCaCerts(): string[];
    set allowedCaCerts(value: string[]);
    resetAllowedCaCerts(): void;
    get allowedCaCertsInput(): string[] | undefined;
    private _requestHeaders?;
    get requestHeaders(): {
        [key: string]: string;
    };
    set requestHeaders(value: {
        [key: string]: string;
    });
    resetRequestHeaders(): void;
    get requestHeadersInput(): {
        [key: string]: string;
    } | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export interface GoogleDialogflowCxWebhookServiceDirectoryGenericWebService {
    /**
    * Specifies a list of allowed custom CA certificates (in DER format) for HTTPS verification.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_webhook#allowed_ca_certs GoogleDialogflowCxWebhook#allowed_ca_certs}
    */
    readonly allowedCaCerts?: string[];
    /**
    * The HTTP request headers to send together with webhook requests.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_webhook#request_headers GoogleDialogflowCxWebhook#request_headers}
    */
    readonly requestHeaders?: {
        [key: string]: string;
    };
    /**
    * Whether to use speech adaptation for speech recognition.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_webhook#uri GoogleDialogflowCxWebhook#uri}
    */
    readonly uri: string;
}
export declare function googleDialogflowCxWebhookServiceDirectoryGenericWebServiceToTerraform(struct?: GoogleDialogflowCxWebhookServiceDirectoryGenericWebServiceOutputReference | GoogleDialogflowCxWebhookServiceDirectoryGenericWebService): any;
export declare function googleDialogflowCxWebhookServiceDirectoryGenericWebServiceToHclTerraform(struct?: GoogleDialogflowCxWebhookServiceDirectoryGenericWebServiceOutputReference | GoogleDialogflowCxWebhookServiceDirectoryGenericWebService): any;
export declare class GoogleDialogflowCxWebhookServiceDirectoryGenericWebServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxWebhookServiceDirectoryGenericWebService | undefined;
    set internalValue(value: GoogleDialogflowCxWebhookServiceDirectoryGenericWebService | undefined);
    private _allowedCaCerts?;
    get allowedCaCerts(): string[];
    set allowedCaCerts(value: string[]);
    resetAllowedCaCerts(): void;
    get allowedCaCertsInput(): string[] | undefined;
    private _requestHeaders?;
    get requestHeaders(): {
        [key: string]: string;
    };
    set requestHeaders(value: {
        [key: string]: string;
    });
    resetRequestHeaders(): void;
    get requestHeadersInput(): {
        [key: string]: string;
    } | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export interface GoogleDialogflowCxWebhookServiceDirectory {
    /**
    * The name of Service Directory service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_webhook#service GoogleDialogflowCxWebhook#service}
    */
    readonly service: string;
    /**
    * generic_web_service block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_webhook#generic_web_service GoogleDialogflowCxWebhook#generic_web_service}
    */
    readonly genericWebService: GoogleDialogflowCxWebhookServiceDirectoryGenericWebService;
}
export declare function googleDialogflowCxWebhookServiceDirectoryToTerraform(struct?: GoogleDialogflowCxWebhookServiceDirectoryOutputReference | GoogleDialogflowCxWebhookServiceDirectory): any;
export declare function googleDialogflowCxWebhookServiceDirectoryToHclTerraform(struct?: GoogleDialogflowCxWebhookServiceDirectoryOutputReference | GoogleDialogflowCxWebhookServiceDirectory): any;
export declare class GoogleDialogflowCxWebhookServiceDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxWebhookServiceDirectory | undefined;
    set internalValue(value: GoogleDialogflowCxWebhookServiceDirectory | undefined);
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _genericWebService;
    get genericWebService(): GoogleDialogflowCxWebhookServiceDirectoryGenericWebServiceOutputReference;
    putGenericWebService(value: GoogleDialogflowCxWebhookServiceDirectoryGenericWebService): void;
    get genericWebServiceInput(): GoogleDialogflowCxWebhookServiceDirectoryGenericWebService | undefined;
}
export interface GoogleDialogflowCxWebhookTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_webhook#create GoogleDialogflowCxWebhook#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_webhook#delete GoogleDialogflowCxWebhook#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_webhook#update GoogleDialogflowCxWebhook#update}
    */
    readonly update?: string;
}
export declare function googleDialogflowCxWebhookTimeoutsToTerraform(struct?: GoogleDialogflowCxWebhookTimeouts | cdktf.IResolvable): any;
export declare function googleDialogflowCxWebhookTimeoutsToHclTerraform(struct?: GoogleDialogflowCxWebhookTimeouts | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxWebhookTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxWebhookTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxWebhookTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_webhook google_dialogflow_cx_webhook}
*/
export declare class GoogleDialogflowCxWebhook extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dialogflow_cx_webhook";
    /**
    * Generates CDKTF code for importing a GoogleDialogflowCxWebhook resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleDialogflowCxWebhook to import
    * @param importFromId The id of the existing GoogleDialogflowCxWebhook that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_webhook#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleDialogflowCxWebhook to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_cx_webhook google_dialogflow_cx_webhook} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDialogflowCxWebhookConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDialogflowCxWebhookConfig);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enableSpellCorrection?;
    get enableSpellCorrection(): boolean | cdktf.IResolvable;
    set enableSpellCorrection(value: boolean | cdktf.IResolvable);
    resetEnableSpellCorrection(): void;
    get enableSpellCorrectionInput(): boolean | cdktf.IResolvable | undefined;
    private _enableStackdriverLogging?;
    get enableStackdriverLogging(): boolean | cdktf.IResolvable;
    set enableStackdriverLogging(value: boolean | cdktf.IResolvable);
    resetEnableStackdriverLogging(): void;
    get enableStackdriverLoggingInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    resetParent(): void;
    get parentInput(): string | undefined;
    private _securitySettings?;
    get securitySettings(): string;
    set securitySettings(value: string);
    resetSecuritySettings(): void;
    get securitySettingsInput(): string | undefined;
    get startFlow(): string;
    private _timeout?;
    get timeout(): string;
    set timeout(value: string);
    resetTimeout(): void;
    get timeoutInput(): string | undefined;
    private _genericWebService;
    get genericWebService(): GoogleDialogflowCxWebhookGenericWebServiceOutputReference;
    putGenericWebService(value: GoogleDialogflowCxWebhookGenericWebService): void;
    resetGenericWebService(): void;
    get genericWebServiceInput(): GoogleDialogflowCxWebhookGenericWebService | undefined;
    private _serviceDirectory;
    get serviceDirectory(): GoogleDialogflowCxWebhookServiceDirectoryOutputReference;
    putServiceDirectory(value: GoogleDialogflowCxWebhookServiceDirectory): void;
    resetServiceDirectory(): void;
    get serviceDirectoryInput(): GoogleDialogflowCxWebhookServiceDirectory | undefined;
    private _timeouts;
    get timeouts(): GoogleDialogflowCxWebhookTimeoutsOutputReference;
    putTimeouts(value: GoogleDialogflowCxWebhookTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDialogflowCxWebhookTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
