/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDialogflowFulfillmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The human-readable name of the fulfillment, unique within the agent.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_fulfillment#display_name GoogleDialogflowFulfillment#display_name}
    */
    readonly displayName: string;
    /**
    * Whether fulfillment is enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_fulfillment#enabled GoogleDialogflowFulfillment#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_fulfillment#id GoogleDialogflowFulfillment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_fulfillment#project GoogleDialogflowFulfillment#project}
    */
    readonly project?: string;
    /**
    * features block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_fulfillment#features GoogleDialogflowFulfillment#features}
    */
    readonly features?: GoogleDialogflowFulfillmentFeatures[] | cdktf.IResolvable;
    /**
    * generic_web_service block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_fulfillment#generic_web_service GoogleDialogflowFulfillment#generic_web_service}
    */
    readonly genericWebService?: GoogleDialogflowFulfillmentGenericWebService;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_fulfillment#timeouts GoogleDialogflowFulfillment#timeouts}
    */
    readonly timeouts?: GoogleDialogflowFulfillmentTimeouts;
}
export interface GoogleDialogflowFulfillmentFeatures {
    /**
    * The type of the feature that enabled for fulfillment.
    * * SMALLTALK: Fulfillment is enabled for SmallTalk. Possible values: ["SMALLTALK"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_fulfillment#type GoogleDialogflowFulfillment#type}
    */
    readonly type: string;
}
export declare function googleDialogflowFulfillmentFeaturesToTerraform(struct?: GoogleDialogflowFulfillmentFeatures | cdktf.IResolvable): any;
export declare function googleDialogflowFulfillmentFeaturesToHclTerraform(struct?: GoogleDialogflowFulfillmentFeatures | cdktf.IResolvable): any;
export declare class GoogleDialogflowFulfillmentFeaturesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowFulfillmentFeatures | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowFulfillmentFeatures | cdktf.IResolvable | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class GoogleDialogflowFulfillmentFeaturesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowFulfillmentFeatures[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowFulfillmentFeaturesOutputReference;
}
export interface GoogleDialogflowFulfillmentGenericWebService {
    /**
    * The password for HTTP Basic authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_fulfillment#password GoogleDialogflowFulfillment#password}
    */
    readonly password?: string;
    /**
    * The HTTP request headers to send together with fulfillment requests.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_fulfillment#request_headers GoogleDialogflowFulfillment#request_headers}
    */
    readonly requestHeaders?: {
        [key: string]: string;
    };
    /**
    * The fulfillment URI for receiving POST requests. It must use https protocol.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_fulfillment#uri GoogleDialogflowFulfillment#uri}
    */
    readonly uri: string;
    /**
    * The user name for HTTP Basic authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_fulfillment#username GoogleDialogflowFulfillment#username}
    */
    readonly username?: string;
}
export declare function googleDialogflowFulfillmentGenericWebServiceToTerraform(struct?: GoogleDialogflowFulfillmentGenericWebServiceOutputReference | GoogleDialogflowFulfillmentGenericWebService): any;
export declare function googleDialogflowFulfillmentGenericWebServiceToHclTerraform(struct?: GoogleDialogflowFulfillmentGenericWebServiceOutputReference | GoogleDialogflowFulfillmentGenericWebService): any;
export declare class GoogleDialogflowFulfillmentGenericWebServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowFulfillmentGenericWebService | undefined;
    set internalValue(value: GoogleDialogflowFulfillmentGenericWebService | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _requestHeaders?;
    get requestHeaders(): {
        [key: string]: string;
    };
    set requestHeaders(value: {
        [key: string]: string;
    });
    resetRequestHeaders(): void;
    get requestHeadersInput(): {
        [key: string]: string;
    } | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
}
export interface GoogleDialogflowFulfillmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_fulfillment#create GoogleDialogflowFulfillment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_fulfillment#delete GoogleDialogflowFulfillment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_fulfillment#update GoogleDialogflowFulfillment#update}
    */
    readonly update?: string;
}
export declare function googleDialogflowFulfillmentTimeoutsToTerraform(struct?: GoogleDialogflowFulfillmentTimeouts | cdktf.IResolvable): any;
export declare function googleDialogflowFulfillmentTimeoutsToHclTerraform(struct?: GoogleDialogflowFulfillmentTimeouts | cdktf.IResolvable): any;
export declare class GoogleDialogflowFulfillmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowFulfillmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowFulfillmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_fulfillment google_dialogflow_fulfillment}
*/
export declare class GoogleDialogflowFulfillment extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dialogflow_fulfillment";
    /**
    * Generates CDKTF code for importing a GoogleDialogflowFulfillment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleDialogflowFulfillment to import
    * @param importFromId The id of the existing GoogleDialogflowFulfillment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_fulfillment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleDialogflowFulfillment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_fulfillment google_dialogflow_fulfillment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDialogflowFulfillmentConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDialogflowFulfillmentConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _features;
    get features(): GoogleDialogflowFulfillmentFeaturesList;
    putFeatures(value: GoogleDialogflowFulfillmentFeatures[] | cdktf.IResolvable): void;
    resetFeatures(): void;
    get featuresInput(): cdktf.IResolvable | GoogleDialogflowFulfillmentFeatures[] | undefined;
    private _genericWebService;
    get genericWebService(): GoogleDialogflowFulfillmentGenericWebServiceOutputReference;
    putGenericWebService(value: GoogleDialogflowFulfillmentGenericWebService): void;
    resetGenericWebService(): void;
    get genericWebServiceInput(): GoogleDialogflowFulfillmentGenericWebService | undefined;
    private _timeouts;
    get timeouts(): GoogleDialogflowFulfillmentTimeoutsOutputReference;
    putTimeouts(value: GoogleDialogflowFulfillmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDialogflowFulfillmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
