/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDialogflowIntentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the action associated with the intent.
    * Note: The action name must not contain whitespaces.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_intent#action GoogleDialogflowIntent#action}
    */
    readonly action?: string;
    /**
    * The list of platforms for which the first responses will be copied from the messages in PLATFORM_UNSPECIFIED
    * (i.e. default platform). Possible values: ["FACEBOOK", "SLACK", "TELEGRAM", "KIK", "SKYPE", "LINE", "VIBER", "ACTIONS_ON_GOOGLE", "GOOGLE_HANGOUTS"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_intent#default_response_platforms GoogleDialogflowIntent#default_response_platforms}
    */
    readonly defaultResponsePlatforms?: string[];
    /**
    * The name of this intent to be displayed on the console.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_intent#display_name GoogleDialogflowIntent#display_name}
    */
    readonly displayName: string;
    /**
    * The collection of event names that trigger the intent. If the collection of input contexts is not empty, all of
    * the contexts must be present in the active user session for an event to trigger this intent. See the
    * [events reference](https://cloud.google.com/dialogflow/docs/events-overview) for more details.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_intent#events GoogleDialogflowIntent#events}
    */
    readonly events?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_intent#id GoogleDialogflowIntent#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The list of context names required for this intent to be triggered.
    * Format: projects/<Project ID>/agent/sessions/-/contexts/<Context ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_intent#input_context_names GoogleDialogflowIntent#input_context_names}
    */
    readonly inputContextNames?: string[];
    /**
    * Indicates whether this is a fallback intent.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_intent#is_fallback GoogleDialogflowIntent#is_fallback}
    */
    readonly isFallback?: boolean | cdktf.IResolvable;
    /**
    * Indicates whether Machine Learning is disabled for the intent.
    * Note: If mlDisabled setting is set to true, then this intent is not taken into account during inference in ML
    * ONLY match mode. Also, auto-markup in the UI is turned off.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_intent#ml_disabled GoogleDialogflowIntent#ml_disabled}
    */
    readonly mlDisabled?: boolean | cdktf.IResolvable;
    /**
    * The unique identifier of the parent intent in the chain of followup intents.
    * Format: projects/<Project ID>/agent/intents/<Intent ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_intent#parent_followup_intent_name GoogleDialogflowIntent#parent_followup_intent_name}
    */
    readonly parentFollowupIntentName?: string;
    /**
    * The priority of this intent. Higher numbers represent higher priorities.
    *   - If the supplied value is unspecified or 0, the service translates the value to 500,000, which corresponds
    *   to the Normal priority in the console.
    *   - If the supplied value is negative, the intent is ignored in runtime detect intent requests.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_intent#priority GoogleDialogflowIntent#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_intent#project GoogleDialogflowIntent#project}
    */
    readonly project?: string;
    /**
    * Indicates whether to delete all contexts in the current session when this intent is matched.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_intent#reset_contexts GoogleDialogflowIntent#reset_contexts}
    */
    readonly resetContexts?: boolean | cdktf.IResolvable;
    /**
    * Indicates whether webhooks are enabled for the intent.
    * * WEBHOOK_STATE_ENABLED: Webhook is enabled in the agent and in the intent.
    * * WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING: Webhook is enabled in the agent and in the intent. Also, each slot
    * filling prompt is forwarded to the webhook. Possible values: ["WEBHOOK_STATE_ENABLED", "WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_intent#webhook_state GoogleDialogflowIntent#webhook_state}
    */
    readonly webhookState?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_intent#timeouts GoogleDialogflowIntent#timeouts}
    */
    readonly timeouts?: GoogleDialogflowIntentTimeouts;
}
export interface GoogleDialogflowIntentFollowupIntentInfo {
}
export declare function googleDialogflowIntentFollowupIntentInfoToTerraform(struct?: GoogleDialogflowIntentFollowupIntentInfo): any;
export declare function googleDialogflowIntentFollowupIntentInfoToHclTerraform(struct?: GoogleDialogflowIntentFollowupIntentInfo): any;
export declare class GoogleDialogflowIntentFollowupIntentInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowIntentFollowupIntentInfo | undefined;
    set internalValue(value: GoogleDialogflowIntentFollowupIntentInfo | undefined);
    get followupIntentName(): string;
    get parentFollowupIntentName(): string;
}
export declare class GoogleDialogflowIntentFollowupIntentInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowIntentFollowupIntentInfoOutputReference;
}
export interface GoogleDialogflowIntentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_intent#create GoogleDialogflowIntent#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_intent#delete GoogleDialogflowIntent#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_intent#update GoogleDialogflowIntent#update}
    */
    readonly update?: string;
}
export declare function googleDialogflowIntentTimeoutsToTerraform(struct?: GoogleDialogflowIntentTimeouts | cdktf.IResolvable): any;
export declare function googleDialogflowIntentTimeoutsToHclTerraform(struct?: GoogleDialogflowIntentTimeouts | cdktf.IResolvable): any;
export declare class GoogleDialogflowIntentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowIntentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowIntentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_intent google_dialogflow_intent}
*/
export declare class GoogleDialogflowIntent extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dialogflow_intent";
    /**
    * Generates CDKTF code for importing a GoogleDialogflowIntent resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleDialogflowIntent to import
    * @param importFromId The id of the existing GoogleDialogflowIntent that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_intent#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleDialogflowIntent to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dialogflow_intent google_dialogflow_intent} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDialogflowIntentConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDialogflowIntentConfig);
    private _action?;
    get action(): string;
    set action(value: string);
    resetAction(): void;
    get actionInput(): string | undefined;
    private _defaultResponsePlatforms?;
    get defaultResponsePlatforms(): string[];
    set defaultResponsePlatforms(value: string[]);
    resetDefaultResponsePlatforms(): void;
    get defaultResponsePlatformsInput(): string[] | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _events?;
    get events(): string[];
    set events(value: string[]);
    resetEvents(): void;
    get eventsInput(): string[] | undefined;
    private _followupIntentInfo;
    get followupIntentInfo(): GoogleDialogflowIntentFollowupIntentInfoList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _inputContextNames?;
    get inputContextNames(): string[];
    set inputContextNames(value: string[]);
    resetInputContextNames(): void;
    get inputContextNamesInput(): string[] | undefined;
    private _isFallback?;
    get isFallback(): boolean | cdktf.IResolvable;
    set isFallback(value: boolean | cdktf.IResolvable);
    resetIsFallback(): void;
    get isFallbackInput(): boolean | cdktf.IResolvable | undefined;
    private _mlDisabled?;
    get mlDisabled(): boolean | cdktf.IResolvable;
    set mlDisabled(value: boolean | cdktf.IResolvable);
    resetMlDisabled(): void;
    get mlDisabledInput(): boolean | cdktf.IResolvable | undefined;
    get name(): string;
    private _parentFollowupIntentName?;
    get parentFollowupIntentName(): string;
    set parentFollowupIntentName(value: string);
    resetParentFollowupIntentName(): void;
    get parentFollowupIntentNameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _resetContexts?;
    get resetContexts(): boolean | cdktf.IResolvable;
    set resetContexts(value: boolean | cdktf.IResolvable);
    resetResetContexts(): void;
    get resetContextsInput(): boolean | cdktf.IResolvable | undefined;
    get rootFollowupIntentName(): string;
    private _webhookState?;
    get webhookState(): string;
    set webhookState(value: string);
    resetWebhookState(): void;
    get webhookStateInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleDialogflowIntentTimeoutsOutputReference;
    putTimeouts(value: GoogleDialogflowIntentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDialogflowIntentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
