/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDiscoveryEngineChatEngineConfig extends cdktf.TerraformMetaArguments {
    /**
    * The collection ID.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_chat_engine#collection_id GoogleDiscoveryEngineChatEngine#collection_id}
    */
    readonly collectionId: string;
    /**
    * The data stores associated with this engine. Multiple DataStores in the same Collection can be associated here. All listed DataStores must be 'SOLUTION_TYPE_CHAT'. Adding or removing data stores will force recreation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_chat_engine#data_store_ids GoogleDiscoveryEngineChatEngine#data_store_ids}
    */
    readonly dataStoreIds: string[];
    /**
    * The display name of the engine. Should be human readable. UTF-8 encoded string with limit of 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_chat_engine#display_name GoogleDiscoveryEngineChatEngine#display_name}
    */
    readonly displayName: string;
    /**
    * The ID to use for chat engine.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_chat_engine#engine_id GoogleDiscoveryEngineChatEngine#engine_id}
    */
    readonly engineId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_chat_engine#id GoogleDiscoveryEngineChatEngine#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The industry vertical that the chat engine registers. Vertical on Engine has to match vertical of the DataStore linked to the engine. Default value: "GENERIC" Possible values: ["GENERIC"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_chat_engine#industry_vertical GoogleDiscoveryEngineChatEngine#industry_vertical}
    */
    readonly industryVertical?: string;
    /**
    * Location.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_chat_engine#location GoogleDiscoveryEngineChatEngine#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_chat_engine#project GoogleDiscoveryEngineChatEngine#project}
    */
    readonly project?: string;
    /**
    * chat_engine_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_chat_engine#chat_engine_config GoogleDiscoveryEngineChatEngine#chat_engine_config}
    */
    readonly chatEngineConfig: GoogleDiscoveryEngineChatEngineChatEngineConfig;
    /**
    * common_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_chat_engine#common_config GoogleDiscoveryEngineChatEngine#common_config}
    */
    readonly commonConfig?: GoogleDiscoveryEngineChatEngineCommonConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_chat_engine#timeouts GoogleDiscoveryEngineChatEngine#timeouts}
    */
    readonly timeouts?: GoogleDiscoveryEngineChatEngineTimeouts;
}
export interface GoogleDiscoveryEngineChatEngineChatEngineMetadata {
}
export declare function googleDiscoveryEngineChatEngineChatEngineMetadataToTerraform(struct?: GoogleDiscoveryEngineChatEngineChatEngineMetadata): any;
export declare function googleDiscoveryEngineChatEngineChatEngineMetadataToHclTerraform(struct?: GoogleDiscoveryEngineChatEngineChatEngineMetadata): any;
export declare class GoogleDiscoveryEngineChatEngineChatEngineMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDiscoveryEngineChatEngineChatEngineMetadata | undefined;
    set internalValue(value: GoogleDiscoveryEngineChatEngineChatEngineMetadata | undefined);
    get dialogflowAgent(): string;
}
export declare class GoogleDiscoveryEngineChatEngineChatEngineMetadataList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDiscoveryEngineChatEngineChatEngineMetadataOutputReference;
}
export interface GoogleDiscoveryEngineChatEngineChatEngineConfigAgentCreationConfig {
    /**
    * Name of the company, organization or other entity that the agent represents. Used for knowledge connector LLM prompt and for knowledge search.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_chat_engine#business GoogleDiscoveryEngineChatEngine#business}
    */
    readonly business?: string;
    /**
    * The default language of the agent as a language tag. See [Language Support](https://cloud.google.com/dialogflow/docs/reference/language) for a list of the currently supported language codes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_chat_engine#default_language_code GoogleDiscoveryEngineChatEngine#default_language_code}
    */
    readonly defaultLanguageCode: string;
    /**
    * Agent location for Agent creation, currently supported values: global/us/eu, it needs to be the same region as the Chat Engine.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_chat_engine#location GoogleDiscoveryEngineChatEngine#location}
    */
    readonly location?: string;
    /**
    * The time zone of the agent from the [time zone database](https://www.iana.org/time-zones), e.g., America/New_York, Europe/Paris.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_chat_engine#time_zone GoogleDiscoveryEngineChatEngine#time_zone}
    */
    readonly timeZone: string;
}
export declare function googleDiscoveryEngineChatEngineChatEngineConfigAgentCreationConfigToTerraform(struct?: GoogleDiscoveryEngineChatEngineChatEngineConfigAgentCreationConfigOutputReference | GoogleDiscoveryEngineChatEngineChatEngineConfigAgentCreationConfig): any;
export declare function googleDiscoveryEngineChatEngineChatEngineConfigAgentCreationConfigToHclTerraform(struct?: GoogleDiscoveryEngineChatEngineChatEngineConfigAgentCreationConfigOutputReference | GoogleDiscoveryEngineChatEngineChatEngineConfigAgentCreationConfig): any;
export declare class GoogleDiscoveryEngineChatEngineChatEngineConfigAgentCreationConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDiscoveryEngineChatEngineChatEngineConfigAgentCreationConfig | undefined;
    set internalValue(value: GoogleDiscoveryEngineChatEngineChatEngineConfigAgentCreationConfig | undefined);
    private _business?;
    get business(): string;
    set business(value: string);
    resetBusiness(): void;
    get businessInput(): string | undefined;
    private _defaultLanguageCode?;
    get defaultLanguageCode(): string;
    set defaultLanguageCode(value: string);
    get defaultLanguageCodeInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    get timeZoneInput(): string | undefined;
}
export interface GoogleDiscoveryEngineChatEngineChatEngineConfig {
    /**
    * agent_creation_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_chat_engine#agent_creation_config GoogleDiscoveryEngineChatEngine#agent_creation_config}
    */
    readonly agentCreationConfig: GoogleDiscoveryEngineChatEngineChatEngineConfigAgentCreationConfig;
}
export declare function googleDiscoveryEngineChatEngineChatEngineConfigToTerraform(struct?: GoogleDiscoveryEngineChatEngineChatEngineConfigOutputReference | GoogleDiscoveryEngineChatEngineChatEngineConfig): any;
export declare function googleDiscoveryEngineChatEngineChatEngineConfigToHclTerraform(struct?: GoogleDiscoveryEngineChatEngineChatEngineConfigOutputReference | GoogleDiscoveryEngineChatEngineChatEngineConfig): any;
export declare class GoogleDiscoveryEngineChatEngineChatEngineConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDiscoveryEngineChatEngineChatEngineConfig | undefined;
    set internalValue(value: GoogleDiscoveryEngineChatEngineChatEngineConfig | undefined);
    private _agentCreationConfig;
    get agentCreationConfig(): GoogleDiscoveryEngineChatEngineChatEngineConfigAgentCreationConfigOutputReference;
    putAgentCreationConfig(value: GoogleDiscoveryEngineChatEngineChatEngineConfigAgentCreationConfig): void;
    get agentCreationConfigInput(): GoogleDiscoveryEngineChatEngineChatEngineConfigAgentCreationConfig | undefined;
}
export interface GoogleDiscoveryEngineChatEngineCommonConfig {
    /**
    * The name of the company, business or entity that is associated with the engine. Setting this may help improve LLM related features.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_chat_engine#company_name GoogleDiscoveryEngineChatEngine#company_name}
    */
    readonly companyName?: string;
}
export declare function googleDiscoveryEngineChatEngineCommonConfigToTerraform(struct?: GoogleDiscoveryEngineChatEngineCommonConfigOutputReference | GoogleDiscoveryEngineChatEngineCommonConfig): any;
export declare function googleDiscoveryEngineChatEngineCommonConfigToHclTerraform(struct?: GoogleDiscoveryEngineChatEngineCommonConfigOutputReference | GoogleDiscoveryEngineChatEngineCommonConfig): any;
export declare class GoogleDiscoveryEngineChatEngineCommonConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDiscoveryEngineChatEngineCommonConfig | undefined;
    set internalValue(value: GoogleDiscoveryEngineChatEngineCommonConfig | undefined);
    private _companyName?;
    get companyName(): string;
    set companyName(value: string);
    resetCompanyName(): void;
    get companyNameInput(): string | undefined;
}
export interface GoogleDiscoveryEngineChatEngineTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_chat_engine#create GoogleDiscoveryEngineChatEngine#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_chat_engine#delete GoogleDiscoveryEngineChatEngine#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_chat_engine#update GoogleDiscoveryEngineChatEngine#update}
    */
    readonly update?: string;
}
export declare function googleDiscoveryEngineChatEngineTimeoutsToTerraform(struct?: GoogleDiscoveryEngineChatEngineTimeouts | cdktf.IResolvable): any;
export declare function googleDiscoveryEngineChatEngineTimeoutsToHclTerraform(struct?: GoogleDiscoveryEngineChatEngineTimeouts | cdktf.IResolvable): any;
export declare class GoogleDiscoveryEngineChatEngineTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDiscoveryEngineChatEngineTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDiscoveryEngineChatEngineTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_chat_engine google_discovery_engine_chat_engine}
*/
export declare class GoogleDiscoveryEngineChatEngine extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_discovery_engine_chat_engine";
    /**
    * Generates CDKTF code for importing a GoogleDiscoveryEngineChatEngine resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleDiscoveryEngineChatEngine to import
    * @param importFromId The id of the existing GoogleDiscoveryEngineChatEngine that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_chat_engine#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleDiscoveryEngineChatEngine to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_chat_engine google_discovery_engine_chat_engine} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDiscoveryEngineChatEngineConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDiscoveryEngineChatEngineConfig);
    private _chatEngineMetadata;
    get chatEngineMetadata(): GoogleDiscoveryEngineChatEngineChatEngineMetadataList;
    private _collectionId?;
    get collectionId(): string;
    set collectionId(value: string);
    get collectionIdInput(): string | undefined;
    get createTime(): string;
    private _dataStoreIds?;
    get dataStoreIds(): string[];
    set dataStoreIds(value: string[]);
    get dataStoreIdsInput(): string[] | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _engineId?;
    get engineId(): string;
    set engineId(value: string);
    get engineIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _industryVertical?;
    get industryVertical(): string;
    set industryVertical(value: string);
    resetIndustryVertical(): void;
    get industryVerticalInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get updateTime(): string;
    private _chatEngineConfig;
    get chatEngineConfig(): GoogleDiscoveryEngineChatEngineChatEngineConfigOutputReference;
    putChatEngineConfig(value: GoogleDiscoveryEngineChatEngineChatEngineConfig): void;
    get chatEngineConfigInput(): GoogleDiscoveryEngineChatEngineChatEngineConfig | undefined;
    private _commonConfig;
    get commonConfig(): GoogleDiscoveryEngineChatEngineCommonConfigOutputReference;
    putCommonConfig(value: GoogleDiscoveryEngineChatEngineCommonConfig): void;
    resetCommonConfig(): void;
    get commonConfigInput(): GoogleDiscoveryEngineChatEngineCommonConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleDiscoveryEngineChatEngineTimeoutsOutputReference;
    putTimeouts(value: GoogleDiscoveryEngineChatEngineTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDiscoveryEngineChatEngineTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
