/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDiscoveryEngineDataStoreConfig extends cdktf.TerraformMetaArguments {
    /**
    * The content config of the data store. Possible values: ["NO_CONTENT", "CONTENT_REQUIRED", "PUBLIC_WEBSITE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_data_store#content_config GoogleDiscoveryEngineDataStore#content_config}
    */
    readonly contentConfig: string;
    /**
    * If true, an advanced data store for site search will be created. If the
    * data store is not configured as site search (GENERIC vertical and
    * PUBLIC_WEBSITE contentConfig), this flag will be ignored.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_data_store#create_advanced_site_search GoogleDiscoveryEngineDataStore#create_advanced_site_search}
    */
    readonly createAdvancedSiteSearch?: boolean | cdktf.IResolvable;
    /**
    * The unique id of the data store.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_data_store#data_store_id GoogleDiscoveryEngineDataStore#data_store_id}
    */
    readonly dataStoreId: string;
    /**
    * The display name of the data store. This field must be a UTF-8 encoded
    * string with a length limit of 128 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_data_store#display_name GoogleDiscoveryEngineDataStore#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_data_store#id GoogleDiscoveryEngineDataStore#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The industry vertical that the data store registers. Possible values: ["GENERIC", "MEDIA"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_data_store#industry_vertical GoogleDiscoveryEngineDataStore#industry_vertical}
    */
    readonly industryVertical: string;
    /**
    * The geographic location where the data store should reside. The value can
    * only be one of "global", "us" and "eu".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_data_store#location GoogleDiscoveryEngineDataStore#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_data_store#project GoogleDiscoveryEngineDataStore#project}
    */
    readonly project?: string;
    /**
    * The solutions that the data store enrolls. Possible values: ["SOLUTION_TYPE_RECOMMENDATION", "SOLUTION_TYPE_SEARCH", "SOLUTION_TYPE_CHAT"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_data_store#solution_types GoogleDiscoveryEngineDataStore#solution_types}
    */
    readonly solutionTypes?: string[];
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_data_store#timeouts GoogleDiscoveryEngineDataStore#timeouts}
    */
    readonly timeouts?: GoogleDiscoveryEngineDataStoreTimeouts;
}
export interface GoogleDiscoveryEngineDataStoreTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_data_store#create GoogleDiscoveryEngineDataStore#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_data_store#delete GoogleDiscoveryEngineDataStore#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_data_store#update GoogleDiscoveryEngineDataStore#update}
    */
    readonly update?: string;
}
export declare function googleDiscoveryEngineDataStoreTimeoutsToTerraform(struct?: GoogleDiscoveryEngineDataStoreTimeouts | cdktf.IResolvable): any;
export declare function googleDiscoveryEngineDataStoreTimeoutsToHclTerraform(struct?: GoogleDiscoveryEngineDataStoreTimeouts | cdktf.IResolvable): any;
export declare class GoogleDiscoveryEngineDataStoreTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDiscoveryEngineDataStoreTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDiscoveryEngineDataStoreTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_data_store google_discovery_engine_data_store}
*/
export declare class GoogleDiscoveryEngineDataStore extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_discovery_engine_data_store";
    /**
    * Generates CDKTF code for importing a GoogleDiscoveryEngineDataStore resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleDiscoveryEngineDataStore to import
    * @param importFromId The id of the existing GoogleDiscoveryEngineDataStore that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_data_store#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleDiscoveryEngineDataStore to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_data_store google_discovery_engine_data_store} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDiscoveryEngineDataStoreConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDiscoveryEngineDataStoreConfig);
    private _contentConfig?;
    get contentConfig(): string;
    set contentConfig(value: string);
    get contentConfigInput(): string | undefined;
    private _createAdvancedSiteSearch?;
    get createAdvancedSiteSearch(): boolean | cdktf.IResolvable;
    set createAdvancedSiteSearch(value: boolean | cdktf.IResolvable);
    resetCreateAdvancedSiteSearch(): void;
    get createAdvancedSiteSearchInput(): boolean | cdktf.IResolvable | undefined;
    get createTime(): string;
    private _dataStoreId?;
    get dataStoreId(): string;
    set dataStoreId(value: string);
    get dataStoreIdInput(): string | undefined;
    get defaultSchemaId(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _industryVertical?;
    get industryVertical(): string;
    set industryVertical(value: string);
    get industryVerticalInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _solutionTypes?;
    get solutionTypes(): string[];
    set solutionTypes(value: string[]);
    resetSolutionTypes(): void;
    get solutionTypesInput(): string[] | undefined;
    private _timeouts;
    get timeouts(): GoogleDiscoveryEngineDataStoreTimeoutsOutputReference;
    putTimeouts(value: GoogleDiscoveryEngineDataStoreTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDiscoveryEngineDataStoreTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
