/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDiscoveryEngineSearchEngineConfig extends cdktf.TerraformMetaArguments {
    /**
    * The collection ID.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_search_engine#collection_id GoogleDiscoveryEngineSearchEngine#collection_id}
    */
    readonly collectionId: string;
    /**
    * The data stores associated with this engine. For SOLUTION_TYPE_SEARCH type of engines, they can only associate with at most one data store.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_search_engine#data_store_ids GoogleDiscoveryEngineSearchEngine#data_store_ids}
    */
    readonly dataStoreIds: string[];
    /**
    * Required. The display name of the engine. Should be human readable. UTF-8 encoded string with limit of 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_search_engine#display_name GoogleDiscoveryEngineSearchEngine#display_name}
    */
    readonly displayName: string;
    /**
    * Unique ID to use for Search Engine App.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_search_engine#engine_id GoogleDiscoveryEngineSearchEngine#engine_id}
    */
    readonly engineId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_search_engine#id GoogleDiscoveryEngineSearchEngine#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The industry vertical that the engine registers. The restriction of the Engine industry vertical is based on DataStore: If unspecified, default to GENERIC. Vertical on Engine has to match vertical of the DataStore liniked to the engine. Default value: "GENERIC" Possible values: ["GENERIC", "MEDIA"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_search_engine#industry_vertical GoogleDiscoveryEngineSearchEngine#industry_vertical}
    */
    readonly industryVertical?: string;
    /**
    * Location.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_search_engine#location GoogleDiscoveryEngineSearchEngine#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_search_engine#project GoogleDiscoveryEngineSearchEngine#project}
    */
    readonly project?: string;
    /**
    * common_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_search_engine#common_config GoogleDiscoveryEngineSearchEngine#common_config}
    */
    readonly commonConfig?: GoogleDiscoveryEngineSearchEngineCommonConfig;
    /**
    * search_engine_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_search_engine#search_engine_config GoogleDiscoveryEngineSearchEngine#search_engine_config}
    */
    readonly searchEngineConfig: GoogleDiscoveryEngineSearchEngineSearchEngineConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_search_engine#timeouts GoogleDiscoveryEngineSearchEngine#timeouts}
    */
    readonly timeouts?: GoogleDiscoveryEngineSearchEngineTimeouts;
}
export interface GoogleDiscoveryEngineSearchEngineCommonConfig {
    /**
    * The name of the company, business or entity that is associated with the engine. Setting this may help improve LLM related features.cd
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_search_engine#company_name GoogleDiscoveryEngineSearchEngine#company_name}
    */
    readonly companyName?: string;
}
export declare function googleDiscoveryEngineSearchEngineCommonConfigToTerraform(struct?: GoogleDiscoveryEngineSearchEngineCommonConfigOutputReference | GoogleDiscoveryEngineSearchEngineCommonConfig): any;
export declare function googleDiscoveryEngineSearchEngineCommonConfigToHclTerraform(struct?: GoogleDiscoveryEngineSearchEngineCommonConfigOutputReference | GoogleDiscoveryEngineSearchEngineCommonConfig): any;
export declare class GoogleDiscoveryEngineSearchEngineCommonConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDiscoveryEngineSearchEngineCommonConfig | undefined;
    set internalValue(value: GoogleDiscoveryEngineSearchEngineCommonConfig | undefined);
    private _companyName?;
    get companyName(): string;
    set companyName(value: string);
    resetCompanyName(): void;
    get companyNameInput(): string | undefined;
}
export interface GoogleDiscoveryEngineSearchEngineSearchEngineConfig {
    /**
    * The add-on that this search engine enables. Possible values: ["SEARCH_ADD_ON_LLM"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_search_engine#search_add_ons GoogleDiscoveryEngineSearchEngine#search_add_ons}
    */
    readonly searchAddOns?: string[];
    /**
    * The search feature tier of this engine. Defaults to SearchTier.SEARCH_TIER_STANDARD if not specified. Default value: "SEARCH_TIER_STANDARD" Possible values: ["SEARCH_TIER_STANDARD", "SEARCH_TIER_ENTERPRISE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_search_engine#search_tier GoogleDiscoveryEngineSearchEngine#search_tier}
    */
    readonly searchTier?: string;
}
export declare function googleDiscoveryEngineSearchEngineSearchEngineConfigToTerraform(struct?: GoogleDiscoveryEngineSearchEngineSearchEngineConfigOutputReference | GoogleDiscoveryEngineSearchEngineSearchEngineConfig): any;
export declare function googleDiscoveryEngineSearchEngineSearchEngineConfigToHclTerraform(struct?: GoogleDiscoveryEngineSearchEngineSearchEngineConfigOutputReference | GoogleDiscoveryEngineSearchEngineSearchEngineConfig): any;
export declare class GoogleDiscoveryEngineSearchEngineSearchEngineConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDiscoveryEngineSearchEngineSearchEngineConfig | undefined;
    set internalValue(value: GoogleDiscoveryEngineSearchEngineSearchEngineConfig | undefined);
    private _searchAddOns?;
    get searchAddOns(): string[];
    set searchAddOns(value: string[]);
    resetSearchAddOns(): void;
    get searchAddOnsInput(): string[] | undefined;
    private _searchTier?;
    get searchTier(): string;
    set searchTier(value: string);
    resetSearchTier(): void;
    get searchTierInput(): string | undefined;
}
export interface GoogleDiscoveryEngineSearchEngineTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_search_engine#create GoogleDiscoveryEngineSearchEngine#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_search_engine#delete GoogleDiscoveryEngineSearchEngine#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_search_engine#update GoogleDiscoveryEngineSearchEngine#update}
    */
    readonly update?: string;
}
export declare function googleDiscoveryEngineSearchEngineTimeoutsToTerraform(struct?: GoogleDiscoveryEngineSearchEngineTimeouts | cdktf.IResolvable): any;
export declare function googleDiscoveryEngineSearchEngineTimeoutsToHclTerraform(struct?: GoogleDiscoveryEngineSearchEngineTimeouts | cdktf.IResolvable): any;
export declare class GoogleDiscoveryEngineSearchEngineTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDiscoveryEngineSearchEngineTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDiscoveryEngineSearchEngineTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_search_engine google_discovery_engine_search_engine}
*/
export declare class GoogleDiscoveryEngineSearchEngine extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_discovery_engine_search_engine";
    /**
    * Generates CDKTF code for importing a GoogleDiscoveryEngineSearchEngine resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleDiscoveryEngineSearchEngine to import
    * @param importFromId The id of the existing GoogleDiscoveryEngineSearchEngine that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_search_engine#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleDiscoveryEngineSearchEngine to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_discovery_engine_search_engine google_discovery_engine_search_engine} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDiscoveryEngineSearchEngineConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDiscoveryEngineSearchEngineConfig);
    private _collectionId?;
    get collectionId(): string;
    set collectionId(value: string);
    get collectionIdInput(): string | undefined;
    get createTime(): string;
    private _dataStoreIds?;
    get dataStoreIds(): string[];
    set dataStoreIds(value: string[]);
    get dataStoreIdsInput(): string[] | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _engineId?;
    get engineId(): string;
    set engineId(value: string);
    get engineIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _industryVertical?;
    get industryVertical(): string;
    set industryVertical(value: string);
    resetIndustryVertical(): void;
    get industryVerticalInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get updateTime(): string;
    private _commonConfig;
    get commonConfig(): GoogleDiscoveryEngineSearchEngineCommonConfigOutputReference;
    putCommonConfig(value: GoogleDiscoveryEngineSearchEngineCommonConfig): void;
    resetCommonConfig(): void;
    get commonConfigInput(): GoogleDiscoveryEngineSearchEngineCommonConfig | undefined;
    private _searchEngineConfig;
    get searchEngineConfig(): GoogleDiscoveryEngineSearchEngineSearchEngineConfigOutputReference;
    putSearchEngineConfig(value: GoogleDiscoveryEngineSearchEngineSearchEngineConfig): void;
    get searchEngineConfigInput(): GoogleDiscoveryEngineSearchEngineSearchEngineConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleDiscoveryEngineSearchEngineTimeoutsOutputReference;
    putTimeouts(value: GoogleDiscoveryEngineSearchEngineTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDiscoveryEngineSearchEngineTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
