/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDnsResponsePolicyRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Answer this query with a behavior rather than DNS data. Acceptable values are 'behaviorUnspecified', and 'bypassResponsePolicy'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dns_response_policy_rule#behavior GoogleDnsResponsePolicyRule#behavior}
    */
    readonly behavior?: string;
    /**
    * The DNS name (wildcard or exact) to apply this rule to. Must be unique within the Response Policy Rule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dns_response_policy_rule#dns_name GoogleDnsResponsePolicyRule#dns_name}
    */
    readonly dnsName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dns_response_policy_rule#id GoogleDnsResponsePolicyRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dns_response_policy_rule#project GoogleDnsResponsePolicyRule#project}
    */
    readonly project?: string;
    /**
    * Identifies the response policy addressed by this request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dns_response_policy_rule#response_policy GoogleDnsResponsePolicyRule#response_policy}
    */
    readonly responsePolicy: string;
    /**
    * An identifier for this rule. Must be unique with the ResponsePolicy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dns_response_policy_rule#rule_name GoogleDnsResponsePolicyRule#rule_name}
    */
    readonly ruleName: string;
    /**
    * local_data block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dns_response_policy_rule#local_data GoogleDnsResponsePolicyRule#local_data}
    */
    readonly localData?: GoogleDnsResponsePolicyRuleLocalData;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dns_response_policy_rule#timeouts GoogleDnsResponsePolicyRule#timeouts}
    */
    readonly timeouts?: GoogleDnsResponsePolicyRuleTimeouts;
}
export interface GoogleDnsResponsePolicyRuleLocalDataLocalDatas {
    /**
    * For example, www.example.com.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dns_response_policy_rule#name GoogleDnsResponsePolicyRule#name}
    */
    readonly name: string;
    /**
    * As defined in RFC 1035 (section 5) and RFC 1034 (section 3.6.1)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dns_response_policy_rule#rrdatas GoogleDnsResponsePolicyRule#rrdatas}
    */
    readonly rrdatas?: string[];
    /**
    * Number of seconds that this ResourceRecordSet can be cached by
    * resolvers.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dns_response_policy_rule#ttl GoogleDnsResponsePolicyRule#ttl}
    */
    readonly ttl?: number;
    /**
    * One of valid DNS resource types. Possible values: ["A", "AAAA", "CAA", "CNAME", "DNSKEY", "DS", "HTTPS", "IPSECVPNKEY", "MX", "NAPTR", "NS", "PTR", "SOA", "SPF", "SRV", "SSHFP", "SVCB", "TLSA", "TXT"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dns_response_policy_rule#type GoogleDnsResponsePolicyRule#type}
    */
    readonly type: string;
}
export declare function googleDnsResponsePolicyRuleLocalDataLocalDatasToTerraform(struct?: GoogleDnsResponsePolicyRuleLocalDataLocalDatas | cdktf.IResolvable): any;
export declare function googleDnsResponsePolicyRuleLocalDataLocalDatasToHclTerraform(struct?: GoogleDnsResponsePolicyRuleLocalDataLocalDatas | cdktf.IResolvable): any;
export declare class GoogleDnsResponsePolicyRuleLocalDataLocalDatasOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDnsResponsePolicyRuleLocalDataLocalDatas | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDnsResponsePolicyRuleLocalDataLocalDatas | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _rrdatas?;
    get rrdatas(): string[];
    set rrdatas(value: string[]);
    resetRrdatas(): void;
    get rrdatasInput(): string[] | undefined;
    private _ttl?;
    get ttl(): number;
    set ttl(value: number);
    resetTtl(): void;
    get ttlInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class GoogleDnsResponsePolicyRuleLocalDataLocalDatasList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDnsResponsePolicyRuleLocalDataLocalDatas[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDnsResponsePolicyRuleLocalDataLocalDatasOutputReference;
}
export interface GoogleDnsResponsePolicyRuleLocalData {
    /**
    * local_datas block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dns_response_policy_rule#local_datas GoogleDnsResponsePolicyRule#local_datas}
    */
    readonly localDatas: GoogleDnsResponsePolicyRuleLocalDataLocalDatas[] | cdktf.IResolvable;
}
export declare function googleDnsResponsePolicyRuleLocalDataToTerraform(struct?: GoogleDnsResponsePolicyRuleLocalDataOutputReference | GoogleDnsResponsePolicyRuleLocalData): any;
export declare function googleDnsResponsePolicyRuleLocalDataToHclTerraform(struct?: GoogleDnsResponsePolicyRuleLocalDataOutputReference | GoogleDnsResponsePolicyRuleLocalData): any;
export declare class GoogleDnsResponsePolicyRuleLocalDataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDnsResponsePolicyRuleLocalData | undefined;
    set internalValue(value: GoogleDnsResponsePolicyRuleLocalData | undefined);
    private _localDatas;
    get localDatas(): GoogleDnsResponsePolicyRuleLocalDataLocalDatasList;
    putLocalDatas(value: GoogleDnsResponsePolicyRuleLocalDataLocalDatas[] | cdktf.IResolvable): void;
    get localDatasInput(): cdktf.IResolvable | GoogleDnsResponsePolicyRuleLocalDataLocalDatas[] | undefined;
}
export interface GoogleDnsResponsePolicyRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dns_response_policy_rule#create GoogleDnsResponsePolicyRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dns_response_policy_rule#delete GoogleDnsResponsePolicyRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dns_response_policy_rule#update GoogleDnsResponsePolicyRule#update}
    */
    readonly update?: string;
}
export declare function googleDnsResponsePolicyRuleTimeoutsToTerraform(struct?: GoogleDnsResponsePolicyRuleTimeouts | cdktf.IResolvable): any;
export declare function googleDnsResponsePolicyRuleTimeoutsToHclTerraform(struct?: GoogleDnsResponsePolicyRuleTimeouts | cdktf.IResolvable): any;
export declare class GoogleDnsResponsePolicyRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDnsResponsePolicyRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDnsResponsePolicyRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dns_response_policy_rule google_dns_response_policy_rule}
*/
export declare class GoogleDnsResponsePolicyRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dns_response_policy_rule";
    /**
    * Generates CDKTF code for importing a GoogleDnsResponsePolicyRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleDnsResponsePolicyRule to import
    * @param importFromId The id of the existing GoogleDnsResponsePolicyRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dns_response_policy_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleDnsResponsePolicyRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_dns_response_policy_rule google_dns_response_policy_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDnsResponsePolicyRuleConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDnsResponsePolicyRuleConfig);
    private _behavior?;
    get behavior(): string;
    set behavior(value: string);
    resetBehavior(): void;
    get behaviorInput(): string | undefined;
    private _dnsName?;
    get dnsName(): string;
    set dnsName(value: string);
    get dnsNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _responsePolicy?;
    get responsePolicy(): string;
    set responsePolicy(value: string);
    get responsePolicyInput(): string | undefined;
    private _ruleName?;
    get ruleName(): string;
    set ruleName(value: string);
    get ruleNameInput(): string | undefined;
    private _localData;
    get localData(): GoogleDnsResponsePolicyRuleLocalDataOutputReference;
    putLocalData(value: GoogleDnsResponsePolicyRuleLocalData): void;
    resetLocalData(): void;
    get localDataInput(): GoogleDnsResponsePolicyRuleLocalData | undefined;
    private _timeouts;
    get timeouts(): GoogleDnsResponsePolicyRuleTimeoutsOutputReference;
    putTimeouts(value: GoogleDnsResponsePolicyRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDnsResponsePolicyRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
