/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDocumentAiWarehouseLocationConfig extends cdktf.TerraformMetaArguments {
    /**
    * The access control mode for accessing the customer data. Possible values: ["ACL_MODE_DOCUMENT_LEVEL_ACCESS_CONTROL_GCI", "ACL_MODE_DOCUMENT_LEVEL_ACCESS_CONTROL_BYOID", "ACL_MODE_UNIVERSAL_ACCESS"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_document_ai_warehouse_location#access_control_mode GoogleDocumentAiWarehouseLocation#access_control_mode}
    */
    readonly accessControlMode: string;
    /**
    * The type of database used to store customer data. Possible values: ["DB_INFRA_SPANNER", "DB_CLOUD_SQL_POSTGRES"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_document_ai_warehouse_location#database_type GoogleDocumentAiWarehouseLocation#database_type}
    */
    readonly databaseType: string;
    /**
    * The default role for the person who create a document. Possible values: ["DOCUMENT_ADMIN", "DOCUMENT_EDITOR", "DOCUMENT_VIEWER"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_document_ai_warehouse_location#document_creator_default_role GoogleDocumentAiWarehouseLocation#document_creator_default_role}
    */
    readonly documentCreatorDefaultRole?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_document_ai_warehouse_location#id GoogleDocumentAiWarehouseLocation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The KMS key used for CMEK encryption. It is required that
    * the kms key is in the same region as the endpoint. The
    * same key will be used for all provisioned resources, if
    * encryption is available. If the kmsKey is left empty, no
    * encryption will be enforced.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_document_ai_warehouse_location#kms_key GoogleDocumentAiWarehouseLocation#kms_key}
    */
    readonly kmsKey?: string;
    /**
    * The location in which the instance is to be provisioned. It takes the form projects/{projectNumber}/locations/{location}.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_document_ai_warehouse_location#location GoogleDocumentAiWarehouseLocation#location}
    */
    readonly location: string;
    /**
    * The unique identifier of the project.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_document_ai_warehouse_location#project_number GoogleDocumentAiWarehouseLocation#project_number}
    */
    readonly projectNumber: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_document_ai_warehouse_location#timeouts GoogleDocumentAiWarehouseLocation#timeouts}
    */
    readonly timeouts?: GoogleDocumentAiWarehouseLocationTimeouts;
}
export interface GoogleDocumentAiWarehouseLocationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_document_ai_warehouse_location#create GoogleDocumentAiWarehouseLocation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_document_ai_warehouse_location#delete GoogleDocumentAiWarehouseLocation#delete}
    */
    readonly delete?: string;
}
export declare function googleDocumentAiWarehouseLocationTimeoutsToTerraform(struct?: GoogleDocumentAiWarehouseLocationTimeouts | cdktf.IResolvable): any;
export declare function googleDocumentAiWarehouseLocationTimeoutsToHclTerraform(struct?: GoogleDocumentAiWarehouseLocationTimeouts | cdktf.IResolvable): any;
export declare class GoogleDocumentAiWarehouseLocationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDocumentAiWarehouseLocationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDocumentAiWarehouseLocationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_document_ai_warehouse_location google_document_ai_warehouse_location}
*/
export declare class GoogleDocumentAiWarehouseLocation extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_document_ai_warehouse_location";
    /**
    * Generates CDKTF code for importing a GoogleDocumentAiWarehouseLocation resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleDocumentAiWarehouseLocation to import
    * @param importFromId The id of the existing GoogleDocumentAiWarehouseLocation that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_document_ai_warehouse_location#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleDocumentAiWarehouseLocation to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_document_ai_warehouse_location google_document_ai_warehouse_location} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDocumentAiWarehouseLocationConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDocumentAiWarehouseLocationConfig);
    private _accessControlMode?;
    get accessControlMode(): string;
    set accessControlMode(value: string);
    get accessControlModeInput(): string | undefined;
    private _databaseType?;
    get databaseType(): string;
    set databaseType(value: string);
    get databaseTypeInput(): string | undefined;
    private _documentCreatorDefaultRole?;
    get documentCreatorDefaultRole(): string;
    set documentCreatorDefaultRole(value: string);
    resetDocumentCreatorDefaultRole(): void;
    get documentCreatorDefaultRoleInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _projectNumber?;
    get projectNumber(): string;
    set projectNumber(value: string);
    get projectNumberInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleDocumentAiWarehouseLocationTimeoutsOutputReference;
    putTimeouts(value: GoogleDocumentAiWarehouseLocationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDocumentAiWarehouseLocationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
