/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleEdgecontainerClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * The default maximum number of pods per node used if a maximum value is not
    * specified explicitly for a node pool in this cluster. If unspecified, the
    * Kubernetes default value will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#default_max_pods_per_node GoogleEdgecontainerCluster#default_max_pods_per_node}
    */
    readonly defaultMaxPodsPerNode?: number;
    /**
    * Address pools for cluster data plane external load balancing.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#external_load_balancer_ipv4_address_pools GoogleEdgecontainerCluster#external_load_balancer_ipv4_address_pools}
    */
    readonly externalLoadBalancerIpv4AddressPools?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#id GoogleEdgecontainerCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * User-defined labels for the edgecloud cluster.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#labels GoogleEdgecontainerCluster#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location of the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#location GoogleEdgecontainerCluster#location}
    */
    readonly location: string;
    /**
    * The GDCE cluster name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#name GoogleEdgecontainerCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#project GoogleEdgecontainerCluster#project}
    */
    readonly project?: string;
    /**
    * The release channel a cluster is subscribed to. Possible values: ["RELEASE_CHANNEL_UNSPECIFIED", "NONE", "REGULAR"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#release_channel GoogleEdgecontainerCluster#release_channel}
    */
    readonly releaseChannel?: string;
    /**
    * The target cluster version. For example: "1.5.0".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#target_version GoogleEdgecontainerCluster#target_version}
    */
    readonly targetVersion?: string;
    /**
    * authorization block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#authorization GoogleEdgecontainerCluster#authorization}
    */
    readonly authorization: GoogleEdgecontainerClusterAuthorization;
    /**
    * control_plane block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#control_plane GoogleEdgecontainerCluster#control_plane}
    */
    readonly controlPlane?: GoogleEdgecontainerClusterControlPlane;
    /**
    * control_plane_encryption block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#control_plane_encryption GoogleEdgecontainerCluster#control_plane_encryption}
    */
    readonly controlPlaneEncryption?: GoogleEdgecontainerClusterControlPlaneEncryption;
    /**
    * fleet block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#fleet GoogleEdgecontainerCluster#fleet}
    */
    readonly fleet: GoogleEdgecontainerClusterFleet;
    /**
    * maintenance_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#maintenance_policy GoogleEdgecontainerCluster#maintenance_policy}
    */
    readonly maintenancePolicy?: GoogleEdgecontainerClusterMaintenancePolicy;
    /**
    * networking block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#networking GoogleEdgecontainerCluster#networking}
    */
    readonly networking: GoogleEdgecontainerClusterNetworking;
    /**
    * system_addons_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#system_addons_config GoogleEdgecontainerCluster#system_addons_config}
    */
    readonly systemAddonsConfig?: GoogleEdgecontainerClusterSystemAddonsConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#timeouts GoogleEdgecontainerCluster#timeouts}
    */
    readonly timeouts?: GoogleEdgecontainerClusterTimeouts;
}
export interface GoogleEdgecontainerClusterMaintenanceEvents {
}
export declare function googleEdgecontainerClusterMaintenanceEventsToTerraform(struct?: GoogleEdgecontainerClusterMaintenanceEvents): any;
export declare function googleEdgecontainerClusterMaintenanceEventsToHclTerraform(struct?: GoogleEdgecontainerClusterMaintenanceEvents): any;
export declare class GoogleEdgecontainerClusterMaintenanceEventsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleEdgecontainerClusterMaintenanceEvents | undefined;
    set internalValue(value: GoogleEdgecontainerClusterMaintenanceEvents | undefined);
    get createTime(): string;
    get endTime(): string;
    get operation(): string;
    get schedule(): string;
    get startTime(): string;
    get state(): string;
    get targetVersion(): string;
    get type(): string;
    get updateTime(): string;
    get uuid(): string;
}
export declare class GoogleEdgecontainerClusterMaintenanceEventsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleEdgecontainerClusterMaintenanceEventsOutputReference;
}
export interface GoogleEdgecontainerClusterAuthorizationAdminUsers {
    /**
    * An active Google username.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#username GoogleEdgecontainerCluster#username}
    */
    readonly username: string;
}
export declare function googleEdgecontainerClusterAuthorizationAdminUsersToTerraform(struct?: GoogleEdgecontainerClusterAuthorizationAdminUsersOutputReference | GoogleEdgecontainerClusterAuthorizationAdminUsers): any;
export declare function googleEdgecontainerClusterAuthorizationAdminUsersToHclTerraform(struct?: GoogleEdgecontainerClusterAuthorizationAdminUsersOutputReference | GoogleEdgecontainerClusterAuthorizationAdminUsers): any;
export declare class GoogleEdgecontainerClusterAuthorizationAdminUsersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEdgecontainerClusterAuthorizationAdminUsers | undefined;
    set internalValue(value: GoogleEdgecontainerClusterAuthorizationAdminUsers | undefined);
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface GoogleEdgecontainerClusterAuthorization {
    /**
    * admin_users block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#admin_users GoogleEdgecontainerCluster#admin_users}
    */
    readonly adminUsers: GoogleEdgecontainerClusterAuthorizationAdminUsers;
}
export declare function googleEdgecontainerClusterAuthorizationToTerraform(struct?: GoogleEdgecontainerClusterAuthorizationOutputReference | GoogleEdgecontainerClusterAuthorization): any;
export declare function googleEdgecontainerClusterAuthorizationToHclTerraform(struct?: GoogleEdgecontainerClusterAuthorizationOutputReference | GoogleEdgecontainerClusterAuthorization): any;
export declare class GoogleEdgecontainerClusterAuthorizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEdgecontainerClusterAuthorization | undefined;
    set internalValue(value: GoogleEdgecontainerClusterAuthorization | undefined);
    private _adminUsers;
    get adminUsers(): GoogleEdgecontainerClusterAuthorizationAdminUsersOutputReference;
    putAdminUsers(value: GoogleEdgecontainerClusterAuthorizationAdminUsers): void;
    get adminUsersInput(): GoogleEdgecontainerClusterAuthorizationAdminUsers | undefined;
}
export interface GoogleEdgecontainerClusterControlPlaneLocal {
    /**
    * Only machines matching this filter will be allowed to host control
    * plane nodes. The filtering language accepts strings like "name=<name>",
    * and is documented here: [AIP-160](https://google.aip.dev/160).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#machine_filter GoogleEdgecontainerCluster#machine_filter}
    */
    readonly machineFilter?: string;
    /**
    * The number of nodes to serve as replicas of the Control Plane.
    * Only 1 and 3 are supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#node_count GoogleEdgecontainerCluster#node_count}
    */
    readonly nodeCount?: number;
    /**
    * Name of the Google Distributed Cloud Edge zones where this node pool
    * will be created. For example: 'us-central1-edge-customer-a'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#node_location GoogleEdgecontainerCluster#node_location}
    */
    readonly nodeLocation?: string;
    /**
    * Policy configuration about how user applications are deployed. Possible values: ["SHARED_DEPLOYMENT_POLICY_UNSPECIFIED", "ALLOWED", "DISALLOWED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#shared_deployment_policy GoogleEdgecontainerCluster#shared_deployment_policy}
    */
    readonly sharedDeploymentPolicy?: string;
}
export declare function googleEdgecontainerClusterControlPlaneLocalToTerraform(struct?: GoogleEdgecontainerClusterControlPlaneLocalOutputReference | GoogleEdgecontainerClusterControlPlaneLocal): any;
export declare function googleEdgecontainerClusterControlPlaneLocalToHclTerraform(struct?: GoogleEdgecontainerClusterControlPlaneLocalOutputReference | GoogleEdgecontainerClusterControlPlaneLocal): any;
export declare class GoogleEdgecontainerClusterControlPlaneLocalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEdgecontainerClusterControlPlaneLocal | undefined;
    set internalValue(value: GoogleEdgecontainerClusterControlPlaneLocal | undefined);
    private _machineFilter?;
    get machineFilter(): string;
    set machineFilter(value: string);
    resetMachineFilter(): void;
    get machineFilterInput(): string | undefined;
    private _nodeCount?;
    get nodeCount(): number;
    set nodeCount(value: number);
    resetNodeCount(): void;
    get nodeCountInput(): number | undefined;
    private _nodeLocation?;
    get nodeLocation(): string;
    set nodeLocation(value: string);
    resetNodeLocation(): void;
    get nodeLocationInput(): string | undefined;
    private _sharedDeploymentPolicy?;
    get sharedDeploymentPolicy(): string;
    set sharedDeploymentPolicy(value: string);
    resetSharedDeploymentPolicy(): void;
    get sharedDeploymentPolicyInput(): string | undefined;
}
export interface GoogleEdgecontainerClusterControlPlaneRemote {
    /**
    * Name of the Google Distributed Cloud Edge zones where this node pool
    * will be created. For example: 'us-central1-edge-customer-a'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#node_location GoogleEdgecontainerCluster#node_location}
    */
    readonly nodeLocation?: string;
}
export declare function googleEdgecontainerClusterControlPlaneRemoteToTerraform(struct?: GoogleEdgecontainerClusterControlPlaneRemoteOutputReference | GoogleEdgecontainerClusterControlPlaneRemote): any;
export declare function googleEdgecontainerClusterControlPlaneRemoteToHclTerraform(struct?: GoogleEdgecontainerClusterControlPlaneRemoteOutputReference | GoogleEdgecontainerClusterControlPlaneRemote): any;
export declare class GoogleEdgecontainerClusterControlPlaneRemoteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEdgecontainerClusterControlPlaneRemote | undefined;
    set internalValue(value: GoogleEdgecontainerClusterControlPlaneRemote | undefined);
    private _nodeLocation?;
    get nodeLocation(): string;
    set nodeLocation(value: string);
    resetNodeLocation(): void;
    get nodeLocationInput(): string | undefined;
}
export interface GoogleEdgecontainerClusterControlPlane {
    /**
    * local block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#local GoogleEdgecontainerCluster#local}
    */
    readonly local?: GoogleEdgecontainerClusterControlPlaneLocal;
    /**
    * remote block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#remote GoogleEdgecontainerCluster#remote}
    */
    readonly remote?: GoogleEdgecontainerClusterControlPlaneRemote;
}
export declare function googleEdgecontainerClusterControlPlaneToTerraform(struct?: GoogleEdgecontainerClusterControlPlaneOutputReference | GoogleEdgecontainerClusterControlPlane): any;
export declare function googleEdgecontainerClusterControlPlaneToHclTerraform(struct?: GoogleEdgecontainerClusterControlPlaneOutputReference | GoogleEdgecontainerClusterControlPlane): any;
export declare class GoogleEdgecontainerClusterControlPlaneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEdgecontainerClusterControlPlane | undefined;
    set internalValue(value: GoogleEdgecontainerClusterControlPlane | undefined);
    private _local;
    get local(): GoogleEdgecontainerClusterControlPlaneLocalOutputReference;
    putLocal(value: GoogleEdgecontainerClusterControlPlaneLocal): void;
    resetLocal(): void;
    get localInput(): GoogleEdgecontainerClusterControlPlaneLocal | undefined;
    private _remote;
    get remote(): GoogleEdgecontainerClusterControlPlaneRemoteOutputReference;
    putRemote(value: GoogleEdgecontainerClusterControlPlaneRemote): void;
    resetRemote(): void;
    get remoteInput(): GoogleEdgecontainerClusterControlPlaneRemote | undefined;
}
export interface GoogleEdgecontainerClusterControlPlaneEncryptionKmsStatus {
}
export declare function googleEdgecontainerClusterControlPlaneEncryptionKmsStatusToTerraform(struct?: GoogleEdgecontainerClusterControlPlaneEncryptionKmsStatus): any;
export declare function googleEdgecontainerClusterControlPlaneEncryptionKmsStatusToHclTerraform(struct?: GoogleEdgecontainerClusterControlPlaneEncryptionKmsStatus): any;
export declare class GoogleEdgecontainerClusterControlPlaneEncryptionKmsStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleEdgecontainerClusterControlPlaneEncryptionKmsStatus | undefined;
    set internalValue(value: GoogleEdgecontainerClusterControlPlaneEncryptionKmsStatus | undefined);
    get code(): number;
    get message(): string;
}
export declare class GoogleEdgecontainerClusterControlPlaneEncryptionKmsStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleEdgecontainerClusterControlPlaneEncryptionKmsStatusOutputReference;
}
export interface GoogleEdgecontainerClusterControlPlaneEncryption {
    /**
    * The Cloud KMS CryptoKey e.g.
    * projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{cryptoKey}
    * to use for protecting control plane disks. If not specified, a
    * Google-managed key will be used instead.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#kms_key GoogleEdgecontainerCluster#kms_key}
    */
    readonly kmsKey?: string;
}
export declare function googleEdgecontainerClusterControlPlaneEncryptionToTerraform(struct?: GoogleEdgecontainerClusterControlPlaneEncryptionOutputReference | GoogleEdgecontainerClusterControlPlaneEncryption): any;
export declare function googleEdgecontainerClusterControlPlaneEncryptionToHclTerraform(struct?: GoogleEdgecontainerClusterControlPlaneEncryptionOutputReference | GoogleEdgecontainerClusterControlPlaneEncryption): any;
export declare class GoogleEdgecontainerClusterControlPlaneEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEdgecontainerClusterControlPlaneEncryption | undefined;
    set internalValue(value: GoogleEdgecontainerClusterControlPlaneEncryption | undefined);
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
    get kmsKeyActiveVersion(): string;
    get kmsKeyState(): string;
    private _kmsStatus;
    get kmsStatus(): GoogleEdgecontainerClusterControlPlaneEncryptionKmsStatusList;
}
export interface GoogleEdgecontainerClusterFleet {
    /**
    * The name of the Fleet host project where this cluster will be registered.
    * Project names are formatted as
    * 'projects/<project-number>'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#project GoogleEdgecontainerCluster#project}
    */
    readonly project: string;
}
export declare function googleEdgecontainerClusterFleetToTerraform(struct?: GoogleEdgecontainerClusterFleetOutputReference | GoogleEdgecontainerClusterFleet): any;
export declare function googleEdgecontainerClusterFleetToHclTerraform(struct?: GoogleEdgecontainerClusterFleetOutputReference | GoogleEdgecontainerClusterFleet): any;
export declare class GoogleEdgecontainerClusterFleetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEdgecontainerClusterFleet | undefined;
    set internalValue(value: GoogleEdgecontainerClusterFleet | undefined);
    get membership(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
}
export interface GoogleEdgecontainerClusterMaintenancePolicyWindowRecurringWindowWindow {
    /**
    * The time that the window ends. The end time must take place after the
    * start time.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#end_time GoogleEdgecontainerCluster#end_time}
    */
    readonly endTime?: string;
    /**
    * The time that the window first starts.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#start_time GoogleEdgecontainerCluster#start_time}
    */
    readonly startTime?: string;
}
export declare function googleEdgecontainerClusterMaintenancePolicyWindowRecurringWindowWindowToTerraform(struct?: GoogleEdgecontainerClusterMaintenancePolicyWindowRecurringWindowWindowOutputReference | GoogleEdgecontainerClusterMaintenancePolicyWindowRecurringWindowWindow): any;
export declare function googleEdgecontainerClusterMaintenancePolicyWindowRecurringWindowWindowToHclTerraform(struct?: GoogleEdgecontainerClusterMaintenancePolicyWindowRecurringWindowWindowOutputReference | GoogleEdgecontainerClusterMaintenancePolicyWindowRecurringWindowWindow): any;
export declare class GoogleEdgecontainerClusterMaintenancePolicyWindowRecurringWindowWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEdgecontainerClusterMaintenancePolicyWindowRecurringWindowWindow | undefined;
    set internalValue(value: GoogleEdgecontainerClusterMaintenancePolicyWindowRecurringWindowWindow | undefined);
    private _endTime?;
    get endTime(): string;
    set endTime(value: string);
    resetEndTime(): void;
    get endTimeInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
}
export interface GoogleEdgecontainerClusterMaintenancePolicyWindowRecurringWindow {
    /**
    * An RRULE (https://tools.ietf.org/html/rfc5545#section-3.8.5.3) for how
    * this window recurs. They go on for the span of time between the start and
    * end time.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#recurrence GoogleEdgecontainerCluster#recurrence}
    */
    readonly recurrence?: string;
    /**
    * window block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#window GoogleEdgecontainerCluster#window}
    */
    readonly window?: GoogleEdgecontainerClusterMaintenancePolicyWindowRecurringWindowWindow;
}
export declare function googleEdgecontainerClusterMaintenancePolicyWindowRecurringWindowToTerraform(struct?: GoogleEdgecontainerClusterMaintenancePolicyWindowRecurringWindowOutputReference | GoogleEdgecontainerClusterMaintenancePolicyWindowRecurringWindow): any;
export declare function googleEdgecontainerClusterMaintenancePolicyWindowRecurringWindowToHclTerraform(struct?: GoogleEdgecontainerClusterMaintenancePolicyWindowRecurringWindowOutputReference | GoogleEdgecontainerClusterMaintenancePolicyWindowRecurringWindow): any;
export declare class GoogleEdgecontainerClusterMaintenancePolicyWindowRecurringWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEdgecontainerClusterMaintenancePolicyWindowRecurringWindow | undefined;
    set internalValue(value: GoogleEdgecontainerClusterMaintenancePolicyWindowRecurringWindow | undefined);
    private _recurrence?;
    get recurrence(): string;
    set recurrence(value: string);
    resetRecurrence(): void;
    get recurrenceInput(): string | undefined;
    private _window;
    get window(): GoogleEdgecontainerClusterMaintenancePolicyWindowRecurringWindowWindowOutputReference;
    putWindow(value: GoogleEdgecontainerClusterMaintenancePolicyWindowRecurringWindowWindow): void;
    resetWindow(): void;
    get windowInput(): GoogleEdgecontainerClusterMaintenancePolicyWindowRecurringWindowWindow | undefined;
}
export interface GoogleEdgecontainerClusterMaintenancePolicyWindow {
    /**
    * recurring_window block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#recurring_window GoogleEdgecontainerCluster#recurring_window}
    */
    readonly recurringWindow: GoogleEdgecontainerClusterMaintenancePolicyWindowRecurringWindow;
}
export declare function googleEdgecontainerClusterMaintenancePolicyWindowToTerraform(struct?: GoogleEdgecontainerClusterMaintenancePolicyWindowOutputReference | GoogleEdgecontainerClusterMaintenancePolicyWindow): any;
export declare function googleEdgecontainerClusterMaintenancePolicyWindowToHclTerraform(struct?: GoogleEdgecontainerClusterMaintenancePolicyWindowOutputReference | GoogleEdgecontainerClusterMaintenancePolicyWindow): any;
export declare class GoogleEdgecontainerClusterMaintenancePolicyWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEdgecontainerClusterMaintenancePolicyWindow | undefined;
    set internalValue(value: GoogleEdgecontainerClusterMaintenancePolicyWindow | undefined);
    private _recurringWindow;
    get recurringWindow(): GoogleEdgecontainerClusterMaintenancePolicyWindowRecurringWindowOutputReference;
    putRecurringWindow(value: GoogleEdgecontainerClusterMaintenancePolicyWindowRecurringWindow): void;
    get recurringWindowInput(): GoogleEdgecontainerClusterMaintenancePolicyWindowRecurringWindow | undefined;
}
export interface GoogleEdgecontainerClusterMaintenancePolicy {
    /**
    * window block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#window GoogleEdgecontainerCluster#window}
    */
    readonly window: GoogleEdgecontainerClusterMaintenancePolicyWindow;
}
export declare function googleEdgecontainerClusterMaintenancePolicyToTerraform(struct?: GoogleEdgecontainerClusterMaintenancePolicyOutputReference | GoogleEdgecontainerClusterMaintenancePolicy): any;
export declare function googleEdgecontainerClusterMaintenancePolicyToHclTerraform(struct?: GoogleEdgecontainerClusterMaintenancePolicyOutputReference | GoogleEdgecontainerClusterMaintenancePolicy): any;
export declare class GoogleEdgecontainerClusterMaintenancePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEdgecontainerClusterMaintenancePolicy | undefined;
    set internalValue(value: GoogleEdgecontainerClusterMaintenancePolicy | undefined);
    private _window;
    get window(): GoogleEdgecontainerClusterMaintenancePolicyWindowOutputReference;
    putWindow(value: GoogleEdgecontainerClusterMaintenancePolicyWindow): void;
    get windowInput(): GoogleEdgecontainerClusterMaintenancePolicyWindow | undefined;
}
export interface GoogleEdgecontainerClusterNetworking {
    /**
    * All pods in the cluster are assigned an RFC1918 IPv4 address from these
    * blocks. Only a single block is supported. This field cannot be changed
    * after creation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#cluster_ipv4_cidr_blocks GoogleEdgecontainerCluster#cluster_ipv4_cidr_blocks}
    */
    readonly clusterIpv4CidrBlocks: string[];
    /**
    * If specified, dual stack mode is enabled and all pods in the cluster are
    * assigned an IPv6 address from these blocks alongside from an IPv4
    * address. Only a single block is supported. This field cannot be changed
    * after creation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#cluster_ipv6_cidr_blocks GoogleEdgecontainerCluster#cluster_ipv6_cidr_blocks}
    */
    readonly clusterIpv6CidrBlocks?: string[];
    /**
    * All services in the cluster are assigned an RFC1918 IPv4 address from these
    * blocks. Only a single block is supported. This field cannot be changed
    * after creation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#services_ipv4_cidr_blocks GoogleEdgecontainerCluster#services_ipv4_cidr_blocks}
    */
    readonly servicesIpv4CidrBlocks: string[];
    /**
    * If specified, dual stack mode is enabled and all services in the cluster are
    * assigned an IPv6 address from these blocks alongside from an IPv4
    * address. Only a single block is supported. This field cannot be changed
    * after creation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#services_ipv6_cidr_blocks GoogleEdgecontainerCluster#services_ipv6_cidr_blocks}
    */
    readonly servicesIpv6CidrBlocks?: string[];
}
export declare function googleEdgecontainerClusterNetworkingToTerraform(struct?: GoogleEdgecontainerClusterNetworkingOutputReference | GoogleEdgecontainerClusterNetworking): any;
export declare function googleEdgecontainerClusterNetworkingToHclTerraform(struct?: GoogleEdgecontainerClusterNetworkingOutputReference | GoogleEdgecontainerClusterNetworking): any;
export declare class GoogleEdgecontainerClusterNetworkingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEdgecontainerClusterNetworking | undefined;
    set internalValue(value: GoogleEdgecontainerClusterNetworking | undefined);
    private _clusterIpv4CidrBlocks?;
    get clusterIpv4CidrBlocks(): string[];
    set clusterIpv4CidrBlocks(value: string[]);
    get clusterIpv4CidrBlocksInput(): string[] | undefined;
    private _clusterIpv6CidrBlocks?;
    get clusterIpv6CidrBlocks(): string[];
    set clusterIpv6CidrBlocks(value: string[]);
    resetClusterIpv6CidrBlocks(): void;
    get clusterIpv6CidrBlocksInput(): string[] | undefined;
    get networkType(): string;
    private _servicesIpv4CidrBlocks?;
    get servicesIpv4CidrBlocks(): string[];
    set servicesIpv4CidrBlocks(value: string[]);
    get servicesIpv4CidrBlocksInput(): string[] | undefined;
    private _servicesIpv6CidrBlocks?;
    get servicesIpv6CidrBlocks(): string[];
    set servicesIpv6CidrBlocks(value: string[]);
    resetServicesIpv6CidrBlocks(): void;
    get servicesIpv6CidrBlocksInput(): string[] | undefined;
}
export interface GoogleEdgecontainerClusterSystemAddonsConfigIngress {
    /**
    * Whether Ingress is disabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#disabled GoogleEdgecontainerCluster#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * Ingress VIP.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#ipv4_vip GoogleEdgecontainerCluster#ipv4_vip}
    */
    readonly ipv4Vip?: string;
}
export declare function googleEdgecontainerClusterSystemAddonsConfigIngressToTerraform(struct?: GoogleEdgecontainerClusterSystemAddonsConfigIngressOutputReference | GoogleEdgecontainerClusterSystemAddonsConfigIngress): any;
export declare function googleEdgecontainerClusterSystemAddonsConfigIngressToHclTerraform(struct?: GoogleEdgecontainerClusterSystemAddonsConfigIngressOutputReference | GoogleEdgecontainerClusterSystemAddonsConfigIngress): any;
export declare class GoogleEdgecontainerClusterSystemAddonsConfigIngressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEdgecontainerClusterSystemAddonsConfigIngress | undefined;
    set internalValue(value: GoogleEdgecontainerClusterSystemAddonsConfigIngress | undefined);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ipv4Vip?;
    get ipv4Vip(): string;
    set ipv4Vip(value: string);
    resetIpv4Vip(): void;
    get ipv4VipInput(): string | undefined;
}
export interface GoogleEdgecontainerClusterSystemAddonsConfig {
    /**
    * ingress block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#ingress GoogleEdgecontainerCluster#ingress}
    */
    readonly ingress?: GoogleEdgecontainerClusterSystemAddonsConfigIngress;
}
export declare function googleEdgecontainerClusterSystemAddonsConfigToTerraform(struct?: GoogleEdgecontainerClusterSystemAddonsConfigOutputReference | GoogleEdgecontainerClusterSystemAddonsConfig): any;
export declare function googleEdgecontainerClusterSystemAddonsConfigToHclTerraform(struct?: GoogleEdgecontainerClusterSystemAddonsConfigOutputReference | GoogleEdgecontainerClusterSystemAddonsConfig): any;
export declare class GoogleEdgecontainerClusterSystemAddonsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEdgecontainerClusterSystemAddonsConfig | undefined;
    set internalValue(value: GoogleEdgecontainerClusterSystemAddonsConfig | undefined);
    private _ingress;
    get ingress(): GoogleEdgecontainerClusterSystemAddonsConfigIngressOutputReference;
    putIngress(value: GoogleEdgecontainerClusterSystemAddonsConfigIngress): void;
    resetIngress(): void;
    get ingressInput(): GoogleEdgecontainerClusterSystemAddonsConfigIngress | undefined;
}
export interface GoogleEdgecontainerClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#create GoogleEdgecontainerCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#delete GoogleEdgecontainerCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#update GoogleEdgecontainerCluster#update}
    */
    readonly update?: string;
}
export declare function googleEdgecontainerClusterTimeoutsToTerraform(struct?: GoogleEdgecontainerClusterTimeouts | cdktf.IResolvable): any;
export declare function googleEdgecontainerClusterTimeoutsToHclTerraform(struct?: GoogleEdgecontainerClusterTimeouts | cdktf.IResolvable): any;
export declare class GoogleEdgecontainerClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEdgecontainerClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleEdgecontainerClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster google_edgecontainer_cluster}
*/
export declare class GoogleEdgecontainerCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_edgecontainer_cluster";
    /**
    * Generates CDKTF code for importing a GoogleEdgecontainerCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleEdgecontainerCluster to import
    * @param importFromId The id of the existing GoogleEdgecontainerCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleEdgecontainerCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_cluster google_edgecontainer_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleEdgecontainerClusterConfig
    */
    constructor(scope: Construct, id: string, config: GoogleEdgecontainerClusterConfig);
    get clusterCaCertificate(): string;
    get controlPlaneVersion(): string;
    get createTime(): string;
    private _defaultMaxPodsPerNode?;
    get defaultMaxPodsPerNode(): number;
    set defaultMaxPodsPerNode(value: number);
    resetDefaultMaxPodsPerNode(): void;
    get defaultMaxPodsPerNodeInput(): number | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get endpoint(): string;
    private _externalLoadBalancerIpv4AddressPools?;
    get externalLoadBalancerIpv4AddressPools(): string[];
    set externalLoadBalancerIpv4AddressPools(value: string[]);
    resetExternalLoadBalancerIpv4AddressPools(): void;
    get externalLoadBalancerIpv4AddressPoolsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _maintenanceEvents;
    get maintenanceEvents(): GoogleEdgecontainerClusterMaintenanceEventsList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get nodeVersion(): string;
    get port(): number;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _releaseChannel?;
    get releaseChannel(): string;
    set releaseChannel(value: string);
    resetReleaseChannel(): void;
    get releaseChannelInput(): string | undefined;
    get status(): string;
    private _targetVersion?;
    get targetVersion(): string;
    set targetVersion(value: string);
    resetTargetVersion(): void;
    get targetVersionInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get updateTime(): string;
    private _authorization;
    get authorization(): GoogleEdgecontainerClusterAuthorizationOutputReference;
    putAuthorization(value: GoogleEdgecontainerClusterAuthorization): void;
    get authorizationInput(): GoogleEdgecontainerClusterAuthorization | undefined;
    private _controlPlane;
    get controlPlane(): GoogleEdgecontainerClusterControlPlaneOutputReference;
    putControlPlane(value: GoogleEdgecontainerClusterControlPlane): void;
    resetControlPlane(): void;
    get controlPlaneInput(): GoogleEdgecontainerClusterControlPlane | undefined;
    private _controlPlaneEncryption;
    get controlPlaneEncryption(): GoogleEdgecontainerClusterControlPlaneEncryptionOutputReference;
    putControlPlaneEncryption(value: GoogleEdgecontainerClusterControlPlaneEncryption): void;
    resetControlPlaneEncryption(): void;
    get controlPlaneEncryptionInput(): GoogleEdgecontainerClusterControlPlaneEncryption | undefined;
    private _fleet;
    get fleet(): GoogleEdgecontainerClusterFleetOutputReference;
    putFleet(value: GoogleEdgecontainerClusterFleet): void;
    get fleetInput(): GoogleEdgecontainerClusterFleet | undefined;
    private _maintenancePolicy;
    get maintenancePolicy(): GoogleEdgecontainerClusterMaintenancePolicyOutputReference;
    putMaintenancePolicy(value: GoogleEdgecontainerClusterMaintenancePolicy): void;
    resetMaintenancePolicy(): void;
    get maintenancePolicyInput(): GoogleEdgecontainerClusterMaintenancePolicy | undefined;
    private _networking;
    get networking(): GoogleEdgecontainerClusterNetworkingOutputReference;
    putNetworking(value: GoogleEdgecontainerClusterNetworking): void;
    get networkingInput(): GoogleEdgecontainerClusterNetworking | undefined;
    private _systemAddonsConfig;
    get systemAddonsConfig(): GoogleEdgecontainerClusterSystemAddonsConfigOutputReference;
    putSystemAddonsConfig(value: GoogleEdgecontainerClusterSystemAddonsConfig): void;
    resetSystemAddonsConfig(): void;
    get systemAddonsConfigInput(): GoogleEdgecontainerClusterSystemAddonsConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleEdgecontainerClusterTimeoutsOutputReference;
    putTimeouts(value: GoogleEdgecontainerClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleEdgecontainerClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
